/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

#include <drv_types.h>
#include <hal_data.h>	/* HAL_DATA_TYPE */

#if (RTW_FPGA_VERIFICATION==1)

void ex_rtw_fpga_set_rftype_id(PADAPTER adapter)
{
    HAL_DATA_TYPE	*pHalData = GET_HAL_DATA(adapter);
	pHalData->rf_chip = RF_PSEUDO_11N;
}

bool ex_rw_fpga_skip_set_chn_bw(unsigned char channel, unsigned char channel_offset, unsigned short bwmode)
{
    
    RTW_INFO("\n[%s] ch = %d, offset = %d, bwmode = %d\n\n", __FUNCTION__, channel, channel_offset, bwmode);
    return _TRUE;
}

bool ex_rtw_fpga_skip_check_fw_ractrl(PADAPTER adapter)
{
	/* During the FPGA veification, this check has to be skipped or fix_rate fails because there is no fw in this stage. */
    return (adapter->fix_rate != 0xFF)?_TRUE:_FALSE;
}


bool ex_rtw_fpga_skip_read_efuse(PADAPTER adapter)
{
    PHAL_DATA_TYPE hal;

	hal = GET_HAL_DATA(adapter);
    hal->bautoload_fail_flag = TRUE;
    
    RTW_INFO("\n[%s] ======> \n\n", __FUNCTION__);
    return _TRUE;
}

bool ex_rtw_fpga_skip_load_tx_power(PADAPTER adapter)
{
    RTW_INFO("\n[%s] ======> \n\n", __FUNCTION__);
    return _TRUE;
}

void ex_rtw_fpga_dump_current_function(PADAPTER adapter,const char * func)
{
    RTW_INFO("\n[%s] : %s ======> \n\n", __FUNCTION__, func);
}


#define DUMP_RX_REPORT TRUE
void ex_rtw_fpga_dump_rx_report(PADAPTER adapter, const char * ic_type, struct rx_pkt_attrib *a, u8 *rx_buf)
{
    u8 *rx_payload = rx_buf + RXDESC_SIZE + (a->drvinfo_sz);

   /*  RTW_INFO("\n[%s] drvinfo_sz(%x), ppdu_cnt(%u), sub-type(%x) \n", __FUNCTION__, a->drvinfo_sz, a->ppdu_cnt, ( rx_payload[0] & 0xFC)); */
   /* _RTW_DBG_DUMP("rx pkt\n", rx_buf, RXDESC_SIZE + (a->drvinfo_sz) +  20);	 */
   /* _RTW_DBG_DUMP("rx pkt-p\n", rx_payload, 20); */

   if(!DUMP_RX_REPORT)
	   return;

    if(a->amsdu)
    {
        RTW_INFO("\n[%s_RX] AMSDU Pkt \n", ic_type);
    }

    if( a->crc_err | a->icv_err )
    {
        RTW_INFO("\n[%s_RX] RxERR: CRC(%u), ICVERR(%u)\n", ic_type, a->crc_err, a->icv_err);
    }

    if( a->ppdu_cnt != adapter->PPDUCnt_index)
    {
        if( adapter->PPDUCnt[adapter->PPDUCnt_index] > 0 )
        {
            RTW_INFO("\n[%s_RX] UP(%u) Last PPDUCnt = %u\n", ic_type, 
                adapter->LastPPDU_AC, adapter->PPDUCnt[adapter->PPDUCnt_index]);
        }

        adapter->PPDUCnt[adapter->PPDUCnt_index] = 0;
        adapter->PPDUCnt_index = a->ppdu_cnt;
    }

	switch( rx_payload[0] & 0xFC)
	{			
		case WIFI_ACK:
			{
                    RTW_INFO("\n[%s_RX] OnAck\n", ic_type);
			}
			break;

		case WIFI_DATA_NULL:  /* 0x48 */
			{
				u16	SeqN	= a->seq_num; 
				
				if(GetRetry(rx_payload)){
                    RTW_INFO("\n[%s_RX] OnNullPkt, NullSeq(%u), nRetryCount(%u)\n", ic_type, SeqN, adapter->nRetryCount);
				}else{
                    RTW_INFO("\n[%s_RX] OnNullPkt, NullSeq(%u)\n", ic_type, SeqN);
				}
             }    
			break;

		case WIFI_PROBERSP: /* 0x50 */
			{
				u16	SeqN	= a->seq_num; 
			
                		RTW_INFO("\n[%s_RX] OnProbeRsp(%u)\n", ic_type, SeqN);
				
#ifdef TEST_TSF_PROBE
				u8	u1bZeroReg0x1500	= PlatformEFIORead1Byte(Adapter, REG_PORT_CTRL_SEL_8814B) & (~(BIT4|BIT5|BIT6));
				u16	i					= 0;
				u32	u4tmp_h 			= 0;
				u32	u4tmp_l 			= 0;
				u64	u8PortTSF			= 0;
				u8 *pTimestamp			= ((u8 *)(&pdu[24]));
				u64	Timestamp			= (*(u8 *)(pTimestamp));
				
				PlatformEFIOWrite1Byte(Adapter, REG_PORT_CTRL_SEL_8814B, u1bZeroReg0x1500);
				u4tmp_h = PlatformEFIORead4Byte(Adapter, REG_TSFTR_HIGH_8814B);
				u4tmp_l = PlatformEFIORead4Byte(Adapter, REG_TSFTR_LOW_8814B);
				u8PortTSF |= u4tmp_h;
				u8PortTSF = (u8PortTSF<<32) | u4tmp_l;

				RT_TRACE(COMP_INIT, DBG_LOUD, ("[8814B_TSF] %s(): STA Port0 TSF DEC(%llu)\n", __FUNCTION__, u8PortTSF));

				RT_TRACE(COMP_INIT, DBG_LOUD, ("[8814B_TSF] %s(): ProbeRsp Timestamp EACH - (%#x %#x %#x %#x) (%#x %#x %#x %#x)\n", 
					__FUNCTION__,
					pTimestamp[7], pTimestamp[6],
					pTimestamp[5], pTimestamp[4],
					pTimestamp[3], pTimestamp[2],
					pTimestamp[1], pTimestamp[0]));
				RT_TRACE(COMP_INIT, DBG_LOUD, ("[8814B_TSF] %s(): ProbeRsp Timestamp HEX(0x%x%x)\n", __FUNCTION__, (u32)(Timestamp>>32), (u32)(Timestamp&0xffffffff)));
				RT_TRACE(COMP_INIT, DBG_LOUD, ("[8814B_TSF] %s(): ProbeRsp Timestamp DEC(%llu)\n", __FUNCTION__, Timestamp));
#endif				
			}
			break;

		case WIFI_BA:	/* 0x94 */
			{
				u64	BitMap		= (*((u64*)(&rx_payload[20])));
				u16	StartSeqN	= (*((u16*)(&rx_payload[18]))) >> 4;					
				u16	New_NextSeq = 0;
				u16	New_nDiff	= 0;
				u16	NextSeq 	= 0;
				u16	nDiff		= 0;

                /* start seq. of current BA is rotated when rx end lost to many pkts */
				if(adapter->LastBA_StartBA > StartSeqN)
				{
					++adapter->nRxSeqRotate_BE;
                    RTW_INFO("[%s_RX]  %u -> %u, nRxRotate(%u)\n", ic_type, adapter->LastBA_StartBA, StartSeqN, adapter->nRxSeqRotate_BE);
#ifdef CATC_TRIGGER
					if( StartSeqN > 100)
					{
					    rtw_read8(adapter, 0x3368);
					}
#endif
				}

                RTW_INFO("[%s_RX] OnBlockAck Report: Start SeqN # = %u\n", ic_type, StartSeqN);
                RTW_INFO("[%s_RX] BitMap = %llx\n", ic_type, BitMap);

				{
					BOOLEAN nowBA[64] = {0};
					BOOLEAN FindFir 		= FALSE;
					u16	Index_LastBA	= 0;
					u8	i				= 0;
					u64	cpBitMap		= BitMap; 

                    //_rtw_memset(nowBA, 0, 64);

                    RTW_INFO("[%s_RX] LastBA_StartBA(%u)\n", ic_type, adapter->LastBA_StartBA);

					for( i=0, FindFir=FALSE, New_nDiff=0 ; i<64 ; ++i, cpBitMap=cpBitMap>>1 )
					{
						Index_LastBA = (StartSeqN+i+0x1000-adapter->LastBA_StartBA) % 0x1000;

						if( cpBitMap & BIT0 )
						{
							nowBA[i] = TRUE;
							
							if( Index_LastBA < 64 )
							{
								if( adapter->LastBA[Index_LastBA] == FALSE )
									++New_nDiff;
							}
							else
							{
								++New_nDiff;
							}					
						}
						else
						{
							nowBA[i] = FALSE;

                            /* First missing pkt is the first seq. of next BA */
							if( FindFir == FALSE )
							{
								New_NextSeq = (StartSeqN+i+0x1000) % 0x1000;
								FindFir = TRUE;
							}
						}							
					}

                    _rtw_memmove(adapter->LastBA, nowBA, 64);
					adapter->LastBA_StartBA = StartSeqN;

					if( FindFir==FALSE )
						New_NextSeq = (StartSeqN+i+0x1000) % 0x1000;						
				}

				if( (adapter->LastNextSeqReportByBA+0x1000-StartSeqN)%0x1000 <= 64 )
				{
				    RTW_INFO("[%s_RX] OnBlockAck Report: Next SeqN # = %u\n", ic_type, New_NextSeq);
				    RTW_INFO("[%s_RX] OnBlockAck Report: New_nDiff # = %u\n", ic_type, New_nDiff);
				}
				else
				{
				    RTW_INFO("[%s_RX] Some PKTs not being Acked.\n", ic_type);
				    RTW_WARN("[%s_RX] OnBlockAck Report: Next SeqN # = %u \n", ic_type, New_NextSeq);
				    RTW_WARN("[%s_RX] OnBlockAck Report: Diff SeqN # = %u \n", ic_type, New_nDiff);
				}

				adapter->LastNextSeqReportByBA = New_NextSeq;
				
			}
			break;

		case WIFI_QOS_DATA_TYPE:
			{
				u16	SeqN 	= (*((u16*)(&rx_payload[22]))) >> 4;
				u8	UP		= (*((u16*)(&rx_payload[24]))) & 0xF;
				
				++adapter->PPDUCnt[adapter->PPDUCnt_index];

				adapter->LastPPDU_AC = UP;

				if(GetRetry(rx_payload))
				{						
					++(adapter->nRetryCount);
					++(adapter->nRetryCountPerRotate_BE);
				    RTW_INFO("[%s_RX] UP(%u) RxSeqN = %u, nRetryCount = %u\n", ic_type, UP, SeqN, adapter->nRetryCount);
				}
				else
				{
				    RTW_INFO("[%s_RX] UP(%u) RxSeqN = %u\n", ic_type, UP, SeqN);
				}

				
#ifdef TEST_TSF_PING
				{
					u16	length	= pRfd->PacketLength;

//					if( length > 0 )
//						RT_PRINT_DATA(COMP_INIT, DBG_LOUD, "QoSData\n", pdu, length);
					
					if( IsDataFrame(pdu) && length>90 )
					{
						if( pdu[43] == 0x1 )
						{
							if( pdu[54]==0 || pdu[54]==0x8 )
							{
								u8	u1bZeroReg0x1500	= PlatformEFIORead1Byte(Adapter, REG_PORT_CTRL_SEL_8814B) & (~(BIT4|BIT5|BIT6));
								u32	u4tmp_h 			= 0;
								u32	u4tmp_l 			= 0;
								u64	u8PortTSF			= 0;
								char* str = (pdu[54]==0) ? "Reply" : "Request";
								
								PlatformEFIOWrite1Byte(Adapter, REG_PORT_CTRL_SEL_8814B, u1bZeroReg0x1500);
								u4tmp_h = PlatformEFIORead4Byte(Adapter, REG_TSFTR_HIGH_8814B);
								u4tmp_l = PlatformEFIORead4Byte(Adapter, REG_TSFTR_LOW_8814B);
								u8PortTSF |= u4tmp_h;
								u8PortTSF = (u8PortTSF<<32) | u4tmp_l;

								Adapter->u8b_TSF_of_Ping_Recv = u8PortTSF;

								if(pdu[54]==0)
									Adapter->SendPingReply = TRUE;

//								RT_PRINT_DATA(COMP_INIT, DBG_LOUD, "QoSData\n", pdu, length);
//								RT_TRACE(COMP_INIT, DBG_WARNING, ("[8814B_PING] %s(): TSF(%llu), Ping %s(%u)\n", __FUNCTION__, u8PortTSF, str, SeqN));
							}
						}
					}

				}
#endif
			}
			break;
			
		case WIFI_DATA:
			{
				u16	SeqN = (*((u16*)(&rx_payload[22]))) >> 4;

				++adapter->PPDUCnt[adapter->PPDUCnt_index];

				if(GetRetry(rx_payload))
				{						
					++(adapter->nRetryCount);
					++(adapter->nRetryCountPerRotate_BE);
				    RTW_INFO("\n[%s_RX] RxSeqN = %u, nRetryCount = %u\n", ic_type, SeqN, adapter->nRetryCount);
				}
				else
				{
				    RTW_INFO("\n[%s_RX] RxSeqN = %u\n", ic_type, SeqN);
				}
			}
			break;

		case WIFI_BEACON:
			{
#if 0
				u1Byte	u1bZeroReg0x1500	= PlatformEFIORead1Byte(Adapter, REG_PORT_CTRL_SEL_8814B) & (~(BIT4|BIT5|BIT6));
				u2Byte	i					= 0;
				u4Byte	u4tmp_h				= 0;
				u4Byte	u4tmp_l				= 0;
				u8Byte	u8PortTSF			= 0;
				pu1Byte	pTimestamp			= ((pu1Byte)(&pdu[24]));
				u8Byte	Timestamp			= (*(pu8Byte)(pTimestamp));
				
				PlatformEFIOWrite1Byte(Adapter, REG_PORT_CTRL_SEL_8814B, u1bZeroReg0x1500);
				u4tmp_h = PlatformEFIORead4Byte(Adapter, REG_TSFTR_HIGH_8814B);
				u4tmp_l = PlatformEFIORead4Byte(Adapter, REG_TSFTR_LOW_8814B);
				u8PortTSF |= u4tmp_h;
				u8PortTSF = (u8PortTSF<<32) | u4tmp_l;

				RT_TRACE(COMP_INIT, DBG_LOUD, ("[8814B_TSF] %s(): STA Port0 TSF DEC(%llu)\n", __FUNCTION__, u8PortTSF));
				RT_TRACE(COMP_INIT, DBG_LOUD, ("[8814B_TSF] %s(): STA FreeRunCt DEC(%llu)\n", __FUNCTION__, RxTSFL));

				RT_TRACE(COMP_INIT, DBG_LOUD, ("[8814B_TSF] %s(): Beacon Timestamp EACH - (%#x %#x %#x %#x) (%#x %#x %#x %#x)\n", 
					__FUNCTION__,
					pTimestamp[7], pTimestamp[6],
					pTimestamp[5], pTimestamp[4],
					pTimestamp[3], pTimestamp[2],
					pTimestamp[1], pTimestamp[0]));
				RT_TRACE(COMP_INIT, DBG_LOUD, ("[8814B_TSF] %s(): Beacon Timestamp HEX(0x%x%x)\n", __FUNCTION__, (u4Byte)(Timestamp>>32), (u4Byte)(Timestamp&0xffffffff)));
				RT_TRACE(COMP_INIT, DBG_LOUD, ("[8814B_TSF] %s(): Beacon Timestamp DEC(%llu)\n", __FUNCTION__, Timestamp));
#endif
			}
			break;
			
		default:
			break;
	}    

}





#endif  /* RTW_FPGA_VERIFICATION */

