/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/
#ifndef __RTW_CHPLAN_H__
#define __RTW_CHPLAN_H__

enum rtw_chplan_id {
	RTW_CHPLAN_WW_01_NA_00          = 0x20,
	RTW_CHPLAN_ETSI_02_NA_00        = 0x21,
	RTW_CHPLAN_FCC_03_NA_00         = 0x22,
	RTW_CHPLAN_MKK_04_NA_00         = 0x23,
	RTW_CHPLAN_ETSI_05_NA_00        = 0x24,
	RTW_CHPLAN_FCC_03_FCC_03        = 0x25,
	RTW_CHPLAN_ETSI_01_ETSI_02      = 0x26,
	RTW_CHPLAN_MKK_04_MKK_02        = 0x27,
	RTW_CHPLAN_KCC_01_KCC_05        = 0x28,
	RTW_CHPLAN_FCC_01_FCC_06        = 0x29,
	RTW_CHPLAN_FCC_02_NA_00         = 0x2A,
	RTW_CHPLAN_IC_02_IC_33          = 0x2B,
	RTW_CHPLAN_MKK_02_NA_00         = 0x2C,
	RTW_CHPLAN_CHILE_01_CHILE_22    = 0x2D,
	RTW_CHPLAN_WW_03_WW_37          = 0x2E,
	RTW_CHPLAN_CHILE_01_CHILE_38    = 0x2F,
	RTW_CHPLAN_FCC_01_FCC_07        = 0x30,
	RTW_CHPLAN_FCC_01_FCC_08        = 0x31,
	RTW_CHPLAN_FCC_01_FCC_09        = 0x32,
	RTW_CHPLAN_FCC_01_FCC_10        = 0x33,
	RTW_CHPLAN_FCC_03_FCC_01        = 0x34,
	RTW_CHPLAN_ETSI_01_ETSI_03      = 0x35,
	RTW_CHPLAN_ETSI_01_ETSI_04      = 0x36,
	RTW_CHPLAN_MKK_04_MKK_10        = 0x37,
	RTW_CHPLAN_MKK_04_MKK_11        = 0x38,
	RTW_CHPLAN_NCC_03_NCC_12        = 0x39,
	RTW_CHPLAN_ETSI_02_ETSI_02      = 0x3A,
	RTW_CHPLAN_ACMA_02_ACMA_01      = 0x3B,
	RTW_CHPLAN_ETSI_02_ETSI_10      = 0x3C,
	RTW_CHPLAN_ETSI_02_ETSI_15      = 0x3D,
	RTW_CHPLAN_KCC_02_KCC_03        = 0x3E,
	RTW_CHPLAN_FCC_03_FCC_22        = 0x3F,
	RTW_CHPLAN_NCC_03_NCC_13        = 0x40,
	RTW_CHPLAN_WW_06_NA_00          = 0x41,
	RTW_CHPLAN_ETSI_02_ETSI_14      = 0x42,
	RTW_CHPLAN_FCC_03_FCC_06        = 0x43,
	RTW_CHPLAN_NCC_03_NCC_09        = 0x44,
	RTW_CHPLAN_ACMA_01_ACMA_01      = 0x45,
	RTW_CHPLAN_FCC_03_FCC_15        = 0x46,
	RTW_CHPLAN_ETSI_01_ETSI_10      = 0x47,
	RTW_CHPLAN_ETSI_01_ETSI_07      = 0x48,
	RTW_CHPLAN_ETSI_01_ETSI_06      = 0x49,
	RTW_CHPLAN_IC_03_IC_33          = 0x4A,
	RTW_CHPLAN_KCC_02_KCC_22        = 0x4B,
	RTW_CHPLAN_FCC_03_FCC_28        = 0x4C,
	RTW_CHPLAN_MEX_02_MEX_01        = 0x4D,
	RTW_CHPLAN_ETSI_02_ETSI_42      = 0x4E,
	RTW_CHPLAN_NA_00_MKK_43         = 0x4F,
	RTW_CHPLAN_ETSI_01_ETSI_16      = 0x50,
	RTW_CHPLAN_ETSI_01_ETSI_09      = 0x51,
	RTW_CHPLAN_ETSI_01_ETSI_17      = 0x52,
	RTW_CHPLAN_NCC_03_NCC_18        = 0x53,
	RTW_CHPLAN_ETSI_01_ETSI_15      = 0x54,
	RTW_CHPLAN_FCC_03_FCC_01_2      = 0x55,
	RTW_CHPLAN_ETSI_01_ETSI_19      = 0x56,
	RTW_CHPLAN_FCC_03_FCC_20        = 0x57,
	RTW_CHPLAN_MKK_02_MKK_14        = 0x58,
	RTW_CHPLAN_ETSI_01_ETSI_21      = 0x59,
	RTW_CHPLAN_NA_00_FCC_44         = 0x5A,
	RTW_CHPLAN_NA_00_FCC_45         = 0x5B,
	RTW_CHPLAN_NA_00_FCC_43         = 0x5C,
	RTW_CHPLAN_ETSI_02_ETSI_08      = 0x5D,
	RTW_CHPLAN_ETSI_02_ETSI_03      = 0x5E,
	RTW_CHPLAN_MKK_02_MKK_47        = 0x5F,
	RTW_CHPLAN_FCC_03_FCC_09        = 0x60,
	RTW_CHPLAN_FCC_02_FCC_01        = 0x61,
	RTW_CHPLAN_FCC_02_FCC_03        = 0x62,
	RTW_CHPLAN_ETSI_01_ETSI_23      = 0x63,
	RTW_CHPLAN_MKK_02_MKK_24        = 0x64,
	RTW_CHPLAN_ETSI_02_ETSI_24      = 0x65,
	RTW_CHPLAN_FCC_03_FCC_27        = 0x66,
	RTW_CHPLAN_FCC_03_FCC_25        = 0x67,
	RTW_CHPLAN_FCC_02_FCC_27        = 0x68,
	RTW_CHPLAN_FCC_02_FCC_25        = 0x69,
	RTW_CHPLAN_ETSI_02_ETSI_25      = 0x6A,
	RTW_CHPLAN_FCC_01_FCC_29        = 0x6B,
	RTW_CHPLAN_FCC_01_FCC_26        = 0x6C,
	RTW_CHPLAN_FCC_02_FCC_28        = 0x6D,
	RTW_CHPLAN_FCC_01_FCC_25        = 0x6E,
	RTW_CHPLAN_NA_00_ETSI_06        = 0x6F,
	RTW_CHPLAN_NA_00_ETSI_30        = 0x70,
	RTW_CHPLAN_NA_00_ETSI_25        = 0x71,
	RTW_CHPLAN_NA_00_ETSI_31        = 0x72,
	RTW_CHPLAN_FCC_01_FCC_01        = 0x73,
	RTW_CHPLAN_FCC_02_FCC_19        = 0x74,
	RTW_CHPLAN_ETSI_01_ETSI_32      = 0x75,
	RTW_CHPLAN_FCC_02_FCC_22        = 0x76,
	RTW_CHPLAN_ETSI_01_ETSI_34      = 0x77,
	RTW_CHPLAN_FCC_03_FCC_35        = 0x78,
	RTW_CHPLAN_MKK_02_MKK_02        = 0x79,                     
	RTW_CHPLAN_ETSI_02_ETSI_28      = 0x7A,                    
	RTW_CHPLAN_ETSI_02_ETSI_46      = 0x7B,
	RTW_CHPLAN_ETSI_02_ETSI_47      = 0x7C,
	RTW_CHPLAN_MKK_04_MKK_48        = 0x7D,
	RTW_CHPLAN_MKK_02_MKK_48        = 0x7E,
	RTW_CHPLAN_WW_01_WW_36          = 0x7F,
	RTW_CHPLAN_MAX,
	RTW_CHPLAN_UNSPECIFIED = 0xFF,
};

u8 rtw_chplan_get_default_regd(u8 id);
bool rtw_chplan_is_empty(u8 id);
#define rtw_is_channel_plan_valid(chplan) (((chplan) < RTW_CHPLAN_MAX) && !rtw_chplan_is_empty(chplan))
#define rtw_is_legacy_channel_plan(chplan) ((chplan) < 0x20)

struct _RT_CHANNEL_INFO;
u8 init_channel_set(_adapter *padapter, u8 ChannelPlan, struct _RT_CHANNEL_INFO *channel_set);

#define IS_ALPHA2_NO_SPECIFIED(_alpha2) ((*((u16 *)(_alpha2))) == 0xFFFF)

#define RTW_MODULE_RTL8821AE_HMC_M2		BIT0	/* RTL8821AE(HMC + M.2) */
#define RTW_MODULE_RTL8821AU			BIT1	/* RTL8821AU */
#define RTW_MODULE_RTL8812AENF_NGFF		BIT2	/* RTL8812AENF(8812AE+8761)_NGFF */
#define RTW_MODULE_RTL8812AEBT_HMC		BIT3	/* RTL8812AEBT(8812AE+8761)_HMC */
#define RTW_MODULE_RTL8188EE_HMC_M2		BIT4	/* RTL8188EE(HMC + M.2) */
#define RTW_MODULE_RTL8723BE_HMC_M2		BIT5	/* RTL8723BE(HMC + M.2) */
#define RTW_MODULE_RTL8723BS_NGFF1216	BIT6	/* RTL8723BS(NGFF1216) */
#define RTW_MODULE_RTL8192EEBT_HMC_M2	BIT7	/* RTL8192EEBT(8192EE+8761AU)_(HMC + M.2) */
#define RTW_MODULE_RTL8723DE_NGFF1630	BIT8	/* RTL8723DE(NGFF1630) */
#define RTW_MODULE_RTL8822BE			BIT9	/* RTL8822BE */
#define RTW_MODULE_RTL8821CE			BIT10	/* RTL8821CE */
#define RTW_MODULE_RTL8822CE			BIT11	/* RTL8822CE */

struct country_chplan {
	char alpha2[2];
	u8 chplan;
#ifdef CONFIG_80211AC_VHT
	u8 en_11ac;
#endif
#if RTW_DEF_MODULE_REGULATORY_CERT
	u16 def_module_flags; /* RTW_MODULE_RTLXXX */
#endif
};

#ifdef CONFIG_80211AC_VHT
#define COUNTRY_CHPLAN_EN_11AC(_ent) ((_ent)->en_11ac)
#else
#define COUNTRY_CHPLAN_EN_11AC(_ent) 0
#endif

#if RTW_DEF_MODULE_REGULATORY_CERT
#define COUNTRY_CHPLAN_DEF_MODULE_FALGS(_ent) ((_ent)->def_module_flags)
#else
#define COUNTRY_CHPLAN_DEF_MODULE_FALGS(_ent) 0
#endif

const struct country_chplan *rtw_get_chplan_from_country(const char *country_code);

void dump_country_chplan(void *sel, const struct country_chplan *ent);
void dump_country_chplan_map(void *sel);
void dump_chplan_id_list(void *sel);
void dump_chplan_test(void *sel);
void dump_chplan_ver(void *sel);

#endif /* __RTW_CHPLAN_H__ */
