/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

#include <drv_types.h>
#include <hal_data.h>	/* HAL_DATA_TYPE */

#ifdef CONFIG_AUTOSUSPEND

extern int rtw_resume_process(PADAPTER padapter);

/*  ============ private : =========================================================== */


void autosuspend_enable(struct dvobj_priv *dvobj)
{

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 35))
		usb_enable_autosuspend(dvobj->pusbdev);
#else
		dvobj->pusbdev->autosuspend_disabled = 0;/* autosuspend disabled by the user */
#endif

	return;

}


void autosuspend_disable(struct dvobj_priv *dvobj)
{

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 35))
		usb_disable_autosuspend(dvobj->pusbdev);
#elif (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 22) && LINUX_VERSION_CODE <= KERNEL_VERSION(2, 6, 34))
		dvobj->pusbdev->autosuspend_disabled =1;/* autosuspend disabled by the user */
#endif

	return;
}


void autosuspend_int_put(struct dvobj_priv *dvobj)
{

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 33))
		usb_autopm_put_interface(dvobj->pusbintf);
#elif (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 20))
		usb_autopm_enable(dvobj->pusbintf);
#else
		usb_autosuspend_device(dvobj->pusbdev, 1);
#endif

	return;

}

int autosuspend_int_get(struct dvobj_priv *dvobj)
{
	int result = _SUCCESS;

	
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 33))
			if (usb_autopm_get_interface(dvobj->pusbintf) < 0) {
				RTW_INFO("autosuspend_int_get ... can't get autopm: %d\n", result);
				result = _FAIL;
			}
#elif (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 20))
			usb_autopm_disable(dvobj->pusbintf);
#else
			usb_autoresume_device(dvobj->pusbdev, 1);
#endif

	return result;

}

void autosuspend_int_get_no_resume(struct dvobj_priv *dvobj)
{


#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 33))
		usb_autopm_get_interface_no_resume(dvobj->pusbintf);
#endif

}

int autosuspend_int_get_async(struct dvobj_priv *dvobj)
{
	int result = _SUCCESS;

	
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 33))
			if (usb_autopm_get_interface_async(dvobj->pusbintf) < 0) {
				RTW_INFO("usb_autopm_get_interface_async ... can't get autopm: %d\n", result);
				result = _FAIL;
			}
#elif (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 20))
			usb_autopm_disable(dvobj->pusbintf);
#else
			usb_autoresume_device(dvobj->pusbdev, 1);
#endif

	return result;

}


void autosuspend_set_autosuspend_delay(struct dvobj_priv *dvobj, u8 idletimeout)
{

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 38))
				dvobj->pusbdev->dev.power.autosuspend_delay = idletimeout * HZ;
#else
				dvobj->pusbdev->autosuspend_delay = idletimeout * HZ;
#endif

}


/*  ============ private : system api end =========================================================== */


// interface put, and wait for rtw_suspend callback
int autoresume_entry(_adapter *padapter, u8 bFromPS, u8 wow)
{
	int result = _SUCCESS;
	struct security_priv *psecuritypriv = &(padapter->securitypriv);
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);

	/* RTW_INFO("====> autoresume_entry\n"); */

	 if (rf_off == pwrpriv->rf_pwrstate || wow) 
	{
		aspriv_set_as_state(pwrpriv,AS_RESUME_PROCESSING);
		pwrpriv->ps_flag = _FALSE;

#ifdef	CONFIG_BT_COEXIST
		pwrpriv->bAutoResume = _TRUE;
		if (0 == pwrpriv->autopm_cnt) 
		{
#endif // #ifdef	CONFIG_BT_COEXIST

			pwrpriv->aspriv.bInternalAutoResume_processing = _TRUE;	
			if(bFromPS)
			{
				RTW_INFO("====> autoresume_entry : rtw resume flow (wow:%d/reason:%d)\n", wow, pwrpriv->aspriv.leaveAutoSuspendReason);
				if((pwrpriv->aspriv.leaveAutoSuspendReason == REASON_TX) 
                    || (pwrpriv->aspriv.leaveAutoSuspendReason == REASON_DISCONNECT)
                    || (pwrpriv->aspriv.leaveAutoSuspendReason == REASON_DISMATCH)
                    || (pwrpriv->aspriv.leaveAutoSuspendReason == REASON_CONCURRENT)) 
				{
					result = autosuspend_int_get_async(dvobj);
				} else
				{
					result = autosuspend_int_get(dvobj);
				}
				/* _SUCCESS(1) and _FAIL(0) */
				if (result != _SUCCESS)
				{
					RTW_INFO("can't get autopm: %d\n", result);
					goto error_exit;
				}
			}else
			{
				RTW_INFO("====> autoresume_entry : system resume flow\n");
				result = rtw_resume_process(padapter);
                /* must get intf back when system final resume rather than here, or system will callback to auto suspend. 2018/1/10-Emerson */
				/* autosuspend_int_get_async(dvobj); */
                
			}

			ex_autosuspend_dump_pm_cnt(dvobj, _TRUE);

#ifdef	CONFIG_BT_COEXIST			
			pwrpriv->autopm_cnt++;

#if CONFIG_AUTOSUSPEND_DEBUG
			RTW_INFO("(bt) ... pwrpriv->autopm_cnt  (%d)  ...........\n", pwrpriv->autopm_cnt);
#endif 
		}
		else
		{

			RTW_INFO("0!=pwrpriv->autopm_cnt[%d]   didn't usb_autopm_get_interface\n", pwrpriv->autopm_cnt);
			goto error_exit;
		}
#endif /* CONFIG_BT_COEXIST */

	}

	if(!wow) pwrpriv->rf_pwrstate = rf_on;
	RTW_INFO("<==== autoresume_entry\n");
error_exit:

	return result ;
}

void autosuspend_reset_waitcnt(_adapter *padapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);
	
	pwrpriv->aspriv.InternalAutoSuspend_waitcnt = dvobj->pusbdev->dev.power.autosuspend_delay  / 2000 ;
}


bool autosuspend_if_get_ip_address(_adapter *padapter)
{
		struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
		struct mlme_ext_info *pmlmeinfo = &(pmlmeext->mlmext_info);
		struct in_device *my_ip_ptr = padapter->pnetdev->ip_ptr;
		u8 ipaddress[4];
		bool ret = _FALSE;
	
		if ((pmlmeinfo->state & WIFI_FW_LINKING_STATE) ||
			pmlmeinfo->state & WIFI_FW_AP_STATE) {
			_rtw_memcpy(ipaddress, pmlmeinfo->ip_addr, RTW_IP_ADDR_LEN);
			
			if(ipaddress[0] == 169 && ipaddress[1] == 254)
				RTW_INFO("%s: DHCP fail ! \n", __func__);
			else if(ipaddress[0] == 0)
				RTW_INFO("%s: No IP ! \n", __func__);
			else
			{
				RTW_INFO("%s: %d.%d.%d.%d ==========\n", __func__,
					ipaddress[0], ipaddress[1], ipaddress[2], ipaddress[3]);
				ret = _TRUE;
			}
		}

		return ret;

}

bool autosuspend_if_suspend_or_resume_inprogress(_adapter *adapter)
{
	return (adapter->cmdThread==NULL) ? _TRUE: _FALSE ;
}

void ex_autosuspend_enter(_adapter *padapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	

	/*  RTW_INFO("==>autosuspend_enter...........\n"); */
	if(!aspriv_chk_as_state(pwrpriv, AS_NORMAL))
		RTW_WARN("==>autosuspend_enter: as state is not in AS_NORMAL.\n");

#ifdef DBG_CONFIG_ERROR_DETECT
	if (rtw_hal_sreset_inprogress(padapter))
	{
		RTW_INFO("==>%s : sreset_inprogress, return\n", __FUNCTION__);
		return;
	}	
#endif /* DBG_CONFIG_ERROR_DETECT */	

	if (pwrpriv->aspriv.bInternalAutoBlock == AS_BLK_ALL) 
		return;

	// check which as mode will involed and enable condition
	if (check_fwstate(pmlmepriv, WIFI_ASOC_STATE))
	{
		pwrpriv->aspriv.bInternalAssociatedAutoSuspend = _TRUE;
		pwrpriv->LpsIdleCount = 0;
		RTW_INFO("==>autosuspend_enter (wow)(%d) ...........\n", ex_autosuspend_dump_pm_cnt(dvobj, _FALSE));
	}else if (check_fwstate(pmlmepriv, WIFI_UNDER_SURVEY | WIFI_UNDER_LINKING)  != _TRUE)
	{
		if (rf_off != pwrpriv->change_rfpwrstate)
			goto exit;

		pwrpriv->aspriv.bInternalAssociatedAutoSuspend = _FALSE;
		autosuspend_reset_waitcnt(padapter);
		RTW_INFO("==>autosuspend_enter (normal)(%d) ...........\n", ex_autosuspend_dump_pm_cnt(dvobj, _FALSE));
	}
	else
	{
		RTW_INFO("autosuspend_enter ... return because some conditions doesn't match ! \n");
		goto exit;
	}


	pwrpriv->bInternalAutoSuspend = _TRUE;
	pwrpriv->bips_processing = _TRUE;
	pwrpriv->aspriv.bInternalAutoSuspend_processing  = _TRUE;

#ifdef CONFIG_BT_COEXIST
	if (1 == pwrpriv->autopm_cnt)
	{
#endif /* CONFIG_BT_COEXIST */

		autosuspend_enable(dvobj);
		autosuspend_int_put(dvobj);
		
#ifdef CONFIG_BT_COEXIST
		pwrpriv->autopm_cnt--;

#if CONFIG_AUTOSUSPEND_DEBUG
		RTW_INFO("(bt) ... pwrpriv->autopm_cnt  (%d)  ...........\n", pwrpriv->autopm_cnt);
#endif 

	} else
	{
		RTW_INFO("1!=pwrpriv->autopm_cnt[%d]   didn't usb_autopm_put_interface\n", pwrpriv->autopm_cnt);
	}
#endif	 /* CONFIG_BT_COEXIST */


	ex_autosuspend_dump_pm_cnt(dvobj, _TRUE);
	aspriv_set_as_state(pwrpriv,AS_SUSPEND_WAITING);

exit:
	RTW_INFO("<== autosuspend_enter...........\n");

}

void ex_autosuspend_resume_end(_adapter *padapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	
	if(pwrpriv->aspriv.leaveAutoSuspendReason == REASON_DISCONNECT)
		receive_disconnect(padapter, pmlmeinfo->network.MacAddress, WLAN_REASON_EXPIRATION_CHK, _FALSE);
    else if(pwrpriv->aspriv.leaveAutoSuspendReason == REASON_CONCURRENT){
        RTW_INFO("==> %s: Set Auto-suspend block. \n", __func__); 
        pwrpriv->aspriv.bInternalAutoBlock = AS_BLK_ALL;
    }else if((pwrpriv->aspriv.leaveAutoSuspendReason == REASON_RX) 
        && (ex_autosuspend_dump_pm_cnt(dvobj, _FALSE) == 0) ){

        if(aspriv_chk_as_state(pwrpriv, AS_RESUME_PROCESSING)){
            RTW_INFO("%s : call autosuspend_int_get_async\n", __FUNCTION__);
            autosuspend_int_get_async(dvobj);          
        }else if(aspriv_chk_as_state(pwrpriv, AS_NORMAL)){
            RTW_INFO("%s : call autosuspend_int_get \n", __FUNCTION__);
            autosuspend_int_get(dvobj);
        }
     }
    
	pwrpriv->aspriv.bInternalAutoResume_processing = _FALSE;
	pwrpriv->aspriv.leaveAutoSuspendReason = REASON_UNKNOWN;
	aspriv_set_as_state(pwrpriv,AS_NORMAL);
}

void ex_autosuspend_sys_resume_end(_adapter *padapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);

    if(ex_autosuspend_dump_pm_cnt(dvobj, _FALSE) == 0){
	    autosuspend_int_get_async(dvobj);
        RTW_INFO("<==== %s : call autosuspend_int_get_async \n", __FUNCTION__);
    }    
    else{
        RTW_INFO("<==== %s : ........... \n", __FUNCTION__);
    }    
}


static const char *const _as_state_str[] = {
	"AS_NORMAL",
	"AS_SUSPEND_WAITING",
	"AS_SUSPEND_PROCESSING",
	"AS_SUSPEND",
	"AS_RESUME_PROCESSING",
	"AS_STATE_MAX",
};

const char *as_state_str(u8 state)
{
	state = (state >= AS_STATE_MAX) ? AS_STATE_MAX : state;
	return _as_state_str[state];
}


/*  ============ pulic : =========================================================== */

void ex_autosuspend_priv_init(_adapter *padapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);
	//struct autosuspend_priv aspriv = pwrpriv->aspriv;
	aspriv_set_as_state(pwrpriv,AS_NORMAL);
	pwrpriv->aspriv.bInternalAssociatedAutoSuspend = _FALSE;
	pwrpriv->aspriv.bInternalAutoSuspend_processing  = _FALSE;
	pwrpriv->aspriv.bInternalAutoResume_processing  = _FALSE;
	pwrpriv->aspriv.bInternalAutoBlock = AS_BLK_NONE;
	pwrpriv->aspriv.InternalAutoSuspend_waitcnt = 0;
	pwrpriv->aspriv.leaveAutoSuspendReason = REASON_UNKNOWN;
}


void ex_autosuspend_init(_adapter *padapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);

	if (padapter->registrypriv.power_mgnt != PS_MODE_ACTIVE)
	{
		if (padapter->registrypriv.usbss_enable)
		{
			/*dvobj->pusbdev->dev.power.autosuspend_delay = 20 * HZ; */
			pwrpriv->aspriv.InternalAutoSuspend_waitcnt = dvobj->pusbdev->dev.power.autosuspend_delay  / 2000  + 1 ;
			autosuspend_enable(dvobj);
		}
	}

	if (autosuspend_int_get(dvobj) != _SUCCESS)
	{
		RTW_INFO("can't get autopm:\n");
		goto exit;
	}
	
#ifdef CONFIG_BT_COEXIST
		dvobj_to_pwrctl(dvobj)->autopm_cnt = 1;
#endif

exit:
	RTW_INFO("%s...pm_usage_cnt(%d).....\n", __FUNCTION__, ex_autosuspend_dump_pm_cnt(dvobj, _FALSE));
	return;

}

void ex_autosuspend_deinit(_adapter *padapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);
	
#ifdef CONFIG_BT_COEXIST
	if (1 == pwrpriv->autopm_cnt)
#endif
	{
		autosuspend_int_put(dvobj);
		autosuspend_disable(dvobj);

#ifdef CONFIG_BT_COEXIST
		pwrpriv->autopm_cnt--;
#endif
	}
}

bool ex_autosuspend_connected_entry(_adapter *padapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);


#ifndef CONFIG_AUTOSUSPEND_WOW
	return _FALSE;
#else

#ifdef DBG_CONFIG_ERROR_DETECT
	if (rtw_hal_sreset_inprogress(padapter))
	{
		RTW_INFO("%s: return because thermal_defence_is_handling = 1\n", __FUNCTION__);
		return _FALSE;
	}
#endif /* DBG_CONFIG_ERROR_DETECT */

	/*  
	 *  return _FALSE in here, device could enter normal LPS mode,
	 *  it means wow-as and normal LPS are coexisting rather than be mutual exclusion,
	 *   in which case the return value should be _TRUE.	 
	 */
    
    ex_autosuspend_watchdog_check_concurrent_state(padapter);

	if (!padapter->registrypriv.usbss_enable ||pwrpriv->aspriv.bInternalAutoBlock == AS_BLK_ALL) 
		return _FALSE;

	if((dvobj->traffic_stat.cur_tx_bytes + dvobj->traffic_stat.cur_rx_bytes) >= 128)
	{
		/* Auto suspend cancel function en-queue to prevent device hang. */
		RTW_INFO("==> %s .TX bytes(%lld), Rx bytes(%lld)\n", __FUNCTION__, 
			dvobj->traffic_stat.cur_tx_bytes, dvobj->traffic_stat.cur_rx_bytes);
		if(_TRUE == pwrpriv->bInternalAutoSuspend) ex_autosuspend_cancel_cmd(padapter, _FALSE);
		return _FALSE;
	}

#if CONFIG_AUTOSUSPEND_DEBUG
	RTW_INFO("<==%s .TX bytes(%lld), Rx bytes(%lld)\n", __FUNCTION__, 
		dvobj->traffic_stat.cur_tx_bytes, dvobj->traffic_stat.cur_rx_bytes);
#endif

	if(pwrpriv->LpsIdleCount < 1 )  /* > 2 Sec */
	{
		pwrpriv->LpsIdleCount++;
		return _TRUE;
	}	

	if (_TRUE == pwrpriv->bInternalAutoSuspend)
	{	
#if CONFIG_AUTOSUSPEND_DEBUG
		RTW_INFO("<==%s .pwrpriv->bInternalAutoSuspend)(%x), as pm-cnt(%d)\n", __FUNCTION__, 
			pwrpriv->bInternalAutoSuspend, ex_autosuspend_dump_pm_cnt(adapter_to_dvobj(padapter), FALSE));	
#endif
	}
	else if (autosuspend_if_get_ip_address(padapter))
	{
	
#if CONFIG_AUTOSUSPEND_DEBUG
		RTW_INFO("<==%s .pwrpriv->bInternalAutoSuspend)(%x) change_rfpwrstate(%d) call autosuspend_enter\n", __FUNCTION__, pwrpriv->bInternalAutoSuspend, pwrpriv->change_rfpwrstate);
#endif 
		// 20210924 Adjust Auto Suspend mode enter condition. Need to disable the function to prevent exiting the power save.
		//LeaveAllPowerSaveMode(padapter);
		pwrpriv->ps_flag = TRUE;
		ex_autosuspend_enter(padapter);
	}
#endif /* CONFIG_AUTOSUSPEND_WOW */

	return _TRUE;
			
}

bool ex_autosuspend_cancel_nas_in_suspend(_adapter *padapter, pm_message_t message)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	bool ret = _FALSE;

	if(!PMSG_IS_AUTO(message) && aspriv_chk_as_state(pwrpriv,AS_SUSPEND_WAITING)) {
		RTW_INFO("%s : cancel the auto-suspend entering if system suspend come first! \n", __FUNCTION__);
		/* ex_autosuspend_cancel(padapter, _TRUE); */
        pwrpriv->aspriv.leaveAutoSuspendReason = REASON_DISMATCH;
		ret = _TRUE;
	}
	if(PMSG_IS_AUTO(message) && (check_fwstate(pmlmepriv, WIFI_ASOC_STATE)) && (!pwrpriv->aspriv.bInternalAssociatedAutoSuspend)  &&  (rf_off == pwrpriv->change_rfpwrstate))
	{
		/* cancel the  noraml auto-suspend entering if FW status in linked */
		RTW_INFO("%s : cancel the  noraml auto-suspend entering if FW status in linked \n", __FUNCTION__);
		/* ex_autosuspend_cancel(padapter, _FALSE); */
        pwrpriv->aspriv.leaveAutoSuspendReason = REASON_TX;
		pwrpriv->change_rfpwrstate = rf_on;
		ret = _TRUE;
	}
	if (check_fwstate(pmlmepriv, WIFI_ASOC_STATE) && aspriv_chk_as_state(pwrpriv,AS_SUSPEND_WAITING)) {
		
		if(!ex_autosuspend_active_chk_alive(padapter)) {
			RTW_INFO(FUNC_ADPT_FMT" disconnect or roaming\n", FUNC_ADPT_ARG(padapter));
			/* ex_autosuspend_cancel(padapter, _TRUE);
			receive_disconnect(padapter, pmlmeinfo->network.MacAddress, WLAN_REASON_EXPIRATION_CHK, _FALSE); */
			pwrpriv->aspriv.leaveAutoSuspendReason = REASON_DISCONNECT;
			pwrpriv->change_rfpwrstate = rf_on;
			ret = _TRUE;
		}
	}

	return ret;
}

void ex_autosuspend_suspend_end(_adapter *padapter, bool ret_suspend)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);

	if(!aspriv_chk_as_state(pwrpriv, AS_SUSPEND_PROCESSING))
		return;
		
	if(ret_suspend != SUCCESS) 
		return;

	/*  for disconnected auto suspend flow */
	if (!pwrpriv->aspriv.bInternalAssociatedAutoSuspend)
		pwrpriv->rf_pwrstate = rf_off;

	pwrpriv->aspriv.bInternalAutoSuspend_processing = _FALSE;		

	aspriv_set_as_state(pwrpriv,AS_SUSPEND);
	/* 
	 * When there is any tx packet enqueued whthin the AS_SUSPEND_PROCESSING,
	 * we should leave the suspend state directly and send the packet.
	 */
	if((pwrpriv->aspriv.leaveAutoSuspendReason == REASON_TX) 
        ||(pwrpriv->aspriv.leaveAutoSuspendReason == REASON_DISCONNECT) 
        || (pwrpriv->aspriv.leaveAutoSuspendReason == REASON_DISMATCH)
        || (pwrpriv->aspriv.leaveAutoSuspendReason == REASON_CONCURRENT)) {
#if CONFIG_AUTOSUSPEND_DEBUG
	    RTW_INFO("====> %s: leaveAutoSuspendReason(%d) :  \n", __FUNCTION__, pwrpriv->aspriv.leaveAutoSuspendReason );
#endif         
		ex_autosuspend_leave(padapter);
	}

	return;
}

bool ex_autosuspend_leave(_adapter *padapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);
	int wait_time = 0;

	if (!padapter->registrypriv.usbss_enable ||pwrpriv->aspriv.bInternalAutoBlock == AS_BLK_ALL)
		return _FALSE;

#if CONFIG_AUTOSUSPEND_DEBUG
	RTW_INFO("====> %s(%s) :  \n", __FUNCTION__, pwrpriv->bInternalAutoSuspend? "true":"false" );
#endif

	if (_FALSE == pwrpriv->bInternalAutoSuspend)
		goto exit;

	/* return if device is already resuming in connected state. */
	if(_TRUE == pwrpriv->aspriv.bInternalAutoResume_processing && pwrpriv->aspriv.bInternalAssociatedAutoSuspend)
		goto exit;

#if defined(CONFIG_BT_COEXIST) && defined (CONFIG_AUTOSUSPEND)
	if (0 == pwrpriv->autopm_cnt)
#endif	/* #if defined (CONFIG_BT_COEXIST) && defined (CONFIG_AUTOSUSPEND)  */
	{
		if(pwrpriv->aspriv.bInternalAutoSuspend_processing){
			ex_autosuspend_cancel(padapter, FALSE);
		}
		autoresume_entry(padapter, TRUE, pwrpriv->aspriv.bInternalAssociatedAutoSuspend);
	}

#if CONFIG_AUTOSUSPEND_DEBUG
	RTW_INFO("<==== %s : ........... \n", __FUNCTION__);
#endif

exit:
	return _TRUE;
}

bool ex_autoresume_entry_in_resume(_adapter *padapter, int *b_resume_result)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	bool ret = _FALSE;

	/* 
	 * When rtw_resume is called by asyncronized method, that is autoresume_entry was called by ex_autosuspend_leave 
	 * and the AS_STATE will be AS_RESUME_PROCESSING.
	 * In this case, autoresume_entry should not be called again.
	 */
	if(aspriv_chk_as_state(pwrpriv, AS_SUSPEND) &&  (!aspriv_chk_as_state(pwrpriv, AS_RESUME_PROCESSING)))
	{		
		ret = _TRUE;
		RTW_INFO("========>  %s \n", __func__);
		RTW_INFO("%s: Resume from auto-suspend call autoresume_enter....\n", __FUNCTION__);
		*b_resume_result = autoresume_entry(padapter, FALSE, pwrpriv->aspriv.bInternalAssociatedAutoSuspend);

		ex_autosuspend_resume_end(padapter);

		/* 
	 	 * When there is any tx packet enqueued whthin the AS_RESUME_PROCESSING,
	 	 * we should trigger the xmit_tasklet to send the packet.
	 	*/
		if(rtw_txframes_pending(padapter)) {
			tasklet_hi_schedule(&padapter->xmitpriv.xmit_tasklet);
		}
		pmlmeext->last_scan_time = rtw_get_current_time();

		RTW_INFO("<========  %s return %d\n", __func__, ret);
	}

	
	return ret;
}


void ex_autosuspend_check_wow_reason(_adapter *padapter){
    struct pwrctrl_priv *pwrctl = adapter_to_pwrctl(padapter);
    
    if(pwrctl->wowlan_wake_reason != 0x00){
        pwrctl->aspriv.leaveAutoSuspendReason = REASON_RX;
#if CONFIG_AUTOSUSPEND_DEBUG
        RTW_INFO("==> %s  leaveAutoSuspendReason %x ...........\n", __func__, pwrctl->aspriv.leaveAutoSuspendReason);
#endif          
    }
}


void ex_autosuspend_check_waitcnt(_adapter *padapter)
{

	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);

	if (!padapter->registrypriv.usbss_enable ||pwrpriv->aspriv.bInternalAutoBlock == AS_BLK_ALL) 
		return; 

	if (_TRUE == pwrpriv->bInternalAutoSuspend)
		(pwrpriv->aspriv.InternalAutoSuspend_waitcnt < 0)? ex_autosuspend_cancel(padapter, FALSE): pwrpriv->aspriv.InternalAutoSuspend_waitcnt--;

#if CONFIG_AUTOSUSPEND_DEBUG
	RTW_INFO("==> %s  InternalAutoSuspend_waitcnt %d ...........\n", __func__, pwrpriv->aspriv.InternalAutoSuspend_waitcnt); 
#endif 

	return;
}

void ex_autosuspend_cancel(_adapter *padapter, u8 bFromSystemCall)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);

#if CONFIG_AUTOSUSPEND_DEBUG	
	RTW_INFO("==> %s(%d)  ...........\n", __func__, bFromSystemCall);
#endif /* CONFIG_AUTOSUSPEND_DEBUG */

	if(autosuspend_if_suspend_or_resume_inprogress(padapter))
	{
		RTW_INFO("==> %s : suspend or resume is in progress, return. \n", __func__);
		return;
	}
	
	if (_TRUE == pwrpriv->bInternalAutoSuspend)
	{
		
#if defined(CONFIG_BT_COEXIST)
		if (0 == pwrpriv->autopm_cnt)
#endif	/* #if defined (CONFIG_BT_COEXIST)  */
		{	
			if(bFromSystemCall)
				autosuspend_int_get_no_resume(dvobj);
			else
				autosuspend_int_get_async(dvobj) ;
			
			pwrpriv->bInternalAutoSuspend = _FALSE;
			pwrpriv->ps_flag = _FALSE;
			pwrpriv->aspriv.bInternalAssociatedAutoSuspend = _FALSE;
			pwrpriv->aspriv.bInternalAutoSuspend_processing  = _FALSE;
			autosuspend_reset_waitcnt(padapter);
			ex_autosuspend_dump_pm_cnt(dvobj, _TRUE);

			aspriv_set_as_state(pwrpriv,AS_NORMAL);
			
#if defined(CONFIG_BT_COEXIST)
			pwrpriv->autopm_cnt++;
#if CONFIG_AUTOSUSPEND_DEBUG
			RTW_INFO("(bt) ... pwrpriv->autopm_cnt  (%d)  ...........\n", pwrpriv->autopm_cnt);
#endif /* CONFIG_AUTOSUSPEND_DEBUG */
#endif /* #if defined(CONFIG_BT_COEXIST) */

		}
	}
	
#if CONFIG_AUTOSUSPEND_DEBUG
	RTW_INFO("<== %s  ...........\n", __func__);
#endif /* CONFIG_AUTOSUSPEND_DEBUG */


}

u8 ex_autosuspend_cancel_hdl(_adapter *padapter, u8 *pbuf)
{
	struct autosuspend_cancel_parm *p;
	
	if (NULL == pbuf)
		return H2C_PARAMETERS_ERROR;
	
	p = (struct autosuspend_cancel_parm *)pbuf;

	ex_autosuspend_cancel(padapter, p->bFromSystemCall);

	return H2C_SUCCESS;
}

u8 ex_autosuspend_cancel_cmd(_adapter *padapter, u8 bFromSystemCall)
{
	struct cmd_priv *pcmdpriv = &padapter->cmdpriv;
	struct cmd_obj *ph2c;
	struct autosuspend_cancel_parm	*pascancelPara;
	u8 res = _SUCCESS;
	
	ph2c = (struct cmd_obj *)rtw_zmalloc(sizeof(struct cmd_obj));
	if (ph2c == NULL) {
		res = _FAIL;
		goto exit;
	}	

	pascancelPara = (struct autosuspend_cancel_parm *)rtw_zmalloc(sizeof(struct autosuspend_cancel_parm));
	if (pascancelPara == NULL) {
		rtw_mfree((unsigned char *) ph2c, sizeof(struct cmd_obj));
		return _FAIL;
	}

	init_h2fwcmd_w_parm_no_rsp(ph2c, pascancelPara, CMD_AUTO_SUSPEND_CANCEL);
	pascancelPara->bFromSystemCall = bFromSystemCall;

	res = rtw_enqueue_cmd(pcmdpriv, ph2c);

exit:


	return res;
}


void ex_autosuspend_switch(_adapter *padapter, u8 block_type)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);

#if CONFIG_AUTOSUSPEND_DEBUG
	RTW_INFO("==> %s  ...........\n", __func__);
#endif 

	if(block_type >= AS_BLK_MAX) 
	{
		RTW_INFO("%s :  wrong autu suspend block type (%x) ...........\n", __func__, block_type);
		return;
	}
	
	if( (pwrpriv->aspriv.bInternalAutoBlock != block_type) && pwrpriv->bInternalAutoSuspend)
		ex_autosuspend_leave(padapter);

	pwrpriv->aspriv.bInternalAutoBlock = block_type;
	
#if CONFIG_AUTOSUSPEND_DEBUG
	RTW_INFO("<== %s  ...........\n", __func__);
#endif


}


void ex_autosuspend_check_netif_queue(_adapter *padapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);
	struct net_device *pnetdev = padapter->pnetdev;

	if(pwrpriv->aspriv.bInternalAutoBlock == AS_BLK_TX)
		return;
	
	/* keep netif queue alive for autosuspend tx resume */
	if( pwrpriv->aspriv.bInternalAssociatedAutoSuspend && pnetdev)
		rtw_netif_wake_queue(pnetdev);
}


/* 

Target : 
	1. check usb bus if in autosuspend mode, and resume in here when it is.
	2. Return value is for controlling the tx flow

Reture : 
	_FAIL : (rtw_xmit_entry) will return _FALSE directly.
	_SUCCUES : keep the normal tx flow, and the pkts will enqueue to tx_pending queue if usb bus is in auto-suspend. 
	
*/
int ex_autosuspend_check_autosuspend_status(_adapter *padapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);
	int ret = _SUCCESS;

	if(aspriv_chk_as_state(pwrpriv, AS_SUSPEND_WAITING)) {
		ex_autosuspend_cancel(padapter, FALSE);
	}
    else if(aspriv_chk_as_state(pwrpriv, AS_SUSPEND_PROCESSING))
	{
		pwrpriv->aspriv.leaveAutoSuspendReason = REASON_TX;
	}
	else if(aspriv_chk_as_state(pwrpriv, AS_SUSPEND))
	{
		pwrpriv->aspriv.leaveAutoSuspendReason = REASON_TX;
		ex_autosuspend_leave(padapter);
	}
	else
		pwrpriv->aspriv.leaveAutoSuspendReason = REASON_UNKNOWN;

	return ret;
}

u8 ex_autosuspend_check_tx_pkt_enqueue(_adapter *padapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);
	/* We should not tx within these state, so pending all the tx packets. */
	if(aspriv_chk_as_state(pwrpriv, AS_RESUME_PROCESSING) ||
	    aspriv_chk_as_state(pwrpriv, AS_SUSPEND_PROCESSING)||
	    aspriv_chk_as_state(pwrpriv, AS_SUSPEND) ||
	    (pwrpriv->bInSuspend))
	{
#if CONFIG_AUTOSUSPEND_DEBUG
		RTW_INFO("====== %s  : enqueue 'cause bInternalAutoSuspend ============== \n", __FUNCTION__);
#endif 
		return _TRUE;
	}

	return _FALSE;

}

/* Reason : (No roaming & auto suspend enable) + ap lost ==> will keep connected if using sd4 original wow flow. */
/* Resolve : check and indicate in wow flow */

void ex_autosuspend_check_indicate_disconnect(_adapter *padapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	
	if (!rtw_chk_roam_flags(padapter, RTW_ROAM_ON_RESUME)) {
	
		if (pwrpriv->wowlan_wake_reason == FW_DECISION_DISCONNECT ||
		    pwrpriv->wowlan_wake_reason == RX_DISASSOC||
		    pwrpriv->wowlan_wake_reason == RX_DEAUTH) {

#if CONFIG_AUTOSUSPEND_DEBUG
			RTW_INFO("%s: disconnect reason: %02x\n", __func__,
				 pwrpriv->wowlan_wake_reason);
#endif 
			rtw_indicate_disconnect(padapter, 0, _FALSE);

			rtw_sta_media_status_rpt(padapter,
					 rtw_get_stainfo(&padapter->stapriv,
					 get_bssid(&padapter->mlmepriv)), 0);

			rtw_free_assoc_resources(padapter, 1);
			pmlmeinfo->state = WIFI_FW_NULL_STATE;
		} 
	}

	return;

}

void ex_autosuspend_intf_up_check_concurrent_state(_adapter *padapter)
{
    
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);

    if (!is_primary_adapter(padapter)){
        if(aspriv_chk_as_state(pwrpriv, AS_NORMAL)){
            RTW_INFO("==> %s: Set Auto-suspend block. \n", __func__); 
            pwrpriv->aspriv.bInternalAutoBlock = AS_BLK_ALL;
        }else{ 
            pwrpriv->aspriv.leaveAutoSuspendReason = REASON_CONCURRENT;
            RTW_INFO("==> %s: Set leaveAutoSuspendReason as (%d). \n", __func__, pwrpriv->aspriv.leaveAutoSuspendReason);
        }
    }

    RTW_INFO("==> %s: pwrpriv->aspriv.bInternalAutoBlock %d. \n", __func__, pwrpriv->aspriv.bInternalAutoBlock); 

	return;
}

void ex_autosuspend_intf_down_check_concurrent_state(_adapter *padapter)
{

	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);
    u8 intf_up_num = 1, counter = 1;

    if(dvobj->iface_nums <= 1)
       return;

    if(!dvobj->padapters[0]->net_closed)
       return;

    if (!is_primary_adapter(padapter)){   
        
        for(counter; counter < dvobj->iface_nums; counter++){  
            if(!dvobj->padapters[counter]->net_closed){
                /* RTW_INFO("==> %s: counter %d. \n", __func__, counter); */
                intf_up_num++;
            }    
        }

        /* still in concurrent state, skip this checking */
        /* -1 : because this intf is not currently down yet  */
        if((intf_up_num-1) > 1)
            return;
            
        if(pwrpriv->aspriv.bInternalAutoBlock == AS_BLK_ALL){
            RTW_INFO("==> %s: Set AS_BLK_NONE. \n", __func__); 
            pwrpriv->aspriv.bInternalAutoBlock = AS_BLK_NONE;
        }else if(pwrpriv->aspriv.leaveAutoSuspendReason == REASON_CONCURRENT){
            RTW_INFO("==> %s: Set leaveAutoSuspendReason as REASON_UNKNOWN. \n", __func__); 
            pwrpriv->aspriv.leaveAutoSuspendReason = REASON_UNKNOWN;
        }
    }

	return;
}


void ex_autosuspend_watchdog_check_concurrent_state(_adapter *padapter)
{
    
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);
    u8 intf_up_num = 1, counter = 1;

    if(!dvobj->padapters[0]->bup)
       goto  block;

    if(dvobj->iface_nums <= 1)
        return;

    for(counter; counter < dvobj->iface_nums; counter++){  
        if(!dvobj->padapters[counter]->net_closed){
            /* RTW_INFO("==> %s: counter %d. \n", __func__, counter); */
            intf_up_num++;
        }    
    }

    if(intf_up_num==1)
        return;

block:
    if(aspriv_chk_as_state(pwrpriv, AS_NORMAL)){
#if CONFIG_AUTOSUSPEND_DEBUG        
        RTW_INFO("==> %s: Set Auto-suspend block. \n", __func__); 
#endif
        pwrpriv->aspriv.bInternalAutoBlock = AS_BLK_ALL;
    }else{ 
        pwrpriv->aspriv.leaveAutoSuspendReason = REASON_CONCURRENT;
#if CONFIG_AUTOSUSPEND_DEBUG        
        RTW_INFO("==> %s: Set leaveAutoSuspendReason as (%d). \n", __func__, pwrpriv->aspriv.leaveAutoSuspendReason);
#endif
    }
    
    //RTW_INFO("==> %s: pwrpriv->aspriv.bInternalAutoBlock %d. \n", __func__, pwrpriv->aspriv.bInternalAutoBlock); 

	return;
}

/*
	method 
		(1) : usb_write_data_not_xmitframe
		(0) : usb_write_data_rsvd_page_normal
	
*/
void ex_autosuspend_set_not_xmitframe_fw_dl(_adapter *padapter, u8 method )
{
	HAL_DATA_TYPE	*pHalData = GET_HAL_DATA(padapter);
	pHalData->not_xmitframe_fw_dl = method;
}

void ex_autosuspend_set_check_period(u8 *value)
{
	(*value) = 10;
}


int ex_autosuspend_dump_pm_cnt(struct dvobj_priv *dvobj, bool bdump)
{

	int pm_cnt = -100;

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(4, 4, 219))
		pm_cnt = atomic_read(&(dvobj->pusbintf->dev.power.usage_count));
#elif ((LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 32)) && (LINUX_VERSION_CODE < KERNEL_VERSION(4, 4, 219)))
		pm_cnt = atomic_read(&(dvobj->pusbintf->pm_usage_cnt));
#else
		pm_cnt = dvobj->pusbintf->pm_usage_cnt;
#endif

#if CONFIG_AUTOSUSPEND_DEBUG
	if(bdump) RTW_INFO("(as) ... pm_usage_cnt(%d).....\n", pm_cnt);
#endif 

	return pm_cnt;

}

bool ex_autosuspend_if_in_autosuspend(_adapter *padapter)
{
	return adapter_to_pwrctl(padapter)->bInternalAutoSuspend ;
}


bool ex_autosuspend_active_chk_alive(PADAPTER padapter){
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	struct sta_info *psta = NULL;
    struct sta_priv *pstapriv = &padapter->stapriv;
	bool ret = _TRUE;
	_irqL irqL;	
    _list   *plist, *phead;
    u8 bc_addr[ETH_ALEN] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};
	u32	i;
	u64 before_rx_probersp_pkts, after_rx_probersp_pkts;

	/*  Not to active check in 2.4G channel */
	if(pmlmeext->cur_channel < 14)
		return ret;
		
	
	_enter_critical_bh(&pstapriv->sta_hash_lock, &irqL);
    for (i = 0; i < NUM_STA; i++) {
		phead = &(pstapriv->sta_hash[i]);
		plist = get_next(phead);
		while ((rtw_end_of_queue_search(phead, plist)) == _FALSE) {
		    psta = LIST_CONTAINOR(plist, struct sta_info, hash_list);
		    if((psta != NULL) && (_rtw_memcmp(psta->cmn.mac_addr, bc_addr, ETH_ALEN) == _FALSE))
			break;
		    psta = NULL;
		    plist = get_next(plist);
		}
    }
    _exit_critical_bh(&pstapriv->sta_hash_lock, &irqL);	
	if(psta != NULL) {
		before_rx_probersp_pkts = sta_rx_probersp_pkts(psta);
		issue_probereq_ex(padapter, &pmlmeinfo->network.Ssid, pmlmeinfo->network.MacAddress, 0, 0, 0, 0);
		issue_probereq_ex(padapter, &pmlmeinfo->network.Ssid, pmlmeinfo->network.MacAddress, 0, 0, 0, 0);
		issue_probereq_ex(padapter, &pmlmeinfo->network.Ssid, pmlmeinfo->network.MacAddress, 0, 0, 0, 0);
		rtw_msleep_os(10);
		after_rx_probersp_pkts = sta_rx_probersp_pkts(psta);
		RTW_INFO("ex_autosuspend_active_chk_alive(): before = %llu, after = %llu\n",before_rx_probersp_pkts, after_rx_probersp_pkts);
		if((after_rx_probersp_pkts - before_rx_probersp_pkts) == 0)
			ret = _FALSE;
	}

	return ret;	
}

void ex_autosuspend_revise_receive_bcn_count(PADAPTER padapter, u8 *pframe) {
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	struct sta_info *psta = rtw_get_stainfo(&padapter->stapriv, get_addr2_ptr(pframe));
	if(psta != NULL)
		psta->sta_stats.rx_beacon_pkts--;
}

void ex_autosuspend_revise_receive_probersp_count(PADAPTER padapter, u8 *pframe, u32 packet_len) {
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	struct sta_info *psta = rtw_get_stainfo(&padapter->stapriv, get_addr2_ptr(pframe));
	struct rtw_ieee802_11_elems elems;
	struct HT_info_element *pht_info = NULL;
	int left;
	unsigned char *pos;

	if(!psta)
		return;

	/* checking IEs */
	left = packet_len - sizeof(struct rtw_ieee80211_hdr_3addr) - _BEACON_IE_OFFSET_;
	pos = pframe + sizeof(struct rtw_ieee80211_hdr_3addr) + _BEACON_IE_OFFSET_;
	if (rtw_ieee802_11_parse_elems(pos, left, &elems, 1) == ParseFailed)
		return ;

	if (elems.ht_operation) {
		if (elems.ht_operation_len != sizeof(*pht_info))
			return ;

		pht_info = (struct HT_info_element *) elems.ht_operation;
		RTW_INFO("current_channel = %d, pht_info->primary_channel = %d\n", dvobj->oper_channel, pht_info->primary_channel);
		if(dvobj->oper_channel != pht_info->primary_channel)
			psta->sta_stats.rx_probersp_pkts--;
	}
}

bool ex_autosuspend_check_retry_probersp(PADAPTER padapter, u8 *pframe, u32 packet_len) {
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	u16 previous_probersp_seq;
	unsigned char *addr3;
	bool ret = _FALSE;

	addr3 = GetAddr3Ptr(pframe);
	previous_probersp_seq=pmlmepriv->recv_probersp_seq;
	pmlmepriv->recv_probersp_seq = GetSequence(pframe);

	if((pmlmepriv->recv_probersp_seq == previous_probersp_seq)
		&& GetRetry(pframe)){

		RTW_INFO("%s current_channel = %d, seq=%d mac_addr ="MAC_FMT"\n",
				__func__,
				dvobj->oper_channel,
				pmlmepriv->recv_probersp_seq,
				MAC_ARG(addr3));

		return _TRUE;
	}
	return ret;
}

#endif  /* CONFIG_AUTOSUSPEND */

