
/*
   Copyright (C) 2019 Primax Corp Inc.
   Written 2019-2020 by Jacky Huang <jacky.huang@primax.com.tw>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as
   published by the Free Software Foundation;

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY RIGHTS.
   IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) AND AUTHOR(S) BE LIABLE FOR ANY
   CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
   WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
   ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

   ALL LIABILITY, INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PATENTS,
   COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS, RELATING TO USE OF THIS
   SOFTWARE IS DISCLAIMED.

   SKIP: SIGINT(2), SIGKILL(9), SIGSTOP(19), SIGTSTP(20)
*/
#ifndef _SIGCOMM_H
#define _SIGCOMM_H

#include <errno.h>
#include <signal.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>

#define SUCCESS                 (0)
#define FAIL                    (1)
#define SERVER_NAME             "simva.out"
#define GET_PID                 "pidof "SERVER_NAME

#define SIG_INDEX_START         (0)
#define SIG_DHCP_SUCCESS        (1)
#define SIG_DHCP_FAIL           (3)

#define SIG_AUTOIP_SUCCESS      (5)
#define SIG_AUTOIP_FAIL         (6)
#define SIG_AUTOIP_CONFLICT     (7)
#define SIG_AUTOIP_STOP         (8)

#define SIG_RACOON_SUCCESS      (10)
#define SIG_RACOON_FAIL         (12)
#define SIG_SETKEY_SUCCESS      (16)
#define SIG_SETKEY_FAIL         (18)

#define SIG_DHCPV6_SUCCESS      (23)
#define SIG_DHCPV6_FAIL         (26)

#define SIG_ARPING_SUCCESS      (30)
#define SIG_ARPING_FAIL         (31)
#define SIG_ARPING_STOP         (34)
#define SIG_ARPING_IPCHANGE     (35)

uint8_t signal_list[] = {
        SIG_DHCP_SUCCESS,
        SIG_DHCP_FAIL,
        SIG_AUTOIP_SUCCESS,
        SIG_AUTOIP_FAIL,
        SIG_AUTOIP_CONFLICT,
        SIG_AUTOIP_STOP,
        SIG_RACOON_SUCCESS,
        SIG_RACOON_FAIL,
        SIG_SETKEY_SUCCESS,
        SIG_SETKEY_FAIL,
        SIG_DHCPV6_SUCCESS,
        SIG_DHCPV6_FAIL,
        SIG_ARPING_SUCCESS,
        SIG_ARPING_FAIL,
        SIG_ARPING_STOP,
        SIG_ARPING_IPCHANGE,
};

char *signal_str_list[] = {
        "SIG_DHCP_SUCCESS",
        "SIG_DHCP_FAIL",
        "SIG_AUTOIP_SUCCESS",
        "SIG_AUTOIP_FAIL",
        "SIG_AUTOIP_CONFLICT",
        "SIG_AUTOIP_STOP",
        "SIG_RACOON_SUCCESS",
        "SIG_RACOON_FAIL",
        "SIG_SETKEY_SUCCESS",
        "SIG_SETKEY_FAIL",
        "SIG_DHCPV6_SUCCESS",
        "SIG_DHCPV6_FAIL",
        "SIG_ARPING_SUCCESS",
        "SIG_ARPING_FAIL",
        "SIG_ARPING_STOP",
        "SIG_ARPING_IPCHANGE",
};

typedef enum {
        SIG_NONE = 0,
        SIG_DHCP,
        SIG_AUTOIP,
        SIG_RACOON,
        SIG_SETKEY,
        SIG_DHCPV6,
        SIG_ARPING,
	SIG_MAX,
} SIG_CLASS_t;

typedef enum {
        SIG_SUCCESS = 0,
        SIG_FAIL,
} SIG_RET_t;
#endif // _SIGCOMM_H
