/*
 * A driver for the quasar power off 
 *
 * Copyright (c) 2014, 2015, The Linux Foundation. All rights reserved.
 *
 * Copyright (c) 2014 Cambridge Silicon Radio Ltd.
 * 
 * Copyright (c) 2017-2021, QBit Semiconductor LTD.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
// =========================================================
//
//  $DateTime: 2021/10/28 10:29:17 $
//  $Change: 54504 $
//
// =========================================================

#include <linux/delay.h>
#include <linux/err.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/io.h>
#include <linux/of.h>
#include <linux/platform_device.h>
#include <linux/module.h>
#include <linux/reboot.h>

#include <asm/system_misc.h>

static void __iomem *quasar_rstgenporpowerdown;

static void do_quasar_restart(enum reboot_mode reboot_mode, const char *cmd)
{
	// power control for 6600 -- reset
    printk("do_quasar_restart ...\n");
    mdelay(200);
    writel(0x05, quasar_rstgenporpowerdown);  // for RSTGEN_MISCCTRL
    //writel(0x01, quasar_rstgenporpowerdown);    // for RSTGEN_SWRSTPULSE1
}

static void do_quasar_poweroff(void)
{
	/* TODO: Add poweroff capability */
	do_quasar_restart(REBOOT_HARD, NULL);
}

static int quasar_restart_probe(struct platform_device *pdev)
{
	struct device *dev = &pdev->dev;
	struct resource *mem;

	mem = platform_get_resource(pdev, IORESOURCE_MEM, 0);
	quasar_rstgenporpowerdown = devm_ioremap_resource(dev, mem);
	if (IS_ERR(quasar_rstgenporpowerdown))
		return PTR_ERR(quasar_rstgenporpowerdown);

	pm_power_off = do_quasar_poweroff;
	arm_pm_restart = do_quasar_restart;
	return 0;
}

static const struct of_device_id of_quasar_restart_match[] = {
	{ .compatible = "qbit,quasar-rstgenporpowerdown", },
	{},
};
MODULE_DEVICE_TABLE(of, of_quasar_restart_match);

static struct platform_driver quasar_restart_driver = {
	.probe = quasar_restart_probe,
	.driver = {
		.name = "quasar-restart",
		.owner = THIS_MODULE,
		.of_match_table = of_match_ptr(of_quasar_restart_match),
	},
};

static int __init quasar_restart_init(void)
{
	return platform_driver_register(&quasar_restart_driver);
}
device_initcall(quasar_restart_init);
