/*
 * QBit Quasar PCIe host controller driver
 *
 * Copyright (c) 2014, 2015, The Linux Foundation. All rights reserved.
 *
 * Copyright (c) 2018, 2019, 2020 QBit Semiconductor LTD.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _PCIE_QUASAR_H
#define _PCIE_QUASAR_H

#define PCIE1_CFG_COMMAND_STATUS__BUS_MASTER__VALUE      0x00000004
#define PCIE1_CFG_COMMAND_STATUS__MEMORY_SPACE__VALUE    0x00000002
#define PCIE1_CFG_COMMAND_STATUS__IO_SPACE__VALUE        0x00000001

#define PCIE1_GPEXD_CFG_RDY__CFG_RDY__MASK               0x00000001

#define PCIE1_PAB_CTRL__ENABLE_AMBA_PIO__MASK            0x00000001
#define PCIE1_PAB_CTRL__ENABLE_PEX_PIO__MASK             0x00000002
#define PCIE1_PAB_CTRL__ENABLE_WDMA__MASK                0x00000004
#define PCIE1_PAB_CTRL__ENABLE_RDMA__MASK                0x00000008
#define PCIE1_PAB_CTRL__AXI_MAX_BURST_4__VALUE           0x00000010
#define PCIE1_PAB_CTRL__AXI_MAX_BURST_8__VALUE           0x00000020
#define PCIE1_PAB_CTRL__AXI_MAX_BURST_16__VALUE          0x00000030
#define PCIE1_PAB_CTRL__DESC_DEPTH_1__VALUE              0x00000000
#define PCIE1_PAB_CTRL__DESC_DEPTH_2__VALUE              0x00000100
#define PCIE1_PAB_CTRL__DESC_DEPTH_4__VALUE              0x00000200
#define PCIE1_PAB_CTRL__MAX_DMA_128__VALUE               0x00000000
#define PCIE1_PAB_CTRL__MAX_DMA_256__VALUE               0x00000400
#define PCIE1_PAB_CTRL__MAX_DMA_512__VALUE               0x00000800

#define PCIE1_PAB_AXI_PIO_CTRL0__PIO_ENABLE__MASK        0x00000001
#define PCIE1_PAB_AXI_PIO_CTRL0__MEM_WINDOW_ENABLE__MASK 0x00000002
#define PCIE1_PAB_AXI_PIO_CTRL0__IO_WINDOW_ENABLE__MASK  0x00000004
#define PCIE1_PAB_AXI_PIO_CTRL0__CFG_WINDOW_ENABLE__MASK 0x00000008

#define PCIE1_PAB_PEX_PIO_CTRL0__PIO_ENABLE__MASK        0x00000001

#define PCIE1_PAB_PEX_INT_STAT__AMBA_PIO_COMPLETE__MASK  0x00000001
#define PCIE1_PAB_PEX_INT_STAT__PEX_PIO_COMPLETE__MASK   0x00000004
#define PCIE1_PAB_PEX_INT_STAT__WDMA_COMPLETE__MASK      0x00000020
#define PCIE1_PAB_PEX_INT_STAT__RDMA_COMPLETE__MASK      0x00000100
#define PCIE1_PAB_PEX_INT_STAT__MAILBOX_READY__MASK      0x00000400

#define PCIE1_PAB_PEX_AMAP_BAR__ENABLE__VALUE            0x00000001

#define PCIE1_PAB_AXI_INT_PIO_EN__AMBA_PIO__MASK         0x00000001
#define PCIE1_PAB_AXI_INT_PIO_EN__PEX_PIO__MASK          0x00010000

#define	PCIE1_PAB_AXI_INT_MISC_EN__MAILBOX__MASK         0x00000001
#define	PCIE1_PAB_AXI_INT_MISC_EN__MSI__MASK             0x00000008
#define	PCIE1_PAB_AXI_INT_MISC_EN__PEX_INTA__MASK        0x00000020
#define	PCIE1_PAB_AXI_INT_MISC_EN__PEX_INTB__MASK        0x00000040
#define	PCIE1_PAB_AXI_INT_MISC_EN__PEX_INTC__MASK        0x00000080
#define	PCIE1_PAB_AXI_INT_MISC_EN__PEX_INTD__MASK        0x00000100

#define PCIE1_PAB_AXI_INT_PIO_STAT__AMBA_PIO__MASK       0x00000001
#define PCIE1_PAB_AXI_INT_PIO_STAT__PEX_PIO__MASK        0x00010000
#define PCIE1_PAB_AXI_INT_PIO_STAT__AMBA_PIO_COMPLETE__MASK 0x00000001
#define PCIE1_PAB_AXI_INT_PIO_STAT__PEX_PIO_COMPLETE__MASK  0x00010000

#define PCIE1_PAB_AXI_INT_WDMA_STAT__WDMA_COMPLETE__MASK 0x00000100
#define PCIE1_PAB_AXI_INT_RDMA_STAT__RDMA_COMPLETE__MASK 0x00000100

#define PWR_ON_W1   0x00000001
#define PWR_ON_W2   0x00000002
#define PWR_ON_S1   0x00010000
#define WAIT_TIME   50
#define PWR_WAIT_TIMEOUT_LOOP \
		if (--timeout == 0) { printk("PCIe host PWR_TIMEOUT!\n"); return; }

/* PHY parameters */
#define PHY_PARAM00_ADDR     (0x00)
#define PHY_PARAM01_ADDR     (0x01)
#define PHY_PARAM02_ADDR     (0x02)
#define PHY_PARAM03_ADDR     (0x03)
#define PHY_PARAM04_ADDR     (0x04)
#define PHY_PARAM05_ADDR     (0x05)
#define PHY_PARAM06_ADDR     (0x06)
#define PHY_PARAM07_ADDR     (0x07)
#define PHY_PARAM08_ADDR     (0x08)
#define PHY_PARAM09_ADDR     (0x09)
#define PHY_PARAM10_ADDR     (0x0A)
#define PHY_PARAM11_ADDR     (0x0B)
#define PHY_PARAM12_ADDR     (0x0C)
#define PHY_PARAM13_ADDR     (0x0D)
#define PHY_PARAM14_ADDR     (0x0E)
#define PHY_PARAM15_ADDR     (0x0F)
#define PHY_PARAM16_ADDR     (0x10)
#define PHY_PARAM17_ADDR     (0x11)
#define PHY_PARAM18_ADDR     (0x12)
#define PHY_PARAM19_ADDR     (0x13)
#define PHY_PARAM20_ADDR     (0x14)
#define PHY_PARAM21_ADDR     (0x15)
#define PHY_PARAM22_ADDR     (0x16)
#define PHY_PARAM23_ADDR     (0x17)
#define PHY_PARAM24_ADDR     (0x18)
#define PHY_PARAM25_ADDR     (0x19)
#define PHY_PARAM26_ADDR     (0x1A)
#define PHY_PARAM27_ADDR     (0x1B)
#define PHY_PARAM28_ADDR     (0x1C)
#define PHY_PARAM29_ADDR     (0x1D)
#define PHY_PARAM30_ADDR     (0x1E)
#define PHY_PARAM31_ADDR     (0x1F)

#endif /* _PCIE_QUASAR_H */
