/*
 * SDHCI Support for Quasar Soc
 *
 * Copyright (c) 2014, 2015, The Linux Foundation. All rights reserved.
 *
 * Copyright (c) 2014 Cambridge Silicon Radio Ltd.
 * 
 * Copyright (c) 2017-2018, QBit Semiconductor LTD.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
// =========================================================
//
//  $DateTime: 2021/10/28 10:29:17 $
//  $Change: 54504 $
//
// =========================================================
#ifndef _DRIVERS_MMC_SDHCI_QUASAR_H
#define _DRIVERS_MMC_SDHCI_QUASAR_H

#define SD0     0
#define SD1     1
#define SD2     2

/* SDIO0 Clk Disable Control */
#define SDIO0CLKDISCTRL_OFF       0x00000040
#define SDIO0CLKDISCTRL           0x04008040
#define SDIO0CLKDISCTRL__SDIO0_SDM4__SHIFT       0
#define SDIO0CLKDISCTRL__SDIO0_SDM4__WIDTH       1
#define SDIO0CLKDISCTRL__SDIO0_SDM4__MASK        0x00000001
#define SDIO0CLKDISCTRL__SDIO0_SDM4__INV_MASK    0xFFFFFFFE
#define SDIO0CLKDISCTRL__SDIO0_SDM4__HW_DEFAULT  0x0

/* SDIO0 Clk Disable Status */
#define SDIO0CLKDISSTAT_OFF       0x00000044
#define SDIO0CLKDISSTAT           0x04008044
#define SDIO0CLKDISSTAT__SDIO0_SDM4__SHIFT       0
#define SDIO0CLKDISSTAT__SDIO0_SDM4__WIDTH       1
#define SDIO0CLKDISSTAT__SDIO0_SDM4__MASK        0x00000001
#define SDIO0CLKDISSTAT__SDIO0_SDM4__INV_MASK    0xFFFFFFFE
#define SDIO0CLKDISSTAT__SDIO0_SDM4__HW_DEFAULT  0x0

/* SDIO0_SDM4 Clk Divider Control */
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4_OFF 0x000000AC
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4 0x041110AC
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__NEG_PWL_START__SHIFT       24
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__NEG_PWL_START__WIDTH       4
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__NEG_PWL_START__MASK        0x0F000000
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__NEG_PWL_START__INV_MASK    0xF0FFFFFF
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__NEG_PWL_START__HW_DEFAULT  0x0
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__NEG_PWH_START__SHIFT       16
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__NEG_PWH_START__WIDTH       4
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__NEG_PWH_START__MASK        0x000F0000
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__NEG_PWH_START__INV_MASK    0xFFF0FFFF
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__NEG_PWH_START__HW_DEFAULT  0x0
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__POS_PWL_START__SHIFT       8
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__POS_PWL_START__WIDTH       4
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__POS_PWL_START__MASK        0x00000F00
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__POS_PWL_START__INV_MASK    0xFFFFF0FF
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__POS_PWL_START__HW_DEFAULT  0x0
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__DIV_VALUE__SHIFT       0
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__DIV_VALUE__WIDTH       4
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__DIV_VALUE__MASK        0x0000000F
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__DIV_VALUE__INV_MASK    0xFFFFFFF0
#define SYSCG_CLKDIVCTRL_SDIO0_SDM4__DIV_VALUE__HW_DEFAULT  0x1

#define SYSCG_CLKMUXCTRL1__SDIO2_SDM4__SHIFT       12
#define SYSCG_CLKMUXCTRL1__SDIO2_SDM4__WIDTH       1
#define SYSCG_CLKMUXCTRL1__SDIO2_SDM4__MASK        0x00001000
#define SYSCG_CLKMUXCTRL1__SDIO2_SDM4__INV_MASK    0xFFFFEFFF
#define SYSCG_CLKMUXCTRL1__SDIO2_SDM4__HW_DEFAULT  0x0
#define SYSCG_CLKMUXCTRL1__SDIO1_SDM4__SHIFT       11
#define SYSCG_CLKMUXCTRL1__SDIO1_SDM4__WIDTH       1
#define SYSCG_CLKMUXCTRL1__SDIO1_SDM4__MASK        0x00000800
#define SYSCG_CLKMUXCTRL1__SDIO1_SDM4__INV_MASK    0xFFFFF7FF
#define SYSCG_CLKMUXCTRL1__SDIO1_SDM4__HW_DEFAULT  0x0
#define SYSCG_CLKMUXCTRL1__SDIO0_SDM4__SHIFT       10
#define SYSCG_CLKMUXCTRL1__SDIO0_SDM4__WIDTH       1
#define SYSCG_CLKMUXCTRL1__SDIO0_SDM4__MASK        0x00000400
#define SYSCG_CLKMUXCTRL1__SDIO0_SDM4__INV_MASK    0xFFFFFBFF
#define SYSCG_CLKMUXCTRL1__SDIO0_SDM4__HW_DEFAULT  0x0

/* SDIO0 External Control Register */
#define SDIO0_EXTCTL_OFF          0x000000A0
#define SDIO0_EXTCTL              0x040080A0
#define SDIO0_EXTCTL__WP__SHIFT       9
#define SDIO0_EXTCTL__WP__WIDTH       1
#define SDIO0_EXTCTL__WP__MASK        0x00000200
#define SDIO0_EXTCTL__WP__INV_MASK    0xFFFFFDFF
#define SDIO0_EXTCTL__WP__HW_DEFAULT  0x1
#define SDIO0_EXTCTL__WP_OVL__SHIFT       8
#define SDIO0_EXTCTL__WP_OVL__WIDTH       1
#define SDIO0_EXTCTL__WP_OVL__MASK        0x00000100
#define SDIO0_EXTCTL__WP_OVL__INV_MASK    0xFFFFFEFF
#define SDIO0_EXTCTL__WP_OVL__HW_DEFAULT  0x0
#define SDIO0_EXTCTL__CD__SHIFT       5
#define SDIO0_EXTCTL__CD__WIDTH       1
#define SDIO0_EXTCTL__CD__MASK        0x00000020
#define SDIO0_EXTCTL__CD__INV_MASK    0xFFFFFFDF
#define SDIO0_EXTCTL__CD__HW_DEFAULT  0x0
#define SDIO0_EXTCTL__CD_OVL__SHIFT       4
#define SDIO0_EXTCTL__CD_OVL__WIDTH       1
#define SDIO0_EXTCTL__CD_OVL__MASK        0x00000010
#define SDIO0_EXTCTL__CD_OVL__INV_MASK    0xFFFFFFEF
#define SDIO0_EXTCTL__CD_OVL__HW_DEFAULT  0x0
#define SDIO0_EXTCTL__CLE__SHIFT       1
#define SDIO0_EXTCTL__CLE__WIDTH       1
#define SDIO0_EXTCTL__CLE__MASK        0x00000002
#define SDIO0_EXTCTL__CLE__INV_MASK    0xFFFFFFFD
#define SDIO0_EXTCTL__CLE__HW_DEFAULT  0x0
#define SDIO0_EXTCTL__CLE_OVL__SHIFT       0
#define SDIO0_EXTCTL__CLE_OVL__WIDTH       1
#define SDIO0_EXTCTL__CLE_OVL__MASK        0x00000001
#define SDIO0_EXTCTL__CLE_OVL__INV_MASK    0xFFFFFFFE
#define SDIO0_EXTCTL__CLE_OVL__HW_DEFAULT  0x0

#define VENDOR_AHB_CONFIG_OFFSET                           0x0100
#define VENDOR_SWITCHING_OFFSET                            0x0104
#define VENDOR_TUNING_SETTING_OFFSET                       0x0108
#define  VENDOR_TUNING_SETTING_CCCD                       0x10000 
#define VENDOR_TUNING_STATUS_OFFSET                        0x010C
#define VENDOR_IO_CONTROL_2_OFFSET                         0x0114
#define VENDOR_POWER_SW_INTERRUPT_STATUS_OFFSET            0x0118
#define VENDOR_POWER_SW_INTERRUPT_STATUS_ENABLE_OFFSET     0x011C
#define VENDOR_POWER_SW_INTERRUPT_SIGNAL_ENABLE_OFFSET     0x0120
#define VENDOR_MMC_CONTROL_OFFSET                          0x0124
#define VENDOR_MMC_WAIT_IRQ_CONTROL_LOW_OFFSET             0x0128
#define VENDOR_MMC_WAIT_IRQ_CONTROL_HIGH_OFFSET            0x012C
#define VENDOR_MMC_R3_CHECK_BIT_OFFSET                     0x0130
#define VENDOR_CD_SETTING_OFFSET                           0x0154
#define VENDOR_FORCECI_CONTROL_OFFSET                      0x0158
#define VENDOR_RESET_CONTROL_OFFSET                        0x0200
#define VENDOR_INIT_STATUS_OFFSET                          0x0214
#define VENDOR_CDR_DTIMEC_SHIFT                            0x8
#define VENDOR_FORCECI_EN                                  0x40
#define VENDOR_RST_STATUS                                  0x1
#define VENDOR_BCLK_10_CYCLE                               0x2

#define VENDOR_MACRO_CARD_DETECT                            0x0354
#define RST_STATUS                                          0x1
#define BCLK_10_CYCLE                                       0x2


/* IO SD0D0 Configuration Register */
#define IOCTL_SD0D0_OFF           0x000000CC
#define IOCTL_SD0D0               0x0410F0CC
#define IOCTL_SD0D0__OEN__SHIFT       18
#define IOCTL_SD0D0__OEN__WIDTH       1
#define IOCTL_SD0D0__OEN__MASK        0x00040000
#define IOCTL_SD0D0__OEN__INV_MASK    0xFFFBFFFF
#define IOCTL_SD0D0__OEN__HW_DEFAULT  undefined
#define IOCTL_SD0D0__OUT__SHIFT       17
#define IOCTL_SD0D0__OUT__WIDTH       1
#define IOCTL_SD0D0__OUT__MASK        0x00020000
#define IOCTL_SD0D0__OUT__INV_MASK    0xFFFDFFFF
#define IOCTL_SD0D0__OUT__HW_DEFAULT  undefined
#define IOCTL_SD0D0__IN__SHIFT       16
#define IOCTL_SD0D0__IN__WIDTH       1
#define IOCTL_SD0D0__IN__MASK        0x00010000
#define IOCTL_SD0D0__IN__INV_MASK    0xFFFEFFFF
#define IOCTL_SD0D0__IN__HW_DEFAULT  undefined
#define IOCTL_SD0D0__P__SHIFT       5
#define IOCTL_SD0D0__P__WIDTH       2
#define IOCTL_SD0D0__P__MASK        0x00000060
#define IOCTL_SD0D0__P__INV_MASK    0xFFFFFF9F
#define IOCTL_SD0D0__P__HW_DEFAULT  0x2
#define IOCTL_SD0D0__E__SHIFT       3
#define IOCTL_SD0D0__E__WIDTH       2
#define IOCTL_SD0D0__E__MASK        0x00000018
#define IOCTL_SD0D0__E__INV_MASK    0xFFFFFFE7
#define IOCTL_SD0D0__E__HW_DEFAULT  0x0
#define IOCTL_SD0D0__SR__SHIFT       2
#define IOCTL_SD0D0__SR__WIDTH       1
#define IOCTL_SD0D0__SR__MASK        0x00000004
#define IOCTL_SD0D0__SR__INV_MASK    0xFFFFFFFB
#define IOCTL_SD0D0__SR__HW_DEFAULT  0x0
#define IOCTL_SD0D0__REN__SHIFT       1
#define IOCTL_SD0D0__REN__WIDTH       1
#define IOCTL_SD0D0__REN__MASK        0x00000002
#define IOCTL_SD0D0__REN__INV_MASK    0xFFFFFFFD
#define IOCTL_SD0D0__REN__HW_DEFAULT  0x1
#define IOCTL_SD0D0__SMT__SHIFT       0
#define IOCTL_SD0D0__SMT__WIDTH       1
#define IOCTL_SD0D0__SMT__MASK        0x00000001
#define IOCTL_SD0D0__SMT__INV_MASK    0xFFFFFFFE
#define IOCTL_SD0D0__SMT__HW_DEFAULT  0x1

/* IO Segment Active High 1.8V range select */
#define SEL18_CTL_OFF             0x000002DC
#define SEL18_CTL                 0x0410F2DC
#define SEL18_CTL__SPI1__SHIFT       14
#define SEL18_CTL__SPI1__WIDTH       1
#define SEL18_CTL__SPI1__MASK        0x00004000
#define SEL18_CTL__SPI1__INV_MASK    0xFFFFBFFF
#define SEL18_CTL__SPI1__HW_DEFAULT  0x0
#define SEL18_CTL__AM__SHIFT       13
#define SEL18_CTL__AM__WIDTH       1
#define SEL18_CTL__AM__MASK        0x00002000
#define SEL18_CTL__AM__INV_MASK    0xFFFFDFFF
#define SEL18_CTL__AM__HW_DEFAULT  0x0
#define SEL18_CTL__GP0__SHIFT       12
#define SEL18_CTL__GP0__WIDTH       1
#define SEL18_CTL__GP0__MASK        0x00001000
#define SEL18_CTL__GP0__INV_MASK    0xFFFFEFFF
#define SEL18_CTL__GP0__HW_DEFAULT  0x0
#define SEL18_CTL__GP1__SHIFT       11
#define SEL18_CTL__GP1__WIDTH       1
#define SEL18_CTL__GP1__MASK        0x00000800
#define SEL18_CTL__GP1__INV_MASK    0xFFFFF7FF
#define SEL18_CTL__GP1__HW_DEFAULT  0x0
#define SEL18_CTL__GP2__SHIFT       10
#define SEL18_CTL__GP2__WIDTH       1
#define SEL18_CTL__GP2__MASK        0x00000400
#define SEL18_CTL__GP2__INV_MASK    0xFFFFFBFF
#define SEL18_CTL__GP2__HW_DEFAULT  0x0
#define SEL18_CTL__RGMI0__SHIFT       9
#define SEL18_CTL__RGMI0__WIDTH       1
#define SEL18_CTL__RGMI0__MASK        0x00000200
#define SEL18_CTL__RGMI0__INV_MASK    0xFFFFFDFF
#define SEL18_CTL__RGMI0__HW_DEFAULT  0x0
#define SEL18_CTL__RGMI1__SHIFT       8
#define SEL18_CTL__RGMI1__WIDTH       1
#define SEL18_CTL__RGMI1__MASK        0x00000100
#define SEL18_CTL__RGMI1__INV_MASK    0xFFFFFEFF
#define SEL18_CTL__RGMI1__HW_DEFAULT  0x0
#define SEL18_CTL__QSPI__SHIFT       7
#define SEL18_CTL__QSPI__WIDTH       1
#define SEL18_CTL__QSPI__MASK        0x00000080
#define SEL18_CTL__QSPI__INV_MASK    0xFFFFFF7F
#define SEL18_CTL__QSPI__HW_DEFAULT  0x0
#define SEL18_CTL__DPIO__SHIFT       6
#define SEL18_CTL__DPIO__WIDTH       1
#define SEL18_CTL__DPIO__MASK        0x00000040
#define SEL18_CTL__DPIO__INV_MASK    0xFFFFFFBF
#define SEL18_CTL__DPIO__HW_DEFAULT  0x0
#define SEL18_CTL__SD0__SHIFT       5
#define SEL18_CTL__SD0__WIDTH       1
#define SEL18_CTL__SD0__MASK        0x00000020
#define SEL18_CTL__SD0__INV_MASK    0xFFFFFFDF
#define SEL18_CTL__SD0__HW_DEFAULT  0x0
#define SEL18_CTL__SD1__SHIFT       4
#define SEL18_CTL__SD1__WIDTH       1
#define SEL18_CTL__SD1__MASK        0x00000010
#define SEL18_CTL__SD1__INV_MASK    0xFFFFFFEF
#define SEL18_CTL__SD1__HW_DEFAULT  0x0
#define SEL18_CTL__SD2__SHIFT       3
#define SEL18_CTL__SD2__WIDTH       1
#define SEL18_CTL__SD2__MASK        0x00000008
#define SEL18_CTL__SD2__INV_MASK    0xFFFFFFF7
#define SEL18_CTL__SD2__HW_DEFAULT  0x0
#define SEL18_CTL__PRI__SHIFT       2
#define SEL18_CTL__PRI__WIDTH       1
#define SEL18_CTL__PRI__MASK        0x00000004
#define SEL18_CTL__PRI__INV_MASK    0xFFFFFFFB
#define SEL18_CTL__PRI__HW_DEFAULT  0x0
#define SEL18_CTL__LCD__SHIFT       1
#define SEL18_CTL__LCD__WIDTH       1
#define SEL18_CTL__LCD__MASK        0x00000002
#define SEL18_CTL__LCD__INV_MASK    0xFFFFFFFD
#define SEL18_CTL__LCD__HW_DEFAULT  0x0
#define SEL18_CTL__SCA__SHIFT       0
#define SEL18_CTL__SCA__WIDTH       1
#define SEL18_CTL__SCA__MASK        0x00000001
#define SEL18_CTL__SCA__INV_MASK    0xFFFFFFFE
#define SEL18_CTL__SCA__HW_DEFAULT  0x0

/* IO SD0CMD Configuration Register */
#define IOCTL_SD0CMD_OFF          0x000000C0
#define IOCTL_SD0CMD              0x0410F0C0
#define IOCTL_SD0CMD__OEN__SHIFT       18
#define IOCTL_SD0CMD__OEN__WIDTH       1
#define IOCTL_SD0CMD__OEN__MASK        0x00040000
#define IOCTL_SD0CMD__OEN__INV_MASK    0xFFFBFFFF
#define IOCTL_SD0CMD__OEN__HW_DEFAULT  undefined
#define IOCTL_SD0CMD__OUT__SHIFT       17
#define IOCTL_SD0CMD__OUT__WIDTH       1
#define IOCTL_SD0CMD__OUT__MASK        0x00020000
#define IOCTL_SD0CMD__OUT__INV_MASK    0xFFFDFFFF
#define IOCTL_SD0CMD__OUT__HW_DEFAULT  undefined
#define IOCTL_SD0CMD__IN__SHIFT       16
#define IOCTL_SD0CMD__IN__WIDTH       1
#define IOCTL_SD0CMD__IN__MASK        0x00010000
#define IOCTL_SD0CMD__IN__INV_MASK    0xFFFEFFFF
#define IOCTL_SD0CMD__IN__HW_DEFAULT  undefined
#define IOCTL_SD0CMD__P__SHIFT       5
#define IOCTL_SD0CMD__P__WIDTH       2
#define IOCTL_SD0CMD__P__MASK        0x00000060
#define IOCTL_SD0CMD__P__INV_MASK    0xFFFFFF9F
#define IOCTL_SD0CMD__P__HW_DEFAULT  0x2
#define IOCTL_SD0CMD__E__SHIFT       3
#define IOCTL_SD0CMD__E__WIDTH       2
#define IOCTL_SD0CMD__E__MASK        0x00000018
#define IOCTL_SD0CMD__E__INV_MASK    0xFFFFFFE7
#define IOCTL_SD0CMD__E__HW_DEFAULT  0x0
#define IOCTL_SD0CMD__SR__SHIFT       2
#define IOCTL_SD0CMD__SR__WIDTH       1
#define IOCTL_SD0CMD__SR__MASK        0x00000004
#define IOCTL_SD0CMD__SR__INV_MASK    0xFFFFFFFB
#define IOCTL_SD0CMD__SR__HW_DEFAULT  0x0
#define IOCTL_SD0CMD__REN__SHIFT       1
#define IOCTL_SD0CMD__REN__WIDTH       1
#define IOCTL_SD0CMD__REN__MASK        0x00000002
#define IOCTL_SD0CMD__REN__INV_MASK    0xFFFFFFFD
#define IOCTL_SD0CMD__REN__HW_DEFAULT  0x1
#define IOCTL_SD0CMD__SMT__SHIFT       0
#define IOCTL_SD0CMD__SMT__WIDTH       1
#define IOCTL_SD0CMD__SMT__MASK        0x00000001
#define IOCTL_SD0CMD__SMT__INV_MASK    0xFFFFFFFE
#define IOCTL_SD0CMD__SMT__HW_DEFAULT  0x1

/* SYS Spare Register */
#define SYS_SPARE_OFF             0x00000200
#define SYS_SPARE                 0x04008200
#define SYS_SPARE__HIGH__SHIFT       16
#define SYS_SPARE__HIGH__WIDTH       16
#define SYS_SPARE__HIGH__MASK        0xFFFF0000
#define SYS_SPARE__HIGH__INV_MASK    0x0000FFFF
#define SYS_SPARE__HIGH__HW_DEFAULT  0xFFFF
#define SYS_SPARE__LOW__SHIFT       0
#define SYS_SPARE__LOW__WIDTH       16
#define SYS_SPARE__LOW__MASK        0x0000FFFF
#define SYS_SPARE__LOW__INV_MASK    0xFFFF0000
#define SYS_SPARE__LOW__HW_DEFAULT  0x0

/* DDR Spare */
#define DDRGPF_DDR_SPARE_OFF      0x00000010
#define DDRGPF_DDR_SPARE          0x04109010
#define DDRGPF_DDR_SPARE__HIGH__SHIFT       16
#define DDRGPF_DDR_SPARE__HIGH__WIDTH       16
#define DDRGPF_DDR_SPARE__HIGH__MASK        0xFFFF0000
#define DDRGPF_DDR_SPARE__HIGH__INV_MASK    0x0000FFFF
#define DDRGPF_DDR_SPARE__HIGH__HW_DEFAULT  0xFFFF
#define DDRGPF_DDR_SPARE__LOW__SHIFT       0
#define DDRGPF_DDR_SPARE__LOW__WIDTH       16
#define DDRGPF_DDR_SPARE__LOW__MASK        0x0000FFFF
#define DDRGPF_DDR_SPARE__LOW__INV_MASK    0xFFFF0000
#define DDRGPF_DDR_SPARE__LOW__HW_DEFAULT  0x0

#endif /* _DRIVERS_MMC_SDHCI_QUASAR_H */
