/*
 * arch/arm/mach-quasar/quasar_pm.S
 *
 * A driver for the low power for Quasar SOCs
 *
 * Copyright (c) 2014 - 2016 Linux Foundation.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */
#include <linux/linkage.h>
#include <linux/init.h>
#include <asm/cp15.h>

    .align 2
    .text
    .arch_extension sec
    .pushsection .idmap.text, "ax"

    .equ    MODE_MASK, 0x1F     /*  Processor Mode Mask*/
    .equ    MON_MODE, 0x16      /*  Monitor Mode (MON)*/    
ENTRY(BIOSSetCp15MVBARReg)
BIOSSetCp15MVBARReg:
    // r0: mvbar
    // r1: SP for monitor mode
    //
    push    {r3}
    // Set up MVBAR
    mcr p15, 0, r0, c12, c0, 1  @Set MVBAR
    isb
    mrs r3, CPSR                /*  Pickup current CPSR*/
    bic ip, r3, #MODE_MASK      /*  Clear the mode bits*/
    orr ip, ip, #MON_MODE       /*  Set the MON mode bits*/
    msr CPSR_cxsf, ip           /*  Switch to the MON mode*/
    isb
    // Set SP on monitor mode
    mov sp, r1
    
    isb
    msr CPSR_cxsf, r3           /*  Restore caller's mode*/
    pop {r3}
    bx lr
ENDPROC(BIOSSetCp15MVBARReg)      
    
ENTRY(BIOSSetCp15Nonsecure)
    smc #0
    bx  lr
ENDPROC(BIOSSetCp15Nonsecure)  

ENTRY(BIOSSetCp15Secure)
BIOSSetCp15Secure:
    smc #1
    bx  lr
ENDPROC(BIOSSetCp15Secure)    

ENTRY(BIOSMonContextSave)
BIOSMonContextSave:
    smc #2
    bx  lr
ENDPROC(BIOSMonContextSave) 

ENTRY(BIOSMonContextRestore)
BIOSMonContextRestore:
    smc #3
    bx  lr
ENDPROC(BIOSMonContextRestore) 
               
ENTRY(BIOSflushDcache)       
/* BIOSflushDcache(void) */     /* Note this ALSO invalidates */
BIOSflushDcache:
    PUSH    {r0-r12}
    MRC     p15, 1, r0, c0, c0, 1   /*; Read CLIDR */
    ANDS    r3, r0, #0x07000000     /*; Extract coherency level */
    MOV     r3, r3, LSR #23         /*; Total cache levels << 1 */
    BEQ     IDFfinished             /*; If 0, no need to clean */

    MOV     r10, #0                 /*; R10 holds current cache level << 1 */
IDFLoop1:
    ADD     r2, r10, r10, LSR #1    /*; R2 holds cache "Set" position */
    MOV     r1, r0, LSR r2          /*; Bottom 3 bits are the Cache-type for this level */
    AND     r1, r1, #7              /*; Isolate those lower 3 bits */
    CMP     r1, #2
    BLT     IDFSkip                 /*; No cache or only instruction cache at this level */

    MCR     p15, 2, r10, c0, c0, 0  /*; Write the Cache Size selection register */
    ISB                             /*; ISB to sync the change to the CacheSizeID reg */
    MRC     p15, 1, r1, c0, c0, 0   /*; Reads current Cache Size ID register */
    AND     r2, r1, #7              /*; Extract the line length field */
    ADD     r2, r2, #4              /*; Add 4 for the line length offset (log2 16 bytes) */
    LDR     r4, =0x3FF
    ANDS    r4, r4, r1, LSR #3      /*; R4 is the max number on the way size (right aligned) */
    CLZ     r5, r4                  /*; R5 is the bit position of the way size increment */
    LDR     r7, =0x7FFF
    ANDS    r7, r7, r1, LSR #13     /*; R7 is the max number of the index size (right aligned) */

IDFLoop2:
    MOV     r9, r4                  /*; R9 working copy of the max way size (right aligned) */

IDFLoop3:
    ORR     r11, r10, r9, LSL r5    /*; Factor in the Way number and cache number into R11 */
    ORR     r11, r11, r7, LSL r2    /*; Factor in the Set number */
    MCR     p15, 0, r11, c7, c14, 2 /*; Clean and Invalidate by Set/Way */
    SUBS    r9, r9, #1              /*; Decrement the Way number */
    BGE     IDFLoop3
    SUBS    r7, r7, #1              /*; Decrement the Set number */
    BGE     IDFLoop2
IDFSkip:
    ADD     r10, r10, #2            /*; increment the cache number */
    CMP     r3, r10
    BGT     IDFLoop1
IDFfinished:
    POP     {r0-r12}
    DSB
    BX      lr
ENDPROC(BIOSflushDcache)
       
ENTRY(BIOSshutdownA7)
// A7 UG shutdown step 1
    MRC     p15, #0, r0, c1, c0, #0 /* Read SCTLR */
	bic	r0, r0, #0x4
    MCR     p15, #0, r0, c1, c0, #0 /* Write SCTLR */
// A7 UG shutdown step 2
	BL	BIOSflushDcache
// A7 UG shutdown step 3
	CLREX
// A7 UG shutdown step 4
    MRC     p15, #0, r0, c1, c0, #1 /* Read ACTLR */
	bic	r0, r0, #0x40
    MCR     p15, #0, r0, c1, c0, #1 /* Write ACTLR */
// A7 UG shutdown step 5
	isb
// A7 UG shutdown step 6
	dsb
// A7 UG shutdown step 7
	wfi
	BX	lr
ENDPROC(BIOSshutdownA7)  

    .popsection

    

