/*
 * arch/arm/mach-quasar/quasar.h
 *
 * Copyright (c) 2014, 2015 Linux Foundation.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef __QUASAR_H__
#define __QUASAR_H__

#include <linux/init.h>
#include <linux/reboot.h>

#include <asm/mach/time.h>
#include <asm/exception.h>

extern struct smp_operations   quasar_smp_ops;
extern void quasar_secondary_startup(void);
extern void quasar_cpu_die(unsigned int cpu);

extern void __init quasar_of_irq_init(void);
extern asmlinkage void __exception_irq_entry quasar_handle_irq(struct pt_regs *regs);

#ifdef CONFIG_PM_SLEEP
extern void __init quasar_pm_init(void);
#else
static inline void quasar_pm_init(void) {}
#endif

#endif
