/*
 * arch/arm/mach-quasar/quasar.c
 *
 * Copyright (c) 2014 - 2016 Linux Foundation.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <linux/init.h>
#include <linux/kernel.h>
#include <asm/sizes.h>
#include <asm/mach-types.h>
#include <asm/mach/arch.h>
#include <linux/of.h>
#include <linux/of_address.h>
#include <linux/of_platform.h>
#include <asm/mcpm.h>
#include "quasar.h"
#include <asm/mach/map.h>

static void __init quasar_init_machine(void)
{
	of_platform_populate(NULL, of_default_bus_match_table, NULL, NULL);
}

#ifdef CONFIG_SOC_QUASAR6300
static const char *quasar6300_dt_match[] __initconst = {
	"qbit,quasar-6300",
	NULL
};

#ifdef CONFIG_SMP
static void __init quasar63xx_smp_init_cpus(void)
{
	int index;
	for (index=0; index<2; index++) {
		set_cpu_possible(index, true);
	}
}

static bool __init quasar63xx_smp_init_ops(void)
{
#ifdef CONFIG_MCPM    
	struct device_node *node;
	node = of_find_compatible_node(NULL, NULL, "arm,cci-400");
	if (node && of_device_is_available(node)) {
		mcpm_smp_set_ops();     
		return true;
	} 
#endif    
	return false;
}
#endif

#ifdef CONFIG_SUSPEND  
static void __init quasar6300_init_late(void)
{
	quasar_pm_init();
}
#endif

#ifdef CONFIG_SMP
struct smp_operations __initdata quasar63xx_smp_ops = {
	.smp_init_cpus		= quasar63xx_smp_init_cpus,
};
#endif

DT_MACHINE_START(QUASAR6300_DT, "QBit 6300 (Flattened Device Tree)")
	.init_machine	= quasar_init_machine,
	.dt_compat      = quasar6300_dt_match,
#ifdef CONFIG_SMP    
#ifdef CONFIG_MCPM 
	.smp		= smp_ops(quasar63xx_smp_ops),
#else    
	.smp		= smp_ops(quasar_smp_ops),
#endif    
	.smp_init	= smp_init_ops(quasar63xx_smp_init_ops),
#endif
#ifdef CONFIG_SUSPEND  
	.init_late	= quasar6300_init_late,
#endif	
MACHINE_END
#endif
