/*
 * arch/arm/mach-quasar/pm.c
 *
 * Copyright (c) 2014 - 2016 Linux Foundation.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <linux/string.h>
#include <linux/delay.h>
#include <linux/init.h>
#include <linux/suspend.h>
#include <linux/syscore_ops.h>
#include <linux/cpu_pm.h>
#include <linux/io.h>
#include <linux/irqchip/arm-gic.h>
#include <linux/err.h>
#include <linux/clk.h>

#include <asm/cacheflush.h>
#include <asm/hardware/cache-l2x0.h>
#include <asm/smp_scu.h>
#include <asm/suspend.h>
#include <asm/idmap.h>

#include "quasar.h"
#include "core.h"

#define RESTOREWRREG_U32(p,c)   (*((volatile u32 *)(p)) = ((u32)(c)))
#define UART2THR                0x04140000
#define UART_THR                UART2THR
static int quasar_sleep_cpu(unsigned long v2p) __attribute__ ((section (".idmap.text")));
static int quasar_sleep_cpu(unsigned long v2p)
{
    //printk("####### quasar_sleep_cpu, v2p=%d, off=%08X-%08X, %d ....\n", v2p, PHYS_OFFSET, PAGE_OFFSET, PHYS_OFFSET - PAGE_OFFSET); 
	setup_mm_for_reboot();
  
    quasar_lp_start();

RESTOREWRREG_U32(UART_THR, 'R');
RESTOREWRREG_U32(UART_THR, '\n');      
 
    asm volatile("b     cpu_resume");

	/* should never here */
	BUG();

	return 0;
}

/*
 * Suspend Ops
 */

static int quasar_suspend_enter(suspend_state_t state)
{
    //printk("####### quasar_suspend_enter, %p - %p ....\n", (u32)quasar_sleep_cpu, (u32)&quasar_sleep_cpu);

    cpu_suspend(PHYS_OFFSET - PAGE_OFFSET, &quasar_sleep_cpu);
    
    //printk("####### quasar_suspend_enter return\n");
	return 0;
}

static int quasar_suspend_prepare(void)
{
	//printk("####### quasar_suspend_prepare\n");

	return 0;
}

static void quasar_suspend_finish(void)
{
    //printk("####### quasar_suspend_finish\n");
#if 0    
    void __iomem* hrt0;
    u32 val;

	hrt0 = ioremap(0x0410B018, 4);
    val = readl((void *)hrt0);
    printk("####### quasar_suspend_finish, hrt0= %08X\n", val);
    iounmap(hrt0);
#endif    
}

static const struct platform_suspend_ops quasar_suspend_ops = {
	.enter		= quasar_suspend_enter,
	.prepare	= quasar_suspend_prepare,
	.finish		= quasar_suspend_finish,
	.valid		= suspend_valid_only_mem,    
};


void __init quasar_pm_init(void)
{

	suspend_set_ops(&quasar_suspend_ops);
}
