/*
 * arch/arm/mach-quasar/headsmp.S
 *
 * Copyright (c) 2012 ST Microelectronics Limited
 * Shiraz Hashim <shiraz.linux.kernel@gmail.com>
 *
 * Portions copyright (c) 2014, 2015 Linux Foundation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/linkage.h>
#include <linux/init.h>

/*	__INIT */

	.text
/*
 * quasar specific entry point for secondary CPUs. This provides
 * a "holding pen" into which all secondary cores are held until we're
 * ready for them to initialise.
 */

ENTRY(quasar_secondary_startup)
#ifdef CONFIG_MCPM 
    mov r0,#0x80000000  /* Put in SVC mode, disable FIQ, IRQ. */
    orr r0,r0,#0x100
    orr r0,r0,#0xf0
    orr r0,r0,#0x3
    msr CPSR,r0

    // Enable CPU1 debug control
    mov r1, #0x04300000
    orr r1, r1, #0x00010000
    orr r1, r1, #0x00000060
    ldr r0, [r1]
    orr r0, r0, #2
    mov r0, #3
    str r0, [r1]

    /* insure all caches are off */
    dmb
    mrc p15, #0, r0, c1, c0, #0
    bic r0, r0, #(1<<12)
    bic r0, r0, #(1<<11)
    bic r0, r0, #((1<<2)|(1<<0))
    mcr p15, #0, r0, c1, c0, #0

    mov r0, #0
    mcr p15, #0x0, r0, c7, c5,  #0   // invalidate I cache
    
    /* turn on SMP bit */
    mrc	p15, #0, r0, c1, c0, #1
    orr	r0, r0, #(1<<6)
    mcr 	p15, #0, r0, c1, c0, #1

    // Enable Vector Floating point and NEON
    mrc p15, 0, r1, c1, c0, 2
    orr r1, r1, #(0xf << 20)
    mcr p15, 0, r1, c1, c0, 2
    mov r1, #0
    mcr p15, 0, r1, c7, c5, 4
    mcr p15, 0, r1, c1, c1, 2
    orr r1, r1, #(0x3 << 10)
    mcr p15, 0, r1, c1, c1, 2
    vmrs r0, FPEXC
    orr r0, r0, #(1<<30)
    vmsr FPEXC, r0     
  
    // Set GIC as Group1 interrupt
    mov r1, #0x04300000
    orr r1, r1, #0x1000
    orr r1, r1, #0x80
    mov r0, #0xFFFFFFFF
    str r0, [r1]
    add r1, r1, #4
    str r0, [r1]
    add r1, r1, #4
    str r0, [r1]
    add r1, r1, #4
    str r0, [r1]
    add r1, r1, #4
    str r0, [r1]
    add r1, r1, #4
    str r0, [r1]
    add r1, r1, #4
    str r0, [r1]
    
    // Setup GICC_PMR
    mov r1, #0x04300000
    orr r1, r1, #0x2000
    orr r1, r1, #0x04
    mov r0, #0xFF
    str r0, [r1]

    // Setup MVBAR and monitor mode SP
    // mvbar at 0x80000040, sp at 0x80003000
    // Put sp at a fixed address just before the swapper_pg_dir
    // Between the deviceblob and swapper_pg_dir
    .equ    MODE_MASK, 0x1F     /*  Processor Mode Mask*/
    .equ    MON_MODE, 0x16      /*  Monitor Mode (MON)*/ 
    mov r0, #0x80000000
    orr r0, r0, #0x00000040
    mov r1, #0x80000000
    orr r1, r1, #0x00003000
    sub r1, r1, #4   
    // Set up MVBAR
    mcr p15, 0, r0, c12, c0, 1  @Set MVBAR
    isb
    mrs r3, CPSR                /*  Pickup current CPSR*/
    bic ip, r3, #MODE_MASK      /*  Clear the mode bits*/
    orr ip, ip, #MON_MODE       /*  Set the MON mode bits*/
    msr CPSR_cxsf, ip           /*  Switch to the MON mode*/
    isb
    // Set SP on monitor mode
    mov sp, r1
    isb
    msr CPSR_cxsf, r3           /*  Restore caller's mode*/
     
    // Enter Non-Secure world
    bl  BIOSSetCp15Nonsecure 
    
    mov   r0, #0
    mcr   p15, #0x0, r0, c7, c5,  #0   // invalidate I cache
    
	bl	v7_invalidate_l1

	ldr	r1, 1f
	bx	r1

	.align 2
	.globl quasar63xx_smp_entrypoint
quasar63xx_smp_entrypoint:
1:	.space 4

#else   // !CONFIG_MCPM
	mrc	p15, 0, r0, c0, c0, 5
	and	r0, r0, #15
	adr	r4, 1f
	ldmia	r4, {r5, r6}
	sub	r4, r4, r5
	add	r6, r6, r4
pen:	ldr	r7, [r6]
	cmp	r7, r0
	bne	pen

	.if 0
	/* re-enable coherency */
	mrc	p15, 0, r0, c1, c0, 1
	orr	r0, r0, #(1 << 6) | (1 << 0)
	mcr	p15, 0, r0, c1, c0, 1
	.endif
	/*
	 * we've been released from the holding pen: secondary_stack
	 * should now contain the SVC stack for this core
	 */
    bl	v7_invalidate_l1
    
	b	secondary_startup

	.align
1:	.long	.
	.long	pen_release
#endif
ENDPROC(quasar_secondary_startup)
