/*
 * Copyright (c) 2010 RICOH Co. Ltd. All rights reserved.
 */


#ifndef _LOGBOARD_IF_H_
#define _LOGBOARD_IF_H_


#define LOGB_MAXLOGID	500


struct logb_logdata {
	u_int	id;			
#define LOGB_BUFSIZE	256		
	char	data[LOGB_BUFSIZE];	
};





#define LOGB_IOC_MAGIC	'L'
#define LOGB_INITIALIZE	_IO(LOGB_IOC_MAGIC, 1)
#define LOGB_WRTYPE	_IOR(LOGB_IOC_MAGIC, 2, int)
#define LOGB_CREATE	_IOW(LOGB_IOC_MAGIC, 3, struct logb_cmd_create)
#define LOGB_LOGCTL	_IOW(LOGB_IOC_MAGIC, 4, struct logb_cmd_ctl)
#define LOGB_STAT_ALL	_IOWR(LOGB_IOC_MAGIC, 5, struct logb_cmd_statall)
#define LOGB_STAT_LIST	_IOWR(LOGB_IOC_MAGIC, 6, struct logb_cmd_statlist)
#define LOGB_STAT_ID	_IOWR(LOGB_IOC_MAGIC, 7, struct logb_cmd_statid)
#define LOGB_READSET	_IOW(LOGB_IOC_MAGIC, 8, struct logb_cmd_read)
#define LOGB_TESTIO     _IOW(LOGB_IOC_MAGIC, 30, int)
#define LOGB_DBGMEMDUMP	_IOW(LOGB_IOC_MAGIC, 31, struct logb_cmd_dbgmem)
#define LOGB_DBGREGDUMP _IOR(LOGB_IOC_MAGIC, 32, struct logb_cmd_dbgreg)


#define LOGB_STOP	1
#define LOGB_TIMESTAMP	2
#define LOGB_TYPE	3


#define LOGB_RDWR	1
#define LOGB_RDONLY	2
#define LOGB_INIT	3

#define NBBY		8



struct logb_cmd_create {
	u_int	id;	
	int	size;	
};


struct logb_cmd_ctl {
	u_int	id;		
	u_int	cmd;		
	u_int	cmd_arg;	
};



struct logb_cmd_statall {
	int	count;			
	u_int	abs_count;		
	struct timeval	boot_time;	
	u_int	machine_type;		
	int	banks;			
};


struct logb_idlist {
	u_int id;	
	int size;	
};

struct logb_cmd_statlist {
	int	count;		
	struct	logb_idlist list[LOGB_MAXLOGID];
};


struct logb_cmd_statid {
	int	count;		
	u_int	id;		
	struct timeval	time;	
	pid_t	pid;		
	int	area;		
	int	usage;		
};


struct logb_cmd_read {
	int	count;		
	u_int	id;		
};



struct logb_cmd_dbgmem {
	u_long	uaddr;		
	u_long	start_addr;
	u_long	dump_size;	
};



struct logb_cmd_dbgreg {
	u_int	sc_status;	
	u_int	sc_bnks;	
	u_int	sc_bnks_usage;	
	u_int	sc_start_bnkno;	
	u_int	sc_cur_bnkno;	
	u_int	sc_alloc_blkno;	

	u_char	reg_endian;	
	u_char	reg_mw_enable;	
	u_char	reg_mem_cap;	
	u_char	reg_bank;	

};


#endif 

