/*
 * If distributed as part of the Linux kernel, this code is licensed under the
 * terms of the GPL v2.
 *
 * Otherwise, the following license terms apply:
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1) Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2) Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3) The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef _DEV_PCI_FCU_SUBR_H_
#define	_DEV_PCI_FCU_SUBR_H_

/*
 * 指定されたサイズのelementを管理するFIFO (clist風)
 */
typedef struct plist {
	int		cnt;				/* now count */
	int		emp;				/* now empty count */
	size_t	siz;				/* data size of packet */
	size_t	asz;				/* alloc size of packet */
	u_char	*hd;				/* valid data head */
	u_char	*tl;				/* empty head */
	u_char	*st;				/* fifo start */
	u_char	*en;				/* fifo end(st + asz * num) */
	long    sc_irq;                      /* interrupt bit number */
} plist_t;


int		plalloc(plist_t *, int, size_t, long);
void	plfree(plist_t *);
int		plget(plist_t *, caddr_t);
int		plput(plist_t *, caddr_t);
void	plinit(plist_t *);

/* FIFOに入っているデータの個数を返す */
#define plcnt(plp)	((plp)->cnt)
/* FIFOの空き個数を返す */
#define plemp(plp)	((plp)->emp)


#endif	/* !_DEV_PCI_FCU_SUBR_H_ */
