/*
 * If distributed as part of the Linux kernel, this code is licensed under the
 * terms of the GPL v2.
 *
 * Otherwise, the following license terms apply:
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1) Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2) Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3) The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
/*
 * common data structure and control functions for fcu and fcud
 */
#ifndef __FAX_SHARE_H__
#define __FAX_SHARE_H__
#include <linux/cdev.h>
#include <linux/interrupt.h>
#include <linux/pci.h>

/* dev/pci/pcidevs.hから移動 */
#define	PCI_VENDOR_RICOH	0x1180		/* Ricoh */
#define	PCI_PRODUCT_RICOH_FBI	0x0482		/* FBI */
#define	PCI_PRODUCT_RICOH_FBI2	0x0484		/* FBI2 */
#define	PCI_PRODUCT_RICOH_FBI2_FACE3	0x0264		/* FBI2_FACE3 */
#define PCI_PRODUCT_RICOH_FACE6     0x5026      /* 新FCU対応 */

#define DEV_NAME "pcifcu"

typedef int (*fcud_intr_establish_t)(irqreturn_t (*)(void *));

typedef struct {
	unsigned 			irqno;
	fcud_intr_establish_t		fax_intr_establish;
	unsigned long		io_vaddr;
	unsigned long		io_len;
	unsigned long		mem_vaddr;
	unsigned long		mem_len;
	unsigned long		io_addr;
	unsigned long		mem_addr;
	struct pci_dev		*pci_dev;
}fax_share_param_t;

/* 
 * This structure should be declared as first member 
 * of each softc 
 */
typedef struct {
	dev_t			sc_dev;
	struct cdev		sc_cdev;
	struct class	*sc_class;
	const char		*sc_name;
}fax_driver_header_t;

typedef int  (*attach_func_t)(void *);
typedef int  (*detach_func_t)(void *);
typedef int  (*softcsize_func_t)(void);

struct devlist {
	void					*softc;
	size_t					softc_size;
	struct file_operations	*ops;
	const char				*name;
	attach_func_t			attachfunc;
	detach_func_t			detachfunc;
	softcsize_func_t		softcsizefunc;
};
 
/* prototype */
fax_share_param_t *get_fax_share_param(void);

extern struct devlist fax_devlist[2];

#endif	/* __FAX_SHARE_H__ */
