/*
* Copyright (c) 2024 RICOH Co. Ltd. All rights reserved.
*/
#ifndef __NCS_IPSEC_H__
#define __NCS_IPSEC_H__

#define NCS_IPSEC_EVENT_P2600LOG	(1)

#define NCS_IPSEC_EVENT_CCLOG	(2)

#define NCS_IPSEC_EVENT_SIZE	(256)

#define NCS_IPSEC_CC_REASON_MAX	(64)

typedef struct ncs_ipsec_event_p2600log {
    uint32_t id;
    uint32_t ip_version;
    uint32_t is_initiator;
    uint32_t ipv4_address;
    uint8_t  ipv6_address[16];
    uint8_t  reason[NCS_IPSEC_CC_REASON_MAX];
    uint8_t  data[160];
} ipsec_log_info;

#define CHARON_SOCKNAME		"/udom/NCS_IPSEC" 

#endif	/* __NCS_IPSEC_H__ */
