/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package java.security;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.security.auth.Subject;

//import sun.reflect.Reflection;

/**
 * Legacy security code; do not use.
 */
public final class AccessController {
    private AccessController() { }

    //private static AccessControlContext sAcc = new AccessControlContext(null, true);
    //private static Subject sSubject = new Subject();
    private static List<AccessControlContext> AccessControlContextList = new ArrayList<AccessControlContext>();
    private static String currentUid = null;

    /**
     * Calls {@code action.run()}.
     */
    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        return action.run();
    }

    /**
     * Calls {@code action.run()}.
     */
    private static synchronized void addACC(AccessControlContext context,Subject sj) {
        if(sj != null){
            String uid = ((Principal)sj.getPrincipals().iterator().next()).getName();
            
            for(Iterator<AccessControlContext>itr = AccessControlContextList.iterator(); itr.hasNext();){
                AccessControlContext acc = itr.next();
                Subject sbj = Subject.getSubject(acc);
                if( ((Principal)sbj.getPrincipals().iterator().next()).getName().equals(uid) ){
                    itr.remove();
                    break;
                }
            }
            AccessControlContextList.add(context);
            currentUid = uid;
        }
    }
    
    public static <T> T doPrivileged(PrivilegedAction<T> action, AccessControlContext context) {
        if(context != null){
            Subject sj = Subject.getSubject(context);
            if(sj != null){
                addACC(context, sj);
            }
        }
        return action.run();
    }

    /**
     * Calls {@code action.run()}.
     */
    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        try {
            return action.run();
        } catch (RuntimeException e) {
            throw e; // so we don't wrap RuntimeExceptions with PrivilegedActionException
        } catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
    }

    /**
     * Calls {@code action.run()}.
     */
    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action, AccessControlContext context) throws PrivilegedActionException {
        if(context != null){
            Subject sj = Subject.getSubject(context);
            if(sj != null){
                addACC(context, sj);
            }
        }
        return doPrivileged(action);
    }

    /**
     * Calls {@code action.run()}.
     */
    public static <T> T doPrivilegedWithCombiner(PrivilegedAction<T> action) {
        return action.run();
    }

    /**
     * Calls {@code action.run()}.
     */
    public static <T> T doPrivilegedWithCombiner(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        return doPrivileged(action);
    }

    public static void checkPermission(Permission permission) throws AccessControlException {
    }

    public static synchronized AccessControlContext getContext(){
        if(currentUid != null){
            for(Iterator<AccessControlContext>itr = AccessControlContextList.iterator(); itr.hasNext();){
                AccessControlContext acc = itr.next();
                Subject sbj = Subject.getSubject(acc);
                if( ((Principal)sbj.getPrincipals().iterator().next()).getName().equals(currentUid) ){
                    return acc;
                }
            }
        }
        return new AccessControlContext(null, true);
    }

    public static synchronized List<AccessControlContext> getArrayContext(){
        return AccessControlContextList;
    }

    public static synchronized void cleanAccessController(String principalName){
        for(Iterator<AccessControlContext>itr = AccessControlContextList.iterator(); itr.hasNext();){
            AccessControlContext acc = itr.next();
            Subject sbj = Subject.getSubject(acc);
            if( ((Principal)sbj.getPrincipals().iterator().next()).getName().equals(principalName) ){
                itr.remove();
            }
        }
    }
}
