package com.ibm.jusb.os.linux;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

class JavaxUsbPropertyFileLoader {
	// properties file default name 
	public final static String JAVAX_USB_PROPERTIES    = "javaxusb.properties";
	public final static String JAVAX_USB_INTERVAL    ="JavaxUsb.interval";
	public final static String JAVAX_USB_SLEEP    ="JavaxUsb.sleep";
	public final static String JAVAX_USB_DEFAULT_INTERVAL    = "0";
	public final static String JAVAX_USB_DEFAULT_SLEEP    = "0";
	private int interval;
	private int sleep;

	JavaxUsbPropertyFileLoader() {
	}
	
	int getInterval() {
		return interval;
	}
	
	int getSleep() {
		return sleep;
	}
	
	void setInterval(int interval) {
		this.interval = interval;
	}

	void setSleep(int sleep) {
		this.sleep = sleep;
	}

	void loadProperties () {
		String propStr = JAVAX_USB_PROPERTIES;

		String location = System.getProperty("java.home") + File.separator + "lib" + File.separator + propStr;

		load (location);
	}

	protected void load (String location) {
		Properties prop = new Properties(); 
		try {
			//load the data from property file.
			prop.load(new FileInputStream(location));

			//Get the "JavaxUsb.interval" data.The default value is 0. 
			String interval = prop.getProperty(JAVAX_USB_INTERVAL, JAVAX_USB_DEFAULT_INTERVAL); 
			this.setInterval(Integer.parseInt(interval));

			//Get the "JavaxUsb.sleep" data.The default value is 0. 
			String sleep = prop.getProperty(JAVAX_USB_SLEEP, JAVAX_USB_DEFAULT_SLEEP); 
			this.setSleep(Integer.parseInt(sleep));

		} catch (FileNotFoundException e) {
			this.setInterval(Integer.parseInt(JAVAX_USB_DEFAULT_INTERVAL));
			this.setSleep(Integer.parseInt(JAVAX_USB_DEFAULT_SLEEP));
		} catch (IOException e) {
			this.setInterval(Integer.parseInt(JAVAX_USB_DEFAULT_INTERVAL));
			this.setSleep(Integer.parseInt(JAVAX_USB_DEFAULT_SLEEP));
		} 
	}
}
