
/** 
 * Copyright (c) 1999 - 2001, International Business Machines Corporation.
 * All Rights Reserved.
 *
 * This software is provided and licensed under the terms and conditions
 * of the Common Public License:
 * http://oss.software.ibm.com/developerworks/opensource/license-cpl.html
 */

#include "JavaxUsb.h"

#include "jp_co_ricoh_dsdk_util_usb_JavaxUsbUtil.h"

/* These MUST match those defined in com/ibm/jusb/os/linux/LinuxRequest.java */
#define LINUX_PIPE_REQUEST 1
#define LINUX_SET_INTERFACE_REQUEST 2
#define LINUX_SET_CONFIGURATION_REQUEST 3
#define LINUX_CLAIM_INTERFACE_REQUEST 4
#define LINUX_IS_CLAIMED_INTERFACE_REQUEST 5
#define LINUX_RELEASE_INTERFACE_REQUEST 6
#define LINUX_ISOCHRONOUS_REQUEST 7
#define LINUX_RESET_INTERFACE_REQUEST 8
#define LINUX_DISCONNECT_INTERFACE_REQUEST 9

//added by kawakubo
//static void submitRequest( JNIEnv *env, int fd, jobject linuxRequest );
//static void cancelRequest( JNIEnv *env, int fd, jobject linuxRequest );
//static void completeRequest( JNIEnv *env, jobject linuxRequest );

static int submitRequest( JNIEnv *env, int fd, jobject linuxRequest, jstring javaKey, usefd_set* useFdSet );
//static int cancelRequest( JNIEnv *env, int fd, jobject linuxRequest );
static int completeRequest( JNIEnv *env, jobject linuxRequest );
/*
 * Proxy for all I/O with a device
 * @author Dan Streetman
 */
JNIEXPORT void JNICALL Java_com_ibm_jusb_os_linux_JavaxUsb_nativeDeviceProxy
  ( JNIEnv *env, jclass JavaxUsb, jobject linuxDeviceProxy )
{
	//added by kawakubo
	int fd = 0;
  	usefd_set *useFdSet = NULL;

//	struct usbdevfs_urb *urb;
	//added by kawakubo
	int sub_res = 0;
	int comp_res = 0;
	int no_request = 0;
	int j = 0;
	
	jclass LinuxDeviceProxy, LinuxRequestProxy;
	jobject linuxRequest;
	jstring jkey;
	jint jinterval, jsleep;
	jmethodID startCompleted, isRequestWaiting, getReadyRequest, getCancelRequest;
	jmethodID getKey, getInterval, getSleep;

	LinuxDeviceProxy = CheckedGetObjectClass( env, linuxDeviceProxy );
	LinuxRequestProxy = ChedkedGetSuperclass( env, LinuxDeviceProxy);
	
	startCompleted = CheckedGetMethodID( env, LinuxDeviceProxy, "startCompleted", "(I)V" );
//added by kawakubo
//	isRequestWaiting = CheckedGetMethodID( env, LinuxDeviceProxy, "isRequestWaiting", "()Z" );
//	getReadyRequest = CheckedGetMethodID( env, LinuxDeviceProxy, "getReadyRequest", "()Lcom/ibm/jusb/os/linux/LinuxRequest;" );
//	getCancelRequest = CheckedGetMethodID( env, LinuxDeviceProxy, "getCancelRequest", "()Lcom/ibm/jusb/os/linux/LinuxRequest;" );
	isRequestWaiting = CheckedGetMethodID( env, LinuxRequestProxy, "isRequestWaiting", "()Z" );
	getReadyRequest = CheckedGetMethodID( env, LinuxRequestProxy, "getReadyRequest", "()Lcom/ibm/jusb/os/linux/LinuxRequest;" );
	getCancelRequest = CheckedGetMethodID( env, LinuxRequestProxy, "getCancelRequest", "()Lcom/ibm/jusb/os/linux/LinuxRequest;" );
	getKey = CheckedGetMethodID( env, LinuxDeviceProxy, "getKey", "()Ljava/lang/String;" );
	jkey = CheckedCallObjectMethod( env, linuxDeviceProxy, getKey );
	getInterval = CheckedGetMethodID( env, LinuxDeviceProxy, "getInterval", "()I" );
	jinterval = CheckedCallIntMethod( env, linuxDeviceProxy, getInterval );
	getSleep = CheckedGetMethodID( env, LinuxDeviceProxy, "getSleep", "()I" );
	jsleep = CheckedCallIntMethod( env, linuxDeviceProxy, getSleep );
	CheckedDeleteLocalRef( env, LinuxRequestProxy );
	CheckedDeleteLocalRef( env, LinuxDeviceProxy );

	//added by kawakubo
	useFdSet= (usefd_set *)malloc(sizeof(usefd_set));
  	useFdSet->numfd = 0;

	//errno = 0;
	//fd = open_device( env, jkey, O_RDWR );
	//CheckedDeleteLocalRef( env, jkey );

	//if (0 > fd) {
	//	log( LOG_XFER_ERROR, "Could not open node for device!" );
	//	CheckedCallVoidMethod( env, linuxDeviceProxy, startCompleted, errno );
	//	return;
	//}

	CheckedCallVoidMethod( env, linuxDeviceProxy, startCompleted, 0 );

	/* run forever...? */
	while (1) {
		if((jinterval > 0) && (no_request > jinterval*100)){//100 times (about 1 seconds. Please refer to the following source code "usleep(10000);".)
			break;
		}
		if (JNI_TRUE == CheckedCallBooleanMethod( env, linuxDeviceProxy, isRequestWaiting )) {
			no_request = 0;
			//added by kawakubo
			
			if ((linuxRequest = CheckedCallObjectMethod( env, linuxDeviceProxy, getReadyRequest ))) {
				log( LOG_XFER_REQUEST, "Got Request" ); 
				//added by kawakubo
				sub_res = submitRequest( env, fd, linuxRequest, jkey, useFdSet );
				if (0 > sub_res) {
					log( LOG_XFER_ERROR, "Submit Error!" );
					CheckedCallVoidMethod( env, linuxDeviceProxy, startCompleted, sub_res );
					CheckedDeleteLocalRef( env, linuxRequest );
					continue;
				}
				comp_res = completeRequest( env, linuxRequest );
				CheckedDeleteLocalRef( env, linuxRequest );

				if(sub_res == LINUX_RESET_INTERFACE_REQUEST){
					//Because of the SC819. The combination of the interrupt transfer and the disconnecting may cause a error.The error point is the timing of the method "close".
					if(useFdSet->numfd != 0){
						log( LOG_XFER_REQUEST, "sleep %d ms", jsleep);
						usleep(jsleep * 1000); //jsleep * 1 millisecond sleep.
					}
					
					//close the all file descriptor.
				  	for(j = 0; j < useFdSet->numfd; j++){
				  		close(useFdSet->fd[j].fd);
				  		useFdSet->fd[j].fd = 0;
				  	}
					useFdSet->numfd = 0;
				}
				
				if(sub_res == LINUX_DISCONNECT_INTERFACE_REQUEST){
					break;
				}
				
				log( LOG_XFER_REQUEST, "Completed Request" );
			}
			if ((linuxRequest = CheckedCallObjectMethod( env, linuxDeviceProxy, getCancelRequest ))) {
				log( LOG_XFER_REQUEST, "Got Abort Request" );
				log( LOG_XFER_ERROR, "Cancel Method is not supported." );
				//added by kawakubo
				//can_res = cancelRequest( env, fd, linuxRequest );
				//comp_res = completeRequest( env, linuxRequest );
				CheckedDeleteLocalRef( env, linuxRequest );
				log( LOG_XFER_REQUEST, "Completed Abort Request" );
			}
		}
		else{
			no_request++;
		}
//added by kawakubo
		//errno = 0;
		//if (!(ioctl( fd, USBDEVFS_REAPURBNDELAY, &urb ))) {
		//	log( LOG_XFER_REQUEST, "Got completed URB" );
		//	linuxRequest = urb->usercontext;
		//	comp_res = completeRequest( env, linuxRequest );
		//	CheckedDeleteGlobalRef( env, linuxRequest );
		//	log( LOG_XFER_REQUEST, "Finished completed URB" );
		//} else if (ENODEV == errno) {
		//	break;
		//}
		usleep(10000); //10 millisecond sleep. But the function "usleep" depends on the machine status. So, in fact, I think the sleeping time is about 20 milliseconds .
	}

	log( LOG_XFER_OTHER, "Device Proxy exiting." );
	
	//added by kawakubo
	CheckedDeleteLocalRef( env, jkey );

	//Because of the SC819. The combination of the interrupt transfer and the disconnecting may cause a error.The error point is the timing of the method "close".
	if(useFdSet->numfd != 0){
		log( LOG_XFER_REQUEST, "sleep %d ms", jsleep);
		usleep(jsleep * 1000); //jsleep * 1 millisecond sleep.
	}
	
	//close the all file descriptor.
  	for(j = 0; j < useFdSet->numfd; j++){
  		close(useFdSet->fd[j].fd);
  		useFdSet->fd[j].fd = 0;
  	}
	useFdSet->numfd = 0;

  	free(useFdSet);

	//close( fd );
}

/**
 * Submit a LinuxRequest.
 * @param env The JNIEnv.
 * @param fd The file descriptor.
 * @param linuxRequest The LinuxRequest.
 * @return The error or 0.
 */
//added by kawakubo
//static void submitRequest( JNIEnv *env, int fd, jobject linuxRequest )
static int submitRequest( JNIEnv *env, int fd, jobject linuxRequest, jstring javaKey,  usefd_set* useFdSet )
{
	int type, err, sync = 0;

	jclass LinuxRequest;
	jmethodID getType, setError, setCompleted;

	LinuxRequest = CheckedGetObjectClass( env, linuxRequest );
	getType = CheckedGetMethodID( env, LinuxRequest, "getType", "()I" );
	setCompleted = CheckedGetMethodID( env, LinuxRequest, "setCompleted", "(Z)V" );
	setError = CheckedGetMethodID( env, LinuxRequest, "setError", "(I)V" );
	CheckedDeleteLocalRef( env, LinuxRequest );

	type = CheckedCallIntMethod( env, linuxRequest, getType );

	log( LOG_XFER_OTHER, "Submitting Request.");

	switch (type) {
	case LINUX_PIPE_REQUEST:
		log( LOG_XFER_OTHER, "Submitting Pipe Request.");
		//added by kawakubo
		//err = pipe_request( env, fd, linuxRequest );
		err = pipe_request( env, fd, linuxRequest, javaKey, useFdSet );
		break;
	case LINUX_SET_INTERFACE_REQUEST:
		log( LOG_XFER_OTHER, "Submitting SetInterface Request.");
		//added by kawakubo
		//err = set_interface( env, fd, linuxRequest );
		err = set_interface( env, fd, linuxRequest, javaKey, useFdSet );
		sync = 1;
		break;
	case LINUX_SET_CONFIGURATION_REQUEST:
		log( LOG_XFER_OTHER, "Submitting SetConfiguration Request.");
		//added by kawakubo
		//err = set_configuration( env, fd, linuxRequest );
		err = set_configuration( env, fd, linuxRequest, javaKey, useFdSet );
		sync = 1;
		break;
	case LINUX_CLAIM_INTERFACE_REQUEST:
		log( LOG_XFER_OTHER, "Submitting ClaimInterface Request.");
		//added by kawakubo
		//err = claim_interface( env, fd, 1, linuxRequest );
		err = claim_interface( env, fd, 1, linuxRequest, javaKey );
		sync = 1;
		break;
	case LINUX_RELEASE_INTERFACE_REQUEST:
		log( LOG_XFER_OTHER, "Submitting ReleaseInterface Request.");
		//added by kawakubo
		//err = claim_interface( env, fd, 0, linuxRequest );
		err = claim_interface( env, fd, 0, linuxRequest, javaKey );
		sync = 1;
		break;
	case LINUX_IS_CLAIMED_INTERFACE_REQUEST:
		log( LOG_XFER_OTHER, "Submitting IsClaimed Request.");
		//added by kawakubo
		//err = is_claimed( env, fd, linuxRequest );
		err = is_claimed( env, fd, linuxRequest, javaKey );
		sync = 1;
		break;
	case LINUX_ISOCHRONOUS_REQUEST:
		log( LOG_XFER_OTHER, "Submitting Isochronous Request.");
		//added by kawakubo
		//err = isochronous_request( env, fd, linuxRequest );
		err = isochronous_request( env, fd, linuxRequest, javaKey );
		break;
	case LINUX_RESET_INTERFACE_REQUEST:
		log( LOG_XFER_OTHER, "Submitting ResetInterface Request.");
		//added by kawakubo
		err = 0;
		sync = 1;
		break;
	case LINUX_DISCONNECT_INTERFACE_REQUEST:
		log( LOG_XFER_OTHER, "Submitting Disconnect Request.");
		//added by kawakubo
		err = 0;
		sync = 1;
		break;
	default: /* ? */
		log( LOG_XFER_ERROR, "Unknown Request type %d", type );
		err = -EINVAL;
		break;
	}

	if (err){
		//added by kawakubo
		log( LOG_XFER_OTHER, "setError.(err = %d)", err);
		CheckedCallVoidMethod( env, linuxRequest, setError, err );
	}

	if (sync || err)
		CheckedCallVoidMethod( env, linuxRequest, setCompleted, JNI_TRUE );

	//added by kawakubo
	if(type == LINUX_RESET_INTERFACE_REQUEST){
		return LINUX_RESET_INTERFACE_REQUEST;
	}else if(type == LINUX_DISCONNECT_INTERFACE_REQUEST){
		return LINUX_DISCONNECT_INTERFACE_REQUEST;
	}
	return err;
}

/**
 * Cancel a LinuxRequest.
 * @param env The JNIEnv.
 * @param fd The file descriptor.
 * @param linuxRequest The LinuxRequest.
 * @return The error or 0.
 */
//added by kawakubo
//static void cancelRequest( JNIEnv *env, int fd, jobject linuxRequest )
//static int cancelRequest( JNIEnv *env, int fd, jobject linuxRequest)
//{
	//added by kawakubo
	//int type;
	//int err = 0;

	//jclass LinuxRequest;
	//jmethodID getType;

	//LinuxRequest = CheckedGetObjectClass( env, linuxRequest );
	//getType = CheckedGetMethodID( env, LinuxRequest, "getType", "()I" );
	//CheckedDeleteLocalRef( env, LinuxRequest );

	//type = CheckedCallIntMethod( env, linuxRequest, getType );

	//switch (type) {
	//case LINUX_PIPE_REQUEST:
	//	cancel_pipe_request( env, fd, linuxRequest, javaKey );
	//	break;
	//case LINUX_SET_INTERFACE_REQUEST:
	//case LINUX_SET_CONFIGURATION_REQUEST:
	//case LINUX_CLAIM_INTERFACE_REQUEST:
	//case LINUX_IS_CLAIMED_INTERFACE_REQUEST:
	//case LINUX_RELEASE_INTERFACE_REQUEST:
	//	/* cannot abort these synchronous requests */
	//	break;
	//case LINUX_ISOCHRONOUS_REQUEST:
	//	cancel_isochronous_request( env, fd, linuxRequest );
	//	break;
	//default: /* ? */
	//	log( LOG_XFER_ERROR, "Unknown Request type %d", type );
	//	break;
	//}
	//return err;
//}

/**
 * Complete a LinuxRequest.
 * @param env The JNIEnv.
 * @param linuxRequest The LinuxRequest.
 * @return The error or 0.
 */
//added by kawakubo
//static void completeRequest( JNIEnv *env, jobject linuxRequest )
static int completeRequest( JNIEnv *env, jobject linuxRequest)
{
	int type, err;

	jclass LinuxRequest;
	jmethodID getType, setError, setCompleted;

	LinuxRequest = CheckedGetObjectClass( env, linuxRequest );
	getType = CheckedGetMethodID( env, LinuxRequest, "getType", "()I" );
	setCompleted = CheckedGetMethodID( env, LinuxRequest, "setCompleted", "(Z)V" );
	setError = CheckedGetMethodID( env, LinuxRequest, "setError", "(I)V" );
	CheckedDeleteLocalRef( env, LinuxRequest );

	type = CheckedCallIntMethod( env, linuxRequest, getType );
	//added by kawakubo
	err = 0;
	
	switch (type) {
	case LINUX_PIPE_REQUEST:
		err = complete_pipe_request( env, linuxRequest );
		break;
	case LINUX_SET_INTERFACE_REQUEST:
	case LINUX_SET_CONFIGURATION_REQUEST:
	case LINUX_CLAIM_INTERFACE_REQUEST:
	case LINUX_IS_CLAIMED_INTERFACE_REQUEST:
	case LINUX_RELEASE_INTERFACE_REQUEST:
	case LINUX_RESET_INTERFACE_REQUEST:
	case LINUX_DISCONNECT_INTERFACE_REQUEST:
		/* these are synchronous, completion happens during submit */
		break;
	case LINUX_ISOCHRONOUS_REQUEST:
		err = complete_isochronous_request( env, linuxRequest );
		break;
	default: /* ? */
		log( LOG_XFER_ERROR, "Unknown Request type %d", type );
		err = -EINVAL;
		break;
	}

	if (err){
		//added by kawakubo
		log( LOG_XFER_OTHER, "setError.");
		CheckedCallVoidMethod( env, linuxRequest, setError, err );
	}
		
	CheckedCallVoidMethod( env, linuxRequest, setCompleted, JNI_TRUE );

	return err;
}
