
/** 
 * Copyright (c) 1999 - 2001, International Business Machines Corporation.
 * All Rights Reserved.
 *
 * This software is provided and licensed under the terms and conditions
 * of the Common Public License:
 * http://oss.software.ibm.com/developerworks/opensource/license-cpl.html
 */

#ifndef _JAVAXUSBUTIL_H
#define _JAVAXUSBUTIL_H

#include "com_ibm_jusb_os_linux_JavaxUsb.h"
#include "JavaxUsbLog.h"
#include "JavaxUsbChecks.h"

#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/poll.h>
#include <sys/time.h>
#include <sys/dir.h>
#include <dirent.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <pthread.h>
#include <errno.h>
//#include </usr/include/asm/types.h>

#include "types.h"
#include "JavaxUsbUhDevProfile.h"

/* Need to include this last or gcc will give warnings */
#include "JavaxUsbKernel.h"
//added by kawakubo
#define USBDEVFS_PATH            "/dev/"
#define USBDEVFS_HUB_PATH            "/dev/usb"

#define USBDEVFS_URB_TYPE_ISO              0
#define USBDEVFS_URB_TYPE_INTERRUPT        1
#define USBDEVFS_URB_TYPE_CONTROL          2
#define USBDEVFS_URB_TYPE_BULK             3

//#define USBDEVFS_PATH            "/proc/bus/usb"
//#define USBDEVFS_DEVICES         "/proc/bus/usb/devices"
//#define USBDEVFS_DRIVERS         "/proc/bus/usb/drivers"
//
//#define USBDEVFS_SPRINTF_NODE    "/proc/bus/usb/%3.03d/%3.03d"
//#define USBDEVFS_SSCANF_NODE     "/proc/bus/usb/%3d/%3d"

#define MAX_LINE_LENGTH 255
#define MAX_KEY_LENGTH 255
#define MAX_PATH_LENGTH 255

#define MAX_POLLING_ERRORS 64

/* These must match the defines in JavaxUsb.java */
#define SPEED_UNKNOWN 0
#define SPEED_LOW 1
#define SPEED_FULL 2

#ifdef FIXEDLINK_JAVAXUSB
#define USBERRNO *__errno()
//extern int local_errno = *__errno()
#else
#define USBERRNO errno
//extern int local_errno = errno;
#endif

#define USB_STALL_EXCEPTION -32
#define USB_BITSTUFF_EXCEPTION -71
#define USB_BABBLE_EXCEPTION -75
#define USB_CRC_EXCEPTION -84
#define USB_SHORTPACKET_EXCEPTION -121
#define USB_PLATFORM_EXCEPTION -1

//******************************************************************************
// Descriptor structs 
//added by kawakubo
#define USBDEVFS_URB_ISO_ASAP              2

struct usbdevfs_iso_packet_desc {
    unsigned int length;
	unsigned int actual_length;
    unsigned int status;
};

struct usbdevfs_urb {
	unsigned char type;
	unsigned char endpoint;
	int status;
	unsigned int flags;
	void *buffer;
	int buffer_length;
	int actual_length;
	int start_frame;
	int number_of_packets;
	int error_count;
	unsigned int signr;  /* signal to be sent on error, -1 if none should be sent */
	void *usercontext;
	struct usbdevfs_iso_packet_desc iso_frame_desc[0];
};

struct file_descriptor;
typedef struct file_descriptor {
	int fd;
	unsigned char endpoint;
	int oflag;
	int acceptShortPacket;
}file_descriptor;

struct usefd_set;
typedef struct usefd_set{
	int numfd;
	file_descriptor fd[256];
}usefd_set;

struct bus_list;
typedef struct bus_list{
	int num;
	int bus[127];
}bus_list;


struct root;
typedef struct root{
	int bus;
	int addr;
	int lowspeed;
}root;

struct root_list;
typedef struct root_list{
	int num;
	root root[UHCOMM_MAX_CONTROLLERS];
}root_list;



//added by kawakubo
//struct jusb_device_descriptor {
//	__u8 bLength;
//	__u8 bDescriptorType;
//	__u16 bcdUSB;
//	__u8 bDeviceClass;
//	__u8 bDeviceSubClass;
//	__u8 bDeviceProtocol;
//	__u8 bMaxPacketSize0;
//	__u16 idVendor;
//	__u16 idProduct;
//	__u16 bcdDevice;
//	__u8 iManufacturer;
//	__u8 iProduct;
//	__u8 iSerialNumber;
//	__u8 bNumConfigurations;
//};
//
//struct jusb_config_descriptor {
//	__u8 bLength;
//	__u8 bDescriptorType;
//	__u16 wTotalLength;
//	__u8 bNumInterfaces;
//	__u8 bConfigurationValue;
//	__u8 iConfiguration;
//	__u8 bmAttributes;
//	__u8 bMaxPower;
//};
//
//struct jusb_interface_descriptor {
//	__u8 bLength;
//	__u8 bDescriptorType;
//	__u8 bInterfaceNumber;
//	__u8 bAlternateSetting;
//	__u8 bNumEndpoints;
//	__u8 bInterfaceClass;
//	__u8 bInterfaceSubClass;
//	__u8 bInterfaceProtocol;
//	__u8 iInterface;
//};
//
//struct jusb_endpoint_descriptor {
//	__u8 bLength;
//	__u8 bDescriptorType;
//	__u8 bEndpointAddress;
//	__u8 bmAttributes;
//	__u16 wMaxPacketSize;
//	__u8 bInterval;
//};
//
//struct jusb_string_descriptor {
//	__u8 bLength;
//	__u8 bDescriptorType;
//	unsigned char bString[254];
//};

//******************************************************************************
// Request methods
//added by kawakubo
//int pipe_request( JNIEnv *env, int fd, jobject linuxRequest );
//int isochronous_request( JNIEnv *env, int fd, jobject linuxRequest );
int pipe_request( JNIEnv *env, int fd, jobject linuxPipeRequest , jstring javaKey, usefd_set* useFdSet);
int isochronous_request( JNIEnv *env, int fd, jobject linuxRequest, jstring javaKey );

void cancel_pipe_request( JNIEnv *env, int fd, jobject linuxRequest );
void cancel_isochronous_request( JNIEnv *env, int fd, jobject linuxRequest );

int complete_pipe_request( JNIEnv *env, jobject linuxRequest );
int complete_isochronous_request( JNIEnv *env, jobject linuxRequest );

//added by kawakubo
//int set_configuration( JNIEnv *env, int fd, jobject linuxRequest );
int set_configuration( JNIEnv *env, int fd, jobject linuxSetConfigurationRequest, jstring javaKey, usefd_set* useFdSet );

//added by kawakubo
//int set_interface( JNIEnv *env, int fd, jobject linuxRequest);
//int claim_interface( JNIEnv *env, int fd, int claim, jobject linuxRequest );
//int is_claimed( JNIEnv *env, int fd, jobject linuxRequest );
int set_interface( JNIEnv *env, int fd, jobject linuxRequest, jstring javaKey, usefd_set* useFdSet );
int claim_interface( JNIEnv *env, int fd, int claim, jobject linuxRequest, jstring javaKey );
int is_claimed( JNIEnv *env, int fd, jobject linuxRequest, jstring javaKey );

int control_pipe_request( JNIEnv *env, int fd, jobject linuxPipeRequest, struct usbdevfs_urb *urb );
int bulk_pipe_request( JNIEnv *env, int fd, jobject linuxPipeRequest, struct usbdevfs_urb *urb );
int interrupt_pipe_request( JNIEnv *env, int fd, jobject linuxPipeRequest, struct usbdevfs_urb *urb );
int isochronous_pipe_request( JNIEnv *env, int fd, jobject linuxPipeRequest, struct usbdevfs_urb *urb );

int complete_control_pipe_request( JNIEnv *env, jobject linuxPipeRequest, struct usbdevfs_urb *urb );
int complete_bulk_pipe_request( JNIEnv *env, jobject linuxPipeRequest, struct usbdevfs_urb *urb );
int complete_interrupt_pipe_request( JNIEnv *env, jobject linuxPipeRequest, struct usbdevfs_urb *urb );
int complete_isochronous_pipe_request( JNIEnv *env, jobject linuxPipeRequest, struct usbdevfs_urb *urb );

//******************************************************************************
// Config and Interface active checking methods

/* Pick a way to determine active config.
 *
 * Most of these generate bus traffic to one or more devices.
 * This is BAD when using non-queueing (up to 2.5.44) UHCI Host Controller Driver,
 * as it can interfere with other drivers and the results are unpredictable - ranging
 * from nothing to complete loss of use of the device(s).
 *
 * CONFIG_SETTING_ASK_DEVICE:
 * Asking the device directly is the best available way,
 * as bus traffic is generated only for the specific device in question,
 * and only 1 standard request.
 *
 * CONFIG_SETTING_USE_DEVICES_FILE:
 * Reading/parsing the /proc/bus/usb/devices file generates bus traffic,
 * by asking ALL connected devices for their 3 standard String-descriptors;
 * Manufacturer, Product, and SerialNumber.  This is a lot of bus traffic and
 * can cause problems with any or all connected devices (if using a non-queueing UHCI driver).
 *
 * CONFIG_SETTING_1_ALWAYS_ACTIVE:
 * This does not communicate with the device at all, but always marks the first
 * configuration (number 1, as configs must be numbered consecutively starting with 1)
 * as active.  This should work for all devices, but will produce incorrect results
 * for devices whose active configuration has been changed outside of the current javax.usb
 * instance.
 *
 * All or none may be used, attempts are in order shown, failure moves to the next one.
 * If none are defined (or all fail) then the result will be no configs active, i.e.
 * the device will appear to be (but will not really be) in a Not Configured state.
 *
 * Most people want at least the CONFIG_1_ALWAYS_ACTIVE define, as it is always
 * the last attempted and will do the right thing in many more cases than leaving the
 * device to appear as Not Configured.
 */
//#define CONFIG_SETTING_ASK_DEVICE
//added by kawakubo this function isn't supported.
//#undef CONFIG_SETTING_ASK_DEVICE
//#undef CONFIG_SETTING_USE_DEVICES_FILE
//#define CONFIG_SETTING_1_ALWAYS_ACTIVE

/* Pick a way to determine active interface alternate setting.
 *
 * INTERFACE_SETTING_ASK_DEVICE:
 * This directly asks the device in the same manner as above.  The only difference is,
 * to communicate with an interface, the interface must be claimed;
 * for a device that already has a driver (which is usually most devices)
 * this will not work since the interface will already be claimed.
 *
 * INTERFACE_SETTING_USE_DEVICES_FILE:
 * This uses the /proc/bus/usb/devices file in the same manner as above.
 * However, until kernel 2.5.XX, the devices file does not provide active
 * interface setting information, so this will fail on those kernels.
 *
 * If none are defined (or all fail) then the result will be first setting is active.
 */
//#undef INTERFACE_SETTING_ASK_DEVICE
//#undef INTERFACE_SETTING_USE_DEVICES_FILE
//added by kawakubo this function isn't supported.
//int getActiveConfig( JNIEnv *env, int fd, unsigned char bus, unsigned char dev );
//int getActiveInterfaceSetting( JNIEnv *env, int fd, unsigned char bus, unsigned char dev, __u8 interface );

//******************************************************************************
// Utility methods

static inline __u16 bcd( __u8 msb, __u8 lsb ) 
{
    return ( (msb << 8) & 0xff00 ) | ( lsb & 0x00ff );
}
//added by kawakubo
static inline int set_short_packet(jboolean acceptShortPacket, file_descriptor* fileDescriptor)
{
	int zero = 0;
	int one = 1;
	int ret = 0;
	
	errno = 0;

	if(acceptShortPacket != fileDescriptor->acceptShortPacket){
		if(acceptShortPacket == JNI_TRUE){
			log( LOG_XFER_OTHER, "Set Short Packet");
			if (ioctl(fileDescriptor->fd, USB_SET_SHORT_XFER, &one) < 0) {
				int errsv = USBERRNO;
				ret = -errsv;
				log( LOG_ERROR, "Could not set accept short packet. %d : %s", errsv, strerror(errsv));
			}
			fileDescriptor->acceptShortPacket = 1;
		}else{
			log( LOG_XFER_OTHER, "Set No Short Packet");
			if (ioctl(fileDescriptor->fd, USB_SET_SHORT_XFER, &zero) < 0) {
				int errsv = USBERRNO;
				ret = -errsv;
				log( LOG_ERROR, "Could not set no short packet. %d : %s", errsv, strerror(errsv) );
			}
			fileDescriptor->acceptShortPacket = 0;
		}
	}
	return ret;
}

//static inline int open_device( JNIEnv *env, jstring javaKey, int oflag ) 
static inline int open_device_control( JNIEnv *env, jstring javaKey, int oflag ) 
{
	const char *key;
	int filed;
	//added by kawakubo
	//jobject device = NULL, existingDevice = NULL;
	//jstring keyString = NULL;
	//jobject device = NULL;
	
	char node[100];

	key = (*env)->GetStringUTFChars( env, javaKey, NULL );
	sprintf(node, "%s.%.2d", key, 0);

	log( LOG_INFO, "Opening node %s", node );
	if (0 > (filed = open( node, oflag ))){
		int errsv = USBERRNO;
		log( LOG_ERROR, "Could not open node %s : %d :%s", node, errsv, strerror(errsv) );
	}
	(*env)->ReleaseStringUTFChars( env, javaKey, key );
	return filed;
//added by kawakubo
	//const char *node;
	//int filed;

	//node = (*env)->GetStringUTFChars( env, javaKey, NULL );
	//log( LOG_INFO, "Opening node %s", node );
	//if (0 > (filed = open( node, oflag )))
	//	log( LOG_ERROR, "Could not open node %s : %s", node, strerror(errno) );
	//(*env)->ReleaseStringUTFChars( env, javaKey, node );
	//return filed;
}
//added by kawakubo
static inline int open_device_endpoint( JNIEnv *env, jstring javaKey, int oflag, unsigned char endpoint, jboolean acceptShortPacket, usefd_set* useFdSet) 
{
	const char *key;
	unsigned char newEndpoint;
	int i = 0;
	int index = 0;
	int ret = 0;

	char node[100];
	index = useFdSet->numfd;
	newEndpoint = endpoint & 0x0f;

	
	//added by kawakubo
	//jobject device = NULL, existingDevice = NULL;
	//jstring keyString = NULL;
	//jobject device = NULL;
	
	//search fd.
	for(i = 0; i < index; i++){
		if(useFdSet->fd[i].endpoint == endpoint){
			if(useFdSet->fd[i].endpoint & 0x80){//Read only
				log( LOG_XFER_OTHER, "Set Short Packet");
				if(0 > (ret = set_short_packet(acceptShortPacket, &(useFdSet->fd[i])))){
					log( LOG_ERROR, "Could not set short packet." );
					return ret;
				}
			}	
			return useFdSet->fd[i].fd;
		}else if(((useFdSet->fd[i].endpoint) & 0x0f) == newEndpoint){
			if(useFdSet->fd[i].oflag == O_RDWR){//allow read/write
				log( LOG_XFER_OTHER, "Set Short Packet");
				if(0 > (ret = set_short_packet(acceptShortPacket, &(useFdSet->fd[i])))){
					log( LOG_ERROR, "Could not set short packet." );
					return ret;
				}
				return useFdSet->fd[i].fd;
			}	
		}
	}

	key = (*env)->GetStringUTFChars( env, javaKey, NULL );
	sprintf(node, "%s.%.2d", key, newEndpoint);

	//At first, try O_RDWR
	log( LOG_INFO, "Opening node %s", node );

	if (0 > (ret = open(node , O_RDWR ))){
		int errsv = USBERRNO;
		log( LOG_INFO, "Could not open by using O_RDWR mode. %s : %d : %s", node, errsv, strerror(errsv));
	}else{
		useFdSet->fd[index].endpoint = endpoint;
		useFdSet->fd[index].oflag = O_RDWR;
		useFdSet->fd[index].fd = ret;
		useFdSet->fd[index].acceptShortPacket = 0;
		useFdSet->numfd++;
		log( LOG_XFER_OTHER, "Set Short Packet");
		if(0 > (ret = set_short_packet(acceptShortPacket, &(useFdSet->fd[index])))){
			log( LOG_ERROR, "Could not set short packet." );
			(*env)->ReleaseStringUTFChars( env, javaKey, key );
			close(useFdSet->fd[index].fd);
			useFdSet->numfd--;
			return ret;
		}

		(*env)->ReleaseStringUTFChars( env, javaKey, key );
		return useFdSet->fd[i].fd;
	}
	
	if (0 > (ret = open(node,  oflag))){
		int errsv = USBERRNO;
		ret = -errsv;
		log( LOG_ERROR, "Could not open node %s : %d : %s", node, errsv, strerror(errsv));
	}else{
		useFdSet->fd[index].endpoint = endpoint;
		useFdSet->fd[index].oflag = oflag;
		useFdSet->fd[index].fd = ret;
		useFdSet->fd[index].acceptShortPacket = 0;
		useFdSet->numfd++;
		if(oflag == O_RDONLY){//Read only
			log( LOG_XFER_OTHER, "Set Short Packet");
			if(0 > (ret = set_short_packet(acceptShortPacket, &(useFdSet->fd[index])))){
				log( LOG_ERROR, "Could not set short packet." );
				(*env)->ReleaseStringUTFChars( env, javaKey, key );
				close(useFdSet->fd[index].fd);
				useFdSet->numfd--;
				return ret;
			}
		}
		(*env)->ReleaseStringUTFChars( env, javaKey, key );

		return useFdSet->fd[i].fd;
	}
	(*env)->ReleaseStringUTFChars( env, javaKey, key );

	return ret;
}

//static inline int bus_node_to_name( int bus, int node, char *name )
//{
//	sprintf( name, USBDEVFS_SPRINTF_NODE, bus, node );
//	return strlen( name );
//}
//
//static inline int get_busnum_from_name( const char *name )
//{
//	int bus, node;
//	if (1 > (sscanf( name, USBDEVFS_SSCANF_NODE, &bus, &node )))
//		return -1;
//	else return bus;
//}
//
//static inline int get_busnum_from_jname( JNIEnv *env, jstring jname )
//{
//	const char *name = (*env)->GetStringUTFChars( env, jname, NULL );
//	int busnum = get_busnum_from_name( name );
//	(*env)->ReleaseStringUTFChars( env, jname, name );
//	return busnum;
//}
//
//static inline int get_devnum_from_name( const char *name )
//{
//	int bus, node;
//	if (2 > (sscanf( name, USBDEVFS_SSCANF_NODE, &bus, &node )))
//		return -1;
//	else return node;
//}
//
//static inline int get_devnum_from_jname( JNIEnv *env, jstring jname )
//{
//	const char *name = (*env)->GetStringUTFChars( env, jname, NULL );
//	int devnum = get_devnum_from_name( name );
//	(*env)->ReleaseStringUTFChars( env, jname, name );
//	return devnum;
//}

/**
 * Debug a URB.
 * @env The JNIEnv*.
 * @param calling_method The name of the calling method.
 * @param urb The usbdevfs_urb.
 */
static inline void debug_urb( JNIEnv *env, char *calling_method, struct usbdevfs_urb *urb )
{
	if (!tracing)
		return;

//FIXME - add device number and/or other dev info
	log( LOG_URB_METADATA, "%s : URB endpoint = %x status = %d signal = %x", calling_method, urb->endpoint, urb->status, urb->signr );
	log( LOG_URB_METADATA, "%s : URB buffer length = %d actual length = %d", calling_method, urb->buffer_length, urb->actual_length );

	if (urb->buffer && (0 < urb->buffer_length)) {
		static const char hex[] = "0123456789abcdef";
		int i, loglen = (3*urb->buffer_length);
		char logbuf[loglen], *bufp = logbuf;
		char* p = (char *)urb->buffer;
		for (i=0; i<urb->buffer_length; i++) {
			int c = *p++;
			*bufp++ = hex[(c>>4)&0xf]; // index to array
			*bufp++ = hex[c&0xf]; // index to array
			*bufp++ = ' ';
		}
		logbuf[loglen-1] = 0; // null terminate string
		log( LOG_URB_DATA, "%s : URB data = %s", calling_method, logbuf );
 	} else {
 		log( LOG_URB_DATA, "%s : URB data empty", calling_method );
 	}
}

//added by kawakubo
static inline u_int16_t uWordTou_int16_t(uWord value){
	return (value[0] | ((value)[1] << 8));
}

/**
 * Debug a UCR.
 * @env The JNIEnv*.
 * @param calling_method The name of the calling method.
 * @param urb The usb_ctl_request.
 */
static inline void debug_ucr( JNIEnv *env, char *calling_method, struct usb_ctl_request *ucr )
{
	if (!tracing)
		return;

//FIXME - add device number and/or other dev info
	log( LOG_URB_METADATA, "%s : UCR addr = %d flags = %d actlen = %d", calling_method, ucr->addr, ucr->flags, ucr->actlen );
	log( LOG_URB_METADATA, "%s : UCR request bmRequestType = %x bRequest = %x", calling_method, ucr->request.bmRequestType, ucr->request.bRequest );
	log( LOG_URB_METADATA, "%s : UCR request wValue = %x wIndex = %x wLength = %x", calling_method, uWordTou_int16_t(ucr->request.wValue), uWordTou_int16_t(ucr->request.wIndex), uWordTou_int16_t(ucr->request.wLength) );

	if (ucr->data && (0 < ucr->actlen)) {
		static const char hex[] = "0123456789abcdef";
		int i, loglen = (3*ucr->actlen);
		char logbuf[loglen], *bufp = logbuf;
		char* p = (char *)ucr->data;
		for (i=0; i<ucr->actlen; i++) {
			int c = *p++;
			*bufp++ = hex[(c>>4)&0xf]; // index to array
			*bufp++ = hex[c&0xf]; // index to array
			*bufp++ = ' ';
		}
		logbuf[loglen-1] = 0; // null terminate string
		log( LOG_URB_DATA, "%s : UCR data = %s", calling_method, logbuf );
 	} else {
 		log( LOG_URB_DATA, "%s : UCR data empty", calling_method );
 	}
}

#endif /* _JAVAXUSBUTIL_H */

