#ifdef DEBUG_ICC
#include <pthread.h>
#include <stdio.h>
#include <stdarg.h>
#include <mfprintf.h>
#include <mdebug.h> /* for _mdebug() */
#include <read_time.h> /* for read_microsec() */
#include "pcsc_mdebug.h"

/*-- for ICCARD mmesg(֐|C^) --*/
/*
2007/08݁Amf_pcsc()read_microsec() ̋L
65ȏ㏉łȂQ̑Ή 
*/

void (*fp_mf_pcsc)(const char *fmt, ...) = 0; /* ֐|C^̏ */
void setMfPcsc(void* fp){
	fp_mf_pcsc = fp;
}

void _mf_pcsc_format(const char* prefix, const char *fmt, va_list ap){
	char buf[BUFF_SIZE];
	int offset = 0;
	
	memset(buf, 0, BUFF_SIZE);
	
	if(0 == fp_mf_pcsc) return;
//	snprintf(buf, BUFF_SIZE, "%10.6f:%s", getSecond(), prefix);
	offset = strlen(buf);
	vsnprintf(buf + offset, BUFF_SIZE - offset, fmt, ap);
	
	// pcsc log_msgX add line feed
	offset = strlen(buf);
	buf[offset] = '\n';
	
	(*fp_mf_pcsc)(buf);
}

void _mf_pcsc(const char *fmt, ...){
	char buff[BUFF_SIZE];
	va_list ap;
	if(0 == fp_mf_pcsc) return;

	/*
	dlopen()ꂽł́APłȂƐɓ삵Ȃ̂
	buffɊi[
	*/
	va_start(ap, fmt);
	vsnprintf(buff, BUFF_SIZE, fmt, ap);
	(*fp_mf_pcsc)(buff);
	va_end(ap);
}

u_long (*fp_read_microsec)(void) = 0; /* ֐|C^̏ */
void setReadMicrosec(void* fp){
	fp_read_microsec = fp;
}
u_long mf_read_microsec(){
	if(0 == fp_read_microsec) return 0;
	return (*fp_read_microsec)();
}

double getSecond(){
	struct timeval tv;
	gettimeofday(&tv, NULL);
	return tv.tv_sec + (double)tv.tv_usec * 1e-6;
}

#undef _MF_PRINT_DEFINITION
#endif
