/*
 * Copyright (c) 2010 RICOH Co. Ltd. All rights reserved.
 */

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <stdio.h>
#include <stdarg.h>
#include <fcntl.h>

#include "mfprintf.h"
#include "mfpr_shm.h"
#include "mfpr_if.h"


void *
mfprintf_create(key, size)
	key_t	key;
	int	size;
{
	void	*argv[2];
	int	ret;
	int	retval;

	argv[0] = (void *)key;
	argv[1] = (void *)size;
	ret = _mfextension(EXT_MFCREATE, 2, argv, &retval);
	if (ret == 0)
		ret = retval;
	return ((void *)ret);
}

void
mfprintf(void *id, const char *fmt, ...)
{
	va_list	ap;
	void	*argv[3];
	int	ret;
	int	retval;

	if (id == NULL || id == (void *)(-1))
		return;

	va_start(ap, fmt);
	argv[0] = (void *)id;
	argv[1] = (void *)fmt;
	argv[2] = (void *)ap;
	ret = _mfextension(EXT_VMFPRINTF, 3, argv, &retval);
	va_end(ap);
}

void
vmfprintf(void *id, const char *fmt, va_list ap)
{
	void	*argv[3];
	int	ret;
	int	retval;

	if (id == NULL || id == (void *)(-1))
		return;
	argv[0] = (void *)id;
	argv[1] = (void *)fmt;
	argv[2] = (void *)ap;
	ret = _mfextension(EXT_VMFPRINTF, 3, argv, &retval);
}

void
mfputs(s, id)
	const char	*s;
	void	*id;
{
	void	*argv[2];
	int	ret;
	int	retval;

	if (id == NULL || id == (void *)(-1))
		return;

	argv[0] = (void *)id;
	argv[1] = (void *)s;
	ret = _mfextension(EXT_MFPUTS, 2, argv, &retval);
}

void
mfhexdump(id, addr, len)
	void	*id;
	char	*addr;
	int	len;
{
	void	*argv[3];
	int	ret;
	int	retval;

	if (id == NULL || id == (void *)(-1))
		return;

	argv[0] = (void *)id;
	argv[1] = (void *)addr;
	argv[2] = (void *)len;
	ret = _mfextension(EXT_MFHEXDUMP, 3, argv, &retval);
}

int
mfprintf_control(id, command, arg)
	void	*id;
	int	command;
	char	*arg;
{
	void	*argv[3];
	int	ret = -1;
	int	retval;

	if (id == NULL || id == (void *)(-1))
		return (-1);

	switch (command) {
	case MFPRINTF_DELETE:
		argv[0] = (void *)id;
		argv[1] = (void *)arg;
		ret = _mfextension(EXT_MFDELETE, 2, argv, &retval);
		break;

	case MFPRINTF_STOP:
		argv[0] = (void *)id;
		argv[1] = (void *)MF_DISABLE;
		argv[2] = (void *)arg;
		ret = _mfextension(EXT_MFFLAGS, 3, argv, &retval);
		break;

	case MFPRINTF_TIMESTAMP:
		argv[0] = (void *)id;
		argv[1] = (void *)MF_TIMESTAMP;
		argv[2] = (void *)arg;
		ret = _mfextension(EXT_MFFLAGS, 3, argv, &retval);
		break;

	case MFPRINTF_SINGLEBUFFER:
		argv[0] = (void *)id;
		argv[1] = (void *)MF_ONESHOT;
		argv[2] = (void *)arg;
		ret = _mfextension(EXT_MFFLAGS, 3, argv, &retval);
		break;

	case MFPRINTF_STATUS:
		argv[0] = (void *)id;
		argv[1] = (void *)arg;
		ret = _mfextension(EXT_STATUS, 2, argv, &retval);
		break;

	default:
		break;
	}

	return (ret);
}


