/*
 * Copyright (c) 2010 RICOH Co. Ltd. All rights reserved.
 */

#include <sys/types.h>
#include <stdio.h>
#include <stdarg.h>

#include "mfprintf.h"
#include "mfpr_if.h"

int	mprintf_create __P((key_t, int));
int	mprintf_delete __P((void));
void	mprintf __P((const char *, ...));
void	vmprintf __P((const char *, va_list));
void	mputs __P((const char *));

void	*mprintf_compat = NULL;


int
mprintf_create(key, size)
	key_t	key;
	int	size;
{
	void	*mf;

	mf = mfprintf_create(key, size);
	if (mf == NULL || mf == (void *)-1)
		return (-1);
	mprintf_compat = mf;
	return ((int)mf);
}

int
mprintf_delete()
{
	if (mfprintf_control(mprintf_compat, MFPRINTF_DELETE, (char *)1) == -1)
		return (-1);
	mprintf_compat = NULL;
	return (0);
}

void
mputs(str)
	const char	*str;
{
	mfputs(str, mprintf_compat);
}

void
vmprintf(fmt, ap)
	const char	*fmt;
	va_list		ap;
{
	vmfprintf(mprintf_compat, fmt, ap);
}

void
mprintf(const char *fmt, ...)
{
	va_list	ap;

	va_start(ap, fmt);
	vmprintf(fmt, ap);
	va_end(ap);
}


