/*
 * Copyright (c) 2010 RICOH Co. Ltd. All rights reserved.
 */

#ifndef __MFPRINTF_H__
#define __MFPRINTF_H__

#include <stdarg.h>

void	*mfprintf_create __P((key_t, int));
void	mfprintf __P((void *, const char *, ...));
void	mfputs __P((const char *, void *));
void	mfhexdump __P((void *, char *, int));
int	mfprintf_control __P((void *, int, char *));
void	vmfprintf __P((void *, const char *, va_list));


#define	MFPRINTF_STATUS		1
#define	MFPRINTF_DELETE		2	
#define MFPRINTF_STOP		3	
#define	MFPRINTF_TIMESTAMP	4	
#define	MFPRINTF_SINGLEBUFFER	5	


struct mf_status {
	int	ms_version;		
	int	ms_time;		
	pid_t	ms_pid;			
	key_t	ms_key;			
	volatile char	*ms_head;	
	volatile char	*ms_tail;	
	volatile char	*ms_wpos;	
	char	*ms_reserved;		
};

#endif 

