#undef TRACE_SYSTEM
#define TRACE_SYSTEM cpuidle

#if !defined(_TRACE_CPUIDLE_H) || defined(TRACE_HEADER_MULTI_READ)
#define _TRACE_CPUIDLE_H

#include <linux/tracepoint.h>
#include <linux/cpumask.h>

#define poke_args &cpuidle_coupled_poke_pending, &cpuidle_coupled_poked
#define cpuidle_trace_args dev, poke_args

DECLARE_EVENT_CLASS(cpuidle_coupled,

	TP_PROTO(struct cpuidle_device *dev,
		 const struct cpumask *pnd,
		 const struct cpumask *poked),

	TP_ARGS(dev, pnd, poked),

	TP_STRUCT__entry(
		__bitmask(pnd, nr_cpumask_bits)
		__bitmask(poked, nr_cpumask_bits)
		__field(int, online)
		__field(unsigned, ready_waiting_counts)
		__field(int, requested_state)
	),

	TP_fast_assign(
		__assign_bitmask(pnd, cpumask_bits(pnd), nr_cpumask_bits);
		__assign_bitmask(poked, cpumask_bits(poked), nr_cpumask_bits);
		__entry->online = dev->coupled->online_count;
		__entry->ready_waiting_counts = atomic_read(&dev->coupled->ready_waiting_counts);
		__entry->requested_state = dev->coupled->requested_state[dev->cpu];
	),

	TP_printk("poked=%s pnd=%s rdw=0x%x o=%d req=%d",
		  __get_bitmask(poked),
		  __get_bitmask(pnd),
		  __entry->ready_waiting_counts,
		  __entry->online,
		  __entry->requested_state)
);

#define DEFINE_CPUIDLE_COUPLED_EVENT(name) \
DEFINE_EVENT(cpuidle_coupled, coupled_ ## name, \
 \
	TP_PROTO(struct cpuidle_device *dev, \
		 const struct cpumask *pnd, \
		 const struct cpumask *poked), \
 \
	TP_ARGS(dev, pnd, poked) \
)

DEFINE_CPUIDLE_COUPLED_EVENT(enter);
DEFINE_CPUIDLE_COUPLED_EVENT(resched_in_prevent);
DEFINE_CPUIDLE_COUPLED_EVENT(poke_others);
DEFINE_CPUIDLE_COUPLED_EVENT(resched_waiting);
DEFINE_CPUIDLE_COUPLED_EVENT(resched_waiting_prevent);
DEFINE_CPUIDLE_COUPLED_EVENT(resched_cleared_pokes);
DEFINE_CPUIDLE_COUPLED_EVENT(retry);
DEFINE_CPUIDLE_COUPLED_EVENT(reset_enter);
DEFINE_CPUIDLE_COUPLED_EVENT(reset_exit);
DEFINE_CPUIDLE_COUPLED_EVENT(enter_state);

TRACE_EVENT(coupled_handle_poke,

	TP_PROTO(const struct cpumask *pnd,
		 const struct cpumask *poked),

	TP_ARGS(pnd, poked),

	TP_STRUCT__entry(
		__bitmask(pnd, nr_cpumask_bits)
		__bitmask(poked, nr_cpumask_bits)
	),

	TP_fast_assign(
		__assign_bitmask(pnd, cpumask_bits(pnd), nr_cpumask_bits);
		__assign_bitmask(poked, cpumask_bits(poked), nr_cpumask_bits);
	),

	TP_printk("poked=%s pnd=%s",
		  __get_bitmask(poked),
		  __get_bitmask(pnd))
);

#endif

#include <trace/define_trace.h>
