/***** -*- C -*- **************************************
 *
 * Copyright (C) 2003 Ricoh Company, Ltd.  All Rights Reserved.
 *   ORDER           : USB2.0 device driver
 *   PROGRAM NAME    : Common headder file
 *   FILE NAME       : ucom.h
 *   VERSION         : $Revision: 1.7 $
 *   DESIGNER        : Hiroshi Yamasita
 *   AUTHOR          : $Author: cb285 $
 ******************************************************/


#ifndef _DEV_GW_USB_UCOM_H_
#define _DEV_GW_USB_UCOM_H_

/**
 * @file
 *   USB(t@NV)foCXhCõwb_t@CB
 *   ([Uh)
 *
 *   foCXhCoANZXɕKvƂȂf[^\A}N`sB
 *   ڍׂ LPUX݌vdlDB ̃C^tF[XdlQƂ̂
 */


/*
 * DEVICE request
 */
#define GET_STATUS		0x00
#define CLR_FEATURE		0x01
#define SET_FEATURE		0x03
#define SET_ADDRESS		0x05
#define GET_DESCRIPTOR		0x06
#define SET_DESCRIPTOR		0x07
#define GET_CONFIGURATION	0x08
#define SET_CONFIGURATION	0x09
#define GET_INTERFACE		0x0a
#define SET_INTERFACE		0x0b

/*
 * Feature Selector
 *	(CLR_FEATURE/SET_FEATUREwValue)
 */
#define FS_REMOTEWAKEUP		(0x01)
#define FS_TEST_MODE		(0x02)
#define FS_EP_HALT 			(0x00)

/************************************************************
 *
 * Data structure on CONTROL transfer device driver
 *
 */

/*
 * NEC2foCXhCo\͏
 */
#define UCNEC2_MAX_CFG_NUM		1	/**< őRtBM[V */
#define UCNEC2_MAX_IF_NUM		16	/**< őC^tFCX */
#define UCNEC2_MAX_IFALT_NUM	8	/**< őC^tFCX֐ */
#define UCNEC2_MAX_EPI_NUM		6	/**< őoNCEP(MAX7) */
#define UCNEC2_MAX_EPO_NUM		6	/**< őoNAEgEP(MAX7) */
/** őGh|Cg(EP0͊܂܂Ȃ) */
#define UCNEC2_MAX_EP_NUM		(UCNEC2_MAX_EPI_NUM + UCNEC2_MAX_EPO_NUM)

/*
 * 'cmd' value on read system call
 */
#define UCG_NONCMD	0
#define	UCG_STATE	1	/* get status */
#define UCG_CTLDATA	100	/* require CONTROL transfer */
/*
 * USB state
 */
#define UCST_NOT_ATTACHED	0x01	/* ڑ		*/
#define UCST_ATTACHED		0x02	/* ڑE	*/
#define UCST_POWERED		0x04	/* Jn		*/
#define UCST_ADDRESS		0x08	/* Bus enumlation	*/
#define UCST_CONFIGURED		0x10	/* Enumlation 	*/
#define UCST_ERROR		0x20	/* G[		*/
/*
 * detail of USB state
 */
#define UCST_ERR_CRC		0x2000	/* CRC error	*/
#define UCST_ERR_RX		0x1000	/* RECIVE error	*/
#define UCST_ERR_STALL		0x0800	/* STALL	*/
#define UCST_ATT_START		0x0080	/* Debug	*/
#define UCST_ATT_REQUEST	0x0040	/* Debug	*/
#define UCST_ATT_SETUP		0x0020	/* Debug	*/
#define UCST_ATT_SETUPENABLE	0x0010	/* Debug	*/
#define UCST_ATT_RXTRANS	0x0008	/* Debug	*/
#define UCST_ATT_TXTRANS	0x0004	/* Debug	*/

/*
 * sub_infoɓf[^
 */
/* 4bit: USB][h */
#define GWUSB_FULLSPEED		0x01	/**< FS][h */
#define GWUSB_HIGHSPEED		0x02	/**< HS][h */
#define GWUSB_SPEED_MASK	0x0F	/**< ]xp}XN */
/* 4bit: USB샂[h */
#define GWUSB_MODE_LEGACY	0x00	/**< ]w */
#define GWUSB_MODE_IPP		0x10	/**< IPPw */
#define GWUSB_CHANGE_IFINFO	0x20	/**< IFIFύXL */
#define GWUSB_MODE_MASK		0xF0	/**< dlpr}XN */

/*
 * USB controlreadR[ŃvZXǂ݂\
 */
typedef struct usbctrl_read {
	u_char		cmd;		/* R}h			*/
	u_char		state;		/* foCX			*/
	u_int32_t	sub_state;	/* foCXTu		*/
	u_char		sub_info;	/* foCXTu		*/
	u_char		cont[0];	/* Rg[]擾f[^	*/
} uc_read_t;
/* cmdUCG_CTLDATȀꍇsub_infoɐݒ肷l */
#define UC_DIR_IN			0x80	/**< ]: IN */
#define UC_DIR_OUT			0x00	/**< ]: OUT */

/*
 * usbctrl_writecmdŎgpR}h
 */
#define UCS_NONCMD		0	/* R}h */
#define UCS_STATE		10	/* ԗv	*/
#define UCS_STDDESC_FS		1	/* standard desc.o^	*/
#define UCS_CONFDESC_FS		2	/* configuration desc.o^ */
#define UCS_MCONFDESC_FS       	4	/* configuration, interface, endpoint desc.  o^ */
#define UCS_STDDESC_HS		16	/* standard desc.o^	*/
#define UCS_CONFDESC_HS		32	/* configuration desc.o^ */
#define UCS_MCONFDESC_HS       	64	/* configuration, interface, endpoint desc.  o^ */
#define UCS_STRDESC		20	/* string desc.o^ */
#define UCS_OSCDESC		21	/* other speed configuration desc.o^ */
#define UCS_DEVQFRDESC		22	/* device qualifier desc.o^ */
#define UCS_CLASSDESC		23	/* class spesific desc.(GET_DEV_ID)o^ */
#define UCS_CLASSDESCEXT	24	/* statuso^ */
#define UCS_PORT_STATUS		25	/* GET_PORT_STATUS X|Xݒ */
#define UCS_SUPPORTLANG		26	/* T|[gĂ錾ꃊXg */
#define UCS_OSC_MDESC		27	/* other speed configration multi desc */
#define UCS_CLASSDESCEXT2	28	/* DEVICE_IDXVptB[ho^ */
#define UCS_DEVINFO			29	/* device info desc.o^ */
#define	UCS_D_PLUS_ON		30	/* D+ CONɂ		*/
#define	UCS_D_PLUS_OFF		31	/* D+ COFFɂ		*/
#define UCS_CHGSPEED		40	/* ][h̐؂ւ */
#define UCS_SETIF_CTL		41	/* SET_INTERFACEM؂ւ */
#define UCS_DESC_CLR		50	/* descriptore[ubufNA */
#define UCS_RESET		100	/* USBZbgv(STALL) */
#define UCS_ERR_TEST		101	/* ERRORXe[^XL[ɃZbg */
#define UCS_CTLDATA		200
#define UCS_IPATTERN	        201     /* fobOp I-Pattern */
#define UCS_SOFCOUNT		202	/* fobOp SOF */


#define UCS_STDDESC		UCS_STDDESC_FS
#define UCS_CONFDESC		UCS_CONFDESC_FS
#define UCS_MCONFDESC		UCS_MCONFDESC_FS

/*
 * fBXNv^TCY
 */
#define	UCS_STDDESC_SZ		18	/* Œ */
#define	UCS_CONFDESC_SZ		9	/* Œ */
#define	UCS_STRDESC_SZ		64	/* őPpPbg */
#define UCS_DEVQFRDESC_SZ	10	/* Œ */
#define UCS_OSCDESC_SZ		9	/* Œ */
#define UCS_CLASSDESC_SZ	512	/* GET_DEVICE_IDŕԂ(IEEE1284Ɠ) */

/*
 * UCS_CHGSPEEDŎgpnop}N
 */
#define FS_FIXED	0x01
#define HS_FIXED	0x02
#define HS_CHARP	0x04

#define UCS_FS_FIXED	0x01
#define UCS_HS_FIXED	0x02
#define UCS_HS_CHARP	0x04	/* default */


/*
 * UCS_SETIF_CTLŎgpnop}N
 *	SET_INTERFACEM̏ݒ肷
 *	EUCS_SETIF_NORMAL
 *	   ΏIFAltIFɕωꍇTogglẽZbgsȂ
 *	EUCS_SETIF_RST
 *	   ΏIFAltIFɕωꍇTogglẽZbgs
 */
#define UCS_SETIF_NORMAL	0x00	/* default */
#define UCS_SETIF_RST		0x01
/*
 * USB controlwriteR[ŃvZXǂ݂\
 */
typedef struct usbctrl_write {
	u_short	cmd;		/* ݎw(cmd)	*/
	u_char	no;		/* ԍ(descŎgp)	*/
	u_short	langID;		/* ԍ(descID)	*/
	u_char	cont[0];	/* ݓe(ϒ)		*/
} uc_write_t;

/******* ioctl *******/

typedef struct usb_bufinfo {
	u_long		bufsize;	/* mmapŊmۂłMobt@̃TCY */
	u_long		descsize;	/* 1̃fBXNv^TCY */
	u_long		ndesc;		/* fBXNv^̍ő */
} usb_bufinfo_t;

typedef struct usb_epinfo {
	u_char		epno;		/* endpointԍ */
	u_char		epattr;		/* ]^Cv */
	u_char		epdir;		/* ] */
} usb_epinfo_t;

typedef struct usb_epconf {
	u_char		bcdusb[2];	/* USB[Xԍ */
	u_char		numep;		/* endpoint̐ */
	u_char		ver;		/* hCoo[W */
	usb_epinfo_t	epinfo[33];
} usb_epconf_t;

typedef struct interface_getinfo {
	u_char	alt_setting_now[UCNEC2_MAX_IF_NUM];	/**< ݂̑փC^tF[Xԍ */
} uc_interface_getinfo_t;

typedef struct interface_info {
	u_char	interface_num;	/* C^[tF[Xԍ(bInterfaceNumber) */
	u_char	alt_setting_num;	/* փC^tF[X(AlternateSetting) */
	u_char	ep_info[UCNEC2_MAX_IFALT_NUM][UCNEC2_MAX_EP_NUM]; /* Gh|CgAhX(bEndpointAddress) */
} uc_interface_info_t;

typedef struct usb_bulkinfo {
	u_char	epaddr;			/* foCX䂷EPAhX */
} usb_bulkinfo_t;


typedef struct if_comp_s {
	u_char	is_set;					/**< ݒԊmFptO */
	u_char	alt_set;				/**< ݂̑փC^tF[X */
	u_char	alt_num;				/**< փC^tF[X(#0܂) */
	u_char	ep_comp[UCNEC2_MAX_IFALT_NUM][UCNEC2_MAX_EP_NUM];
										/**< Gh|Cg\ */
} if_comp_s_t;

typedef struct dev_comp_s {
	/* Ƃ肠AC^tF[X񂩂ێ */
	if_comp_s_t if_comp[UCNEC2_MAX_IF_NUM];	/**< C^tF[X\ */
	u_char	if_num;					/**< C^tF[X */
	u_char	if_set;					/**< ݂̃C^tF[X */
} dev_comp_t;


#define UC_MAX_NOTIFY_REQ		16	/**< őʒmΏۃNGXg */
#define UC_SETUP_PTK_SIZE		8	/**< setuppPbgTCY */

/* len_check_type̐ݒl */
#define UC_LENCHK_TYPE_NONE		0	/**< wLength`FbNȂ */
#define UC_LENCHK_TYPE_EQUAL	1	/**< wLength`FbNv */
#define UC_LENCHK_TYPE_ABOVE	2	/**< wLength`FbN */
#define UC_LENCHK_TYPE_BELOW	3	/**< wLength`FbN */

/* IOCSCTLDATAsetup_pkt[0]̐ݒl */
#define UC_SEND_NONE		0x00	/**< f[^Msv(Control OUT) */
#define UC_SEND_DATA		0x01	/**< f[^Mݒ(Control IN) */
#define UC_SEND_STALL		0x80	/**< STALLM(G[Ȃ) */

typedef struct notify_req {
	u_char		setup_pkt[UC_SETUP_PTK_SIZE];	/* ʒmΏۃNGXgsetuppPbg */
	u_short		len_check_type;					/* wLength@ */
} uc_notify_req_t;

typedef struct ctl_data {
	u_char		data_no;						/* NGXgʔ (1 - 255) */
	u_char		setup_pkt[UC_SETUP_PTK_SIZE];	/* setuppPbg */
	u_short		data_len;						/* datapPbg */
	u_char		*data_pkt;					/* datapPbg() */
} uc_ctl_data_t;

#define UC_CHANGE_INFO_NONE 0x00			/**ύXȂ */
#define UC_CHANGE_INFO_START 0x01				/**bulkoutXbhselect𔲂 */
#define UC_CHANGE_INFO_FINISH 0x02				/**bulkoutXbhselect𔲂 + statsuXe[WɈڍs */
typedef struct interface_changeinfo {
	u_char chnaginfo;	/* [h̐؂ւ */
} uc_interface_changeinfo_t;

typedef struct ep_getstate {
	u_char ep_dma_state[UCNEC2_MAX_IF_NUM];	/* IF̎wGh|Cg̏ */
} uc_ep_getstate_t;


#define IOCGBUFINFO		_IOR('K', 1, usb_bufinfo_t)
#define IOCGEPCONF		_IOR('K', 2, usb_epconf_t)
#define IOCSEPINFO		_IOW('K', 3, uc_interface_info_t)
#define IOCGBULKINFO	_IOR('K', 4, usb_bulkinfo_t)
#define IOCSNOTIFYREQ	_IOW('K', 5, uc_notify_req_t)
#define IOCDNOTIFYREQ	_IOW('K', 6, uc_notify_req_t)
#define IOCGCTLDATA		_IOWR('K', 7, uc_ctl_data_t)
#define IOCSCTLDATA		_IOWR('K', 8, uc_ctl_data_t)
#define IOCGIFINFO		_IOR('K', 9, uc_interface_getinfo_t)
#define IOCSIFCHANGE	_IOW('K', 10, uc_interface_changeinfo_t)
#define IOCGEPSTATE		_IOR('K', 11, uc_ep_getstate_t)
#define IOCTESTDATA		_IOWR('K', 12, uc_ctl_data_t)

/******* bulk transfer *******/

/*
 * readŕԂstatus (bulk IN/OUT)
 */
#define DMA_OFF		0x00U	/* DMA~	*/
#define DMA_ON		0x01U	/* DMAJn	*/
#define DMA_MASK	0x01U	/* DMA bit	*/
#define IRP_START	0x02U	/* IRP̎n	*/
#define IN_TRANS	0x04U	/* ]	*/
#define IRP_END		0x08U	/* IRP̏I	*/
#define DMA_ENABLE	0x10U	/* DMAN\	*/
#define DESC_FULL	0x20U	/* fBXNv^t (BULKIN̂) */
#define IF_CHANGE	0x40U	/* SET_INTERFACEM */
#define IF_CHANGED	0x80U	/* SET_INTERFACEM */
#define SO_MASK	0x00FFFF00
#define SO_00		(1 << (0 + 8))	/* SOFlag Information (for Debug) */
#define SO_01		(1 << (1 + 8))
#define SO_02		(1 << (2 + 8))
#define SO_03		(1 << (3 + 8))
#define SO_04		(1 << (4 + 8))
#define SO_05		(1 << (5 + 8))
#define SO_06		(1 << (6 + 8))
#define SO_07		(1 << (7 + 8))
#define SO_08		(1 << (8 + 8))
#define SO_09		(1 << (9 + 8))
#define SO_10		(1 << (10 + 8))
#define SO_11		(1 << (11 + 8))
#define SO_12		(1 << (12 + 8))
#define SO_13		(1 << (13 + 8))
#define SO_14		(1 << (14 + 8))
#define SO_15		(1 << (15 + 8))
#define ERR_INFO	(1 << 31)	/* Error Status */

#define UBS_DMA_OFF	DMA_OFF
#define UBS_DMA_ON	DMA_ON
#define UBS_DMA_MASK	DMA_MASK
#define UBS_IRP_START	IRP_START
#define UBS_IN_TRANS	IN_TRANS
#define UBS_IRP_END	IRP_END
#define UBS_DMA_ENABLE	DMA_ENABLE
#define UBS_DESC_FULL	DESC_FULL
#define UBS_ERR_INFO	ERR_INFO
#define UBS_IF_CHANGE	IF_CHANGE
#define UBS_IF_CHANGED	IF_CHANGED

/*
 * USB bulk outreadR[ŃvZXǂ݂\
 */
typedef struct usbblkout_read {
	u_long		status;
	u_long		offset;
	u_long		size;
} ubo_read_t;

/*
 * usbblkout_writecmdŎgpR}h
 */
#define UBO_NONE		0	/* size, offsetԋp̂ */
#define UBO_DMASTART		1	/* DMA */
#define UBO_DMASTOP		2	/* DMA~ */
#define UBO_BUFFLUSH		3	/* init buffer */
#define UBO_DMAHOLD		4	/* DMAꎞ~ */
#define UBO_DMARESTART		5	/* DMAĊJ */

/*
 * USB bulk outwriteR[ŃvZXǂ݂\
 */
typedef struct usbblkout_write {
	u_long		cmd;
	u_long		offset;
	u_long		size;
} ubo_write_t;

/*
 * USB bulk inreadR[ŃvZXǂ݂\
 */
typedef struct usbblkin_read {
	u_long		status;
	u_long		start;		/* ߂ItZbgCfbNX */
	u_long		size;		/* 󂫃TCY */
} ubi_read_t;

/*
 * USB bulkIN writeR[ŎgpR}h
 */
#define UBI_STATUS		0	/* Xe[^Xv */
#define UBI_DMASTART		1	/* DMAJn */
#define UBI_DMASTOP		2	/* DMA~(\) */
#define UBI_FLUSH		3	/* buffer flush */
#define UBI_IRP_START		4	/* ]Jn */
#define UBI_DATA_CONTINUE	5	/* IRP */
#define UBI_IRP_END		6	/* ̃R}hƈꏏɑf[^œ]I */
#define UBI_DMAHOLD		7	/* DMAꎞ~ */
#define UBI_DMARESTART		8	/* DMAĊJ */

/*
 * USB bulk inwriteR[ŃvZXǂ݂\
 */
typedef struct usbblkin_write {
	u_long		cmd;
	u_long		start;
	u_long		size;
} ubi_write_t;

#endif /* _DEV_GW_USB_UCOM_H_ */

#define VENDER_CODE_IPP	0x04	/* IPP*/
/*
 * Local Variables:
 * c-basic-offset: 8
 * End:
 */
