 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _UART_REGSTRUCTS_H_
#define _UART_REGSTRUCTS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: UART (uart)
//
//====================================================================

typedef struct UART_REGS_s
{
 union {
  volatile uint32_t UART_RBR;  ///< 0x0 [R]: Receive Buffer Register
  volatile uint32_t UART_THR;  ///< 0x0 [W]: Transmit Holding Register
  volatile uint32_t UART_DLL;  ///< 0x0 [R/W]: Divisor Latch Low Byte Register
 } union0;
 union {
  volatile uint32_t UART_IER;  ///< 0x4 [R/W]: Interrupt Enable Register
  volatile uint32_t UART_DLH;  ///< 0x4 [R/W]: Divisor Latch High Byte Register
 } union1;
 union {
  volatile uint32_t UART_IIR;  ///< 0x8 [R]: Interrupt Identification Register
  volatile uint32_t UART_FCR;  ///< 0x8 [W]: FIFO Control Register
 } union2;
  volatile uint32_t UART_LCR;  ///< 0xc [R/W]: Line Control Register
  volatile uint32_t UART_MCR;  ///< 0x10 [R/W]: Modem Control Register
  volatile uint32_t UART_LSR;  ///< 0x14 [R]: Line Status Register
  volatile uint32_t UART_MSR;  ///< 0x18 [R]: Modem Status Register
  volatile uint32_t UART_SCR;  ///< 0x1c [R/W]: Scratchpad Register
  volatile uint32_t UART_ISR;  ///< 0x20 [R/W]: Infrared Selection Register
  volatile uint32_t UART_FOR;  ///< 0x24 [R]: Receive FIFO Occupancy Register
  volatile uint32_t UART_ABR;  ///< 0x28 [R/W]: Auto-Baud Control Register
  volatile uint32_t UART_ACR;  ///< 0x2c [R]: Auto-Baud Count Register
  volatile uint32_t REV0;  ///< 0x30 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x34 [R]: IP Tagging Revision 1
} UART_REGS_t;

#endif // UART
 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _UART_REGMASKS_H_
#define _UART_REGMASKS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: UART (uart)
//
//====================================================================

//====================================================================
//Register: Receive Buffer Register (UART_RBR)
/** \brief In non-FIFO mode, this register holds the character(s) received by the UART
Receive Shift Register. If this register is configured to use fewer than eight
bits, the bits are right-justified and the most significant bits (MSbs) are
zeroed. Reading the register empties the register and clears the <Data
Ready> field in the Line Status Register.
This register latches the value of the data byte at the front of the FIFO in
FIFO mode.*/
//====================================================================

#define  UART_UART_RBR_BYTE_3_MASK 0xff000000
#define  UART_UART_RBR_BYTE_3_SHIFT 24
#define  UART_UART_RBR_BYTE_3_MASK_SHIFT(reg) (((reg) & UART_UART_RBR_BYTE_3_MASK) >> UART_UART_RBR_BYTE_3_SHIFT)
#define  UART_UART_RBR_BYTE_3_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_RBR_BYTE_3_MASK) | (((uint32_t)val) << UART_UART_RBR_BYTE_3_SHIFT))

#define  UART_UART_RBR_BYTE_2_MASK 0xff0000
#define  UART_UART_RBR_BYTE_2_SHIFT 16
#define  UART_UART_RBR_BYTE_2_MASK_SHIFT(reg) (((reg) & UART_UART_RBR_BYTE_2_MASK) >> UART_UART_RBR_BYTE_2_SHIFT)
#define  UART_UART_RBR_BYTE_2_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_RBR_BYTE_2_MASK) | (((uint32_t)val) << UART_UART_RBR_BYTE_2_SHIFT))

#define  UART_UART_RBR_BYTE_1_MASK 0xff00
#define  UART_UART_RBR_BYTE_1_SHIFT 8
#define  UART_UART_RBR_BYTE_1_MASK_SHIFT(reg) (((reg) & UART_UART_RBR_BYTE_1_MASK) >> UART_UART_RBR_BYTE_1_SHIFT)
#define  UART_UART_RBR_BYTE_1_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_RBR_BYTE_1_MASK) | (((uint32_t)val) << UART_UART_RBR_BYTE_1_SHIFT))

#define  UART_UART_RBR_BYTE_0_MASK 0xff
#define  UART_UART_RBR_BYTE_0_SHIFT 0
#define  UART_UART_RBR_BYTE_0_MASK_SHIFT(reg) (((reg) & UART_UART_RBR_BYTE_0_MASK) >> UART_UART_RBR_BYTE_0_SHIFT)
#define  UART_UART_RBR_BYTE_0_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_RBR_BYTE_0_MASK) | (((uint32_t)val) << UART_UART_RBR_BYTE_0_SHIFT))

//====================================================================
//Register: Transmit Holding Register (UART_THR)
/** \brief This register holds the data byte(s) to be transmitted next in non-FIFO mode.
When the Transmit Shift Register is emptied, the contents of this register are
loaded into the Transmit Shift Register and the <Transmit Data Request> field in
the Line Status Register is set.
A write to Transmit Holding Register puts data into the top of the FIFO in FIFO
mode. The data at the front of the FIFO is loaded into the Transmit Shift
Register when the Transmit Shift Register is empty.*/
//====================================================================

#define  UART_UART_THR_BYTE_3_MASK 0xff000000
#define  UART_UART_THR_BYTE_3_SHIFT 24
#define  UART_UART_THR_BYTE_3_MASK_SHIFT(reg) (((reg) & UART_UART_THR_BYTE_3_MASK) >> UART_UART_THR_BYTE_3_SHIFT)
#define  UART_UART_THR_BYTE_3_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_THR_BYTE_3_MASK) | (((uint32_t)val) << UART_UART_THR_BYTE_3_SHIFT))

#define  UART_UART_THR_BYTE_2_MASK 0xff0000
#define  UART_UART_THR_BYTE_2_SHIFT 16
#define  UART_UART_THR_BYTE_2_MASK_SHIFT(reg) (((reg) & UART_UART_THR_BYTE_2_MASK) >> UART_UART_THR_BYTE_2_SHIFT)
#define  UART_UART_THR_BYTE_2_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_THR_BYTE_2_MASK) | (((uint32_t)val) << UART_UART_THR_BYTE_2_SHIFT))

#define  UART_UART_THR_BYTE_1_MASK 0xff00
#define  UART_UART_THR_BYTE_1_SHIFT 8
#define  UART_UART_THR_BYTE_1_MASK_SHIFT(reg) (((reg) & UART_UART_THR_BYTE_1_MASK) >> UART_UART_THR_BYTE_1_SHIFT)
#define  UART_UART_THR_BYTE_1_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_THR_BYTE_1_MASK) | (((uint32_t)val) << UART_UART_THR_BYTE_1_SHIFT))

#define  UART_UART_THR_BYTE_0_MASK 0xff
#define  UART_UART_THR_BYTE_0_SHIFT 0
#define  UART_UART_THR_BYTE_0_MASK_SHIFT(reg) (((reg) & UART_UART_THR_BYTE_0_MASK) >> UART_UART_THR_BYTE_0_SHIFT)
#define  UART_UART_THR_BYTE_0_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_THR_BYTE_0_MASK) | (((uint32_t)val) << UART_UART_THR_BYTE_0_SHIFT))

//====================================================================
//Register: Divisor Latch Low Byte Register (UART_DLL)
//====================================================================

#define  UART_UART_DLL_RESERVED1_MASK 0xffffff00
#define  UART_UART_DLL_RESERVED1_SHIFT 8
#define  UART_UART_DLL_RESERVED1_MASK_SHIFT(reg) (((reg) & UART_UART_DLL_RESERVED1_MASK) >> UART_UART_DLL_RESERVED1_SHIFT)
#define  UART_UART_DLL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_DLL_RESERVED1_MASK) | (((uint32_t)val) << UART_UART_DLL_RESERVED1_SHIFT))

#define  UART_UART_DLL_DLL_MASK 0xff
#define  UART_UART_DLL_DLL_SHIFT 0
#define  UART_UART_DLL_DLL_MASK_SHIFT(reg) (((reg) & UART_UART_DLL_DLL_MASK) >> UART_UART_DLL_DLL_SHIFT)
#define  UART_UART_DLL_DLL_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_DLL_DLL_MASK) | (((uint32_t)val) << UART_UART_DLL_DLL_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (UART_IER)
/** \brief This register enables the five types of interrupts that set a value in the
Interrupt Identification Register. Software must clear the appropriate bit in
this register to disable an interrupt. Software can enable some interrupts by
setting the appropriate bit.
The character timeout-indication interrupt is separated from the received
data-available interrupt to ensure that the PXA2128 Application Processor and
the DMA controller do not service the receive FIFO at the same time. When
a character-timeout-indication interrupt occurs, the PXA2128 Application
Processor must handle the data in the receive FIFO through programmed I/O.
An error interrupt is used when DMA requests are enabled. The interrupt is
generated when the <FIFO Error Status> field in the Line Status Register is set
because a receive DMA request is not generated when the receive FIFO has an
error. The error interrupt tells the PXA2128 Application Processor to handle the
data in the receive FIFO through programmed I/O. The error interrupt is enabled
when DMA requests are enabled, and it cannot be masked. Receiver line-status
interrupts occur when the error is at the front of the FIFO.
Note: When DMA requests are enabled and an interrupt occurs, software must first
read the Line Status Register to see if an error interrupt exists, then check
the Interrupt Identification Register for the source of the interrupt. Software
must read the Infrared Selected Register to determine the error condition if an
interrupt occurs and the <FIFO Error Status> field in the Line Status Register
is clear. DMA requests are automatically enabled when the last error byte is
read from the FIFO. Software is not required to check for the error interrupt if
DMA requests are disabled because an error interrupt occurs only when DMA
requests are enabled.
The <FIFO Error Status> field is used to enable DMA requests. This register also
contains the unit enable and NRZ coding enable control bits. Bits 7 through 4
are used differently from the standard 16550A register definition.
Note: Software must not set the <DMA Requests Enable> field while the <Transmit
Data Request Interrupt Enable> or <Receiver Data Available Interrupt
Enable> fields are set to ensure that the DMA controller and programmed I/O do
not access the same FIFO.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART_UART_IER_RESERVED1_MASK 0xfffffe00
#define  UART_UART_IER_RESERVED1_SHIFT 9
#define  UART_UART_IER_RESERVED1_MASK_SHIFT(reg) (((reg) & UART_UART_IER_RESERVED1_MASK) >> UART_UART_IER_RESERVED1_SHIFT)
#define  UART_UART_IER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_IER_RESERVED1_MASK) | (((uint32_t)val) << UART_UART_IER_RESERVED1_SHIFT))

#define  UART_UART_IER_FAST_MASK 0x100
#define  UART_UART_IER_FAST_SHIFT 8
#define  UART_UART_IER_FAST_MASK_SHIFT(reg) (((reg) & UART_UART_IER_FAST_MASK) >> UART_UART_IER_FAST_SHIFT)
#define  UART_UART_IER_FAST_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_IER_FAST_MASK) | (((uint32_t)val) << UART_UART_IER_FAST_SHIFT))

#define  UART_UART_IER_DMAE_MASK 0x80
#define  UART_UART_IER_DMAE_SHIFT 7
#define  UART_UART_IER_DMAE_MASK_SHIFT(reg) (((reg) & UART_UART_IER_DMAE_MASK) >> UART_UART_IER_DMAE_SHIFT)
#define  UART_UART_IER_DMAE_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_IER_DMAE_MASK) | (((uint32_t)val) << UART_UART_IER_DMAE_SHIFT))

#define  UART_UART_IER_UUE_MASK 0x40
#define  UART_UART_IER_UUE_SHIFT 6
#define  UART_UART_IER_UUE_MASK_SHIFT(reg) (((reg) & UART_UART_IER_UUE_MASK) >> UART_UART_IER_UUE_SHIFT)
#define  UART_UART_IER_UUE_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_IER_UUE_MASK) | (((uint32_t)val) << UART_UART_IER_UUE_SHIFT))

#define  UART_UART_IER_NRZE_MASK 0x20
#define  UART_UART_IER_NRZE_SHIFT 5
#define  UART_UART_IER_NRZE_MASK_SHIFT(reg) (((reg) & UART_UART_IER_NRZE_MASK) >> UART_UART_IER_NRZE_SHIFT)
#define  UART_UART_IER_NRZE_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_IER_NRZE_MASK) | (((uint32_t)val) << UART_UART_IER_NRZE_SHIFT))

#define  UART_UART_IER_RTOIE_MASK 0x10
#define  UART_UART_IER_RTOIE_SHIFT 4
#define  UART_UART_IER_RTOIE_MASK_SHIFT(reg) (((reg) & UART_UART_IER_RTOIE_MASK) >> UART_UART_IER_RTOIE_SHIFT)
#define  UART_UART_IER_RTOIE_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_IER_RTOIE_MASK) | (((uint32_t)val) << UART_UART_IER_RTOIE_SHIFT))

#define  UART_UART_IER_MIE_MASK 0x8
#define  UART_UART_IER_MIE_SHIFT 3
#define  UART_UART_IER_MIE_MASK_SHIFT(reg) (((reg) & UART_UART_IER_MIE_MASK) >> UART_UART_IER_MIE_SHIFT)
#define  UART_UART_IER_MIE_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_IER_MIE_MASK) | (((uint32_t)val) << UART_UART_IER_MIE_SHIFT))

#define  UART_UART_IER_RLSE_MASK 0x4
#define  UART_UART_IER_RLSE_SHIFT 2
#define  UART_UART_IER_RLSE_MASK_SHIFT(reg) (((reg) & UART_UART_IER_RLSE_MASK) >> UART_UART_IER_RLSE_SHIFT)
#define  UART_UART_IER_RLSE_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_IER_RLSE_MASK) | (((uint32_t)val) << UART_UART_IER_RLSE_SHIFT))

#define  UART_UART_IER_TIE_MASK 0x2
#define  UART_UART_IER_TIE_SHIFT 1
#define  UART_UART_IER_TIE_MASK_SHIFT(reg) (((reg) & UART_UART_IER_TIE_MASK) >> UART_UART_IER_TIE_SHIFT)
#define  UART_UART_IER_TIE_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_IER_TIE_MASK) | (((uint32_t)val) << UART_UART_IER_TIE_SHIFT))

#define  UART_UART_IER_RAVIE_MASK 0x1
#define  UART_UART_IER_RAVIE_SHIFT 0
#define  UART_UART_IER_RAVIE_MASK_SHIFT(reg) (((reg) & UART_UART_IER_RAVIE_MASK) >> UART_UART_IER_RAVIE_SHIFT)
#define  UART_UART_IER_RAVIE_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_IER_RAVIE_MASK) | (((uint32_t)val) << UART_UART_IER_RAVIE_SHIFT))

//====================================================================
//Register: Divisor Latch High Byte Register (UART_DLH)
//====================================================================

#define  UART_UART_DLH_RESERVED1_MASK 0xffffff00
#define  UART_UART_DLH_RESERVED1_SHIFT 8
#define  UART_UART_DLH_RESERVED1_MASK_SHIFT(reg) (((reg) & UART_UART_DLH_RESERVED1_MASK) >> UART_UART_DLH_RESERVED1_SHIFT)
#define  UART_UART_DLH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_DLH_RESERVED1_MASK) | (((uint32_t)val) << UART_UART_DLH_RESERVED1_SHIFT))

#define  UART_UART_DLH_DLH_MASK 0xff
#define  UART_UART_DLH_DLH_SHIFT 0
#define  UART_UART_DLH_DLH_MASK_SHIFT(reg) (((reg) & UART_UART_DLH_DLH_MASK) >> UART_UART_DLH_DLH_SHIFT)
#define  UART_UART_DLH_DLH_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_DLH_DLH_MASK) | (((uint32_t)val) << UART_UART_DLH_DLH_SHIFT))

//====================================================================
//Register: Interrupt Identification Register (UART_IIR)
//====================================================================

#define  UART_UART_IIR_RESERVED1_MASK 0xffffff00
#define  UART_UART_IIR_RESERVED1_SHIFT 8
#define  UART_UART_IIR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART_UART_IIR_RESERVED1_MASK) >> UART_UART_IIR_RESERVED1_SHIFT)
#define  UART_UART_IIR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_IIR_RESERVED1_MASK) | (((uint32_t)val) << UART_UART_IIR_RESERVED1_SHIFT))

#define  UART_UART_IIR_FIFOES10_MASK 0xc0
#define  UART_UART_IIR_FIFOES10_SHIFT 6
#define  UART_UART_IIR_FIFOES10_MASK_SHIFT(reg) (((reg) & UART_UART_IIR_FIFOES10_MASK) >> UART_UART_IIR_FIFOES10_SHIFT)
#define  UART_UART_IIR_FIFOES10_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_IIR_FIFOES10_MASK) | (((uint32_t)val) << UART_UART_IIR_FIFOES10_SHIFT))

#define  UART_UART_IIR_EOC_MASK 0x20
#define  UART_UART_IIR_EOC_SHIFT 5
#define  UART_UART_IIR_EOC_MASK_SHIFT(reg) (((reg) & UART_UART_IIR_EOC_MASK) >> UART_UART_IIR_EOC_SHIFT)
#define  UART_UART_IIR_EOC_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_IIR_EOC_MASK) | (((uint32_t)val) << UART_UART_IIR_EOC_SHIFT))

#define  UART_UART_IIR_ABL_MASK 0x10
#define  UART_UART_IIR_ABL_SHIFT 4
#define  UART_UART_IIR_ABL_MASK_SHIFT(reg) (((reg) & UART_UART_IIR_ABL_MASK) >> UART_UART_IIR_ABL_SHIFT)
#define  UART_UART_IIR_ABL_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_IIR_ABL_MASK) | (((uint32_t)val) << UART_UART_IIR_ABL_SHIFT))

#define  UART_UART_IIR_TOD_MASK 0x8
#define  UART_UART_IIR_TOD_SHIFT 3
#define  UART_UART_IIR_TOD_MASK_SHIFT(reg) (((reg) & UART_UART_IIR_TOD_MASK) >> UART_UART_IIR_TOD_SHIFT)
#define  UART_UART_IIR_TOD_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_IIR_TOD_MASK) | (((uint32_t)val) << UART_UART_IIR_TOD_SHIFT))

#define  UART_UART_IIR_IID10_MASK 0x6
#define  UART_UART_IIR_IID10_SHIFT 1
#define  UART_UART_IIR_IID10_MASK_SHIFT(reg) (((reg) & UART_UART_IIR_IID10_MASK) >> UART_UART_IIR_IID10_SHIFT)
#define  UART_UART_IIR_IID10_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_IIR_IID10_MASK) | (((uint32_t)val) << UART_UART_IIR_IID10_SHIFT))

#define  UART_UART_IIR_NIP_MASK 0x1
#define  UART_UART_IIR_NIP_SHIFT 0
#define  UART_UART_IIR_NIP_MASK_SHIFT(reg) (((reg) & UART_UART_IIR_NIP_MASK) >> UART_UART_IIR_NIP_SHIFT)
#define  UART_UART_IIR_NIP_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_IIR_NIP_MASK) | (((uint32_t)val) << UART_UART_IIR_NIP_SHIFT))

//====================================================================
//Register: FIFO Control Register (UART_FCR)
/** \brief This is a write-only register that is located at the same address as the
Interrupt Identification Register, which is a read-only register. This register
enables/disables the transmit/receive FIFOs, clears the transmit/receive FIFOs,
and sets the receive FIFO trigger threshold.
Note: The trigger level must be equal to the DMA burst length programmed in the
DMA registers.
Interrupt Trigger Level - When the number of bytes in the receive FIFO equals
the interrupt trigger level programmed into this field and the
received-data-available interrupt is enabled (via the Interrupt Enable
Register), an interrupt is generated and the appropriate bits are set in the
Interrupt Identification Register. The receive DMA request is generated as well
when trigger level is reached. The trigger level must be greater than or equal
to the DMA burst size programmed in the DMA registers.
32-Bit Peripheral Bus - When clear, the UART ignores any information in the
upper three bytes of the 32-bit bus. A full- or partial-word read or write to
the UART with this field clear increments the FIFO counters by only one byte. If
this field is set, a full- or partial-word read or write increments the counter
by the number of valid bytes within the word.
Trailing Bytes - When clear, trailing bytes are handled by the PXA2128
Application Processor. When set, trailing bytes are handled automatically by the
DMA controller. See the DMA section for more information.
Transmit Interrupt Level - Setting this field causes transmitter interrupts and
DMA requests to occur when the transmit FIFO is empty. Clearing this field
causes transmitter interrupts and DMA requests to occur when the transmit FIFO
is half empty.
Reset Transmit FIFO - When this field is set, the transmit FIFO counter is reset
to clear all the bytes in the FIFO. The <Transmit Data Request> field in the
Line Status Register is set, generating a transmitter-requests-data interrupt
(<Interrupt Source Encoded> field in the Interrupt Identification Register) if
the <Transmit Data Request Interrupt Enable> field in the Interrupt Enable
Register is set. The Transmit Shift Register is not reset, it completes the
current transmission. Any DMA or transmit-FIFO-service-request interrupts are
cleared.
Note: The <Reset Transmit FIFO> field is reset to 0 automatically after the FIFO
is cleared.
Reset Receive FIFO - When this field is set, the receive FIFO counter is reset
to clear all the bytes in the FIFO. The <Data Ready> field in the Line Status
Register is cleared. All error bits in the FIFO and the <FIFO Error
Status> field in the Line Status Register are cleared. Any error bits (OE, PE,
FE, or BI) that had been set in the Line Status Register remain set. The Receive
Shift Register is not cleared. Any DMA or receive-FIFO-service-request
interrupts are cleared.
Note: The <Reset Receive FIFO> field is reset automatically to 0 after the FIFO
is cleared.
Transmit and Receive FIFO Enable - This field enables and disables the transmit
and receive FIFOs. When it is set, both FIFOs are enabled (FIFO mode). When it
is clear, the FIFOs are both disabled (non-FIFO mode). Writing 0x0 to this bit
clears all bytes in both FIFOs. When changing from FIFO mode to non-FIFO mode
and vice versa, data is cleared automatically from the FIFOs. Any DMA or
FIFO-service-request interrupts are cleared when this field is clear.
Note: This field must be 1 when other fields in this register are written, or
the other fields are not programmed.
This is a write-only register. Write 0x0 to reserved bits.*/
//====================================================================

#define  UART_UART_FCR_RESERVED1_MASK 0xffffff00
#define  UART_UART_FCR_RESERVED1_SHIFT 8
#define  UART_UART_FCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART_UART_FCR_RESERVED1_MASK) >> UART_UART_FCR_RESERVED1_SHIFT)
#define  UART_UART_FCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_FCR_RESERVED1_MASK) | (((uint32_t)val) << UART_UART_FCR_RESERVED1_SHIFT))

#define  UART_UART_FCR_ITL_MASK 0xc0
#define  UART_UART_FCR_ITL_SHIFT 6
#define  UART_UART_FCR_ITL_MASK_SHIFT(reg) (((reg) & UART_UART_FCR_ITL_MASK) >> UART_UART_FCR_ITL_SHIFT)
#define  UART_UART_FCR_ITL_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_FCR_ITL_MASK) | (((uint32_t)val) << UART_UART_FCR_ITL_SHIFT))

#define  UART_UART_FCR_BUS_MASK 0x20
#define  UART_UART_FCR_BUS_SHIFT 5
#define  UART_UART_FCR_BUS_MASK_SHIFT(reg) (((reg) & UART_UART_FCR_BUS_MASK) >> UART_UART_FCR_BUS_SHIFT)
#define  UART_UART_FCR_BUS_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_FCR_BUS_MASK) | (((uint32_t)val) << UART_UART_FCR_BUS_SHIFT))

#define  UART_UART_FCR_TRAIL_MASK 0x10
#define  UART_UART_FCR_TRAIL_SHIFT 4
#define  UART_UART_FCR_TRAIL_MASK_SHIFT(reg) (((reg) & UART_UART_FCR_TRAIL_MASK) >> UART_UART_FCR_TRAIL_SHIFT)
#define  UART_UART_FCR_TRAIL_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_FCR_TRAIL_MASK) | (((uint32_t)val) << UART_UART_FCR_TRAIL_SHIFT))

#define  UART_UART_FCR_TIL_MASK 0x8
#define  UART_UART_FCR_TIL_SHIFT 3
#define  UART_UART_FCR_TIL_MASK_SHIFT(reg) (((reg) & UART_UART_FCR_TIL_MASK) >> UART_UART_FCR_TIL_SHIFT)
#define  UART_UART_FCR_TIL_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_FCR_TIL_MASK) | (((uint32_t)val) << UART_UART_FCR_TIL_SHIFT))

#define  UART_UART_FCR_RESETTF_MASK 0x4
#define  UART_UART_FCR_RESETTF_SHIFT 2
#define  UART_UART_FCR_RESETTF_MASK_SHIFT(reg) (((reg) & UART_UART_FCR_RESETTF_MASK) >> UART_UART_FCR_RESETTF_SHIFT)
#define  UART_UART_FCR_RESETTF_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_FCR_RESETTF_MASK) | (((uint32_t)val) << UART_UART_FCR_RESETTF_SHIFT))

#define  UART_UART_FCR_RESETRF_MASK 0x2
#define  UART_UART_FCR_RESETRF_SHIFT 1
#define  UART_UART_FCR_RESETRF_MASK_SHIFT(reg) (((reg) & UART_UART_FCR_RESETRF_MASK) >> UART_UART_FCR_RESETRF_SHIFT)
#define  UART_UART_FCR_RESETRF_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_FCR_RESETRF_MASK) | (((uint32_t)val) << UART_UART_FCR_RESETRF_SHIFT))

#define  UART_UART_FCR_TRFIFOE_MASK 0x1
#define  UART_UART_FCR_TRFIFOE_SHIFT 0
#define  UART_UART_FCR_TRFIFOE_MASK_SHIFT(reg) (((reg) & UART_UART_FCR_TRFIFOE_MASK) >> UART_UART_FCR_TRFIFOE_SHIFT)
#define  UART_UART_FCR_TRFIFOE_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_FCR_TRFIFOE_MASK) | (((uint32_t)val) << UART_UART_FCR_TRFIFOE_SHIFT))

//====================================================================
//Register: Line Control Register (UART_LCR)
/** \brief This register specifies the format for the asynchronous data-communications
exchange. The serial-data format consists of a start bit, 8 data bits, an
optional parity bit, and 1 stop bit. This register has bits that allow access to
the Divisor Latch registers and bits that can cause a break condition.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART_UART_LCR_RESERVED1_MASK 0xffffff00
#define  UART_UART_LCR_RESERVED1_SHIFT 8
#define  UART_UART_LCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART_UART_LCR_RESERVED1_MASK) >> UART_UART_LCR_RESERVED1_SHIFT)
#define  UART_UART_LCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_LCR_RESERVED1_MASK) | (((uint32_t)val) << UART_UART_LCR_RESERVED1_SHIFT))

#define  UART_UART_LCR_DLAB_MASK 0x80
#define  UART_UART_LCR_DLAB_SHIFT 7
#define  UART_UART_LCR_DLAB_MASK_SHIFT(reg) (((reg) & UART_UART_LCR_DLAB_MASK) >> UART_UART_LCR_DLAB_SHIFT)
#define  UART_UART_LCR_DLAB_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_LCR_DLAB_MASK) | (((uint32_t)val) << UART_UART_LCR_DLAB_SHIFT))

#define  UART_UART_LCR_SB_MASK 0x40
#define  UART_UART_LCR_SB_SHIFT 6
#define  UART_UART_LCR_SB_MASK_SHIFT(reg) (((reg) & UART_UART_LCR_SB_MASK) >> UART_UART_LCR_SB_SHIFT)
#define  UART_UART_LCR_SB_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_LCR_SB_MASK) | (((uint32_t)val) << UART_UART_LCR_SB_SHIFT))

#define  UART_UART_LCR_STKYP_MASK 0x20
#define  UART_UART_LCR_STKYP_SHIFT 5
#define  UART_UART_LCR_STKYP_MASK_SHIFT(reg) (((reg) & UART_UART_LCR_STKYP_MASK) >> UART_UART_LCR_STKYP_SHIFT)
#define  UART_UART_LCR_STKYP_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_LCR_STKYP_MASK) | (((uint32_t)val) << UART_UART_LCR_STKYP_SHIFT))

#define  UART_UART_LCR_EPS_MASK 0x10
#define  UART_UART_LCR_EPS_SHIFT 4
#define  UART_UART_LCR_EPS_MASK_SHIFT(reg) (((reg) & UART_UART_LCR_EPS_MASK) >> UART_UART_LCR_EPS_SHIFT)
#define  UART_UART_LCR_EPS_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_LCR_EPS_MASK) | (((uint32_t)val) << UART_UART_LCR_EPS_SHIFT))

#define  UART_UART_LCR_PEN_MASK 0x8
#define  UART_UART_LCR_PEN_SHIFT 3
#define  UART_UART_LCR_PEN_MASK_SHIFT(reg) (((reg) & UART_UART_LCR_PEN_MASK) >> UART_UART_LCR_PEN_SHIFT)
#define  UART_UART_LCR_PEN_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_LCR_PEN_MASK) | (((uint32_t)val) << UART_UART_LCR_PEN_SHIFT))

#define  UART_UART_LCR_STB_MASK 0x4
#define  UART_UART_LCR_STB_SHIFT 2
#define  UART_UART_LCR_STB_MASK_SHIFT(reg) (((reg) & UART_UART_LCR_STB_MASK) >> UART_UART_LCR_STB_SHIFT)
#define  UART_UART_LCR_STB_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_LCR_STB_MASK) | (((uint32_t)val) << UART_UART_LCR_STB_SHIFT))

#define  UART_UART_LCR_WLS10_MASK 0x3
#define  UART_UART_LCR_WLS10_SHIFT 0
#define  UART_UART_LCR_WLS10_MASK_SHIFT(reg) (((reg) & UART_UART_LCR_WLS10_MASK) >> UART_UART_LCR_WLS10_SHIFT)
#define  UART_UART_LCR_WLS10_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_LCR_WLS10_MASK) | (((uint32_t)val) << UART_UART_LCR_WLS10_SHIFT))

//====================================================================
//Register: Modem Control Register (UART_MCR)
/** \brief This register uses the modem control pins RTSn and DTRn to control the interface
with a modem or data set. This register also controls the loopback mode.
Loopback mode must be enabled before the UART is enabled.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART_UART_MCR_RESERVED1_MASK 0xffffffc0
#define  UART_UART_MCR_RESERVED1_SHIFT 6
#define  UART_UART_MCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART_UART_MCR_RESERVED1_MASK) >> UART_UART_MCR_RESERVED1_SHIFT)
#define  UART_UART_MCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_MCR_RESERVED1_MASK) | (((uint32_t)val) << UART_UART_MCR_RESERVED1_SHIFT))

#define  UART_UART_MCR_AFE_MASK 0x20
#define  UART_UART_MCR_AFE_SHIFT 5
#define  UART_UART_MCR_AFE_MASK_SHIFT(reg) (((reg) & UART_UART_MCR_AFE_MASK) >> UART_UART_MCR_AFE_SHIFT)
#define  UART_UART_MCR_AFE_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_MCR_AFE_MASK) | (((uint32_t)val) << UART_UART_MCR_AFE_SHIFT))

#define  UART_UART_MCR_LOOP_MASK 0x10
#define  UART_UART_MCR_LOOP_SHIFT 4
#define  UART_UART_MCR_LOOP_MASK_SHIFT(reg) (((reg) & UART_UART_MCR_LOOP_MASK) >> UART_UART_MCR_LOOP_SHIFT)
#define  UART_UART_MCR_LOOP_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_MCR_LOOP_MASK) | (((uint32_t)val) << UART_UART_MCR_LOOP_SHIFT))

#define  UART_UART_MCR_OUT2_MASK 0x8
#define  UART_UART_MCR_OUT2_SHIFT 3
#define  UART_UART_MCR_OUT2_MASK_SHIFT(reg) (((reg) & UART_UART_MCR_OUT2_MASK) >> UART_UART_MCR_OUT2_SHIFT)
#define  UART_UART_MCR_OUT2_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_MCR_OUT2_MASK) | (((uint32_t)val) << UART_UART_MCR_OUT2_SHIFT))

#define  UART_UART_MCR_OUT1_MASK 0x4
#define  UART_UART_MCR_OUT1_SHIFT 2
#define  UART_UART_MCR_OUT1_MASK_SHIFT(reg) (((reg) & UART_UART_MCR_OUT1_MASK) >> UART_UART_MCR_OUT1_SHIFT)
#define  UART_UART_MCR_OUT1_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_MCR_OUT1_MASK) | (((uint32_t)val) << UART_UART_MCR_OUT1_SHIFT))

#define  UART_UART_MCR_RTS_MASK 0x2
#define  UART_UART_MCR_RTS_SHIFT 1
#define  UART_UART_MCR_RTS_MASK_SHIFT(reg) (((reg) & UART_UART_MCR_RTS_MASK) >> UART_UART_MCR_RTS_SHIFT)
#define  UART_UART_MCR_RTS_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_MCR_RTS_MASK) | (((uint32_t)val) << UART_UART_MCR_RTS_SHIFT))

#define  UART_UART_MCR_DTR_MASK 0x1
#define  UART_UART_MCR_DTR_SHIFT 0
#define  UART_UART_MCR_DTR_MASK_SHIFT(reg) (((reg) & UART_UART_MCR_DTR_MASK) >> UART_UART_MCR_DTR_SHIFT)
#define  UART_UART_MCR_DTR_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_MCR_DTR_MASK) | (((uint32_t)val) << UART_UART_MCR_DTR_SHIFT))

//====================================================================
//Register: Line Status Register (UART_LSR)
/** \brief This register provides data-transfer status information to the PXA2128
Application Processor. In non-FIFO mode, bits [4:2] show the error status of the
character that has just been received. In FIFO mode, bits [4:2] show the status
bits of the character that is currently at the front of the FIFO.
Bits [4:1] produce a receiver-line-status interrupt when the corresponding
conditions are detected and the interrupt is enabled. In FIFO mode, the
receiver-line-status interrupt occurs only when the erroneous character reaches
the front of the FIFO. If the erroneous character is not at the front of the
FIFO, a line-status interrupt is generated after the other characters are read,
and the erroneous character becomes the character at the front of the FIFO.
This register must be read before the erroneous character is read. Bits [4:1]
remain set until software reads this register.
See FIFO DMA Mode Operation section in the PXA2128 Application Processor
Datasheet for details on using the DMAC to receive data.
This is a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  UART_UART_LSR_RESERVED1_MASK 0xffffff00
#define  UART_UART_LSR_RESERVED1_SHIFT 8
#define  UART_UART_LSR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART_UART_LSR_RESERVED1_MASK) >> UART_UART_LSR_RESERVED1_SHIFT)
#define  UART_UART_LSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_LSR_RESERVED1_MASK) | (((uint32_t)val) << UART_UART_LSR_RESERVED1_SHIFT))

#define  UART_UART_LSR_FIFOE_MASK 0x80
#define  UART_UART_LSR_FIFOE_SHIFT 7
#define  UART_UART_LSR_FIFOE_MASK_SHIFT(reg) (((reg) & UART_UART_LSR_FIFOE_MASK) >> UART_UART_LSR_FIFOE_SHIFT)
#define  UART_UART_LSR_FIFOE_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_LSR_FIFOE_MASK) | (((uint32_t)val) << UART_UART_LSR_FIFOE_SHIFT))

#define  UART_UART_LSR_TEMT_MASK 0x40
#define  UART_UART_LSR_TEMT_SHIFT 6
#define  UART_UART_LSR_TEMT_MASK_SHIFT(reg) (((reg) & UART_UART_LSR_TEMT_MASK) >> UART_UART_LSR_TEMT_SHIFT)
#define  UART_UART_LSR_TEMT_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_LSR_TEMT_MASK) | (((uint32_t)val) << UART_UART_LSR_TEMT_SHIFT))

#define  UART_UART_LSR_TDRQ_MASK 0x20
#define  UART_UART_LSR_TDRQ_SHIFT 5
#define  UART_UART_LSR_TDRQ_MASK_SHIFT(reg) (((reg) & UART_UART_LSR_TDRQ_MASK) >> UART_UART_LSR_TDRQ_SHIFT)
#define  UART_UART_LSR_TDRQ_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_LSR_TDRQ_MASK) | (((uint32_t)val) << UART_UART_LSR_TDRQ_SHIFT))

#define  UART_UART_LSR_BI_MASK 0x10
#define  UART_UART_LSR_BI_SHIFT 4
#define  UART_UART_LSR_BI_MASK_SHIFT(reg) (((reg) & UART_UART_LSR_BI_MASK) >> UART_UART_LSR_BI_SHIFT)
#define  UART_UART_LSR_BI_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_LSR_BI_MASK) | (((uint32_t)val) << UART_UART_LSR_BI_SHIFT))

#define  UART_UART_LSR_FE_MASK 0x8
#define  UART_UART_LSR_FE_SHIFT 3
#define  UART_UART_LSR_FE_MASK_SHIFT(reg) (((reg) & UART_UART_LSR_FE_MASK) >> UART_UART_LSR_FE_SHIFT)
#define  UART_UART_LSR_FE_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_LSR_FE_MASK) | (((uint32_t)val) << UART_UART_LSR_FE_SHIFT))

#define  UART_UART_LSR_PE_MASK 0x4
#define  UART_UART_LSR_PE_SHIFT 2
#define  UART_UART_LSR_PE_MASK_SHIFT(reg) (((reg) & UART_UART_LSR_PE_MASK) >> UART_UART_LSR_PE_SHIFT)
#define  UART_UART_LSR_PE_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_LSR_PE_MASK) | (((uint32_t)val) << UART_UART_LSR_PE_SHIFT))

#define  UART_UART_LSR_OE_MASK 0x2
#define  UART_UART_LSR_OE_SHIFT 1
#define  UART_UART_LSR_OE_MASK_SHIFT(reg) (((reg) & UART_UART_LSR_OE_MASK) >> UART_UART_LSR_OE_SHIFT)
#define  UART_UART_LSR_OE_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_LSR_OE_MASK) | (((uint32_t)val) << UART_UART_LSR_OE_SHIFT))

#define  UART_UART_LSR_DR_MASK 0x1
#define  UART_UART_LSR_DR_SHIFT 0
#define  UART_UART_LSR_DR_MASK_SHIFT(reg) (((reg) & UART_UART_LSR_DR_MASK) >> UART_UART_LSR_DR_SHIFT)
#define  UART_UART_LSR_DR_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_LSR_DR_MASK) | (((uint32_t)val) << UART_UART_LSR_DR_SHIFT))

//====================================================================
//Register: Modem Status Register (UART_MSR)
/** \brief This register provides the current state of the control lines from the modem or
data set (or a peripheral device emulating a modem) to the PXA2128 Application
Processor. In addition to this current state information, four bits provide
change information. Bits [3:0] are set when a control input from the modem
changes state. They are cleared when the PXA2128 Application Processor reads
this register.
The status of the modem control lines does not affect the FIFOs. The <Modem
Interrupt Enable> field in the Interrupt Enable Register must be set to use
these lines for flow control. The interrupt service routine must disable the
UART when an interrupt occurs on one of the flow-control pins. The UART
continues transmission/reception of the current character and then stops. The
contents of the FIFOs are preserved. If the UART is re-enabled, transmission
continues where it stopped.
Note: When bit 0, 1, 2, or 3 is set, a modem-status interrupt is generated if
the <Modem Interrupt Enable> field is set.
This is a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  UART_UART_MSR_RESERVED1_MASK 0xffffff00
#define  UART_UART_MSR_RESERVED1_SHIFT 8
#define  UART_UART_MSR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART_UART_MSR_RESERVED1_MASK) >> UART_UART_MSR_RESERVED1_SHIFT)
#define  UART_UART_MSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_MSR_RESERVED1_MASK) | (((uint32_t)val) << UART_UART_MSR_RESERVED1_SHIFT))

#define  UART_UART_MSR_DCD_MASK 0x80
#define  UART_UART_MSR_DCD_SHIFT 7
#define  UART_UART_MSR_DCD_MASK_SHIFT(reg) (((reg) & UART_UART_MSR_DCD_MASK) >> UART_UART_MSR_DCD_SHIFT)
#define  UART_UART_MSR_DCD_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_MSR_DCD_MASK) | (((uint32_t)val) << UART_UART_MSR_DCD_SHIFT))

#define  UART_UART_MSR_RI_MASK 0x40
#define  UART_UART_MSR_RI_SHIFT 6
#define  UART_UART_MSR_RI_MASK_SHIFT(reg) (((reg) & UART_UART_MSR_RI_MASK) >> UART_UART_MSR_RI_SHIFT)
#define  UART_UART_MSR_RI_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_MSR_RI_MASK) | (((uint32_t)val) << UART_UART_MSR_RI_SHIFT))

#define  UART_UART_MSR_DSR_MASK 0x20
#define  UART_UART_MSR_DSR_SHIFT 5
#define  UART_UART_MSR_DSR_MASK_SHIFT(reg) (((reg) & UART_UART_MSR_DSR_MASK) >> UART_UART_MSR_DSR_SHIFT)
#define  UART_UART_MSR_DSR_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_MSR_DSR_MASK) | (((uint32_t)val) << UART_UART_MSR_DSR_SHIFT))

#define  UART_UART_MSR_CTS_MASK 0x10
#define  UART_UART_MSR_CTS_SHIFT 4
#define  UART_UART_MSR_CTS_MASK_SHIFT(reg) (((reg) & UART_UART_MSR_CTS_MASK) >> UART_UART_MSR_CTS_SHIFT)
#define  UART_UART_MSR_CTS_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_MSR_CTS_MASK) | (((uint32_t)val) << UART_UART_MSR_CTS_SHIFT))

#define  UART_UART_MSR_DDCD_MASK 0x8
#define  UART_UART_MSR_DDCD_SHIFT 3
#define  UART_UART_MSR_DDCD_MASK_SHIFT(reg) (((reg) & UART_UART_MSR_DDCD_MASK) >> UART_UART_MSR_DDCD_SHIFT)
#define  UART_UART_MSR_DDCD_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_MSR_DDCD_MASK) | (((uint32_t)val) << UART_UART_MSR_DDCD_SHIFT))

#define  UART_UART_MSR_TERI_MASK 0x4
#define  UART_UART_MSR_TERI_SHIFT 2
#define  UART_UART_MSR_TERI_MASK_SHIFT(reg) (((reg) & UART_UART_MSR_TERI_MASK) >> UART_UART_MSR_TERI_SHIFT)
#define  UART_UART_MSR_TERI_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_MSR_TERI_MASK) | (((uint32_t)val) << UART_UART_MSR_TERI_SHIFT))

#define  UART_UART_MSR_DDSR_MASK 0x2
#define  UART_UART_MSR_DDSR_SHIFT 1
#define  UART_UART_MSR_DDSR_MASK_SHIFT(reg) (((reg) & UART_UART_MSR_DDSR_MASK) >> UART_UART_MSR_DDSR_SHIFT)
#define  UART_UART_MSR_DDSR_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_MSR_DDSR_MASK) | (((uint32_t)val) << UART_UART_MSR_DDSR_SHIFT))

#define  UART_UART_MSR_DCTS_MASK 0x1
#define  UART_UART_MSR_DCTS_SHIFT 0
#define  UART_UART_MSR_DCTS_MASK_SHIFT(reg) (((reg) & UART_UART_MSR_DCTS_MASK) >> UART_UART_MSR_DCTS_SHIFT)
#define  UART_UART_MSR_DCTS_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_MSR_DCTS_MASK) | (((uint32_t)val) << UART_UART_MSR_DCTS_SHIFT))

//====================================================================
//Register: Scratchpad Register (UART_SCR)
/** \brief This register has no effect on the UART. It is intended as a scratchpad register
for use by programmers and is included for 16550A compatibility.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART_UART_SCR_RESERVED1_MASK 0xffffff00
#define  UART_UART_SCR_RESERVED1_SHIFT 8
#define  UART_UART_SCR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART_UART_SCR_RESERVED1_MASK) >> UART_UART_SCR_RESERVED1_SHIFT)
#define  UART_UART_SCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_SCR_RESERVED1_MASK) | (((uint32_t)val) << UART_UART_SCR_RESERVED1_SHIFT))

#define  UART_UART_SCR_SCRATCHPAD_MASK 0xff
#define  UART_UART_SCR_SCRATCHPAD_SHIFT 0
#define  UART_UART_SCR_SCRATCHPAD_MASK_SHIFT(reg) (((reg) & UART_UART_SCR_SCRATCHPAD_MASK) >> UART_UART_SCR_SCRATCHPAD_SHIFT)
#define  UART_UART_SCR_SCRATCHPAD_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_SCR_SCRATCHPAD_MASK) | (((uint32_t)val) << UART_UART_SCR_SCRATCHPAD_SHIFT))

//====================================================================
//Register: Infrared Selection Register (UART_ISR)
/** \brief Each UART can manage an IrDA module associated with it. This register controls
the IrDA functions (see Serial Infrared Asynchronous Interface in the PXA2128
Application Processor Datasheet).
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART_UART_ISR_RESERVED1_MASK 0xffffffe0
#define  UART_UART_ISR_RESERVED1_SHIFT 5
#define  UART_UART_ISR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART_UART_ISR_RESERVED1_MASK) >> UART_UART_ISR_RESERVED1_SHIFT)
#define  UART_UART_ISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_ISR_RESERVED1_MASK) | (((uint32_t)val) << UART_UART_ISR_RESERVED1_SHIFT))

#define  UART_UART_ISR_RXPL_MASK 0x10
#define  UART_UART_ISR_RXPL_SHIFT 4
#define  UART_UART_ISR_RXPL_MASK_SHIFT(reg) (((reg) & UART_UART_ISR_RXPL_MASK) >> UART_UART_ISR_RXPL_SHIFT)
#define  UART_UART_ISR_RXPL_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_ISR_RXPL_MASK) | (((uint32_t)val) << UART_UART_ISR_RXPL_SHIFT))

#define  UART_UART_ISR_TXPL_MASK 0x8
#define  UART_UART_ISR_TXPL_SHIFT 3
#define  UART_UART_ISR_TXPL_MASK_SHIFT(reg) (((reg) & UART_UART_ISR_TXPL_MASK) >> UART_UART_ISR_TXPL_SHIFT)
#define  UART_UART_ISR_TXPL_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_ISR_TXPL_MASK) | (((uint32_t)val) << UART_UART_ISR_TXPL_SHIFT))

#define  UART_UART_ISR_XMODE_MASK 0x4
#define  UART_UART_ISR_XMODE_SHIFT 2
#define  UART_UART_ISR_XMODE_MASK_SHIFT(reg) (((reg) & UART_UART_ISR_XMODE_MASK) >> UART_UART_ISR_XMODE_SHIFT)
#define  UART_UART_ISR_XMODE_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_ISR_XMODE_MASK) | (((uint32_t)val) << UART_UART_ISR_XMODE_SHIFT))

#define  UART_UART_ISR_RCVEIR_MASK 0x2
#define  UART_UART_ISR_RCVEIR_SHIFT 1
#define  UART_UART_ISR_RCVEIR_MASK_SHIFT(reg) (((reg) & UART_UART_ISR_RCVEIR_MASK) >> UART_UART_ISR_RCVEIR_SHIFT)
#define  UART_UART_ISR_RCVEIR_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_ISR_RCVEIR_MASK) | (((uint32_t)val) << UART_UART_ISR_RCVEIR_SHIFT))

#define  UART_UART_ISR_XMITIR_MASK 0x1
#define  UART_UART_ISR_XMITIR_SHIFT 0
#define  UART_UART_ISR_XMITIR_MASK_SHIFT(reg) (((reg) & UART_UART_ISR_XMITIR_MASK) >> UART_UART_ISR_XMITIR_SHIFT)
#define  UART_UART_ISR_XMITIR_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_ISR_XMITIR_MASK) | (((uint32_t)val) << UART_UART_ISR_XMITIR_SHIFT))

//====================================================================
//Register: Receive FIFO Occupancy Register (UART_FOR)
/** \brief This register shows the number of bytes currently remaining the receive FIFO.
This register can be used to determine the number of trailing bytes to remove in
the case when the DMA reaches the end of its descriptor chain or when
the <Trailing Bytes> field in the FIFO Control Register is clear, which
indicates that the PXA2128 Application Processor removes trailing bytes as
opposed to the DMA (see Removing Trailing Bytes in DMA Mode section in PXA2128
Application Processor Datasheet). This register is incremented once for each
byte of data written to the receive FIFO and decremented once for each byte
read.
This is a read/write register. Ignore reads from reserved bits. Write 0b0 to
reserved bits.*/
//====================================================================

#define  UART_UART_FOR_RESERVED1_MASK 0xffffffc0
#define  UART_UART_FOR_RESERVED1_SHIFT 6
#define  UART_UART_FOR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART_UART_FOR_RESERVED1_MASK) >> UART_UART_FOR_RESERVED1_SHIFT)
#define  UART_UART_FOR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_FOR_RESERVED1_MASK) | (((uint32_t)val) << UART_UART_FOR_RESERVED1_SHIFT))

#define  UART_UART_FOR_BYTE_COUNT_MASK 0x3f
#define  UART_UART_FOR_BYTE_COUNT_SHIFT 0
#define  UART_UART_FOR_BYTE_COUNT_MASK_SHIFT(reg) (((reg) & UART_UART_FOR_BYTE_COUNT_MASK) >> UART_UART_FOR_BYTE_COUNT_SHIFT)
#define  UART_UART_FOR_BYTE_COUNT_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_FOR_BYTE_COUNT_MASK) | (((uint32_t)val) << UART_UART_FOR_BYTE_COUNT_SHIFT))

//====================================================================
//Register: Auto-Baud Control Register (UART_ABR)
/** \brief This register controls the functionality and options for auto-baud-rate
detection within the UART. Through this register, software can enable/disable
the auto-baud-lock interrupt, direct either the PXA2128 Application Processor or
the UART to program the final baud rate in the Divisor Latch registers, and
choose between two methods used to calculate the final baud rate.
The auto-baud circuitry counts the number of clocks in the start bit and writes
this count into the Auto-Baud Count register (ACR). It then interrupts the
PXA2128 Application Processor if the <Auto-baud Lock> field in the Interrupt
Identification Register is set. It also programs automatically the Divisor Latch
registers (DLL and DLH) if the <ABUP> field is set.
See Auto-Baud-Rate Detection section in PXA2128 Application Processor Datasheet
for more information on auto-baud rate.
Note: Auto-baud-rate detection is not supported in IrDA serial-infrared mode.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  UART_UART_ABR_RESERVED1_MASK 0xfffffff0
#define  UART_UART_ABR_RESERVED1_SHIFT 4
#define  UART_UART_ABR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART_UART_ABR_RESERVED1_MASK) >> UART_UART_ABR_RESERVED1_SHIFT)
#define  UART_UART_ABR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_ABR_RESERVED1_MASK) | (((uint32_t)val) << UART_UART_ABR_RESERVED1_SHIFT))

#define  UART_UART_ABR_ABT_MASK 0x8
#define  UART_UART_ABR_ABT_SHIFT 3
#define  UART_UART_ABR_ABT_MASK_SHIFT(reg) (((reg) & UART_UART_ABR_ABT_MASK) >> UART_UART_ABR_ABT_SHIFT)
#define  UART_UART_ABR_ABT_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_ABR_ABT_MASK) | (((uint32_t)val) << UART_UART_ABR_ABT_SHIFT))

#define  UART_UART_ABR_ABUP_MASK 0x4
#define  UART_UART_ABR_ABUP_SHIFT 2
#define  UART_UART_ABR_ABUP_MASK_SHIFT(reg) (((reg) & UART_UART_ABR_ABUP_MASK) >> UART_UART_ABR_ABUP_SHIFT)
#define  UART_UART_ABR_ABUP_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_ABR_ABUP_MASK) | (((uint32_t)val) << UART_UART_ABR_ABUP_SHIFT))

#define  UART_UART_ABR_ABLIE_MASK 0x2
#define  UART_UART_ABR_ABLIE_SHIFT 1
#define  UART_UART_ABR_ABLIE_MASK_SHIFT(reg) (((reg) & UART_UART_ABR_ABLIE_MASK) >> UART_UART_ABR_ABLIE_SHIFT)
#define  UART_UART_ABR_ABLIE_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_ABR_ABLIE_MASK) | (((uint32_t)val) << UART_UART_ABR_ABLIE_SHIFT))

#define  UART_UART_ABR_ABE_MASK 0x1
#define  UART_UART_ABR_ABE_SHIFT 0
#define  UART_UART_ABR_ABE_MASK_SHIFT(reg) (((reg) & UART_UART_ABR_ABE_MASK) >> UART_UART_ABR_ABE_SHIFT)
#define  UART_UART_ABR_ABE_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_ABR_ABE_MASK) | (((uint32_t)val) << UART_UART_ABR_ABE_SHIFT))

//====================================================================
//Register: Auto-Baud Count Register (UART_ACR)
/** \brief This register stores the number of 14.857-MHz clock cycles within a start-bit
pulse. This value is then used by the PXA2128 Application Processor or the UART
to calculate the baud rate. If auto-baud mode (<ABE> field in Auto-Baud Control
Register) and auto-baud interrupts (<ABLIE> field in Auto-Baud Control Register)
are enabled, the UART interrupts the PXA2128 Application Processor with the
auto-baud-lock interrupt (IIR[ABL]) after it has written the count value into
ACR. The value is written regardless of the state of the auto-baud UART program
bit, (ABR[ABUP]).
This is a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  UART_UART_ACR_RESERVED1_MASK 0xffff0000
#define  UART_UART_ACR_RESERVED1_SHIFT 16
#define  UART_UART_ACR_RESERVED1_MASK_SHIFT(reg) (((reg) & UART_UART_ACR_RESERVED1_MASK) >> UART_UART_ACR_RESERVED1_SHIFT)
#define  UART_UART_ACR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_ACR_RESERVED1_MASK) | (((uint32_t)val) << UART_UART_ACR_RESERVED1_SHIFT))

#define  UART_UART_ACR_COUNT_VALUE_MASK 0xffff
#define  UART_UART_ACR_COUNT_VALUE_SHIFT 0
#define  UART_UART_ACR_COUNT_VALUE_MASK_SHIFT(reg) (((reg) & UART_UART_ACR_COUNT_VALUE_MASK) >> UART_UART_ACR_COUNT_VALUE_SHIFT)
#define  UART_UART_ACR_COUNT_VALUE_REPLACE_VAL(reg,val) (((reg) & ~UART_UART_ACR_COUNT_VALUE_MASK) | (((uint32_t)val) << UART_UART_ACR_COUNT_VALUE_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information. This register of particular interest to firmware*/
//====================================================================

#define  UART_REV0_MAJ_MASK 0xffff0000
#define  UART_REV0_MAJ_SHIFT 16
#define  UART_REV0_MAJ_MASK_SHIFT(reg) (((reg) & UART_REV0_MAJ_MASK) >> UART_REV0_MAJ_SHIFT)
#define  UART_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~UART_REV0_MAJ_MASK) | (((uint32_t)val) << UART_REV0_MAJ_SHIFT))

#define  UART_REV0_MID_MASK 0xffff
#define  UART_REV0_MID_SHIFT 0
#define  UART_REV0_MID_MASK_SHIFT(reg) (((reg) & UART_REV0_MID_MASK) >> UART_REV0_MID_SHIFT)
#define  UART_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~UART_REV0_MID_MASK) | (((uint32_t)val) << UART_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  UART_REV1_RESERVED1_MASK 0xffff0000
#define  UART_REV1_RESERVED1_SHIFT 16
#define  UART_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & UART_REV1_RESERVED1_MASK) >> UART_REV1_RESERVED1_SHIFT)
#define  UART_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~UART_REV1_RESERVED1_MASK) | (((uint32_t)val) << UART_REV1_RESERVED1_SHIFT))

#define  UART_REV1_CFG_MASK 0xffff
#define  UART_REV1_CFG_SHIFT 0
#define  UART_REV1_CFG_MASK_SHIFT(reg) (((reg) & UART_REV1_CFG_MASK) >> UART_REV1_CFG_SHIFT)
#define  UART_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~UART_REV1_CFG_MASK) | (((uint32_t)val) << UART_REV1_CFG_SHIFT))

#endif // UART
