/*
 * (C) Copyright 2011
 * Marvell Semiconductor <www.marvell.com>
 * Written-by: Lei Wen <leiwen@marvell.com>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 */

#ifndef __CONFIG_PEGMATITE_H
#define __CONFIG_PEGMATITE_H

/*
 * High Level Configuration Options
 */
#define CONFIG_ARMV7        1   /* This is an ARM V7 CPU core */
#define CONFIG_L2_OFF       1
#define CONFIG_SYS_THUMB_BUILD

#define CONFIG_BOOTARGS "console=ttyS0,115200n8 earlyprintk=serial,ttyS0,115200"
#define CONFIG_CMDLINE_TAG
#define CONFIG_OF_LIBFDT
#if 1 /* RICOH : un-del for LCD*/
#define CONFIG_OF_BOARD_SETUP
#endif /* 1 RICOH : un-del*/

#ifndef CONFIG_BOOTDELAY
#define CONFIG_BOOTDELAY -2
#define CONFIG_ZERO_BOOTDELAY_CHECK
#else
#define CONFIG_BOOTCOMMAND  "loop.l 0xd0000000 1"
#endif

#if 1 /* RICOH : un-del for LCD*/
#ifndef __ASSEMBLY__
int get_panel_bus(void);
#endif
#define CONFIG_LCD
#define LCD_IS_NOT_STDIO
#define LCD_BPP LCD_COLOR16
#endif /* 1 RICOH : un-del*/
#define CONFIG_SYS_STDIO_DEREGISTER
#if 1/* RICOH : un-del for LCD*/
#define CONFIG_CMD_BMP
#define CONFIG_BMP_16BPP
#define CONFIG_SPLASH_SCREEN_ALIGN
#define CONFIG_MV_MMP_PANEL
#define CONFIG_MV_MMP_PANEL_VGA
#define CONFIG_MV_MMP_PANEL_VGA_PEGMATITE
#endif /* 1 RICOH : un-del*/

#define CONFIG_MV62XX_DISP_REF_PANEL
#define CONFIG_PANEL_I2C_BUS get_panel_bus()

#define CONFIG_SYS_MEMTEST_START	0x100000
#define CONFIG_SYS_MEMTEST_END		0x10000000
#define CONFIG_SYS_HZ			(1000)
#define CONFIG_SYS_HZ_CLOCK    (25000000)       /* Timer Freq. 25MHZ */
#ifndef CONFIG_DRAM_INIT_ONLY
#define CONFIG_SYS_HUSH_PARSER
#define CONFIG_SYS_PROMPT_HUSH_PS2      "> "
#define CONFIG_CMD_SOURCE
#endif

#define CONFIG_BOARD_EARLY_INIT_F 1
#define CONFIG_BOARD_LATE_INIT	1

/*
 * If the icache is enabled and multiple items are loaded and
 * run at the same location, then the icache must be flushed
 * before each run.
 */
#define CONFIG_STANDALONE_ICACHE_FLUSH	1
#define CONFIG_SYS_CACHELINE_SIZE 32
/**
 * RICOH : add
#define CONFIG_SYS_ICACHE_OFF
 */

/*
 * NS16550 Configuration
 */
#ifndef __ASSEMBLY__
unsigned int get_uart_clock(void);
#endif
#define CONFIG_SYS_NS16550_SERIAL
#define CONFIG_SYS_NS16550
#define CONFIG_SYS_NS16550_COM1 0xd4030000
#define CONFIG_SYS_NS16550_CLK  get_uart_clock( )
#define CONFIG_SYS_NS16550_REG_SIZE (-4)
#define CONFIG_CONS_INDEX 1
#define CONFIG_BAUDRATE			115200
#define CONFIG_SYS_BAUDRATE_TABLE	{ 38400, 115200 }
#define CONFIG_SYS_NS16550_IER	(1 << 6)	/* Bit 6 in UART_IER register
						represents UART Unit Enable */

/*
 * Command line configuration.
 */
#define CONFIG_CMD_MEMORY
#define CONFIG_CMD_RUN
/* RICOH : add */
#define CONFIG_CMD_MEMTEST
#define CONFIG_SYS_ALT_MEMTEST

/*
 * Miscellaneous configurable options
 */
#define CONFIG_SYS_CBSIZE	512		/* Console I/O Buffer Size */
#define CONFIG_SYS_DEVICE_NULLDEV 1
#define CONFIG_SYS_CONSOLE_INFO_QUIET 1
/* Monitor Command Prompt	 */
# define CONFIG_SYS_PROMPT	"# "
/* Print Buffer Size */
#define CONFIG_SYS_PBSIZE	\
			(CONFIG_SYS_CBSIZE + sizeof(CONFIG_SYS_PROMPT) + 16)
#define CONFIG_SYS_MAXARGS	16		/* max number of command args */
#define CONFIG_SYS_BARGSIZE	CONFIG_SYS_CBSIZE /* Boot Argument Buffer Size */

#define CONFIG_SYS_LOAD_ADDR	0x8000	/* default load address */

#define CONFIG_SYS_WHITE_ON_BLACK

#ifndef CONFIG_DRAM_INIT_ONLY
#define CONFIG_CMD_CRAMFS
#define CONFIG_CRAMFS_CMDLINE
#define CONFIG_LXK_CRAMFS 1
#define CONFIG_SYS_MAX_FLASH_SECT 512
#define CONFIG_SYS_MAX_FLASH_BANKS 1
#endif

#if 0
/*
 * NAND setup
 */
#define CONFIG_CMD_NAND
#define CONFIG_SYS_NAND_QUIET_TEST 1
#define CONFIG_SYS_MAX_NAND_DEVICE 2
#define CONFIG_NAND_MV61X0 1
#define CONFIG_SYS_NAND_BASE 0xc0000000
#define CONFIG_SYS_NAND_BASE_LIST { 0xc0000000, 0 };
#define CONFIG_SYS_NAND_REG_BASE 0xd4283000
#define CONFIG_MTD_DEVICE
#define CONFIG_MTD_PARTITIONS
#define CONFIG_MTD_LXKSHIM 1
#define CONFIG_CMD_MTDPARTS
#define MTDIDS_DEFAULT "nand0=nand"
#define MTDPARTS_DEFAULT    "mtdparts=nand:-"
#endif

/*
 * SD setup
 */
#define CONFIG_MMC
#define CONFIG_GENERIC_MMC
#define CONFIG_SDHCI
#define CONFIG_MV_SDHCI
#define CONFIG_MMC_SDMA
#define CONFIG_SYS_MMC_NUM	3
#define CONFIG_SYS_MMC_BASE     {0xd4280000, 0xd4280800, 0xd4281000}
#define CONFIG_SYS_MMC_MAX_BLK_COUNT   100

#define CONFIG_CMD_MMC
#define CONFIG_CMD_EXT2
#define CONFIG_DOS_PARTITION
#define CONFIG_SSP_PARTITION
#define HAVE_BLOCK_DEVICE

#define CONFIG_SHA256 1
#define CONFIG_RSAVERIFY 1
#define CONFIG_CMD_SHA256VERIFY 1

#define CONFIG_MD5
#define CONFIG_CRASH_KERNEL_START_MB 128
#define CONFIG_CRASH_KERNEL_SIZE_MB 30

/*
 * I2C definition
 */
#define CONFIG_CMD_I2C
#define CONFIG_I2C_MV		1
#define CONFIG_MV_I2C_NUM	6
#define CONFIG_I2C_MULTI_BUS	1
#define CONFIG_MV_I2C_REG	{0xd4011000, 0xd4031000, 0xd4032000, 0xd4033000, 0xd4033800, 0xd4034000}
#define CONFIG_HARD_I2C		1
#define CONFIG_SYS_I2C_SPEED	0
#define CONFIG_SYS_I2C_SLAVE	0xfe
#define CONFIG_AUDIO_I2C_BUS  1
#define CONFIG_AUDIO_I2C_ADDR 0x18

#define CONFIG_MARVELL_GPIO
#define CONFIG_MARVELL_GPIO_PEGMATITE
#define CONFIG_MARVELL_GPIO_BASE 0xd4019000

#define CONFIG_MARVELL_MFP
#define MV_MFPR_BASE 0xd401e000

/*
 * SPD functions
 */
#define CONFIG_SPD_EEPROM

/*-----------------------------------------------------------------------
 * Physical Memory Map
 */
#define CONFIG_MC_BASE          0xd0000000
#define CONFIG_MC_BANKS         3
#define CONFIG_NR_DRAM_BANKS    (CONFIG_MC_BANKS + 1)
#define CONFIG_SYS_SDRAM_BASE   0

#define CONFIG_ENV_SIZE     (4 * 1024)

/*
 * Size of malloc() pool
 */
#define CONFIG_SYS_MALLOC_LEN		(CONFIG_ENV_SIZE + (8 * 1024 * 1024))
#define CONFIG_SYS_INIT_SP_SIZE     (2 * 1024)

/*
 * Memory Map
 * 0xf9280000 - 0xf92807ff  init stack
 * 0xf9280800               code
 */
#ifndef CONFIG_SYS_TEXT_BASE
#define CONFIG_SYS_TEXT_BASE 0x08000000 /* (CONFIG_SYS_BASE_ADDR + CONFIG_SYS_INIT_SP_SIZE + CONFIG_SYS_MALLOC_LEN) */
#endif

#define CONFIG_SYS_BASE_ADDR (CONFIG_SYS_TEXT_BASE - 0x800)
#define CONFIG_SYS_INIT_SP_ADDR (CONFIG_SYS_BASE_ADDR + CONFIG_SYS_INIT_SP_SIZE - GENERATED_GBL_DATA_SIZE)

#define CONFIG_SYS_NO_FLASH
#define CONFIG_ENV_IS_NOWHERE	1

/* Give us the ability to enable dcache from app space */
#define CONFIG_CMD_CACHE
#define CONFIG_SYS_ARM_CACHE_WRITETHROUGH
/**
 * RICOH : add
#define CONFIG_SYS_DCACHE_OFF
 */

/*  RICOH add  */
#define CONFIG_CMD_FAT

//#define CONFIG_SD_BOOT
#ifdef  CONFIG_SD_BOOT
#define VERBOSE_PLL_DEBUG
/*  This is for SD boot  */
#define CONFIG_EXTRA_ENV_SETTINGS                              \
	"load_img0=mmc dev 2;bootselect;mmc read 0x400000 0x1400 0x2000;mmc read 0x1100000 0x3400 0x4400;mmc read 0xf00000 $dtb_blockid 0xc8;\0"
#else
/*  This is for eMMC boot  */
#define CONFIG_EXTRA_ENV_SETTINGS      \
	"select_boot=bootselect;run load_img;\0" \
	"load_img=mmc read 0x400000 $kernel_blockid 0x2000;mmc read 0x1100000 $initramfs_blockid 0x1800;mmc read 0xf00000 $dtb_blockid 0xc8;\0"
#endif

/*  RICOH : 2015/08/31 add  */
#define  CONFIG_R4_MEM_SIZE    (25*1024*1024)


#endif	/* __CONFIG_PEGMATITE_H */
