/*
 * LITTLE/BIG BROTHER EEPROM DEFINITION
 *
 * LB = 64 bytes
 * BB = 512 bytes
 *
 * WARNING: please note version-specific changes inline
 */
#ifndef __MV_MMP_EEPROM_INFO_H_
#define __MV_MMP_EEPROM_INFO_H_

#include "mv_mmp_eeprom.h"

#define PANEL_FLAGS1_RGB (1<<0)
#define PANEL_FLAGS1_INV_CLK (1<<1)
#define PANEL_FLAGS1_INV_SYNC (1<<2)
#define PANEL_FLAGS1_RB_SWAP (1<<3)
#define PANEL_FLAGS1_PIXEL_DEPTH(x) ((x>>4)&0x3)
#define PANEL_FLAGS1_HAPTICS (1<<6)
#define PANEL_FLAGS1_BUTTON_LIGHTs (1<<7)
#define PIXEL_DEPTH_16 0
#define PIXEL_DEPTH_18 1
#define PIXEL_DEPTH_24 2
#define PANEL_FLAGS1_HAPTICS (1<<6)

/* begin version 2.2 definitions */
#define PANEL_TYPE_LB (1<<7)
#define PANEL_DISPLAY_TYPE_SMPN (1<<7)
/* end version 2.2 definitions */

/*
 * These values must match the type entry in vga_panel_info, so set them explicitly.
 */
typedef enum {
   PANEL_NOT_DETECTED = 0,

   /* BB panels */
   PANEL_KEYWEST = 1,
   PANEL_BVI = 2,
   PANEL_ARUBA = 3,
   PANEL_BARBADOS4 = 4,
   PANEL_BARBADOS10 = 5,
   PANEL_BARBADOS7 = 6,
   PANEL_CUBA = 7,

   PANEL_VGA_GENERIC = 64,
   PANEL_VGA_HARDCODED = 65,
   PANEL_VGA_GEN2 = 65,

   /* LB panels */
   PANEL_ATLANTIS = 128,
   PANEL_BAHAMAS = 129,
   PANEL_JAMAICA= 130,
   PANEL_LED = 131,
   PANEL_2LINE = 132,
   
   PANEL_NOT_RECOGNIZED,
}PANEL_TYPES;

typedef enum {
   /* smart panel displays begin at 128 */
   MV_MMP_PANEL_SMPN_TYPE_TM024HDH49	= 128,
   MV_MMP_PANEL_SMPN_TYPE_INVALID = -1,
} MV_MMP_PANEL_SMPN_TYPE;

typedef panel_info_t vga_panel_info;

/**
 * mv_mmp_eeprom_version_ge - test for minimum eeprom version
 * @major - minimum version major
 * @minor - minimum version minor
 * @vpi - pointer to eeprom data image
 */
extern int mv_mmp_eeprom_version_ge(int major, int minor, vga_panel_info *vpi);

/**
 * mv_mmp_eeprom_version_ge - test for exact eeprom version
 * @major - required version major
 * @minor - required version minor
 * @vpi - pointer to eeprom data image
 */
extern int mv_mmp_eeprom_version_eq(int major, int minor, vga_panel_info *vpi);

/**
 * mv_mmp_eeprom_checksum - verify eeprom contents if supported
 * @vpi - pointer to eeprom data image
 */
extern int mv_mmp_eeprom_checksum(vga_panel_info *vpi);

/**
 * mv_mmp_eeprom_version_blank - test for blank or corrupted version
 * @vpi - pointer to eeprom data image
 *
 * Blank or brownout-corrupted state is usually 0xff, so make it illegal in the
 * version fields.
 */
extern int mv_mmp_eeprom_version_blank(vga_panel_info *vpi);

#endif
