/*----------------------------------------------------------------------------
 * LCD panel hw definitions for Tianma TM024HDH49 2.4" Smart Panel
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * The software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with the this software; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA.
 */

/*
 * This file should be included AFTER platform-specific header
 * defining SMART_CMD, SMART_DAT, SMART_DELAY, and SMART_NOP.
 */

#ifndef _LCD_SMPN_TM024HDH49_H_
#define _LCD_SMPN_TM024HDH49_H_

#include "lcd_smpn_info.h"
#include "mv61fb.h"

#ifndef ARRAY_SIZE
#define ARRAY_SIZE(array) (sizeof(array) / sizeof((array)[0]))
#endif

/*
 * HW-specific command/data sequences for smart panel controllers.
 */
static u16 ili9341_power_on[] = {
	
        /* driver provides sufficient delay on entry, can go straight to soft reset */
	SMART_CMD(0x01),	/* soft reset (also causes Sleep In) */
	SMART_DELAY(10),	/* spec 5ms min to next command */

	SMART_CMD(0xcf),	/* undocumented command from TM024HDH49 example */	
	SMART_DAT(0x00),	
	SMART_DAT(0xDB),	/* Changed from 0x81 to 0xDB for 3.3V per vendor */
	SMART_DAT(0x30),	

	SMART_CMD(0xed),	/* undocumented command from TM024HDH49 example */	
	SMART_DAT(0x64),	
	SMART_DAT(0x03),	
	SMART_DAT(0x12),	
	SMART_DAT(0x81),	

	SMART_CMD(0xe8),	/* undocumented command from TM024HDH49 example */	
	SMART_DAT(0x85),	
	SMART_DAT(0x10),	
	SMART_DAT(0x7a),	

	SMART_CMD(0xcb),	/* AP[2:0], undocumented cmd from TM024HDH49 example */	
	SMART_DAT(0x39),	
	SMART_DAT(0x2c),	
	SMART_DAT(0x00),	
	SMART_DAT(0x34),	
	SMART_DAT(0x02),	

	SMART_CMD(0xf7),	/* undocumented cmd from TM024HDH49 example */	
	SMART_DAT(0x20),	

	SMART_CMD(0xea),	/* undocumented cmd from TM024HDH49 example */	
	SMART_DAT(0x00),	
	SMART_DAT(0x00),	

	SMART_CMD(0xc0),	/* Power Control 1 */	
	SMART_DAT(0x21),	/* VRH[5:0], details TBD */

	SMART_CMD(0xc1),	/* Power Control 2 */	
	SMART_DAT(0x11),	/* SAP[2:0], BT[3:0] */
				/* details TBD */

	SMART_CMD(0xc5),	/* VCOM Control 1 */
	SMART_DAT(0x28),	/* VCOMH = 3.70V  */
	SMART_DAT(0x25),	/* VCOML = -1.575V  */

	/* compromise value for Tianma and EDT */
	SMART_CMD(0xc7),	/* VCOM Control 2 */	
	SMART_DAT(0xb2),	/* offset VCOMH and VCOML -14 steps, details TBD */

	SMART_CMD(0x36),	/* Memory Access Control */	
	SMART_DAT(0x48),	/* BGR sub-pixel ordering on panel */

	SMART_CMD(0xb1),	/* Frame Rate Control */	
	SMART_DAT(0x00),	/* fosc/1 */
	SMART_DAT(0x1f),	/* 31 clocks/line (61Hz)  */

	SMART_CMD(0xb6),	/* Display Function Control */	
	SMART_DAT(0x0a),	/* non-display area scan mode */
				/* default output scan direction = S1->S270 */

	SMART_CMD(0xf2),	/* 3Gamma function disable */
	SMART_DAT(0x00),
	
	SMART_CMD(0x26),	/* gamma curve selected, from TM024HDH49 example */
	SMART_DAT(0x01),	/* details TBD */
	
	SMART_CMD(0xE0),
	SMART_DAT(0x00),  
	SMART_DAT(0x21),      
	SMART_DAT(0x1D),     
	SMART_DAT(0x0A),      
	SMART_DAT(0x10),
	SMART_DAT(0x09),      
	SMART_DAT(0x4B),     
	SMART_DAT(0xA9),      
	SMART_DAT(0x3A),
	SMART_DAT(0x0A),      
	SMART_DAT(0x10),     
	SMART_DAT(0x04),
	SMART_DAT(0x14),
	SMART_DAT(0x15),
	SMART_DAT(0x00),

     
	SMART_CMD(0xE1),
	SMART_DAT(0x0F),      
	SMART_DAT(0x1C),      
	SMART_DAT(0x22),     
	SMART_DAT(0x05),      
	SMART_DAT(0x11),
	SMART_DAT(0x06),      
	SMART_DAT(0x34),     
	SMART_DAT(0x56),      
	SMART_DAT(0x46),
	SMART_DAT(0x05),      
	SMART_DAT(0x0F),     
	SMART_DAT(0x0B),
	SMART_DAT(0x29),
	SMART_DAT(0x3A),
	SMART_DAT(0x0F),
	
	SMART_CMD(0x3a),	/* Pixel format Set (not in TM024HDH41 example) */	
	SMART_DAT(0x55),	/* 16 bpp */
	
	/* default to native portrait mode */
	SMART_CMD(0x2a),	/* Column Address Set */
	SMART_DAT(0x00),
	SMART_DAT(0x00),
	SMART_DAT(0x00),
	SMART_DAT(0xef),
	SMART_CMD(0x2b),	/* Row Address Set */
	SMART_DAT(0x00),
	SMART_DAT(0x00),
	SMART_DAT(0x01),
	SMART_DAT(0x3f),

	SMART_DELAY(10),
};

static const unsigned short ili9340_power_off[] = {
	/* There is no true power_off. Sleep shuts off everything possible */
	SMART_CMD(0x28),	/* Display Off */
	SMART_CMD(0x10),	/* Sleep In */
	SMART_DELAY(10),	/* spec 5 min */
};

static const unsigned short ili9340_panel_on[] = {
	SMART_DELAY(130),	/* spec 120ms min if Sleep In was pending */
	SMART_CMD(0x00),	/* NOP */
	SMART_CMD(0x11),	/* Sleep Out */	
	
	SMART_DELAY(130),	/* spec 120ms min */
	
	SMART_CMD(0x00),	/* NOP */
	SMART_CMD(0x29),	/* Display On */	

	SMART_CMD(0x00),	/* NOP */
	SMART_CMD(0x2c),	/* Memory write */
};

static const unsigned short ili9340_panel_off[] = {
	SMART_CMD(0),		/* NOP  */
	SMART_CMD(0x28),	/* Display Off */
};

static const unsigned short ili9340_frame_update[] = {
	SMART_CMD(0x00),	/* NOP to terminate previous write command */
	SMART_CMD(0x2c),	/* Memory write */
};

static const unsigned short ili9340_rotate[] = {
	SMART_CMD(0x28),	/* Display Off */

	/* landscape */
	SMART_CMD(0x36),	/* Memory Access Control */	
#if 0
	SMART_DAT(0xa8),	/* BGR sub-pixel ordering on panel */
				/* row/col exch */
				/* reverse row address order */
#elif 0

	SMART_DAT(0xe8),	/* BGR sub-pixel ordering on panel */
				/* row/col exch */
				/* reverse row address order */
				/* reverse col address order */
#else
	SMART_DAT(0x28),	/* BGR sub-pixel ordering on panel */
				/* row/col exch */
#endif
	SMART_CMD(0x2a),	/* Column Address Set */
	SMART_DAT(0x00),
	SMART_DAT(0x00),
	SMART_DAT(0x01),
	SMART_DAT(0x3f),
	SMART_CMD(0x2b),	/* Row Address Set */
	SMART_DAT(0x00),
	SMART_DAT(0x00),
	SMART_DAT(0x00),
	SMART_DAT(0xef),

	SMART_CMD(0x29),	/* Display On */	
};

static u16 ili9340_vsync_on[] = {
	SMART_CMD(0x28),	/* Display Off */

#if 1
	SMART_CMD(0x35),	/* Tearing Effect Line (sync output) ON */
	SMART_DAT(0x00),	/* vsync only mode */
#else
	SMART_CMD(0x44),	/* Set Tear Scanline */
	SMART_DAT(0x00),	/* selected scanline STS[8] */
	SMART_DAT(0x00),	/* selected scanline STS[7:0] */	
#endif

#if 0
	SMART_CMD(0xb1),	/* Frame Rate Control */	
	SMART_DAT(0x00),	/* fosc/1 */
	SMART_DAT(0x1f),	/* 31 clocks/line (61Hz)  */
#endif

	SMART_CMD(0x29),	/* Display On */	
};

static const lcd_smpn_info_t smpn_info_TM024HDH49 = {
	.xres = 320,
	.yres = 240,
	.rxlow = 355,
	.rxhigh = 90,
	.rxcycle = 450,
	.txlow = 15,
	.txhigh = 15,
	.txcycle = 66,
	.bpp = (8 * 2),
	.bufsize = (320 * 240 * 2),
	.power_on = ili9341_power_on,
	.power_on_size = ARRAY_SIZE(ili9341_power_on),
	.power_off = ili9340_power_off,
	.power_off_size = ARRAY_SIZE(ili9340_power_off),
	.panel_on = ili9340_panel_on,
	.panel_on_size = ARRAY_SIZE(ili9340_panel_on),
	.panel_off = ili9340_panel_off,
	.panel_off_size = ARRAY_SIZE(ili9340_panel_off),
	.frame_update = ili9340_frame_update,
	.frame_update_size = ARRAY_SIZE(ili9340_frame_update),
	.rotate = ili9340_rotate,
	.rotate_size = ARRAY_SIZE(ili9340_rotate),
	.vsync_on = ili9340_vsync_on,
	.vsync_on_size = ARRAY_SIZE(ili9340_vsync_on),
};
#endif

