#ifndef __PART_SSP_H__
#define __PART_SSP_H__

#define MBR_MAGIC       0x000055aa
#define MAX_PARTITIONS  60
#define MBR_SIZE        512
#define MBR_BLOCK_INDEX 2
#define MBR_OFFSET_0 (MBR_BLOCK_INDEX * (16*1024))
#define MBR_OFFSET_1 (MBR_BLOCK_INDEX * (128*1024))

typedef struct {
	unsigned int start, length;
} partition_table_t;

typedef struct {
	partition_table_t partition_table[MAX_PARTITIONS];
	/* Pushes MAGIC to end of 512-byte page */
	int _Reserved_[(MBR_SIZE - 4 /* sizeof(magic) */ - (MAX_PARTITIONS*sizeof(partition_table_t)))/4];
	uint32_t magic;
} master_boot_record_t;

#define PKGHDR_TAGWORD      0x62656166      /* Tag Word at front of pkg hdr     */
#define PKGNAME_ARRAY_SIZE     16
#define PKGVERSION_ARRAY_SIZE  16
#define PKGSUFFIX_ARRAY_SIZE    8
#define PKGUSERID_ARRAY_SIZE   16
#define PKGTIMEDATE_ARRAY_SIZE 26
#define PKGCRC_ARRAY_SIZE      16

typedef struct {
   unsigned int MagicWord;
   char  HdrMajorVer;
   char  HdrMinorVer;
   short HdrLength;
   int   PkgOffset;
   int   PkgLength;
   char  PkgName[PKGNAME_ARRAY_SIZE];     /*
			   * This will ONLY be used in a few cases such as what gets displayed when
			   * programming flash.  It will NOT be translated.  Most applications should
			   * rely on the package ID to check for a match of packages.
			   */
   char  PkgVersion[PKGVERSION_ARRAY_SIZE];
   char  PkgSuffix[PKGSUFFIX_ARRAY_SIZE];
   char  PkgNoPad;
   char  PkgNoCrcFail;
   short PkgID;
   unsigned int PkgType;
   int   _Reserved1;
   int   PkgFlags;
   int   PkgPartition;
   char  PkgUserid[PKGUSERID_ARRAY_SIZE];
   char  PkgTimeDate[PKGTIMEDATE_ARRAY_SIZE];
   short PkgSigned;
   short PkgSignSize;
   int   PkgSignOffset;
   int   PkgSignedImageSize;
   char  PkgNvBlkCnt;
   char  PkgDataVersion;
   int   PkgShaTblSize;
   int   PkgShaTblOffset;

   char  _Reserved2[48];
   int   CRCLength;
   unsigned int PkgCRC[PKGCRC_ARRAY_SIZE];
} __attribute__((__packed__))  packageHeader_t, PackageHeader_t;

#endif /* __PART_SSP_H__ */
