/*
 * (C) Copyright 2011
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <command.h>
#include <sha256.h>
#include <mv_mmp_panel.h>
#include <fcert_v3.h>

void __code_verification_failure(void) {
    while (1);
}
void code_verification_failure(void)
	__attribute__((weak, alias("__code_verification_failure")));

extern int verify_code(const uint8_t *code_hash, const uint8_t *fsig);

static int do_sha256verify(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	unsigned long addr, authenticate;
	struct fcert_v3 *cert;
	int rc = 0;
	u8 output[SHA256_SUM_LEN];

	if (argc < 4)
		return cmd_usage(cmdtp);

	addr = simple_strtoul(argv[1], NULL, 16);
	cert = (struct fcert_v3 *)simple_strtoul(argv[2], NULL, 16);
	authenticate = simple_strtoul(argv[3], NULL, 16);

	sha256_csum_wd((unsigned char *) addr, ntohl(cert->code.len), output, 0);

	if (authenticate > 0) {
		rc = verify_code(output, (uint8_t *)cert);
		printf("Code authentication %s\n", rc ? "failed" : "success");

		if (rc) {
#ifdef CONFIG_MV_MMP_PANEL
			mv_mmp_panel_status(MV_MMP_PANEL_AUTH_FAIL);
#endif
			code_verification_failure( );
		}
	}
	else {
		printf("Code authentication unnecessary\n");
	}

	return 0;
}

U_BOOT_CMD(
	sha256verify,	4,	1,	do_sha256verify,
	"verify kernel code image",
	"address cert authenticate"
);
