/*
 * Copyright (c) 2014 Stargate International Inc.
 * SPDX-License-Identifier:	GPL-2.0+
 */
#include <common.h>
#include <fdt_support.h>

#if defined(CONFIG_OF_BOARD_SETUP)
/* This corresponds to the device tree fragment in tests/fdt/timings.dts */
#define TIMING_NODE "/soc/internal-regs/lcd@e0000/display-timings/timing0"

static struct display_timing timing = {
	/* Just allow most all fields to be zero for now */

	/* Set two field with different values for min/max/typ to test
	 * generation of the correct number of cells */
	.hactive = {
		.min = 1,
		.typ = 2,
		.max = 3,
	},
	.vactive = {
		.min = 1,
		.typ = 1,
		.max = 2,
	},
};

void ft_lcd_setup(void *blob, bd_t *bd)
{
	fdt_fixup_display_timings(blob, TIMING_NODE, &timing);
}

void ft_board_setup(void *blob, bd_t *bd)
{
	ft_lcd_setup(blob, bd);
}
#endif
