#include <common.h>
#include <asm/arch/gpio.h>
#include <asm/gpio.h>

extern int get_board_suffix(void);

int  bootselect(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	int    i;
	int    boot=0;
	int    kernel_blockid   =0x10000;	/* 34MB(0x11000) -> 32,0x10000 */
	int    initramfs_blockid=0x12000;	/* 38MB(0x13000) -> 37,0x12000 */
#if defined(CONFIG_SD_BOOT)
	int    dtb_blockid=0x7800;			/* 15MB */
#else
	int    dtb_blockid=0x13800;			/* 41MB(0x14800) -> 40,0x13800 */
#endif /* defined(CONFIG_SD_BOOT) */
	char   buf[16];
	int    suffix;

	printf("simvaops --------\n");
#if !defined(CONFIG_SD_BOOT)
	/*  XXX : boot system select  */
	if(*(unsigned char *)0x400000 == 1)
	{
		boot = 1;
		kernel_blockid+=0x5000;			/* 0x4000 -> 0x5000 */
		initramfs_blockid+=0x5000;		/* 0x4000 -> 0x5000 */
		dtb_blockid+=0x5000;			/* 0x4000 -> 0x5000 */
	}
#endif /* !defined(CONFIG_SD_BOOT) */

	suffix = get_board_suffix();
	if (suffix < 7) {
		dtb_blockid += (0xa0 * suffix);
	}

#if !defined(CONFIG_SD_BOOT)
	/*  setenv boot */
	sprintf(buf, "%d", boot);
	setenv("boot", buf);
	/*  setenv kernel_blockid  */
	sprintf(buf, "0x%x", kernel_blockid);
	setenv("kernel_blockid", buf);
	/*  setenv initramfs_blockid  */
	sprintf(buf, "0x%x", initramfs_blockid);
	setenv("initramfs_blockid", buf);
#endif /* !defined(CONFIG_SD_BOOT) */
	/*  setenv dtb_blockid  */
	sprintf(buf, "0x%x", dtb_blockid);
	setenv("dtb_blockid", buf);

	return CMD_RET_SUCCESS;
}
U_BOOT_CMD(bootselect, 4, 0, bootselect, "select boot file", "");
