#include <common.h>
#include <asm/arch/regAddrs.h>
#include <asm/arch/adc_regmasks.h>
#include <asm/arch/adc_regstructs.h>

uint32_t mv61x0_adc_read(uint32_t channel) {
    int i;
    uint32_t *ip;
    struct ADC_REGS_REGS_s *adc = (struct ADC_REGS_REGS_s *)DEC_ADC_REGS_BASE;

    adc->IntEna = 0;
    adc->Int2Ena = 0;

    ip = (uint32_t *)&adc->TriggerConfig0;
    for (i=0; i<15; ++i, ip += (2 * sizeof(uint32_t)))
        *ip = 0;

    ip = (uint32_t *)&adc->Priority0;
    for (i=0; i<16; ++i, ip += sizeof(uint32_t))
        *ip = 0;

    adc->SARADC_Control |= (ADC_REGS_SARADC_CONTROL_VREF_SEL_MASK | ADC_REGS_SARADC_CONTROL_RESET_MASK);
    adc->SARADC_Control = ADC_REGS_SARADC_CONTROL_RESET_REPLACE_VAL(adc->SARADC_Control, 0);
    adc->SARADC_Control |= ADC_REGS_SARADC_CONTROL_PU_SARADC_MASK;

    adc->ADC_Control = 1;
    adc->ContTimebaseConfig = 0;

    adc->TriggerConfig14 = ADC_REGS_TRIGGERCONFIG14_TRIG_EDGE_REPLACE_VAL(adc->TriggerConfig14, 3);
    adc->TriggerConfig14 = ADC_REGS_TRIGGERCONFIG14_TBDELAY_REPLACE_VAL(adc->TriggerConfig14, 10);
    adc->TriggerConfig14 = ADC_REGS_TRIGGERCONFIG14_TBPERIOD_REPLACE_VAL(adc->TriggerConfig14, 10);

    adc->Instruction0 = ADC_REGS_INSTRUCTION0_N_SAMPLES_REPLACE_VAL(adc->Instruction0, 15);
    adc->Instruction0 = ADC_REGS_INSTRUCTION0_CHAN_REPLACE_VAL(adc->Instruction0, channel);

    adc->Priority14 = ADC_REGS_PRIORITY0_TRIGGER_SRC_REPLACE_VAL(adc->Priority14, 0xe);
    adc->Priority14 = ADC_REGS_PRIORITY0_INSTR_ADDR_REPLACE_VAL(adc->Priority14, 0);
    adc->Priority14 |= ADC_REGS_PRIORITY0_ENABLE_MASK;

    adc->FWRequest = ADC_REGS_FWREQUEST_START_MASK;
    while (!(adc->IntRaw & ADC_REGS_INTRAW_FW_DONE_MASK));
    adc->FWRequest = 0;

    return ((adc->RXData0 & ADC_REGS_RXDATA0_DATA_MASK) >> 6);
}
