 /*
 **************************************************************************************
 *
 * Copyright (c) 2011 Marvell International, Ltd.
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file VCF_wrappermasks.h
 * Generated using RegBuild 1.6.1
 *
 *************************************************************************
 */

#ifndef _VCF_WRAPPER_REGMASKS_H_
#define _VCF_WRAPPER_REGMASKS_H_

//#include <stdint.h>

//====================================================================
//
//Register File: VCF Wrapper Registers (VCF_Wrapper)
//
//====================================================================

//====================================================================
//Register: VCF Accumulator Low Register (Instance 1 of 12) (VALR0)
/** \brief  (Instance 1 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VALR0_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VALR0_VALUE_SHIFT 0
#define  VCF_WRAPPER_VALR0_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VALR0_VALUE_MASK) >> VCF_WRAPPER_VALR0_VALUE_SHIFT)
#define  VCF_WRAPPER_VALR0_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VALR0_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VALR0_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Low Register (Instance 2 of 12) (VALR1)
/** \brief  (Instance 2 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VALR1_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VALR1_VALUE_SHIFT 0
#define  VCF_WRAPPER_VALR1_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VALR1_VALUE_MASK) >> VCF_WRAPPER_VALR1_VALUE_SHIFT)
#define  VCF_WRAPPER_VALR1_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VALR1_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VALR1_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Low Register (Instance 3 of 12) (VALR2)
/** \brief  (Instance 3 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VALR2_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VALR2_VALUE_SHIFT 0
#define  VCF_WRAPPER_VALR2_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VALR2_VALUE_MASK) >> VCF_WRAPPER_VALR2_VALUE_SHIFT)
#define  VCF_WRAPPER_VALR2_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VALR2_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VALR2_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Low Register (Instance 4 of 12) (VALR3)
/** \brief  (Instance 4 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VALR3_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VALR3_VALUE_SHIFT 0
#define  VCF_WRAPPER_VALR3_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VALR3_VALUE_MASK) >> VCF_WRAPPER_VALR3_VALUE_SHIFT)
#define  VCF_WRAPPER_VALR3_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VALR3_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VALR3_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Low Register (Instance 5 of 12) (VALR4)
/** \brief  (Instance 5 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VALR4_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VALR4_VALUE_SHIFT 0
#define  VCF_WRAPPER_VALR4_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VALR4_VALUE_MASK) >> VCF_WRAPPER_VALR4_VALUE_SHIFT)
#define  VCF_WRAPPER_VALR4_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VALR4_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VALR4_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Low Register (Instance 6 of 12) (VALR5)
/** \brief  (Instance 6 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VALR5_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VALR5_VALUE_SHIFT 0
#define  VCF_WRAPPER_VALR5_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VALR5_VALUE_MASK) >> VCF_WRAPPER_VALR5_VALUE_SHIFT)
#define  VCF_WRAPPER_VALR5_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VALR5_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VALR5_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Low Register (Instance 7 of 12) (VALR6)
/** \brief  (Instance 7 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VALR6_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VALR6_VALUE_SHIFT 0
#define  VCF_WRAPPER_VALR6_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VALR6_VALUE_MASK) >> VCF_WRAPPER_VALR6_VALUE_SHIFT)
#define  VCF_WRAPPER_VALR6_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VALR6_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VALR6_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Low Register (Instance 8 of 12) (VALR7)
/** \brief  (Instance 8 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VALR7_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VALR7_VALUE_SHIFT 0
#define  VCF_WRAPPER_VALR7_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VALR7_VALUE_MASK) >> VCF_WRAPPER_VALR7_VALUE_SHIFT)
#define  VCF_WRAPPER_VALR7_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VALR7_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VALR7_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Low Register (Instance 9 of 12) (VALR8)
/** \brief  (Instance 9 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VALR8_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VALR8_VALUE_SHIFT 0
#define  VCF_WRAPPER_VALR8_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VALR8_VALUE_MASK) >> VCF_WRAPPER_VALR8_VALUE_SHIFT)
#define  VCF_WRAPPER_VALR8_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VALR8_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VALR8_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Low Register (Instance 10 of 12) (VALR9)
/** \brief  (Instance 10 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VALR9_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VALR9_VALUE_SHIFT 0
#define  VCF_WRAPPER_VALR9_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VALR9_VALUE_MASK) >> VCF_WRAPPER_VALR9_VALUE_SHIFT)
#define  VCF_WRAPPER_VALR9_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VALR9_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VALR9_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Low Register (Instance 11 of 12) (VALR10)
/** \brief  (Instance 11 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VALR10_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VALR10_VALUE_SHIFT 0
#define  VCF_WRAPPER_VALR10_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VALR10_VALUE_MASK) >> VCF_WRAPPER_VALR10_VALUE_SHIFT)
#define  VCF_WRAPPER_VALR10_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VALR10_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VALR10_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Low Register (Instance 12 of 12) (VALR11)
/** \brief  (Instance 12 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VALR11_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VALR11_VALUE_SHIFT 0
#define  VCF_WRAPPER_VALR11_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VALR11_VALUE_MASK) >> VCF_WRAPPER_VALR11_VALUE_SHIFT)
#define  VCF_WRAPPER_VALR11_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VALR11_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VALR11_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator High Register (Instance 1 of 12) (VAHR0)
/** \brief  (Instance 1 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAHR0_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAHR0_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAHR0_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAHR0_VALUE_MASK) >> VCF_WRAPPER_VAHR0_VALUE_SHIFT)
#define  VCF_WRAPPER_VAHR0_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAHR0_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAHR0_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator High Register (Instance 2 of 12) (VAHR1)
/** \brief  (Instance 2 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAHR1_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAHR1_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAHR1_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAHR1_VALUE_MASK) >> VCF_WRAPPER_VAHR1_VALUE_SHIFT)
#define  VCF_WRAPPER_VAHR1_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAHR1_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAHR1_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator High Register (Instance 3 of 12) (VAHR2)
/** \brief  (Instance 3 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAHR2_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAHR2_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAHR2_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAHR2_VALUE_MASK) >> VCF_WRAPPER_VAHR2_VALUE_SHIFT)
#define  VCF_WRAPPER_VAHR2_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAHR2_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAHR2_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator High Register (Instance 4 of 12) (VAHR3)
/** \brief  (Instance 4 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAHR3_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAHR3_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAHR3_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAHR3_VALUE_MASK) >> VCF_WRAPPER_VAHR3_VALUE_SHIFT)
#define  VCF_WRAPPER_VAHR3_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAHR3_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAHR3_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator High Register (Instance 5 of 12) (VAHR4)
/** \brief  (Instance 5 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAHR4_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAHR4_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAHR4_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAHR4_VALUE_MASK) >> VCF_WRAPPER_VAHR4_VALUE_SHIFT)
#define  VCF_WRAPPER_VAHR4_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAHR4_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAHR4_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator High Register (Instance 6 of 12) (VAHR5)
/** \brief  (Instance 6 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAHR5_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAHR5_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAHR5_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAHR5_VALUE_MASK) >> VCF_WRAPPER_VAHR5_VALUE_SHIFT)
#define  VCF_WRAPPER_VAHR5_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAHR5_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAHR5_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator High Register (Instance 7 of 12) (VAHR6)
/** \brief  (Instance 7 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAHR6_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAHR6_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAHR6_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAHR6_VALUE_MASK) >> VCF_WRAPPER_VAHR6_VALUE_SHIFT)
#define  VCF_WRAPPER_VAHR6_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAHR6_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAHR6_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator High Register (Instance 8 of 12) (VAHR7)
/** \brief  (Instance 8 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAHR7_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAHR7_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAHR7_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAHR7_VALUE_MASK) >> VCF_WRAPPER_VAHR7_VALUE_SHIFT)
#define  VCF_WRAPPER_VAHR7_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAHR7_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAHR7_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator High Register (Instance 9 of 12) (VAHR8)
/** \brief  (Instance 9 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAHR8_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAHR8_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAHR8_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAHR8_VALUE_MASK) >> VCF_WRAPPER_VAHR8_VALUE_SHIFT)
#define  VCF_WRAPPER_VAHR8_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAHR8_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAHR8_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator High Register (Instance 10 of 12) (VAHR9)
/** \brief  (Instance 10 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAHR9_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAHR9_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAHR9_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAHR9_VALUE_MASK) >> VCF_WRAPPER_VAHR9_VALUE_SHIFT)
#define  VCF_WRAPPER_VAHR9_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAHR9_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAHR9_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator High Register (Instance 11 of 12) (VAHR10)
/** \brief  (Instance 11 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAHR10_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAHR10_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAHR10_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAHR10_VALUE_MASK) >> VCF_WRAPPER_VAHR10_VALUE_SHIFT)
#define  VCF_WRAPPER_VAHR10_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAHR10_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAHR10_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator High Register (Instance 12 of 12) (VAHR11)
/** \brief  (Instance 12 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAHR11_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAHR11_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAHR11_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAHR11_VALUE_MASK) >> VCF_WRAPPER_VAHR11_VALUE_SHIFT)
#define  VCF_WRAPPER_VAHR11_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAHR11_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAHR11_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Increment Register (Instance 1 of 12) (VAIR0)
/** \brief  (Instance 1 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAIR0_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAIR0_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAIR0_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAIR0_VALUE_MASK) >> VCF_WRAPPER_VAIR0_VALUE_SHIFT)
#define  VCF_WRAPPER_VAIR0_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAIR0_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAIR0_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Increment Register (Instance 2 of 12) (VAIR1)
/** \brief  (Instance 2 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAIR1_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAIR1_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAIR1_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAIR1_VALUE_MASK) >> VCF_WRAPPER_VAIR1_VALUE_SHIFT)
#define  VCF_WRAPPER_VAIR1_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAIR1_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAIR1_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Increment Register (Instance 3 of 12) (VAIR2)
/** \brief  (Instance 3 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAIR2_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAIR2_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAIR2_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAIR2_VALUE_MASK) >> VCF_WRAPPER_VAIR2_VALUE_SHIFT)
#define  VCF_WRAPPER_VAIR2_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAIR2_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAIR2_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Increment Register (Instance 4 of 12) (VAIR3)
/** \brief  (Instance 4 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAIR3_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAIR3_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAIR3_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAIR3_VALUE_MASK) >> VCF_WRAPPER_VAIR3_VALUE_SHIFT)
#define  VCF_WRAPPER_VAIR3_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAIR3_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAIR3_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Increment Register (Instance 5 of 12) (VAIR4)
/** \brief  (Instance 5 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAIR4_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAIR4_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAIR4_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAIR4_VALUE_MASK) >> VCF_WRAPPER_VAIR4_VALUE_SHIFT)
#define  VCF_WRAPPER_VAIR4_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAIR4_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAIR4_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Increment Register (Instance 6 of 12) (VAIR5)
/** \brief  (Instance 6 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAIR5_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAIR5_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAIR5_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAIR5_VALUE_MASK) >> VCF_WRAPPER_VAIR5_VALUE_SHIFT)
#define  VCF_WRAPPER_VAIR5_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAIR5_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAIR5_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Increment Register (Instance 7 of 12) (VAIR6)
/** \brief  (Instance 7 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAIR6_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAIR6_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAIR6_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAIR6_VALUE_MASK) >> VCF_WRAPPER_VAIR6_VALUE_SHIFT)
#define  VCF_WRAPPER_VAIR6_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAIR6_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAIR6_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Increment Register (Instance 8 of 12) (VAIR7)
/** \brief  (Instance 8 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAIR7_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAIR7_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAIR7_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAIR7_VALUE_MASK) >> VCF_WRAPPER_VAIR7_VALUE_SHIFT)
#define  VCF_WRAPPER_VAIR7_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAIR7_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAIR7_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Increment Register (Instance 9 of 12) (VAIR8)
/** \brief  (Instance 9 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAIR8_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAIR8_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAIR8_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAIR8_VALUE_MASK) >> VCF_WRAPPER_VAIR8_VALUE_SHIFT)
#define  VCF_WRAPPER_VAIR8_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAIR8_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAIR8_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Increment Register (Instance 10 of 12) (VAIR9)
/** \brief  (Instance 10 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAIR9_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAIR9_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAIR9_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAIR9_VALUE_MASK) >> VCF_WRAPPER_VAIR9_VALUE_SHIFT)
#define  VCF_WRAPPER_VAIR9_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAIR9_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAIR9_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Increment Register (Instance 11 of 12) (VAIR10)
/** \brief  (Instance 11 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAIR10_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAIR10_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAIR10_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAIR10_VALUE_MASK) >> VCF_WRAPPER_VAIR10_VALUE_SHIFT)
#define  VCF_WRAPPER_VAIR10_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAIR10_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAIR10_VALUE_SHIFT))

//====================================================================
//Register: VCF Accumulator Increment Register (Instance 12 of 12) (VAIR11)
/** \brief  (Instance 12 of 12)*/
//====================================================================

#define  VCF_WRAPPER_VAIR11_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VAIR11_VALUE_SHIFT 0
#define  VCF_WRAPPER_VAIR11_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VAIR11_VALUE_MASK) >> VCF_WRAPPER_VAIR11_VALUE_SHIFT)
#define  VCF_WRAPPER_VAIR11_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VAIR11_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VAIR11_VALUE_SHIFT))

//====================================================================
//Register: VCF MCPU Hash Register (Instance 1 of 6) (VMHR0)
/** \brief  (Instance 1 of 6)*/
//====================================================================

#define  VCF_WRAPPER_VMHR0_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VMHR0_VALUE_SHIFT 0
#define  VCF_WRAPPER_VMHR0_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VMHR0_VALUE_MASK) >> VCF_WRAPPER_VMHR0_VALUE_SHIFT)
#define  VCF_WRAPPER_VMHR0_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VMHR0_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VMHR0_VALUE_SHIFT))

//====================================================================
//Register: VCF MCPU Hash Register (Instance 2 of 6) (VMHR1)
/** \brief  (Instance 2 of 6)*/
//====================================================================

#define  VCF_WRAPPER_VMHR1_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VMHR1_VALUE_SHIFT 0
#define  VCF_WRAPPER_VMHR1_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VMHR1_VALUE_MASK) >> VCF_WRAPPER_VMHR1_VALUE_SHIFT)
#define  VCF_WRAPPER_VMHR1_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VMHR1_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VMHR1_VALUE_SHIFT))

//====================================================================
//Register: VCF MCPU Hash Register (Instance 3 of 6) (VMHR2)
/** \brief  (Instance 3 of 6)*/
//====================================================================

#define  VCF_WRAPPER_VMHR2_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VMHR2_VALUE_SHIFT 0
#define  VCF_WRAPPER_VMHR2_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VMHR2_VALUE_MASK) >> VCF_WRAPPER_VMHR2_VALUE_SHIFT)
#define  VCF_WRAPPER_VMHR2_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VMHR2_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VMHR2_VALUE_SHIFT))

//====================================================================
//Register: VCF MCPU Hash Register (Instance 4 of 6) (VMHR3)
/** \brief  (Instance 4 of 6)*/
//====================================================================

#define  VCF_WRAPPER_VMHR3_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VMHR3_VALUE_SHIFT 0
#define  VCF_WRAPPER_VMHR3_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VMHR3_VALUE_MASK) >> VCF_WRAPPER_VMHR3_VALUE_SHIFT)
#define  VCF_WRAPPER_VMHR3_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VMHR3_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VMHR3_VALUE_SHIFT))

//====================================================================
//Register: VCF MCPU Hash Register (Instance 5 of 6) (VMHR4)
/** \brief  (Instance 5 of 6)*/
//====================================================================

#define  VCF_WRAPPER_VMHR4_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VMHR4_VALUE_SHIFT 0
#define  VCF_WRAPPER_VMHR4_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VMHR4_VALUE_MASK) >> VCF_WRAPPER_VMHR4_VALUE_SHIFT)
#define  VCF_WRAPPER_VMHR4_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VMHR4_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VMHR4_VALUE_SHIFT))

//====================================================================
//Register: VCF MCPU Hash Register (Instance 6 of 6) (VMHR5)
/** \brief  (Instance 6 of 6)*/
//====================================================================

#define  VCF_WRAPPER_VMHR5_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VMHR5_VALUE_SHIFT 0
#define  VCF_WRAPPER_VMHR5_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VMHR5_VALUE_MASK) >> VCF_WRAPPER_VMHR5_VALUE_SHIFT)
#define  VCF_WRAPPER_VMHR5_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VMHR5_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VMHR5_VALUE_SHIFT))

//====================================================================
//Register: VCF ICPU0 Hash Register (Instance 1 of 6) (VIHR00)
/** \brief  (Instance 1 of 6)*/
//====================================================================

#define  VCF_WRAPPER_VIHR00_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VIHR00_VALUE_SHIFT 0
#define  VCF_WRAPPER_VIHR00_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VIHR00_VALUE_MASK) >> VCF_WRAPPER_VIHR00_VALUE_SHIFT)
#define  VCF_WRAPPER_VIHR00_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VIHR00_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VIHR00_VALUE_SHIFT))

//====================================================================
//Register: VCF ICPU0 Hash Register (Instance 2 of 6) (VIHR01)
/** \brief  (Instance 2 of 6)*/
//====================================================================

#define  VCF_WRAPPER_VIHR01_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VIHR01_VALUE_SHIFT 0
#define  VCF_WRAPPER_VIHR01_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VIHR01_VALUE_MASK) >> VCF_WRAPPER_VIHR01_VALUE_SHIFT)
#define  VCF_WRAPPER_VIHR01_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VIHR01_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VIHR01_VALUE_SHIFT))

//====================================================================
//Register: VCF ICPU0 Hash Register (Instance 3 of 6) (VIHR02)
/** \brief  (Instance 3 of 6)*/
//====================================================================

#define  VCF_WRAPPER_VIHR02_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VIHR02_VALUE_SHIFT 0
#define  VCF_WRAPPER_VIHR02_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VIHR02_VALUE_MASK) >> VCF_WRAPPER_VIHR02_VALUE_SHIFT)
#define  VCF_WRAPPER_VIHR02_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VIHR02_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VIHR02_VALUE_SHIFT))

//====================================================================
//Register: VCF ICPU0 Hash Register (Instance 4 of 6) (VIHR03)
/** \brief  (Instance 4 of 6)*/
//====================================================================

#define  VCF_WRAPPER_VIHR03_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VIHR03_VALUE_SHIFT 0
#define  VCF_WRAPPER_VIHR03_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VIHR03_VALUE_MASK) >> VCF_WRAPPER_VIHR03_VALUE_SHIFT)
#define  VCF_WRAPPER_VIHR03_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VIHR03_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VIHR03_VALUE_SHIFT))

//====================================================================
//Register: VCF ICPU0 Hash Register (Instance 5 of 6) (VIHR04)
/** \brief  (Instance 5 of 6)*/
//====================================================================

#define  VCF_WRAPPER_VIHR04_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VIHR04_VALUE_SHIFT 0
#define  VCF_WRAPPER_VIHR04_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VIHR04_VALUE_MASK) >> VCF_WRAPPER_VIHR04_VALUE_SHIFT)
#define  VCF_WRAPPER_VIHR04_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VIHR04_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VIHR04_VALUE_SHIFT))

//====================================================================
//Register: VCF ICPU0 Hash Register (Instance 6 of 6) (VIHR05)
/** \brief  (Instance 6 of 6)*/
//====================================================================

#define  VCF_WRAPPER_VIHR05_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VIHR05_VALUE_SHIFT 0
#define  VCF_WRAPPER_VIHR05_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VIHR05_VALUE_MASK) >> VCF_WRAPPER_VIHR05_VALUE_SHIFT)
#define  VCF_WRAPPER_VIHR05_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VIHR05_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VIHR05_VALUE_SHIFT))

//====================================================================
//Register: VCF ICPU1 Hash Register (Instance 1 of 6) (VIHR10)
/** \brief  (Instance 1 of 6)*/
//====================================================================

#define  VCF_WRAPPER_VIHR10_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VIHR10_VALUE_SHIFT 0
#define  VCF_WRAPPER_VIHR10_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VIHR10_VALUE_MASK) >> VCF_WRAPPER_VIHR10_VALUE_SHIFT)
#define  VCF_WRAPPER_VIHR10_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VIHR10_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VIHR10_VALUE_SHIFT))

//====================================================================
//Register: VCF ICPU1 Hash Register (Instance 2 of 6) (VIHR11)
/** \brief  (Instance 2 of 6)*/
//====================================================================

#define  VCF_WRAPPER_VIHR11_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VIHR11_VALUE_SHIFT 0
#define  VCF_WRAPPER_VIHR11_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VIHR11_VALUE_MASK) >> VCF_WRAPPER_VIHR11_VALUE_SHIFT)
#define  VCF_WRAPPER_VIHR11_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VIHR11_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VIHR11_VALUE_SHIFT))

//====================================================================
//Register: VCF ICPU1 Hash Register (Instance 3 of 6) (VIHR12)
/** \brief  (Instance 3 of 6)*/
//====================================================================

#define  VCF_WRAPPER_VIHR12_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VIHR12_VALUE_SHIFT 0
#define  VCF_WRAPPER_VIHR12_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VIHR12_VALUE_MASK) >> VCF_WRAPPER_VIHR12_VALUE_SHIFT)
#define  VCF_WRAPPER_VIHR12_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VIHR12_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VIHR12_VALUE_SHIFT))

//====================================================================
//Register: VCF ICPU1 Hash Register (Instance 4 of 6) (VIHR13)
/** \brief  (Instance 4 of 6)*/
//====================================================================

#define  VCF_WRAPPER_VIHR13_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VIHR13_VALUE_SHIFT 0
#define  VCF_WRAPPER_VIHR13_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VIHR13_VALUE_MASK) >> VCF_WRAPPER_VIHR13_VALUE_SHIFT)
#define  VCF_WRAPPER_VIHR13_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VIHR13_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VIHR13_VALUE_SHIFT))

//====================================================================
//Register: VCF ICPU1 Hash Register (Instance 5 of 6) (VIHR14)
/** \brief  (Instance 5 of 6)*/
//====================================================================

#define  VCF_WRAPPER_VIHR14_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VIHR14_VALUE_SHIFT 0
#define  VCF_WRAPPER_VIHR14_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VIHR14_VALUE_MASK) >> VCF_WRAPPER_VIHR14_VALUE_SHIFT)
#define  VCF_WRAPPER_VIHR14_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VIHR14_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VIHR14_VALUE_SHIFT))

//====================================================================
//Register: VCF ICPU1 Hash Register (Instance 6 of 6) (VIHR15)
/** \brief  (Instance 6 of 6)*/
//====================================================================

#define  VCF_WRAPPER_VIHR15_VALUE_MASK 0xffffffff
#define  VCF_WRAPPER_VIHR15_VALUE_SHIFT 0
#define  VCF_WRAPPER_VIHR15_VALUE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VIHR15_VALUE_MASK) >> VCF_WRAPPER_VIHR15_VALUE_SHIFT)
#define  VCF_WRAPPER_VIHR15_VALUE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VIHR15_VALUE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VIHR15_VALUE_SHIFT))

//====================================================================
//Register: VCF Wrapper Status Register (VWSR)
//====================================================================

#define  VCF_WRAPPER_VWSR_RESERVED1_MASK 0xffffe000
#define  VCF_WRAPPER_VWSR_RESERVED1_SHIFT 13
#define  VCF_WRAPPER_VWSR_RESERVED1_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VWSR_RESERVED1_MASK) >> VCF_WRAPPER_VWSR_RESERVED1_SHIFT)
#define  VCF_WRAPPER_VWSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VWSR_RESERVED1_MASK) | (((uint32_t)val) << VCF_WRAPPER_VWSR_RESERVED1_SHIFT))

#define  VCF_WRAPPER_VWSR_LASERACCUMSEL_MASK 0x1000
#define  VCF_WRAPPER_VWSR_LASERACCUMSEL_SHIFT 12
#define  VCF_WRAPPER_VWSR_LASERACCUMSEL_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VWSR_LASERACCUMSEL_MASK) >> VCF_WRAPPER_VWSR_LASERACCUMSEL_SHIFT)
#define  VCF_WRAPPER_VWSR_LASERACCUMSEL_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VWSR_LASERACCUMSEL_MASK) | (((uint32_t)val) << VCF_WRAPPER_VWSR_LASERACCUMSEL_SHIFT))

#define  VCF_WRAPPER_VWSR_ALTINKMODE_MASK 0x800
#define  VCF_WRAPPER_VWSR_ALTINKMODE_SHIFT 11
#define  VCF_WRAPPER_VWSR_ALTINKMODE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VWSR_ALTINKMODE_MASK) >> VCF_WRAPPER_VWSR_ALTINKMODE_SHIFT)
#define  VCF_WRAPPER_VWSR_ALTINKMODE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VWSR_ALTINKMODE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VWSR_ALTINKMODE_SHIFT))

#define  VCF_WRAPPER_VWSR_SECUREDTCM_MASK 0x700
#define  VCF_WRAPPER_VWSR_SECUREDTCM_SHIFT 8
#define  VCF_WRAPPER_VWSR_SECUREDTCM_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VWSR_SECUREDTCM_MASK) >> VCF_WRAPPER_VWSR_SECUREDTCM_SHIFT)
#define  VCF_WRAPPER_VWSR_SECUREDTCM_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VWSR_SECUREDTCM_MASK) | (((uint32_t)val) << VCF_WRAPPER_VWSR_SECUREDTCM_SHIFT))

#define  VCF_WRAPPER_VWSR_IHASHBYPASS_MASK 0x80
#define  VCF_WRAPPER_VWSR_IHASHBYPASS_SHIFT 7
#define  VCF_WRAPPER_VWSR_IHASHBYPASS_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VWSR_IHASHBYPASS_MASK) >> VCF_WRAPPER_VWSR_IHASHBYPASS_SHIFT)
#define  VCF_WRAPPER_VWSR_IHASHBYPASS_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VWSR_IHASHBYPASS_MASK) | (((uint32_t)val) << VCF_WRAPPER_VWSR_IHASHBYPASS_SHIFT))

#define  VCF_WRAPPER_VWSR_MHASHBYPASS_MASK 0x40
#define  VCF_WRAPPER_VWSR_MHASHBYPASS_SHIFT 6
#define  VCF_WRAPPER_VWSR_MHASHBYPASS_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VWSR_MHASHBYPASS_MASK) >> VCF_WRAPPER_VWSR_MHASHBYPASS_SHIFT)
#define  VCF_WRAPPER_VWSR_MHASHBYPASS_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VWSR_MHASHBYPASS_MASK) | (((uint32_t)val) << VCF_WRAPPER_VWSR_MHASHBYPASS_SHIFT))

#define  VCF_WRAPPER_VWSR_MINFUNC_MASK 0x20
#define  VCF_WRAPPER_VWSR_MINFUNC_SHIFT 5
#define  VCF_WRAPPER_VWSR_MINFUNC_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VWSR_MINFUNC_MASK) >> VCF_WRAPPER_VWSR_MINFUNC_SHIFT)
#define  VCF_WRAPPER_VWSR_MINFUNC_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VWSR_MINFUNC_MASK) | (((uint32_t)val) << VCF_WRAPPER_VWSR_MINFUNC_SHIFT))

#define  VCF_WRAPPER_VWSR_REQUESTBLOCKALL_MASK 0x10
#define  VCF_WRAPPER_VWSR_REQUESTBLOCKALL_SHIFT 4
#define  VCF_WRAPPER_VWSR_REQUESTBLOCKALL_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VWSR_REQUESTBLOCKALL_MASK) >> VCF_WRAPPER_VWSR_REQUESTBLOCKALL_SHIFT)
#define  VCF_WRAPPER_VWSR_REQUESTBLOCKALL_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VWSR_REQUESTBLOCKALL_MASK) | (((uint32_t)val) << VCF_WRAPPER_VWSR_REQUESTBLOCKALL_SHIFT))

#define  VCF_WRAPPER_VWSR_STATEICPU1_MASK 0xc
#define  VCF_WRAPPER_VWSR_STATEICPU1_SHIFT 2
#define  VCF_WRAPPER_VWSR_STATEICPU1_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VWSR_STATEICPU1_MASK) >> VCF_WRAPPER_VWSR_STATEICPU1_SHIFT)
#define  VCF_WRAPPER_VWSR_STATEICPU1_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VWSR_STATEICPU1_MASK) | (((uint32_t)val) << VCF_WRAPPER_VWSR_STATEICPU1_SHIFT))

#define  VCF_WRAPPER_VWSR_STATEICPU0_MASK 0x3
#define  VCF_WRAPPER_VWSR_STATEICPU0_SHIFT 0
#define  VCF_WRAPPER_VWSR_STATEICPU0_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VWSR_STATEICPU0_MASK) >> VCF_WRAPPER_VWSR_STATEICPU0_SHIFT)
#define  VCF_WRAPPER_VWSR_STATEICPU0_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VWSR_STATEICPU0_MASK) | (((uint32_t)val) << VCF_WRAPPER_VWSR_STATEICPU0_SHIFT))

//====================================================================
//Register: VCF Minimum Function Register (VMFR)
//====================================================================

#define  VCF_WRAPPER_VMFR_RESERVED1_MASK 0xfffffffe
#define  VCF_WRAPPER_VMFR_RESERVED1_SHIFT 1
#define  VCF_WRAPPER_VMFR_RESERVED1_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VMFR_RESERVED1_MASK) >> VCF_WRAPPER_VMFR_RESERVED1_SHIFT)
#define  VCF_WRAPPER_VMFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VMFR_RESERVED1_MASK) | (((uint32_t)val) << VCF_WRAPPER_VMFR_RESERVED1_SHIFT))

#define  VCF_WRAPPER_VMFR_MINFUNC_MASK 0x1
#define  VCF_WRAPPER_VMFR_MINFUNC_SHIFT 0
#define  VCF_WRAPPER_VMFR_MINFUNC_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VMFR_MINFUNC_MASK) >> VCF_WRAPPER_VMFR_MINFUNC_SHIFT)
#define  VCF_WRAPPER_VMFR_MINFUNC_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VMFR_MINFUNC_MASK) | (((uint32_t)val) << VCF_WRAPPER_VMFR_MINFUNC_SHIFT))

//====================================================================
//Register: VCF Laser Map Register (VLMR)
//====================================================================

#define  VCF_WRAPPER_VLMR_RESERVED1_MASK 0x80000000
#define  VCF_WRAPPER_VLMR_RESERVED1_SHIFT 31
#define  VCF_WRAPPER_VLMR_RESERVED1_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VLMR_RESERVED1_MASK) >> VCF_WRAPPER_VLMR_RESERVED1_SHIFT)
#define  VCF_WRAPPER_VLMR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VLMR_RESERVED1_MASK) | (((uint32_t)val) << VCF_WRAPPER_VLMR_RESERVED1_SHIFT))

#define  VCF_WRAPPER_VLMR_CHAN7_MASK 0x70000000
#define  VCF_WRAPPER_VLMR_CHAN7_SHIFT 28
#define  VCF_WRAPPER_VLMR_CHAN7_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VLMR_CHAN7_MASK) >> VCF_WRAPPER_VLMR_CHAN7_SHIFT)
#define  VCF_WRAPPER_VLMR_CHAN7_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VLMR_CHAN7_MASK) | (((uint32_t)val) << VCF_WRAPPER_VLMR_CHAN7_SHIFT))

#define  VCF_WRAPPER_VLMR_RESERVED2_MASK 0x8000000
#define  VCF_WRAPPER_VLMR_RESERVED2_SHIFT 27
#define  VCF_WRAPPER_VLMR_RESERVED2_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VLMR_RESERVED2_MASK) >> VCF_WRAPPER_VLMR_RESERVED2_SHIFT)
#define  VCF_WRAPPER_VLMR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VLMR_RESERVED2_MASK) | (((uint32_t)val) << VCF_WRAPPER_VLMR_RESERVED2_SHIFT))

#define  VCF_WRAPPER_VLMR_CHAN6_MASK 0x7000000
#define  VCF_WRAPPER_VLMR_CHAN6_SHIFT 24
#define  VCF_WRAPPER_VLMR_CHAN6_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VLMR_CHAN6_MASK) >> VCF_WRAPPER_VLMR_CHAN6_SHIFT)
#define  VCF_WRAPPER_VLMR_CHAN6_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VLMR_CHAN6_MASK) | (((uint32_t)val) << VCF_WRAPPER_VLMR_CHAN6_SHIFT))

#define  VCF_WRAPPER_VLMR_RESERVED3_MASK 0x800000
#define  VCF_WRAPPER_VLMR_RESERVED3_SHIFT 23
#define  VCF_WRAPPER_VLMR_RESERVED3_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VLMR_RESERVED3_MASK) >> VCF_WRAPPER_VLMR_RESERVED3_SHIFT)
#define  VCF_WRAPPER_VLMR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VLMR_RESERVED3_MASK) | (((uint32_t)val) << VCF_WRAPPER_VLMR_RESERVED3_SHIFT))

#define  VCF_WRAPPER_VLMR_CHAN5_MASK 0x700000
#define  VCF_WRAPPER_VLMR_CHAN5_SHIFT 20
#define  VCF_WRAPPER_VLMR_CHAN5_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VLMR_CHAN5_MASK) >> VCF_WRAPPER_VLMR_CHAN5_SHIFT)
#define  VCF_WRAPPER_VLMR_CHAN5_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VLMR_CHAN5_MASK) | (((uint32_t)val) << VCF_WRAPPER_VLMR_CHAN5_SHIFT))

#define  VCF_WRAPPER_VLMR_RESERVED4_MASK 0x80000
#define  VCF_WRAPPER_VLMR_RESERVED4_SHIFT 19
#define  VCF_WRAPPER_VLMR_RESERVED4_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VLMR_RESERVED4_MASK) >> VCF_WRAPPER_VLMR_RESERVED4_SHIFT)
#define  VCF_WRAPPER_VLMR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VLMR_RESERVED4_MASK) | (((uint32_t)val) << VCF_WRAPPER_VLMR_RESERVED4_SHIFT))

#define  VCF_WRAPPER_VLMR_CHAN4_MASK 0x70000
#define  VCF_WRAPPER_VLMR_CHAN4_SHIFT 16
#define  VCF_WRAPPER_VLMR_CHAN4_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VLMR_CHAN4_MASK) >> VCF_WRAPPER_VLMR_CHAN4_SHIFT)
#define  VCF_WRAPPER_VLMR_CHAN4_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VLMR_CHAN4_MASK) | (((uint32_t)val) << VCF_WRAPPER_VLMR_CHAN4_SHIFT))

#define  VCF_WRAPPER_VLMR_RESERVED5_MASK 0x8000
#define  VCF_WRAPPER_VLMR_RESERVED5_SHIFT 15
#define  VCF_WRAPPER_VLMR_RESERVED5_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VLMR_RESERVED5_MASK) >> VCF_WRAPPER_VLMR_RESERVED5_SHIFT)
#define  VCF_WRAPPER_VLMR_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VLMR_RESERVED5_MASK) | (((uint32_t)val) << VCF_WRAPPER_VLMR_RESERVED5_SHIFT))

#define  VCF_WRAPPER_VLMR_CHAN3_MASK 0x7000
#define  VCF_WRAPPER_VLMR_CHAN3_SHIFT 12
#define  VCF_WRAPPER_VLMR_CHAN3_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VLMR_CHAN3_MASK) >> VCF_WRAPPER_VLMR_CHAN3_SHIFT)
#define  VCF_WRAPPER_VLMR_CHAN3_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VLMR_CHAN3_MASK) | (((uint32_t)val) << VCF_WRAPPER_VLMR_CHAN3_SHIFT))

#define  VCF_WRAPPER_VLMR_RESERVED6_MASK 0x800
#define  VCF_WRAPPER_VLMR_RESERVED6_SHIFT 11
#define  VCF_WRAPPER_VLMR_RESERVED6_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VLMR_RESERVED6_MASK) >> VCF_WRAPPER_VLMR_RESERVED6_SHIFT)
#define  VCF_WRAPPER_VLMR_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VLMR_RESERVED6_MASK) | (((uint32_t)val) << VCF_WRAPPER_VLMR_RESERVED6_SHIFT))

#define  VCF_WRAPPER_VLMR_CHAN2_MASK 0x700
#define  VCF_WRAPPER_VLMR_CHAN2_SHIFT 8
#define  VCF_WRAPPER_VLMR_CHAN2_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VLMR_CHAN2_MASK) >> VCF_WRAPPER_VLMR_CHAN2_SHIFT)
#define  VCF_WRAPPER_VLMR_CHAN2_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VLMR_CHAN2_MASK) | (((uint32_t)val) << VCF_WRAPPER_VLMR_CHAN2_SHIFT))

#define  VCF_WRAPPER_VLMR_RESERVED7_MASK 0x80
#define  VCF_WRAPPER_VLMR_RESERVED7_SHIFT 7
#define  VCF_WRAPPER_VLMR_RESERVED7_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VLMR_RESERVED7_MASK) >> VCF_WRAPPER_VLMR_RESERVED7_SHIFT)
#define  VCF_WRAPPER_VLMR_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VLMR_RESERVED7_MASK) | (((uint32_t)val) << VCF_WRAPPER_VLMR_RESERVED7_SHIFT))

#define  VCF_WRAPPER_VLMR_CHAN1_MASK 0x70
#define  VCF_WRAPPER_VLMR_CHAN1_SHIFT 4
#define  VCF_WRAPPER_VLMR_CHAN1_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VLMR_CHAN1_MASK) >> VCF_WRAPPER_VLMR_CHAN1_SHIFT)
#define  VCF_WRAPPER_VLMR_CHAN1_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VLMR_CHAN1_MASK) | (((uint32_t)val) << VCF_WRAPPER_VLMR_CHAN1_SHIFT))

#define  VCF_WRAPPER_VLMR_RESERVED8_MASK 0x8
#define  VCF_WRAPPER_VLMR_RESERVED8_SHIFT 3
#define  VCF_WRAPPER_VLMR_RESERVED8_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VLMR_RESERVED8_MASK) >> VCF_WRAPPER_VLMR_RESERVED8_SHIFT)
#define  VCF_WRAPPER_VLMR_RESERVED8_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VLMR_RESERVED8_MASK) | (((uint32_t)val) << VCF_WRAPPER_VLMR_RESERVED8_SHIFT))

#define  VCF_WRAPPER_VLMR_CHAN0_MASK 0x7
#define  VCF_WRAPPER_VLMR_CHAN0_SHIFT 0
#define  VCF_WRAPPER_VLMR_CHAN0_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VLMR_CHAN0_MASK) >> VCF_WRAPPER_VLMR_CHAN0_SHIFT)
#define  VCF_WRAPPER_VLMR_CHAN0_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VLMR_CHAN0_MASK) | (((uint32_t)val) << VCF_WRAPPER_VLMR_CHAN0_SHIFT))

//====================================================================
//Register: VCF Laser Enforce Register (VLER)
//====================================================================

#define  VCF_WRAPPER_VLER_RESERVED1_MASK 0xffffff00
#define  VCF_WRAPPER_VLER_RESERVED1_SHIFT 8
#define  VCF_WRAPPER_VLER_RESERVED1_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VLER_RESERVED1_MASK) >> VCF_WRAPPER_VLER_RESERVED1_SHIFT)
#define  VCF_WRAPPER_VLER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VLER_RESERVED1_MASK) | (((uint32_t)val) << VCF_WRAPPER_VLER_RESERVED1_SHIFT))

#define  VCF_WRAPPER_VLER_LASERENFORCE_MASK 0xff
#define  VCF_WRAPPER_VLER_LASERENFORCE_SHIFT 0
#define  VCF_WRAPPER_VLER_LASERENFORCE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VLER_LASERENFORCE_MASK) >> VCF_WRAPPER_VLER_LASERENFORCE_SHIFT)
#define  VCF_WRAPPER_VLER_LASERENFORCE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VLER_LASERENFORCE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VLER_LASERENFORCE_SHIFT))

//====================================================================
//Register: VCF Ink Enforce Register 0 (VIER0)
//====================================================================

#define  VCF_WRAPPER_VIER0_INKENFORCE_MASK 0xffffffff
#define  VCF_WRAPPER_VIER0_INKENFORCE_SHIFT 0
#define  VCF_WRAPPER_VIER0_INKENFORCE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VIER0_INKENFORCE_MASK) >> VCF_WRAPPER_VIER0_INKENFORCE_SHIFT)
#define  VCF_WRAPPER_VIER0_INKENFORCE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VIER0_INKENFORCE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VIER0_INKENFORCE_SHIFT))

//====================================================================
//Register: VCF Ink Enforce Register 1 (VIER1)
//====================================================================

#define  VCF_WRAPPER_VIER1_RESERVED1_MASK 0xfffe0000
#define  VCF_WRAPPER_VIER1_RESERVED1_SHIFT 17
#define  VCF_WRAPPER_VIER1_RESERVED1_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VIER1_RESERVED1_MASK) >> VCF_WRAPPER_VIER1_RESERVED1_SHIFT)
#define  VCF_WRAPPER_VIER1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VIER1_RESERVED1_MASK) | (((uint32_t)val) << VCF_WRAPPER_VIER1_RESERVED1_SHIFT))

#define  VCF_WRAPPER_VIER1_INKENFORCEEXTRA_MASK 0x10000
#define  VCF_WRAPPER_VIER1_INKENFORCEEXTRA_SHIFT 16
#define  VCF_WRAPPER_VIER1_INKENFORCEEXTRA_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VIER1_INKENFORCEEXTRA_MASK) >> VCF_WRAPPER_VIER1_INKENFORCEEXTRA_SHIFT)
#define  VCF_WRAPPER_VIER1_INKENFORCEEXTRA_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VIER1_INKENFORCEEXTRA_MASK) | (((uint32_t)val) << VCF_WRAPPER_VIER1_INKENFORCEEXTRA_SHIFT))

#define  VCF_WRAPPER_VIER1_INKENFORCE_MASK 0xffff
#define  VCF_WRAPPER_VIER1_INKENFORCE_SHIFT 0
#define  VCF_WRAPPER_VIER1_INKENFORCE_MASK_SHIFT(reg) (((reg) & VCF_WRAPPER_VIER1_INKENFORCE_MASK) >> VCF_WRAPPER_VIER1_INKENFORCE_SHIFT)
#define  VCF_WRAPPER_VIER1_INKENFORCE_REPLACE_VAL(reg,val) (((reg) & ~VCF_WRAPPER_VIER1_INKENFORCE_MASK) | (((uint32_t)val) << VCF_WRAPPER_VIER1_INKENFORCE_SHIFT))

#endif // VCF_WRAPPER
