 /*
 **************************************************************************************
 *
 * Copyright (c) 2010 Marvell International, Ltd.
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file USB2TOP_regmasks.h
 * Generated using RegBuild 1.6.1
 *
 *************************************************************************
 */

#ifndef _USB2TOP_REGMASKS_H_
#define _USB2TOP_REGMASKS_H_

//#include <stdint.h>

//====================================================================
//
//Register File: USB2TOP (USB2TOP)
//
//====================================================================

//====================================================================
//
//Register File: USB Device (USB2D)
//
//====================================================================

//====================================================================
//Register: Identification Register (ID)
//====================================================================

#define  USB2D_ID_CIVERSION_MASK 0xe0000000
#define  USB2D_ID_CIVERSION_SHIFT 29
#define  USB2D_ID_CIVERSION_MASK_SHIFT(reg) (((reg) & USB2D_ID_CIVERSION_MASK) >> USB2D_ID_CIVERSION_SHIFT)
#define  USB2D_ID_CIVERSION_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ID_CIVERSION_MASK) | (((uint32_t)val) << USB2D_ID_CIVERSION_SHIFT))

#define  USB2D_ID_VERSION_MASK 0x1e000000
#define  USB2D_ID_VERSION_SHIFT 25
#define  USB2D_ID_VERSION_MASK_SHIFT(reg) (((reg) & USB2D_ID_VERSION_MASK) >> USB2D_ID_VERSION_SHIFT)
#define  USB2D_ID_VERSION_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ID_VERSION_MASK) | (((uint32_t)val) << USB2D_ID_VERSION_SHIFT))

#define  USB2D_ID_REVISION_MASK 0x1e00000
#define  USB2D_ID_REVISION_SHIFT 21
#define  USB2D_ID_REVISION_MASK_SHIFT(reg) (((reg) & USB2D_ID_REVISION_MASK) >> USB2D_ID_REVISION_SHIFT)
#define  USB2D_ID_REVISION_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ID_REVISION_MASK) | (((uint32_t)val) << USB2D_ID_REVISION_SHIFT))

#define  USB2D_ID_TAG_MASK 0x1f0000
#define  USB2D_ID_TAG_SHIFT 16
#define  USB2D_ID_TAG_MASK_SHIFT(reg) (((reg) & USB2D_ID_TAG_MASK) >> USB2D_ID_TAG_SHIFT)
#define  USB2D_ID_TAG_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ID_TAG_MASK) | (((uint32_t)val) << USB2D_ID_TAG_SHIFT))

#define  USB2D_ID_NID_MASK 0xff00
#define  USB2D_ID_NID_SHIFT 8
#define  USB2D_ID_NID_MASK_SHIFT(reg) (((reg) & USB2D_ID_NID_MASK) >> USB2D_ID_NID_SHIFT)
#define  USB2D_ID_NID_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ID_NID_MASK) | (((uint32_t)val) << USB2D_ID_NID_SHIFT))

#define  USB2D_ID_ID_MASK 0xff
#define  USB2D_ID_ID_SHIFT 0
#define  USB2D_ID_ID_MASK_SHIFT(reg) (((reg) & USB2D_ID_ID_MASK) >> USB2D_ID_ID_SHIFT)
#define  USB2D_ID_ID_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ID_ID_MASK) | (((uint32_t)val) << USB2D_ID_ID_SHIFT))

//====================================================================
//Register: ChipIdea General Hardware Parameters Register (HWGENERAL)
//====================================================================

#define  USB2D_HWGENERAL_RESERVED1_MASK 0xfffff800
#define  USB2D_HWGENERAL_RESERVED1_SHIFT 11
#define  USB2D_HWGENERAL_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_HWGENERAL_RESERVED1_MASK) >> USB2D_HWGENERAL_RESERVED1_SHIFT)
#define  USB2D_HWGENERAL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HWGENERAL_RESERVED1_MASK) | (((uint32_t)val) << USB2D_HWGENERAL_RESERVED1_SHIFT))

#define  USB2D_HWGENERAL_SM_MASK 0x600
#define  USB2D_HWGENERAL_SM_SHIFT 9
#define  USB2D_HWGENERAL_SM_MASK_SHIFT(reg) (((reg) & USB2D_HWGENERAL_SM_MASK) >> USB2D_HWGENERAL_SM_SHIFT)
#define  USB2D_HWGENERAL_SM_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HWGENERAL_SM_MASK) | (((uint32_t)val) << USB2D_HWGENERAL_SM_SHIFT))

#define  USB2D_HWGENERAL_PHYM_MASK 0x1c0
#define  USB2D_HWGENERAL_PHYM_SHIFT 6
#define  USB2D_HWGENERAL_PHYM_MASK_SHIFT(reg) (((reg) & USB2D_HWGENERAL_PHYM_MASK) >> USB2D_HWGENERAL_PHYM_SHIFT)
#define  USB2D_HWGENERAL_PHYM_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HWGENERAL_PHYM_MASK) | (((uint32_t)val) << USB2D_HWGENERAL_PHYM_SHIFT))

#define  USB2D_HWGENERAL_PHYW_MASK 0x30
#define  USB2D_HWGENERAL_PHYW_SHIFT 4
#define  USB2D_HWGENERAL_PHYW_MASK_SHIFT(reg) (((reg) & USB2D_HWGENERAL_PHYW_MASK) >> USB2D_HWGENERAL_PHYW_SHIFT)
#define  USB2D_HWGENERAL_PHYW_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HWGENERAL_PHYW_MASK) | (((uint32_t)val) << USB2D_HWGENERAL_PHYW_SHIFT))

#define  USB2D_HWGENERAL_BWT_MASK 0x8
#define  USB2D_HWGENERAL_BWT_SHIFT 3
#define  USB2D_HWGENERAL_BWT_MASK_SHIFT(reg) (((reg) & USB2D_HWGENERAL_BWT_MASK) >> USB2D_HWGENERAL_BWT_SHIFT)
#define  USB2D_HWGENERAL_BWT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HWGENERAL_BWT_MASK) | (((uint32_t)val) << USB2D_HWGENERAL_BWT_SHIFT))

#define  USB2D_HWGENERAL_CLKC_MASK 0x6
#define  USB2D_HWGENERAL_CLKC_SHIFT 1
#define  USB2D_HWGENERAL_CLKC_MASK_SHIFT(reg) (((reg) & USB2D_HWGENERAL_CLKC_MASK) >> USB2D_HWGENERAL_CLKC_SHIFT)
#define  USB2D_HWGENERAL_CLKC_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HWGENERAL_CLKC_MASK) | (((uint32_t)val) << USB2D_HWGENERAL_CLKC_SHIFT))

#define  USB2D_HWGENERAL_RT_MASK 0x1
#define  USB2D_HWGENERAL_RT_SHIFT 0
#define  USB2D_HWGENERAL_RT_MASK_SHIFT(reg) (((reg) & USB2D_HWGENERAL_RT_MASK) >> USB2D_HWGENERAL_RT_SHIFT)
#define  USB2D_HWGENERAL_RT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HWGENERAL_RT_MASK) | (((uint32_t)val) << USB2D_HWGENERAL_RT_SHIFT))

//====================================================================
//Register: Device Hardware Parameters Register (HWDEVICE)
//====================================================================

#define  USB2D_HWDEVICE_RESERVED1_MASK 0xffffffc0
#define  USB2D_HWDEVICE_RESERVED1_SHIFT 6
#define  USB2D_HWDEVICE_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_HWDEVICE_RESERVED1_MASK) >> USB2D_HWDEVICE_RESERVED1_SHIFT)
#define  USB2D_HWDEVICE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HWDEVICE_RESERVED1_MASK) | (((uint32_t)val) << USB2D_HWDEVICE_RESERVED1_SHIFT))

#define  USB2D_HWDEVICE_DEVEP_MASK 0x3e
#define  USB2D_HWDEVICE_DEVEP_SHIFT 1
#define  USB2D_HWDEVICE_DEVEP_MASK_SHIFT(reg) (((reg) & USB2D_HWDEVICE_DEVEP_MASK) >> USB2D_HWDEVICE_DEVEP_SHIFT)
#define  USB2D_HWDEVICE_DEVEP_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HWDEVICE_DEVEP_MASK) | (((uint32_t)val) << USB2D_HWDEVICE_DEVEP_SHIFT))

#define  USB2D_HWDEVICE_DC_MASK 0x1
#define  USB2D_HWDEVICE_DC_SHIFT 0
#define  USB2D_HWDEVICE_DC_MASK_SHIFT(reg) (((reg) & USB2D_HWDEVICE_DC_MASK) >> USB2D_HWDEVICE_DC_SHIFT)
#define  USB2D_HWDEVICE_DC_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HWDEVICE_DC_MASK) | (((uint32_t)val) << USB2D_HWDEVICE_DC_SHIFT))

//====================================================================
//Register: TX Buffer Parameters Register (HWTXBUF)
//====================================================================

#define  USB2D_HWTXBUF_TXLCR_MASK 0x80000000
#define  USB2D_HWTXBUF_TXLCR_SHIFT 31
#define  USB2D_HWTXBUF_TXLCR_MASK_SHIFT(reg) (((reg) & USB2D_HWTXBUF_TXLCR_MASK) >> USB2D_HWTXBUF_TXLCR_SHIFT)
#define  USB2D_HWTXBUF_TXLCR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HWTXBUF_TXLCR_MASK) | (((uint32_t)val) << USB2D_HWTXBUF_TXLCR_SHIFT))

#define  USB2D_HWTXBUF_RESERVED1_MASK 0x7f000000
#define  USB2D_HWTXBUF_RESERVED1_SHIFT 24
#define  USB2D_HWTXBUF_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_HWTXBUF_RESERVED1_MASK) >> USB2D_HWTXBUF_RESERVED1_SHIFT)
#define  USB2D_HWTXBUF_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HWTXBUF_RESERVED1_MASK) | (((uint32_t)val) << USB2D_HWTXBUF_RESERVED1_SHIFT))

#define  USB2D_HWTXBUF_TXCHANADD_MASK 0xff0000
#define  USB2D_HWTXBUF_TXCHANADD_SHIFT 16
#define  USB2D_HWTXBUF_TXCHANADD_MASK_SHIFT(reg) (((reg) & USB2D_HWTXBUF_TXCHANADD_MASK) >> USB2D_HWTXBUF_TXCHANADD_SHIFT)
#define  USB2D_HWTXBUF_TXCHANADD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HWTXBUF_TXCHANADD_MASK) | (((uint32_t)val) << USB2D_HWTXBUF_TXCHANADD_SHIFT))

#define  USB2D_HWTXBUF_TXADD_MASK 0xff00
#define  USB2D_HWTXBUF_TXADD_SHIFT 8
#define  USB2D_HWTXBUF_TXADD_MASK_SHIFT(reg) (((reg) & USB2D_HWTXBUF_TXADD_MASK) >> USB2D_HWTXBUF_TXADD_SHIFT)
#define  USB2D_HWTXBUF_TXADD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HWTXBUF_TXADD_MASK) | (((uint32_t)val) << USB2D_HWTXBUF_TXADD_SHIFT))

#define  USB2D_HWTXBUF_TXBURST_MASK 0xff
#define  USB2D_HWTXBUF_TXBURST_SHIFT 0
#define  USB2D_HWTXBUF_TXBURST_MASK_SHIFT(reg) (((reg) & USB2D_HWTXBUF_TXBURST_MASK) >> USB2D_HWTXBUF_TXBURST_SHIFT)
#define  USB2D_HWTXBUF_TXBURST_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HWTXBUF_TXBURST_MASK) | (((uint32_t)val) << USB2D_HWTXBUF_TXBURST_SHIFT))

//====================================================================
//Register: RX Buffer Parameters Register (HWRXBUF)
//====================================================================

#define  USB2D_HWRXBUF_RESERVED1_MASK 0xffff0000
#define  USB2D_HWRXBUF_RESERVED1_SHIFT 16
#define  USB2D_HWRXBUF_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_HWRXBUF_RESERVED1_MASK) >> USB2D_HWRXBUF_RESERVED1_SHIFT)
#define  USB2D_HWRXBUF_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HWRXBUF_RESERVED1_MASK) | (((uint32_t)val) << USB2D_HWRXBUF_RESERVED1_SHIFT))

#define  USB2D_HWRXBUF_RXADD_MASK 0xff00
#define  USB2D_HWRXBUF_RXADD_SHIFT 8
#define  USB2D_HWRXBUF_RXADD_MASK_SHIFT(reg) (((reg) & USB2D_HWRXBUF_RXADD_MASK) >> USB2D_HWRXBUF_RXADD_SHIFT)
#define  USB2D_HWRXBUF_RXADD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HWRXBUF_RXADD_MASK) | (((uint32_t)val) << USB2D_HWRXBUF_RXADD_SHIFT))

#define  USB2D_HWRXBUF_RXBURST_MASK 0xff
#define  USB2D_HWRXBUF_RXBURST_SHIFT 0
#define  USB2D_HWRXBUF_RXBURST_MASK_SHIFT(reg) (((reg) & USB2D_HWRXBUF_RXBURST_MASK) >> USB2D_HWRXBUF_RXBURST_SHIFT)
#define  USB2D_HWRXBUF_RXBURST_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HWRXBUF_RXBURST_MASK) | (((uint32_t)val) << USB2D_HWRXBUF_RXBURST_SHIFT))

//====================================================================
//Register: System Bus Control Register (SBUSCFG)
//====================================================================

#define  USB2D_SBUSCFG_RESERVED1_MASK 0xfffffff8
#define  USB2D_SBUSCFG_RESERVED1_SHIFT 3
#define  USB2D_SBUSCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_SBUSCFG_RESERVED1_MASK) >> USB2D_SBUSCFG_RESERVED1_SHIFT)
#define  USB2D_SBUSCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_SBUSCFG_RESERVED1_MASK) | (((uint32_t)val) << USB2D_SBUSCFG_RESERVED1_SHIFT))

#define  USB2D_SBUSCFG_AHBBRST_MASK 0x7
#define  USB2D_SBUSCFG_AHBBRST_SHIFT 0
#define  USB2D_SBUSCFG_AHBBRST_MASK_SHIFT(reg) (((reg) & USB2D_SBUSCFG_AHBBRST_MASK) >> USB2D_SBUSCFG_AHBBRST_SHIFT)
#define  USB2D_SBUSCFG_AHBBRST_REPLACE_VAL(reg,val) (((reg) & ~USB2D_SBUSCFG_AHBBRST_MASK) | (((uint32_t)val) << USB2D_SBUSCFG_AHBBRST_SHIFT))

//====================================================================
//Register: Timer 0 Duration Register (GPTIMER0LD)
//====================================================================

#define  USB2D_GPTIMER0LD_RESERVED1_MASK 0xff000000
#define  USB2D_GPTIMER0LD_RESERVED1_SHIFT 24
#define  USB2D_GPTIMER0LD_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_GPTIMER0LD_RESERVED1_MASK) >> USB2D_GPTIMER0LD_RESERVED1_SHIFT)
#define  USB2D_GPTIMER0LD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_GPTIMER0LD_RESERVED1_MASK) | (((uint32_t)val) << USB2D_GPTIMER0LD_RESERVED1_SHIFT))

#define  USB2D_GPTIMER0LD_GPTLD_MASK 0xffffff
#define  USB2D_GPTIMER0LD_GPTLD_SHIFT 0
#define  USB2D_GPTIMER0LD_GPTLD_MASK_SHIFT(reg) (((reg) & USB2D_GPTIMER0LD_GPTLD_MASK) >> USB2D_GPTIMER0LD_GPTLD_SHIFT)
#define  USB2D_GPTIMER0LD_GPTLD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_GPTIMER0LD_GPTLD_MASK) | (((uint32_t)val) << USB2D_GPTIMER0LD_GPTLD_SHIFT))

//====================================================================
//Register: Timer 0 Control Register (GPTIMER0CTRL)
//====================================================================

#define  USB2D_GPTIMER0CTRL_GPTRUN_MASK 0x80000000
#define  USB2D_GPTIMER0CTRL_GPTRUN_SHIFT 31
#define  USB2D_GPTIMER0CTRL_GPTRUN_MASK_SHIFT(reg) (((reg) & USB2D_GPTIMER0CTRL_GPTRUN_MASK) >> USB2D_GPTIMER0CTRL_GPTRUN_SHIFT)
#define  USB2D_GPTIMER0CTRL_GPTRUN_REPLACE_VAL(reg,val) (((reg) & ~USB2D_GPTIMER0CTRL_GPTRUN_MASK) | (((uint32_t)val) << USB2D_GPTIMER0CTRL_GPTRUN_SHIFT))

#define  USB2D_GPTIMER0CTRL_GPTRST_MASK 0x40000000
#define  USB2D_GPTIMER0CTRL_GPTRST_SHIFT 30
#define  USB2D_GPTIMER0CTRL_GPTRST_MASK_SHIFT(reg) (((reg) & USB2D_GPTIMER0CTRL_GPTRST_MASK) >> USB2D_GPTIMER0CTRL_GPTRST_SHIFT)
#define  USB2D_GPTIMER0CTRL_GPTRST_REPLACE_VAL(reg,val) (((reg) & ~USB2D_GPTIMER0CTRL_GPTRST_MASK) | (((uint32_t)val) << USB2D_GPTIMER0CTRL_GPTRST_SHIFT))

#define  USB2D_GPTIMER0CTRL_RESERVED1_MASK 0x3e000000
#define  USB2D_GPTIMER0CTRL_RESERVED1_SHIFT 25
#define  USB2D_GPTIMER0CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_GPTIMER0CTRL_RESERVED1_MASK) >> USB2D_GPTIMER0CTRL_RESERVED1_SHIFT)
#define  USB2D_GPTIMER0CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_GPTIMER0CTRL_RESERVED1_MASK) | (((uint32_t)val) << USB2D_GPTIMER0CTRL_RESERVED1_SHIFT))

#define  USB2D_GPTIMER0CTRL_GPTMODE_MASK 0x1000000
#define  USB2D_GPTIMER0CTRL_GPTMODE_SHIFT 24
#define  USB2D_GPTIMER0CTRL_GPTMODE_MASK_SHIFT(reg) (((reg) & USB2D_GPTIMER0CTRL_GPTMODE_MASK) >> USB2D_GPTIMER0CTRL_GPTMODE_SHIFT)
#define  USB2D_GPTIMER0CTRL_GPTMODE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_GPTIMER0CTRL_GPTMODE_MASK) | (((uint32_t)val) << USB2D_GPTIMER0CTRL_GPTMODE_SHIFT))

#define  USB2D_GPTIMER0CTRL_GPTCNT_MASK 0xffffff
#define  USB2D_GPTIMER0CTRL_GPTCNT_SHIFT 0
#define  USB2D_GPTIMER0CTRL_GPTCNT_MASK_SHIFT(reg) (((reg) & USB2D_GPTIMER0CTRL_GPTCNT_MASK) >> USB2D_GPTIMER0CTRL_GPTCNT_SHIFT)
#define  USB2D_GPTIMER0CTRL_GPTCNT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_GPTIMER0CTRL_GPTCNT_MASK) | (((uint32_t)val) << USB2D_GPTIMER0CTRL_GPTCNT_SHIFT))

//====================================================================
//Register: Timer 1 Duration Register (GPTIMER1LD)
//====================================================================

#define  USB2D_GPTIMER1LD_RESERVED1_MASK 0xff000000
#define  USB2D_GPTIMER1LD_RESERVED1_SHIFT 24
#define  USB2D_GPTIMER1LD_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_GPTIMER1LD_RESERVED1_MASK) >> USB2D_GPTIMER1LD_RESERVED1_SHIFT)
#define  USB2D_GPTIMER1LD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_GPTIMER1LD_RESERVED1_MASK) | (((uint32_t)val) << USB2D_GPTIMER1LD_RESERVED1_SHIFT))

#define  USB2D_GPTIMER1LD_GPTLD_MASK 0xffffff
#define  USB2D_GPTIMER1LD_GPTLD_SHIFT 0
#define  USB2D_GPTIMER1LD_GPTLD_MASK_SHIFT(reg) (((reg) & USB2D_GPTIMER1LD_GPTLD_MASK) >> USB2D_GPTIMER1LD_GPTLD_SHIFT)
#define  USB2D_GPTIMER1LD_GPTLD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_GPTIMER1LD_GPTLD_MASK) | (((uint32_t)val) << USB2D_GPTIMER1LD_GPTLD_SHIFT))

//====================================================================
//Register: Timer 1 Control Register (GPTIMER1CTRL)
//====================================================================

#define  USB2D_GPTIMER1CTRL_GPTRUN_MASK 0x80000000
#define  USB2D_GPTIMER1CTRL_GPTRUN_SHIFT 31
#define  USB2D_GPTIMER1CTRL_GPTRUN_MASK_SHIFT(reg) (((reg) & USB2D_GPTIMER1CTRL_GPTRUN_MASK) >> USB2D_GPTIMER1CTRL_GPTRUN_SHIFT)
#define  USB2D_GPTIMER1CTRL_GPTRUN_REPLACE_VAL(reg,val) (((reg) & ~USB2D_GPTIMER1CTRL_GPTRUN_MASK) | (((uint32_t)val) << USB2D_GPTIMER1CTRL_GPTRUN_SHIFT))

#define  USB2D_GPTIMER1CTRL_GPTRST_MASK 0x40000000
#define  USB2D_GPTIMER1CTRL_GPTRST_SHIFT 30
#define  USB2D_GPTIMER1CTRL_GPTRST_MASK_SHIFT(reg) (((reg) & USB2D_GPTIMER1CTRL_GPTRST_MASK) >> USB2D_GPTIMER1CTRL_GPTRST_SHIFT)
#define  USB2D_GPTIMER1CTRL_GPTRST_REPLACE_VAL(reg,val) (((reg) & ~USB2D_GPTIMER1CTRL_GPTRST_MASK) | (((uint32_t)val) << USB2D_GPTIMER1CTRL_GPTRST_SHIFT))

#define  USB2D_GPTIMER1CTRL_RESERVED1_MASK 0x3e000000
#define  USB2D_GPTIMER1CTRL_RESERVED1_SHIFT 25
#define  USB2D_GPTIMER1CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_GPTIMER1CTRL_RESERVED1_MASK) >> USB2D_GPTIMER1CTRL_RESERVED1_SHIFT)
#define  USB2D_GPTIMER1CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_GPTIMER1CTRL_RESERVED1_MASK) | (((uint32_t)val) << USB2D_GPTIMER1CTRL_RESERVED1_SHIFT))

#define  USB2D_GPTIMER1CTRL_GPTMODE_MASK 0x1000000
#define  USB2D_GPTIMER1CTRL_GPTMODE_SHIFT 24
#define  USB2D_GPTIMER1CTRL_GPTMODE_MASK_SHIFT(reg) (((reg) & USB2D_GPTIMER1CTRL_GPTMODE_MASK) >> USB2D_GPTIMER1CTRL_GPTMODE_SHIFT)
#define  USB2D_GPTIMER1CTRL_GPTMODE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_GPTIMER1CTRL_GPTMODE_MASK) | (((uint32_t)val) << USB2D_GPTIMER1CTRL_GPTMODE_SHIFT))

#define  USB2D_GPTIMER1CTRL_GPTCNT_MASK 0xffffff
#define  USB2D_GPTIMER1CTRL_GPTCNT_SHIFT 0
#define  USB2D_GPTIMER1CTRL_GPTCNT_MASK_SHIFT(reg) (((reg) & USB2D_GPTIMER1CTRL_GPTCNT_MASK) >> USB2D_GPTIMER1CTRL_GPTCNT_SHIFT)
#define  USB2D_GPTIMER1CTRL_GPTCNT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_GPTIMER1CTRL_GPTCNT_MASK) | (((uint32_t)val) << USB2D_GPTIMER1CTRL_GPTCNT_SHIFT))

//====================================================================
//Register: EHCI Version / Capability Length Register (HCIV_CAPLENGTH)
//====================================================================

#define  USB2D_HCIV_CAPLENGTH_HCIVERSION_MASK 0xffff0000
#define  USB2D_HCIV_CAPLENGTH_HCIVERSION_SHIFT 16
#define  USB2D_HCIV_CAPLENGTH_HCIVERSION_MASK_SHIFT(reg) (((reg) & USB2D_HCIV_CAPLENGTH_HCIVERSION_MASK) >> USB2D_HCIV_CAPLENGTH_HCIVERSION_SHIFT)
#define  USB2D_HCIV_CAPLENGTH_HCIVERSION_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HCIV_CAPLENGTH_HCIVERSION_MASK) | (((uint32_t)val) << USB2D_HCIV_CAPLENGTH_HCIVERSION_SHIFT))

#define  USB2D_HCIV_CAPLENGTH_RESERVED1_MASK 0xff00
#define  USB2D_HCIV_CAPLENGTH_RESERVED1_SHIFT 8
#define  USB2D_HCIV_CAPLENGTH_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_HCIV_CAPLENGTH_RESERVED1_MASK) >> USB2D_HCIV_CAPLENGTH_RESERVED1_SHIFT)
#define  USB2D_HCIV_CAPLENGTH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HCIV_CAPLENGTH_RESERVED1_MASK) | (((uint32_t)val) << USB2D_HCIV_CAPLENGTH_RESERVED1_SHIFT))

#define  USB2D_HCIV_CAPLENGTH_CAPLENGTH_MASK 0xff
#define  USB2D_HCIV_CAPLENGTH_CAPLENGTH_SHIFT 0
#define  USB2D_HCIV_CAPLENGTH_CAPLENGTH_MASK_SHIFT(reg) (((reg) & USB2D_HCIV_CAPLENGTH_CAPLENGTH_MASK) >> USB2D_HCIV_CAPLENGTH_CAPLENGTH_SHIFT)
#define  USB2D_HCIV_CAPLENGTH_CAPLENGTH_REPLACE_VAL(reg,val) (((reg) & ~USB2D_HCIV_CAPLENGTH_CAPLENGTH_MASK) | (((uint32_t)val) << USB2D_HCIV_CAPLENGTH_CAPLENGTH_SHIFT))

//====================================================================
//Register: Device Controller Version Register (DCIVERSION)
//====================================================================

#define  USB2D_DCIVERSION_RESERVED1_MASK 0xffff0000
#define  USB2D_DCIVERSION_RESERVED1_SHIFT 16
#define  USB2D_DCIVERSION_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_DCIVERSION_RESERVED1_MASK) >> USB2D_DCIVERSION_RESERVED1_SHIFT)
#define  USB2D_DCIVERSION_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_DCIVERSION_RESERVED1_MASK) | (((uint32_t)val) << USB2D_DCIVERSION_RESERVED1_SHIFT))

#define  USB2D_DCIVERSION_DCIVERSION_MASK 0xffff
#define  USB2D_DCIVERSION_DCIVERSION_SHIFT 0
#define  USB2D_DCIVERSION_DCIVERSION_MASK_SHIFT(reg) (((reg) & USB2D_DCIVERSION_DCIVERSION_MASK) >> USB2D_DCIVERSION_DCIVERSION_SHIFT)
#define  USB2D_DCIVERSION_DCIVERSION_REPLACE_VAL(reg,val) (((reg) & ~USB2D_DCIVERSION_DCIVERSION_MASK) | (((uint32_t)val) << USB2D_DCIVERSION_DCIVERSION_SHIFT))

//====================================================================
//Register: Device Capability Register (DCCPARAMS)
//====================================================================

#define  USB2D_DCCPARAMS_RESERVED1_MASK 0xfffffe00
#define  USB2D_DCCPARAMS_RESERVED1_SHIFT 9
#define  USB2D_DCCPARAMS_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_DCCPARAMS_RESERVED1_MASK) >> USB2D_DCCPARAMS_RESERVED1_SHIFT)
#define  USB2D_DCCPARAMS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_DCCPARAMS_RESERVED1_MASK) | (((uint32_t)val) << USB2D_DCCPARAMS_RESERVED1_SHIFT))

#define  USB2D_DCCPARAMS_HC_MASK 0x100
#define  USB2D_DCCPARAMS_HC_SHIFT 8
#define  USB2D_DCCPARAMS_HC_MASK_SHIFT(reg) (((reg) & USB2D_DCCPARAMS_HC_MASK) >> USB2D_DCCPARAMS_HC_SHIFT)
#define  USB2D_DCCPARAMS_HC_REPLACE_VAL(reg,val) (((reg) & ~USB2D_DCCPARAMS_HC_MASK) | (((uint32_t)val) << USB2D_DCCPARAMS_HC_SHIFT))

#define  USB2D_DCCPARAMS_DC_MASK 0x80
#define  USB2D_DCCPARAMS_DC_SHIFT 7
#define  USB2D_DCCPARAMS_DC_MASK_SHIFT(reg) (((reg) & USB2D_DCCPARAMS_DC_MASK) >> USB2D_DCCPARAMS_DC_SHIFT)
#define  USB2D_DCCPARAMS_DC_REPLACE_VAL(reg,val) (((reg) & ~USB2D_DCCPARAMS_DC_MASK) | (((uint32_t)val) << USB2D_DCCPARAMS_DC_SHIFT))

#define  USB2D_DCCPARAMS_RESERVED2_MASK 0x60
#define  USB2D_DCCPARAMS_RESERVED2_SHIFT 5
#define  USB2D_DCCPARAMS_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2D_DCCPARAMS_RESERVED2_MASK) >> USB2D_DCCPARAMS_RESERVED2_SHIFT)
#define  USB2D_DCCPARAMS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2D_DCCPARAMS_RESERVED2_MASK) | (((uint32_t)val) << USB2D_DCCPARAMS_RESERVED2_SHIFT))

#define  USB2D_DCCPARAMS_DEN_MASK 0x1f
#define  USB2D_DCCPARAMS_DEN_SHIFT 0
#define  USB2D_DCCPARAMS_DEN_MASK_SHIFT(reg) (((reg) & USB2D_DCCPARAMS_DEN_MASK) >> USB2D_DCCPARAMS_DEN_SHIFT)
#define  USB2D_DCCPARAMS_DEN_REPLACE_VAL(reg,val) (((reg) & ~USB2D_DCCPARAMS_DEN_MASK) | (((uint32_t)val) << USB2D_DCCPARAMS_DEN_SHIFT))

//====================================================================
//Register: USB Command Register (USBCMD)
//====================================================================

#define  USB2D_USBCMD_RESERVED1_MASK 0xff000000
#define  USB2D_USBCMD_RESERVED1_SHIFT 24
#define  USB2D_USBCMD_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_USBCMD_RESERVED1_MASK) >> USB2D_USBCMD_RESERVED1_SHIFT)
#define  USB2D_USBCMD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBCMD_RESERVED1_MASK) | (((uint32_t)val) << USB2D_USBCMD_RESERVED1_SHIFT))

#define  USB2D_USBCMD_ITC_MASK 0xff0000
#define  USB2D_USBCMD_ITC_SHIFT 16
#define  USB2D_USBCMD_ITC_MASK_SHIFT(reg) (((reg) & USB2D_USBCMD_ITC_MASK) >> USB2D_USBCMD_ITC_SHIFT)
#define  USB2D_USBCMD_ITC_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBCMD_ITC_MASK) | (((uint32_t)val) << USB2D_USBCMD_ITC_SHIFT))

#define  USB2D_USBCMD_FS2_MASK 0x8000
#define  USB2D_USBCMD_FS2_SHIFT 15
#define  USB2D_USBCMD_FS2_MASK_SHIFT(reg) (((reg) & USB2D_USBCMD_FS2_MASK) >> USB2D_USBCMD_FS2_SHIFT)
#define  USB2D_USBCMD_FS2_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBCMD_FS2_MASK) | (((uint32_t)val) << USB2D_USBCMD_FS2_SHIFT))

#define  USB2D_USBCMD_ATDTW_MASK 0x4000
#define  USB2D_USBCMD_ATDTW_SHIFT 14
#define  USB2D_USBCMD_ATDTW_MASK_SHIFT(reg) (((reg) & USB2D_USBCMD_ATDTW_MASK) >> USB2D_USBCMD_ATDTW_SHIFT)
#define  USB2D_USBCMD_ATDTW_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBCMD_ATDTW_MASK) | (((uint32_t)val) << USB2D_USBCMD_ATDTW_SHIFT))

#define  USB2D_USBCMD_SUTW_MASK 0x2000
#define  USB2D_USBCMD_SUTW_SHIFT 13
#define  USB2D_USBCMD_SUTW_MASK_SHIFT(reg) (((reg) & USB2D_USBCMD_SUTW_MASK) >> USB2D_USBCMD_SUTW_SHIFT)
#define  USB2D_USBCMD_SUTW_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBCMD_SUTW_MASK) | (((uint32_t)val) << USB2D_USBCMD_SUTW_SHIFT))

#define  USB2D_USBCMD_RESERVED2_MASK 0x1000
#define  USB2D_USBCMD_RESERVED2_SHIFT 12
#define  USB2D_USBCMD_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2D_USBCMD_RESERVED2_MASK) >> USB2D_USBCMD_RESERVED2_SHIFT)
#define  USB2D_USBCMD_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBCMD_RESERVED2_MASK) | (((uint32_t)val) << USB2D_USBCMD_RESERVED2_SHIFT))

#define  USB2D_USBCMD_RESERVED3_MASK 0xc00
#define  USB2D_USBCMD_RESERVED3_SHIFT 10
#define  USB2D_USBCMD_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2D_USBCMD_RESERVED3_MASK) >> USB2D_USBCMD_RESERVED3_SHIFT)
#define  USB2D_USBCMD_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBCMD_RESERVED3_MASK) | (((uint32_t)val) << USB2D_USBCMD_RESERVED3_SHIFT))

#define  USB2D_USBCMD_ASP_MASK 0x300
#define  USB2D_USBCMD_ASP_SHIFT 8
#define  USB2D_USBCMD_ASP_MASK_SHIFT(reg) (((reg) & USB2D_USBCMD_ASP_MASK) >> USB2D_USBCMD_ASP_SHIFT)
#define  USB2D_USBCMD_ASP_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBCMD_ASP_MASK) | (((uint32_t)val) << USB2D_USBCMD_ASP_SHIFT))

#define  USB2D_USBCMD_LR_MASK 0x80
#define  USB2D_USBCMD_LR_SHIFT 7
#define  USB2D_USBCMD_LR_MASK_SHIFT(reg) (((reg) & USB2D_USBCMD_LR_MASK) >> USB2D_USBCMD_LR_SHIFT)
#define  USB2D_USBCMD_LR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBCMD_LR_MASK) | (((uint32_t)val) << USB2D_USBCMD_LR_SHIFT))

#define  USB2D_USBCMD_IAA_MASK 0x40
#define  USB2D_USBCMD_IAA_SHIFT 6
#define  USB2D_USBCMD_IAA_MASK_SHIFT(reg) (((reg) & USB2D_USBCMD_IAA_MASK) >> USB2D_USBCMD_IAA_SHIFT)
#define  USB2D_USBCMD_IAA_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBCMD_IAA_MASK) | (((uint32_t)val) << USB2D_USBCMD_IAA_SHIFT))

#define  USB2D_USBCMD_ASE_MASK 0x20
#define  USB2D_USBCMD_ASE_SHIFT 5
#define  USB2D_USBCMD_ASE_MASK_SHIFT(reg) (((reg) & USB2D_USBCMD_ASE_MASK) >> USB2D_USBCMD_ASE_SHIFT)
#define  USB2D_USBCMD_ASE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBCMD_ASE_MASK) | (((uint32_t)val) << USB2D_USBCMD_ASE_SHIFT))

#define  USB2D_USBCMD_PSE_MASK 0x10
#define  USB2D_USBCMD_PSE_SHIFT 4
#define  USB2D_USBCMD_PSE_MASK_SHIFT(reg) (((reg) & USB2D_USBCMD_PSE_MASK) >> USB2D_USBCMD_PSE_SHIFT)
#define  USB2D_USBCMD_PSE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBCMD_PSE_MASK) | (((uint32_t)val) << USB2D_USBCMD_PSE_SHIFT))

#define  USB2D_USBCMD_FS1_MASK 0x8
#define  USB2D_USBCMD_FS1_SHIFT 3
#define  USB2D_USBCMD_FS1_MASK_SHIFT(reg) (((reg) & USB2D_USBCMD_FS1_MASK) >> USB2D_USBCMD_FS1_SHIFT)
#define  USB2D_USBCMD_FS1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBCMD_FS1_MASK) | (((uint32_t)val) << USB2D_USBCMD_FS1_SHIFT))

#define  USB2D_USBCMD_FS0_MASK 0x4
#define  USB2D_USBCMD_FS0_SHIFT 2
#define  USB2D_USBCMD_FS0_MASK_SHIFT(reg) (((reg) & USB2D_USBCMD_FS0_MASK) >> USB2D_USBCMD_FS0_SHIFT)
#define  USB2D_USBCMD_FS0_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBCMD_FS0_MASK) | (((uint32_t)val) << USB2D_USBCMD_FS0_SHIFT))

#define  USB2D_USBCMD_RST_MASK 0x2
#define  USB2D_USBCMD_RST_SHIFT 1
#define  USB2D_USBCMD_RST_MASK_SHIFT(reg) (((reg) & USB2D_USBCMD_RST_MASK) >> USB2D_USBCMD_RST_SHIFT)
#define  USB2D_USBCMD_RST_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBCMD_RST_MASK) | (((uint32_t)val) << USB2D_USBCMD_RST_SHIFT))

#define  USB2D_USBCMD_RS_MASK 0x1
#define  USB2D_USBCMD_RS_SHIFT 0
#define  USB2D_USBCMD_RS_MASK_SHIFT(reg) (((reg) & USB2D_USBCMD_RS_MASK) >> USB2D_USBCMD_RS_SHIFT)
#define  USB2D_USBCMD_RS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBCMD_RS_MASK) | (((uint32_t)val) << USB2D_USBCMD_RS_SHIFT))

//====================================================================
//Register: USB Status Register (USBSTS)
//====================================================================

#define  USB2D_USBSTS_RESERVED1_MASK 0xfc000000
#define  USB2D_USBSTS_RESERVED1_SHIFT 26
#define  USB2D_USBSTS_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_USBSTS_RESERVED1_MASK) >> USB2D_USBSTS_RESERVED1_SHIFT)
#define  USB2D_USBSTS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBSTS_RESERVED1_MASK) | (((uint32_t)val) << USB2D_USBSTS_RESERVED1_SHIFT))

#define  USB2D_USBSTS_TI1_MASK 0x2000000
#define  USB2D_USBSTS_TI1_SHIFT 25
#define  USB2D_USBSTS_TI1_MASK_SHIFT(reg) (((reg) & USB2D_USBSTS_TI1_MASK) >> USB2D_USBSTS_TI1_SHIFT)
#define  USB2D_USBSTS_TI1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBSTS_TI1_MASK) | (((uint32_t)val) << USB2D_USBSTS_TI1_SHIFT))

#define  USB2D_USBSTS_TI0_MASK 0x1000000
#define  USB2D_USBSTS_TI0_SHIFT 24
#define  USB2D_USBSTS_TI0_MASK_SHIFT(reg) (((reg) & USB2D_USBSTS_TI0_MASK) >> USB2D_USBSTS_TI0_SHIFT)
#define  USB2D_USBSTS_TI0_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBSTS_TI0_MASK) | (((uint32_t)val) << USB2D_USBSTS_TI0_SHIFT))

#define  USB2D_USBSTS_RESERVED2_MASK 0xfe0000
#define  USB2D_USBSTS_RESERVED2_SHIFT 17
#define  USB2D_USBSTS_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2D_USBSTS_RESERVED2_MASK) >> USB2D_USBSTS_RESERVED2_SHIFT)
#define  USB2D_USBSTS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBSTS_RESERVED2_MASK) | (((uint32_t)val) << USB2D_USBSTS_RESERVED2_SHIFT))

#define  USB2D_USBSTS_NAKI_MASK 0x10000
#define  USB2D_USBSTS_NAKI_SHIFT 16
#define  USB2D_USBSTS_NAKI_MASK_SHIFT(reg) (((reg) & USB2D_USBSTS_NAKI_MASK) >> USB2D_USBSTS_NAKI_SHIFT)
#define  USB2D_USBSTS_NAKI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBSTS_NAKI_MASK) | (((uint32_t)val) << USB2D_USBSTS_NAKI_SHIFT))

#define  USB2D_USBSTS_RESERVED3_MASK 0xfe00
#define  USB2D_USBSTS_RESERVED3_SHIFT 9
#define  USB2D_USBSTS_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2D_USBSTS_RESERVED3_MASK) >> USB2D_USBSTS_RESERVED3_SHIFT)
#define  USB2D_USBSTS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBSTS_RESERVED3_MASK) | (((uint32_t)val) << USB2D_USBSTS_RESERVED3_SHIFT))

#define  USB2D_USBSTS_SLI_MASK 0x100
#define  USB2D_USBSTS_SLI_SHIFT 8
#define  USB2D_USBSTS_SLI_MASK_SHIFT(reg) (((reg) & USB2D_USBSTS_SLI_MASK) >> USB2D_USBSTS_SLI_SHIFT)
#define  USB2D_USBSTS_SLI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBSTS_SLI_MASK) | (((uint32_t)val) << USB2D_USBSTS_SLI_SHIFT))

#define  USB2D_USBSTS_SRI_MASK 0x80
#define  USB2D_USBSTS_SRI_SHIFT 7
#define  USB2D_USBSTS_SRI_MASK_SHIFT(reg) (((reg) & USB2D_USBSTS_SRI_MASK) >> USB2D_USBSTS_SRI_SHIFT)
#define  USB2D_USBSTS_SRI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBSTS_SRI_MASK) | (((uint32_t)val) << USB2D_USBSTS_SRI_SHIFT))

#define  USB2D_USBSTS_URI_MASK 0x40
#define  USB2D_USBSTS_URI_SHIFT 6
#define  USB2D_USBSTS_URI_MASK_SHIFT(reg) (((reg) & USB2D_USBSTS_URI_MASK) >> USB2D_USBSTS_URI_SHIFT)
#define  USB2D_USBSTS_URI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBSTS_URI_MASK) | (((uint32_t)val) << USB2D_USBSTS_URI_SHIFT))

#define  USB2D_USBSTS_AAI_MASK 0x20
#define  USB2D_USBSTS_AAI_SHIFT 5
#define  USB2D_USBSTS_AAI_MASK_SHIFT(reg) (((reg) & USB2D_USBSTS_AAI_MASK) >> USB2D_USBSTS_AAI_SHIFT)
#define  USB2D_USBSTS_AAI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBSTS_AAI_MASK) | (((uint32_t)val) << USB2D_USBSTS_AAI_SHIFT))

#define  USB2D_USBSTS_SEI_MASK 0x10
#define  USB2D_USBSTS_SEI_SHIFT 4
#define  USB2D_USBSTS_SEI_MASK_SHIFT(reg) (((reg) & USB2D_USBSTS_SEI_MASK) >> USB2D_USBSTS_SEI_SHIFT)
#define  USB2D_USBSTS_SEI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBSTS_SEI_MASK) | (((uint32_t)val) << USB2D_USBSTS_SEI_SHIFT))

#define  USB2D_USBSTS_FRI_MASK 0x8
#define  USB2D_USBSTS_FRI_SHIFT 3
#define  USB2D_USBSTS_FRI_MASK_SHIFT(reg) (((reg) & USB2D_USBSTS_FRI_MASK) >> USB2D_USBSTS_FRI_SHIFT)
#define  USB2D_USBSTS_FRI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBSTS_FRI_MASK) | (((uint32_t)val) << USB2D_USBSTS_FRI_SHIFT))

#define  USB2D_USBSTS_PCI_MASK 0x4
#define  USB2D_USBSTS_PCI_SHIFT 2
#define  USB2D_USBSTS_PCI_MASK_SHIFT(reg) (((reg) & USB2D_USBSTS_PCI_MASK) >> USB2D_USBSTS_PCI_SHIFT)
#define  USB2D_USBSTS_PCI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBSTS_PCI_MASK) | (((uint32_t)val) << USB2D_USBSTS_PCI_SHIFT))

#define  USB2D_USBSTS_UEI_MASK 0x2
#define  USB2D_USBSTS_UEI_SHIFT 1
#define  USB2D_USBSTS_UEI_MASK_SHIFT(reg) (((reg) & USB2D_USBSTS_UEI_MASK) >> USB2D_USBSTS_UEI_SHIFT)
#define  USB2D_USBSTS_UEI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBSTS_UEI_MASK) | (((uint32_t)val) << USB2D_USBSTS_UEI_SHIFT))

#define  USB2D_USBSTS_UI_MASK 0x1
#define  USB2D_USBSTS_UI_SHIFT 0
#define  USB2D_USBSTS_UI_MASK_SHIFT(reg) (((reg) & USB2D_USBSTS_UI_MASK) >> USB2D_USBSTS_UI_SHIFT)
#define  USB2D_USBSTS_UI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBSTS_UI_MASK) | (((uint32_t)val) << USB2D_USBSTS_UI_SHIFT))

//====================================================================
//Register: USB Interrupt Register (USBINTR)
//====================================================================

#define  USB2D_USBINTR_RESERVED1_MASK 0xfc000000
#define  USB2D_USBINTR_RESERVED1_SHIFT 26
#define  USB2D_USBINTR_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_USBINTR_RESERVED1_MASK) >> USB2D_USBINTR_RESERVED1_SHIFT)
#define  USB2D_USBINTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBINTR_RESERVED1_MASK) | (((uint32_t)val) << USB2D_USBINTR_RESERVED1_SHIFT))

#define  USB2D_USBINTR_TIE1_MASK 0x2000000
#define  USB2D_USBINTR_TIE1_SHIFT 25
#define  USB2D_USBINTR_TIE1_MASK_SHIFT(reg) (((reg) & USB2D_USBINTR_TIE1_MASK) >> USB2D_USBINTR_TIE1_SHIFT)
#define  USB2D_USBINTR_TIE1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBINTR_TIE1_MASK) | (((uint32_t)val) << USB2D_USBINTR_TIE1_SHIFT))

#define  USB2D_USBINTR_TIE0_MASK 0x1000000
#define  USB2D_USBINTR_TIE0_SHIFT 24
#define  USB2D_USBINTR_TIE0_MASK_SHIFT(reg) (((reg) & USB2D_USBINTR_TIE0_MASK) >> USB2D_USBINTR_TIE0_SHIFT)
#define  USB2D_USBINTR_TIE0_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBINTR_TIE0_MASK) | (((uint32_t)val) << USB2D_USBINTR_TIE0_SHIFT))

#define  USB2D_USBINTR_RESERVED2_MASK 0xfe0000
#define  USB2D_USBINTR_RESERVED2_SHIFT 17
#define  USB2D_USBINTR_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2D_USBINTR_RESERVED2_MASK) >> USB2D_USBINTR_RESERVED2_SHIFT)
#define  USB2D_USBINTR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBINTR_RESERVED2_MASK) | (((uint32_t)val) << USB2D_USBINTR_RESERVED2_SHIFT))

#define  USB2D_USBINTR_NAKE_MASK 0x10000
#define  USB2D_USBINTR_NAKE_SHIFT 16
#define  USB2D_USBINTR_NAKE_MASK_SHIFT(reg) (((reg) & USB2D_USBINTR_NAKE_MASK) >> USB2D_USBINTR_NAKE_SHIFT)
#define  USB2D_USBINTR_NAKE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBINTR_NAKE_MASK) | (((uint32_t)val) << USB2D_USBINTR_NAKE_SHIFT))

#define  USB2D_USBINTR_RESERVED3_MASK 0xfe00
#define  USB2D_USBINTR_RESERVED3_SHIFT 9
#define  USB2D_USBINTR_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2D_USBINTR_RESERVED3_MASK) >> USB2D_USBINTR_RESERVED3_SHIFT)
#define  USB2D_USBINTR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBINTR_RESERVED3_MASK) | (((uint32_t)val) << USB2D_USBINTR_RESERVED3_SHIFT))

#define  USB2D_USBINTR_SLE_MASK 0x100
#define  USB2D_USBINTR_SLE_SHIFT 8
#define  USB2D_USBINTR_SLE_MASK_SHIFT(reg) (((reg) & USB2D_USBINTR_SLE_MASK) >> USB2D_USBINTR_SLE_SHIFT)
#define  USB2D_USBINTR_SLE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBINTR_SLE_MASK) | (((uint32_t)val) << USB2D_USBINTR_SLE_SHIFT))

#define  USB2D_USBINTR_SRE_MASK 0x80
#define  USB2D_USBINTR_SRE_SHIFT 7
#define  USB2D_USBINTR_SRE_MASK_SHIFT(reg) (((reg) & USB2D_USBINTR_SRE_MASK) >> USB2D_USBINTR_SRE_SHIFT)
#define  USB2D_USBINTR_SRE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBINTR_SRE_MASK) | (((uint32_t)val) << USB2D_USBINTR_SRE_SHIFT))

#define  USB2D_USBINTR_URE_MASK 0x40
#define  USB2D_USBINTR_URE_SHIFT 6
#define  USB2D_USBINTR_URE_MASK_SHIFT(reg) (((reg) & USB2D_USBINTR_URE_MASK) >> USB2D_USBINTR_URE_SHIFT)
#define  USB2D_USBINTR_URE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBINTR_URE_MASK) | (((uint32_t)val) << USB2D_USBINTR_URE_SHIFT))

#define  USB2D_USBINTR_RESERVED4_MASK 0x20
#define  USB2D_USBINTR_RESERVED4_SHIFT 5
#define  USB2D_USBINTR_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2D_USBINTR_RESERVED4_MASK) >> USB2D_USBINTR_RESERVED4_SHIFT)
#define  USB2D_USBINTR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBINTR_RESERVED4_MASK) | (((uint32_t)val) << USB2D_USBINTR_RESERVED4_SHIFT))

#define  USB2D_USBINTR_SEE_MASK 0x10
#define  USB2D_USBINTR_SEE_SHIFT 4
#define  USB2D_USBINTR_SEE_MASK_SHIFT(reg) (((reg) & USB2D_USBINTR_SEE_MASK) >> USB2D_USBINTR_SEE_SHIFT)
#define  USB2D_USBINTR_SEE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBINTR_SEE_MASK) | (((uint32_t)val) << USB2D_USBINTR_SEE_SHIFT))

#define  USB2D_USBINTR_RESERVED5_MASK 0x8
#define  USB2D_USBINTR_RESERVED5_SHIFT 3
#define  USB2D_USBINTR_RESERVED5_MASK_SHIFT(reg) (((reg) & USB2D_USBINTR_RESERVED5_MASK) >> USB2D_USBINTR_RESERVED5_SHIFT)
#define  USB2D_USBINTR_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBINTR_RESERVED5_MASK) | (((uint32_t)val) << USB2D_USBINTR_RESERVED5_SHIFT))

#define  USB2D_USBINTR_PCE_MASK 0x4
#define  USB2D_USBINTR_PCE_SHIFT 2
#define  USB2D_USBINTR_PCE_MASK_SHIFT(reg) (((reg) & USB2D_USBINTR_PCE_MASK) >> USB2D_USBINTR_PCE_SHIFT)
#define  USB2D_USBINTR_PCE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBINTR_PCE_MASK) | (((uint32_t)val) << USB2D_USBINTR_PCE_SHIFT))

#define  USB2D_USBINTR_UEE_MASK 0x2
#define  USB2D_USBINTR_UEE_SHIFT 1
#define  USB2D_USBINTR_UEE_MASK_SHIFT(reg) (((reg) & USB2D_USBINTR_UEE_MASK) >> USB2D_USBINTR_UEE_SHIFT)
#define  USB2D_USBINTR_UEE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBINTR_UEE_MASK) | (((uint32_t)val) << USB2D_USBINTR_UEE_SHIFT))

#define  USB2D_USBINTR_UE_MASK 0x1
#define  USB2D_USBINTR_UE_SHIFT 0
#define  USB2D_USBINTR_UE_MASK_SHIFT(reg) (((reg) & USB2D_USBINTR_UE_MASK) >> USB2D_USBINTR_UE_SHIFT)
#define  USB2D_USBINTR_UE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBINTR_UE_MASK) | (((uint32_t)val) << USB2D_USBINTR_UE_SHIFT))

//====================================================================
//Register: Frame Index Register (FRINDEX)
//====================================================================

#define  USB2D_FRINDEX_RESERVED1_MASK 0xffffc000
#define  USB2D_FRINDEX_RESERVED1_SHIFT 14
#define  USB2D_FRINDEX_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_FRINDEX_RESERVED1_MASK) >> USB2D_FRINDEX_RESERVED1_SHIFT)
#define  USB2D_FRINDEX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_FRINDEX_RESERVED1_MASK) | (((uint32_t)val) << USB2D_FRINDEX_RESERVED1_SHIFT))

#define  USB2D_FRINDEX_FRINDEX_MASK 0x3fff
#define  USB2D_FRINDEX_FRINDEX_SHIFT 0
#define  USB2D_FRINDEX_FRINDEX_MASK_SHIFT(reg) (((reg) & USB2D_FRINDEX_FRINDEX_MASK) >> USB2D_FRINDEX_FRINDEX_SHIFT)
#define  USB2D_FRINDEX_FRINDEX_REPLACE_VAL(reg,val) (((reg) & ~USB2D_FRINDEX_FRINDEX_MASK) | (((uint32_t)val) << USB2D_FRINDEX_FRINDEX_SHIFT))

//====================================================================
//Register: Device Address Register (DEVICEADDR)
//====================================================================

#define  USB2D_DEVICEADDR_USBADR_MASK 0xfe000000
#define  USB2D_DEVICEADDR_USBADR_SHIFT 25
#define  USB2D_DEVICEADDR_USBADR_MASK_SHIFT(reg) (((reg) & USB2D_DEVICEADDR_USBADR_MASK) >> USB2D_DEVICEADDR_USBADR_SHIFT)
#define  USB2D_DEVICEADDR_USBADR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_DEVICEADDR_USBADR_MASK) | (((uint32_t)val) << USB2D_DEVICEADDR_USBADR_SHIFT))

#define  USB2D_DEVICEADDR_USBADRA_MASK 0x1000000
#define  USB2D_DEVICEADDR_USBADRA_SHIFT 24
#define  USB2D_DEVICEADDR_USBADRA_MASK_SHIFT(reg) (((reg) & USB2D_DEVICEADDR_USBADRA_MASK) >> USB2D_DEVICEADDR_USBADRA_SHIFT)
#define  USB2D_DEVICEADDR_USBADRA_REPLACE_VAL(reg,val) (((reg) & ~USB2D_DEVICEADDR_USBADRA_MASK) | (((uint32_t)val) << USB2D_DEVICEADDR_USBADRA_SHIFT))

#define  USB2D_DEVICEADDR_RESERVED1_MASK 0xffffff
#define  USB2D_DEVICEADDR_RESERVED1_SHIFT 0
#define  USB2D_DEVICEADDR_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_DEVICEADDR_RESERVED1_MASK) >> USB2D_DEVICEADDR_RESERVED1_SHIFT)
#define  USB2D_DEVICEADDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_DEVICEADDR_RESERVED1_MASK) | (((uint32_t)val) << USB2D_DEVICEADDR_RESERVED1_SHIFT))

//====================================================================
//Register: Endpoint List Address Register (EPLISTADDR)
//====================================================================

#define  USB2D_EPLISTADDR_EPBASE_MASK 0xfffff800
#define  USB2D_EPLISTADDR_EPBASE_SHIFT 11
#define  USB2D_EPLISTADDR_EPBASE_MASK_SHIFT(reg) (((reg) & USB2D_EPLISTADDR_EPBASE_MASK) >> USB2D_EPLISTADDR_EPBASE_SHIFT)
#define  USB2D_EPLISTADDR_EPBASE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_EPLISTADDR_EPBASE_MASK) | (((uint32_t)val) << USB2D_EPLISTADDR_EPBASE_SHIFT))

#define  USB2D_EPLISTADDR_RESERVED1_MASK 0x7ff
#define  USB2D_EPLISTADDR_RESERVED1_SHIFT 0
#define  USB2D_EPLISTADDR_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_EPLISTADDR_RESERVED1_MASK) >> USB2D_EPLISTADDR_RESERVED1_SHIFT)
#define  USB2D_EPLISTADDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_EPLISTADDR_RESERVED1_MASK) | (((uint32_t)val) << USB2D_EPLISTADDR_RESERVED1_SHIFT))

//====================================================================
//Register: Burst Size Register (BURSTSIZE)
//====================================================================

#define  USB2D_BURSTSIZE_RESERVED1_MASK 0xffff0000
#define  USB2D_BURSTSIZE_RESERVED1_SHIFT 16
#define  USB2D_BURSTSIZE_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_BURSTSIZE_RESERVED1_MASK) >> USB2D_BURSTSIZE_RESERVED1_SHIFT)
#define  USB2D_BURSTSIZE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_BURSTSIZE_RESERVED1_MASK) | (((uint32_t)val) << USB2D_BURSTSIZE_RESERVED1_SHIFT))

#define  USB2D_BURSTSIZE_TXPBURST_MASK 0xff00
#define  USB2D_BURSTSIZE_TXPBURST_SHIFT 8
#define  USB2D_BURSTSIZE_TXPBURST_MASK_SHIFT(reg) (((reg) & USB2D_BURSTSIZE_TXPBURST_MASK) >> USB2D_BURSTSIZE_TXPBURST_SHIFT)
#define  USB2D_BURSTSIZE_TXPBURST_REPLACE_VAL(reg,val) (((reg) & ~USB2D_BURSTSIZE_TXPBURST_MASK) | (((uint32_t)val) << USB2D_BURSTSIZE_TXPBURST_SHIFT))

#define  USB2D_BURSTSIZE_RXPBURST_MASK 0xff
#define  USB2D_BURSTSIZE_RXPBURST_SHIFT 0
#define  USB2D_BURSTSIZE_RXPBURST_MASK_SHIFT(reg) (((reg) & USB2D_BURSTSIZE_RXPBURST_MASK) >> USB2D_BURSTSIZE_RXPBURST_SHIFT)
#define  USB2D_BURSTSIZE_RXPBURST_REPLACE_VAL(reg,val) (((reg) & ~USB2D_BURSTSIZE_RXPBURST_MASK) | (((uint32_t)val) << USB2D_BURSTSIZE_RXPBURST_SHIFT))

//====================================================================
//Register: Endpoint NAK Register (ENDPTNAK)
//====================================================================

#define  USB2D_ENDPTNAK_EPTN_MASK 0xffff0000
#define  USB2D_ENDPTNAK_EPTN_SHIFT 16
#define  USB2D_ENDPTNAK_EPTN_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTNAK_EPTN_MASK) >> USB2D_ENDPTNAK_EPTN_SHIFT)
#define  USB2D_ENDPTNAK_EPTN_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTNAK_EPTN_MASK) | (((uint32_t)val) << USB2D_ENDPTNAK_EPTN_SHIFT))

#define  USB2D_ENDPTNAK_EPRN_MASK 0xffff
#define  USB2D_ENDPTNAK_EPRN_SHIFT 0
#define  USB2D_ENDPTNAK_EPRN_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTNAK_EPRN_MASK) >> USB2D_ENDPTNAK_EPRN_SHIFT)
#define  USB2D_ENDPTNAK_EPRN_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTNAK_EPRN_MASK) | (((uint32_t)val) << USB2D_ENDPTNAK_EPRN_SHIFT))

//====================================================================
//Register: Endpoint NAK Enable Register (ENDPTNAKEN)
//====================================================================

#define  USB2D_ENDPTNAKEN_EPTNE_MASK 0xffff0000
#define  USB2D_ENDPTNAKEN_EPTNE_SHIFT 16
#define  USB2D_ENDPTNAKEN_EPTNE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTNAKEN_EPTNE_MASK) >> USB2D_ENDPTNAKEN_EPTNE_SHIFT)
#define  USB2D_ENDPTNAKEN_EPTNE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTNAKEN_EPTNE_MASK) | (((uint32_t)val) << USB2D_ENDPTNAKEN_EPTNE_SHIFT))

#define  USB2D_ENDPTNAKEN_EPRNE_MASK 0xffff
#define  USB2D_ENDPTNAKEN_EPRNE_SHIFT 0
#define  USB2D_ENDPTNAKEN_EPRNE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTNAKEN_EPRNE_MASK) >> USB2D_ENDPTNAKEN_EPRNE_SHIFT)
#define  USB2D_ENDPTNAKEN_EPRNE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTNAKEN_EPRNE_MASK) | (((uint32_t)val) << USB2D_ENDPTNAKEN_EPRNE_SHIFT))

//====================================================================
//Register: Port Status Control Register (PORTSC)
//====================================================================

#define  USB2D_PORTSC_PTS_MASK 0xc0000000
#define  USB2D_PORTSC_PTS_SHIFT 30
#define  USB2D_PORTSC_PTS_MASK_SHIFT(reg) (((reg) & USB2D_PORTSC_PTS_MASK) >> USB2D_PORTSC_PTS_SHIFT)
#define  USB2D_PORTSC_PTS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_PORTSC_PTS_MASK) | (((uint32_t)val) << USB2D_PORTSC_PTS_SHIFT))

#define  USB2D_PORTSC_STS_MASK 0x20000000
#define  USB2D_PORTSC_STS_SHIFT 29
#define  USB2D_PORTSC_STS_MASK_SHIFT(reg) (((reg) & USB2D_PORTSC_STS_MASK) >> USB2D_PORTSC_STS_SHIFT)
#define  USB2D_PORTSC_STS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_PORTSC_STS_MASK) | (((uint32_t)val) << USB2D_PORTSC_STS_SHIFT))

#define  USB2D_PORTSC_PTW_MASK 0x10000000
#define  USB2D_PORTSC_PTW_SHIFT 28
#define  USB2D_PORTSC_PTW_MASK_SHIFT(reg) (((reg) & USB2D_PORTSC_PTW_MASK) >> USB2D_PORTSC_PTW_SHIFT)
#define  USB2D_PORTSC_PTW_REPLACE_VAL(reg,val) (((reg) & ~USB2D_PORTSC_PTW_MASK) | (((uint32_t)val) << USB2D_PORTSC_PTW_SHIFT))

#define  USB2D_PORTSC_PSPD_MASK 0xc000000
#define  USB2D_PORTSC_PSPD_SHIFT 26
#define  USB2D_PORTSC_PSPD_MASK_SHIFT(reg) (((reg) & USB2D_PORTSC_PSPD_MASK) >> USB2D_PORTSC_PSPD_SHIFT)
#define  USB2D_PORTSC_PSPD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_PORTSC_PSPD_MASK) | (((uint32_t)val) << USB2D_PORTSC_PSPD_SHIFT))

#define  USB2D_PORTSC_RESERVED1_MASK 0x2000000
#define  USB2D_PORTSC_RESERVED1_SHIFT 25
#define  USB2D_PORTSC_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_PORTSC_RESERVED1_MASK) >> USB2D_PORTSC_RESERVED1_SHIFT)
#define  USB2D_PORTSC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_PORTSC_RESERVED1_MASK) | (((uint32_t)val) << USB2D_PORTSC_RESERVED1_SHIFT))

#define  USB2D_PORTSC_PFSC_MASK 0x1000000
#define  USB2D_PORTSC_PFSC_SHIFT 24
#define  USB2D_PORTSC_PFSC_MASK_SHIFT(reg) (((reg) & USB2D_PORTSC_PFSC_MASK) >> USB2D_PORTSC_PFSC_SHIFT)
#define  USB2D_PORTSC_PFSC_REPLACE_VAL(reg,val) (((reg) & ~USB2D_PORTSC_PFSC_MASK) | (((uint32_t)val) << USB2D_PORTSC_PFSC_SHIFT))

#define  USB2D_PORTSC_PHCD_MASK 0x800000
#define  USB2D_PORTSC_PHCD_SHIFT 23
#define  USB2D_PORTSC_PHCD_MASK_SHIFT(reg) (((reg) & USB2D_PORTSC_PHCD_MASK) >> USB2D_PORTSC_PHCD_SHIFT)
#define  USB2D_PORTSC_PHCD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_PORTSC_PHCD_MASK) | (((uint32_t)val) << USB2D_PORTSC_PHCD_SHIFT))

#define  USB2D_PORTSC_RESERVED2_MASK 0x700000
#define  USB2D_PORTSC_RESERVED2_SHIFT 20
#define  USB2D_PORTSC_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2D_PORTSC_RESERVED2_MASK) >> USB2D_PORTSC_RESERVED2_SHIFT)
#define  USB2D_PORTSC_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2D_PORTSC_RESERVED2_MASK) | (((uint32_t)val) << USB2D_PORTSC_RESERVED2_SHIFT))

#define  USB2D_PORTSC_PTC_MASK 0xf0000
#define  USB2D_PORTSC_PTC_SHIFT 16
#define  USB2D_PORTSC_PTC_MASK_SHIFT(reg) (((reg) & USB2D_PORTSC_PTC_MASK) >> USB2D_PORTSC_PTC_SHIFT)
#define  USB2D_PORTSC_PTC_REPLACE_VAL(reg,val) (((reg) & ~USB2D_PORTSC_PTC_MASK) | (((uint32_t)val) << USB2D_PORTSC_PTC_SHIFT))

#define  USB2D_PORTSC_RESERVED3_MASK 0xf000
#define  USB2D_PORTSC_RESERVED3_SHIFT 12
#define  USB2D_PORTSC_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2D_PORTSC_RESERVED3_MASK) >> USB2D_PORTSC_RESERVED3_SHIFT)
#define  USB2D_PORTSC_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2D_PORTSC_RESERVED3_MASK) | (((uint32_t)val) << USB2D_PORTSC_RESERVED3_SHIFT))

#define  USB2D_PORTSC_LS_MASK 0xc00
#define  USB2D_PORTSC_LS_SHIFT 10
#define  USB2D_PORTSC_LS_MASK_SHIFT(reg) (((reg) & USB2D_PORTSC_LS_MASK) >> USB2D_PORTSC_LS_SHIFT)
#define  USB2D_PORTSC_LS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_PORTSC_LS_MASK) | (((uint32_t)val) << USB2D_PORTSC_LS_SHIFT))

#define  USB2D_PORTSC_HSP_MASK 0x200
#define  USB2D_PORTSC_HSP_SHIFT 9
#define  USB2D_PORTSC_HSP_MASK_SHIFT(reg) (((reg) & USB2D_PORTSC_HSP_MASK) >> USB2D_PORTSC_HSP_SHIFT)
#define  USB2D_PORTSC_HSP_REPLACE_VAL(reg,val) (((reg) & ~USB2D_PORTSC_HSP_MASK) | (((uint32_t)val) << USB2D_PORTSC_HSP_SHIFT))

#define  USB2D_PORTSC_PR_MASK 0x100
#define  USB2D_PORTSC_PR_SHIFT 8
#define  USB2D_PORTSC_PR_MASK_SHIFT(reg) (((reg) & USB2D_PORTSC_PR_MASK) >> USB2D_PORTSC_PR_SHIFT)
#define  USB2D_PORTSC_PR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_PORTSC_PR_MASK) | (((uint32_t)val) << USB2D_PORTSC_PR_SHIFT))

#define  USB2D_PORTSC_SUSP_MASK 0x80
#define  USB2D_PORTSC_SUSP_SHIFT 7
#define  USB2D_PORTSC_SUSP_MASK_SHIFT(reg) (((reg) & USB2D_PORTSC_SUSP_MASK) >> USB2D_PORTSC_SUSP_SHIFT)
#define  USB2D_PORTSC_SUSP_REPLACE_VAL(reg,val) (((reg) & ~USB2D_PORTSC_SUSP_MASK) | (((uint32_t)val) << USB2D_PORTSC_SUSP_SHIFT))

#define  USB2D_PORTSC_FPR_MASK 0x40
#define  USB2D_PORTSC_FPR_SHIFT 6
#define  USB2D_PORTSC_FPR_MASK_SHIFT(reg) (((reg) & USB2D_PORTSC_FPR_MASK) >> USB2D_PORTSC_FPR_SHIFT)
#define  USB2D_PORTSC_FPR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_PORTSC_FPR_MASK) | (((uint32_t)val) << USB2D_PORTSC_FPR_SHIFT))

#define  USB2D_PORTSC_RESERVED4_MASK 0x3e
#define  USB2D_PORTSC_RESERVED4_SHIFT 1
#define  USB2D_PORTSC_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2D_PORTSC_RESERVED4_MASK) >> USB2D_PORTSC_RESERVED4_SHIFT)
#define  USB2D_PORTSC_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2D_PORTSC_RESERVED4_MASK) | (((uint32_t)val) << USB2D_PORTSC_RESERVED4_SHIFT))

#define  USB2D_PORTSC_CCS_MASK 0x1
#define  USB2D_PORTSC_CCS_SHIFT 0
#define  USB2D_PORTSC_CCS_MASK_SHIFT(reg) (((reg) & USB2D_PORTSC_CCS_MASK) >> USB2D_PORTSC_CCS_SHIFT)
#define  USB2D_PORTSC_CCS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_PORTSC_CCS_MASK) | (((uint32_t)val) << USB2D_PORTSC_CCS_SHIFT))

//====================================================================
//Register: USB Device Mode Register (USBMODE)
//====================================================================

#define  USB2D_USBMODE_RESERVED1_MASK 0xffffffc0
#define  USB2D_USBMODE_RESERVED1_SHIFT 6
#define  USB2D_USBMODE_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_USBMODE_RESERVED1_MASK) >> USB2D_USBMODE_RESERVED1_SHIFT)
#define  USB2D_USBMODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBMODE_RESERVED1_MASK) | (((uint32_t)val) << USB2D_USBMODE_RESERVED1_SHIFT))

#define  USB2D_USBMODE_VBPS_MASK 0x20
#define  USB2D_USBMODE_VBPS_SHIFT 5
#define  USB2D_USBMODE_VBPS_MASK_SHIFT(reg) (((reg) & USB2D_USBMODE_VBPS_MASK) >> USB2D_USBMODE_VBPS_SHIFT)
#define  USB2D_USBMODE_VBPS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBMODE_VBPS_MASK) | (((uint32_t)val) << USB2D_USBMODE_VBPS_SHIFT))

#define  USB2D_USBMODE_SDIS_MASK 0x10
#define  USB2D_USBMODE_SDIS_SHIFT 4
#define  USB2D_USBMODE_SDIS_MASK_SHIFT(reg) (((reg) & USB2D_USBMODE_SDIS_MASK) >> USB2D_USBMODE_SDIS_SHIFT)
#define  USB2D_USBMODE_SDIS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBMODE_SDIS_MASK) | (((uint32_t)val) << USB2D_USBMODE_SDIS_SHIFT))

#define  USB2D_USBMODE_SLOM_MASK 0x8
#define  USB2D_USBMODE_SLOM_SHIFT 3
#define  USB2D_USBMODE_SLOM_MASK_SHIFT(reg) (((reg) & USB2D_USBMODE_SLOM_MASK) >> USB2D_USBMODE_SLOM_SHIFT)
#define  USB2D_USBMODE_SLOM_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBMODE_SLOM_MASK) | (((uint32_t)val) << USB2D_USBMODE_SLOM_SHIFT))

#define  USB2D_USBMODE_ES_MASK 0x4
#define  USB2D_USBMODE_ES_SHIFT 2
#define  USB2D_USBMODE_ES_MASK_SHIFT(reg) (((reg) & USB2D_USBMODE_ES_MASK) >> USB2D_USBMODE_ES_SHIFT)
#define  USB2D_USBMODE_ES_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBMODE_ES_MASK) | (((uint32_t)val) << USB2D_USBMODE_ES_SHIFT))

#define  USB2D_USBMODE_CM_MASK 0x3
#define  USB2D_USBMODE_CM_SHIFT 0
#define  USB2D_USBMODE_CM_MASK_SHIFT(reg) (((reg) & USB2D_USBMODE_CM_MASK) >> USB2D_USBMODE_CM_SHIFT)
#define  USB2D_USBMODE_CM_REPLACE_VAL(reg,val) (((reg) & ~USB2D_USBMODE_CM_MASK) | (((uint32_t)val) << USB2D_USBMODE_CM_SHIFT))

//====================================================================
//Register: Endpoint Setup Status Register (ENDPTSETUPSTAT)
//====================================================================

#define  USB2D_ENDPTSETUPSTAT_RESERVED1_MASK 0xffff0000
#define  USB2D_ENDPTSETUPSTAT_RESERVED1_SHIFT 16
#define  USB2D_ENDPTSETUPSTAT_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTSETUPSTAT_RESERVED1_MASK) >> USB2D_ENDPTSETUPSTAT_RESERVED1_SHIFT)
#define  USB2D_ENDPTSETUPSTAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTSETUPSTAT_RESERVED1_MASK) | (((uint32_t)val) << USB2D_ENDPTSETUPSTAT_RESERVED1_SHIFT))

#define  USB2D_ENDPTSETUPSTAT_ENDPTSETUPSTAT_MASK 0xffff
#define  USB2D_ENDPTSETUPSTAT_ENDPTSETUPSTAT_SHIFT 0
#define  USB2D_ENDPTSETUPSTAT_ENDPTSETUPSTAT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTSETUPSTAT_ENDPTSETUPSTAT_MASK) >> USB2D_ENDPTSETUPSTAT_ENDPTSETUPSTAT_SHIFT)
#define  USB2D_ENDPTSETUPSTAT_ENDPTSETUPSTAT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTSETUPSTAT_ENDPTSETUPSTAT_MASK) | (((uint32_t)val) << USB2D_ENDPTSETUPSTAT_ENDPTSETUPSTAT_SHIFT))

//====================================================================
//Register: Endpoint Initialization Register (ENDPTPRIME)
//====================================================================

#define  USB2D_ENDPTPRIME_PETB_MASK 0xffff0000
#define  USB2D_ENDPTPRIME_PETB_SHIFT 16
#define  USB2D_ENDPTPRIME_PETB_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTPRIME_PETB_MASK) >> USB2D_ENDPTPRIME_PETB_SHIFT)
#define  USB2D_ENDPTPRIME_PETB_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTPRIME_PETB_MASK) | (((uint32_t)val) << USB2D_ENDPTPRIME_PETB_SHIFT))

#define  USB2D_ENDPTPRIME_PERB_MASK 0xffff
#define  USB2D_ENDPTPRIME_PERB_SHIFT 0
#define  USB2D_ENDPTPRIME_PERB_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTPRIME_PERB_MASK) >> USB2D_ENDPTPRIME_PERB_SHIFT)
#define  USB2D_ENDPTPRIME_PERB_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTPRIME_PERB_MASK) | (((uint32_t)val) << USB2D_ENDPTPRIME_PERB_SHIFT))

//====================================================================
//Register: Endpoint De-Initialize Register (ENDPTFLUSH)
//====================================================================

#define  USB2D_ENDPTFLUSH_FETB_MASK 0xffff0000
#define  USB2D_ENDPTFLUSH_FETB_SHIFT 16
#define  USB2D_ENDPTFLUSH_FETB_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTFLUSH_FETB_MASK) >> USB2D_ENDPTFLUSH_FETB_SHIFT)
#define  USB2D_ENDPTFLUSH_FETB_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTFLUSH_FETB_MASK) | (((uint32_t)val) << USB2D_ENDPTFLUSH_FETB_SHIFT))

#define  USB2D_ENDPTFLUSH_FERB_MASK 0xffff
#define  USB2D_ENDPTFLUSH_FERB_SHIFT 0
#define  USB2D_ENDPTFLUSH_FERB_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTFLUSH_FERB_MASK) >> USB2D_ENDPTFLUSH_FERB_SHIFT)
#define  USB2D_ENDPTFLUSH_FERB_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTFLUSH_FERB_MASK) | (((uint32_t)val) << USB2D_ENDPTFLUSH_FERB_SHIFT))

//====================================================================
//Register: Endpoint Status Register (ENDPTSTAT)
//====================================================================

#define  USB2D_ENDPTSTAT_ETBR_MASK 0xffff0000
#define  USB2D_ENDPTSTAT_ETBR_SHIFT 16
#define  USB2D_ENDPTSTAT_ETBR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTSTAT_ETBR_MASK) >> USB2D_ENDPTSTAT_ETBR_SHIFT)
#define  USB2D_ENDPTSTAT_ETBR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTSTAT_ETBR_MASK) | (((uint32_t)val) << USB2D_ENDPTSTAT_ETBR_SHIFT))

#define  USB2D_ENDPTSTAT_ERBR_MASK 0xffff
#define  USB2D_ENDPTSTAT_ERBR_SHIFT 0
#define  USB2D_ENDPTSTAT_ERBR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTSTAT_ERBR_MASK) >> USB2D_ENDPTSTAT_ERBR_SHIFT)
#define  USB2D_ENDPTSTAT_ERBR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTSTAT_ERBR_MASK) | (((uint32_t)val) << USB2D_ENDPTSTAT_ERBR_SHIFT))

//====================================================================
//Register: Endpoint Complete Register (ENDPTCOMPLETE)
//====================================================================

#define  USB2D_ENDPTCOMPLETE_ETCE_MASK 0xffff0000
#define  USB2D_ENDPTCOMPLETE_ETCE_SHIFT 16
#define  USB2D_ENDPTCOMPLETE_ETCE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCOMPLETE_ETCE_MASK) >> USB2D_ENDPTCOMPLETE_ETCE_SHIFT)
#define  USB2D_ENDPTCOMPLETE_ETCE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCOMPLETE_ETCE_MASK) | (((uint32_t)val) << USB2D_ENDPTCOMPLETE_ETCE_SHIFT))

#define  USB2D_ENDPTCOMPLETE_ERCE_MASK 0xffff
#define  USB2D_ENDPTCOMPLETE_ERCE_SHIFT 0
#define  USB2D_ENDPTCOMPLETE_ERCE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCOMPLETE_ERCE_MASK) >> USB2D_ENDPTCOMPLETE_ERCE_SHIFT)
#define  USB2D_ENDPTCOMPLETE_ERCE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCOMPLETE_ERCE_MASK) | (((uint32_t)val) << USB2D_ENDPTCOMPLETE_ERCE_SHIFT))

//====================================================================
//Register: Endpoint Control 0 Register (ENDPTCTRL_0)
//====================================================================

#define  USB2D_ENDPTCTRL_0_RESERVED1_MASK 0xff000000
#define  USB2D_ENDPTCTRL_0_RESERVED1_SHIFT 24
#define  USB2D_ENDPTCTRL_0_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL_0_RESERVED1_MASK) >> USB2D_ENDPTCTRL_0_RESERVED1_SHIFT)
#define  USB2D_ENDPTCTRL_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL_0_RESERVED1_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL_0_RESERVED1_SHIFT))

#define  USB2D_ENDPTCTRL_0_TXE_MASK 0x800000
#define  USB2D_ENDPTCTRL_0_TXE_SHIFT 23
#define  USB2D_ENDPTCTRL_0_TXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL_0_TXE_MASK) >> USB2D_ENDPTCTRL_0_TXE_SHIFT)
#define  USB2D_ENDPTCTRL_0_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL_0_TXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL_0_TXE_SHIFT))

#define  USB2D_ENDPTCTRL_0_RESERVED2_MASK 0x700000
#define  USB2D_ENDPTCTRL_0_RESERVED2_SHIFT 20
#define  USB2D_ENDPTCTRL_0_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL_0_RESERVED2_MASK) >> USB2D_ENDPTCTRL_0_RESERVED2_SHIFT)
#define  USB2D_ENDPTCTRL_0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL_0_RESERVED2_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL_0_RESERVED2_SHIFT))

#define  USB2D_ENDPTCTRL_0_TXT_MASK 0xc0000
#define  USB2D_ENDPTCTRL_0_TXT_SHIFT 18
#define  USB2D_ENDPTCTRL_0_TXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL_0_TXT_MASK) >> USB2D_ENDPTCTRL_0_TXT_SHIFT)
#define  USB2D_ENDPTCTRL_0_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL_0_TXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL_0_TXT_SHIFT))

#define  USB2D_ENDPTCTRL_0_RESERVED3_MASK 0x20000
#define  USB2D_ENDPTCTRL_0_RESERVED3_SHIFT 17
#define  USB2D_ENDPTCTRL_0_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL_0_RESERVED3_MASK) >> USB2D_ENDPTCTRL_0_RESERVED3_SHIFT)
#define  USB2D_ENDPTCTRL_0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL_0_RESERVED3_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL_0_RESERVED3_SHIFT))

#define  USB2D_ENDPTCTRL_0_TXS_MASK 0x10000
#define  USB2D_ENDPTCTRL_0_TXS_SHIFT 16
#define  USB2D_ENDPTCTRL_0_TXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL_0_TXS_MASK) >> USB2D_ENDPTCTRL_0_TXS_SHIFT)
#define  USB2D_ENDPTCTRL_0_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL_0_TXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL_0_TXS_SHIFT))

#define  USB2D_ENDPTCTRL_0_RESERVED4_MASK 0xff00
#define  USB2D_ENDPTCTRL_0_RESERVED4_SHIFT 8
#define  USB2D_ENDPTCTRL_0_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL_0_RESERVED4_MASK) >> USB2D_ENDPTCTRL_0_RESERVED4_SHIFT)
#define  USB2D_ENDPTCTRL_0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL_0_RESERVED4_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL_0_RESERVED4_SHIFT))

#define  USB2D_ENDPTCTRL_0_RXE_MASK 0x80
#define  USB2D_ENDPTCTRL_0_RXE_SHIFT 7
#define  USB2D_ENDPTCTRL_0_RXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL_0_RXE_MASK) >> USB2D_ENDPTCTRL_0_RXE_SHIFT)
#define  USB2D_ENDPTCTRL_0_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL_0_RXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL_0_RXE_SHIFT))

#define  USB2D_ENDPTCTRL_0_RESERVED5_MASK 0x70
#define  USB2D_ENDPTCTRL_0_RESERVED5_SHIFT 4
#define  USB2D_ENDPTCTRL_0_RESERVED5_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL_0_RESERVED5_MASK) >> USB2D_ENDPTCTRL_0_RESERVED5_SHIFT)
#define  USB2D_ENDPTCTRL_0_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL_0_RESERVED5_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL_0_RESERVED5_SHIFT))

#define  USB2D_ENDPTCTRL_0_RXT_MASK 0xc
#define  USB2D_ENDPTCTRL_0_RXT_SHIFT 2
#define  USB2D_ENDPTCTRL_0_RXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL_0_RXT_MASK) >> USB2D_ENDPTCTRL_0_RXT_SHIFT)
#define  USB2D_ENDPTCTRL_0_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL_0_RXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL_0_RXT_SHIFT))

#define  USB2D_ENDPTCTRL_0_RESERVED6_MASK 0x2
#define  USB2D_ENDPTCTRL_0_RESERVED6_SHIFT 1
#define  USB2D_ENDPTCTRL_0_RESERVED6_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL_0_RESERVED6_MASK) >> USB2D_ENDPTCTRL_0_RESERVED6_SHIFT)
#define  USB2D_ENDPTCTRL_0_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL_0_RESERVED6_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL_0_RESERVED6_SHIFT))

#define  USB2D_ENDPTCTRL_0_RXS_MASK 0x1
#define  USB2D_ENDPTCTRL_0_RXS_SHIFT 0
#define  USB2D_ENDPTCTRL_0_RXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL_0_RXS_MASK) >> USB2D_ENDPTCTRL_0_RXS_SHIFT)
#define  USB2D_ENDPTCTRL_0_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL_0_RXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL_0_RXS_SHIFT))

//====================================================================
//Register: Endpoint Control Register (Instance 1 of 9) (ENDPTCTRL1)
/** \brief  (Instance 1 of 9)*/
//====================================================================

#define  USB2D_ENDPTCTRL1_RESERVED1_MASK 0xff000000
#define  USB2D_ENDPTCTRL1_RESERVED1_SHIFT 24
#define  USB2D_ENDPTCTRL1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL1_RESERVED1_MASK) >> USB2D_ENDPTCTRL1_RESERVED1_SHIFT)
#define  USB2D_ENDPTCTRL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL1_RESERVED1_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL1_RESERVED1_SHIFT))

#define  USB2D_ENDPTCTRL1_TXE_MASK 0x800000
#define  USB2D_ENDPTCTRL1_TXE_SHIFT 23
#define  USB2D_ENDPTCTRL1_TXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL1_TXE_MASK) >> USB2D_ENDPTCTRL1_TXE_SHIFT)
#define  USB2D_ENDPTCTRL1_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL1_TXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL1_TXE_SHIFT))

#define  USB2D_ENDPTCTRL1_TXR_MASK 0x400000
#define  USB2D_ENDPTCTRL1_TXR_SHIFT 22
#define  USB2D_ENDPTCTRL1_TXR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL1_TXR_MASK) >> USB2D_ENDPTCTRL1_TXR_SHIFT)
#define  USB2D_ENDPTCTRL1_TXR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL1_TXR_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL1_TXR_SHIFT))

#define  USB2D_ENDPTCTRL1_TXI_MASK 0x200000
#define  USB2D_ENDPTCTRL1_TXI_SHIFT 21
#define  USB2D_ENDPTCTRL1_TXI_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL1_TXI_MASK) >> USB2D_ENDPTCTRL1_TXI_SHIFT)
#define  USB2D_ENDPTCTRL1_TXI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL1_TXI_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL1_TXI_SHIFT))

#define  USB2D_ENDPTCTRL1_RESERVED2_MASK 0x100000
#define  USB2D_ENDPTCTRL1_RESERVED2_SHIFT 20
#define  USB2D_ENDPTCTRL1_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL1_RESERVED2_MASK) >> USB2D_ENDPTCTRL1_RESERVED2_SHIFT)
#define  USB2D_ENDPTCTRL1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL1_RESERVED2_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL1_RESERVED2_SHIFT))

#define  USB2D_ENDPTCTRL1_TXT_MASK 0xc0000
#define  USB2D_ENDPTCTRL1_TXT_SHIFT 18
#define  USB2D_ENDPTCTRL1_TXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL1_TXT_MASK) >> USB2D_ENDPTCTRL1_TXT_SHIFT)
#define  USB2D_ENDPTCTRL1_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL1_TXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL1_TXT_SHIFT))

#define  USB2D_ENDPTCTRL1_TXD_MASK 0x20000
#define  USB2D_ENDPTCTRL1_TXD_SHIFT 17
#define  USB2D_ENDPTCTRL1_TXD_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL1_TXD_MASK) >> USB2D_ENDPTCTRL1_TXD_SHIFT)
#define  USB2D_ENDPTCTRL1_TXD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL1_TXD_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL1_TXD_SHIFT))

#define  USB2D_ENDPTCTRL1_TXS_MASK 0x10000
#define  USB2D_ENDPTCTRL1_TXS_SHIFT 16
#define  USB2D_ENDPTCTRL1_TXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL1_TXS_MASK) >> USB2D_ENDPTCTRL1_TXS_SHIFT)
#define  USB2D_ENDPTCTRL1_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL1_TXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL1_TXS_SHIFT))

#define  USB2D_ENDPTCTRL1_RESERVED3_MASK 0xff00
#define  USB2D_ENDPTCTRL1_RESERVED3_SHIFT 8
#define  USB2D_ENDPTCTRL1_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL1_RESERVED3_MASK) >> USB2D_ENDPTCTRL1_RESERVED3_SHIFT)
#define  USB2D_ENDPTCTRL1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL1_RESERVED3_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL1_RESERVED3_SHIFT))

#define  USB2D_ENDPTCTRL1_RXE_MASK 0x80
#define  USB2D_ENDPTCTRL1_RXE_SHIFT 7
#define  USB2D_ENDPTCTRL1_RXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL1_RXE_MASK) >> USB2D_ENDPTCTRL1_RXE_SHIFT)
#define  USB2D_ENDPTCTRL1_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL1_RXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL1_RXE_SHIFT))

#define  USB2D_ENDPTCTRL1_RXR_MASK 0x40
#define  USB2D_ENDPTCTRL1_RXR_SHIFT 6
#define  USB2D_ENDPTCTRL1_RXR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL1_RXR_MASK) >> USB2D_ENDPTCTRL1_RXR_SHIFT)
#define  USB2D_ENDPTCTRL1_RXR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL1_RXR_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL1_RXR_SHIFT))

#define  USB2D_ENDPTCTRL1_RXI_MASK 0x20
#define  USB2D_ENDPTCTRL1_RXI_SHIFT 5
#define  USB2D_ENDPTCTRL1_RXI_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL1_RXI_MASK) >> USB2D_ENDPTCTRL1_RXI_SHIFT)
#define  USB2D_ENDPTCTRL1_RXI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL1_RXI_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL1_RXI_SHIFT))

#define  USB2D_ENDPTCTRL1_RESERVED4_MASK 0x10
#define  USB2D_ENDPTCTRL1_RESERVED4_SHIFT 4
#define  USB2D_ENDPTCTRL1_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL1_RESERVED4_MASK) >> USB2D_ENDPTCTRL1_RESERVED4_SHIFT)
#define  USB2D_ENDPTCTRL1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL1_RESERVED4_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL1_RESERVED4_SHIFT))

#define  USB2D_ENDPTCTRL1_RXT_MASK 0xc
#define  USB2D_ENDPTCTRL1_RXT_SHIFT 2
#define  USB2D_ENDPTCTRL1_RXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL1_RXT_MASK) >> USB2D_ENDPTCTRL1_RXT_SHIFT)
#define  USB2D_ENDPTCTRL1_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL1_RXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL1_RXT_SHIFT))

#define  USB2D_ENDPTCTRL1_RXD_MASK 0x2
#define  USB2D_ENDPTCTRL1_RXD_SHIFT 1
#define  USB2D_ENDPTCTRL1_RXD_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL1_RXD_MASK) >> USB2D_ENDPTCTRL1_RXD_SHIFT)
#define  USB2D_ENDPTCTRL1_RXD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL1_RXD_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL1_RXD_SHIFT))

#define  USB2D_ENDPTCTRL1_RXS_MASK 0x1
#define  USB2D_ENDPTCTRL1_RXS_SHIFT 0
#define  USB2D_ENDPTCTRL1_RXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL1_RXS_MASK) >> USB2D_ENDPTCTRL1_RXS_SHIFT)
#define  USB2D_ENDPTCTRL1_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL1_RXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL1_RXS_SHIFT))

//====================================================================
//Register: Endpoint Control Register (Instance 2 of 9) (ENDPTCTRL2)
/** \brief  (Instance 2 of 9)*/
//====================================================================

#define  USB2D_ENDPTCTRL2_RESERVED1_MASK 0xff000000
#define  USB2D_ENDPTCTRL2_RESERVED1_SHIFT 24
#define  USB2D_ENDPTCTRL2_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL2_RESERVED1_MASK) >> USB2D_ENDPTCTRL2_RESERVED1_SHIFT)
#define  USB2D_ENDPTCTRL2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL2_RESERVED1_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL2_RESERVED1_SHIFT))

#define  USB2D_ENDPTCTRL2_TXE_MASK 0x800000
#define  USB2D_ENDPTCTRL2_TXE_SHIFT 23
#define  USB2D_ENDPTCTRL2_TXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL2_TXE_MASK) >> USB2D_ENDPTCTRL2_TXE_SHIFT)
#define  USB2D_ENDPTCTRL2_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL2_TXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL2_TXE_SHIFT))

#define  USB2D_ENDPTCTRL2_TXR_MASK 0x400000
#define  USB2D_ENDPTCTRL2_TXR_SHIFT 22
#define  USB2D_ENDPTCTRL2_TXR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL2_TXR_MASK) >> USB2D_ENDPTCTRL2_TXR_SHIFT)
#define  USB2D_ENDPTCTRL2_TXR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL2_TXR_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL2_TXR_SHIFT))

#define  USB2D_ENDPTCTRL2_TXI_MASK 0x200000
#define  USB2D_ENDPTCTRL2_TXI_SHIFT 21
#define  USB2D_ENDPTCTRL2_TXI_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL2_TXI_MASK) >> USB2D_ENDPTCTRL2_TXI_SHIFT)
#define  USB2D_ENDPTCTRL2_TXI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL2_TXI_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL2_TXI_SHIFT))

#define  USB2D_ENDPTCTRL2_RESERVED2_MASK 0x100000
#define  USB2D_ENDPTCTRL2_RESERVED2_SHIFT 20
#define  USB2D_ENDPTCTRL2_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL2_RESERVED2_MASK) >> USB2D_ENDPTCTRL2_RESERVED2_SHIFT)
#define  USB2D_ENDPTCTRL2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL2_RESERVED2_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL2_RESERVED2_SHIFT))

#define  USB2D_ENDPTCTRL2_TXT_MASK 0xc0000
#define  USB2D_ENDPTCTRL2_TXT_SHIFT 18
#define  USB2D_ENDPTCTRL2_TXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL2_TXT_MASK) >> USB2D_ENDPTCTRL2_TXT_SHIFT)
#define  USB2D_ENDPTCTRL2_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL2_TXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL2_TXT_SHIFT))

#define  USB2D_ENDPTCTRL2_TXD_MASK 0x20000
#define  USB2D_ENDPTCTRL2_TXD_SHIFT 17
#define  USB2D_ENDPTCTRL2_TXD_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL2_TXD_MASK) >> USB2D_ENDPTCTRL2_TXD_SHIFT)
#define  USB2D_ENDPTCTRL2_TXD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL2_TXD_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL2_TXD_SHIFT))

#define  USB2D_ENDPTCTRL2_TXS_MASK 0x10000
#define  USB2D_ENDPTCTRL2_TXS_SHIFT 16
#define  USB2D_ENDPTCTRL2_TXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL2_TXS_MASK) >> USB2D_ENDPTCTRL2_TXS_SHIFT)
#define  USB2D_ENDPTCTRL2_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL2_TXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL2_TXS_SHIFT))

#define  USB2D_ENDPTCTRL2_RESERVED3_MASK 0xff00
#define  USB2D_ENDPTCTRL2_RESERVED3_SHIFT 8
#define  USB2D_ENDPTCTRL2_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL2_RESERVED3_MASK) >> USB2D_ENDPTCTRL2_RESERVED3_SHIFT)
#define  USB2D_ENDPTCTRL2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL2_RESERVED3_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL2_RESERVED3_SHIFT))

#define  USB2D_ENDPTCTRL2_RXE_MASK 0x80
#define  USB2D_ENDPTCTRL2_RXE_SHIFT 7
#define  USB2D_ENDPTCTRL2_RXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL2_RXE_MASK) >> USB2D_ENDPTCTRL2_RXE_SHIFT)
#define  USB2D_ENDPTCTRL2_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL2_RXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL2_RXE_SHIFT))

#define  USB2D_ENDPTCTRL2_RXR_MASK 0x40
#define  USB2D_ENDPTCTRL2_RXR_SHIFT 6
#define  USB2D_ENDPTCTRL2_RXR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL2_RXR_MASK) >> USB2D_ENDPTCTRL2_RXR_SHIFT)
#define  USB2D_ENDPTCTRL2_RXR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL2_RXR_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL2_RXR_SHIFT))

#define  USB2D_ENDPTCTRL2_RXI_MASK 0x20
#define  USB2D_ENDPTCTRL2_RXI_SHIFT 5
#define  USB2D_ENDPTCTRL2_RXI_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL2_RXI_MASK) >> USB2D_ENDPTCTRL2_RXI_SHIFT)
#define  USB2D_ENDPTCTRL2_RXI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL2_RXI_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL2_RXI_SHIFT))

#define  USB2D_ENDPTCTRL2_RESERVED4_MASK 0x10
#define  USB2D_ENDPTCTRL2_RESERVED4_SHIFT 4
#define  USB2D_ENDPTCTRL2_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL2_RESERVED4_MASK) >> USB2D_ENDPTCTRL2_RESERVED4_SHIFT)
#define  USB2D_ENDPTCTRL2_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL2_RESERVED4_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL2_RESERVED4_SHIFT))

#define  USB2D_ENDPTCTRL2_RXT_MASK 0xc
#define  USB2D_ENDPTCTRL2_RXT_SHIFT 2
#define  USB2D_ENDPTCTRL2_RXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL2_RXT_MASK) >> USB2D_ENDPTCTRL2_RXT_SHIFT)
#define  USB2D_ENDPTCTRL2_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL2_RXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL2_RXT_SHIFT))

#define  USB2D_ENDPTCTRL2_RXD_MASK 0x2
#define  USB2D_ENDPTCTRL2_RXD_SHIFT 1
#define  USB2D_ENDPTCTRL2_RXD_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL2_RXD_MASK) >> USB2D_ENDPTCTRL2_RXD_SHIFT)
#define  USB2D_ENDPTCTRL2_RXD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL2_RXD_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL2_RXD_SHIFT))

#define  USB2D_ENDPTCTRL2_RXS_MASK 0x1
#define  USB2D_ENDPTCTRL2_RXS_SHIFT 0
#define  USB2D_ENDPTCTRL2_RXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL2_RXS_MASK) >> USB2D_ENDPTCTRL2_RXS_SHIFT)
#define  USB2D_ENDPTCTRL2_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL2_RXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL2_RXS_SHIFT))

//====================================================================
//Register: Endpoint Control Register (Instance 3 of 9) (ENDPTCTRL3)
/** \brief  (Instance 3 of 9)*/
//====================================================================

#define  USB2D_ENDPTCTRL3_RESERVED1_MASK 0xff000000
#define  USB2D_ENDPTCTRL3_RESERVED1_SHIFT 24
#define  USB2D_ENDPTCTRL3_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL3_RESERVED1_MASK) >> USB2D_ENDPTCTRL3_RESERVED1_SHIFT)
#define  USB2D_ENDPTCTRL3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL3_RESERVED1_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL3_RESERVED1_SHIFT))

#define  USB2D_ENDPTCTRL3_TXE_MASK 0x800000
#define  USB2D_ENDPTCTRL3_TXE_SHIFT 23
#define  USB2D_ENDPTCTRL3_TXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL3_TXE_MASK) >> USB2D_ENDPTCTRL3_TXE_SHIFT)
#define  USB2D_ENDPTCTRL3_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL3_TXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL3_TXE_SHIFT))

#define  USB2D_ENDPTCTRL3_TXR_MASK 0x400000
#define  USB2D_ENDPTCTRL3_TXR_SHIFT 22
#define  USB2D_ENDPTCTRL3_TXR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL3_TXR_MASK) >> USB2D_ENDPTCTRL3_TXR_SHIFT)
#define  USB2D_ENDPTCTRL3_TXR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL3_TXR_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL3_TXR_SHIFT))

#define  USB2D_ENDPTCTRL3_TXI_MASK 0x200000
#define  USB2D_ENDPTCTRL3_TXI_SHIFT 21
#define  USB2D_ENDPTCTRL3_TXI_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL3_TXI_MASK) >> USB2D_ENDPTCTRL3_TXI_SHIFT)
#define  USB2D_ENDPTCTRL3_TXI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL3_TXI_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL3_TXI_SHIFT))

#define  USB2D_ENDPTCTRL3_RESERVED2_MASK 0x100000
#define  USB2D_ENDPTCTRL3_RESERVED2_SHIFT 20
#define  USB2D_ENDPTCTRL3_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL3_RESERVED2_MASK) >> USB2D_ENDPTCTRL3_RESERVED2_SHIFT)
#define  USB2D_ENDPTCTRL3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL3_RESERVED2_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL3_RESERVED2_SHIFT))

#define  USB2D_ENDPTCTRL3_TXT_MASK 0xc0000
#define  USB2D_ENDPTCTRL3_TXT_SHIFT 18
#define  USB2D_ENDPTCTRL3_TXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL3_TXT_MASK) >> USB2D_ENDPTCTRL3_TXT_SHIFT)
#define  USB2D_ENDPTCTRL3_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL3_TXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL3_TXT_SHIFT))

#define  USB2D_ENDPTCTRL3_TXD_MASK 0x20000
#define  USB2D_ENDPTCTRL3_TXD_SHIFT 17
#define  USB2D_ENDPTCTRL3_TXD_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL3_TXD_MASK) >> USB2D_ENDPTCTRL3_TXD_SHIFT)
#define  USB2D_ENDPTCTRL3_TXD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL3_TXD_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL3_TXD_SHIFT))

#define  USB2D_ENDPTCTRL3_TXS_MASK 0x10000
#define  USB2D_ENDPTCTRL3_TXS_SHIFT 16
#define  USB2D_ENDPTCTRL3_TXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL3_TXS_MASK) >> USB2D_ENDPTCTRL3_TXS_SHIFT)
#define  USB2D_ENDPTCTRL3_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL3_TXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL3_TXS_SHIFT))

#define  USB2D_ENDPTCTRL3_RESERVED3_MASK 0xff00
#define  USB2D_ENDPTCTRL3_RESERVED3_SHIFT 8
#define  USB2D_ENDPTCTRL3_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL3_RESERVED3_MASK) >> USB2D_ENDPTCTRL3_RESERVED3_SHIFT)
#define  USB2D_ENDPTCTRL3_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL3_RESERVED3_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL3_RESERVED3_SHIFT))

#define  USB2D_ENDPTCTRL3_RXE_MASK 0x80
#define  USB2D_ENDPTCTRL3_RXE_SHIFT 7
#define  USB2D_ENDPTCTRL3_RXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL3_RXE_MASK) >> USB2D_ENDPTCTRL3_RXE_SHIFT)
#define  USB2D_ENDPTCTRL3_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL3_RXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL3_RXE_SHIFT))

#define  USB2D_ENDPTCTRL3_RXR_MASK 0x40
#define  USB2D_ENDPTCTRL3_RXR_SHIFT 6
#define  USB2D_ENDPTCTRL3_RXR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL3_RXR_MASK) >> USB2D_ENDPTCTRL3_RXR_SHIFT)
#define  USB2D_ENDPTCTRL3_RXR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL3_RXR_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL3_RXR_SHIFT))

#define  USB2D_ENDPTCTRL3_RXI_MASK 0x20
#define  USB2D_ENDPTCTRL3_RXI_SHIFT 5
#define  USB2D_ENDPTCTRL3_RXI_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL3_RXI_MASK) >> USB2D_ENDPTCTRL3_RXI_SHIFT)
#define  USB2D_ENDPTCTRL3_RXI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL3_RXI_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL3_RXI_SHIFT))

#define  USB2D_ENDPTCTRL3_RESERVED4_MASK 0x10
#define  USB2D_ENDPTCTRL3_RESERVED4_SHIFT 4
#define  USB2D_ENDPTCTRL3_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL3_RESERVED4_MASK) >> USB2D_ENDPTCTRL3_RESERVED4_SHIFT)
#define  USB2D_ENDPTCTRL3_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL3_RESERVED4_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL3_RESERVED4_SHIFT))

#define  USB2D_ENDPTCTRL3_RXT_MASK 0xc
#define  USB2D_ENDPTCTRL3_RXT_SHIFT 2
#define  USB2D_ENDPTCTRL3_RXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL3_RXT_MASK) >> USB2D_ENDPTCTRL3_RXT_SHIFT)
#define  USB2D_ENDPTCTRL3_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL3_RXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL3_RXT_SHIFT))

#define  USB2D_ENDPTCTRL3_RXD_MASK 0x2
#define  USB2D_ENDPTCTRL3_RXD_SHIFT 1
#define  USB2D_ENDPTCTRL3_RXD_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL3_RXD_MASK) >> USB2D_ENDPTCTRL3_RXD_SHIFT)
#define  USB2D_ENDPTCTRL3_RXD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL3_RXD_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL3_RXD_SHIFT))

#define  USB2D_ENDPTCTRL3_RXS_MASK 0x1
#define  USB2D_ENDPTCTRL3_RXS_SHIFT 0
#define  USB2D_ENDPTCTRL3_RXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL3_RXS_MASK) >> USB2D_ENDPTCTRL3_RXS_SHIFT)
#define  USB2D_ENDPTCTRL3_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL3_RXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL3_RXS_SHIFT))

//====================================================================
//Register: Endpoint Control Register (Instance 4 of 9) (ENDPTCTRL4)
/** \brief  (Instance 4 of 9)*/
//====================================================================

#define  USB2D_ENDPTCTRL4_RESERVED1_MASK 0xff000000
#define  USB2D_ENDPTCTRL4_RESERVED1_SHIFT 24
#define  USB2D_ENDPTCTRL4_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL4_RESERVED1_MASK) >> USB2D_ENDPTCTRL4_RESERVED1_SHIFT)
#define  USB2D_ENDPTCTRL4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL4_RESERVED1_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL4_RESERVED1_SHIFT))

#define  USB2D_ENDPTCTRL4_TXE_MASK 0x800000
#define  USB2D_ENDPTCTRL4_TXE_SHIFT 23
#define  USB2D_ENDPTCTRL4_TXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL4_TXE_MASK) >> USB2D_ENDPTCTRL4_TXE_SHIFT)
#define  USB2D_ENDPTCTRL4_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL4_TXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL4_TXE_SHIFT))

#define  USB2D_ENDPTCTRL4_TXR_MASK 0x400000
#define  USB2D_ENDPTCTRL4_TXR_SHIFT 22
#define  USB2D_ENDPTCTRL4_TXR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL4_TXR_MASK) >> USB2D_ENDPTCTRL4_TXR_SHIFT)
#define  USB2D_ENDPTCTRL4_TXR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL4_TXR_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL4_TXR_SHIFT))

#define  USB2D_ENDPTCTRL4_TXI_MASK 0x200000
#define  USB2D_ENDPTCTRL4_TXI_SHIFT 21
#define  USB2D_ENDPTCTRL4_TXI_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL4_TXI_MASK) >> USB2D_ENDPTCTRL4_TXI_SHIFT)
#define  USB2D_ENDPTCTRL4_TXI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL4_TXI_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL4_TXI_SHIFT))

#define  USB2D_ENDPTCTRL4_RESERVED2_MASK 0x100000
#define  USB2D_ENDPTCTRL4_RESERVED2_SHIFT 20
#define  USB2D_ENDPTCTRL4_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL4_RESERVED2_MASK) >> USB2D_ENDPTCTRL4_RESERVED2_SHIFT)
#define  USB2D_ENDPTCTRL4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL4_RESERVED2_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL4_RESERVED2_SHIFT))

#define  USB2D_ENDPTCTRL4_TXT_MASK 0xc0000
#define  USB2D_ENDPTCTRL4_TXT_SHIFT 18
#define  USB2D_ENDPTCTRL4_TXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL4_TXT_MASK) >> USB2D_ENDPTCTRL4_TXT_SHIFT)
#define  USB2D_ENDPTCTRL4_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL4_TXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL4_TXT_SHIFT))

#define  USB2D_ENDPTCTRL4_TXD_MASK 0x20000
#define  USB2D_ENDPTCTRL4_TXD_SHIFT 17
#define  USB2D_ENDPTCTRL4_TXD_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL4_TXD_MASK) >> USB2D_ENDPTCTRL4_TXD_SHIFT)
#define  USB2D_ENDPTCTRL4_TXD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL4_TXD_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL4_TXD_SHIFT))

#define  USB2D_ENDPTCTRL4_TXS_MASK 0x10000
#define  USB2D_ENDPTCTRL4_TXS_SHIFT 16
#define  USB2D_ENDPTCTRL4_TXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL4_TXS_MASK) >> USB2D_ENDPTCTRL4_TXS_SHIFT)
#define  USB2D_ENDPTCTRL4_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL4_TXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL4_TXS_SHIFT))

#define  USB2D_ENDPTCTRL4_RESERVED3_MASK 0xff00
#define  USB2D_ENDPTCTRL4_RESERVED3_SHIFT 8
#define  USB2D_ENDPTCTRL4_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL4_RESERVED3_MASK) >> USB2D_ENDPTCTRL4_RESERVED3_SHIFT)
#define  USB2D_ENDPTCTRL4_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL4_RESERVED3_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL4_RESERVED3_SHIFT))

#define  USB2D_ENDPTCTRL4_RXE_MASK 0x80
#define  USB2D_ENDPTCTRL4_RXE_SHIFT 7
#define  USB2D_ENDPTCTRL4_RXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL4_RXE_MASK) >> USB2D_ENDPTCTRL4_RXE_SHIFT)
#define  USB2D_ENDPTCTRL4_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL4_RXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL4_RXE_SHIFT))

#define  USB2D_ENDPTCTRL4_RXR_MASK 0x40
#define  USB2D_ENDPTCTRL4_RXR_SHIFT 6
#define  USB2D_ENDPTCTRL4_RXR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL4_RXR_MASK) >> USB2D_ENDPTCTRL4_RXR_SHIFT)
#define  USB2D_ENDPTCTRL4_RXR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL4_RXR_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL4_RXR_SHIFT))

#define  USB2D_ENDPTCTRL4_RXI_MASK 0x20
#define  USB2D_ENDPTCTRL4_RXI_SHIFT 5
#define  USB2D_ENDPTCTRL4_RXI_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL4_RXI_MASK) >> USB2D_ENDPTCTRL4_RXI_SHIFT)
#define  USB2D_ENDPTCTRL4_RXI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL4_RXI_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL4_RXI_SHIFT))

#define  USB2D_ENDPTCTRL4_RESERVED4_MASK 0x10
#define  USB2D_ENDPTCTRL4_RESERVED4_SHIFT 4
#define  USB2D_ENDPTCTRL4_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL4_RESERVED4_MASK) >> USB2D_ENDPTCTRL4_RESERVED4_SHIFT)
#define  USB2D_ENDPTCTRL4_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL4_RESERVED4_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL4_RESERVED4_SHIFT))

#define  USB2D_ENDPTCTRL4_RXT_MASK 0xc
#define  USB2D_ENDPTCTRL4_RXT_SHIFT 2
#define  USB2D_ENDPTCTRL4_RXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL4_RXT_MASK) >> USB2D_ENDPTCTRL4_RXT_SHIFT)
#define  USB2D_ENDPTCTRL4_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL4_RXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL4_RXT_SHIFT))

#define  USB2D_ENDPTCTRL4_RXD_MASK 0x2
#define  USB2D_ENDPTCTRL4_RXD_SHIFT 1
#define  USB2D_ENDPTCTRL4_RXD_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL4_RXD_MASK) >> USB2D_ENDPTCTRL4_RXD_SHIFT)
#define  USB2D_ENDPTCTRL4_RXD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL4_RXD_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL4_RXD_SHIFT))

#define  USB2D_ENDPTCTRL4_RXS_MASK 0x1
#define  USB2D_ENDPTCTRL4_RXS_SHIFT 0
#define  USB2D_ENDPTCTRL4_RXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL4_RXS_MASK) >> USB2D_ENDPTCTRL4_RXS_SHIFT)
#define  USB2D_ENDPTCTRL4_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL4_RXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL4_RXS_SHIFT))

//====================================================================
//Register: Endpoint Control Register (Instance 5 of 9) (ENDPTCTRL5)
/** \brief  (Instance 5 of 9)*/
//====================================================================

#define  USB2D_ENDPTCTRL5_RESERVED1_MASK 0xff000000
#define  USB2D_ENDPTCTRL5_RESERVED1_SHIFT 24
#define  USB2D_ENDPTCTRL5_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL5_RESERVED1_MASK) >> USB2D_ENDPTCTRL5_RESERVED1_SHIFT)
#define  USB2D_ENDPTCTRL5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL5_RESERVED1_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL5_RESERVED1_SHIFT))

#define  USB2D_ENDPTCTRL5_TXE_MASK 0x800000
#define  USB2D_ENDPTCTRL5_TXE_SHIFT 23
#define  USB2D_ENDPTCTRL5_TXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL5_TXE_MASK) >> USB2D_ENDPTCTRL5_TXE_SHIFT)
#define  USB2D_ENDPTCTRL5_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL5_TXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL5_TXE_SHIFT))

#define  USB2D_ENDPTCTRL5_TXR_MASK 0x400000
#define  USB2D_ENDPTCTRL5_TXR_SHIFT 22
#define  USB2D_ENDPTCTRL5_TXR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL5_TXR_MASK) >> USB2D_ENDPTCTRL5_TXR_SHIFT)
#define  USB2D_ENDPTCTRL5_TXR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL5_TXR_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL5_TXR_SHIFT))

#define  USB2D_ENDPTCTRL5_TXI_MASK 0x200000
#define  USB2D_ENDPTCTRL5_TXI_SHIFT 21
#define  USB2D_ENDPTCTRL5_TXI_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL5_TXI_MASK) >> USB2D_ENDPTCTRL5_TXI_SHIFT)
#define  USB2D_ENDPTCTRL5_TXI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL5_TXI_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL5_TXI_SHIFT))

#define  USB2D_ENDPTCTRL5_RESERVED2_MASK 0x100000
#define  USB2D_ENDPTCTRL5_RESERVED2_SHIFT 20
#define  USB2D_ENDPTCTRL5_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL5_RESERVED2_MASK) >> USB2D_ENDPTCTRL5_RESERVED2_SHIFT)
#define  USB2D_ENDPTCTRL5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL5_RESERVED2_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL5_RESERVED2_SHIFT))

#define  USB2D_ENDPTCTRL5_TXT_MASK 0xc0000
#define  USB2D_ENDPTCTRL5_TXT_SHIFT 18
#define  USB2D_ENDPTCTRL5_TXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL5_TXT_MASK) >> USB2D_ENDPTCTRL5_TXT_SHIFT)
#define  USB2D_ENDPTCTRL5_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL5_TXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL5_TXT_SHIFT))

#define  USB2D_ENDPTCTRL5_TXD_MASK 0x20000
#define  USB2D_ENDPTCTRL5_TXD_SHIFT 17
#define  USB2D_ENDPTCTRL5_TXD_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL5_TXD_MASK) >> USB2D_ENDPTCTRL5_TXD_SHIFT)
#define  USB2D_ENDPTCTRL5_TXD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL5_TXD_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL5_TXD_SHIFT))

#define  USB2D_ENDPTCTRL5_TXS_MASK 0x10000
#define  USB2D_ENDPTCTRL5_TXS_SHIFT 16
#define  USB2D_ENDPTCTRL5_TXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL5_TXS_MASK) >> USB2D_ENDPTCTRL5_TXS_SHIFT)
#define  USB2D_ENDPTCTRL5_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL5_TXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL5_TXS_SHIFT))

#define  USB2D_ENDPTCTRL5_RESERVED3_MASK 0xff00
#define  USB2D_ENDPTCTRL5_RESERVED3_SHIFT 8
#define  USB2D_ENDPTCTRL5_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL5_RESERVED3_MASK) >> USB2D_ENDPTCTRL5_RESERVED3_SHIFT)
#define  USB2D_ENDPTCTRL5_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL5_RESERVED3_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL5_RESERVED3_SHIFT))

#define  USB2D_ENDPTCTRL5_RXE_MASK 0x80
#define  USB2D_ENDPTCTRL5_RXE_SHIFT 7
#define  USB2D_ENDPTCTRL5_RXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL5_RXE_MASK) >> USB2D_ENDPTCTRL5_RXE_SHIFT)
#define  USB2D_ENDPTCTRL5_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL5_RXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL5_RXE_SHIFT))

#define  USB2D_ENDPTCTRL5_RXR_MASK 0x40
#define  USB2D_ENDPTCTRL5_RXR_SHIFT 6
#define  USB2D_ENDPTCTRL5_RXR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL5_RXR_MASK) >> USB2D_ENDPTCTRL5_RXR_SHIFT)
#define  USB2D_ENDPTCTRL5_RXR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL5_RXR_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL5_RXR_SHIFT))

#define  USB2D_ENDPTCTRL5_RXI_MASK 0x20
#define  USB2D_ENDPTCTRL5_RXI_SHIFT 5
#define  USB2D_ENDPTCTRL5_RXI_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL5_RXI_MASK) >> USB2D_ENDPTCTRL5_RXI_SHIFT)
#define  USB2D_ENDPTCTRL5_RXI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL5_RXI_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL5_RXI_SHIFT))

#define  USB2D_ENDPTCTRL5_RESERVED4_MASK 0x10
#define  USB2D_ENDPTCTRL5_RESERVED4_SHIFT 4
#define  USB2D_ENDPTCTRL5_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL5_RESERVED4_MASK) >> USB2D_ENDPTCTRL5_RESERVED4_SHIFT)
#define  USB2D_ENDPTCTRL5_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL5_RESERVED4_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL5_RESERVED4_SHIFT))

#define  USB2D_ENDPTCTRL5_RXT_MASK 0xc
#define  USB2D_ENDPTCTRL5_RXT_SHIFT 2
#define  USB2D_ENDPTCTRL5_RXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL5_RXT_MASK) >> USB2D_ENDPTCTRL5_RXT_SHIFT)
#define  USB2D_ENDPTCTRL5_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL5_RXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL5_RXT_SHIFT))

#define  USB2D_ENDPTCTRL5_RXD_MASK 0x2
#define  USB2D_ENDPTCTRL5_RXD_SHIFT 1
#define  USB2D_ENDPTCTRL5_RXD_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL5_RXD_MASK) >> USB2D_ENDPTCTRL5_RXD_SHIFT)
#define  USB2D_ENDPTCTRL5_RXD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL5_RXD_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL5_RXD_SHIFT))

#define  USB2D_ENDPTCTRL5_RXS_MASK 0x1
#define  USB2D_ENDPTCTRL5_RXS_SHIFT 0
#define  USB2D_ENDPTCTRL5_RXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL5_RXS_MASK) >> USB2D_ENDPTCTRL5_RXS_SHIFT)
#define  USB2D_ENDPTCTRL5_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL5_RXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL5_RXS_SHIFT))

//====================================================================
//Register: Endpoint Control Register (Instance 6 of 9) (ENDPTCTRL6)
/** \brief  (Instance 6 of 9)*/
//====================================================================

#define  USB2D_ENDPTCTRL6_RESERVED1_MASK 0xff000000
#define  USB2D_ENDPTCTRL6_RESERVED1_SHIFT 24
#define  USB2D_ENDPTCTRL6_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL6_RESERVED1_MASK) >> USB2D_ENDPTCTRL6_RESERVED1_SHIFT)
#define  USB2D_ENDPTCTRL6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL6_RESERVED1_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL6_RESERVED1_SHIFT))

#define  USB2D_ENDPTCTRL6_TXE_MASK 0x800000
#define  USB2D_ENDPTCTRL6_TXE_SHIFT 23
#define  USB2D_ENDPTCTRL6_TXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL6_TXE_MASK) >> USB2D_ENDPTCTRL6_TXE_SHIFT)
#define  USB2D_ENDPTCTRL6_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL6_TXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL6_TXE_SHIFT))

#define  USB2D_ENDPTCTRL6_TXR_MASK 0x400000
#define  USB2D_ENDPTCTRL6_TXR_SHIFT 22
#define  USB2D_ENDPTCTRL6_TXR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL6_TXR_MASK) >> USB2D_ENDPTCTRL6_TXR_SHIFT)
#define  USB2D_ENDPTCTRL6_TXR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL6_TXR_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL6_TXR_SHIFT))

#define  USB2D_ENDPTCTRL6_TXI_MASK 0x200000
#define  USB2D_ENDPTCTRL6_TXI_SHIFT 21
#define  USB2D_ENDPTCTRL6_TXI_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL6_TXI_MASK) >> USB2D_ENDPTCTRL6_TXI_SHIFT)
#define  USB2D_ENDPTCTRL6_TXI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL6_TXI_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL6_TXI_SHIFT))

#define  USB2D_ENDPTCTRL6_RESERVED2_MASK 0x100000
#define  USB2D_ENDPTCTRL6_RESERVED2_SHIFT 20
#define  USB2D_ENDPTCTRL6_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL6_RESERVED2_MASK) >> USB2D_ENDPTCTRL6_RESERVED2_SHIFT)
#define  USB2D_ENDPTCTRL6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL6_RESERVED2_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL6_RESERVED2_SHIFT))

#define  USB2D_ENDPTCTRL6_TXT_MASK 0xc0000
#define  USB2D_ENDPTCTRL6_TXT_SHIFT 18
#define  USB2D_ENDPTCTRL6_TXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL6_TXT_MASK) >> USB2D_ENDPTCTRL6_TXT_SHIFT)
#define  USB2D_ENDPTCTRL6_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL6_TXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL6_TXT_SHIFT))

#define  USB2D_ENDPTCTRL6_TXD_MASK 0x20000
#define  USB2D_ENDPTCTRL6_TXD_SHIFT 17
#define  USB2D_ENDPTCTRL6_TXD_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL6_TXD_MASK) >> USB2D_ENDPTCTRL6_TXD_SHIFT)
#define  USB2D_ENDPTCTRL6_TXD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL6_TXD_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL6_TXD_SHIFT))

#define  USB2D_ENDPTCTRL6_TXS_MASK 0x10000
#define  USB2D_ENDPTCTRL6_TXS_SHIFT 16
#define  USB2D_ENDPTCTRL6_TXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL6_TXS_MASK) >> USB2D_ENDPTCTRL6_TXS_SHIFT)
#define  USB2D_ENDPTCTRL6_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL6_TXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL6_TXS_SHIFT))

#define  USB2D_ENDPTCTRL6_RESERVED3_MASK 0xff00
#define  USB2D_ENDPTCTRL6_RESERVED3_SHIFT 8
#define  USB2D_ENDPTCTRL6_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL6_RESERVED3_MASK) >> USB2D_ENDPTCTRL6_RESERVED3_SHIFT)
#define  USB2D_ENDPTCTRL6_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL6_RESERVED3_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL6_RESERVED3_SHIFT))

#define  USB2D_ENDPTCTRL6_RXE_MASK 0x80
#define  USB2D_ENDPTCTRL6_RXE_SHIFT 7
#define  USB2D_ENDPTCTRL6_RXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL6_RXE_MASK) >> USB2D_ENDPTCTRL6_RXE_SHIFT)
#define  USB2D_ENDPTCTRL6_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL6_RXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL6_RXE_SHIFT))

#define  USB2D_ENDPTCTRL6_RXR_MASK 0x40
#define  USB2D_ENDPTCTRL6_RXR_SHIFT 6
#define  USB2D_ENDPTCTRL6_RXR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL6_RXR_MASK) >> USB2D_ENDPTCTRL6_RXR_SHIFT)
#define  USB2D_ENDPTCTRL6_RXR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL6_RXR_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL6_RXR_SHIFT))

#define  USB2D_ENDPTCTRL6_RXI_MASK 0x20
#define  USB2D_ENDPTCTRL6_RXI_SHIFT 5
#define  USB2D_ENDPTCTRL6_RXI_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL6_RXI_MASK) >> USB2D_ENDPTCTRL6_RXI_SHIFT)
#define  USB2D_ENDPTCTRL6_RXI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL6_RXI_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL6_RXI_SHIFT))

#define  USB2D_ENDPTCTRL6_RESERVED4_MASK 0x10
#define  USB2D_ENDPTCTRL6_RESERVED4_SHIFT 4
#define  USB2D_ENDPTCTRL6_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL6_RESERVED4_MASK) >> USB2D_ENDPTCTRL6_RESERVED4_SHIFT)
#define  USB2D_ENDPTCTRL6_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL6_RESERVED4_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL6_RESERVED4_SHIFT))

#define  USB2D_ENDPTCTRL6_RXT_MASK 0xc
#define  USB2D_ENDPTCTRL6_RXT_SHIFT 2
#define  USB2D_ENDPTCTRL6_RXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL6_RXT_MASK) >> USB2D_ENDPTCTRL6_RXT_SHIFT)
#define  USB2D_ENDPTCTRL6_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL6_RXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL6_RXT_SHIFT))

#define  USB2D_ENDPTCTRL6_RXD_MASK 0x2
#define  USB2D_ENDPTCTRL6_RXD_SHIFT 1
#define  USB2D_ENDPTCTRL6_RXD_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL6_RXD_MASK) >> USB2D_ENDPTCTRL6_RXD_SHIFT)
#define  USB2D_ENDPTCTRL6_RXD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL6_RXD_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL6_RXD_SHIFT))

#define  USB2D_ENDPTCTRL6_RXS_MASK 0x1
#define  USB2D_ENDPTCTRL6_RXS_SHIFT 0
#define  USB2D_ENDPTCTRL6_RXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL6_RXS_MASK) >> USB2D_ENDPTCTRL6_RXS_SHIFT)
#define  USB2D_ENDPTCTRL6_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL6_RXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL6_RXS_SHIFT))

//====================================================================
//Register: Endpoint Control Register (Instance 7 of 9) (ENDPTCTRL7)
/** \brief  (Instance 7 of 9)*/
//====================================================================

#define  USB2D_ENDPTCTRL7_RESERVED1_MASK 0xff000000
#define  USB2D_ENDPTCTRL7_RESERVED1_SHIFT 24
#define  USB2D_ENDPTCTRL7_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL7_RESERVED1_MASK) >> USB2D_ENDPTCTRL7_RESERVED1_SHIFT)
#define  USB2D_ENDPTCTRL7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL7_RESERVED1_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL7_RESERVED1_SHIFT))

#define  USB2D_ENDPTCTRL7_TXE_MASK 0x800000
#define  USB2D_ENDPTCTRL7_TXE_SHIFT 23
#define  USB2D_ENDPTCTRL7_TXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL7_TXE_MASK) >> USB2D_ENDPTCTRL7_TXE_SHIFT)
#define  USB2D_ENDPTCTRL7_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL7_TXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL7_TXE_SHIFT))

#define  USB2D_ENDPTCTRL7_TXR_MASK 0x400000
#define  USB2D_ENDPTCTRL7_TXR_SHIFT 22
#define  USB2D_ENDPTCTRL7_TXR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL7_TXR_MASK) >> USB2D_ENDPTCTRL7_TXR_SHIFT)
#define  USB2D_ENDPTCTRL7_TXR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL7_TXR_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL7_TXR_SHIFT))

#define  USB2D_ENDPTCTRL7_TXI_MASK 0x200000
#define  USB2D_ENDPTCTRL7_TXI_SHIFT 21
#define  USB2D_ENDPTCTRL7_TXI_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL7_TXI_MASK) >> USB2D_ENDPTCTRL7_TXI_SHIFT)
#define  USB2D_ENDPTCTRL7_TXI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL7_TXI_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL7_TXI_SHIFT))

#define  USB2D_ENDPTCTRL7_RESERVED2_MASK 0x100000
#define  USB2D_ENDPTCTRL7_RESERVED2_SHIFT 20
#define  USB2D_ENDPTCTRL7_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL7_RESERVED2_MASK) >> USB2D_ENDPTCTRL7_RESERVED2_SHIFT)
#define  USB2D_ENDPTCTRL7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL7_RESERVED2_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL7_RESERVED2_SHIFT))

#define  USB2D_ENDPTCTRL7_TXT_MASK 0xc0000
#define  USB2D_ENDPTCTRL7_TXT_SHIFT 18
#define  USB2D_ENDPTCTRL7_TXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL7_TXT_MASK) >> USB2D_ENDPTCTRL7_TXT_SHIFT)
#define  USB2D_ENDPTCTRL7_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL7_TXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL7_TXT_SHIFT))

#define  USB2D_ENDPTCTRL7_TXD_MASK 0x20000
#define  USB2D_ENDPTCTRL7_TXD_SHIFT 17
#define  USB2D_ENDPTCTRL7_TXD_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL7_TXD_MASK) >> USB2D_ENDPTCTRL7_TXD_SHIFT)
#define  USB2D_ENDPTCTRL7_TXD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL7_TXD_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL7_TXD_SHIFT))

#define  USB2D_ENDPTCTRL7_TXS_MASK 0x10000
#define  USB2D_ENDPTCTRL7_TXS_SHIFT 16
#define  USB2D_ENDPTCTRL7_TXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL7_TXS_MASK) >> USB2D_ENDPTCTRL7_TXS_SHIFT)
#define  USB2D_ENDPTCTRL7_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL7_TXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL7_TXS_SHIFT))

#define  USB2D_ENDPTCTRL7_RESERVED3_MASK 0xff00
#define  USB2D_ENDPTCTRL7_RESERVED3_SHIFT 8
#define  USB2D_ENDPTCTRL7_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL7_RESERVED3_MASK) >> USB2D_ENDPTCTRL7_RESERVED3_SHIFT)
#define  USB2D_ENDPTCTRL7_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL7_RESERVED3_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL7_RESERVED3_SHIFT))

#define  USB2D_ENDPTCTRL7_RXE_MASK 0x80
#define  USB2D_ENDPTCTRL7_RXE_SHIFT 7
#define  USB2D_ENDPTCTRL7_RXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL7_RXE_MASK) >> USB2D_ENDPTCTRL7_RXE_SHIFT)
#define  USB2D_ENDPTCTRL7_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL7_RXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL7_RXE_SHIFT))

#define  USB2D_ENDPTCTRL7_RXR_MASK 0x40
#define  USB2D_ENDPTCTRL7_RXR_SHIFT 6
#define  USB2D_ENDPTCTRL7_RXR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL7_RXR_MASK) >> USB2D_ENDPTCTRL7_RXR_SHIFT)
#define  USB2D_ENDPTCTRL7_RXR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL7_RXR_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL7_RXR_SHIFT))

#define  USB2D_ENDPTCTRL7_RXI_MASK 0x20
#define  USB2D_ENDPTCTRL7_RXI_SHIFT 5
#define  USB2D_ENDPTCTRL7_RXI_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL7_RXI_MASK) >> USB2D_ENDPTCTRL7_RXI_SHIFT)
#define  USB2D_ENDPTCTRL7_RXI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL7_RXI_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL7_RXI_SHIFT))

#define  USB2D_ENDPTCTRL7_RESERVED4_MASK 0x10
#define  USB2D_ENDPTCTRL7_RESERVED4_SHIFT 4
#define  USB2D_ENDPTCTRL7_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL7_RESERVED4_MASK) >> USB2D_ENDPTCTRL7_RESERVED4_SHIFT)
#define  USB2D_ENDPTCTRL7_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL7_RESERVED4_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL7_RESERVED4_SHIFT))

#define  USB2D_ENDPTCTRL7_RXT_MASK 0xc
#define  USB2D_ENDPTCTRL7_RXT_SHIFT 2
#define  USB2D_ENDPTCTRL7_RXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL7_RXT_MASK) >> USB2D_ENDPTCTRL7_RXT_SHIFT)
#define  USB2D_ENDPTCTRL7_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL7_RXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL7_RXT_SHIFT))

#define  USB2D_ENDPTCTRL7_RXD_MASK 0x2
#define  USB2D_ENDPTCTRL7_RXD_SHIFT 1
#define  USB2D_ENDPTCTRL7_RXD_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL7_RXD_MASK) >> USB2D_ENDPTCTRL7_RXD_SHIFT)
#define  USB2D_ENDPTCTRL7_RXD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL7_RXD_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL7_RXD_SHIFT))

#define  USB2D_ENDPTCTRL7_RXS_MASK 0x1
#define  USB2D_ENDPTCTRL7_RXS_SHIFT 0
#define  USB2D_ENDPTCTRL7_RXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL7_RXS_MASK) >> USB2D_ENDPTCTRL7_RXS_SHIFT)
#define  USB2D_ENDPTCTRL7_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL7_RXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL7_RXS_SHIFT))

//====================================================================
//Register: Endpoint Control Register (Instance 8 of 9) (ENDPTCTRL8)
/** \brief  (Instance 8 of 9)*/
//====================================================================

#define  USB2D_ENDPTCTRL8_RESERVED1_MASK 0xff000000
#define  USB2D_ENDPTCTRL8_RESERVED1_SHIFT 24
#define  USB2D_ENDPTCTRL8_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL8_RESERVED1_MASK) >> USB2D_ENDPTCTRL8_RESERVED1_SHIFT)
#define  USB2D_ENDPTCTRL8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL8_RESERVED1_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL8_RESERVED1_SHIFT))

#define  USB2D_ENDPTCTRL8_TXE_MASK 0x800000
#define  USB2D_ENDPTCTRL8_TXE_SHIFT 23
#define  USB2D_ENDPTCTRL8_TXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL8_TXE_MASK) >> USB2D_ENDPTCTRL8_TXE_SHIFT)
#define  USB2D_ENDPTCTRL8_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL8_TXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL8_TXE_SHIFT))

#define  USB2D_ENDPTCTRL8_TXR_MASK 0x400000
#define  USB2D_ENDPTCTRL8_TXR_SHIFT 22
#define  USB2D_ENDPTCTRL8_TXR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL8_TXR_MASK) >> USB2D_ENDPTCTRL8_TXR_SHIFT)
#define  USB2D_ENDPTCTRL8_TXR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL8_TXR_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL8_TXR_SHIFT))

#define  USB2D_ENDPTCTRL8_TXI_MASK 0x200000
#define  USB2D_ENDPTCTRL8_TXI_SHIFT 21
#define  USB2D_ENDPTCTRL8_TXI_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL8_TXI_MASK) >> USB2D_ENDPTCTRL8_TXI_SHIFT)
#define  USB2D_ENDPTCTRL8_TXI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL8_TXI_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL8_TXI_SHIFT))

#define  USB2D_ENDPTCTRL8_RESERVED2_MASK 0x100000
#define  USB2D_ENDPTCTRL8_RESERVED2_SHIFT 20
#define  USB2D_ENDPTCTRL8_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL8_RESERVED2_MASK) >> USB2D_ENDPTCTRL8_RESERVED2_SHIFT)
#define  USB2D_ENDPTCTRL8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL8_RESERVED2_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL8_RESERVED2_SHIFT))

#define  USB2D_ENDPTCTRL8_TXT_MASK 0xc0000
#define  USB2D_ENDPTCTRL8_TXT_SHIFT 18
#define  USB2D_ENDPTCTRL8_TXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL8_TXT_MASK) >> USB2D_ENDPTCTRL8_TXT_SHIFT)
#define  USB2D_ENDPTCTRL8_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL8_TXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL8_TXT_SHIFT))

#define  USB2D_ENDPTCTRL8_TXD_MASK 0x20000
#define  USB2D_ENDPTCTRL8_TXD_SHIFT 17
#define  USB2D_ENDPTCTRL8_TXD_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL8_TXD_MASK) >> USB2D_ENDPTCTRL8_TXD_SHIFT)
#define  USB2D_ENDPTCTRL8_TXD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL8_TXD_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL8_TXD_SHIFT))

#define  USB2D_ENDPTCTRL8_TXS_MASK 0x10000
#define  USB2D_ENDPTCTRL8_TXS_SHIFT 16
#define  USB2D_ENDPTCTRL8_TXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL8_TXS_MASK) >> USB2D_ENDPTCTRL8_TXS_SHIFT)
#define  USB2D_ENDPTCTRL8_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL8_TXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL8_TXS_SHIFT))

#define  USB2D_ENDPTCTRL8_RESERVED3_MASK 0xff00
#define  USB2D_ENDPTCTRL8_RESERVED3_SHIFT 8
#define  USB2D_ENDPTCTRL8_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL8_RESERVED3_MASK) >> USB2D_ENDPTCTRL8_RESERVED3_SHIFT)
#define  USB2D_ENDPTCTRL8_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL8_RESERVED3_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL8_RESERVED3_SHIFT))

#define  USB2D_ENDPTCTRL8_RXE_MASK 0x80
#define  USB2D_ENDPTCTRL8_RXE_SHIFT 7
#define  USB2D_ENDPTCTRL8_RXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL8_RXE_MASK) >> USB2D_ENDPTCTRL8_RXE_SHIFT)
#define  USB2D_ENDPTCTRL8_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL8_RXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL8_RXE_SHIFT))

#define  USB2D_ENDPTCTRL8_RXR_MASK 0x40
#define  USB2D_ENDPTCTRL8_RXR_SHIFT 6
#define  USB2D_ENDPTCTRL8_RXR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL8_RXR_MASK) >> USB2D_ENDPTCTRL8_RXR_SHIFT)
#define  USB2D_ENDPTCTRL8_RXR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL8_RXR_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL8_RXR_SHIFT))

#define  USB2D_ENDPTCTRL8_RXI_MASK 0x20
#define  USB2D_ENDPTCTRL8_RXI_SHIFT 5
#define  USB2D_ENDPTCTRL8_RXI_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL8_RXI_MASK) >> USB2D_ENDPTCTRL8_RXI_SHIFT)
#define  USB2D_ENDPTCTRL8_RXI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL8_RXI_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL8_RXI_SHIFT))

#define  USB2D_ENDPTCTRL8_RESERVED4_MASK 0x10
#define  USB2D_ENDPTCTRL8_RESERVED4_SHIFT 4
#define  USB2D_ENDPTCTRL8_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL8_RESERVED4_MASK) >> USB2D_ENDPTCTRL8_RESERVED4_SHIFT)
#define  USB2D_ENDPTCTRL8_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL8_RESERVED4_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL8_RESERVED4_SHIFT))

#define  USB2D_ENDPTCTRL8_RXT_MASK 0xc
#define  USB2D_ENDPTCTRL8_RXT_SHIFT 2
#define  USB2D_ENDPTCTRL8_RXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL8_RXT_MASK) >> USB2D_ENDPTCTRL8_RXT_SHIFT)
#define  USB2D_ENDPTCTRL8_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL8_RXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL8_RXT_SHIFT))

#define  USB2D_ENDPTCTRL8_RXD_MASK 0x2
#define  USB2D_ENDPTCTRL8_RXD_SHIFT 1
#define  USB2D_ENDPTCTRL8_RXD_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL8_RXD_MASK) >> USB2D_ENDPTCTRL8_RXD_SHIFT)
#define  USB2D_ENDPTCTRL8_RXD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL8_RXD_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL8_RXD_SHIFT))

#define  USB2D_ENDPTCTRL8_RXS_MASK 0x1
#define  USB2D_ENDPTCTRL8_RXS_SHIFT 0
#define  USB2D_ENDPTCTRL8_RXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL8_RXS_MASK) >> USB2D_ENDPTCTRL8_RXS_SHIFT)
#define  USB2D_ENDPTCTRL8_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL8_RXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL8_RXS_SHIFT))

//====================================================================
//Register: Endpoint Control Register (Instance 9 of 9) (ENDPTCTRL9)
/** \brief  (Instance 9 of 9)*/
//====================================================================

#define  USB2D_ENDPTCTRL9_RESERVED1_MASK 0xff000000
#define  USB2D_ENDPTCTRL9_RESERVED1_SHIFT 24
#define  USB2D_ENDPTCTRL9_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL9_RESERVED1_MASK) >> USB2D_ENDPTCTRL9_RESERVED1_SHIFT)
#define  USB2D_ENDPTCTRL9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL9_RESERVED1_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL9_RESERVED1_SHIFT))

#define  USB2D_ENDPTCTRL9_TXE_MASK 0x800000
#define  USB2D_ENDPTCTRL9_TXE_SHIFT 23
#define  USB2D_ENDPTCTRL9_TXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL9_TXE_MASK) >> USB2D_ENDPTCTRL9_TXE_SHIFT)
#define  USB2D_ENDPTCTRL9_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL9_TXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL9_TXE_SHIFT))

#define  USB2D_ENDPTCTRL9_TXR_MASK 0x400000
#define  USB2D_ENDPTCTRL9_TXR_SHIFT 22
#define  USB2D_ENDPTCTRL9_TXR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL9_TXR_MASK) >> USB2D_ENDPTCTRL9_TXR_SHIFT)
#define  USB2D_ENDPTCTRL9_TXR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL9_TXR_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL9_TXR_SHIFT))

#define  USB2D_ENDPTCTRL9_TXI_MASK 0x200000
#define  USB2D_ENDPTCTRL9_TXI_SHIFT 21
#define  USB2D_ENDPTCTRL9_TXI_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL9_TXI_MASK) >> USB2D_ENDPTCTRL9_TXI_SHIFT)
#define  USB2D_ENDPTCTRL9_TXI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL9_TXI_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL9_TXI_SHIFT))

#define  USB2D_ENDPTCTRL9_RESERVED2_MASK 0x100000
#define  USB2D_ENDPTCTRL9_RESERVED2_SHIFT 20
#define  USB2D_ENDPTCTRL9_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL9_RESERVED2_MASK) >> USB2D_ENDPTCTRL9_RESERVED2_SHIFT)
#define  USB2D_ENDPTCTRL9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL9_RESERVED2_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL9_RESERVED2_SHIFT))

#define  USB2D_ENDPTCTRL9_TXT_MASK 0xc0000
#define  USB2D_ENDPTCTRL9_TXT_SHIFT 18
#define  USB2D_ENDPTCTRL9_TXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL9_TXT_MASK) >> USB2D_ENDPTCTRL9_TXT_SHIFT)
#define  USB2D_ENDPTCTRL9_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL9_TXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL9_TXT_SHIFT))

#define  USB2D_ENDPTCTRL9_TXD_MASK 0x20000
#define  USB2D_ENDPTCTRL9_TXD_SHIFT 17
#define  USB2D_ENDPTCTRL9_TXD_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL9_TXD_MASK) >> USB2D_ENDPTCTRL9_TXD_SHIFT)
#define  USB2D_ENDPTCTRL9_TXD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL9_TXD_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL9_TXD_SHIFT))

#define  USB2D_ENDPTCTRL9_TXS_MASK 0x10000
#define  USB2D_ENDPTCTRL9_TXS_SHIFT 16
#define  USB2D_ENDPTCTRL9_TXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL9_TXS_MASK) >> USB2D_ENDPTCTRL9_TXS_SHIFT)
#define  USB2D_ENDPTCTRL9_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL9_TXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL9_TXS_SHIFT))

#define  USB2D_ENDPTCTRL9_RESERVED3_MASK 0xff00
#define  USB2D_ENDPTCTRL9_RESERVED3_SHIFT 8
#define  USB2D_ENDPTCTRL9_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL9_RESERVED3_MASK) >> USB2D_ENDPTCTRL9_RESERVED3_SHIFT)
#define  USB2D_ENDPTCTRL9_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL9_RESERVED3_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL9_RESERVED3_SHIFT))

#define  USB2D_ENDPTCTRL9_RXE_MASK 0x80
#define  USB2D_ENDPTCTRL9_RXE_SHIFT 7
#define  USB2D_ENDPTCTRL9_RXE_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL9_RXE_MASK) >> USB2D_ENDPTCTRL9_RXE_SHIFT)
#define  USB2D_ENDPTCTRL9_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL9_RXE_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL9_RXE_SHIFT))

#define  USB2D_ENDPTCTRL9_RXR_MASK 0x40
#define  USB2D_ENDPTCTRL9_RXR_SHIFT 6
#define  USB2D_ENDPTCTRL9_RXR_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL9_RXR_MASK) >> USB2D_ENDPTCTRL9_RXR_SHIFT)
#define  USB2D_ENDPTCTRL9_RXR_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL9_RXR_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL9_RXR_SHIFT))

#define  USB2D_ENDPTCTRL9_RXI_MASK 0x20
#define  USB2D_ENDPTCTRL9_RXI_SHIFT 5
#define  USB2D_ENDPTCTRL9_RXI_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL9_RXI_MASK) >> USB2D_ENDPTCTRL9_RXI_SHIFT)
#define  USB2D_ENDPTCTRL9_RXI_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL9_RXI_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL9_RXI_SHIFT))

#define  USB2D_ENDPTCTRL9_RESERVED4_MASK 0x10
#define  USB2D_ENDPTCTRL9_RESERVED4_SHIFT 4
#define  USB2D_ENDPTCTRL9_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL9_RESERVED4_MASK) >> USB2D_ENDPTCTRL9_RESERVED4_SHIFT)
#define  USB2D_ENDPTCTRL9_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL9_RESERVED4_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL9_RESERVED4_SHIFT))

#define  USB2D_ENDPTCTRL9_RXT_MASK 0xc
#define  USB2D_ENDPTCTRL9_RXT_SHIFT 2
#define  USB2D_ENDPTCTRL9_RXT_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL9_RXT_MASK) >> USB2D_ENDPTCTRL9_RXT_SHIFT)
#define  USB2D_ENDPTCTRL9_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL9_RXT_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL9_RXT_SHIFT))

#define  USB2D_ENDPTCTRL9_RXD_MASK 0x2
#define  USB2D_ENDPTCTRL9_RXD_SHIFT 1
#define  USB2D_ENDPTCTRL9_RXD_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL9_RXD_MASK) >> USB2D_ENDPTCTRL9_RXD_SHIFT)
#define  USB2D_ENDPTCTRL9_RXD_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL9_RXD_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL9_RXD_SHIFT))

#define  USB2D_ENDPTCTRL9_RXS_MASK 0x1
#define  USB2D_ENDPTCTRL9_RXS_SHIFT 0
#define  USB2D_ENDPTCTRL9_RXS_MASK_SHIFT(reg) (((reg) & USB2D_ENDPTCTRL9_RXS_MASK) >> USB2D_ENDPTCTRL9_RXS_SHIFT)
#define  USB2D_ENDPTCTRL9_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2D_ENDPTCTRL9_RXS_MASK) | (((uint32_t)val) << USB2D_ENDPTCTRL9_RXS_SHIFT))

//====================================================================
//
//Register File: USB Host (USB2H)
//
//====================================================================

//====================================================================
//Register: Identification Register (ID)
//====================================================================

#define  USB2H_ID_CIVERSION_MASK 0xe0000000
#define  USB2H_ID_CIVERSION_SHIFT 29
#define  USB2H_ID_CIVERSION_MASK_SHIFT(reg) (((reg) & USB2H_ID_CIVERSION_MASK) >> USB2H_ID_CIVERSION_SHIFT)
#define  USB2H_ID_CIVERSION_REPLACE_VAL(reg,val) (((reg) & ~USB2H_ID_CIVERSION_MASK) | (((uint32_t)val) << USB2H_ID_CIVERSION_SHIFT))

#define  USB2H_ID_VERSION_MASK 0x1e000000
#define  USB2H_ID_VERSION_SHIFT 25
#define  USB2H_ID_VERSION_MASK_SHIFT(reg) (((reg) & USB2H_ID_VERSION_MASK) >> USB2H_ID_VERSION_SHIFT)
#define  USB2H_ID_VERSION_REPLACE_VAL(reg,val) (((reg) & ~USB2H_ID_VERSION_MASK) | (((uint32_t)val) << USB2H_ID_VERSION_SHIFT))

#define  USB2H_ID_REVISION_MASK 0x1e00000
#define  USB2H_ID_REVISION_SHIFT 21
#define  USB2H_ID_REVISION_MASK_SHIFT(reg) (((reg) & USB2H_ID_REVISION_MASK) >> USB2H_ID_REVISION_SHIFT)
#define  USB2H_ID_REVISION_REPLACE_VAL(reg,val) (((reg) & ~USB2H_ID_REVISION_MASK) | (((uint32_t)val) << USB2H_ID_REVISION_SHIFT))

#define  USB2H_ID_TAG_MASK 0x1f0000
#define  USB2H_ID_TAG_SHIFT 16
#define  USB2H_ID_TAG_MASK_SHIFT(reg) (((reg) & USB2H_ID_TAG_MASK) >> USB2H_ID_TAG_SHIFT)
#define  USB2H_ID_TAG_REPLACE_VAL(reg,val) (((reg) & ~USB2H_ID_TAG_MASK) | (((uint32_t)val) << USB2H_ID_TAG_SHIFT))

#define  USB2H_ID_NID_MASK 0xff00
#define  USB2H_ID_NID_SHIFT 8
#define  USB2H_ID_NID_MASK_SHIFT(reg) (((reg) & USB2H_ID_NID_MASK) >> USB2H_ID_NID_SHIFT)
#define  USB2H_ID_NID_REPLACE_VAL(reg,val) (((reg) & ~USB2H_ID_NID_MASK) | (((uint32_t)val) << USB2H_ID_NID_SHIFT))

#define  USB2H_ID_ID_MASK 0xff
#define  USB2H_ID_ID_SHIFT 0
#define  USB2H_ID_ID_MASK_SHIFT(reg) (((reg) & USB2H_ID_ID_MASK) >> USB2H_ID_ID_SHIFT)
#define  USB2H_ID_ID_REPLACE_VAL(reg,val) (((reg) & ~USB2H_ID_ID_MASK) | (((uint32_t)val) << USB2H_ID_ID_SHIFT))

//====================================================================
//Register: ChipIdea General Hardware Parameters Register (HWGENERAL)
//====================================================================

#define  USB2H_HWGENERAL_RESERVED1_MASK 0xfffff800
#define  USB2H_HWGENERAL_RESERVED1_SHIFT 11
#define  USB2H_HWGENERAL_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_HWGENERAL_RESERVED1_MASK) >> USB2H_HWGENERAL_RESERVED1_SHIFT)
#define  USB2H_HWGENERAL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWGENERAL_RESERVED1_MASK) | (((uint32_t)val) << USB2H_HWGENERAL_RESERVED1_SHIFT))

#define  USB2H_HWGENERAL_SM_MASK 0x600
#define  USB2H_HWGENERAL_SM_SHIFT 9
#define  USB2H_HWGENERAL_SM_MASK_SHIFT(reg) (((reg) & USB2H_HWGENERAL_SM_MASK) >> USB2H_HWGENERAL_SM_SHIFT)
#define  USB2H_HWGENERAL_SM_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWGENERAL_SM_MASK) | (((uint32_t)val) << USB2H_HWGENERAL_SM_SHIFT))

#define  USB2H_HWGENERAL_PHYM_MASK 0x1c0
#define  USB2H_HWGENERAL_PHYM_SHIFT 6
#define  USB2H_HWGENERAL_PHYM_MASK_SHIFT(reg) (((reg) & USB2H_HWGENERAL_PHYM_MASK) >> USB2H_HWGENERAL_PHYM_SHIFT)
#define  USB2H_HWGENERAL_PHYM_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWGENERAL_PHYM_MASK) | (((uint32_t)val) << USB2H_HWGENERAL_PHYM_SHIFT))

#define  USB2H_HWGENERAL_PHYW_MASK 0x30
#define  USB2H_HWGENERAL_PHYW_SHIFT 4
#define  USB2H_HWGENERAL_PHYW_MASK_SHIFT(reg) (((reg) & USB2H_HWGENERAL_PHYW_MASK) >> USB2H_HWGENERAL_PHYW_SHIFT)
#define  USB2H_HWGENERAL_PHYW_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWGENERAL_PHYW_MASK) | (((uint32_t)val) << USB2H_HWGENERAL_PHYW_SHIFT))

#define  USB2H_HWGENERAL_BWT_MASK 0x8
#define  USB2H_HWGENERAL_BWT_SHIFT 3
#define  USB2H_HWGENERAL_BWT_MASK_SHIFT(reg) (((reg) & USB2H_HWGENERAL_BWT_MASK) >> USB2H_HWGENERAL_BWT_SHIFT)
#define  USB2H_HWGENERAL_BWT_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWGENERAL_BWT_MASK) | (((uint32_t)val) << USB2H_HWGENERAL_BWT_SHIFT))

#define  USB2H_HWGENERAL_CLKC_MASK 0x6
#define  USB2H_HWGENERAL_CLKC_SHIFT 1
#define  USB2H_HWGENERAL_CLKC_MASK_SHIFT(reg) (((reg) & USB2H_HWGENERAL_CLKC_MASK) >> USB2H_HWGENERAL_CLKC_SHIFT)
#define  USB2H_HWGENERAL_CLKC_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWGENERAL_CLKC_MASK) | (((uint32_t)val) << USB2H_HWGENERAL_CLKC_SHIFT))

#define  USB2H_HWGENERAL_RT_MASK 0x1
#define  USB2H_HWGENERAL_RT_SHIFT 0
#define  USB2H_HWGENERAL_RT_MASK_SHIFT(reg) (((reg) & USB2H_HWGENERAL_RT_MASK) >> USB2H_HWGENERAL_RT_SHIFT)
#define  USB2H_HWGENERAL_RT_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWGENERAL_RT_MASK) | (((uint32_t)val) << USB2H_HWGENERAL_RT_SHIFT))

//====================================================================
//Register: Host Hardware Parameters Register (HWHOST)
//====================================================================

#define  USB2H_HWHOST_TTPER_MASK 0xff000000
#define  USB2H_HWHOST_TTPER_SHIFT 24
#define  USB2H_HWHOST_TTPER_MASK_SHIFT(reg) (((reg) & USB2H_HWHOST_TTPER_MASK) >> USB2H_HWHOST_TTPER_SHIFT)
#define  USB2H_HWHOST_TTPER_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWHOST_TTPER_MASK) | (((uint32_t)val) << USB2H_HWHOST_TTPER_SHIFT))

#define  USB2H_HWHOST_TTASY_MASK 0xff0000
#define  USB2H_HWHOST_TTASY_SHIFT 16
#define  USB2H_HWHOST_TTASY_MASK_SHIFT(reg) (((reg) & USB2H_HWHOST_TTASY_MASK) >> USB2H_HWHOST_TTASY_SHIFT)
#define  USB2H_HWHOST_TTASY_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWHOST_TTASY_MASK) | (((uint32_t)val) << USB2H_HWHOST_TTASY_SHIFT))

#define  USB2H_HWHOST_RESERVED1_MASK 0xfff0
#define  USB2H_HWHOST_RESERVED1_SHIFT 4
#define  USB2H_HWHOST_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_HWHOST_RESERVED1_MASK) >> USB2H_HWHOST_RESERVED1_SHIFT)
#define  USB2H_HWHOST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWHOST_RESERVED1_MASK) | (((uint32_t)val) << USB2H_HWHOST_RESERVED1_SHIFT))

#define  USB2H_HWHOST_NPORT_MASK 0xe
#define  USB2H_HWHOST_NPORT_SHIFT 1
#define  USB2H_HWHOST_NPORT_MASK_SHIFT(reg) (((reg) & USB2H_HWHOST_NPORT_MASK) >> USB2H_HWHOST_NPORT_SHIFT)
#define  USB2H_HWHOST_NPORT_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWHOST_NPORT_MASK) | (((uint32_t)val) << USB2H_HWHOST_NPORT_SHIFT))

#define  USB2H_HWHOST_HC_MASK 0x1
#define  USB2H_HWHOST_HC_SHIFT 0
#define  USB2H_HWHOST_HC_MASK_SHIFT(reg) (((reg) & USB2H_HWHOST_HC_MASK) >> USB2H_HWHOST_HC_SHIFT)
#define  USB2H_HWHOST_HC_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWHOST_HC_MASK) | (((uint32_t)val) << USB2H_HWHOST_HC_SHIFT))

//====================================================================
//Register: TX Buffer Parameters Register (HWTXBUF)
//====================================================================

#define  USB2H_HWTXBUF_TXLCR_MASK 0x80000000
#define  USB2H_HWTXBUF_TXLCR_SHIFT 31
#define  USB2H_HWTXBUF_TXLCR_MASK_SHIFT(reg) (((reg) & USB2H_HWTXBUF_TXLCR_MASK) >> USB2H_HWTXBUF_TXLCR_SHIFT)
#define  USB2H_HWTXBUF_TXLCR_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWTXBUF_TXLCR_MASK) | (((uint32_t)val) << USB2H_HWTXBUF_TXLCR_SHIFT))

#define  USB2H_HWTXBUF_RESERVED1_MASK 0x7f000000
#define  USB2H_HWTXBUF_RESERVED1_SHIFT 24
#define  USB2H_HWTXBUF_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_HWTXBUF_RESERVED1_MASK) >> USB2H_HWTXBUF_RESERVED1_SHIFT)
#define  USB2H_HWTXBUF_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWTXBUF_RESERVED1_MASK) | (((uint32_t)val) << USB2H_HWTXBUF_RESERVED1_SHIFT))

#define  USB2H_HWTXBUF_TXCHANADD_MASK 0xff0000
#define  USB2H_HWTXBUF_TXCHANADD_SHIFT 16
#define  USB2H_HWTXBUF_TXCHANADD_MASK_SHIFT(reg) (((reg) & USB2H_HWTXBUF_TXCHANADD_MASK) >> USB2H_HWTXBUF_TXCHANADD_SHIFT)
#define  USB2H_HWTXBUF_TXCHANADD_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWTXBUF_TXCHANADD_MASK) | (((uint32_t)val) << USB2H_HWTXBUF_TXCHANADD_SHIFT))

#define  USB2H_HWTXBUF_TXADD_MASK 0xff00
#define  USB2H_HWTXBUF_TXADD_SHIFT 8
#define  USB2H_HWTXBUF_TXADD_MASK_SHIFT(reg) (((reg) & USB2H_HWTXBUF_TXADD_MASK) >> USB2H_HWTXBUF_TXADD_SHIFT)
#define  USB2H_HWTXBUF_TXADD_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWTXBUF_TXADD_MASK) | (((uint32_t)val) << USB2H_HWTXBUF_TXADD_SHIFT))

#define  USB2H_HWTXBUF_TXBURST_MASK 0xff
#define  USB2H_HWTXBUF_TXBURST_SHIFT 0
#define  USB2H_HWTXBUF_TXBURST_MASK_SHIFT(reg) (((reg) & USB2H_HWTXBUF_TXBURST_MASK) >> USB2H_HWTXBUF_TXBURST_SHIFT)
#define  USB2H_HWTXBUF_TXBURST_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWTXBUF_TXBURST_MASK) | (((uint32_t)val) << USB2H_HWTXBUF_TXBURST_SHIFT))

//====================================================================
//Register: RX Buffer Parameters Register (HWRXBUF)
//====================================================================

#define  USB2H_HWRXBUF_RESERVED1_MASK 0xffff0000
#define  USB2H_HWRXBUF_RESERVED1_SHIFT 16
#define  USB2H_HWRXBUF_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_HWRXBUF_RESERVED1_MASK) >> USB2H_HWRXBUF_RESERVED1_SHIFT)
#define  USB2H_HWRXBUF_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWRXBUF_RESERVED1_MASK) | (((uint32_t)val) << USB2H_HWRXBUF_RESERVED1_SHIFT))

#define  USB2H_HWRXBUF_RXADD_MASK 0xff00
#define  USB2H_HWRXBUF_RXADD_SHIFT 8
#define  USB2H_HWRXBUF_RXADD_MASK_SHIFT(reg) (((reg) & USB2H_HWRXBUF_RXADD_MASK) >> USB2H_HWRXBUF_RXADD_SHIFT)
#define  USB2H_HWRXBUF_RXADD_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWRXBUF_RXADD_MASK) | (((uint32_t)val) << USB2H_HWRXBUF_RXADD_SHIFT))

#define  USB2H_HWRXBUF_RXBURST_MASK 0xff
#define  USB2H_HWRXBUF_RXBURST_SHIFT 0
#define  USB2H_HWRXBUF_RXBURST_MASK_SHIFT(reg) (((reg) & USB2H_HWRXBUF_RXBURST_MASK) >> USB2H_HWRXBUF_RXBURST_SHIFT)
#define  USB2H_HWRXBUF_RXBURST_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HWRXBUF_RXBURST_MASK) | (((uint32_t)val) << USB2H_HWRXBUF_RXBURST_SHIFT))

//====================================================================
//Register: System Bus Control Register (SBUSCFG)
//====================================================================

#define  USB2H_SBUSCFG_RESERVED1_MASK 0xfffffff8
#define  USB2H_SBUSCFG_RESERVED1_SHIFT 3
#define  USB2H_SBUSCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_SBUSCFG_RESERVED1_MASK) >> USB2H_SBUSCFG_RESERVED1_SHIFT)
#define  USB2H_SBUSCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_SBUSCFG_RESERVED1_MASK) | (((uint32_t)val) << USB2H_SBUSCFG_RESERVED1_SHIFT))

#define  USB2H_SBUSCFG_AHBBRST_MASK 0x7
#define  USB2H_SBUSCFG_AHBBRST_SHIFT 0
#define  USB2H_SBUSCFG_AHBBRST_MASK_SHIFT(reg) (((reg) & USB2H_SBUSCFG_AHBBRST_MASK) >> USB2H_SBUSCFG_AHBBRST_SHIFT)
#define  USB2H_SBUSCFG_AHBBRST_REPLACE_VAL(reg,val) (((reg) & ~USB2H_SBUSCFG_AHBBRST_MASK) | (((uint32_t)val) << USB2H_SBUSCFG_AHBBRST_SHIFT))

//====================================================================
//Register: Timer 0 Duration Register (GPTIMER0LD)
//====================================================================

#define  USB2H_GPTIMER0LD_RESERVED1_MASK 0xff000000
#define  USB2H_GPTIMER0LD_RESERVED1_SHIFT 24
#define  USB2H_GPTIMER0LD_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_GPTIMER0LD_RESERVED1_MASK) >> USB2H_GPTIMER0LD_RESERVED1_SHIFT)
#define  USB2H_GPTIMER0LD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_GPTIMER0LD_RESERVED1_MASK) | (((uint32_t)val) << USB2H_GPTIMER0LD_RESERVED1_SHIFT))

#define  USB2H_GPTIMER0LD_GPTLD_MASK 0xffffff
#define  USB2H_GPTIMER0LD_GPTLD_SHIFT 0
#define  USB2H_GPTIMER0LD_GPTLD_MASK_SHIFT(reg) (((reg) & USB2H_GPTIMER0LD_GPTLD_MASK) >> USB2H_GPTIMER0LD_GPTLD_SHIFT)
#define  USB2H_GPTIMER0LD_GPTLD_REPLACE_VAL(reg,val) (((reg) & ~USB2H_GPTIMER0LD_GPTLD_MASK) | (((uint32_t)val) << USB2H_GPTIMER0LD_GPTLD_SHIFT))

//====================================================================
//Register: Timer 0 Control Register (GPTIMER0CTRL)
//====================================================================

#define  USB2H_GPTIMER0CTRL_GPTRUN_MASK 0x80000000
#define  USB2H_GPTIMER0CTRL_GPTRUN_SHIFT 31
#define  USB2H_GPTIMER0CTRL_GPTRUN_MASK_SHIFT(reg) (((reg) & USB2H_GPTIMER0CTRL_GPTRUN_MASK) >> USB2H_GPTIMER0CTRL_GPTRUN_SHIFT)
#define  USB2H_GPTIMER0CTRL_GPTRUN_REPLACE_VAL(reg,val) (((reg) & ~USB2H_GPTIMER0CTRL_GPTRUN_MASK) | (((uint32_t)val) << USB2H_GPTIMER0CTRL_GPTRUN_SHIFT))

#define  USB2H_GPTIMER0CTRL_GPTRST_MASK 0x40000000
#define  USB2H_GPTIMER0CTRL_GPTRST_SHIFT 30
#define  USB2H_GPTIMER0CTRL_GPTRST_MASK_SHIFT(reg) (((reg) & USB2H_GPTIMER0CTRL_GPTRST_MASK) >> USB2H_GPTIMER0CTRL_GPTRST_SHIFT)
#define  USB2H_GPTIMER0CTRL_GPTRST_REPLACE_VAL(reg,val) (((reg) & ~USB2H_GPTIMER0CTRL_GPTRST_MASK) | (((uint32_t)val) << USB2H_GPTIMER0CTRL_GPTRST_SHIFT))

#define  USB2H_GPTIMER0CTRL_RESERVED1_MASK 0x3e000000
#define  USB2H_GPTIMER0CTRL_RESERVED1_SHIFT 25
#define  USB2H_GPTIMER0CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_GPTIMER0CTRL_RESERVED1_MASK) >> USB2H_GPTIMER0CTRL_RESERVED1_SHIFT)
#define  USB2H_GPTIMER0CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_GPTIMER0CTRL_RESERVED1_MASK) | (((uint32_t)val) << USB2H_GPTIMER0CTRL_RESERVED1_SHIFT))

#define  USB2H_GPTIMER0CTRL_GPTMODE_MASK 0x1000000
#define  USB2H_GPTIMER0CTRL_GPTMODE_SHIFT 24
#define  USB2H_GPTIMER0CTRL_GPTMODE_MASK_SHIFT(reg) (((reg) & USB2H_GPTIMER0CTRL_GPTMODE_MASK) >> USB2H_GPTIMER0CTRL_GPTMODE_SHIFT)
#define  USB2H_GPTIMER0CTRL_GPTMODE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_GPTIMER0CTRL_GPTMODE_MASK) | (((uint32_t)val) << USB2H_GPTIMER0CTRL_GPTMODE_SHIFT))

#define  USB2H_GPTIMER0CTRL_GPTCNT_MASK 0xffffff
#define  USB2H_GPTIMER0CTRL_GPTCNT_SHIFT 0
#define  USB2H_GPTIMER0CTRL_GPTCNT_MASK_SHIFT(reg) (((reg) & USB2H_GPTIMER0CTRL_GPTCNT_MASK) >> USB2H_GPTIMER0CTRL_GPTCNT_SHIFT)
#define  USB2H_GPTIMER0CTRL_GPTCNT_REPLACE_VAL(reg,val) (((reg) & ~USB2H_GPTIMER0CTRL_GPTCNT_MASK) | (((uint32_t)val) << USB2H_GPTIMER0CTRL_GPTCNT_SHIFT))

//====================================================================
//Register: Timer 1 Duration Register (GPTIMER1LD)
//====================================================================

#define  USB2H_GPTIMER1LD_RESERVED1_MASK 0xff000000
#define  USB2H_GPTIMER1LD_RESERVED1_SHIFT 24
#define  USB2H_GPTIMER1LD_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_GPTIMER1LD_RESERVED1_MASK) >> USB2H_GPTIMER1LD_RESERVED1_SHIFT)
#define  USB2H_GPTIMER1LD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_GPTIMER1LD_RESERVED1_MASK) | (((uint32_t)val) << USB2H_GPTIMER1LD_RESERVED1_SHIFT))

#define  USB2H_GPTIMER1LD_GPTLD_MASK 0xffffff
#define  USB2H_GPTIMER1LD_GPTLD_SHIFT 0
#define  USB2H_GPTIMER1LD_GPTLD_MASK_SHIFT(reg) (((reg) & USB2H_GPTIMER1LD_GPTLD_MASK) >> USB2H_GPTIMER1LD_GPTLD_SHIFT)
#define  USB2H_GPTIMER1LD_GPTLD_REPLACE_VAL(reg,val) (((reg) & ~USB2H_GPTIMER1LD_GPTLD_MASK) | (((uint32_t)val) << USB2H_GPTIMER1LD_GPTLD_SHIFT))

//====================================================================
//Register: Timer 1 Control Register (GPTIMER1CTRL)
//====================================================================

#define  USB2H_GPTIMER1CTRL_GPTRUN_MASK 0x80000000
#define  USB2H_GPTIMER1CTRL_GPTRUN_SHIFT 31
#define  USB2H_GPTIMER1CTRL_GPTRUN_MASK_SHIFT(reg) (((reg) & USB2H_GPTIMER1CTRL_GPTRUN_MASK) >> USB2H_GPTIMER1CTRL_GPTRUN_SHIFT)
#define  USB2H_GPTIMER1CTRL_GPTRUN_REPLACE_VAL(reg,val) (((reg) & ~USB2H_GPTIMER1CTRL_GPTRUN_MASK) | (((uint32_t)val) << USB2H_GPTIMER1CTRL_GPTRUN_SHIFT))

#define  USB2H_GPTIMER1CTRL_GPTRST_MASK 0x40000000
#define  USB2H_GPTIMER1CTRL_GPTRST_SHIFT 30
#define  USB2H_GPTIMER1CTRL_GPTRST_MASK_SHIFT(reg) (((reg) & USB2H_GPTIMER1CTRL_GPTRST_MASK) >> USB2H_GPTIMER1CTRL_GPTRST_SHIFT)
#define  USB2H_GPTIMER1CTRL_GPTRST_REPLACE_VAL(reg,val) (((reg) & ~USB2H_GPTIMER1CTRL_GPTRST_MASK) | (((uint32_t)val) << USB2H_GPTIMER1CTRL_GPTRST_SHIFT))

#define  USB2H_GPTIMER1CTRL_RESERVED1_MASK 0x3e000000
#define  USB2H_GPTIMER1CTRL_RESERVED1_SHIFT 25
#define  USB2H_GPTIMER1CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_GPTIMER1CTRL_RESERVED1_MASK) >> USB2H_GPTIMER1CTRL_RESERVED1_SHIFT)
#define  USB2H_GPTIMER1CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_GPTIMER1CTRL_RESERVED1_MASK) | (((uint32_t)val) << USB2H_GPTIMER1CTRL_RESERVED1_SHIFT))

#define  USB2H_GPTIMER1CTRL_GPTMODE_MASK 0x1000000
#define  USB2H_GPTIMER1CTRL_GPTMODE_SHIFT 24
#define  USB2H_GPTIMER1CTRL_GPTMODE_MASK_SHIFT(reg) (((reg) & USB2H_GPTIMER1CTRL_GPTMODE_MASK) >> USB2H_GPTIMER1CTRL_GPTMODE_SHIFT)
#define  USB2H_GPTIMER1CTRL_GPTMODE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_GPTIMER1CTRL_GPTMODE_MASK) | (((uint32_t)val) << USB2H_GPTIMER1CTRL_GPTMODE_SHIFT))

#define  USB2H_GPTIMER1CTRL_GPTCNT_MASK 0xffffff
#define  USB2H_GPTIMER1CTRL_GPTCNT_SHIFT 0
#define  USB2H_GPTIMER1CTRL_GPTCNT_MASK_SHIFT(reg) (((reg) & USB2H_GPTIMER1CTRL_GPTCNT_MASK) >> USB2H_GPTIMER1CTRL_GPTCNT_SHIFT)
#define  USB2H_GPTIMER1CTRL_GPTCNT_REPLACE_VAL(reg,val) (((reg) & ~USB2H_GPTIMER1CTRL_GPTCNT_MASK) | (((uint32_t)val) << USB2H_GPTIMER1CTRL_GPTCNT_SHIFT))

//====================================================================
//Register: EHCI Version / Capability Length Register (HCIV_CAPLENGTH)
//====================================================================

#define  USB2H_HCIV_CAPLENGTH_HCIVERSION_MASK 0xffff0000
#define  USB2H_HCIV_CAPLENGTH_HCIVERSION_SHIFT 16
#define  USB2H_HCIV_CAPLENGTH_HCIVERSION_MASK_SHIFT(reg) (((reg) & USB2H_HCIV_CAPLENGTH_HCIVERSION_MASK) >> USB2H_HCIV_CAPLENGTH_HCIVERSION_SHIFT)
#define  USB2H_HCIV_CAPLENGTH_HCIVERSION_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCIV_CAPLENGTH_HCIVERSION_MASK) | (((uint32_t)val) << USB2H_HCIV_CAPLENGTH_HCIVERSION_SHIFT))

#define  USB2H_HCIV_CAPLENGTH_RESERVED1_MASK 0xff00
#define  USB2H_HCIV_CAPLENGTH_RESERVED1_SHIFT 8
#define  USB2H_HCIV_CAPLENGTH_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_HCIV_CAPLENGTH_RESERVED1_MASK) >> USB2H_HCIV_CAPLENGTH_RESERVED1_SHIFT)
#define  USB2H_HCIV_CAPLENGTH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCIV_CAPLENGTH_RESERVED1_MASK) | (((uint32_t)val) << USB2H_HCIV_CAPLENGTH_RESERVED1_SHIFT))

#define  USB2H_HCIV_CAPLENGTH_CAPLENGTH_MASK 0xff
#define  USB2H_HCIV_CAPLENGTH_CAPLENGTH_SHIFT 0
#define  USB2H_HCIV_CAPLENGTH_CAPLENGTH_MASK_SHIFT(reg) (((reg) & USB2H_HCIV_CAPLENGTH_CAPLENGTH_MASK) >> USB2H_HCIV_CAPLENGTH_CAPLENGTH_SHIFT)
#define  USB2H_HCIV_CAPLENGTH_CAPLENGTH_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCIV_CAPLENGTH_CAPLENGTH_MASK) | (((uint32_t)val) << USB2H_HCIV_CAPLENGTH_CAPLENGTH_SHIFT))

//====================================================================
//Register: Host Control Structural Parameters Register (HCSPARAMS)
//====================================================================

#define  USB2H_HCSPARAMS_RESERVED1_MASK 0xf0000000
#define  USB2H_HCSPARAMS_RESERVED1_SHIFT 28
#define  USB2H_HCSPARAMS_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_HCSPARAMS_RESERVED1_MASK) >> USB2H_HCSPARAMS_RESERVED1_SHIFT)
#define  USB2H_HCSPARAMS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCSPARAMS_RESERVED1_MASK) | (((uint32_t)val) << USB2H_HCSPARAMS_RESERVED1_SHIFT))

#define  USB2H_HCSPARAMS_NTT_MASK 0xf000000
#define  USB2H_HCSPARAMS_NTT_SHIFT 24
#define  USB2H_HCSPARAMS_NTT_MASK_SHIFT(reg) (((reg) & USB2H_HCSPARAMS_NTT_MASK) >> USB2H_HCSPARAMS_NTT_SHIFT)
#define  USB2H_HCSPARAMS_NTT_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCSPARAMS_NTT_MASK) | (((uint32_t)val) << USB2H_HCSPARAMS_NTT_SHIFT))

#define  USB2H_HCSPARAMS_NPTT_MASK 0xf00000
#define  USB2H_HCSPARAMS_NPTT_SHIFT 20
#define  USB2H_HCSPARAMS_NPTT_MASK_SHIFT(reg) (((reg) & USB2H_HCSPARAMS_NPTT_MASK) >> USB2H_HCSPARAMS_NPTT_SHIFT)
#define  USB2H_HCSPARAMS_NPTT_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCSPARAMS_NPTT_MASK) | (((uint32_t)val) << USB2H_HCSPARAMS_NPTT_SHIFT))

#define  USB2H_HCSPARAMS_RESERVED2_MASK 0xe0000
#define  USB2H_HCSPARAMS_RESERVED2_SHIFT 17
#define  USB2H_HCSPARAMS_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2H_HCSPARAMS_RESERVED2_MASK) >> USB2H_HCSPARAMS_RESERVED2_SHIFT)
#define  USB2H_HCSPARAMS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCSPARAMS_RESERVED2_MASK) | (((uint32_t)val) << USB2H_HCSPARAMS_RESERVED2_SHIFT))

#define  USB2H_HCSPARAMS_PI_MASK 0x10000
#define  USB2H_HCSPARAMS_PI_SHIFT 16
#define  USB2H_HCSPARAMS_PI_MASK_SHIFT(reg) (((reg) & USB2H_HCSPARAMS_PI_MASK) >> USB2H_HCSPARAMS_PI_SHIFT)
#define  USB2H_HCSPARAMS_PI_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCSPARAMS_PI_MASK) | (((uint32_t)val) << USB2H_HCSPARAMS_PI_SHIFT))

#define  USB2H_HCSPARAMS_NCC_MASK 0xf000
#define  USB2H_HCSPARAMS_NCC_SHIFT 12
#define  USB2H_HCSPARAMS_NCC_MASK_SHIFT(reg) (((reg) & USB2H_HCSPARAMS_NCC_MASK) >> USB2H_HCSPARAMS_NCC_SHIFT)
#define  USB2H_HCSPARAMS_NCC_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCSPARAMS_NCC_MASK) | (((uint32_t)val) << USB2H_HCSPARAMS_NCC_SHIFT))

#define  USB2H_HCSPARAMS_NPCC_MASK 0xf00
#define  USB2H_HCSPARAMS_NPCC_SHIFT 8
#define  USB2H_HCSPARAMS_NPCC_MASK_SHIFT(reg) (((reg) & USB2H_HCSPARAMS_NPCC_MASK) >> USB2H_HCSPARAMS_NPCC_SHIFT)
#define  USB2H_HCSPARAMS_NPCC_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCSPARAMS_NPCC_MASK) | (((uint32_t)val) << USB2H_HCSPARAMS_NPCC_SHIFT))

#define  USB2H_HCSPARAMS_RESERVED3_MASK 0xe0
#define  USB2H_HCSPARAMS_RESERVED3_SHIFT 5
#define  USB2H_HCSPARAMS_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2H_HCSPARAMS_RESERVED3_MASK) >> USB2H_HCSPARAMS_RESERVED3_SHIFT)
#define  USB2H_HCSPARAMS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCSPARAMS_RESERVED3_MASK) | (((uint32_t)val) << USB2H_HCSPARAMS_RESERVED3_SHIFT))

#define  USB2H_HCSPARAMS_PPC_MASK 0x10
#define  USB2H_HCSPARAMS_PPC_SHIFT 4
#define  USB2H_HCSPARAMS_PPC_MASK_SHIFT(reg) (((reg) & USB2H_HCSPARAMS_PPC_MASK) >> USB2H_HCSPARAMS_PPC_SHIFT)
#define  USB2H_HCSPARAMS_PPC_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCSPARAMS_PPC_MASK) | (((uint32_t)val) << USB2H_HCSPARAMS_PPC_SHIFT))

#define  USB2H_HCSPARAMS_NPORTS_MASK 0xf
#define  USB2H_HCSPARAMS_NPORTS_SHIFT 0
#define  USB2H_HCSPARAMS_NPORTS_MASK_SHIFT(reg) (((reg) & USB2H_HCSPARAMS_NPORTS_MASK) >> USB2H_HCSPARAMS_NPORTS_SHIFT)
#define  USB2H_HCSPARAMS_NPORTS_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCSPARAMS_NPORTS_MASK) | (((uint32_t)val) << USB2H_HCSPARAMS_NPORTS_SHIFT))

//====================================================================
//Register: Host Control Capability Parameters Register (HCCPARAMS)
//====================================================================

#define  USB2H_HCCPARAMS_RESERVED1_MASK 0xffff0000
#define  USB2H_HCCPARAMS_RESERVED1_SHIFT 16
#define  USB2H_HCCPARAMS_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_HCCPARAMS_RESERVED1_MASK) >> USB2H_HCCPARAMS_RESERVED1_SHIFT)
#define  USB2H_HCCPARAMS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCCPARAMS_RESERVED1_MASK) | (((uint32_t)val) << USB2H_HCCPARAMS_RESERVED1_SHIFT))

#define  USB2H_HCCPARAMS_EECP_MASK 0xff00
#define  USB2H_HCCPARAMS_EECP_SHIFT 8
#define  USB2H_HCCPARAMS_EECP_MASK_SHIFT(reg) (((reg) & USB2H_HCCPARAMS_EECP_MASK) >> USB2H_HCCPARAMS_EECP_SHIFT)
#define  USB2H_HCCPARAMS_EECP_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCCPARAMS_EECP_MASK) | (((uint32_t)val) << USB2H_HCCPARAMS_EECP_SHIFT))

#define  USB2H_HCCPARAMS_IST_MASK 0xf0
#define  USB2H_HCCPARAMS_IST_SHIFT 4
#define  USB2H_HCCPARAMS_IST_MASK_SHIFT(reg) (((reg) & USB2H_HCCPARAMS_IST_MASK) >> USB2H_HCCPARAMS_IST_SHIFT)
#define  USB2H_HCCPARAMS_IST_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCCPARAMS_IST_MASK) | (((uint32_t)val) << USB2H_HCCPARAMS_IST_SHIFT))

#define  USB2H_HCCPARAMS_RESERVED2_MASK 0x8
#define  USB2H_HCCPARAMS_RESERVED2_SHIFT 3
#define  USB2H_HCCPARAMS_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2H_HCCPARAMS_RESERVED2_MASK) >> USB2H_HCCPARAMS_RESERVED2_SHIFT)
#define  USB2H_HCCPARAMS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCCPARAMS_RESERVED2_MASK) | (((uint32_t)val) << USB2H_HCCPARAMS_RESERVED2_SHIFT))

#define  USB2H_HCCPARAMS_ASP_MASK 0x4
#define  USB2H_HCCPARAMS_ASP_SHIFT 2
#define  USB2H_HCCPARAMS_ASP_MASK_SHIFT(reg) (((reg) & USB2H_HCCPARAMS_ASP_MASK) >> USB2H_HCCPARAMS_ASP_SHIFT)
#define  USB2H_HCCPARAMS_ASP_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCCPARAMS_ASP_MASK) | (((uint32_t)val) << USB2H_HCCPARAMS_ASP_SHIFT))

#define  USB2H_HCCPARAMS_PFL_MASK 0x2
#define  USB2H_HCCPARAMS_PFL_SHIFT 1
#define  USB2H_HCCPARAMS_PFL_MASK_SHIFT(reg) (((reg) & USB2H_HCCPARAMS_PFL_MASK) >> USB2H_HCCPARAMS_PFL_SHIFT)
#define  USB2H_HCCPARAMS_PFL_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCCPARAMS_PFL_MASK) | (((uint32_t)val) << USB2H_HCCPARAMS_PFL_SHIFT))

#define  USB2H_HCCPARAMS_ADC_MASK 0x1
#define  USB2H_HCCPARAMS_ADC_SHIFT 0
#define  USB2H_HCCPARAMS_ADC_MASK_SHIFT(reg) (((reg) & USB2H_HCCPARAMS_ADC_MASK) >> USB2H_HCCPARAMS_ADC_SHIFT)
#define  USB2H_HCCPARAMS_ADC_REPLACE_VAL(reg,val) (((reg) & ~USB2H_HCCPARAMS_ADC_MASK) | (((uint32_t)val) << USB2H_HCCPARAMS_ADC_SHIFT))

//====================================================================
//Register: USB Command Register (USBCMD)
//====================================================================

#define  USB2H_USBCMD_RESERVED1_MASK 0xff000000
#define  USB2H_USBCMD_RESERVED1_SHIFT 24
#define  USB2H_USBCMD_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_USBCMD_RESERVED1_MASK) >> USB2H_USBCMD_RESERVED1_SHIFT)
#define  USB2H_USBCMD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBCMD_RESERVED1_MASK) | (((uint32_t)val) << USB2H_USBCMD_RESERVED1_SHIFT))

#define  USB2H_USBCMD_ITC_MASK 0xff0000
#define  USB2H_USBCMD_ITC_SHIFT 16
#define  USB2H_USBCMD_ITC_MASK_SHIFT(reg) (((reg) & USB2H_USBCMD_ITC_MASK) >> USB2H_USBCMD_ITC_SHIFT)
#define  USB2H_USBCMD_ITC_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBCMD_ITC_MASK) | (((uint32_t)val) << USB2H_USBCMD_ITC_SHIFT))

#define  USB2H_USBCMD_FS2_MASK 0x8000
#define  USB2H_USBCMD_FS2_SHIFT 15
#define  USB2H_USBCMD_FS2_MASK_SHIFT(reg) (((reg) & USB2H_USBCMD_FS2_MASK) >> USB2H_USBCMD_FS2_SHIFT)
#define  USB2H_USBCMD_FS2_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBCMD_FS2_MASK) | (((uint32_t)val) << USB2H_USBCMD_FS2_SHIFT))

#define  USB2H_USBCMD_ATDTW_MASK 0x4000
#define  USB2H_USBCMD_ATDTW_SHIFT 14
#define  USB2H_USBCMD_ATDTW_MASK_SHIFT(reg) (((reg) & USB2H_USBCMD_ATDTW_MASK) >> USB2H_USBCMD_ATDTW_SHIFT)
#define  USB2H_USBCMD_ATDTW_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBCMD_ATDTW_MASK) | (((uint32_t)val) << USB2H_USBCMD_ATDTW_SHIFT))

#define  USB2H_USBCMD_SUTW_MASK 0x2000
#define  USB2H_USBCMD_SUTW_SHIFT 13
#define  USB2H_USBCMD_SUTW_MASK_SHIFT(reg) (((reg) & USB2H_USBCMD_SUTW_MASK) >> USB2H_USBCMD_SUTW_SHIFT)
#define  USB2H_USBCMD_SUTW_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBCMD_SUTW_MASK) | (((uint32_t)val) << USB2H_USBCMD_SUTW_SHIFT))

#define  USB2H_USBCMD_RESERVED2_MASK 0x1000
#define  USB2H_USBCMD_RESERVED2_SHIFT 12
#define  USB2H_USBCMD_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2H_USBCMD_RESERVED2_MASK) >> USB2H_USBCMD_RESERVED2_SHIFT)
#define  USB2H_USBCMD_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBCMD_RESERVED2_MASK) | (((uint32_t)val) << USB2H_USBCMD_RESERVED2_SHIFT))

#define  USB2H_USBCMD_ASPE_MASK 0x800
#define  USB2H_USBCMD_ASPE_SHIFT 11
#define  USB2H_USBCMD_ASPE_MASK_SHIFT(reg) (((reg) & USB2H_USBCMD_ASPE_MASK) >> USB2H_USBCMD_ASPE_SHIFT)
#define  USB2H_USBCMD_ASPE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBCMD_ASPE_MASK) | (((uint32_t)val) << USB2H_USBCMD_ASPE_SHIFT))

#define  USB2H_USBCMD_RESERVED3_MASK 0x400
#define  USB2H_USBCMD_RESERVED3_SHIFT 10
#define  USB2H_USBCMD_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2H_USBCMD_RESERVED3_MASK) >> USB2H_USBCMD_RESERVED3_SHIFT)
#define  USB2H_USBCMD_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBCMD_RESERVED3_MASK) | (((uint32_t)val) << USB2H_USBCMD_RESERVED3_SHIFT))

#define  USB2H_USBCMD_ASP_MASK 0x300
#define  USB2H_USBCMD_ASP_SHIFT 8
#define  USB2H_USBCMD_ASP_MASK_SHIFT(reg) (((reg) & USB2H_USBCMD_ASP_MASK) >> USB2H_USBCMD_ASP_SHIFT)
#define  USB2H_USBCMD_ASP_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBCMD_ASP_MASK) | (((uint32_t)val) << USB2H_USBCMD_ASP_SHIFT))

#define  USB2H_USBCMD_LR_MASK 0x80
#define  USB2H_USBCMD_LR_SHIFT 7
#define  USB2H_USBCMD_LR_MASK_SHIFT(reg) (((reg) & USB2H_USBCMD_LR_MASK) >> USB2H_USBCMD_LR_SHIFT)
#define  USB2H_USBCMD_LR_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBCMD_LR_MASK) | (((uint32_t)val) << USB2H_USBCMD_LR_SHIFT))

#define  USB2H_USBCMD_IAA_MASK 0x40
#define  USB2H_USBCMD_IAA_SHIFT 6
#define  USB2H_USBCMD_IAA_MASK_SHIFT(reg) (((reg) & USB2H_USBCMD_IAA_MASK) >> USB2H_USBCMD_IAA_SHIFT)
#define  USB2H_USBCMD_IAA_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBCMD_IAA_MASK) | (((uint32_t)val) << USB2H_USBCMD_IAA_SHIFT))

#define  USB2H_USBCMD_ASE_MASK 0x20
#define  USB2H_USBCMD_ASE_SHIFT 5
#define  USB2H_USBCMD_ASE_MASK_SHIFT(reg) (((reg) & USB2H_USBCMD_ASE_MASK) >> USB2H_USBCMD_ASE_SHIFT)
#define  USB2H_USBCMD_ASE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBCMD_ASE_MASK) | (((uint32_t)val) << USB2H_USBCMD_ASE_SHIFT))

#define  USB2H_USBCMD_PSE_MASK 0x10
#define  USB2H_USBCMD_PSE_SHIFT 4
#define  USB2H_USBCMD_PSE_MASK_SHIFT(reg) (((reg) & USB2H_USBCMD_PSE_MASK) >> USB2H_USBCMD_PSE_SHIFT)
#define  USB2H_USBCMD_PSE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBCMD_PSE_MASK) | (((uint32_t)val) << USB2H_USBCMD_PSE_SHIFT))

#define  USB2H_USBCMD_FS1_MASK 0x8
#define  USB2H_USBCMD_FS1_SHIFT 3
#define  USB2H_USBCMD_FS1_MASK_SHIFT(reg) (((reg) & USB2H_USBCMD_FS1_MASK) >> USB2H_USBCMD_FS1_SHIFT)
#define  USB2H_USBCMD_FS1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBCMD_FS1_MASK) | (((uint32_t)val) << USB2H_USBCMD_FS1_SHIFT))

#define  USB2H_USBCMD_FS0_MASK 0x4
#define  USB2H_USBCMD_FS0_SHIFT 2
#define  USB2H_USBCMD_FS0_MASK_SHIFT(reg) (((reg) & USB2H_USBCMD_FS0_MASK) >> USB2H_USBCMD_FS0_SHIFT)
#define  USB2H_USBCMD_FS0_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBCMD_FS0_MASK) | (((uint32_t)val) << USB2H_USBCMD_FS0_SHIFT))

#define  USB2H_USBCMD_RST_MASK 0x2
#define  USB2H_USBCMD_RST_SHIFT 1
#define  USB2H_USBCMD_RST_MASK_SHIFT(reg) (((reg) & USB2H_USBCMD_RST_MASK) >> USB2H_USBCMD_RST_SHIFT)
#define  USB2H_USBCMD_RST_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBCMD_RST_MASK) | (((uint32_t)val) << USB2H_USBCMD_RST_SHIFT))

#define  USB2H_USBCMD_RS_MASK 0x1
#define  USB2H_USBCMD_RS_SHIFT 0
#define  USB2H_USBCMD_RS_MASK_SHIFT(reg) (((reg) & USB2H_USBCMD_RS_MASK) >> USB2H_USBCMD_RS_SHIFT)
#define  USB2H_USBCMD_RS_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBCMD_RS_MASK) | (((uint32_t)val) << USB2H_USBCMD_RS_SHIFT))

//====================================================================
//Register: USB Status Register (USBSTS)
//====================================================================

#define  USB2H_USBSTS_RESERVED1_MASK 0xfc000000
#define  USB2H_USBSTS_RESERVED1_SHIFT 26
#define  USB2H_USBSTS_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_RESERVED1_MASK) >> USB2H_USBSTS_RESERVED1_SHIFT)
#define  USB2H_USBSTS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_RESERVED1_MASK) | (((uint32_t)val) << USB2H_USBSTS_RESERVED1_SHIFT))

#define  USB2H_USBSTS_TI1_MASK 0x2000000
#define  USB2H_USBSTS_TI1_SHIFT 25
#define  USB2H_USBSTS_TI1_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_TI1_MASK) >> USB2H_USBSTS_TI1_SHIFT)
#define  USB2H_USBSTS_TI1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_TI1_MASK) | (((uint32_t)val) << USB2H_USBSTS_TI1_SHIFT))

#define  USB2H_USBSTS_TI0_MASK 0x1000000
#define  USB2H_USBSTS_TI0_SHIFT 24
#define  USB2H_USBSTS_TI0_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_TI0_MASK) >> USB2H_USBSTS_TI0_SHIFT)
#define  USB2H_USBSTS_TI0_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_TI0_MASK) | (((uint32_t)val) << USB2H_USBSTS_TI0_SHIFT))

#define  USB2H_USBSTS_RESERVED2_MASK 0xf00000
#define  USB2H_USBSTS_RESERVED2_SHIFT 20
#define  USB2H_USBSTS_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_RESERVED2_MASK) >> USB2H_USBSTS_RESERVED2_SHIFT)
#define  USB2H_USBSTS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_RESERVED2_MASK) | (((uint32_t)val) << USB2H_USBSTS_RESERVED2_SHIFT))

#define  USB2H_USBSTS_UPI_MASK 0x80000
#define  USB2H_USBSTS_UPI_SHIFT 19
#define  USB2H_USBSTS_UPI_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_UPI_MASK) >> USB2H_USBSTS_UPI_SHIFT)
#define  USB2H_USBSTS_UPI_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_UPI_MASK) | (((uint32_t)val) << USB2H_USBSTS_UPI_SHIFT))

#define  USB2H_USBSTS_UAI_MASK 0x40000
#define  USB2H_USBSTS_UAI_SHIFT 18
#define  USB2H_USBSTS_UAI_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_UAI_MASK) >> USB2H_USBSTS_UAI_SHIFT)
#define  USB2H_USBSTS_UAI_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_UAI_MASK) | (((uint32_t)val) << USB2H_USBSTS_UAI_SHIFT))

#define  USB2H_USBSTS_RESERVED3_MASK 0x20000
#define  USB2H_USBSTS_RESERVED3_SHIFT 17
#define  USB2H_USBSTS_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_RESERVED3_MASK) >> USB2H_USBSTS_RESERVED3_SHIFT)
#define  USB2H_USBSTS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_RESERVED3_MASK) | (((uint32_t)val) << USB2H_USBSTS_RESERVED3_SHIFT))

#define  USB2H_USBSTS_NAKI_MASK 0x10000
#define  USB2H_USBSTS_NAKI_SHIFT 16
#define  USB2H_USBSTS_NAKI_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_NAKI_MASK) >> USB2H_USBSTS_NAKI_SHIFT)
#define  USB2H_USBSTS_NAKI_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_NAKI_MASK) | (((uint32_t)val) << USB2H_USBSTS_NAKI_SHIFT))

#define  USB2H_USBSTS_AS_MASK 0x8000
#define  USB2H_USBSTS_AS_SHIFT 15
#define  USB2H_USBSTS_AS_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_AS_MASK) >> USB2H_USBSTS_AS_SHIFT)
#define  USB2H_USBSTS_AS_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_AS_MASK) | (((uint32_t)val) << USB2H_USBSTS_AS_SHIFT))

#define  USB2H_USBSTS_PS_MASK 0x4000
#define  USB2H_USBSTS_PS_SHIFT 14
#define  USB2H_USBSTS_PS_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_PS_MASK) >> USB2H_USBSTS_PS_SHIFT)
#define  USB2H_USBSTS_PS_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_PS_MASK) | (((uint32_t)val) << USB2H_USBSTS_PS_SHIFT))

#define  USB2H_USBSTS_RCL_MASK 0x2000
#define  USB2H_USBSTS_RCL_SHIFT 13
#define  USB2H_USBSTS_RCL_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_RCL_MASK) >> USB2H_USBSTS_RCL_SHIFT)
#define  USB2H_USBSTS_RCL_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_RCL_MASK) | (((uint32_t)val) << USB2H_USBSTS_RCL_SHIFT))

#define  USB2H_USBSTS_HCH_MASK 0x1000
#define  USB2H_USBSTS_HCH_SHIFT 12
#define  USB2H_USBSTS_HCH_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_HCH_MASK) >> USB2H_USBSTS_HCH_SHIFT)
#define  USB2H_USBSTS_HCH_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_HCH_MASK) | (((uint32_t)val) << USB2H_USBSTS_HCH_SHIFT))

#define  USB2H_USBSTS_RESERVED4_MASK 0x800
#define  USB2H_USBSTS_RESERVED4_SHIFT 11
#define  USB2H_USBSTS_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_RESERVED4_MASK) >> USB2H_USBSTS_RESERVED4_SHIFT)
#define  USB2H_USBSTS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_RESERVED4_MASK) | (((uint32_t)val) << USB2H_USBSTS_RESERVED4_SHIFT))

#define  USB2H_USBSTS_RESERVED5_MASK 0x600
#define  USB2H_USBSTS_RESERVED5_SHIFT 9
#define  USB2H_USBSTS_RESERVED5_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_RESERVED5_MASK) >> USB2H_USBSTS_RESERVED5_SHIFT)
#define  USB2H_USBSTS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_RESERVED5_MASK) | (((uint32_t)val) << USB2H_USBSTS_RESERVED5_SHIFT))

#define  USB2H_USBSTS_SLI_MASK 0x100
#define  USB2H_USBSTS_SLI_SHIFT 8
#define  USB2H_USBSTS_SLI_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_SLI_MASK) >> USB2H_USBSTS_SLI_SHIFT)
#define  USB2H_USBSTS_SLI_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_SLI_MASK) | (((uint32_t)val) << USB2H_USBSTS_SLI_SHIFT))

#define  USB2H_USBSTS_SRI_MASK 0x80
#define  USB2H_USBSTS_SRI_SHIFT 7
#define  USB2H_USBSTS_SRI_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_SRI_MASK) >> USB2H_USBSTS_SRI_SHIFT)
#define  USB2H_USBSTS_SRI_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_SRI_MASK) | (((uint32_t)val) << USB2H_USBSTS_SRI_SHIFT))

#define  USB2H_USBSTS_URI_MASK 0x40
#define  USB2H_USBSTS_URI_SHIFT 6
#define  USB2H_USBSTS_URI_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_URI_MASK) >> USB2H_USBSTS_URI_SHIFT)
#define  USB2H_USBSTS_URI_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_URI_MASK) | (((uint32_t)val) << USB2H_USBSTS_URI_SHIFT))

#define  USB2H_USBSTS_AAI_MASK 0x20
#define  USB2H_USBSTS_AAI_SHIFT 5
#define  USB2H_USBSTS_AAI_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_AAI_MASK) >> USB2H_USBSTS_AAI_SHIFT)
#define  USB2H_USBSTS_AAI_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_AAI_MASK) | (((uint32_t)val) << USB2H_USBSTS_AAI_SHIFT))

#define  USB2H_USBSTS_SEI_MASK 0x10
#define  USB2H_USBSTS_SEI_SHIFT 4
#define  USB2H_USBSTS_SEI_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_SEI_MASK) >> USB2H_USBSTS_SEI_SHIFT)
#define  USB2H_USBSTS_SEI_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_SEI_MASK) | (((uint32_t)val) << USB2H_USBSTS_SEI_SHIFT))

#define  USB2H_USBSTS_FRI_MASK 0x8
#define  USB2H_USBSTS_FRI_SHIFT 3
#define  USB2H_USBSTS_FRI_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_FRI_MASK) >> USB2H_USBSTS_FRI_SHIFT)
#define  USB2H_USBSTS_FRI_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_FRI_MASK) | (((uint32_t)val) << USB2H_USBSTS_FRI_SHIFT))

#define  USB2H_USBSTS_PCI_MASK 0x4
#define  USB2H_USBSTS_PCI_SHIFT 2
#define  USB2H_USBSTS_PCI_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_PCI_MASK) >> USB2H_USBSTS_PCI_SHIFT)
#define  USB2H_USBSTS_PCI_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_PCI_MASK) | (((uint32_t)val) << USB2H_USBSTS_PCI_SHIFT))

#define  USB2H_USBSTS_UEI_MASK 0x2
#define  USB2H_USBSTS_UEI_SHIFT 1
#define  USB2H_USBSTS_UEI_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_UEI_MASK) >> USB2H_USBSTS_UEI_SHIFT)
#define  USB2H_USBSTS_UEI_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_UEI_MASK) | (((uint32_t)val) << USB2H_USBSTS_UEI_SHIFT))

#define  USB2H_USBSTS_UI_MASK 0x1
#define  USB2H_USBSTS_UI_SHIFT 0
#define  USB2H_USBSTS_UI_MASK_SHIFT(reg) (((reg) & USB2H_USBSTS_UI_MASK) >> USB2H_USBSTS_UI_SHIFT)
#define  USB2H_USBSTS_UI_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBSTS_UI_MASK) | (((uint32_t)val) << USB2H_USBSTS_UI_SHIFT))

//====================================================================
//Register: USB Interrupt Enable Register (USBINTR)
//====================================================================

#define  USB2H_USBINTR_RESERVED1_MASK 0xfc000000
#define  USB2H_USBINTR_RESERVED1_SHIFT 26
#define  USB2H_USBINTR_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_USBINTR_RESERVED1_MASK) >> USB2H_USBINTR_RESERVED1_SHIFT)
#define  USB2H_USBINTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBINTR_RESERVED1_MASK) | (((uint32_t)val) << USB2H_USBINTR_RESERVED1_SHIFT))

#define  USB2H_USBINTR_TIE1_MASK 0x2000000
#define  USB2H_USBINTR_TIE1_SHIFT 25
#define  USB2H_USBINTR_TIE1_MASK_SHIFT(reg) (((reg) & USB2H_USBINTR_TIE1_MASK) >> USB2H_USBINTR_TIE1_SHIFT)
#define  USB2H_USBINTR_TIE1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBINTR_TIE1_MASK) | (((uint32_t)val) << USB2H_USBINTR_TIE1_SHIFT))

#define  USB2H_USBINTR_TIE0_MASK 0x1000000
#define  USB2H_USBINTR_TIE0_SHIFT 24
#define  USB2H_USBINTR_TIE0_MASK_SHIFT(reg) (((reg) & USB2H_USBINTR_TIE0_MASK) >> USB2H_USBINTR_TIE0_SHIFT)
#define  USB2H_USBINTR_TIE0_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBINTR_TIE0_MASK) | (((uint32_t)val) << USB2H_USBINTR_TIE0_SHIFT))

#define  USB2H_USBINTR_RESERVED2_MASK 0xf00000
#define  USB2H_USBINTR_RESERVED2_SHIFT 20
#define  USB2H_USBINTR_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2H_USBINTR_RESERVED2_MASK) >> USB2H_USBINTR_RESERVED2_SHIFT)
#define  USB2H_USBINTR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBINTR_RESERVED2_MASK) | (((uint32_t)val) << USB2H_USBINTR_RESERVED2_SHIFT))

#define  USB2H_USBINTR_UPIE_MASK 0x80000
#define  USB2H_USBINTR_UPIE_SHIFT 19
#define  USB2H_USBINTR_UPIE_MASK_SHIFT(reg) (((reg) & USB2H_USBINTR_UPIE_MASK) >> USB2H_USBINTR_UPIE_SHIFT)
#define  USB2H_USBINTR_UPIE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBINTR_UPIE_MASK) | (((uint32_t)val) << USB2H_USBINTR_UPIE_SHIFT))

#define  USB2H_USBINTR_UAIE_MASK 0x40000
#define  USB2H_USBINTR_UAIE_SHIFT 18
#define  USB2H_USBINTR_UAIE_MASK_SHIFT(reg) (((reg) & USB2H_USBINTR_UAIE_MASK) >> USB2H_USBINTR_UAIE_SHIFT)
#define  USB2H_USBINTR_UAIE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBINTR_UAIE_MASK) | (((uint32_t)val) << USB2H_USBINTR_UAIE_SHIFT))

#define  USB2H_USBINTR_RESERVED3_MASK 0x20000
#define  USB2H_USBINTR_RESERVED3_SHIFT 17
#define  USB2H_USBINTR_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2H_USBINTR_RESERVED3_MASK) >> USB2H_USBINTR_RESERVED3_SHIFT)
#define  USB2H_USBINTR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBINTR_RESERVED3_MASK) | (((uint32_t)val) << USB2H_USBINTR_RESERVED3_SHIFT))

#define  USB2H_USBINTR_NAKE_MASK 0x10000
#define  USB2H_USBINTR_NAKE_SHIFT 16
#define  USB2H_USBINTR_NAKE_MASK_SHIFT(reg) (((reg) & USB2H_USBINTR_NAKE_MASK) >> USB2H_USBINTR_NAKE_SHIFT)
#define  USB2H_USBINTR_NAKE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBINTR_NAKE_MASK) | (((uint32_t)val) << USB2H_USBINTR_NAKE_SHIFT))

#define  USB2H_USBINTR_RESERVED4_MASK 0xfe00
#define  USB2H_USBINTR_RESERVED4_SHIFT 9
#define  USB2H_USBINTR_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2H_USBINTR_RESERVED4_MASK) >> USB2H_USBINTR_RESERVED4_SHIFT)
#define  USB2H_USBINTR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBINTR_RESERVED4_MASK) | (((uint32_t)val) << USB2H_USBINTR_RESERVED4_SHIFT))

#define  USB2H_USBINTR_SLE_MASK 0x100
#define  USB2H_USBINTR_SLE_SHIFT 8
#define  USB2H_USBINTR_SLE_MASK_SHIFT(reg) (((reg) & USB2H_USBINTR_SLE_MASK) >> USB2H_USBINTR_SLE_SHIFT)
#define  USB2H_USBINTR_SLE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBINTR_SLE_MASK) | (((uint32_t)val) << USB2H_USBINTR_SLE_SHIFT))

#define  USB2H_USBINTR_SRE_MASK 0x80
#define  USB2H_USBINTR_SRE_SHIFT 7
#define  USB2H_USBINTR_SRE_MASK_SHIFT(reg) (((reg) & USB2H_USBINTR_SRE_MASK) >> USB2H_USBINTR_SRE_SHIFT)
#define  USB2H_USBINTR_SRE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBINTR_SRE_MASK) | (((uint32_t)val) << USB2H_USBINTR_SRE_SHIFT))

#define  USB2H_USBINTR_URE_MASK 0x40
#define  USB2H_USBINTR_URE_SHIFT 6
#define  USB2H_USBINTR_URE_MASK_SHIFT(reg) (((reg) & USB2H_USBINTR_URE_MASK) >> USB2H_USBINTR_URE_SHIFT)
#define  USB2H_USBINTR_URE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBINTR_URE_MASK) | (((uint32_t)val) << USB2H_USBINTR_URE_SHIFT))

#define  USB2H_USBINTR_AAE_MASK 0x20
#define  USB2H_USBINTR_AAE_SHIFT 5
#define  USB2H_USBINTR_AAE_MASK_SHIFT(reg) (((reg) & USB2H_USBINTR_AAE_MASK) >> USB2H_USBINTR_AAE_SHIFT)
#define  USB2H_USBINTR_AAE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBINTR_AAE_MASK) | (((uint32_t)val) << USB2H_USBINTR_AAE_SHIFT))

#define  USB2H_USBINTR_SEE_MASK 0x10
#define  USB2H_USBINTR_SEE_SHIFT 4
#define  USB2H_USBINTR_SEE_MASK_SHIFT(reg) (((reg) & USB2H_USBINTR_SEE_MASK) >> USB2H_USBINTR_SEE_SHIFT)
#define  USB2H_USBINTR_SEE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBINTR_SEE_MASK) | (((uint32_t)val) << USB2H_USBINTR_SEE_SHIFT))

#define  USB2H_USBINTR_FRE_MASK 0x8
#define  USB2H_USBINTR_FRE_SHIFT 3
#define  USB2H_USBINTR_FRE_MASK_SHIFT(reg) (((reg) & USB2H_USBINTR_FRE_MASK) >> USB2H_USBINTR_FRE_SHIFT)
#define  USB2H_USBINTR_FRE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBINTR_FRE_MASK) | (((uint32_t)val) << USB2H_USBINTR_FRE_SHIFT))

#define  USB2H_USBINTR_PCE_MASK 0x4
#define  USB2H_USBINTR_PCE_SHIFT 2
#define  USB2H_USBINTR_PCE_MASK_SHIFT(reg) (((reg) & USB2H_USBINTR_PCE_MASK) >> USB2H_USBINTR_PCE_SHIFT)
#define  USB2H_USBINTR_PCE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBINTR_PCE_MASK) | (((uint32_t)val) << USB2H_USBINTR_PCE_SHIFT))

#define  USB2H_USBINTR_UEE_MASK 0x2
#define  USB2H_USBINTR_UEE_SHIFT 1
#define  USB2H_USBINTR_UEE_MASK_SHIFT(reg) (((reg) & USB2H_USBINTR_UEE_MASK) >> USB2H_USBINTR_UEE_SHIFT)
#define  USB2H_USBINTR_UEE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBINTR_UEE_MASK) | (((uint32_t)val) << USB2H_USBINTR_UEE_SHIFT))

#define  USB2H_USBINTR_UE_MASK 0x1
#define  USB2H_USBINTR_UE_SHIFT 0
#define  USB2H_USBINTR_UE_MASK_SHIFT(reg) (((reg) & USB2H_USBINTR_UE_MASK) >> USB2H_USBINTR_UE_SHIFT)
#define  USB2H_USBINTR_UE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBINTR_UE_MASK) | (((uint32_t)val) << USB2H_USBINTR_UE_SHIFT))

//====================================================================
//Register: Frame Index Register (FRINDEX)
//====================================================================

#define  USB2H_FRINDEX_RESERVED1_MASK 0xffffc000
#define  USB2H_FRINDEX_RESERVED1_SHIFT 14
#define  USB2H_FRINDEX_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_FRINDEX_RESERVED1_MASK) >> USB2H_FRINDEX_RESERVED1_SHIFT)
#define  USB2H_FRINDEX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_FRINDEX_RESERVED1_MASK) | (((uint32_t)val) << USB2H_FRINDEX_RESERVED1_SHIFT))

#define  USB2H_FRINDEX_FRINDEX_MASK 0x3fff
#define  USB2H_FRINDEX_FRINDEX_SHIFT 0
#define  USB2H_FRINDEX_FRINDEX_MASK_SHIFT(reg) (((reg) & USB2H_FRINDEX_FRINDEX_MASK) >> USB2H_FRINDEX_FRINDEX_SHIFT)
#define  USB2H_FRINDEX_FRINDEX_REPLACE_VAL(reg,val) (((reg) & ~USB2H_FRINDEX_FRINDEX_MASK) | (((uint32_t)val) << USB2H_FRINDEX_FRINDEX_SHIFT))

//====================================================================
//Register: Host Controller Frame List Base Address Register (PLISTBASE)
//====================================================================

#define  USB2H_PLISTBASE_PERBASE_MASK 0xfffff000
#define  USB2H_PLISTBASE_PERBASE_SHIFT 12
#define  USB2H_PLISTBASE_PERBASE_MASK_SHIFT(reg) (((reg) & USB2H_PLISTBASE_PERBASE_MASK) >> USB2H_PLISTBASE_PERBASE_SHIFT)
#define  USB2H_PLISTBASE_PERBASE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PLISTBASE_PERBASE_MASK) | (((uint32_t)val) << USB2H_PLISTBASE_PERBASE_SHIFT))

#define  USB2H_PLISTBASE_RESERVED1_MASK 0xfff
#define  USB2H_PLISTBASE_RESERVED1_SHIFT 0
#define  USB2H_PLISTBASE_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_PLISTBASE_RESERVED1_MASK) >> USB2H_PLISTBASE_RESERVED1_SHIFT)
#define  USB2H_PLISTBASE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PLISTBASE_RESERVED1_MASK) | (((uint32_t)val) << USB2H_PLISTBASE_RESERVED1_SHIFT))

//====================================================================
//Register: Host Controller Next Asynch Address Register (ASYNCLISTADDR)
//====================================================================

#define  USB2H_ASYNCLISTADDR_ASYBASE_MASK 0xffffffe0
#define  USB2H_ASYNCLISTADDR_ASYBASE_SHIFT 5
#define  USB2H_ASYNCLISTADDR_ASYBASE_MASK_SHIFT(reg) (((reg) & USB2H_ASYNCLISTADDR_ASYBASE_MASK) >> USB2H_ASYNCLISTADDR_ASYBASE_SHIFT)
#define  USB2H_ASYNCLISTADDR_ASYBASE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_ASYNCLISTADDR_ASYBASE_MASK) | (((uint32_t)val) << USB2H_ASYNCLISTADDR_ASYBASE_SHIFT))

#define  USB2H_ASYNCLISTADDR_RESERVED1_MASK 0x1f
#define  USB2H_ASYNCLISTADDR_RESERVED1_SHIFT 0
#define  USB2H_ASYNCLISTADDR_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_ASYNCLISTADDR_RESERVED1_MASK) >> USB2H_ASYNCLISTADDR_RESERVED1_SHIFT)
#define  USB2H_ASYNCLISTADDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_ASYNCLISTADDR_RESERVED1_MASK) | (((uint32_t)val) << USB2H_ASYNCLISTADDR_RESERVED1_SHIFT))

//====================================================================
//Register: Host Controller Embedded TT Async Buffer Status Register (TTCTRL)
//====================================================================

#define  USB2H_TTCTRL_RESERVED1_MASK 0x80000000
#define  USB2H_TTCTRL_RESERVED1_SHIFT 31
#define  USB2H_TTCTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_TTCTRL_RESERVED1_MASK) >> USB2H_TTCTRL_RESERVED1_SHIFT)
#define  USB2H_TTCTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_TTCTRL_RESERVED1_MASK) | (((uint32_t)val) << USB2H_TTCTRL_RESERVED1_SHIFT))

#define  USB2H_TTCTRL_TTHA_MASK 0x7f000000
#define  USB2H_TTCTRL_TTHA_SHIFT 24
#define  USB2H_TTCTRL_TTHA_MASK_SHIFT(reg) (((reg) & USB2H_TTCTRL_TTHA_MASK) >> USB2H_TTCTRL_TTHA_SHIFT)
#define  USB2H_TTCTRL_TTHA_REPLACE_VAL(reg,val) (((reg) & ~USB2H_TTCTRL_TTHA_MASK) | (((uint32_t)val) << USB2H_TTCTRL_TTHA_SHIFT))

#define  USB2H_TTCTRL_RESERVED2_MASK 0xffffff
#define  USB2H_TTCTRL_RESERVED2_SHIFT 0
#define  USB2H_TTCTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2H_TTCTRL_RESERVED2_MASK) >> USB2H_TTCTRL_RESERVED2_SHIFT)
#define  USB2H_TTCTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2H_TTCTRL_RESERVED2_MASK) | (((uint32_t)val) << USB2H_TTCTRL_RESERVED2_SHIFT))

//====================================================================
//Register: Burst Size Register (BURSTSIZE)
//====================================================================

#define  USB2H_BURSTSIZE_RESERVED1_MASK 0xffff0000
#define  USB2H_BURSTSIZE_RESERVED1_SHIFT 16
#define  USB2H_BURSTSIZE_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_BURSTSIZE_RESERVED1_MASK) >> USB2H_BURSTSIZE_RESERVED1_SHIFT)
#define  USB2H_BURSTSIZE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_BURSTSIZE_RESERVED1_MASK) | (((uint32_t)val) << USB2H_BURSTSIZE_RESERVED1_SHIFT))

#define  USB2H_BURSTSIZE_TXPBURST_MASK 0xff00
#define  USB2H_BURSTSIZE_TXPBURST_SHIFT 8
#define  USB2H_BURSTSIZE_TXPBURST_MASK_SHIFT(reg) (((reg) & USB2H_BURSTSIZE_TXPBURST_MASK) >> USB2H_BURSTSIZE_TXPBURST_SHIFT)
#define  USB2H_BURSTSIZE_TXPBURST_REPLACE_VAL(reg,val) (((reg) & ~USB2H_BURSTSIZE_TXPBURST_MASK) | (((uint32_t)val) << USB2H_BURSTSIZE_TXPBURST_SHIFT))

#define  USB2H_BURSTSIZE_RXPBURST_MASK 0xff
#define  USB2H_BURSTSIZE_RXPBURST_SHIFT 0
#define  USB2H_BURSTSIZE_RXPBURST_MASK_SHIFT(reg) (((reg) & USB2H_BURSTSIZE_RXPBURST_MASK) >> USB2H_BURSTSIZE_RXPBURST_SHIFT)
#define  USB2H_BURSTSIZE_RXPBURST_REPLACE_VAL(reg,val) (((reg) & ~USB2H_BURSTSIZE_RXPBURST_MASK) | (((uint32_t)val) << USB2H_BURSTSIZE_RXPBURST_SHIFT))

//====================================================================
//Register: TX Fill Tuning Register (TXFILLTUNING)
//====================================================================

#define  USB2H_TXFILLTUNING_RESERVED1_MASK 0xffc00000
#define  USB2H_TXFILLTUNING_RESERVED1_SHIFT 22
#define  USB2H_TXFILLTUNING_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_TXFILLTUNING_RESERVED1_MASK) >> USB2H_TXFILLTUNING_RESERVED1_SHIFT)
#define  USB2H_TXFILLTUNING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_TXFILLTUNING_RESERVED1_MASK) | (((uint32_t)val) << USB2H_TXFILLTUNING_RESERVED1_SHIFT))

#define  USB2H_TXFILLTUNING_TXFIFOTHRES_MASK 0x3f0000
#define  USB2H_TXFILLTUNING_TXFIFOTHRES_SHIFT 16
#define  USB2H_TXFILLTUNING_TXFIFOTHRES_MASK_SHIFT(reg) (((reg) & USB2H_TXFILLTUNING_TXFIFOTHRES_MASK) >> USB2H_TXFILLTUNING_TXFIFOTHRES_SHIFT)
#define  USB2H_TXFILLTUNING_TXFIFOTHRES_REPLACE_VAL(reg,val) (((reg) & ~USB2H_TXFILLTUNING_TXFIFOTHRES_MASK) | (((uint32_t)val) << USB2H_TXFILLTUNING_TXFIFOTHRES_SHIFT))

#define  USB2H_TXFILLTUNING_RESERVED2_MASK 0xe000
#define  USB2H_TXFILLTUNING_RESERVED2_SHIFT 13
#define  USB2H_TXFILLTUNING_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2H_TXFILLTUNING_RESERVED2_MASK) >> USB2H_TXFILLTUNING_RESERVED2_SHIFT)
#define  USB2H_TXFILLTUNING_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2H_TXFILLTUNING_RESERVED2_MASK) | (((uint32_t)val) << USB2H_TXFILLTUNING_RESERVED2_SHIFT))

#define  USB2H_TXFILLTUNING_TXSCHEALTH_MASK 0x1f00
#define  USB2H_TXFILLTUNING_TXSCHEALTH_SHIFT 8
#define  USB2H_TXFILLTUNING_TXSCHEALTH_MASK_SHIFT(reg) (((reg) & USB2H_TXFILLTUNING_TXSCHEALTH_MASK) >> USB2H_TXFILLTUNING_TXSCHEALTH_SHIFT)
#define  USB2H_TXFILLTUNING_TXSCHEALTH_REPLACE_VAL(reg,val) (((reg) & ~USB2H_TXFILLTUNING_TXSCHEALTH_MASK) | (((uint32_t)val) << USB2H_TXFILLTUNING_TXSCHEALTH_SHIFT))

#define  USB2H_TXFILLTUNING_RESERVED3_MASK 0x80
#define  USB2H_TXFILLTUNING_RESERVED3_SHIFT 7
#define  USB2H_TXFILLTUNING_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2H_TXFILLTUNING_RESERVED3_MASK) >> USB2H_TXFILLTUNING_RESERVED3_SHIFT)
#define  USB2H_TXFILLTUNING_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2H_TXFILLTUNING_RESERVED3_MASK) | (((uint32_t)val) << USB2H_TXFILLTUNING_RESERVED3_SHIFT))

#define  USB2H_TXFILLTUNING_TXSCHOH_MASK 0x7f
#define  USB2H_TXFILLTUNING_TXSCHOH_SHIFT 0
#define  USB2H_TXFILLTUNING_TXSCHOH_MASK_SHIFT(reg) (((reg) & USB2H_TXFILLTUNING_TXSCHOH_MASK) >> USB2H_TXFILLTUNING_TXSCHOH_SHIFT)
#define  USB2H_TXFILLTUNING_TXSCHOH_REPLACE_VAL(reg,val) (((reg) & ~USB2H_TXFILLTUNING_TXSCHOH_MASK) | (((uint32_t)val) << USB2H_TXFILLTUNING_TXSCHOH_SHIFT))

//====================================================================
//Register: Config Flag Register (CONFIGFLAG)
//====================================================================

#define  USB2H_CONFIGFLAG_CFLAG_MASK 0xffffffff
#define  USB2H_CONFIGFLAG_CFLAG_SHIFT 0
#define  USB2H_CONFIGFLAG_CFLAG_MASK_SHIFT(reg) (((reg) & USB2H_CONFIGFLAG_CFLAG_MASK) >> USB2H_CONFIGFLAG_CFLAG_SHIFT)
#define  USB2H_CONFIGFLAG_CFLAG_REPLACE_VAL(reg,val) (((reg) & ~USB2H_CONFIGFLAG_CFLAG_MASK) | (((uint32_t)val) << USB2H_CONFIGFLAG_CFLAG_SHIFT))

//====================================================================
//Register: Port Status Control Register (PORTSC)
//====================================================================

#define  USB2H_PORTSC_PTS_MASK 0xc0000000
#define  USB2H_PORTSC_PTS_SHIFT 30
#define  USB2H_PORTSC_PTS_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_PTS_MASK) >> USB2H_PORTSC_PTS_SHIFT)
#define  USB2H_PORTSC_PTS_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_PTS_MASK) | (((uint32_t)val) << USB2H_PORTSC_PTS_SHIFT))

#define  USB2H_PORTSC_STS_MASK 0x20000000
#define  USB2H_PORTSC_STS_SHIFT 29
#define  USB2H_PORTSC_STS_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_STS_MASK) >> USB2H_PORTSC_STS_SHIFT)
#define  USB2H_PORTSC_STS_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_STS_MASK) | (((uint32_t)val) << USB2H_PORTSC_STS_SHIFT))

#define  USB2H_PORTSC_PTW_MASK 0x10000000
#define  USB2H_PORTSC_PTW_SHIFT 28
#define  USB2H_PORTSC_PTW_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_PTW_MASK) >> USB2H_PORTSC_PTW_SHIFT)
#define  USB2H_PORTSC_PTW_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_PTW_MASK) | (((uint32_t)val) << USB2H_PORTSC_PTW_SHIFT))

#define  USB2H_PORTSC_PSPD_MASK 0xc000000
#define  USB2H_PORTSC_PSPD_SHIFT 26
#define  USB2H_PORTSC_PSPD_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_PSPD_MASK) >> USB2H_PORTSC_PSPD_SHIFT)
#define  USB2H_PORTSC_PSPD_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_PSPD_MASK) | (((uint32_t)val) << USB2H_PORTSC_PSPD_SHIFT))

#define  USB2H_PORTSC_SRT_MASK 0x2000000
#define  USB2H_PORTSC_SRT_SHIFT 25
#define  USB2H_PORTSC_SRT_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_SRT_MASK) >> USB2H_PORTSC_SRT_SHIFT)
#define  USB2H_PORTSC_SRT_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_SRT_MASK) | (((uint32_t)val) << USB2H_PORTSC_SRT_SHIFT))

#define  USB2H_PORTSC_PFSC_MASK 0x1000000
#define  USB2H_PORTSC_PFSC_SHIFT 24
#define  USB2H_PORTSC_PFSC_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_PFSC_MASK) >> USB2H_PORTSC_PFSC_SHIFT)
#define  USB2H_PORTSC_PFSC_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_PFSC_MASK) | (((uint32_t)val) << USB2H_PORTSC_PFSC_SHIFT))

#define  USB2H_PORTSC_PCHD_MASK 0x800000
#define  USB2H_PORTSC_PCHD_SHIFT 23
#define  USB2H_PORTSC_PCHD_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_PCHD_MASK) >> USB2H_PORTSC_PCHD_SHIFT)
#define  USB2H_PORTSC_PCHD_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_PCHD_MASK) | (((uint32_t)val) << USB2H_PORTSC_PCHD_SHIFT))

#define  USB2H_PORTSC_WKOC_MASK 0x400000
#define  USB2H_PORTSC_WKOC_SHIFT 22
#define  USB2H_PORTSC_WKOC_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_WKOC_MASK) >> USB2H_PORTSC_WKOC_SHIFT)
#define  USB2H_PORTSC_WKOC_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_WKOC_MASK) | (((uint32_t)val) << USB2H_PORTSC_WKOC_SHIFT))

#define  USB2H_PORTSC_WKDS_MASK 0x200000
#define  USB2H_PORTSC_WKDS_SHIFT 21
#define  USB2H_PORTSC_WKDS_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_WKDS_MASK) >> USB2H_PORTSC_WKDS_SHIFT)
#define  USB2H_PORTSC_WKDS_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_WKDS_MASK) | (((uint32_t)val) << USB2H_PORTSC_WKDS_SHIFT))

#define  USB2H_PORTSC_WKCN_MASK 0x100000
#define  USB2H_PORTSC_WKCN_SHIFT 20
#define  USB2H_PORTSC_WKCN_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_WKCN_MASK) >> USB2H_PORTSC_WKCN_SHIFT)
#define  USB2H_PORTSC_WKCN_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_WKCN_MASK) | (((uint32_t)val) << USB2H_PORTSC_WKCN_SHIFT))

#define  USB2H_PORTSC_PTC_MASK 0xf0000
#define  USB2H_PORTSC_PTC_SHIFT 16
#define  USB2H_PORTSC_PTC_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_PTC_MASK) >> USB2H_PORTSC_PTC_SHIFT)
#define  USB2H_PORTSC_PTC_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_PTC_MASK) | (((uint32_t)val) << USB2H_PORTSC_PTC_SHIFT))

#define  USB2H_PORTSC_PIC_MASK 0xc000
#define  USB2H_PORTSC_PIC_SHIFT 14
#define  USB2H_PORTSC_PIC_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_PIC_MASK) >> USB2H_PORTSC_PIC_SHIFT)
#define  USB2H_PORTSC_PIC_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_PIC_MASK) | (((uint32_t)val) << USB2H_PORTSC_PIC_SHIFT))

#define  USB2H_PORTSC_PO_MASK 0x2000
#define  USB2H_PORTSC_PO_SHIFT 13
#define  USB2H_PORTSC_PO_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_PO_MASK) >> USB2H_PORTSC_PO_SHIFT)
#define  USB2H_PORTSC_PO_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_PO_MASK) | (((uint32_t)val) << USB2H_PORTSC_PO_SHIFT))

#define  USB2H_PORTSC_PP_MASK 0x1000
#define  USB2H_PORTSC_PP_SHIFT 12
#define  USB2H_PORTSC_PP_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_PP_MASK) >> USB2H_PORTSC_PP_SHIFT)
#define  USB2H_PORTSC_PP_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_PP_MASK) | (((uint32_t)val) << USB2H_PORTSC_PP_SHIFT))

#define  USB2H_PORTSC_LS_MASK 0xc00
#define  USB2H_PORTSC_LS_SHIFT 10
#define  USB2H_PORTSC_LS_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_LS_MASK) >> USB2H_PORTSC_LS_SHIFT)
#define  USB2H_PORTSC_LS_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_LS_MASK) | (((uint32_t)val) << USB2H_PORTSC_LS_SHIFT))

#define  USB2H_PORTSC_HSP_MASK 0x200
#define  USB2H_PORTSC_HSP_SHIFT 9
#define  USB2H_PORTSC_HSP_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_HSP_MASK) >> USB2H_PORTSC_HSP_SHIFT)
#define  USB2H_PORTSC_HSP_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_HSP_MASK) | (((uint32_t)val) << USB2H_PORTSC_HSP_SHIFT))

#define  USB2H_PORTSC_PR_MASK 0x100
#define  USB2H_PORTSC_PR_SHIFT 8
#define  USB2H_PORTSC_PR_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_PR_MASK) >> USB2H_PORTSC_PR_SHIFT)
#define  USB2H_PORTSC_PR_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_PR_MASK) | (((uint32_t)val) << USB2H_PORTSC_PR_SHIFT))

#define  USB2H_PORTSC_SUSP_MASK 0x80
#define  USB2H_PORTSC_SUSP_SHIFT 7
#define  USB2H_PORTSC_SUSP_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_SUSP_MASK) >> USB2H_PORTSC_SUSP_SHIFT)
#define  USB2H_PORTSC_SUSP_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_SUSP_MASK) | (((uint32_t)val) << USB2H_PORTSC_SUSP_SHIFT))

#define  USB2H_PORTSC_FPR_MASK 0x40
#define  USB2H_PORTSC_FPR_SHIFT 6
#define  USB2H_PORTSC_FPR_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_FPR_MASK) >> USB2H_PORTSC_FPR_SHIFT)
#define  USB2H_PORTSC_FPR_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_FPR_MASK) | (((uint32_t)val) << USB2H_PORTSC_FPR_SHIFT))

#define  USB2H_PORTSC_OCC_MASK 0x20
#define  USB2H_PORTSC_OCC_SHIFT 5
#define  USB2H_PORTSC_OCC_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_OCC_MASK) >> USB2H_PORTSC_OCC_SHIFT)
#define  USB2H_PORTSC_OCC_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_OCC_MASK) | (((uint32_t)val) << USB2H_PORTSC_OCC_SHIFT))

#define  USB2H_PORTSC_OCA_MASK 0x10
#define  USB2H_PORTSC_OCA_SHIFT 4
#define  USB2H_PORTSC_OCA_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_OCA_MASK) >> USB2H_PORTSC_OCA_SHIFT)
#define  USB2H_PORTSC_OCA_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_OCA_MASK) | (((uint32_t)val) << USB2H_PORTSC_OCA_SHIFT))

#define  USB2H_PORTSC_PEC_MASK 0x8
#define  USB2H_PORTSC_PEC_SHIFT 3
#define  USB2H_PORTSC_PEC_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_PEC_MASK) >> USB2H_PORTSC_PEC_SHIFT)
#define  USB2H_PORTSC_PEC_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_PEC_MASK) | (((uint32_t)val) << USB2H_PORTSC_PEC_SHIFT))

#define  USB2H_PORTSC_PE_MASK 0x4
#define  USB2H_PORTSC_PE_SHIFT 2
#define  USB2H_PORTSC_PE_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_PE_MASK) >> USB2H_PORTSC_PE_SHIFT)
#define  USB2H_PORTSC_PE_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_PE_MASK) | (((uint32_t)val) << USB2H_PORTSC_PE_SHIFT))

#define  USB2H_PORTSC_CSC_MASK 0x2
#define  USB2H_PORTSC_CSC_SHIFT 1
#define  USB2H_PORTSC_CSC_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_CSC_MASK) >> USB2H_PORTSC_CSC_SHIFT)
#define  USB2H_PORTSC_CSC_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_CSC_MASK) | (((uint32_t)val) << USB2H_PORTSC_CSC_SHIFT))

#define  USB2H_PORTSC_CCS_MASK 0x1
#define  USB2H_PORTSC_CCS_SHIFT 0
#define  USB2H_PORTSC_CCS_MASK_SHIFT(reg) (((reg) & USB2H_PORTSC_CCS_MASK) >> USB2H_PORTSC_CCS_SHIFT)
#define  USB2H_PORTSC_CCS_REPLACE_VAL(reg,val) (((reg) & ~USB2H_PORTSC_CCS_MASK) | (((uint32_t)val) << USB2H_PORTSC_CCS_SHIFT))

//====================================================================
//Register: USB Device Mode Register (USBMODE)
//====================================================================

#define  USB2H_USBMODE_RESERVED1_MASK 0xffffffc0
#define  USB2H_USBMODE_RESERVED1_SHIFT 6
#define  USB2H_USBMODE_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2H_USBMODE_RESERVED1_MASK) >> USB2H_USBMODE_RESERVED1_SHIFT)
#define  USB2H_USBMODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBMODE_RESERVED1_MASK) | (((uint32_t)val) << USB2H_USBMODE_RESERVED1_SHIFT))

#define  USB2H_USBMODE_VBPS_MASK 0x20
#define  USB2H_USBMODE_VBPS_SHIFT 5
#define  USB2H_USBMODE_VBPS_MASK_SHIFT(reg) (((reg) & USB2H_USBMODE_VBPS_MASK) >> USB2H_USBMODE_VBPS_SHIFT)
#define  USB2H_USBMODE_VBPS_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBMODE_VBPS_MASK) | (((uint32_t)val) << USB2H_USBMODE_VBPS_SHIFT))

#define  USB2H_USBMODE_SDIS_MASK 0x10
#define  USB2H_USBMODE_SDIS_SHIFT 4
#define  USB2H_USBMODE_SDIS_MASK_SHIFT(reg) (((reg) & USB2H_USBMODE_SDIS_MASK) >> USB2H_USBMODE_SDIS_SHIFT)
#define  USB2H_USBMODE_SDIS_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBMODE_SDIS_MASK) | (((uint32_t)val) << USB2H_USBMODE_SDIS_SHIFT))

#define  USB2H_USBMODE_SLOM_MASK 0x8
#define  USB2H_USBMODE_SLOM_SHIFT 3
#define  USB2H_USBMODE_SLOM_MASK_SHIFT(reg) (((reg) & USB2H_USBMODE_SLOM_MASK) >> USB2H_USBMODE_SLOM_SHIFT)
#define  USB2H_USBMODE_SLOM_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBMODE_SLOM_MASK) | (((uint32_t)val) << USB2H_USBMODE_SLOM_SHIFT))

#define  USB2H_USBMODE_ES_MASK 0x4
#define  USB2H_USBMODE_ES_SHIFT 2
#define  USB2H_USBMODE_ES_MASK_SHIFT(reg) (((reg) & USB2H_USBMODE_ES_MASK) >> USB2H_USBMODE_ES_SHIFT)
#define  USB2H_USBMODE_ES_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBMODE_ES_MASK) | (((uint32_t)val) << USB2H_USBMODE_ES_SHIFT))

#define  USB2H_USBMODE_CM_MASK 0x3
#define  USB2H_USBMODE_CM_SHIFT 0
#define  USB2H_USBMODE_CM_MASK_SHIFT(reg) (((reg) & USB2H_USBMODE_CM_MASK) >> USB2H_USBMODE_CM_SHIFT)
#define  USB2H_USBMODE_CM_REPLACE_VAL(reg,val) (((reg) & ~USB2H_USBMODE_CM_MASK) | (((uint32_t)val) << USB2H_USBMODE_CM_SHIFT))

//====================================================================
//
//Register File: USB OTG (USB2O)
//
//====================================================================

//====================================================================
//Register: Identification Register (ID)
//====================================================================

#define  USB2O_ID_CIVERSION_MASK 0xe0000000
#define  USB2O_ID_CIVERSION_SHIFT 29
#define  USB2O_ID_CIVERSION_MASK_SHIFT(reg) (((reg) & USB2O_ID_CIVERSION_MASK) >> USB2O_ID_CIVERSION_SHIFT)
#define  USB2O_ID_CIVERSION_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ID_CIVERSION_MASK) | (((uint32_t)val) << USB2O_ID_CIVERSION_SHIFT))

#define  USB2O_ID_VERSION_MASK 0x1e000000
#define  USB2O_ID_VERSION_SHIFT 25
#define  USB2O_ID_VERSION_MASK_SHIFT(reg) (((reg) & USB2O_ID_VERSION_MASK) >> USB2O_ID_VERSION_SHIFT)
#define  USB2O_ID_VERSION_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ID_VERSION_MASK) | (((uint32_t)val) << USB2O_ID_VERSION_SHIFT))

#define  USB2O_ID_REVISION_MASK 0x1e00000
#define  USB2O_ID_REVISION_SHIFT 21
#define  USB2O_ID_REVISION_MASK_SHIFT(reg) (((reg) & USB2O_ID_REVISION_MASK) >> USB2O_ID_REVISION_SHIFT)
#define  USB2O_ID_REVISION_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ID_REVISION_MASK) | (((uint32_t)val) << USB2O_ID_REVISION_SHIFT))

#define  USB2O_ID_TAG_MASK 0x1f0000
#define  USB2O_ID_TAG_SHIFT 16
#define  USB2O_ID_TAG_MASK_SHIFT(reg) (((reg) & USB2O_ID_TAG_MASK) >> USB2O_ID_TAG_SHIFT)
#define  USB2O_ID_TAG_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ID_TAG_MASK) | (((uint32_t)val) << USB2O_ID_TAG_SHIFT))

#define  USB2O_ID_NID_MASK 0xff00
#define  USB2O_ID_NID_SHIFT 8
#define  USB2O_ID_NID_MASK_SHIFT(reg) (((reg) & USB2O_ID_NID_MASK) >> USB2O_ID_NID_SHIFT)
#define  USB2O_ID_NID_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ID_NID_MASK) | (((uint32_t)val) << USB2O_ID_NID_SHIFT))

#define  USB2O_ID_ID_MASK 0xff
#define  USB2O_ID_ID_SHIFT 0
#define  USB2O_ID_ID_MASK_SHIFT(reg) (((reg) & USB2O_ID_ID_MASK) >> USB2O_ID_ID_SHIFT)
#define  USB2O_ID_ID_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ID_ID_MASK) | (((uint32_t)val) << USB2O_ID_ID_SHIFT))

//====================================================================
//Register: ChipIdea General Hardware Parameters Register (HWGENERAL)
//====================================================================

#define  USB2O_HWGENERAL_RESERVED1_MASK 0xfffff800
#define  USB2O_HWGENERAL_RESERVED1_SHIFT 11
#define  USB2O_HWGENERAL_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_HWGENERAL_RESERVED1_MASK) >> USB2O_HWGENERAL_RESERVED1_SHIFT)
#define  USB2O_HWGENERAL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWGENERAL_RESERVED1_MASK) | (((uint32_t)val) << USB2O_HWGENERAL_RESERVED1_SHIFT))

#define  USB2O_HWGENERAL_SM_MASK 0x600
#define  USB2O_HWGENERAL_SM_SHIFT 9
#define  USB2O_HWGENERAL_SM_MASK_SHIFT(reg) (((reg) & USB2O_HWGENERAL_SM_MASK) >> USB2O_HWGENERAL_SM_SHIFT)
#define  USB2O_HWGENERAL_SM_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWGENERAL_SM_MASK) | (((uint32_t)val) << USB2O_HWGENERAL_SM_SHIFT))

#define  USB2O_HWGENERAL_PHYM_MASK 0x1c0
#define  USB2O_HWGENERAL_PHYM_SHIFT 6
#define  USB2O_HWGENERAL_PHYM_MASK_SHIFT(reg) (((reg) & USB2O_HWGENERAL_PHYM_MASK) >> USB2O_HWGENERAL_PHYM_SHIFT)
#define  USB2O_HWGENERAL_PHYM_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWGENERAL_PHYM_MASK) | (((uint32_t)val) << USB2O_HWGENERAL_PHYM_SHIFT))

#define  USB2O_HWGENERAL_PHYW_MASK 0x30
#define  USB2O_HWGENERAL_PHYW_SHIFT 4
#define  USB2O_HWGENERAL_PHYW_MASK_SHIFT(reg) (((reg) & USB2O_HWGENERAL_PHYW_MASK) >> USB2O_HWGENERAL_PHYW_SHIFT)
#define  USB2O_HWGENERAL_PHYW_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWGENERAL_PHYW_MASK) | (((uint32_t)val) << USB2O_HWGENERAL_PHYW_SHIFT))

#define  USB2O_HWGENERAL_BWT_MASK 0x8
#define  USB2O_HWGENERAL_BWT_SHIFT 3
#define  USB2O_HWGENERAL_BWT_MASK_SHIFT(reg) (((reg) & USB2O_HWGENERAL_BWT_MASK) >> USB2O_HWGENERAL_BWT_SHIFT)
#define  USB2O_HWGENERAL_BWT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWGENERAL_BWT_MASK) | (((uint32_t)val) << USB2O_HWGENERAL_BWT_SHIFT))

#define  USB2O_HWGENERAL_CLKC_MASK 0x6
#define  USB2O_HWGENERAL_CLKC_SHIFT 1
#define  USB2O_HWGENERAL_CLKC_MASK_SHIFT(reg) (((reg) & USB2O_HWGENERAL_CLKC_MASK) >> USB2O_HWGENERAL_CLKC_SHIFT)
#define  USB2O_HWGENERAL_CLKC_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWGENERAL_CLKC_MASK) | (((uint32_t)val) << USB2O_HWGENERAL_CLKC_SHIFT))

#define  USB2O_HWGENERAL_RT_MASK 0x1
#define  USB2O_HWGENERAL_RT_SHIFT 0
#define  USB2O_HWGENERAL_RT_MASK_SHIFT(reg) (((reg) & USB2O_HWGENERAL_RT_MASK) >> USB2O_HWGENERAL_RT_SHIFT)
#define  USB2O_HWGENERAL_RT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWGENERAL_RT_MASK) | (((uint32_t)val) << USB2O_HWGENERAL_RT_SHIFT))

//====================================================================
//Register: Host Hardware Parameters Register (HWHOST)
//====================================================================

#define  USB2O_HWHOST_TTPER_MASK 0xff000000
#define  USB2O_HWHOST_TTPER_SHIFT 24
#define  USB2O_HWHOST_TTPER_MASK_SHIFT(reg) (((reg) & USB2O_HWHOST_TTPER_MASK) >> USB2O_HWHOST_TTPER_SHIFT)
#define  USB2O_HWHOST_TTPER_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWHOST_TTPER_MASK) | (((uint32_t)val) << USB2O_HWHOST_TTPER_SHIFT))

#define  USB2O_HWHOST_TTASY_MASK 0xff0000
#define  USB2O_HWHOST_TTASY_SHIFT 16
#define  USB2O_HWHOST_TTASY_MASK_SHIFT(reg) (((reg) & USB2O_HWHOST_TTASY_MASK) >> USB2O_HWHOST_TTASY_SHIFT)
#define  USB2O_HWHOST_TTASY_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWHOST_TTASY_MASK) | (((uint32_t)val) << USB2O_HWHOST_TTASY_SHIFT))

#define  USB2O_HWHOST_RESERVED1_MASK 0xfff0
#define  USB2O_HWHOST_RESERVED1_SHIFT 4
#define  USB2O_HWHOST_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_HWHOST_RESERVED1_MASK) >> USB2O_HWHOST_RESERVED1_SHIFT)
#define  USB2O_HWHOST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWHOST_RESERVED1_MASK) | (((uint32_t)val) << USB2O_HWHOST_RESERVED1_SHIFT))

#define  USB2O_HWHOST_NPORT_MASK 0xe
#define  USB2O_HWHOST_NPORT_SHIFT 1
#define  USB2O_HWHOST_NPORT_MASK_SHIFT(reg) (((reg) & USB2O_HWHOST_NPORT_MASK) >> USB2O_HWHOST_NPORT_SHIFT)
#define  USB2O_HWHOST_NPORT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWHOST_NPORT_MASK) | (((uint32_t)val) << USB2O_HWHOST_NPORT_SHIFT))

#define  USB2O_HWHOST_HC_MASK 0x1
#define  USB2O_HWHOST_HC_SHIFT 0
#define  USB2O_HWHOST_HC_MASK_SHIFT(reg) (((reg) & USB2O_HWHOST_HC_MASK) >> USB2O_HWHOST_HC_SHIFT)
#define  USB2O_HWHOST_HC_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWHOST_HC_MASK) | (((uint32_t)val) << USB2O_HWHOST_HC_SHIFT))

//====================================================================
//Register: Device Hardware Parameters Register (HWDEVICE)
//====================================================================

#define  USB2O_HWDEVICE_RESERVED1_MASK 0xffffffc0
#define  USB2O_HWDEVICE_RESERVED1_SHIFT 6
#define  USB2O_HWDEVICE_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_HWDEVICE_RESERVED1_MASK) >> USB2O_HWDEVICE_RESERVED1_SHIFT)
#define  USB2O_HWDEVICE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWDEVICE_RESERVED1_MASK) | (((uint32_t)val) << USB2O_HWDEVICE_RESERVED1_SHIFT))

#define  USB2O_HWDEVICE_DEVEP_MASK 0x3e
#define  USB2O_HWDEVICE_DEVEP_SHIFT 1
#define  USB2O_HWDEVICE_DEVEP_MASK_SHIFT(reg) (((reg) & USB2O_HWDEVICE_DEVEP_MASK) >> USB2O_HWDEVICE_DEVEP_SHIFT)
#define  USB2O_HWDEVICE_DEVEP_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWDEVICE_DEVEP_MASK) | (((uint32_t)val) << USB2O_HWDEVICE_DEVEP_SHIFT))

#define  USB2O_HWDEVICE_DC_MASK 0x1
#define  USB2O_HWDEVICE_DC_SHIFT 0
#define  USB2O_HWDEVICE_DC_MASK_SHIFT(reg) (((reg) & USB2O_HWDEVICE_DC_MASK) >> USB2O_HWDEVICE_DC_SHIFT)
#define  USB2O_HWDEVICE_DC_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWDEVICE_DC_MASK) | (((uint32_t)val) << USB2O_HWDEVICE_DC_SHIFT))

//====================================================================
//Register: TX Buffer Parameters Register (HWTXBUF)
//====================================================================

#define  USB2O_HWTXBUF_TXLCR_MASK 0x80000000
#define  USB2O_HWTXBUF_TXLCR_SHIFT 31
#define  USB2O_HWTXBUF_TXLCR_MASK_SHIFT(reg) (((reg) & USB2O_HWTXBUF_TXLCR_MASK) >> USB2O_HWTXBUF_TXLCR_SHIFT)
#define  USB2O_HWTXBUF_TXLCR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWTXBUF_TXLCR_MASK) | (((uint32_t)val) << USB2O_HWTXBUF_TXLCR_SHIFT))

#define  USB2O_HWTXBUF_RESERVED1_MASK 0x7f000000
#define  USB2O_HWTXBUF_RESERVED1_SHIFT 24
#define  USB2O_HWTXBUF_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_HWTXBUF_RESERVED1_MASK) >> USB2O_HWTXBUF_RESERVED1_SHIFT)
#define  USB2O_HWTXBUF_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWTXBUF_RESERVED1_MASK) | (((uint32_t)val) << USB2O_HWTXBUF_RESERVED1_SHIFT))

#define  USB2O_HWTXBUF_TXCHANADD_MASK 0xff0000
#define  USB2O_HWTXBUF_TXCHANADD_SHIFT 16
#define  USB2O_HWTXBUF_TXCHANADD_MASK_SHIFT(reg) (((reg) & USB2O_HWTXBUF_TXCHANADD_MASK) >> USB2O_HWTXBUF_TXCHANADD_SHIFT)
#define  USB2O_HWTXBUF_TXCHANADD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWTXBUF_TXCHANADD_MASK) | (((uint32_t)val) << USB2O_HWTXBUF_TXCHANADD_SHIFT))

#define  USB2O_HWTXBUF_TXADD_MASK 0xff00
#define  USB2O_HWTXBUF_TXADD_SHIFT 8
#define  USB2O_HWTXBUF_TXADD_MASK_SHIFT(reg) (((reg) & USB2O_HWTXBUF_TXADD_MASK) >> USB2O_HWTXBUF_TXADD_SHIFT)
#define  USB2O_HWTXBUF_TXADD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWTXBUF_TXADD_MASK) | (((uint32_t)val) << USB2O_HWTXBUF_TXADD_SHIFT))

#define  USB2O_HWTXBUF_TXBURST_MASK 0xff
#define  USB2O_HWTXBUF_TXBURST_SHIFT 0
#define  USB2O_HWTXBUF_TXBURST_MASK_SHIFT(reg) (((reg) & USB2O_HWTXBUF_TXBURST_MASK) >> USB2O_HWTXBUF_TXBURST_SHIFT)
#define  USB2O_HWTXBUF_TXBURST_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWTXBUF_TXBURST_MASK) | (((uint32_t)val) << USB2O_HWTXBUF_TXBURST_SHIFT))

//====================================================================
//Register: RX Buffer Parameters Register (HWRXBUF)
//====================================================================

#define  USB2O_HWRXBUF_RESERVED1_MASK 0xffff0000
#define  USB2O_HWRXBUF_RESERVED1_SHIFT 16
#define  USB2O_HWRXBUF_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_HWRXBUF_RESERVED1_MASK) >> USB2O_HWRXBUF_RESERVED1_SHIFT)
#define  USB2O_HWRXBUF_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWRXBUF_RESERVED1_MASK) | (((uint32_t)val) << USB2O_HWRXBUF_RESERVED1_SHIFT))

#define  USB2O_HWRXBUF_RXADD_MASK 0xff00
#define  USB2O_HWRXBUF_RXADD_SHIFT 8
#define  USB2O_HWRXBUF_RXADD_MASK_SHIFT(reg) (((reg) & USB2O_HWRXBUF_RXADD_MASK) >> USB2O_HWRXBUF_RXADD_SHIFT)
#define  USB2O_HWRXBUF_RXADD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWRXBUF_RXADD_MASK) | (((uint32_t)val) << USB2O_HWRXBUF_RXADD_SHIFT))

#define  USB2O_HWRXBUF_RXBURST_MASK 0xff
#define  USB2O_HWRXBUF_RXBURST_SHIFT 0
#define  USB2O_HWRXBUF_RXBURST_MASK_SHIFT(reg) (((reg) & USB2O_HWRXBUF_RXBURST_MASK) >> USB2O_HWRXBUF_RXBURST_SHIFT)
#define  USB2O_HWRXBUF_RXBURST_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HWRXBUF_RXBURST_MASK) | (((uint32_t)val) << USB2O_HWRXBUF_RXBURST_SHIFT))

//====================================================================
//Register: System Bus Control Register (SBUSCFG)
//====================================================================

#define  USB2O_SBUSCFG_RESERVED1_MASK 0xfffffff8
#define  USB2O_SBUSCFG_RESERVED1_SHIFT 3
#define  USB2O_SBUSCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_SBUSCFG_RESERVED1_MASK) >> USB2O_SBUSCFG_RESERVED1_SHIFT)
#define  USB2O_SBUSCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_SBUSCFG_RESERVED1_MASK) | (((uint32_t)val) << USB2O_SBUSCFG_RESERVED1_SHIFT))

#define  USB2O_SBUSCFG_AHBBRST_MASK 0x7
#define  USB2O_SBUSCFG_AHBBRST_SHIFT 0
#define  USB2O_SBUSCFG_AHBBRST_MASK_SHIFT(reg) (((reg) & USB2O_SBUSCFG_AHBBRST_MASK) >> USB2O_SBUSCFG_AHBBRST_SHIFT)
#define  USB2O_SBUSCFG_AHBBRST_REPLACE_VAL(reg,val) (((reg) & ~USB2O_SBUSCFG_AHBBRST_MASK) | (((uint32_t)val) << USB2O_SBUSCFG_AHBBRST_SHIFT))

//====================================================================
//Register: Timer 0 Duration Register (GPTIMER0LD)
//====================================================================

#define  USB2O_GPTIMER0LD_RESERVED1_MASK 0xff000000
#define  USB2O_GPTIMER0LD_RESERVED1_SHIFT 24
#define  USB2O_GPTIMER0LD_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_GPTIMER0LD_RESERVED1_MASK) >> USB2O_GPTIMER0LD_RESERVED1_SHIFT)
#define  USB2O_GPTIMER0LD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_GPTIMER0LD_RESERVED1_MASK) | (((uint32_t)val) << USB2O_GPTIMER0LD_RESERVED1_SHIFT))

#define  USB2O_GPTIMER0LD_GPTLD_MASK 0xffffff
#define  USB2O_GPTIMER0LD_GPTLD_SHIFT 0
#define  USB2O_GPTIMER0LD_GPTLD_MASK_SHIFT(reg) (((reg) & USB2O_GPTIMER0LD_GPTLD_MASK) >> USB2O_GPTIMER0LD_GPTLD_SHIFT)
#define  USB2O_GPTIMER0LD_GPTLD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_GPTIMER0LD_GPTLD_MASK) | (((uint32_t)val) << USB2O_GPTIMER0LD_GPTLD_SHIFT))

//====================================================================
//Register: Timer 0 Control Register (GPTIMER0CTRL)
//====================================================================

#define  USB2O_GPTIMER0CTRL_GPTRUN_MASK 0x80000000
#define  USB2O_GPTIMER0CTRL_GPTRUN_SHIFT 31
#define  USB2O_GPTIMER0CTRL_GPTRUN_MASK_SHIFT(reg) (((reg) & USB2O_GPTIMER0CTRL_GPTRUN_MASK) >> USB2O_GPTIMER0CTRL_GPTRUN_SHIFT)
#define  USB2O_GPTIMER0CTRL_GPTRUN_REPLACE_VAL(reg,val) (((reg) & ~USB2O_GPTIMER0CTRL_GPTRUN_MASK) | (((uint32_t)val) << USB2O_GPTIMER0CTRL_GPTRUN_SHIFT))

#define  USB2O_GPTIMER0CTRL_GPTRST_MASK 0x40000000
#define  USB2O_GPTIMER0CTRL_GPTRST_SHIFT 30
#define  USB2O_GPTIMER0CTRL_GPTRST_MASK_SHIFT(reg) (((reg) & USB2O_GPTIMER0CTRL_GPTRST_MASK) >> USB2O_GPTIMER0CTRL_GPTRST_SHIFT)
#define  USB2O_GPTIMER0CTRL_GPTRST_REPLACE_VAL(reg,val) (((reg) & ~USB2O_GPTIMER0CTRL_GPTRST_MASK) | (((uint32_t)val) << USB2O_GPTIMER0CTRL_GPTRST_SHIFT))

#define  USB2O_GPTIMER0CTRL_RESERVED1_MASK 0x3e000000
#define  USB2O_GPTIMER0CTRL_RESERVED1_SHIFT 25
#define  USB2O_GPTIMER0CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_GPTIMER0CTRL_RESERVED1_MASK) >> USB2O_GPTIMER0CTRL_RESERVED1_SHIFT)
#define  USB2O_GPTIMER0CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_GPTIMER0CTRL_RESERVED1_MASK) | (((uint32_t)val) << USB2O_GPTIMER0CTRL_RESERVED1_SHIFT))

#define  USB2O_GPTIMER0CTRL_GPTMODE_MASK 0x1000000
#define  USB2O_GPTIMER0CTRL_GPTMODE_SHIFT 24
#define  USB2O_GPTIMER0CTRL_GPTMODE_MASK_SHIFT(reg) (((reg) & USB2O_GPTIMER0CTRL_GPTMODE_MASK) >> USB2O_GPTIMER0CTRL_GPTMODE_SHIFT)
#define  USB2O_GPTIMER0CTRL_GPTMODE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_GPTIMER0CTRL_GPTMODE_MASK) | (((uint32_t)val) << USB2O_GPTIMER0CTRL_GPTMODE_SHIFT))

#define  USB2O_GPTIMER0CTRL_GPTCNT_MASK 0xffffff
#define  USB2O_GPTIMER0CTRL_GPTCNT_SHIFT 0
#define  USB2O_GPTIMER0CTRL_GPTCNT_MASK_SHIFT(reg) (((reg) & USB2O_GPTIMER0CTRL_GPTCNT_MASK) >> USB2O_GPTIMER0CTRL_GPTCNT_SHIFT)
#define  USB2O_GPTIMER0CTRL_GPTCNT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_GPTIMER0CTRL_GPTCNT_MASK) | (((uint32_t)val) << USB2O_GPTIMER0CTRL_GPTCNT_SHIFT))

//====================================================================
//Register: Timer 1 Duration Register (GPTIMER1LD)
//====================================================================

#define  USB2O_GPTIMER1LD_RESERVED1_MASK 0xff000000
#define  USB2O_GPTIMER1LD_RESERVED1_SHIFT 24
#define  USB2O_GPTIMER1LD_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_GPTIMER1LD_RESERVED1_MASK) >> USB2O_GPTIMER1LD_RESERVED1_SHIFT)
#define  USB2O_GPTIMER1LD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_GPTIMER1LD_RESERVED1_MASK) | (((uint32_t)val) << USB2O_GPTIMER1LD_RESERVED1_SHIFT))

#define  USB2O_GPTIMER1LD_GPTLD_MASK 0xffffff
#define  USB2O_GPTIMER1LD_GPTLD_SHIFT 0
#define  USB2O_GPTIMER1LD_GPTLD_MASK_SHIFT(reg) (((reg) & USB2O_GPTIMER1LD_GPTLD_MASK) >> USB2O_GPTIMER1LD_GPTLD_SHIFT)
#define  USB2O_GPTIMER1LD_GPTLD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_GPTIMER1LD_GPTLD_MASK) | (((uint32_t)val) << USB2O_GPTIMER1LD_GPTLD_SHIFT))

//====================================================================
//Register: Timer 1 Control Register (GPTIMER1CTRL)
//====================================================================

#define  USB2O_GPTIMER1CTRL_GPTRUN_MASK 0x80000000
#define  USB2O_GPTIMER1CTRL_GPTRUN_SHIFT 31
#define  USB2O_GPTIMER1CTRL_GPTRUN_MASK_SHIFT(reg) (((reg) & USB2O_GPTIMER1CTRL_GPTRUN_MASK) >> USB2O_GPTIMER1CTRL_GPTRUN_SHIFT)
#define  USB2O_GPTIMER1CTRL_GPTRUN_REPLACE_VAL(reg,val) (((reg) & ~USB2O_GPTIMER1CTRL_GPTRUN_MASK) | (((uint32_t)val) << USB2O_GPTIMER1CTRL_GPTRUN_SHIFT))

#define  USB2O_GPTIMER1CTRL_GPTRST_MASK 0x40000000
#define  USB2O_GPTIMER1CTRL_GPTRST_SHIFT 30
#define  USB2O_GPTIMER1CTRL_GPTRST_MASK_SHIFT(reg) (((reg) & USB2O_GPTIMER1CTRL_GPTRST_MASK) >> USB2O_GPTIMER1CTRL_GPTRST_SHIFT)
#define  USB2O_GPTIMER1CTRL_GPTRST_REPLACE_VAL(reg,val) (((reg) & ~USB2O_GPTIMER1CTRL_GPTRST_MASK) | (((uint32_t)val) << USB2O_GPTIMER1CTRL_GPTRST_SHIFT))

#define  USB2O_GPTIMER1CTRL_RESERVED1_MASK 0x3e000000
#define  USB2O_GPTIMER1CTRL_RESERVED1_SHIFT 25
#define  USB2O_GPTIMER1CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_GPTIMER1CTRL_RESERVED1_MASK) >> USB2O_GPTIMER1CTRL_RESERVED1_SHIFT)
#define  USB2O_GPTIMER1CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_GPTIMER1CTRL_RESERVED1_MASK) | (((uint32_t)val) << USB2O_GPTIMER1CTRL_RESERVED1_SHIFT))

#define  USB2O_GPTIMER1CTRL_GPTMODE_MASK 0x1000000
#define  USB2O_GPTIMER1CTRL_GPTMODE_SHIFT 24
#define  USB2O_GPTIMER1CTRL_GPTMODE_MASK_SHIFT(reg) (((reg) & USB2O_GPTIMER1CTRL_GPTMODE_MASK) >> USB2O_GPTIMER1CTRL_GPTMODE_SHIFT)
#define  USB2O_GPTIMER1CTRL_GPTMODE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_GPTIMER1CTRL_GPTMODE_MASK) | (((uint32_t)val) << USB2O_GPTIMER1CTRL_GPTMODE_SHIFT))

#define  USB2O_GPTIMER1CTRL_GPTCNT_MASK 0xffffff
#define  USB2O_GPTIMER1CTRL_GPTCNT_SHIFT 0
#define  USB2O_GPTIMER1CTRL_GPTCNT_MASK_SHIFT(reg) (((reg) & USB2O_GPTIMER1CTRL_GPTCNT_MASK) >> USB2O_GPTIMER1CTRL_GPTCNT_SHIFT)
#define  USB2O_GPTIMER1CTRL_GPTCNT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_GPTIMER1CTRL_GPTCNT_MASK) | (((uint32_t)val) << USB2O_GPTIMER1CTRL_GPTCNT_SHIFT))

//====================================================================
//Register: EHCI Version / Capability Length Register (HCIV_CAPLENGTH)
//====================================================================

#define  USB2O_HCIV_CAPLENGTH_HCIVERSION_MASK 0xffff0000
#define  USB2O_HCIV_CAPLENGTH_HCIVERSION_SHIFT 16
#define  USB2O_HCIV_CAPLENGTH_HCIVERSION_MASK_SHIFT(reg) (((reg) & USB2O_HCIV_CAPLENGTH_HCIVERSION_MASK) >> USB2O_HCIV_CAPLENGTH_HCIVERSION_SHIFT)
#define  USB2O_HCIV_CAPLENGTH_HCIVERSION_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCIV_CAPLENGTH_HCIVERSION_MASK) | (((uint32_t)val) << USB2O_HCIV_CAPLENGTH_HCIVERSION_SHIFT))

#define  USB2O_HCIV_CAPLENGTH_RESERVED1_MASK 0xff00
#define  USB2O_HCIV_CAPLENGTH_RESERVED1_SHIFT 8
#define  USB2O_HCIV_CAPLENGTH_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_HCIV_CAPLENGTH_RESERVED1_MASK) >> USB2O_HCIV_CAPLENGTH_RESERVED1_SHIFT)
#define  USB2O_HCIV_CAPLENGTH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCIV_CAPLENGTH_RESERVED1_MASK) | (((uint32_t)val) << USB2O_HCIV_CAPLENGTH_RESERVED1_SHIFT))

#define  USB2O_HCIV_CAPLENGTH_CAPLENGTH_MASK 0xff
#define  USB2O_HCIV_CAPLENGTH_CAPLENGTH_SHIFT 0
#define  USB2O_HCIV_CAPLENGTH_CAPLENGTH_MASK_SHIFT(reg) (((reg) & USB2O_HCIV_CAPLENGTH_CAPLENGTH_MASK) >> USB2O_HCIV_CAPLENGTH_CAPLENGTH_SHIFT)
#define  USB2O_HCIV_CAPLENGTH_CAPLENGTH_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCIV_CAPLENGTH_CAPLENGTH_MASK) | (((uint32_t)val) << USB2O_HCIV_CAPLENGTH_CAPLENGTH_SHIFT))

//====================================================================
//Register: Host Control Structural Parameters Register (HCSPARAMS)
//====================================================================

#define  USB2O_HCSPARAMS_RESERVED1_MASK 0xf0000000
#define  USB2O_HCSPARAMS_RESERVED1_SHIFT 28
#define  USB2O_HCSPARAMS_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_HCSPARAMS_RESERVED1_MASK) >> USB2O_HCSPARAMS_RESERVED1_SHIFT)
#define  USB2O_HCSPARAMS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCSPARAMS_RESERVED1_MASK) | (((uint32_t)val) << USB2O_HCSPARAMS_RESERVED1_SHIFT))

#define  USB2O_HCSPARAMS_NTT_MASK 0xf000000
#define  USB2O_HCSPARAMS_NTT_SHIFT 24
#define  USB2O_HCSPARAMS_NTT_MASK_SHIFT(reg) (((reg) & USB2O_HCSPARAMS_NTT_MASK) >> USB2O_HCSPARAMS_NTT_SHIFT)
#define  USB2O_HCSPARAMS_NTT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCSPARAMS_NTT_MASK) | (((uint32_t)val) << USB2O_HCSPARAMS_NTT_SHIFT))

#define  USB2O_HCSPARAMS_NPTT_MASK 0xf00000
#define  USB2O_HCSPARAMS_NPTT_SHIFT 20
#define  USB2O_HCSPARAMS_NPTT_MASK_SHIFT(reg) (((reg) & USB2O_HCSPARAMS_NPTT_MASK) >> USB2O_HCSPARAMS_NPTT_SHIFT)
#define  USB2O_HCSPARAMS_NPTT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCSPARAMS_NPTT_MASK) | (((uint32_t)val) << USB2O_HCSPARAMS_NPTT_SHIFT))

#define  USB2O_HCSPARAMS_RESERVED2_MASK 0xe0000
#define  USB2O_HCSPARAMS_RESERVED2_SHIFT 17
#define  USB2O_HCSPARAMS_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2O_HCSPARAMS_RESERVED2_MASK) >> USB2O_HCSPARAMS_RESERVED2_SHIFT)
#define  USB2O_HCSPARAMS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCSPARAMS_RESERVED2_MASK) | (((uint32_t)val) << USB2O_HCSPARAMS_RESERVED2_SHIFT))

#define  USB2O_HCSPARAMS_PI_MASK 0x10000
#define  USB2O_HCSPARAMS_PI_SHIFT 16
#define  USB2O_HCSPARAMS_PI_MASK_SHIFT(reg) (((reg) & USB2O_HCSPARAMS_PI_MASK) >> USB2O_HCSPARAMS_PI_SHIFT)
#define  USB2O_HCSPARAMS_PI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCSPARAMS_PI_MASK) | (((uint32_t)val) << USB2O_HCSPARAMS_PI_SHIFT))

#define  USB2O_HCSPARAMS_NCC_MASK 0xf000
#define  USB2O_HCSPARAMS_NCC_SHIFT 12
#define  USB2O_HCSPARAMS_NCC_MASK_SHIFT(reg) (((reg) & USB2O_HCSPARAMS_NCC_MASK) >> USB2O_HCSPARAMS_NCC_SHIFT)
#define  USB2O_HCSPARAMS_NCC_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCSPARAMS_NCC_MASK) | (((uint32_t)val) << USB2O_HCSPARAMS_NCC_SHIFT))

#define  USB2O_HCSPARAMS_NPCC_MASK 0xf00
#define  USB2O_HCSPARAMS_NPCC_SHIFT 8
#define  USB2O_HCSPARAMS_NPCC_MASK_SHIFT(reg) (((reg) & USB2O_HCSPARAMS_NPCC_MASK) >> USB2O_HCSPARAMS_NPCC_SHIFT)
#define  USB2O_HCSPARAMS_NPCC_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCSPARAMS_NPCC_MASK) | (((uint32_t)val) << USB2O_HCSPARAMS_NPCC_SHIFT))

#define  USB2O_HCSPARAMS_RESERVED3_MASK 0xe0
#define  USB2O_HCSPARAMS_RESERVED3_SHIFT 5
#define  USB2O_HCSPARAMS_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2O_HCSPARAMS_RESERVED3_MASK) >> USB2O_HCSPARAMS_RESERVED3_SHIFT)
#define  USB2O_HCSPARAMS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCSPARAMS_RESERVED3_MASK) | (((uint32_t)val) << USB2O_HCSPARAMS_RESERVED3_SHIFT))

#define  USB2O_HCSPARAMS_PPC_MASK 0x10
#define  USB2O_HCSPARAMS_PPC_SHIFT 4
#define  USB2O_HCSPARAMS_PPC_MASK_SHIFT(reg) (((reg) & USB2O_HCSPARAMS_PPC_MASK) >> USB2O_HCSPARAMS_PPC_SHIFT)
#define  USB2O_HCSPARAMS_PPC_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCSPARAMS_PPC_MASK) | (((uint32_t)val) << USB2O_HCSPARAMS_PPC_SHIFT))

#define  USB2O_HCSPARAMS_NPORTS_MASK 0xf
#define  USB2O_HCSPARAMS_NPORTS_SHIFT 0
#define  USB2O_HCSPARAMS_NPORTS_MASK_SHIFT(reg) (((reg) & USB2O_HCSPARAMS_NPORTS_MASK) >> USB2O_HCSPARAMS_NPORTS_SHIFT)
#define  USB2O_HCSPARAMS_NPORTS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCSPARAMS_NPORTS_MASK) | (((uint32_t)val) << USB2O_HCSPARAMS_NPORTS_SHIFT))

//====================================================================
//Register: Host Control Capability Parameters Register (HCCPARAMS)
//====================================================================

#define  USB2O_HCCPARAMS_RESERVED1_MASK 0xffff0000
#define  USB2O_HCCPARAMS_RESERVED1_SHIFT 16
#define  USB2O_HCCPARAMS_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_HCCPARAMS_RESERVED1_MASK) >> USB2O_HCCPARAMS_RESERVED1_SHIFT)
#define  USB2O_HCCPARAMS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCCPARAMS_RESERVED1_MASK) | (((uint32_t)val) << USB2O_HCCPARAMS_RESERVED1_SHIFT))

#define  USB2O_HCCPARAMS_EECP_MASK 0xff00
#define  USB2O_HCCPARAMS_EECP_SHIFT 8
#define  USB2O_HCCPARAMS_EECP_MASK_SHIFT(reg) (((reg) & USB2O_HCCPARAMS_EECP_MASK) >> USB2O_HCCPARAMS_EECP_SHIFT)
#define  USB2O_HCCPARAMS_EECP_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCCPARAMS_EECP_MASK) | (((uint32_t)val) << USB2O_HCCPARAMS_EECP_SHIFT))

#define  USB2O_HCCPARAMS_IST_MASK 0xf0
#define  USB2O_HCCPARAMS_IST_SHIFT 4
#define  USB2O_HCCPARAMS_IST_MASK_SHIFT(reg) (((reg) & USB2O_HCCPARAMS_IST_MASK) >> USB2O_HCCPARAMS_IST_SHIFT)
#define  USB2O_HCCPARAMS_IST_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCCPARAMS_IST_MASK) | (((uint32_t)val) << USB2O_HCCPARAMS_IST_SHIFT))

#define  USB2O_HCCPARAMS_RESERVED2_MASK 0x8
#define  USB2O_HCCPARAMS_RESERVED2_SHIFT 3
#define  USB2O_HCCPARAMS_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2O_HCCPARAMS_RESERVED2_MASK) >> USB2O_HCCPARAMS_RESERVED2_SHIFT)
#define  USB2O_HCCPARAMS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCCPARAMS_RESERVED2_MASK) | (((uint32_t)val) << USB2O_HCCPARAMS_RESERVED2_SHIFT))

#define  USB2O_HCCPARAMS_ASP_MASK 0x4
#define  USB2O_HCCPARAMS_ASP_SHIFT 2
#define  USB2O_HCCPARAMS_ASP_MASK_SHIFT(reg) (((reg) & USB2O_HCCPARAMS_ASP_MASK) >> USB2O_HCCPARAMS_ASP_SHIFT)
#define  USB2O_HCCPARAMS_ASP_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCCPARAMS_ASP_MASK) | (((uint32_t)val) << USB2O_HCCPARAMS_ASP_SHIFT))

#define  USB2O_HCCPARAMS_PFL_MASK 0x2
#define  USB2O_HCCPARAMS_PFL_SHIFT 1
#define  USB2O_HCCPARAMS_PFL_MASK_SHIFT(reg) (((reg) & USB2O_HCCPARAMS_PFL_MASK) >> USB2O_HCCPARAMS_PFL_SHIFT)
#define  USB2O_HCCPARAMS_PFL_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCCPARAMS_PFL_MASK) | (((uint32_t)val) << USB2O_HCCPARAMS_PFL_SHIFT))

#define  USB2O_HCCPARAMS_ADC_MASK 0x1
#define  USB2O_HCCPARAMS_ADC_SHIFT 0
#define  USB2O_HCCPARAMS_ADC_MASK_SHIFT(reg) (((reg) & USB2O_HCCPARAMS_ADC_MASK) >> USB2O_HCCPARAMS_ADC_SHIFT)
#define  USB2O_HCCPARAMS_ADC_REPLACE_VAL(reg,val) (((reg) & ~USB2O_HCCPARAMS_ADC_MASK) | (((uint32_t)val) << USB2O_HCCPARAMS_ADC_SHIFT))

//====================================================================
//Register: Device Controller Version Register (DCIVERSION)
//====================================================================

#define  USB2O_DCIVERSION_RESERVED1_MASK 0xffff0000
#define  USB2O_DCIVERSION_RESERVED1_SHIFT 16
#define  USB2O_DCIVERSION_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_DCIVERSION_RESERVED1_MASK) >> USB2O_DCIVERSION_RESERVED1_SHIFT)
#define  USB2O_DCIVERSION_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_DCIVERSION_RESERVED1_MASK) | (((uint32_t)val) << USB2O_DCIVERSION_RESERVED1_SHIFT))

#define  USB2O_DCIVERSION_DCIVERSION_MASK 0xffff
#define  USB2O_DCIVERSION_DCIVERSION_SHIFT 0
#define  USB2O_DCIVERSION_DCIVERSION_MASK_SHIFT(reg) (((reg) & USB2O_DCIVERSION_DCIVERSION_MASK) >> USB2O_DCIVERSION_DCIVERSION_SHIFT)
#define  USB2O_DCIVERSION_DCIVERSION_REPLACE_VAL(reg,val) (((reg) & ~USB2O_DCIVERSION_DCIVERSION_MASK) | (((uint32_t)val) << USB2O_DCIVERSION_DCIVERSION_SHIFT))

//====================================================================
//Register: Device Capability Register (DCCPARAMS)
//====================================================================

#define  USB2O_DCCPARAMS_RESERVED1_MASK 0xfffffe00
#define  USB2O_DCCPARAMS_RESERVED1_SHIFT 9
#define  USB2O_DCCPARAMS_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_DCCPARAMS_RESERVED1_MASK) >> USB2O_DCCPARAMS_RESERVED1_SHIFT)
#define  USB2O_DCCPARAMS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_DCCPARAMS_RESERVED1_MASK) | (((uint32_t)val) << USB2O_DCCPARAMS_RESERVED1_SHIFT))

#define  USB2O_DCCPARAMS_HC_MASK 0x100
#define  USB2O_DCCPARAMS_HC_SHIFT 8
#define  USB2O_DCCPARAMS_HC_MASK_SHIFT(reg) (((reg) & USB2O_DCCPARAMS_HC_MASK) >> USB2O_DCCPARAMS_HC_SHIFT)
#define  USB2O_DCCPARAMS_HC_REPLACE_VAL(reg,val) (((reg) & ~USB2O_DCCPARAMS_HC_MASK) | (((uint32_t)val) << USB2O_DCCPARAMS_HC_SHIFT))

#define  USB2O_DCCPARAMS_DC_MASK 0x80
#define  USB2O_DCCPARAMS_DC_SHIFT 7
#define  USB2O_DCCPARAMS_DC_MASK_SHIFT(reg) (((reg) & USB2O_DCCPARAMS_DC_MASK) >> USB2O_DCCPARAMS_DC_SHIFT)
#define  USB2O_DCCPARAMS_DC_REPLACE_VAL(reg,val) (((reg) & ~USB2O_DCCPARAMS_DC_MASK) | (((uint32_t)val) << USB2O_DCCPARAMS_DC_SHIFT))

#define  USB2O_DCCPARAMS_RESERVED2_MASK 0x60
#define  USB2O_DCCPARAMS_RESERVED2_SHIFT 5
#define  USB2O_DCCPARAMS_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2O_DCCPARAMS_RESERVED2_MASK) >> USB2O_DCCPARAMS_RESERVED2_SHIFT)
#define  USB2O_DCCPARAMS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2O_DCCPARAMS_RESERVED2_MASK) | (((uint32_t)val) << USB2O_DCCPARAMS_RESERVED2_SHIFT))

#define  USB2O_DCCPARAMS_DEN_MASK 0x1f
#define  USB2O_DCCPARAMS_DEN_SHIFT 0
#define  USB2O_DCCPARAMS_DEN_MASK_SHIFT(reg) (((reg) & USB2O_DCCPARAMS_DEN_MASK) >> USB2O_DCCPARAMS_DEN_SHIFT)
#define  USB2O_DCCPARAMS_DEN_REPLACE_VAL(reg,val) (((reg) & ~USB2O_DCCPARAMS_DEN_MASK) | (((uint32_t)val) << USB2O_DCCPARAMS_DEN_SHIFT))

//====================================================================
//Register: USB Command Register (USBCMD)
//====================================================================

#define  USB2O_USBCMD_RESERVED1_MASK 0xff000000
#define  USB2O_USBCMD_RESERVED1_SHIFT 24
#define  USB2O_USBCMD_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_USBCMD_RESERVED1_MASK) >> USB2O_USBCMD_RESERVED1_SHIFT)
#define  USB2O_USBCMD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBCMD_RESERVED1_MASK) | (((uint32_t)val) << USB2O_USBCMD_RESERVED1_SHIFT))

#define  USB2O_USBCMD_ITC_MASK 0xff0000
#define  USB2O_USBCMD_ITC_SHIFT 16
#define  USB2O_USBCMD_ITC_MASK_SHIFT(reg) (((reg) & USB2O_USBCMD_ITC_MASK) >> USB2O_USBCMD_ITC_SHIFT)
#define  USB2O_USBCMD_ITC_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBCMD_ITC_MASK) | (((uint32_t)val) << USB2O_USBCMD_ITC_SHIFT))

#define  USB2O_USBCMD_FS2_MASK 0x8000
#define  USB2O_USBCMD_FS2_SHIFT 15
#define  USB2O_USBCMD_FS2_MASK_SHIFT(reg) (((reg) & USB2O_USBCMD_FS2_MASK) >> USB2O_USBCMD_FS2_SHIFT)
#define  USB2O_USBCMD_FS2_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBCMD_FS2_MASK) | (((uint32_t)val) << USB2O_USBCMD_FS2_SHIFT))

#define  USB2O_USBCMD_ATDTW_MASK 0x4000
#define  USB2O_USBCMD_ATDTW_SHIFT 14
#define  USB2O_USBCMD_ATDTW_MASK_SHIFT(reg) (((reg) & USB2O_USBCMD_ATDTW_MASK) >> USB2O_USBCMD_ATDTW_SHIFT)
#define  USB2O_USBCMD_ATDTW_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBCMD_ATDTW_MASK) | (((uint32_t)val) << USB2O_USBCMD_ATDTW_SHIFT))

#define  USB2O_USBCMD_SUTW_MASK 0x2000
#define  USB2O_USBCMD_SUTW_SHIFT 13
#define  USB2O_USBCMD_SUTW_MASK_SHIFT(reg) (((reg) & USB2O_USBCMD_SUTW_MASK) >> USB2O_USBCMD_SUTW_SHIFT)
#define  USB2O_USBCMD_SUTW_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBCMD_SUTW_MASK) | (((uint32_t)val) << USB2O_USBCMD_SUTW_SHIFT))

#define  USB2O_USBCMD_RESERVED2_MASK 0x1000
#define  USB2O_USBCMD_RESERVED2_SHIFT 12
#define  USB2O_USBCMD_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2O_USBCMD_RESERVED2_MASK) >> USB2O_USBCMD_RESERVED2_SHIFT)
#define  USB2O_USBCMD_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBCMD_RESERVED2_MASK) | (((uint32_t)val) << USB2O_USBCMD_RESERVED2_SHIFT))

#define  USB2O_USBCMD_ASPE_MASK 0x800
#define  USB2O_USBCMD_ASPE_SHIFT 11
#define  USB2O_USBCMD_ASPE_MASK_SHIFT(reg) (((reg) & USB2O_USBCMD_ASPE_MASK) >> USB2O_USBCMD_ASPE_SHIFT)
#define  USB2O_USBCMD_ASPE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBCMD_ASPE_MASK) | (((uint32_t)val) << USB2O_USBCMD_ASPE_SHIFT))

#define  USB2O_USBCMD_RESERVED3_MASK 0x400
#define  USB2O_USBCMD_RESERVED3_SHIFT 10
#define  USB2O_USBCMD_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2O_USBCMD_RESERVED3_MASK) >> USB2O_USBCMD_RESERVED3_SHIFT)
#define  USB2O_USBCMD_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBCMD_RESERVED3_MASK) | (((uint32_t)val) << USB2O_USBCMD_RESERVED3_SHIFT))

#define  USB2O_USBCMD_ASP_MASK 0x300
#define  USB2O_USBCMD_ASP_SHIFT 8
#define  USB2O_USBCMD_ASP_MASK_SHIFT(reg) (((reg) & USB2O_USBCMD_ASP_MASK) >> USB2O_USBCMD_ASP_SHIFT)
#define  USB2O_USBCMD_ASP_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBCMD_ASP_MASK) | (((uint32_t)val) << USB2O_USBCMD_ASP_SHIFT))

#define  USB2O_USBCMD_LR_MASK 0x80
#define  USB2O_USBCMD_LR_SHIFT 7
#define  USB2O_USBCMD_LR_MASK_SHIFT(reg) (((reg) & USB2O_USBCMD_LR_MASK) >> USB2O_USBCMD_LR_SHIFT)
#define  USB2O_USBCMD_LR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBCMD_LR_MASK) | (((uint32_t)val) << USB2O_USBCMD_LR_SHIFT))

#define  USB2O_USBCMD_IAA_MASK 0x40
#define  USB2O_USBCMD_IAA_SHIFT 6
#define  USB2O_USBCMD_IAA_MASK_SHIFT(reg) (((reg) & USB2O_USBCMD_IAA_MASK) >> USB2O_USBCMD_IAA_SHIFT)
#define  USB2O_USBCMD_IAA_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBCMD_IAA_MASK) | (((uint32_t)val) << USB2O_USBCMD_IAA_SHIFT))

#define  USB2O_USBCMD_ASE_MASK 0x20
#define  USB2O_USBCMD_ASE_SHIFT 5
#define  USB2O_USBCMD_ASE_MASK_SHIFT(reg) (((reg) & USB2O_USBCMD_ASE_MASK) >> USB2O_USBCMD_ASE_SHIFT)
#define  USB2O_USBCMD_ASE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBCMD_ASE_MASK) | (((uint32_t)val) << USB2O_USBCMD_ASE_SHIFT))

#define  USB2O_USBCMD_PSE_MASK 0x10
#define  USB2O_USBCMD_PSE_SHIFT 4
#define  USB2O_USBCMD_PSE_MASK_SHIFT(reg) (((reg) & USB2O_USBCMD_PSE_MASK) >> USB2O_USBCMD_PSE_SHIFT)
#define  USB2O_USBCMD_PSE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBCMD_PSE_MASK) | (((uint32_t)val) << USB2O_USBCMD_PSE_SHIFT))

#define  USB2O_USBCMD_FS1_MASK 0x8
#define  USB2O_USBCMD_FS1_SHIFT 3
#define  USB2O_USBCMD_FS1_MASK_SHIFT(reg) (((reg) & USB2O_USBCMD_FS1_MASK) >> USB2O_USBCMD_FS1_SHIFT)
#define  USB2O_USBCMD_FS1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBCMD_FS1_MASK) | (((uint32_t)val) << USB2O_USBCMD_FS1_SHIFT))

#define  USB2O_USBCMD_FS0_MASK 0x4
#define  USB2O_USBCMD_FS0_SHIFT 2
#define  USB2O_USBCMD_FS0_MASK_SHIFT(reg) (((reg) & USB2O_USBCMD_FS0_MASK) >> USB2O_USBCMD_FS0_SHIFT)
#define  USB2O_USBCMD_FS0_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBCMD_FS0_MASK) | (((uint32_t)val) << USB2O_USBCMD_FS0_SHIFT))

#define  USB2O_USBCMD_RST_MASK 0x2
#define  USB2O_USBCMD_RST_SHIFT 1
#define  USB2O_USBCMD_RST_MASK_SHIFT(reg) (((reg) & USB2O_USBCMD_RST_MASK) >> USB2O_USBCMD_RST_SHIFT)
#define  USB2O_USBCMD_RST_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBCMD_RST_MASK) | (((uint32_t)val) << USB2O_USBCMD_RST_SHIFT))

#define  USB2O_USBCMD_RS_MASK 0x1
#define  USB2O_USBCMD_RS_SHIFT 0
#define  USB2O_USBCMD_RS_MASK_SHIFT(reg) (((reg) & USB2O_USBCMD_RS_MASK) >> USB2O_USBCMD_RS_SHIFT)
#define  USB2O_USBCMD_RS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBCMD_RS_MASK) | (((uint32_t)val) << USB2O_USBCMD_RS_SHIFT))

//====================================================================
//Register: USB Status Register (USBSTS)
//====================================================================

#define  USB2O_USBSTS_RESERVED1_MASK 0xfc000000
#define  USB2O_USBSTS_RESERVED1_SHIFT 26
#define  USB2O_USBSTS_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_RESERVED1_MASK) >> USB2O_USBSTS_RESERVED1_SHIFT)
#define  USB2O_USBSTS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_RESERVED1_MASK) | (((uint32_t)val) << USB2O_USBSTS_RESERVED1_SHIFT))

#define  USB2O_USBSTS_TI1_MASK 0x2000000
#define  USB2O_USBSTS_TI1_SHIFT 25
#define  USB2O_USBSTS_TI1_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_TI1_MASK) >> USB2O_USBSTS_TI1_SHIFT)
#define  USB2O_USBSTS_TI1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_TI1_MASK) | (((uint32_t)val) << USB2O_USBSTS_TI1_SHIFT))

#define  USB2O_USBSTS_TI0_MASK 0x1000000
#define  USB2O_USBSTS_TI0_SHIFT 24
#define  USB2O_USBSTS_TI0_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_TI0_MASK) >> USB2O_USBSTS_TI0_SHIFT)
#define  USB2O_USBSTS_TI0_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_TI0_MASK) | (((uint32_t)val) << USB2O_USBSTS_TI0_SHIFT))

#define  USB2O_USBSTS_RESERVED2_MASK 0xf00000
#define  USB2O_USBSTS_RESERVED2_SHIFT 20
#define  USB2O_USBSTS_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_RESERVED2_MASK) >> USB2O_USBSTS_RESERVED2_SHIFT)
#define  USB2O_USBSTS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_RESERVED2_MASK) | (((uint32_t)val) << USB2O_USBSTS_RESERVED2_SHIFT))

#define  USB2O_USBSTS_UPI_MASK 0x80000
#define  USB2O_USBSTS_UPI_SHIFT 19
#define  USB2O_USBSTS_UPI_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_UPI_MASK) >> USB2O_USBSTS_UPI_SHIFT)
#define  USB2O_USBSTS_UPI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_UPI_MASK) | (((uint32_t)val) << USB2O_USBSTS_UPI_SHIFT))

#define  USB2O_USBSTS_UAI_MASK 0x40000
#define  USB2O_USBSTS_UAI_SHIFT 18
#define  USB2O_USBSTS_UAI_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_UAI_MASK) >> USB2O_USBSTS_UAI_SHIFT)
#define  USB2O_USBSTS_UAI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_UAI_MASK) | (((uint32_t)val) << USB2O_USBSTS_UAI_SHIFT))

#define  USB2O_USBSTS_RESERVED3_MASK 0x20000
#define  USB2O_USBSTS_RESERVED3_SHIFT 17
#define  USB2O_USBSTS_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_RESERVED3_MASK) >> USB2O_USBSTS_RESERVED3_SHIFT)
#define  USB2O_USBSTS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_RESERVED3_MASK) | (((uint32_t)val) << USB2O_USBSTS_RESERVED3_SHIFT))

#define  USB2O_USBSTS_NAKI_MASK 0x10000
#define  USB2O_USBSTS_NAKI_SHIFT 16
#define  USB2O_USBSTS_NAKI_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_NAKI_MASK) >> USB2O_USBSTS_NAKI_SHIFT)
#define  USB2O_USBSTS_NAKI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_NAKI_MASK) | (((uint32_t)val) << USB2O_USBSTS_NAKI_SHIFT))

#define  USB2O_USBSTS_AS_MASK 0x8000
#define  USB2O_USBSTS_AS_SHIFT 15
#define  USB2O_USBSTS_AS_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_AS_MASK) >> USB2O_USBSTS_AS_SHIFT)
#define  USB2O_USBSTS_AS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_AS_MASK) | (((uint32_t)val) << USB2O_USBSTS_AS_SHIFT))

#define  USB2O_USBSTS_PS_MASK 0x4000
#define  USB2O_USBSTS_PS_SHIFT 14
#define  USB2O_USBSTS_PS_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_PS_MASK) >> USB2O_USBSTS_PS_SHIFT)
#define  USB2O_USBSTS_PS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_PS_MASK) | (((uint32_t)val) << USB2O_USBSTS_PS_SHIFT))

#define  USB2O_USBSTS_RCL_MASK 0x2000
#define  USB2O_USBSTS_RCL_SHIFT 13
#define  USB2O_USBSTS_RCL_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_RCL_MASK) >> USB2O_USBSTS_RCL_SHIFT)
#define  USB2O_USBSTS_RCL_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_RCL_MASK) | (((uint32_t)val) << USB2O_USBSTS_RCL_SHIFT))

#define  USB2O_USBSTS_HCH_MASK 0x1000
#define  USB2O_USBSTS_HCH_SHIFT 12
#define  USB2O_USBSTS_HCH_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_HCH_MASK) >> USB2O_USBSTS_HCH_SHIFT)
#define  USB2O_USBSTS_HCH_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_HCH_MASK) | (((uint32_t)val) << USB2O_USBSTS_HCH_SHIFT))

#define  USB2O_USBSTS_RESERVED4_MASK 0x800
#define  USB2O_USBSTS_RESERVED4_SHIFT 11
#define  USB2O_USBSTS_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_RESERVED4_MASK) >> USB2O_USBSTS_RESERVED4_SHIFT)
#define  USB2O_USBSTS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_RESERVED4_MASK) | (((uint32_t)val) << USB2O_USBSTS_RESERVED4_SHIFT))

#define  USB2O_USBSTS_RESERVED5_MASK 0x600
#define  USB2O_USBSTS_RESERVED5_SHIFT 9
#define  USB2O_USBSTS_RESERVED5_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_RESERVED5_MASK) >> USB2O_USBSTS_RESERVED5_SHIFT)
#define  USB2O_USBSTS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_RESERVED5_MASK) | (((uint32_t)val) << USB2O_USBSTS_RESERVED5_SHIFT))

#define  USB2O_USBSTS_SLI_MASK 0x100
#define  USB2O_USBSTS_SLI_SHIFT 8
#define  USB2O_USBSTS_SLI_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_SLI_MASK) >> USB2O_USBSTS_SLI_SHIFT)
#define  USB2O_USBSTS_SLI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_SLI_MASK) | (((uint32_t)val) << USB2O_USBSTS_SLI_SHIFT))

#define  USB2O_USBSTS_SRI_MASK 0x80
#define  USB2O_USBSTS_SRI_SHIFT 7
#define  USB2O_USBSTS_SRI_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_SRI_MASK) >> USB2O_USBSTS_SRI_SHIFT)
#define  USB2O_USBSTS_SRI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_SRI_MASK) | (((uint32_t)val) << USB2O_USBSTS_SRI_SHIFT))

#define  USB2O_USBSTS_URI_MASK 0x40
#define  USB2O_USBSTS_URI_SHIFT 6
#define  USB2O_USBSTS_URI_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_URI_MASK) >> USB2O_USBSTS_URI_SHIFT)
#define  USB2O_USBSTS_URI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_URI_MASK) | (((uint32_t)val) << USB2O_USBSTS_URI_SHIFT))

#define  USB2O_USBSTS_AAI_MASK 0x20
#define  USB2O_USBSTS_AAI_SHIFT 5
#define  USB2O_USBSTS_AAI_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_AAI_MASK) >> USB2O_USBSTS_AAI_SHIFT)
#define  USB2O_USBSTS_AAI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_AAI_MASK) | (((uint32_t)val) << USB2O_USBSTS_AAI_SHIFT))

#define  USB2O_USBSTS_SEI_MASK 0x10
#define  USB2O_USBSTS_SEI_SHIFT 4
#define  USB2O_USBSTS_SEI_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_SEI_MASK) >> USB2O_USBSTS_SEI_SHIFT)
#define  USB2O_USBSTS_SEI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_SEI_MASK) | (((uint32_t)val) << USB2O_USBSTS_SEI_SHIFT))

#define  USB2O_USBSTS_FRI_MASK 0x8
#define  USB2O_USBSTS_FRI_SHIFT 3
#define  USB2O_USBSTS_FRI_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_FRI_MASK) >> USB2O_USBSTS_FRI_SHIFT)
#define  USB2O_USBSTS_FRI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_FRI_MASK) | (((uint32_t)val) << USB2O_USBSTS_FRI_SHIFT))

#define  USB2O_USBSTS_PCI_MASK 0x4
#define  USB2O_USBSTS_PCI_SHIFT 2
#define  USB2O_USBSTS_PCI_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_PCI_MASK) >> USB2O_USBSTS_PCI_SHIFT)
#define  USB2O_USBSTS_PCI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_PCI_MASK) | (((uint32_t)val) << USB2O_USBSTS_PCI_SHIFT))

#define  USB2O_USBSTS_UEI_MASK 0x2
#define  USB2O_USBSTS_UEI_SHIFT 1
#define  USB2O_USBSTS_UEI_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_UEI_MASK) >> USB2O_USBSTS_UEI_SHIFT)
#define  USB2O_USBSTS_UEI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_UEI_MASK) | (((uint32_t)val) << USB2O_USBSTS_UEI_SHIFT))

#define  USB2O_USBSTS_UI_MASK 0x1
#define  USB2O_USBSTS_UI_SHIFT 0
#define  USB2O_USBSTS_UI_MASK_SHIFT(reg) (((reg) & USB2O_USBSTS_UI_MASK) >> USB2O_USBSTS_UI_SHIFT)
#define  USB2O_USBSTS_UI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBSTS_UI_MASK) | (((uint32_t)val) << USB2O_USBSTS_UI_SHIFT))

//====================================================================
//Register: USB Interrupt Enable Register (USBINTR)
//====================================================================

#define  USB2O_USBINTR_RESERVED1_MASK 0xfc000000
#define  USB2O_USBINTR_RESERVED1_SHIFT 26
#define  USB2O_USBINTR_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_USBINTR_RESERVED1_MASK) >> USB2O_USBINTR_RESERVED1_SHIFT)
#define  USB2O_USBINTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBINTR_RESERVED1_MASK) | (((uint32_t)val) << USB2O_USBINTR_RESERVED1_SHIFT))

#define  USB2O_USBINTR_TIE1_MASK 0x2000000
#define  USB2O_USBINTR_TIE1_SHIFT 25
#define  USB2O_USBINTR_TIE1_MASK_SHIFT(reg) (((reg) & USB2O_USBINTR_TIE1_MASK) >> USB2O_USBINTR_TIE1_SHIFT)
#define  USB2O_USBINTR_TIE1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBINTR_TIE1_MASK) | (((uint32_t)val) << USB2O_USBINTR_TIE1_SHIFT))

#define  USB2O_USBINTR_TIE0_MASK 0x1000000
#define  USB2O_USBINTR_TIE0_SHIFT 24
#define  USB2O_USBINTR_TIE0_MASK_SHIFT(reg) (((reg) & USB2O_USBINTR_TIE0_MASK) >> USB2O_USBINTR_TIE0_SHIFT)
#define  USB2O_USBINTR_TIE0_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBINTR_TIE0_MASK) | (((uint32_t)val) << USB2O_USBINTR_TIE0_SHIFT))

#define  USB2O_USBINTR_RESERVED2_MASK 0xf00000
#define  USB2O_USBINTR_RESERVED2_SHIFT 20
#define  USB2O_USBINTR_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2O_USBINTR_RESERVED2_MASK) >> USB2O_USBINTR_RESERVED2_SHIFT)
#define  USB2O_USBINTR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBINTR_RESERVED2_MASK) | (((uint32_t)val) << USB2O_USBINTR_RESERVED2_SHIFT))

#define  USB2O_USBINTR_UPIE_MASK 0x80000
#define  USB2O_USBINTR_UPIE_SHIFT 19
#define  USB2O_USBINTR_UPIE_MASK_SHIFT(reg) (((reg) & USB2O_USBINTR_UPIE_MASK) >> USB2O_USBINTR_UPIE_SHIFT)
#define  USB2O_USBINTR_UPIE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBINTR_UPIE_MASK) | (((uint32_t)val) << USB2O_USBINTR_UPIE_SHIFT))

#define  USB2O_USBINTR_UAIE_MASK 0x40000
#define  USB2O_USBINTR_UAIE_SHIFT 18
#define  USB2O_USBINTR_UAIE_MASK_SHIFT(reg) (((reg) & USB2O_USBINTR_UAIE_MASK) >> USB2O_USBINTR_UAIE_SHIFT)
#define  USB2O_USBINTR_UAIE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBINTR_UAIE_MASK) | (((uint32_t)val) << USB2O_USBINTR_UAIE_SHIFT))

#define  USB2O_USBINTR_RESERVED3_MASK 0x20000
#define  USB2O_USBINTR_RESERVED3_SHIFT 17
#define  USB2O_USBINTR_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2O_USBINTR_RESERVED3_MASK) >> USB2O_USBINTR_RESERVED3_SHIFT)
#define  USB2O_USBINTR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBINTR_RESERVED3_MASK) | (((uint32_t)val) << USB2O_USBINTR_RESERVED3_SHIFT))

#define  USB2O_USBINTR_NAKE_MASK 0x10000
#define  USB2O_USBINTR_NAKE_SHIFT 16
#define  USB2O_USBINTR_NAKE_MASK_SHIFT(reg) (((reg) & USB2O_USBINTR_NAKE_MASK) >> USB2O_USBINTR_NAKE_SHIFT)
#define  USB2O_USBINTR_NAKE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBINTR_NAKE_MASK) | (((uint32_t)val) << USB2O_USBINTR_NAKE_SHIFT))

#define  USB2O_USBINTR_RESERVED4_MASK 0xfe00
#define  USB2O_USBINTR_RESERVED4_SHIFT 9
#define  USB2O_USBINTR_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2O_USBINTR_RESERVED4_MASK) >> USB2O_USBINTR_RESERVED4_SHIFT)
#define  USB2O_USBINTR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBINTR_RESERVED4_MASK) | (((uint32_t)val) << USB2O_USBINTR_RESERVED4_SHIFT))

#define  USB2O_USBINTR_SLE_MASK 0x100
#define  USB2O_USBINTR_SLE_SHIFT 8
#define  USB2O_USBINTR_SLE_MASK_SHIFT(reg) (((reg) & USB2O_USBINTR_SLE_MASK) >> USB2O_USBINTR_SLE_SHIFT)
#define  USB2O_USBINTR_SLE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBINTR_SLE_MASK) | (((uint32_t)val) << USB2O_USBINTR_SLE_SHIFT))

#define  USB2O_USBINTR_SRE_MASK 0x80
#define  USB2O_USBINTR_SRE_SHIFT 7
#define  USB2O_USBINTR_SRE_MASK_SHIFT(reg) (((reg) & USB2O_USBINTR_SRE_MASK) >> USB2O_USBINTR_SRE_SHIFT)
#define  USB2O_USBINTR_SRE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBINTR_SRE_MASK) | (((uint32_t)val) << USB2O_USBINTR_SRE_SHIFT))

#define  USB2O_USBINTR_URE_MASK 0x40
#define  USB2O_USBINTR_URE_SHIFT 6
#define  USB2O_USBINTR_URE_MASK_SHIFT(reg) (((reg) & USB2O_USBINTR_URE_MASK) >> USB2O_USBINTR_URE_SHIFT)
#define  USB2O_USBINTR_URE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBINTR_URE_MASK) | (((uint32_t)val) << USB2O_USBINTR_URE_SHIFT))

#define  USB2O_USBINTR_AAE_MASK 0x20
#define  USB2O_USBINTR_AAE_SHIFT 5
#define  USB2O_USBINTR_AAE_MASK_SHIFT(reg) (((reg) & USB2O_USBINTR_AAE_MASK) >> USB2O_USBINTR_AAE_SHIFT)
#define  USB2O_USBINTR_AAE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBINTR_AAE_MASK) | (((uint32_t)val) << USB2O_USBINTR_AAE_SHIFT))

#define  USB2O_USBINTR_SEE_MASK 0x10
#define  USB2O_USBINTR_SEE_SHIFT 4
#define  USB2O_USBINTR_SEE_MASK_SHIFT(reg) (((reg) & USB2O_USBINTR_SEE_MASK) >> USB2O_USBINTR_SEE_SHIFT)
#define  USB2O_USBINTR_SEE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBINTR_SEE_MASK) | (((uint32_t)val) << USB2O_USBINTR_SEE_SHIFT))

#define  USB2O_USBINTR_FRE_MASK 0x8
#define  USB2O_USBINTR_FRE_SHIFT 3
#define  USB2O_USBINTR_FRE_MASK_SHIFT(reg) (((reg) & USB2O_USBINTR_FRE_MASK) >> USB2O_USBINTR_FRE_SHIFT)
#define  USB2O_USBINTR_FRE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBINTR_FRE_MASK) | (((uint32_t)val) << USB2O_USBINTR_FRE_SHIFT))

#define  USB2O_USBINTR_PCE_MASK 0x4
#define  USB2O_USBINTR_PCE_SHIFT 2
#define  USB2O_USBINTR_PCE_MASK_SHIFT(reg) (((reg) & USB2O_USBINTR_PCE_MASK) >> USB2O_USBINTR_PCE_SHIFT)
#define  USB2O_USBINTR_PCE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBINTR_PCE_MASK) | (((uint32_t)val) << USB2O_USBINTR_PCE_SHIFT))

#define  USB2O_USBINTR_UEE_MASK 0x2
#define  USB2O_USBINTR_UEE_SHIFT 1
#define  USB2O_USBINTR_UEE_MASK_SHIFT(reg) (((reg) & USB2O_USBINTR_UEE_MASK) >> USB2O_USBINTR_UEE_SHIFT)
#define  USB2O_USBINTR_UEE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBINTR_UEE_MASK) | (((uint32_t)val) << USB2O_USBINTR_UEE_SHIFT))

#define  USB2O_USBINTR_UE_MASK 0x1
#define  USB2O_USBINTR_UE_SHIFT 0
#define  USB2O_USBINTR_UE_MASK_SHIFT(reg) (((reg) & USB2O_USBINTR_UE_MASK) >> USB2O_USBINTR_UE_SHIFT)
#define  USB2O_USBINTR_UE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBINTR_UE_MASK) | (((uint32_t)val) << USB2O_USBINTR_UE_SHIFT))

//====================================================================
//Register: Frame Index Register (FRINDEX)
//====================================================================

#define  USB2O_FRINDEX_RESERVED1_MASK 0xffffc000
#define  USB2O_FRINDEX_RESERVED1_SHIFT 14
#define  USB2O_FRINDEX_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_FRINDEX_RESERVED1_MASK) >> USB2O_FRINDEX_RESERVED1_SHIFT)
#define  USB2O_FRINDEX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_FRINDEX_RESERVED1_MASK) | (((uint32_t)val) << USB2O_FRINDEX_RESERVED1_SHIFT))

#define  USB2O_FRINDEX_FRINDEX_MASK 0x3fff
#define  USB2O_FRINDEX_FRINDEX_SHIFT 0
#define  USB2O_FRINDEX_FRINDEX_MASK_SHIFT(reg) (((reg) & USB2O_FRINDEX_FRINDEX_MASK) >> USB2O_FRINDEX_FRINDEX_SHIFT)
#define  USB2O_FRINDEX_FRINDEX_REPLACE_VAL(reg,val) (((reg) & ~USB2O_FRINDEX_FRINDEX_MASK) | (((uint32_t)val) << USB2O_FRINDEX_FRINDEX_SHIFT))

//====================================================================
//Register: Device Address Register (DEVICEADDR)
//====================================================================

#define  USB2O_DEVICEADDR_USBADR_MASK 0xfe000000
#define  USB2O_DEVICEADDR_USBADR_SHIFT 25
#define  USB2O_DEVICEADDR_USBADR_MASK_SHIFT(reg) (((reg) & USB2O_DEVICEADDR_USBADR_MASK) >> USB2O_DEVICEADDR_USBADR_SHIFT)
#define  USB2O_DEVICEADDR_USBADR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_DEVICEADDR_USBADR_MASK) | (((uint32_t)val) << USB2O_DEVICEADDR_USBADR_SHIFT))

#define  USB2O_DEVICEADDR_USBADRA_MASK 0x1000000
#define  USB2O_DEVICEADDR_USBADRA_SHIFT 24
#define  USB2O_DEVICEADDR_USBADRA_MASK_SHIFT(reg) (((reg) & USB2O_DEVICEADDR_USBADRA_MASK) >> USB2O_DEVICEADDR_USBADRA_SHIFT)
#define  USB2O_DEVICEADDR_USBADRA_REPLACE_VAL(reg,val) (((reg) & ~USB2O_DEVICEADDR_USBADRA_MASK) | (((uint32_t)val) << USB2O_DEVICEADDR_USBADRA_SHIFT))

#define  USB2O_DEVICEADDR_RESERVED1_MASK 0xffffff
#define  USB2O_DEVICEADDR_RESERVED1_SHIFT 0
#define  USB2O_DEVICEADDR_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_DEVICEADDR_RESERVED1_MASK) >> USB2O_DEVICEADDR_RESERVED1_SHIFT)
#define  USB2O_DEVICEADDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_DEVICEADDR_RESERVED1_MASK) | (((uint32_t)val) << USB2O_DEVICEADDR_RESERVED1_SHIFT))

//====================================================================
//Register: Host Controller Frame List Base Address Register (PLISTBASE)
//====================================================================

#define  USB2O_PLISTBASE_PERBASE_MASK 0xfffff000
#define  USB2O_PLISTBASE_PERBASE_SHIFT 12
#define  USB2O_PLISTBASE_PERBASE_MASK_SHIFT(reg) (((reg) & USB2O_PLISTBASE_PERBASE_MASK) >> USB2O_PLISTBASE_PERBASE_SHIFT)
#define  USB2O_PLISTBASE_PERBASE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PLISTBASE_PERBASE_MASK) | (((uint32_t)val) << USB2O_PLISTBASE_PERBASE_SHIFT))

#define  USB2O_PLISTBASE_RESERVED1_MASK 0xfff
#define  USB2O_PLISTBASE_RESERVED1_SHIFT 0
#define  USB2O_PLISTBASE_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_PLISTBASE_RESERVED1_MASK) >> USB2O_PLISTBASE_RESERVED1_SHIFT)
#define  USB2O_PLISTBASE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PLISTBASE_RESERVED1_MASK) | (((uint32_t)val) << USB2O_PLISTBASE_RESERVED1_SHIFT))

//====================================================================
//Register: Endpoint List Address Register (EPLISTADDR)
//====================================================================

#define  USB2O_EPLISTADDR_EPBASE_MASK 0xfffff800
#define  USB2O_EPLISTADDR_EPBASE_SHIFT 11
#define  USB2O_EPLISTADDR_EPBASE_MASK_SHIFT(reg) (((reg) & USB2O_EPLISTADDR_EPBASE_MASK) >> USB2O_EPLISTADDR_EPBASE_SHIFT)
#define  USB2O_EPLISTADDR_EPBASE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_EPLISTADDR_EPBASE_MASK) | (((uint32_t)val) << USB2O_EPLISTADDR_EPBASE_SHIFT))

#define  USB2O_EPLISTADDR_RESERVED1_MASK 0x7ff
#define  USB2O_EPLISTADDR_RESERVED1_SHIFT 0
#define  USB2O_EPLISTADDR_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_EPLISTADDR_RESERVED1_MASK) >> USB2O_EPLISTADDR_RESERVED1_SHIFT)
#define  USB2O_EPLISTADDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_EPLISTADDR_RESERVED1_MASK) | (((uint32_t)val) << USB2O_EPLISTADDR_RESERVED1_SHIFT))

//====================================================================
//Register: Host Controller Next Asynch Address Register (ASYNCLISTADDR)
//====================================================================

#define  USB2O_ASYNCLISTADDR_ASYBASE_MASK 0xffffffe0
#define  USB2O_ASYNCLISTADDR_ASYBASE_SHIFT 5
#define  USB2O_ASYNCLISTADDR_ASYBASE_MASK_SHIFT(reg) (((reg) & USB2O_ASYNCLISTADDR_ASYBASE_MASK) >> USB2O_ASYNCLISTADDR_ASYBASE_SHIFT)
#define  USB2O_ASYNCLISTADDR_ASYBASE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ASYNCLISTADDR_ASYBASE_MASK) | (((uint32_t)val) << USB2O_ASYNCLISTADDR_ASYBASE_SHIFT))

#define  USB2O_ASYNCLISTADDR_RESERVED1_MASK 0x1f
#define  USB2O_ASYNCLISTADDR_RESERVED1_SHIFT 0
#define  USB2O_ASYNCLISTADDR_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_ASYNCLISTADDR_RESERVED1_MASK) >> USB2O_ASYNCLISTADDR_RESERVED1_SHIFT)
#define  USB2O_ASYNCLISTADDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ASYNCLISTADDR_RESERVED1_MASK) | (((uint32_t)val) << USB2O_ASYNCLISTADDR_RESERVED1_SHIFT))

//====================================================================
//Register: Host Controller Embedded TT Async Buffer Status Register (TTCTRL)
//====================================================================

#define  USB2O_TTCTRL_RESERVED1_MASK 0x80000000
#define  USB2O_TTCTRL_RESERVED1_SHIFT 31
#define  USB2O_TTCTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_TTCTRL_RESERVED1_MASK) >> USB2O_TTCTRL_RESERVED1_SHIFT)
#define  USB2O_TTCTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_TTCTRL_RESERVED1_MASK) | (((uint32_t)val) << USB2O_TTCTRL_RESERVED1_SHIFT))

#define  USB2O_TTCTRL_TTHA_MASK 0x7f000000
#define  USB2O_TTCTRL_TTHA_SHIFT 24
#define  USB2O_TTCTRL_TTHA_MASK_SHIFT(reg) (((reg) & USB2O_TTCTRL_TTHA_MASK) >> USB2O_TTCTRL_TTHA_SHIFT)
#define  USB2O_TTCTRL_TTHA_REPLACE_VAL(reg,val) (((reg) & ~USB2O_TTCTRL_TTHA_MASK) | (((uint32_t)val) << USB2O_TTCTRL_TTHA_SHIFT))

#define  USB2O_TTCTRL_RESERVED2_MASK 0xffffff
#define  USB2O_TTCTRL_RESERVED2_SHIFT 0
#define  USB2O_TTCTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2O_TTCTRL_RESERVED2_MASK) >> USB2O_TTCTRL_RESERVED2_SHIFT)
#define  USB2O_TTCTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2O_TTCTRL_RESERVED2_MASK) | (((uint32_t)val) << USB2O_TTCTRL_RESERVED2_SHIFT))

//====================================================================
//Register: Burst Size Register (BURSTSIZE)
//====================================================================

#define  USB2O_BURSTSIZE_RESERVED1_MASK 0xffff0000
#define  USB2O_BURSTSIZE_RESERVED1_SHIFT 16
#define  USB2O_BURSTSIZE_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_BURSTSIZE_RESERVED1_MASK) >> USB2O_BURSTSIZE_RESERVED1_SHIFT)
#define  USB2O_BURSTSIZE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_BURSTSIZE_RESERVED1_MASK) | (((uint32_t)val) << USB2O_BURSTSIZE_RESERVED1_SHIFT))

#define  USB2O_BURSTSIZE_TXPBURST_MASK 0xff00
#define  USB2O_BURSTSIZE_TXPBURST_SHIFT 8
#define  USB2O_BURSTSIZE_TXPBURST_MASK_SHIFT(reg) (((reg) & USB2O_BURSTSIZE_TXPBURST_MASK) >> USB2O_BURSTSIZE_TXPBURST_SHIFT)
#define  USB2O_BURSTSIZE_TXPBURST_REPLACE_VAL(reg,val) (((reg) & ~USB2O_BURSTSIZE_TXPBURST_MASK) | (((uint32_t)val) << USB2O_BURSTSIZE_TXPBURST_SHIFT))

#define  USB2O_BURSTSIZE_RXPBURST_MASK 0xff
#define  USB2O_BURSTSIZE_RXPBURST_SHIFT 0
#define  USB2O_BURSTSIZE_RXPBURST_MASK_SHIFT(reg) (((reg) & USB2O_BURSTSIZE_RXPBURST_MASK) >> USB2O_BURSTSIZE_RXPBURST_SHIFT)
#define  USB2O_BURSTSIZE_RXPBURST_REPLACE_VAL(reg,val) (((reg) & ~USB2O_BURSTSIZE_RXPBURST_MASK) | (((uint32_t)val) << USB2O_BURSTSIZE_RXPBURST_SHIFT))

//====================================================================
//Register: TX Fill Tuning Register (TXFILLTUNING)
//====================================================================

#define  USB2O_TXFILLTUNING_RESERVED1_MASK 0xffc00000
#define  USB2O_TXFILLTUNING_RESERVED1_SHIFT 22
#define  USB2O_TXFILLTUNING_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_TXFILLTUNING_RESERVED1_MASK) >> USB2O_TXFILLTUNING_RESERVED1_SHIFT)
#define  USB2O_TXFILLTUNING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_TXFILLTUNING_RESERVED1_MASK) | (((uint32_t)val) << USB2O_TXFILLTUNING_RESERVED1_SHIFT))

#define  USB2O_TXFILLTUNING_TXFIFOTHRES_MASK 0x3f0000
#define  USB2O_TXFILLTUNING_TXFIFOTHRES_SHIFT 16
#define  USB2O_TXFILLTUNING_TXFIFOTHRES_MASK_SHIFT(reg) (((reg) & USB2O_TXFILLTUNING_TXFIFOTHRES_MASK) >> USB2O_TXFILLTUNING_TXFIFOTHRES_SHIFT)
#define  USB2O_TXFILLTUNING_TXFIFOTHRES_REPLACE_VAL(reg,val) (((reg) & ~USB2O_TXFILLTUNING_TXFIFOTHRES_MASK) | (((uint32_t)val) << USB2O_TXFILLTUNING_TXFIFOTHRES_SHIFT))

#define  USB2O_TXFILLTUNING_RESERVED2_MASK 0xe000
#define  USB2O_TXFILLTUNING_RESERVED2_SHIFT 13
#define  USB2O_TXFILLTUNING_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2O_TXFILLTUNING_RESERVED2_MASK) >> USB2O_TXFILLTUNING_RESERVED2_SHIFT)
#define  USB2O_TXFILLTUNING_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2O_TXFILLTUNING_RESERVED2_MASK) | (((uint32_t)val) << USB2O_TXFILLTUNING_RESERVED2_SHIFT))

#define  USB2O_TXFILLTUNING_TXSCHEALTH_MASK 0x1f00
#define  USB2O_TXFILLTUNING_TXSCHEALTH_SHIFT 8
#define  USB2O_TXFILLTUNING_TXSCHEALTH_MASK_SHIFT(reg) (((reg) & USB2O_TXFILLTUNING_TXSCHEALTH_MASK) >> USB2O_TXFILLTUNING_TXSCHEALTH_SHIFT)
#define  USB2O_TXFILLTUNING_TXSCHEALTH_REPLACE_VAL(reg,val) (((reg) & ~USB2O_TXFILLTUNING_TXSCHEALTH_MASK) | (((uint32_t)val) << USB2O_TXFILLTUNING_TXSCHEALTH_SHIFT))

#define  USB2O_TXFILLTUNING_RESERVED3_MASK 0x80
#define  USB2O_TXFILLTUNING_RESERVED3_SHIFT 7
#define  USB2O_TXFILLTUNING_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2O_TXFILLTUNING_RESERVED3_MASK) >> USB2O_TXFILLTUNING_RESERVED3_SHIFT)
#define  USB2O_TXFILLTUNING_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2O_TXFILLTUNING_RESERVED3_MASK) | (((uint32_t)val) << USB2O_TXFILLTUNING_RESERVED3_SHIFT))

#define  USB2O_TXFILLTUNING_TXSCHOH_MASK 0x7f
#define  USB2O_TXFILLTUNING_TXSCHOH_SHIFT 0
#define  USB2O_TXFILLTUNING_TXSCHOH_MASK_SHIFT(reg) (((reg) & USB2O_TXFILLTUNING_TXSCHOH_MASK) >> USB2O_TXFILLTUNING_TXSCHOH_SHIFT)
#define  USB2O_TXFILLTUNING_TXSCHOH_REPLACE_VAL(reg,val) (((reg) & ~USB2O_TXFILLTUNING_TXSCHOH_MASK) | (((uint32_t)val) << USB2O_TXFILLTUNING_TXSCHOH_SHIFT))

//====================================================================
//Register: Endpoint NAK Register (ENDPTNAK)
//====================================================================

#define  USB2O_ENDPTNAK_EPTN_MASK 0xffff0000
#define  USB2O_ENDPTNAK_EPTN_SHIFT 16
#define  USB2O_ENDPTNAK_EPTN_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTNAK_EPTN_MASK) >> USB2O_ENDPTNAK_EPTN_SHIFT)
#define  USB2O_ENDPTNAK_EPTN_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTNAK_EPTN_MASK) | (((uint32_t)val) << USB2O_ENDPTNAK_EPTN_SHIFT))

#define  USB2O_ENDPTNAK_EPRN_MASK 0xffff
#define  USB2O_ENDPTNAK_EPRN_SHIFT 0
#define  USB2O_ENDPTNAK_EPRN_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTNAK_EPRN_MASK) >> USB2O_ENDPTNAK_EPRN_SHIFT)
#define  USB2O_ENDPTNAK_EPRN_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTNAK_EPRN_MASK) | (((uint32_t)val) << USB2O_ENDPTNAK_EPRN_SHIFT))

//====================================================================
//Register: Endpoint NAK Enable Register (ENDPTNAKEN)
//====================================================================

#define  USB2O_ENDPTNAKEN_EPTNE_MASK 0xffff0000
#define  USB2O_ENDPTNAKEN_EPTNE_SHIFT 16
#define  USB2O_ENDPTNAKEN_EPTNE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTNAKEN_EPTNE_MASK) >> USB2O_ENDPTNAKEN_EPTNE_SHIFT)
#define  USB2O_ENDPTNAKEN_EPTNE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTNAKEN_EPTNE_MASK) | (((uint32_t)val) << USB2O_ENDPTNAKEN_EPTNE_SHIFT))

#define  USB2O_ENDPTNAKEN_EPRNE_MASK 0xffff
#define  USB2O_ENDPTNAKEN_EPRNE_SHIFT 0
#define  USB2O_ENDPTNAKEN_EPRNE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTNAKEN_EPRNE_MASK) >> USB2O_ENDPTNAKEN_EPRNE_SHIFT)
#define  USB2O_ENDPTNAKEN_EPRNE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTNAKEN_EPRNE_MASK) | (((uint32_t)val) << USB2O_ENDPTNAKEN_EPRNE_SHIFT))

//====================================================================
//Register: Config Flag Register (CONFIGFLAG)
//====================================================================

#define  USB2O_CONFIGFLAG_CFLAG_MASK 0xffffffff
#define  USB2O_CONFIGFLAG_CFLAG_SHIFT 0
#define  USB2O_CONFIGFLAG_CFLAG_MASK_SHIFT(reg) (((reg) & USB2O_CONFIGFLAG_CFLAG_MASK) >> USB2O_CONFIGFLAG_CFLAG_SHIFT)
#define  USB2O_CONFIGFLAG_CFLAG_REPLACE_VAL(reg,val) (((reg) & ~USB2O_CONFIGFLAG_CFLAG_MASK) | (((uint32_t)val) << USB2O_CONFIGFLAG_CFLAG_SHIFT))

//====================================================================
//Register: Port Status Control Register (PORTSC)
//====================================================================

#define  USB2O_PORTSC_PTS_MASK 0xc0000000
#define  USB2O_PORTSC_PTS_SHIFT 30
#define  USB2O_PORTSC_PTS_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_PTS_MASK) >> USB2O_PORTSC_PTS_SHIFT)
#define  USB2O_PORTSC_PTS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_PTS_MASK) | (((uint32_t)val) << USB2O_PORTSC_PTS_SHIFT))

#define  USB2O_PORTSC_STS_MASK 0x20000000
#define  USB2O_PORTSC_STS_SHIFT 29
#define  USB2O_PORTSC_STS_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_STS_MASK) >> USB2O_PORTSC_STS_SHIFT)
#define  USB2O_PORTSC_STS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_STS_MASK) | (((uint32_t)val) << USB2O_PORTSC_STS_SHIFT))

#define  USB2O_PORTSC_PTW_MASK 0x10000000
#define  USB2O_PORTSC_PTW_SHIFT 28
#define  USB2O_PORTSC_PTW_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_PTW_MASK) >> USB2O_PORTSC_PTW_SHIFT)
#define  USB2O_PORTSC_PTW_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_PTW_MASK) | (((uint32_t)val) << USB2O_PORTSC_PTW_SHIFT))

#define  USB2O_PORTSC_PSPD_MASK 0xc000000
#define  USB2O_PORTSC_PSPD_SHIFT 26
#define  USB2O_PORTSC_PSPD_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_PSPD_MASK) >> USB2O_PORTSC_PSPD_SHIFT)
#define  USB2O_PORTSC_PSPD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_PSPD_MASK) | (((uint32_t)val) << USB2O_PORTSC_PSPD_SHIFT))

#define  USB2O_PORTSC_SRT_MASK 0x2000000
#define  USB2O_PORTSC_SRT_SHIFT 25
#define  USB2O_PORTSC_SRT_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_SRT_MASK) >> USB2O_PORTSC_SRT_SHIFT)
#define  USB2O_PORTSC_SRT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_SRT_MASK) | (((uint32_t)val) << USB2O_PORTSC_SRT_SHIFT))

#define  USB2O_PORTSC_PFSC_MASK 0x1000000
#define  USB2O_PORTSC_PFSC_SHIFT 24
#define  USB2O_PORTSC_PFSC_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_PFSC_MASK) >> USB2O_PORTSC_PFSC_SHIFT)
#define  USB2O_PORTSC_PFSC_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_PFSC_MASK) | (((uint32_t)val) << USB2O_PORTSC_PFSC_SHIFT))

#define  USB2O_PORTSC_PHCD_MASK 0x800000
#define  USB2O_PORTSC_PHCD_SHIFT 23
#define  USB2O_PORTSC_PHCD_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_PHCD_MASK) >> USB2O_PORTSC_PHCD_SHIFT)
#define  USB2O_PORTSC_PHCD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_PHCD_MASK) | (((uint32_t)val) << USB2O_PORTSC_PHCD_SHIFT))

#define  USB2O_PORTSC_WKOC_MASK 0x400000
#define  USB2O_PORTSC_WKOC_SHIFT 22
#define  USB2O_PORTSC_WKOC_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_WKOC_MASK) >> USB2O_PORTSC_WKOC_SHIFT)
#define  USB2O_PORTSC_WKOC_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_WKOC_MASK) | (((uint32_t)val) << USB2O_PORTSC_WKOC_SHIFT))

#define  USB2O_PORTSC_WKDS_MASK 0x200000
#define  USB2O_PORTSC_WKDS_SHIFT 21
#define  USB2O_PORTSC_WKDS_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_WKDS_MASK) >> USB2O_PORTSC_WKDS_SHIFT)
#define  USB2O_PORTSC_WKDS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_WKDS_MASK) | (((uint32_t)val) << USB2O_PORTSC_WKDS_SHIFT))

#define  USB2O_PORTSC_WKCN_MASK 0x100000
#define  USB2O_PORTSC_WKCN_SHIFT 20
#define  USB2O_PORTSC_WKCN_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_WKCN_MASK) >> USB2O_PORTSC_WKCN_SHIFT)
#define  USB2O_PORTSC_WKCN_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_WKCN_MASK) | (((uint32_t)val) << USB2O_PORTSC_WKCN_SHIFT))

#define  USB2O_PORTSC_PTC_MASK 0xf0000
#define  USB2O_PORTSC_PTC_SHIFT 16
#define  USB2O_PORTSC_PTC_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_PTC_MASK) >> USB2O_PORTSC_PTC_SHIFT)
#define  USB2O_PORTSC_PTC_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_PTC_MASK) | (((uint32_t)val) << USB2O_PORTSC_PTC_SHIFT))

#define  USB2O_PORTSC_PIC_MASK 0xc000
#define  USB2O_PORTSC_PIC_SHIFT 14
#define  USB2O_PORTSC_PIC_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_PIC_MASK) >> USB2O_PORTSC_PIC_SHIFT)
#define  USB2O_PORTSC_PIC_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_PIC_MASK) | (((uint32_t)val) << USB2O_PORTSC_PIC_SHIFT))

#define  USB2O_PORTSC_PO_MASK 0x2000
#define  USB2O_PORTSC_PO_SHIFT 13
#define  USB2O_PORTSC_PO_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_PO_MASK) >> USB2O_PORTSC_PO_SHIFT)
#define  USB2O_PORTSC_PO_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_PO_MASK) | (((uint32_t)val) << USB2O_PORTSC_PO_SHIFT))

#define  USB2O_PORTSC_PP_MASK 0x1000
#define  USB2O_PORTSC_PP_SHIFT 12
#define  USB2O_PORTSC_PP_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_PP_MASK) >> USB2O_PORTSC_PP_SHIFT)
#define  USB2O_PORTSC_PP_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_PP_MASK) | (((uint32_t)val) << USB2O_PORTSC_PP_SHIFT))

#define  USB2O_PORTSC_LS_MASK 0xc00
#define  USB2O_PORTSC_LS_SHIFT 10
#define  USB2O_PORTSC_LS_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_LS_MASK) >> USB2O_PORTSC_LS_SHIFT)
#define  USB2O_PORTSC_LS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_LS_MASK) | (((uint32_t)val) << USB2O_PORTSC_LS_SHIFT))

#define  USB2O_PORTSC_HSP_MASK 0x200
#define  USB2O_PORTSC_HSP_SHIFT 9
#define  USB2O_PORTSC_HSP_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_HSP_MASK) >> USB2O_PORTSC_HSP_SHIFT)
#define  USB2O_PORTSC_HSP_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_HSP_MASK) | (((uint32_t)val) << USB2O_PORTSC_HSP_SHIFT))

#define  USB2O_PORTSC_PR_MASK 0x100
#define  USB2O_PORTSC_PR_SHIFT 8
#define  USB2O_PORTSC_PR_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_PR_MASK) >> USB2O_PORTSC_PR_SHIFT)
#define  USB2O_PORTSC_PR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_PR_MASK) | (((uint32_t)val) << USB2O_PORTSC_PR_SHIFT))

#define  USB2O_PORTSC_SUSP_MASK 0x80
#define  USB2O_PORTSC_SUSP_SHIFT 7
#define  USB2O_PORTSC_SUSP_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_SUSP_MASK) >> USB2O_PORTSC_SUSP_SHIFT)
#define  USB2O_PORTSC_SUSP_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_SUSP_MASK) | (((uint32_t)val) << USB2O_PORTSC_SUSP_SHIFT))

#define  USB2O_PORTSC_FPR_MASK 0x40
#define  USB2O_PORTSC_FPR_SHIFT 6
#define  USB2O_PORTSC_FPR_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_FPR_MASK) >> USB2O_PORTSC_FPR_SHIFT)
#define  USB2O_PORTSC_FPR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_FPR_MASK) | (((uint32_t)val) << USB2O_PORTSC_FPR_SHIFT))

#define  USB2O_PORTSC_OCC_MASK 0x20
#define  USB2O_PORTSC_OCC_SHIFT 5
#define  USB2O_PORTSC_OCC_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_OCC_MASK) >> USB2O_PORTSC_OCC_SHIFT)
#define  USB2O_PORTSC_OCC_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_OCC_MASK) | (((uint32_t)val) << USB2O_PORTSC_OCC_SHIFT))

#define  USB2O_PORTSC_OCA_MASK 0x10
#define  USB2O_PORTSC_OCA_SHIFT 4
#define  USB2O_PORTSC_OCA_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_OCA_MASK) >> USB2O_PORTSC_OCA_SHIFT)
#define  USB2O_PORTSC_OCA_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_OCA_MASK) | (((uint32_t)val) << USB2O_PORTSC_OCA_SHIFT))

#define  USB2O_PORTSC_PEC_MASK 0x8
#define  USB2O_PORTSC_PEC_SHIFT 3
#define  USB2O_PORTSC_PEC_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_PEC_MASK) >> USB2O_PORTSC_PEC_SHIFT)
#define  USB2O_PORTSC_PEC_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_PEC_MASK) | (((uint32_t)val) << USB2O_PORTSC_PEC_SHIFT))

#define  USB2O_PORTSC_PE_MASK 0x4
#define  USB2O_PORTSC_PE_SHIFT 2
#define  USB2O_PORTSC_PE_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_PE_MASK) >> USB2O_PORTSC_PE_SHIFT)
#define  USB2O_PORTSC_PE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_PE_MASK) | (((uint32_t)val) << USB2O_PORTSC_PE_SHIFT))

#define  USB2O_PORTSC_CSC_MASK 0x2
#define  USB2O_PORTSC_CSC_SHIFT 1
#define  USB2O_PORTSC_CSC_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_CSC_MASK) >> USB2O_PORTSC_CSC_SHIFT)
#define  USB2O_PORTSC_CSC_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_CSC_MASK) | (((uint32_t)val) << USB2O_PORTSC_CSC_SHIFT))

#define  USB2O_PORTSC_CCS_MASK 0x1
#define  USB2O_PORTSC_CCS_SHIFT 0
#define  USB2O_PORTSC_CCS_MASK_SHIFT(reg) (((reg) & USB2O_PORTSC_CCS_MASK) >> USB2O_PORTSC_CCS_SHIFT)
#define  USB2O_PORTSC_CCS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_PORTSC_CCS_MASK) | (((uint32_t)val) << USB2O_PORTSC_CCS_SHIFT))

//====================================================================
//Register: USB Device Mode Register (USBMODE)
//====================================================================

#define  USB2O_USBMODE_RESERVED1_MASK 0xffffffc0
#define  USB2O_USBMODE_RESERVED1_SHIFT 6
#define  USB2O_USBMODE_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_USBMODE_RESERVED1_MASK) >> USB2O_USBMODE_RESERVED1_SHIFT)
#define  USB2O_USBMODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBMODE_RESERVED1_MASK) | (((uint32_t)val) << USB2O_USBMODE_RESERVED1_SHIFT))

#define  USB2O_USBMODE_VBPS_MASK 0x20
#define  USB2O_USBMODE_VBPS_SHIFT 5
#define  USB2O_USBMODE_VBPS_MASK_SHIFT(reg) (((reg) & USB2O_USBMODE_VBPS_MASK) >> USB2O_USBMODE_VBPS_SHIFT)
#define  USB2O_USBMODE_VBPS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBMODE_VBPS_MASK) | (((uint32_t)val) << USB2O_USBMODE_VBPS_SHIFT))

#define  USB2O_USBMODE_SDIS_MASK 0x10
#define  USB2O_USBMODE_SDIS_SHIFT 4
#define  USB2O_USBMODE_SDIS_MASK_SHIFT(reg) (((reg) & USB2O_USBMODE_SDIS_MASK) >> USB2O_USBMODE_SDIS_SHIFT)
#define  USB2O_USBMODE_SDIS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBMODE_SDIS_MASK) | (((uint32_t)val) << USB2O_USBMODE_SDIS_SHIFT))

#define  USB2O_USBMODE_SLOM_MASK 0x8
#define  USB2O_USBMODE_SLOM_SHIFT 3
#define  USB2O_USBMODE_SLOM_MASK_SHIFT(reg) (((reg) & USB2O_USBMODE_SLOM_MASK) >> USB2O_USBMODE_SLOM_SHIFT)
#define  USB2O_USBMODE_SLOM_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBMODE_SLOM_MASK) | (((uint32_t)val) << USB2O_USBMODE_SLOM_SHIFT))

#define  USB2O_USBMODE_ES_MASK 0x4
#define  USB2O_USBMODE_ES_SHIFT 2
#define  USB2O_USBMODE_ES_MASK_SHIFT(reg) (((reg) & USB2O_USBMODE_ES_MASK) >> USB2O_USBMODE_ES_SHIFT)
#define  USB2O_USBMODE_ES_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBMODE_ES_MASK) | (((uint32_t)val) << USB2O_USBMODE_ES_SHIFT))

#define  USB2O_USBMODE_CM_MASK 0x3
#define  USB2O_USBMODE_CM_SHIFT 0
#define  USB2O_USBMODE_CM_MASK_SHIFT(reg) (((reg) & USB2O_USBMODE_CM_MASK) >> USB2O_USBMODE_CM_SHIFT)
#define  USB2O_USBMODE_CM_REPLACE_VAL(reg,val) (((reg) & ~USB2O_USBMODE_CM_MASK) | (((uint32_t)val) << USB2O_USBMODE_CM_SHIFT))

//====================================================================
//Register: Endpoint Setup Status Register (ENDPTSETUPSTAT)
//====================================================================

#define  USB2O_ENDPTSETUPSTAT_RESERVED1_MASK 0xffff0000
#define  USB2O_ENDPTSETUPSTAT_RESERVED1_SHIFT 16
#define  USB2O_ENDPTSETUPSTAT_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTSETUPSTAT_RESERVED1_MASK) >> USB2O_ENDPTSETUPSTAT_RESERVED1_SHIFT)
#define  USB2O_ENDPTSETUPSTAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTSETUPSTAT_RESERVED1_MASK) | (((uint32_t)val) << USB2O_ENDPTSETUPSTAT_RESERVED1_SHIFT))

#define  USB2O_ENDPTSETUPSTAT_ENDPTSETUPSTAT_MASK 0xffff
#define  USB2O_ENDPTSETUPSTAT_ENDPTSETUPSTAT_SHIFT 0
#define  USB2O_ENDPTSETUPSTAT_ENDPTSETUPSTAT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTSETUPSTAT_ENDPTSETUPSTAT_MASK) >> USB2O_ENDPTSETUPSTAT_ENDPTSETUPSTAT_SHIFT)
#define  USB2O_ENDPTSETUPSTAT_ENDPTSETUPSTAT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTSETUPSTAT_ENDPTSETUPSTAT_MASK) | (((uint32_t)val) << USB2O_ENDPTSETUPSTAT_ENDPTSETUPSTAT_SHIFT))

//====================================================================
//Register: Endpoint Initialization Register (ENDPTPRIME)
//====================================================================

#define  USB2O_ENDPTPRIME_PETB_MASK 0xffff0000
#define  USB2O_ENDPTPRIME_PETB_SHIFT 16
#define  USB2O_ENDPTPRIME_PETB_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTPRIME_PETB_MASK) >> USB2O_ENDPTPRIME_PETB_SHIFT)
#define  USB2O_ENDPTPRIME_PETB_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTPRIME_PETB_MASK) | (((uint32_t)val) << USB2O_ENDPTPRIME_PETB_SHIFT))

#define  USB2O_ENDPTPRIME_PERB_MASK 0xffff
#define  USB2O_ENDPTPRIME_PERB_SHIFT 0
#define  USB2O_ENDPTPRIME_PERB_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTPRIME_PERB_MASK) >> USB2O_ENDPTPRIME_PERB_SHIFT)
#define  USB2O_ENDPTPRIME_PERB_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTPRIME_PERB_MASK) | (((uint32_t)val) << USB2O_ENDPTPRIME_PERB_SHIFT))

//====================================================================
//Register: Endpoint De-Initialize Register (ENDPTFLUSH)
//====================================================================

#define  USB2O_ENDPTFLUSH_FETB_MASK 0xffff0000
#define  USB2O_ENDPTFLUSH_FETB_SHIFT 16
#define  USB2O_ENDPTFLUSH_FETB_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTFLUSH_FETB_MASK) >> USB2O_ENDPTFLUSH_FETB_SHIFT)
#define  USB2O_ENDPTFLUSH_FETB_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTFLUSH_FETB_MASK) | (((uint32_t)val) << USB2O_ENDPTFLUSH_FETB_SHIFT))

#define  USB2O_ENDPTFLUSH_FERB_MASK 0xffff
#define  USB2O_ENDPTFLUSH_FERB_SHIFT 0
#define  USB2O_ENDPTFLUSH_FERB_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTFLUSH_FERB_MASK) >> USB2O_ENDPTFLUSH_FERB_SHIFT)
#define  USB2O_ENDPTFLUSH_FERB_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTFLUSH_FERB_MASK) | (((uint32_t)val) << USB2O_ENDPTFLUSH_FERB_SHIFT))

//====================================================================
//Register: Endpoint Status Register (ENDPTSTAT)
//====================================================================

#define  USB2O_ENDPTSTAT_ETBR_MASK 0xffff0000
#define  USB2O_ENDPTSTAT_ETBR_SHIFT 16
#define  USB2O_ENDPTSTAT_ETBR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTSTAT_ETBR_MASK) >> USB2O_ENDPTSTAT_ETBR_SHIFT)
#define  USB2O_ENDPTSTAT_ETBR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTSTAT_ETBR_MASK) | (((uint32_t)val) << USB2O_ENDPTSTAT_ETBR_SHIFT))

#define  USB2O_ENDPTSTAT_ERBR_MASK 0xffff
#define  USB2O_ENDPTSTAT_ERBR_SHIFT 0
#define  USB2O_ENDPTSTAT_ERBR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTSTAT_ERBR_MASK) >> USB2O_ENDPTSTAT_ERBR_SHIFT)
#define  USB2O_ENDPTSTAT_ERBR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTSTAT_ERBR_MASK) | (((uint32_t)val) << USB2O_ENDPTSTAT_ERBR_SHIFT))

//====================================================================
//Register: Endpoint Complete Register (ENDPTCOMPLETE)
//====================================================================

#define  USB2O_ENDPTCOMPLETE_ETCE_MASK 0xffff0000
#define  USB2O_ENDPTCOMPLETE_ETCE_SHIFT 16
#define  USB2O_ENDPTCOMPLETE_ETCE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCOMPLETE_ETCE_MASK) >> USB2O_ENDPTCOMPLETE_ETCE_SHIFT)
#define  USB2O_ENDPTCOMPLETE_ETCE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCOMPLETE_ETCE_MASK) | (((uint32_t)val) << USB2O_ENDPTCOMPLETE_ETCE_SHIFT))

#define  USB2O_ENDPTCOMPLETE_ERCE_MASK 0xffff
#define  USB2O_ENDPTCOMPLETE_ERCE_SHIFT 0
#define  USB2O_ENDPTCOMPLETE_ERCE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCOMPLETE_ERCE_MASK) >> USB2O_ENDPTCOMPLETE_ERCE_SHIFT)
#define  USB2O_ENDPTCOMPLETE_ERCE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCOMPLETE_ERCE_MASK) | (((uint32_t)val) << USB2O_ENDPTCOMPLETE_ERCE_SHIFT))

//====================================================================
//Register: Endpoint Control 0 Register (ENDPTCTRL_0)
//====================================================================

#define  USB2O_ENDPTCTRL_0_RESERVED1_MASK 0xff000000
#define  USB2O_ENDPTCTRL_0_RESERVED1_SHIFT 24
#define  USB2O_ENDPTCTRL_0_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL_0_RESERVED1_MASK) >> USB2O_ENDPTCTRL_0_RESERVED1_SHIFT)
#define  USB2O_ENDPTCTRL_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL_0_RESERVED1_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL_0_RESERVED1_SHIFT))

#define  USB2O_ENDPTCTRL_0_TXE_MASK 0x800000
#define  USB2O_ENDPTCTRL_0_TXE_SHIFT 23
#define  USB2O_ENDPTCTRL_0_TXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL_0_TXE_MASK) >> USB2O_ENDPTCTRL_0_TXE_SHIFT)
#define  USB2O_ENDPTCTRL_0_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL_0_TXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL_0_TXE_SHIFT))

#define  USB2O_ENDPTCTRL_0_RESERVED2_MASK 0x700000
#define  USB2O_ENDPTCTRL_0_RESERVED2_SHIFT 20
#define  USB2O_ENDPTCTRL_0_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL_0_RESERVED2_MASK) >> USB2O_ENDPTCTRL_0_RESERVED2_SHIFT)
#define  USB2O_ENDPTCTRL_0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL_0_RESERVED2_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL_0_RESERVED2_SHIFT))

#define  USB2O_ENDPTCTRL_0_TXT_MASK 0xc0000
#define  USB2O_ENDPTCTRL_0_TXT_SHIFT 18
#define  USB2O_ENDPTCTRL_0_TXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL_0_TXT_MASK) >> USB2O_ENDPTCTRL_0_TXT_SHIFT)
#define  USB2O_ENDPTCTRL_0_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL_0_TXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL_0_TXT_SHIFT))

#define  USB2O_ENDPTCTRL_0_RESERVED3_MASK 0x20000
#define  USB2O_ENDPTCTRL_0_RESERVED3_SHIFT 17
#define  USB2O_ENDPTCTRL_0_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL_0_RESERVED3_MASK) >> USB2O_ENDPTCTRL_0_RESERVED3_SHIFT)
#define  USB2O_ENDPTCTRL_0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL_0_RESERVED3_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL_0_RESERVED3_SHIFT))

#define  USB2O_ENDPTCTRL_0_TXS_MASK 0x10000
#define  USB2O_ENDPTCTRL_0_TXS_SHIFT 16
#define  USB2O_ENDPTCTRL_0_TXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL_0_TXS_MASK) >> USB2O_ENDPTCTRL_0_TXS_SHIFT)
#define  USB2O_ENDPTCTRL_0_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL_0_TXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL_0_TXS_SHIFT))

#define  USB2O_ENDPTCTRL_0_RESERVED4_MASK 0xff00
#define  USB2O_ENDPTCTRL_0_RESERVED4_SHIFT 8
#define  USB2O_ENDPTCTRL_0_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL_0_RESERVED4_MASK) >> USB2O_ENDPTCTRL_0_RESERVED4_SHIFT)
#define  USB2O_ENDPTCTRL_0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL_0_RESERVED4_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL_0_RESERVED4_SHIFT))

#define  USB2O_ENDPTCTRL_0_RXE_MASK 0x80
#define  USB2O_ENDPTCTRL_0_RXE_SHIFT 7
#define  USB2O_ENDPTCTRL_0_RXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL_0_RXE_MASK) >> USB2O_ENDPTCTRL_0_RXE_SHIFT)
#define  USB2O_ENDPTCTRL_0_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL_0_RXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL_0_RXE_SHIFT))

#define  USB2O_ENDPTCTRL_0_RESERVED5_MASK 0x70
#define  USB2O_ENDPTCTRL_0_RESERVED5_SHIFT 4
#define  USB2O_ENDPTCTRL_0_RESERVED5_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL_0_RESERVED5_MASK) >> USB2O_ENDPTCTRL_0_RESERVED5_SHIFT)
#define  USB2O_ENDPTCTRL_0_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL_0_RESERVED5_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL_0_RESERVED5_SHIFT))

#define  USB2O_ENDPTCTRL_0_RXT_MASK 0xc
#define  USB2O_ENDPTCTRL_0_RXT_SHIFT 2
#define  USB2O_ENDPTCTRL_0_RXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL_0_RXT_MASK) >> USB2O_ENDPTCTRL_0_RXT_SHIFT)
#define  USB2O_ENDPTCTRL_0_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL_0_RXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL_0_RXT_SHIFT))

#define  USB2O_ENDPTCTRL_0_RESERVED6_MASK 0x2
#define  USB2O_ENDPTCTRL_0_RESERVED6_SHIFT 1
#define  USB2O_ENDPTCTRL_0_RESERVED6_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL_0_RESERVED6_MASK) >> USB2O_ENDPTCTRL_0_RESERVED6_SHIFT)
#define  USB2O_ENDPTCTRL_0_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL_0_RESERVED6_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL_0_RESERVED6_SHIFT))

#define  USB2O_ENDPTCTRL_0_RXS_MASK 0x1
#define  USB2O_ENDPTCTRL_0_RXS_SHIFT 0
#define  USB2O_ENDPTCTRL_0_RXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL_0_RXS_MASK) >> USB2O_ENDPTCTRL_0_RXS_SHIFT)
#define  USB2O_ENDPTCTRL_0_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL_0_RXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL_0_RXS_SHIFT))

//====================================================================
//Register: Endpoint Control Register (Instance 1 of 9) (ENDPTCTRL1)
/** \brief  (Instance 1 of 9)*/
//====================================================================

#define  USB2O_ENDPTCTRL1_RESERVED1_MASK 0xff000000
#define  USB2O_ENDPTCTRL1_RESERVED1_SHIFT 24
#define  USB2O_ENDPTCTRL1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL1_RESERVED1_MASK) >> USB2O_ENDPTCTRL1_RESERVED1_SHIFT)
#define  USB2O_ENDPTCTRL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL1_RESERVED1_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL1_RESERVED1_SHIFT))

#define  USB2O_ENDPTCTRL1_TXE_MASK 0x800000
#define  USB2O_ENDPTCTRL1_TXE_SHIFT 23
#define  USB2O_ENDPTCTRL1_TXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL1_TXE_MASK) >> USB2O_ENDPTCTRL1_TXE_SHIFT)
#define  USB2O_ENDPTCTRL1_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL1_TXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL1_TXE_SHIFT))

#define  USB2O_ENDPTCTRL1_TXR_MASK 0x400000
#define  USB2O_ENDPTCTRL1_TXR_SHIFT 22
#define  USB2O_ENDPTCTRL1_TXR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL1_TXR_MASK) >> USB2O_ENDPTCTRL1_TXR_SHIFT)
#define  USB2O_ENDPTCTRL1_TXR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL1_TXR_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL1_TXR_SHIFT))

#define  USB2O_ENDPTCTRL1_TXI_MASK 0x200000
#define  USB2O_ENDPTCTRL1_TXI_SHIFT 21
#define  USB2O_ENDPTCTRL1_TXI_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL1_TXI_MASK) >> USB2O_ENDPTCTRL1_TXI_SHIFT)
#define  USB2O_ENDPTCTRL1_TXI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL1_TXI_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL1_TXI_SHIFT))

#define  USB2O_ENDPTCTRL1_RESERVED2_MASK 0x100000
#define  USB2O_ENDPTCTRL1_RESERVED2_SHIFT 20
#define  USB2O_ENDPTCTRL1_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL1_RESERVED2_MASK) >> USB2O_ENDPTCTRL1_RESERVED2_SHIFT)
#define  USB2O_ENDPTCTRL1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL1_RESERVED2_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL1_RESERVED2_SHIFT))

#define  USB2O_ENDPTCTRL1_TXT_MASK 0xc0000
#define  USB2O_ENDPTCTRL1_TXT_SHIFT 18
#define  USB2O_ENDPTCTRL1_TXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL1_TXT_MASK) >> USB2O_ENDPTCTRL1_TXT_SHIFT)
#define  USB2O_ENDPTCTRL1_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL1_TXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL1_TXT_SHIFT))

#define  USB2O_ENDPTCTRL1_TXD_MASK 0x20000
#define  USB2O_ENDPTCTRL1_TXD_SHIFT 17
#define  USB2O_ENDPTCTRL1_TXD_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL1_TXD_MASK) >> USB2O_ENDPTCTRL1_TXD_SHIFT)
#define  USB2O_ENDPTCTRL1_TXD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL1_TXD_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL1_TXD_SHIFT))

#define  USB2O_ENDPTCTRL1_TXS_MASK 0x10000
#define  USB2O_ENDPTCTRL1_TXS_SHIFT 16
#define  USB2O_ENDPTCTRL1_TXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL1_TXS_MASK) >> USB2O_ENDPTCTRL1_TXS_SHIFT)
#define  USB2O_ENDPTCTRL1_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL1_TXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL1_TXS_SHIFT))

#define  USB2O_ENDPTCTRL1_RESERVED3_MASK 0xff00
#define  USB2O_ENDPTCTRL1_RESERVED3_SHIFT 8
#define  USB2O_ENDPTCTRL1_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL1_RESERVED3_MASK) >> USB2O_ENDPTCTRL1_RESERVED3_SHIFT)
#define  USB2O_ENDPTCTRL1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL1_RESERVED3_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL1_RESERVED3_SHIFT))

#define  USB2O_ENDPTCTRL1_RXE_MASK 0x80
#define  USB2O_ENDPTCTRL1_RXE_SHIFT 7
#define  USB2O_ENDPTCTRL1_RXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL1_RXE_MASK) >> USB2O_ENDPTCTRL1_RXE_SHIFT)
#define  USB2O_ENDPTCTRL1_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL1_RXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL1_RXE_SHIFT))

#define  USB2O_ENDPTCTRL1_RXR_MASK 0x40
#define  USB2O_ENDPTCTRL1_RXR_SHIFT 6
#define  USB2O_ENDPTCTRL1_RXR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL1_RXR_MASK) >> USB2O_ENDPTCTRL1_RXR_SHIFT)
#define  USB2O_ENDPTCTRL1_RXR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL1_RXR_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL1_RXR_SHIFT))

#define  USB2O_ENDPTCTRL1_RXI_MASK 0x20
#define  USB2O_ENDPTCTRL1_RXI_SHIFT 5
#define  USB2O_ENDPTCTRL1_RXI_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL1_RXI_MASK) >> USB2O_ENDPTCTRL1_RXI_SHIFT)
#define  USB2O_ENDPTCTRL1_RXI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL1_RXI_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL1_RXI_SHIFT))

#define  USB2O_ENDPTCTRL1_RESERVED4_MASK 0x10
#define  USB2O_ENDPTCTRL1_RESERVED4_SHIFT 4
#define  USB2O_ENDPTCTRL1_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL1_RESERVED4_MASK) >> USB2O_ENDPTCTRL1_RESERVED4_SHIFT)
#define  USB2O_ENDPTCTRL1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL1_RESERVED4_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL1_RESERVED4_SHIFT))

#define  USB2O_ENDPTCTRL1_RXT_MASK 0xc
#define  USB2O_ENDPTCTRL1_RXT_SHIFT 2
#define  USB2O_ENDPTCTRL1_RXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL1_RXT_MASK) >> USB2O_ENDPTCTRL1_RXT_SHIFT)
#define  USB2O_ENDPTCTRL1_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL1_RXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL1_RXT_SHIFT))

#define  USB2O_ENDPTCTRL1_RXD_MASK 0x2
#define  USB2O_ENDPTCTRL1_RXD_SHIFT 1
#define  USB2O_ENDPTCTRL1_RXD_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL1_RXD_MASK) >> USB2O_ENDPTCTRL1_RXD_SHIFT)
#define  USB2O_ENDPTCTRL1_RXD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL1_RXD_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL1_RXD_SHIFT))

#define  USB2O_ENDPTCTRL1_RXS_MASK 0x1
#define  USB2O_ENDPTCTRL1_RXS_SHIFT 0
#define  USB2O_ENDPTCTRL1_RXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL1_RXS_MASK) >> USB2O_ENDPTCTRL1_RXS_SHIFT)
#define  USB2O_ENDPTCTRL1_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL1_RXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL1_RXS_SHIFT))

//====================================================================
//Register: Endpoint Control Register (Instance 2 of 9) (ENDPTCTRL2)
/** \brief  (Instance 2 of 9)*/
//====================================================================

#define  USB2O_ENDPTCTRL2_RESERVED1_MASK 0xff000000
#define  USB2O_ENDPTCTRL2_RESERVED1_SHIFT 24
#define  USB2O_ENDPTCTRL2_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL2_RESERVED1_MASK) >> USB2O_ENDPTCTRL2_RESERVED1_SHIFT)
#define  USB2O_ENDPTCTRL2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL2_RESERVED1_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL2_RESERVED1_SHIFT))

#define  USB2O_ENDPTCTRL2_TXE_MASK 0x800000
#define  USB2O_ENDPTCTRL2_TXE_SHIFT 23
#define  USB2O_ENDPTCTRL2_TXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL2_TXE_MASK) >> USB2O_ENDPTCTRL2_TXE_SHIFT)
#define  USB2O_ENDPTCTRL2_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL2_TXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL2_TXE_SHIFT))

#define  USB2O_ENDPTCTRL2_TXR_MASK 0x400000
#define  USB2O_ENDPTCTRL2_TXR_SHIFT 22
#define  USB2O_ENDPTCTRL2_TXR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL2_TXR_MASK) >> USB2O_ENDPTCTRL2_TXR_SHIFT)
#define  USB2O_ENDPTCTRL2_TXR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL2_TXR_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL2_TXR_SHIFT))

#define  USB2O_ENDPTCTRL2_TXI_MASK 0x200000
#define  USB2O_ENDPTCTRL2_TXI_SHIFT 21
#define  USB2O_ENDPTCTRL2_TXI_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL2_TXI_MASK) >> USB2O_ENDPTCTRL2_TXI_SHIFT)
#define  USB2O_ENDPTCTRL2_TXI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL2_TXI_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL2_TXI_SHIFT))

#define  USB2O_ENDPTCTRL2_RESERVED2_MASK 0x100000
#define  USB2O_ENDPTCTRL2_RESERVED2_SHIFT 20
#define  USB2O_ENDPTCTRL2_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL2_RESERVED2_MASK) >> USB2O_ENDPTCTRL2_RESERVED2_SHIFT)
#define  USB2O_ENDPTCTRL2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL2_RESERVED2_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL2_RESERVED2_SHIFT))

#define  USB2O_ENDPTCTRL2_TXT_MASK 0xc0000
#define  USB2O_ENDPTCTRL2_TXT_SHIFT 18
#define  USB2O_ENDPTCTRL2_TXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL2_TXT_MASK) >> USB2O_ENDPTCTRL2_TXT_SHIFT)
#define  USB2O_ENDPTCTRL2_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL2_TXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL2_TXT_SHIFT))

#define  USB2O_ENDPTCTRL2_TXD_MASK 0x20000
#define  USB2O_ENDPTCTRL2_TXD_SHIFT 17
#define  USB2O_ENDPTCTRL2_TXD_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL2_TXD_MASK) >> USB2O_ENDPTCTRL2_TXD_SHIFT)
#define  USB2O_ENDPTCTRL2_TXD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL2_TXD_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL2_TXD_SHIFT))

#define  USB2O_ENDPTCTRL2_TXS_MASK 0x10000
#define  USB2O_ENDPTCTRL2_TXS_SHIFT 16
#define  USB2O_ENDPTCTRL2_TXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL2_TXS_MASK) >> USB2O_ENDPTCTRL2_TXS_SHIFT)
#define  USB2O_ENDPTCTRL2_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL2_TXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL2_TXS_SHIFT))

#define  USB2O_ENDPTCTRL2_RESERVED3_MASK 0xff00
#define  USB2O_ENDPTCTRL2_RESERVED3_SHIFT 8
#define  USB2O_ENDPTCTRL2_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL2_RESERVED3_MASK) >> USB2O_ENDPTCTRL2_RESERVED3_SHIFT)
#define  USB2O_ENDPTCTRL2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL2_RESERVED3_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL2_RESERVED3_SHIFT))

#define  USB2O_ENDPTCTRL2_RXE_MASK 0x80
#define  USB2O_ENDPTCTRL2_RXE_SHIFT 7
#define  USB2O_ENDPTCTRL2_RXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL2_RXE_MASK) >> USB2O_ENDPTCTRL2_RXE_SHIFT)
#define  USB2O_ENDPTCTRL2_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL2_RXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL2_RXE_SHIFT))

#define  USB2O_ENDPTCTRL2_RXR_MASK 0x40
#define  USB2O_ENDPTCTRL2_RXR_SHIFT 6
#define  USB2O_ENDPTCTRL2_RXR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL2_RXR_MASK) >> USB2O_ENDPTCTRL2_RXR_SHIFT)
#define  USB2O_ENDPTCTRL2_RXR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL2_RXR_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL2_RXR_SHIFT))

#define  USB2O_ENDPTCTRL2_RXI_MASK 0x20
#define  USB2O_ENDPTCTRL2_RXI_SHIFT 5
#define  USB2O_ENDPTCTRL2_RXI_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL2_RXI_MASK) >> USB2O_ENDPTCTRL2_RXI_SHIFT)
#define  USB2O_ENDPTCTRL2_RXI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL2_RXI_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL2_RXI_SHIFT))

#define  USB2O_ENDPTCTRL2_RESERVED4_MASK 0x10
#define  USB2O_ENDPTCTRL2_RESERVED4_SHIFT 4
#define  USB2O_ENDPTCTRL2_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL2_RESERVED4_MASK) >> USB2O_ENDPTCTRL2_RESERVED4_SHIFT)
#define  USB2O_ENDPTCTRL2_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL2_RESERVED4_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL2_RESERVED4_SHIFT))

#define  USB2O_ENDPTCTRL2_RXT_MASK 0xc
#define  USB2O_ENDPTCTRL2_RXT_SHIFT 2
#define  USB2O_ENDPTCTRL2_RXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL2_RXT_MASK) >> USB2O_ENDPTCTRL2_RXT_SHIFT)
#define  USB2O_ENDPTCTRL2_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL2_RXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL2_RXT_SHIFT))

#define  USB2O_ENDPTCTRL2_RXD_MASK 0x2
#define  USB2O_ENDPTCTRL2_RXD_SHIFT 1
#define  USB2O_ENDPTCTRL2_RXD_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL2_RXD_MASK) >> USB2O_ENDPTCTRL2_RXD_SHIFT)
#define  USB2O_ENDPTCTRL2_RXD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL2_RXD_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL2_RXD_SHIFT))

#define  USB2O_ENDPTCTRL2_RXS_MASK 0x1
#define  USB2O_ENDPTCTRL2_RXS_SHIFT 0
#define  USB2O_ENDPTCTRL2_RXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL2_RXS_MASK) >> USB2O_ENDPTCTRL2_RXS_SHIFT)
#define  USB2O_ENDPTCTRL2_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL2_RXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL2_RXS_SHIFT))

//====================================================================
//Register: Endpoint Control Register (Instance 3 of 9) (ENDPTCTRL3)
/** \brief  (Instance 3 of 9)*/
//====================================================================

#define  USB2O_ENDPTCTRL3_RESERVED1_MASK 0xff000000
#define  USB2O_ENDPTCTRL3_RESERVED1_SHIFT 24
#define  USB2O_ENDPTCTRL3_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL3_RESERVED1_MASK) >> USB2O_ENDPTCTRL3_RESERVED1_SHIFT)
#define  USB2O_ENDPTCTRL3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL3_RESERVED1_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL3_RESERVED1_SHIFT))

#define  USB2O_ENDPTCTRL3_TXE_MASK 0x800000
#define  USB2O_ENDPTCTRL3_TXE_SHIFT 23
#define  USB2O_ENDPTCTRL3_TXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL3_TXE_MASK) >> USB2O_ENDPTCTRL3_TXE_SHIFT)
#define  USB2O_ENDPTCTRL3_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL3_TXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL3_TXE_SHIFT))

#define  USB2O_ENDPTCTRL3_TXR_MASK 0x400000
#define  USB2O_ENDPTCTRL3_TXR_SHIFT 22
#define  USB2O_ENDPTCTRL3_TXR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL3_TXR_MASK) >> USB2O_ENDPTCTRL3_TXR_SHIFT)
#define  USB2O_ENDPTCTRL3_TXR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL3_TXR_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL3_TXR_SHIFT))

#define  USB2O_ENDPTCTRL3_TXI_MASK 0x200000
#define  USB2O_ENDPTCTRL3_TXI_SHIFT 21
#define  USB2O_ENDPTCTRL3_TXI_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL3_TXI_MASK) >> USB2O_ENDPTCTRL3_TXI_SHIFT)
#define  USB2O_ENDPTCTRL3_TXI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL3_TXI_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL3_TXI_SHIFT))

#define  USB2O_ENDPTCTRL3_RESERVED2_MASK 0x100000
#define  USB2O_ENDPTCTRL3_RESERVED2_SHIFT 20
#define  USB2O_ENDPTCTRL3_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL3_RESERVED2_MASK) >> USB2O_ENDPTCTRL3_RESERVED2_SHIFT)
#define  USB2O_ENDPTCTRL3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL3_RESERVED2_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL3_RESERVED2_SHIFT))

#define  USB2O_ENDPTCTRL3_TXT_MASK 0xc0000
#define  USB2O_ENDPTCTRL3_TXT_SHIFT 18
#define  USB2O_ENDPTCTRL3_TXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL3_TXT_MASK) >> USB2O_ENDPTCTRL3_TXT_SHIFT)
#define  USB2O_ENDPTCTRL3_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL3_TXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL3_TXT_SHIFT))

#define  USB2O_ENDPTCTRL3_TXD_MASK 0x20000
#define  USB2O_ENDPTCTRL3_TXD_SHIFT 17
#define  USB2O_ENDPTCTRL3_TXD_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL3_TXD_MASK) >> USB2O_ENDPTCTRL3_TXD_SHIFT)
#define  USB2O_ENDPTCTRL3_TXD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL3_TXD_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL3_TXD_SHIFT))

#define  USB2O_ENDPTCTRL3_TXS_MASK 0x10000
#define  USB2O_ENDPTCTRL3_TXS_SHIFT 16
#define  USB2O_ENDPTCTRL3_TXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL3_TXS_MASK) >> USB2O_ENDPTCTRL3_TXS_SHIFT)
#define  USB2O_ENDPTCTRL3_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL3_TXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL3_TXS_SHIFT))

#define  USB2O_ENDPTCTRL3_RESERVED3_MASK 0xff00
#define  USB2O_ENDPTCTRL3_RESERVED3_SHIFT 8
#define  USB2O_ENDPTCTRL3_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL3_RESERVED3_MASK) >> USB2O_ENDPTCTRL3_RESERVED3_SHIFT)
#define  USB2O_ENDPTCTRL3_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL3_RESERVED3_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL3_RESERVED3_SHIFT))

#define  USB2O_ENDPTCTRL3_RXE_MASK 0x80
#define  USB2O_ENDPTCTRL3_RXE_SHIFT 7
#define  USB2O_ENDPTCTRL3_RXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL3_RXE_MASK) >> USB2O_ENDPTCTRL3_RXE_SHIFT)
#define  USB2O_ENDPTCTRL3_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL3_RXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL3_RXE_SHIFT))

#define  USB2O_ENDPTCTRL3_RXR_MASK 0x40
#define  USB2O_ENDPTCTRL3_RXR_SHIFT 6
#define  USB2O_ENDPTCTRL3_RXR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL3_RXR_MASK) >> USB2O_ENDPTCTRL3_RXR_SHIFT)
#define  USB2O_ENDPTCTRL3_RXR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL3_RXR_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL3_RXR_SHIFT))

#define  USB2O_ENDPTCTRL3_RXI_MASK 0x20
#define  USB2O_ENDPTCTRL3_RXI_SHIFT 5
#define  USB2O_ENDPTCTRL3_RXI_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL3_RXI_MASK) >> USB2O_ENDPTCTRL3_RXI_SHIFT)
#define  USB2O_ENDPTCTRL3_RXI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL3_RXI_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL3_RXI_SHIFT))

#define  USB2O_ENDPTCTRL3_RESERVED4_MASK 0x10
#define  USB2O_ENDPTCTRL3_RESERVED4_SHIFT 4
#define  USB2O_ENDPTCTRL3_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL3_RESERVED4_MASK) >> USB2O_ENDPTCTRL3_RESERVED4_SHIFT)
#define  USB2O_ENDPTCTRL3_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL3_RESERVED4_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL3_RESERVED4_SHIFT))

#define  USB2O_ENDPTCTRL3_RXT_MASK 0xc
#define  USB2O_ENDPTCTRL3_RXT_SHIFT 2
#define  USB2O_ENDPTCTRL3_RXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL3_RXT_MASK) >> USB2O_ENDPTCTRL3_RXT_SHIFT)
#define  USB2O_ENDPTCTRL3_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL3_RXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL3_RXT_SHIFT))

#define  USB2O_ENDPTCTRL3_RXD_MASK 0x2
#define  USB2O_ENDPTCTRL3_RXD_SHIFT 1
#define  USB2O_ENDPTCTRL3_RXD_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL3_RXD_MASK) >> USB2O_ENDPTCTRL3_RXD_SHIFT)
#define  USB2O_ENDPTCTRL3_RXD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL3_RXD_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL3_RXD_SHIFT))

#define  USB2O_ENDPTCTRL3_RXS_MASK 0x1
#define  USB2O_ENDPTCTRL3_RXS_SHIFT 0
#define  USB2O_ENDPTCTRL3_RXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL3_RXS_MASK) >> USB2O_ENDPTCTRL3_RXS_SHIFT)
#define  USB2O_ENDPTCTRL3_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL3_RXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL3_RXS_SHIFT))

//====================================================================
//Register: Endpoint Control Register (Instance 4 of 9) (ENDPTCTRL4)
/** \brief  (Instance 4 of 9)*/
//====================================================================

#define  USB2O_ENDPTCTRL4_RESERVED1_MASK 0xff000000
#define  USB2O_ENDPTCTRL4_RESERVED1_SHIFT 24
#define  USB2O_ENDPTCTRL4_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL4_RESERVED1_MASK) >> USB2O_ENDPTCTRL4_RESERVED1_SHIFT)
#define  USB2O_ENDPTCTRL4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL4_RESERVED1_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL4_RESERVED1_SHIFT))

#define  USB2O_ENDPTCTRL4_TXE_MASK 0x800000
#define  USB2O_ENDPTCTRL4_TXE_SHIFT 23
#define  USB2O_ENDPTCTRL4_TXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL4_TXE_MASK) >> USB2O_ENDPTCTRL4_TXE_SHIFT)
#define  USB2O_ENDPTCTRL4_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL4_TXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL4_TXE_SHIFT))

#define  USB2O_ENDPTCTRL4_TXR_MASK 0x400000
#define  USB2O_ENDPTCTRL4_TXR_SHIFT 22
#define  USB2O_ENDPTCTRL4_TXR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL4_TXR_MASK) >> USB2O_ENDPTCTRL4_TXR_SHIFT)
#define  USB2O_ENDPTCTRL4_TXR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL4_TXR_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL4_TXR_SHIFT))

#define  USB2O_ENDPTCTRL4_TXI_MASK 0x200000
#define  USB2O_ENDPTCTRL4_TXI_SHIFT 21
#define  USB2O_ENDPTCTRL4_TXI_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL4_TXI_MASK) >> USB2O_ENDPTCTRL4_TXI_SHIFT)
#define  USB2O_ENDPTCTRL4_TXI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL4_TXI_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL4_TXI_SHIFT))

#define  USB2O_ENDPTCTRL4_RESERVED2_MASK 0x100000
#define  USB2O_ENDPTCTRL4_RESERVED2_SHIFT 20
#define  USB2O_ENDPTCTRL4_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL4_RESERVED2_MASK) >> USB2O_ENDPTCTRL4_RESERVED2_SHIFT)
#define  USB2O_ENDPTCTRL4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL4_RESERVED2_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL4_RESERVED2_SHIFT))

#define  USB2O_ENDPTCTRL4_TXT_MASK 0xc0000
#define  USB2O_ENDPTCTRL4_TXT_SHIFT 18
#define  USB2O_ENDPTCTRL4_TXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL4_TXT_MASK) >> USB2O_ENDPTCTRL4_TXT_SHIFT)
#define  USB2O_ENDPTCTRL4_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL4_TXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL4_TXT_SHIFT))

#define  USB2O_ENDPTCTRL4_TXD_MASK 0x20000
#define  USB2O_ENDPTCTRL4_TXD_SHIFT 17
#define  USB2O_ENDPTCTRL4_TXD_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL4_TXD_MASK) >> USB2O_ENDPTCTRL4_TXD_SHIFT)
#define  USB2O_ENDPTCTRL4_TXD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL4_TXD_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL4_TXD_SHIFT))

#define  USB2O_ENDPTCTRL4_TXS_MASK 0x10000
#define  USB2O_ENDPTCTRL4_TXS_SHIFT 16
#define  USB2O_ENDPTCTRL4_TXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL4_TXS_MASK) >> USB2O_ENDPTCTRL4_TXS_SHIFT)
#define  USB2O_ENDPTCTRL4_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL4_TXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL4_TXS_SHIFT))

#define  USB2O_ENDPTCTRL4_RESERVED3_MASK 0xff00
#define  USB2O_ENDPTCTRL4_RESERVED3_SHIFT 8
#define  USB2O_ENDPTCTRL4_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL4_RESERVED3_MASK) >> USB2O_ENDPTCTRL4_RESERVED3_SHIFT)
#define  USB2O_ENDPTCTRL4_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL4_RESERVED3_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL4_RESERVED3_SHIFT))

#define  USB2O_ENDPTCTRL4_RXE_MASK 0x80
#define  USB2O_ENDPTCTRL4_RXE_SHIFT 7
#define  USB2O_ENDPTCTRL4_RXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL4_RXE_MASK) >> USB2O_ENDPTCTRL4_RXE_SHIFT)
#define  USB2O_ENDPTCTRL4_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL4_RXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL4_RXE_SHIFT))

#define  USB2O_ENDPTCTRL4_RXR_MASK 0x40
#define  USB2O_ENDPTCTRL4_RXR_SHIFT 6
#define  USB2O_ENDPTCTRL4_RXR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL4_RXR_MASK) >> USB2O_ENDPTCTRL4_RXR_SHIFT)
#define  USB2O_ENDPTCTRL4_RXR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL4_RXR_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL4_RXR_SHIFT))

#define  USB2O_ENDPTCTRL4_RXI_MASK 0x20
#define  USB2O_ENDPTCTRL4_RXI_SHIFT 5
#define  USB2O_ENDPTCTRL4_RXI_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL4_RXI_MASK) >> USB2O_ENDPTCTRL4_RXI_SHIFT)
#define  USB2O_ENDPTCTRL4_RXI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL4_RXI_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL4_RXI_SHIFT))

#define  USB2O_ENDPTCTRL4_RESERVED4_MASK 0x10
#define  USB2O_ENDPTCTRL4_RESERVED4_SHIFT 4
#define  USB2O_ENDPTCTRL4_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL4_RESERVED4_MASK) >> USB2O_ENDPTCTRL4_RESERVED4_SHIFT)
#define  USB2O_ENDPTCTRL4_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL4_RESERVED4_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL4_RESERVED4_SHIFT))

#define  USB2O_ENDPTCTRL4_RXT_MASK 0xc
#define  USB2O_ENDPTCTRL4_RXT_SHIFT 2
#define  USB2O_ENDPTCTRL4_RXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL4_RXT_MASK) >> USB2O_ENDPTCTRL4_RXT_SHIFT)
#define  USB2O_ENDPTCTRL4_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL4_RXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL4_RXT_SHIFT))

#define  USB2O_ENDPTCTRL4_RXD_MASK 0x2
#define  USB2O_ENDPTCTRL4_RXD_SHIFT 1
#define  USB2O_ENDPTCTRL4_RXD_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL4_RXD_MASK) >> USB2O_ENDPTCTRL4_RXD_SHIFT)
#define  USB2O_ENDPTCTRL4_RXD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL4_RXD_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL4_RXD_SHIFT))

#define  USB2O_ENDPTCTRL4_RXS_MASK 0x1
#define  USB2O_ENDPTCTRL4_RXS_SHIFT 0
#define  USB2O_ENDPTCTRL4_RXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL4_RXS_MASK) >> USB2O_ENDPTCTRL4_RXS_SHIFT)
#define  USB2O_ENDPTCTRL4_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL4_RXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL4_RXS_SHIFT))

//====================================================================
//Register: Endpoint Control Register (Instance 5 of 9) (ENDPTCTRL5)
/** \brief  (Instance 5 of 9)*/
//====================================================================

#define  USB2O_ENDPTCTRL5_RESERVED1_MASK 0xff000000
#define  USB2O_ENDPTCTRL5_RESERVED1_SHIFT 24
#define  USB2O_ENDPTCTRL5_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL5_RESERVED1_MASK) >> USB2O_ENDPTCTRL5_RESERVED1_SHIFT)
#define  USB2O_ENDPTCTRL5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL5_RESERVED1_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL5_RESERVED1_SHIFT))

#define  USB2O_ENDPTCTRL5_TXE_MASK 0x800000
#define  USB2O_ENDPTCTRL5_TXE_SHIFT 23
#define  USB2O_ENDPTCTRL5_TXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL5_TXE_MASK) >> USB2O_ENDPTCTRL5_TXE_SHIFT)
#define  USB2O_ENDPTCTRL5_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL5_TXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL5_TXE_SHIFT))

#define  USB2O_ENDPTCTRL5_TXR_MASK 0x400000
#define  USB2O_ENDPTCTRL5_TXR_SHIFT 22
#define  USB2O_ENDPTCTRL5_TXR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL5_TXR_MASK) >> USB2O_ENDPTCTRL5_TXR_SHIFT)
#define  USB2O_ENDPTCTRL5_TXR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL5_TXR_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL5_TXR_SHIFT))

#define  USB2O_ENDPTCTRL5_TXI_MASK 0x200000
#define  USB2O_ENDPTCTRL5_TXI_SHIFT 21
#define  USB2O_ENDPTCTRL5_TXI_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL5_TXI_MASK) >> USB2O_ENDPTCTRL5_TXI_SHIFT)
#define  USB2O_ENDPTCTRL5_TXI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL5_TXI_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL5_TXI_SHIFT))

#define  USB2O_ENDPTCTRL5_RESERVED2_MASK 0x100000
#define  USB2O_ENDPTCTRL5_RESERVED2_SHIFT 20
#define  USB2O_ENDPTCTRL5_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL5_RESERVED2_MASK) >> USB2O_ENDPTCTRL5_RESERVED2_SHIFT)
#define  USB2O_ENDPTCTRL5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL5_RESERVED2_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL5_RESERVED2_SHIFT))

#define  USB2O_ENDPTCTRL5_TXT_MASK 0xc0000
#define  USB2O_ENDPTCTRL5_TXT_SHIFT 18
#define  USB2O_ENDPTCTRL5_TXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL5_TXT_MASK) >> USB2O_ENDPTCTRL5_TXT_SHIFT)
#define  USB2O_ENDPTCTRL5_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL5_TXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL5_TXT_SHIFT))

#define  USB2O_ENDPTCTRL5_TXD_MASK 0x20000
#define  USB2O_ENDPTCTRL5_TXD_SHIFT 17
#define  USB2O_ENDPTCTRL5_TXD_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL5_TXD_MASK) >> USB2O_ENDPTCTRL5_TXD_SHIFT)
#define  USB2O_ENDPTCTRL5_TXD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL5_TXD_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL5_TXD_SHIFT))

#define  USB2O_ENDPTCTRL5_TXS_MASK 0x10000
#define  USB2O_ENDPTCTRL5_TXS_SHIFT 16
#define  USB2O_ENDPTCTRL5_TXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL5_TXS_MASK) >> USB2O_ENDPTCTRL5_TXS_SHIFT)
#define  USB2O_ENDPTCTRL5_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL5_TXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL5_TXS_SHIFT))

#define  USB2O_ENDPTCTRL5_RESERVED3_MASK 0xff00
#define  USB2O_ENDPTCTRL5_RESERVED3_SHIFT 8
#define  USB2O_ENDPTCTRL5_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL5_RESERVED3_MASK) >> USB2O_ENDPTCTRL5_RESERVED3_SHIFT)
#define  USB2O_ENDPTCTRL5_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL5_RESERVED3_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL5_RESERVED3_SHIFT))

#define  USB2O_ENDPTCTRL5_RXE_MASK 0x80
#define  USB2O_ENDPTCTRL5_RXE_SHIFT 7
#define  USB2O_ENDPTCTRL5_RXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL5_RXE_MASK) >> USB2O_ENDPTCTRL5_RXE_SHIFT)
#define  USB2O_ENDPTCTRL5_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL5_RXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL5_RXE_SHIFT))

#define  USB2O_ENDPTCTRL5_RXR_MASK 0x40
#define  USB2O_ENDPTCTRL5_RXR_SHIFT 6
#define  USB2O_ENDPTCTRL5_RXR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL5_RXR_MASK) >> USB2O_ENDPTCTRL5_RXR_SHIFT)
#define  USB2O_ENDPTCTRL5_RXR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL5_RXR_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL5_RXR_SHIFT))

#define  USB2O_ENDPTCTRL5_RXI_MASK 0x20
#define  USB2O_ENDPTCTRL5_RXI_SHIFT 5
#define  USB2O_ENDPTCTRL5_RXI_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL5_RXI_MASK) >> USB2O_ENDPTCTRL5_RXI_SHIFT)
#define  USB2O_ENDPTCTRL5_RXI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL5_RXI_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL5_RXI_SHIFT))

#define  USB2O_ENDPTCTRL5_RESERVED4_MASK 0x10
#define  USB2O_ENDPTCTRL5_RESERVED4_SHIFT 4
#define  USB2O_ENDPTCTRL5_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL5_RESERVED4_MASK) >> USB2O_ENDPTCTRL5_RESERVED4_SHIFT)
#define  USB2O_ENDPTCTRL5_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL5_RESERVED4_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL5_RESERVED4_SHIFT))

#define  USB2O_ENDPTCTRL5_RXT_MASK 0xc
#define  USB2O_ENDPTCTRL5_RXT_SHIFT 2
#define  USB2O_ENDPTCTRL5_RXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL5_RXT_MASK) >> USB2O_ENDPTCTRL5_RXT_SHIFT)
#define  USB2O_ENDPTCTRL5_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL5_RXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL5_RXT_SHIFT))

#define  USB2O_ENDPTCTRL5_RXD_MASK 0x2
#define  USB2O_ENDPTCTRL5_RXD_SHIFT 1
#define  USB2O_ENDPTCTRL5_RXD_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL5_RXD_MASK) >> USB2O_ENDPTCTRL5_RXD_SHIFT)
#define  USB2O_ENDPTCTRL5_RXD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL5_RXD_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL5_RXD_SHIFT))

#define  USB2O_ENDPTCTRL5_RXS_MASK 0x1
#define  USB2O_ENDPTCTRL5_RXS_SHIFT 0
#define  USB2O_ENDPTCTRL5_RXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL5_RXS_MASK) >> USB2O_ENDPTCTRL5_RXS_SHIFT)
#define  USB2O_ENDPTCTRL5_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL5_RXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL5_RXS_SHIFT))

//====================================================================
//Register: Endpoint Control Register (Instance 6 of 9) (ENDPTCTRL6)
/** \brief  (Instance 6 of 9)*/
//====================================================================

#define  USB2O_ENDPTCTRL6_RESERVED1_MASK 0xff000000
#define  USB2O_ENDPTCTRL6_RESERVED1_SHIFT 24
#define  USB2O_ENDPTCTRL6_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL6_RESERVED1_MASK) >> USB2O_ENDPTCTRL6_RESERVED1_SHIFT)
#define  USB2O_ENDPTCTRL6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL6_RESERVED1_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL6_RESERVED1_SHIFT))

#define  USB2O_ENDPTCTRL6_TXE_MASK 0x800000
#define  USB2O_ENDPTCTRL6_TXE_SHIFT 23
#define  USB2O_ENDPTCTRL6_TXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL6_TXE_MASK) >> USB2O_ENDPTCTRL6_TXE_SHIFT)
#define  USB2O_ENDPTCTRL6_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL6_TXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL6_TXE_SHIFT))

#define  USB2O_ENDPTCTRL6_TXR_MASK 0x400000
#define  USB2O_ENDPTCTRL6_TXR_SHIFT 22
#define  USB2O_ENDPTCTRL6_TXR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL6_TXR_MASK) >> USB2O_ENDPTCTRL6_TXR_SHIFT)
#define  USB2O_ENDPTCTRL6_TXR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL6_TXR_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL6_TXR_SHIFT))

#define  USB2O_ENDPTCTRL6_TXI_MASK 0x200000
#define  USB2O_ENDPTCTRL6_TXI_SHIFT 21
#define  USB2O_ENDPTCTRL6_TXI_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL6_TXI_MASK) >> USB2O_ENDPTCTRL6_TXI_SHIFT)
#define  USB2O_ENDPTCTRL6_TXI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL6_TXI_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL6_TXI_SHIFT))

#define  USB2O_ENDPTCTRL6_RESERVED2_MASK 0x100000
#define  USB2O_ENDPTCTRL6_RESERVED2_SHIFT 20
#define  USB2O_ENDPTCTRL6_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL6_RESERVED2_MASK) >> USB2O_ENDPTCTRL6_RESERVED2_SHIFT)
#define  USB2O_ENDPTCTRL6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL6_RESERVED2_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL6_RESERVED2_SHIFT))

#define  USB2O_ENDPTCTRL6_TXT_MASK 0xc0000
#define  USB2O_ENDPTCTRL6_TXT_SHIFT 18
#define  USB2O_ENDPTCTRL6_TXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL6_TXT_MASK) >> USB2O_ENDPTCTRL6_TXT_SHIFT)
#define  USB2O_ENDPTCTRL6_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL6_TXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL6_TXT_SHIFT))

#define  USB2O_ENDPTCTRL6_TXD_MASK 0x20000
#define  USB2O_ENDPTCTRL6_TXD_SHIFT 17
#define  USB2O_ENDPTCTRL6_TXD_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL6_TXD_MASK) >> USB2O_ENDPTCTRL6_TXD_SHIFT)
#define  USB2O_ENDPTCTRL6_TXD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL6_TXD_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL6_TXD_SHIFT))

#define  USB2O_ENDPTCTRL6_TXS_MASK 0x10000
#define  USB2O_ENDPTCTRL6_TXS_SHIFT 16
#define  USB2O_ENDPTCTRL6_TXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL6_TXS_MASK) >> USB2O_ENDPTCTRL6_TXS_SHIFT)
#define  USB2O_ENDPTCTRL6_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL6_TXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL6_TXS_SHIFT))

#define  USB2O_ENDPTCTRL6_RESERVED3_MASK 0xff00
#define  USB2O_ENDPTCTRL6_RESERVED3_SHIFT 8
#define  USB2O_ENDPTCTRL6_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL6_RESERVED3_MASK) >> USB2O_ENDPTCTRL6_RESERVED3_SHIFT)
#define  USB2O_ENDPTCTRL6_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL6_RESERVED3_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL6_RESERVED3_SHIFT))

#define  USB2O_ENDPTCTRL6_RXE_MASK 0x80
#define  USB2O_ENDPTCTRL6_RXE_SHIFT 7
#define  USB2O_ENDPTCTRL6_RXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL6_RXE_MASK) >> USB2O_ENDPTCTRL6_RXE_SHIFT)
#define  USB2O_ENDPTCTRL6_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL6_RXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL6_RXE_SHIFT))

#define  USB2O_ENDPTCTRL6_RXR_MASK 0x40
#define  USB2O_ENDPTCTRL6_RXR_SHIFT 6
#define  USB2O_ENDPTCTRL6_RXR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL6_RXR_MASK) >> USB2O_ENDPTCTRL6_RXR_SHIFT)
#define  USB2O_ENDPTCTRL6_RXR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL6_RXR_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL6_RXR_SHIFT))

#define  USB2O_ENDPTCTRL6_RXI_MASK 0x20
#define  USB2O_ENDPTCTRL6_RXI_SHIFT 5
#define  USB2O_ENDPTCTRL6_RXI_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL6_RXI_MASK) >> USB2O_ENDPTCTRL6_RXI_SHIFT)
#define  USB2O_ENDPTCTRL6_RXI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL6_RXI_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL6_RXI_SHIFT))

#define  USB2O_ENDPTCTRL6_RESERVED4_MASK 0x10
#define  USB2O_ENDPTCTRL6_RESERVED4_SHIFT 4
#define  USB2O_ENDPTCTRL6_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL6_RESERVED4_MASK) >> USB2O_ENDPTCTRL6_RESERVED4_SHIFT)
#define  USB2O_ENDPTCTRL6_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL6_RESERVED4_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL6_RESERVED4_SHIFT))

#define  USB2O_ENDPTCTRL6_RXT_MASK 0xc
#define  USB2O_ENDPTCTRL6_RXT_SHIFT 2
#define  USB2O_ENDPTCTRL6_RXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL6_RXT_MASK) >> USB2O_ENDPTCTRL6_RXT_SHIFT)
#define  USB2O_ENDPTCTRL6_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL6_RXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL6_RXT_SHIFT))

#define  USB2O_ENDPTCTRL6_RXD_MASK 0x2
#define  USB2O_ENDPTCTRL6_RXD_SHIFT 1
#define  USB2O_ENDPTCTRL6_RXD_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL6_RXD_MASK) >> USB2O_ENDPTCTRL6_RXD_SHIFT)
#define  USB2O_ENDPTCTRL6_RXD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL6_RXD_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL6_RXD_SHIFT))

#define  USB2O_ENDPTCTRL6_RXS_MASK 0x1
#define  USB2O_ENDPTCTRL6_RXS_SHIFT 0
#define  USB2O_ENDPTCTRL6_RXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL6_RXS_MASK) >> USB2O_ENDPTCTRL6_RXS_SHIFT)
#define  USB2O_ENDPTCTRL6_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL6_RXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL6_RXS_SHIFT))

//====================================================================
//Register: Endpoint Control Register (Instance 7 of 9) (ENDPTCTRL7)
/** \brief  (Instance 7 of 9)*/
//====================================================================

#define  USB2O_ENDPTCTRL7_RESERVED1_MASK 0xff000000
#define  USB2O_ENDPTCTRL7_RESERVED1_SHIFT 24
#define  USB2O_ENDPTCTRL7_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL7_RESERVED1_MASK) >> USB2O_ENDPTCTRL7_RESERVED1_SHIFT)
#define  USB2O_ENDPTCTRL7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL7_RESERVED1_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL7_RESERVED1_SHIFT))

#define  USB2O_ENDPTCTRL7_TXE_MASK 0x800000
#define  USB2O_ENDPTCTRL7_TXE_SHIFT 23
#define  USB2O_ENDPTCTRL7_TXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL7_TXE_MASK) >> USB2O_ENDPTCTRL7_TXE_SHIFT)
#define  USB2O_ENDPTCTRL7_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL7_TXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL7_TXE_SHIFT))

#define  USB2O_ENDPTCTRL7_TXR_MASK 0x400000
#define  USB2O_ENDPTCTRL7_TXR_SHIFT 22
#define  USB2O_ENDPTCTRL7_TXR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL7_TXR_MASK) >> USB2O_ENDPTCTRL7_TXR_SHIFT)
#define  USB2O_ENDPTCTRL7_TXR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL7_TXR_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL7_TXR_SHIFT))

#define  USB2O_ENDPTCTRL7_TXI_MASK 0x200000
#define  USB2O_ENDPTCTRL7_TXI_SHIFT 21
#define  USB2O_ENDPTCTRL7_TXI_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL7_TXI_MASK) >> USB2O_ENDPTCTRL7_TXI_SHIFT)
#define  USB2O_ENDPTCTRL7_TXI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL7_TXI_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL7_TXI_SHIFT))

#define  USB2O_ENDPTCTRL7_RESERVED2_MASK 0x100000
#define  USB2O_ENDPTCTRL7_RESERVED2_SHIFT 20
#define  USB2O_ENDPTCTRL7_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL7_RESERVED2_MASK) >> USB2O_ENDPTCTRL7_RESERVED2_SHIFT)
#define  USB2O_ENDPTCTRL7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL7_RESERVED2_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL7_RESERVED2_SHIFT))

#define  USB2O_ENDPTCTRL7_TXT_MASK 0xc0000
#define  USB2O_ENDPTCTRL7_TXT_SHIFT 18
#define  USB2O_ENDPTCTRL7_TXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL7_TXT_MASK) >> USB2O_ENDPTCTRL7_TXT_SHIFT)
#define  USB2O_ENDPTCTRL7_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL7_TXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL7_TXT_SHIFT))

#define  USB2O_ENDPTCTRL7_TXD_MASK 0x20000
#define  USB2O_ENDPTCTRL7_TXD_SHIFT 17
#define  USB2O_ENDPTCTRL7_TXD_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL7_TXD_MASK) >> USB2O_ENDPTCTRL7_TXD_SHIFT)
#define  USB2O_ENDPTCTRL7_TXD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL7_TXD_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL7_TXD_SHIFT))

#define  USB2O_ENDPTCTRL7_TXS_MASK 0x10000
#define  USB2O_ENDPTCTRL7_TXS_SHIFT 16
#define  USB2O_ENDPTCTRL7_TXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL7_TXS_MASK) >> USB2O_ENDPTCTRL7_TXS_SHIFT)
#define  USB2O_ENDPTCTRL7_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL7_TXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL7_TXS_SHIFT))

#define  USB2O_ENDPTCTRL7_RESERVED3_MASK 0xff00
#define  USB2O_ENDPTCTRL7_RESERVED3_SHIFT 8
#define  USB2O_ENDPTCTRL7_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL7_RESERVED3_MASK) >> USB2O_ENDPTCTRL7_RESERVED3_SHIFT)
#define  USB2O_ENDPTCTRL7_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL7_RESERVED3_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL7_RESERVED3_SHIFT))

#define  USB2O_ENDPTCTRL7_RXE_MASK 0x80
#define  USB2O_ENDPTCTRL7_RXE_SHIFT 7
#define  USB2O_ENDPTCTRL7_RXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL7_RXE_MASK) >> USB2O_ENDPTCTRL7_RXE_SHIFT)
#define  USB2O_ENDPTCTRL7_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL7_RXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL7_RXE_SHIFT))

#define  USB2O_ENDPTCTRL7_RXR_MASK 0x40
#define  USB2O_ENDPTCTRL7_RXR_SHIFT 6
#define  USB2O_ENDPTCTRL7_RXR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL7_RXR_MASK) >> USB2O_ENDPTCTRL7_RXR_SHIFT)
#define  USB2O_ENDPTCTRL7_RXR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL7_RXR_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL7_RXR_SHIFT))

#define  USB2O_ENDPTCTRL7_RXI_MASK 0x20
#define  USB2O_ENDPTCTRL7_RXI_SHIFT 5
#define  USB2O_ENDPTCTRL7_RXI_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL7_RXI_MASK) >> USB2O_ENDPTCTRL7_RXI_SHIFT)
#define  USB2O_ENDPTCTRL7_RXI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL7_RXI_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL7_RXI_SHIFT))

#define  USB2O_ENDPTCTRL7_RESERVED4_MASK 0x10
#define  USB2O_ENDPTCTRL7_RESERVED4_SHIFT 4
#define  USB2O_ENDPTCTRL7_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL7_RESERVED4_MASK) >> USB2O_ENDPTCTRL7_RESERVED4_SHIFT)
#define  USB2O_ENDPTCTRL7_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL7_RESERVED4_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL7_RESERVED4_SHIFT))

#define  USB2O_ENDPTCTRL7_RXT_MASK 0xc
#define  USB2O_ENDPTCTRL7_RXT_SHIFT 2
#define  USB2O_ENDPTCTRL7_RXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL7_RXT_MASK) >> USB2O_ENDPTCTRL7_RXT_SHIFT)
#define  USB2O_ENDPTCTRL7_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL7_RXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL7_RXT_SHIFT))

#define  USB2O_ENDPTCTRL7_RXD_MASK 0x2
#define  USB2O_ENDPTCTRL7_RXD_SHIFT 1
#define  USB2O_ENDPTCTRL7_RXD_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL7_RXD_MASK) >> USB2O_ENDPTCTRL7_RXD_SHIFT)
#define  USB2O_ENDPTCTRL7_RXD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL7_RXD_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL7_RXD_SHIFT))

#define  USB2O_ENDPTCTRL7_RXS_MASK 0x1
#define  USB2O_ENDPTCTRL7_RXS_SHIFT 0
#define  USB2O_ENDPTCTRL7_RXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL7_RXS_MASK) >> USB2O_ENDPTCTRL7_RXS_SHIFT)
#define  USB2O_ENDPTCTRL7_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL7_RXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL7_RXS_SHIFT))

//====================================================================
//Register: Endpoint Control Register (Instance 8 of 9) (ENDPTCTRL8)
/** \brief  (Instance 8 of 9)*/
//====================================================================

#define  USB2O_ENDPTCTRL8_RESERVED1_MASK 0xff000000
#define  USB2O_ENDPTCTRL8_RESERVED1_SHIFT 24
#define  USB2O_ENDPTCTRL8_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL8_RESERVED1_MASK) >> USB2O_ENDPTCTRL8_RESERVED1_SHIFT)
#define  USB2O_ENDPTCTRL8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL8_RESERVED1_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL8_RESERVED1_SHIFT))

#define  USB2O_ENDPTCTRL8_TXE_MASK 0x800000
#define  USB2O_ENDPTCTRL8_TXE_SHIFT 23
#define  USB2O_ENDPTCTRL8_TXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL8_TXE_MASK) >> USB2O_ENDPTCTRL8_TXE_SHIFT)
#define  USB2O_ENDPTCTRL8_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL8_TXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL8_TXE_SHIFT))

#define  USB2O_ENDPTCTRL8_TXR_MASK 0x400000
#define  USB2O_ENDPTCTRL8_TXR_SHIFT 22
#define  USB2O_ENDPTCTRL8_TXR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL8_TXR_MASK) >> USB2O_ENDPTCTRL8_TXR_SHIFT)
#define  USB2O_ENDPTCTRL8_TXR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL8_TXR_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL8_TXR_SHIFT))

#define  USB2O_ENDPTCTRL8_TXI_MASK 0x200000
#define  USB2O_ENDPTCTRL8_TXI_SHIFT 21
#define  USB2O_ENDPTCTRL8_TXI_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL8_TXI_MASK) >> USB2O_ENDPTCTRL8_TXI_SHIFT)
#define  USB2O_ENDPTCTRL8_TXI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL8_TXI_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL8_TXI_SHIFT))

#define  USB2O_ENDPTCTRL8_RESERVED2_MASK 0x100000
#define  USB2O_ENDPTCTRL8_RESERVED2_SHIFT 20
#define  USB2O_ENDPTCTRL8_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL8_RESERVED2_MASK) >> USB2O_ENDPTCTRL8_RESERVED2_SHIFT)
#define  USB2O_ENDPTCTRL8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL8_RESERVED2_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL8_RESERVED2_SHIFT))

#define  USB2O_ENDPTCTRL8_TXT_MASK 0xc0000
#define  USB2O_ENDPTCTRL8_TXT_SHIFT 18
#define  USB2O_ENDPTCTRL8_TXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL8_TXT_MASK) >> USB2O_ENDPTCTRL8_TXT_SHIFT)
#define  USB2O_ENDPTCTRL8_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL8_TXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL8_TXT_SHIFT))

#define  USB2O_ENDPTCTRL8_TXD_MASK 0x20000
#define  USB2O_ENDPTCTRL8_TXD_SHIFT 17
#define  USB2O_ENDPTCTRL8_TXD_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL8_TXD_MASK) >> USB2O_ENDPTCTRL8_TXD_SHIFT)
#define  USB2O_ENDPTCTRL8_TXD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL8_TXD_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL8_TXD_SHIFT))

#define  USB2O_ENDPTCTRL8_TXS_MASK 0x10000
#define  USB2O_ENDPTCTRL8_TXS_SHIFT 16
#define  USB2O_ENDPTCTRL8_TXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL8_TXS_MASK) >> USB2O_ENDPTCTRL8_TXS_SHIFT)
#define  USB2O_ENDPTCTRL8_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL8_TXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL8_TXS_SHIFT))

#define  USB2O_ENDPTCTRL8_RESERVED3_MASK 0xff00
#define  USB2O_ENDPTCTRL8_RESERVED3_SHIFT 8
#define  USB2O_ENDPTCTRL8_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL8_RESERVED3_MASK) >> USB2O_ENDPTCTRL8_RESERVED3_SHIFT)
#define  USB2O_ENDPTCTRL8_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL8_RESERVED3_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL8_RESERVED3_SHIFT))

#define  USB2O_ENDPTCTRL8_RXE_MASK 0x80
#define  USB2O_ENDPTCTRL8_RXE_SHIFT 7
#define  USB2O_ENDPTCTRL8_RXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL8_RXE_MASK) >> USB2O_ENDPTCTRL8_RXE_SHIFT)
#define  USB2O_ENDPTCTRL8_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL8_RXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL8_RXE_SHIFT))

#define  USB2O_ENDPTCTRL8_RXR_MASK 0x40
#define  USB2O_ENDPTCTRL8_RXR_SHIFT 6
#define  USB2O_ENDPTCTRL8_RXR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL8_RXR_MASK) >> USB2O_ENDPTCTRL8_RXR_SHIFT)
#define  USB2O_ENDPTCTRL8_RXR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL8_RXR_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL8_RXR_SHIFT))

#define  USB2O_ENDPTCTRL8_RXI_MASK 0x20
#define  USB2O_ENDPTCTRL8_RXI_SHIFT 5
#define  USB2O_ENDPTCTRL8_RXI_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL8_RXI_MASK) >> USB2O_ENDPTCTRL8_RXI_SHIFT)
#define  USB2O_ENDPTCTRL8_RXI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL8_RXI_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL8_RXI_SHIFT))

#define  USB2O_ENDPTCTRL8_RESERVED4_MASK 0x10
#define  USB2O_ENDPTCTRL8_RESERVED4_SHIFT 4
#define  USB2O_ENDPTCTRL8_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL8_RESERVED4_MASK) >> USB2O_ENDPTCTRL8_RESERVED4_SHIFT)
#define  USB2O_ENDPTCTRL8_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL8_RESERVED4_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL8_RESERVED4_SHIFT))

#define  USB2O_ENDPTCTRL8_RXT_MASK 0xc
#define  USB2O_ENDPTCTRL8_RXT_SHIFT 2
#define  USB2O_ENDPTCTRL8_RXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL8_RXT_MASK) >> USB2O_ENDPTCTRL8_RXT_SHIFT)
#define  USB2O_ENDPTCTRL8_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL8_RXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL8_RXT_SHIFT))

#define  USB2O_ENDPTCTRL8_RXD_MASK 0x2
#define  USB2O_ENDPTCTRL8_RXD_SHIFT 1
#define  USB2O_ENDPTCTRL8_RXD_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL8_RXD_MASK) >> USB2O_ENDPTCTRL8_RXD_SHIFT)
#define  USB2O_ENDPTCTRL8_RXD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL8_RXD_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL8_RXD_SHIFT))

#define  USB2O_ENDPTCTRL8_RXS_MASK 0x1
#define  USB2O_ENDPTCTRL8_RXS_SHIFT 0
#define  USB2O_ENDPTCTRL8_RXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL8_RXS_MASK) >> USB2O_ENDPTCTRL8_RXS_SHIFT)
#define  USB2O_ENDPTCTRL8_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL8_RXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL8_RXS_SHIFT))

//====================================================================
//Register: Endpoint Control Register (Instance 9 of 9) (ENDPTCTRL9)
/** \brief  (Instance 9 of 9)*/
//====================================================================

#define  USB2O_ENDPTCTRL9_RESERVED1_MASK 0xff000000
#define  USB2O_ENDPTCTRL9_RESERVED1_SHIFT 24
#define  USB2O_ENDPTCTRL9_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL9_RESERVED1_MASK) >> USB2O_ENDPTCTRL9_RESERVED1_SHIFT)
#define  USB2O_ENDPTCTRL9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL9_RESERVED1_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL9_RESERVED1_SHIFT))

#define  USB2O_ENDPTCTRL9_TXE_MASK 0x800000
#define  USB2O_ENDPTCTRL9_TXE_SHIFT 23
#define  USB2O_ENDPTCTRL9_TXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL9_TXE_MASK) >> USB2O_ENDPTCTRL9_TXE_SHIFT)
#define  USB2O_ENDPTCTRL9_TXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL9_TXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL9_TXE_SHIFT))

#define  USB2O_ENDPTCTRL9_TXR_MASK 0x400000
#define  USB2O_ENDPTCTRL9_TXR_SHIFT 22
#define  USB2O_ENDPTCTRL9_TXR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL9_TXR_MASK) >> USB2O_ENDPTCTRL9_TXR_SHIFT)
#define  USB2O_ENDPTCTRL9_TXR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL9_TXR_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL9_TXR_SHIFT))

#define  USB2O_ENDPTCTRL9_TXI_MASK 0x200000
#define  USB2O_ENDPTCTRL9_TXI_SHIFT 21
#define  USB2O_ENDPTCTRL9_TXI_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL9_TXI_MASK) >> USB2O_ENDPTCTRL9_TXI_SHIFT)
#define  USB2O_ENDPTCTRL9_TXI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL9_TXI_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL9_TXI_SHIFT))

#define  USB2O_ENDPTCTRL9_RESERVED2_MASK 0x100000
#define  USB2O_ENDPTCTRL9_RESERVED2_SHIFT 20
#define  USB2O_ENDPTCTRL9_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL9_RESERVED2_MASK) >> USB2O_ENDPTCTRL9_RESERVED2_SHIFT)
#define  USB2O_ENDPTCTRL9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL9_RESERVED2_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL9_RESERVED2_SHIFT))

#define  USB2O_ENDPTCTRL9_TXT_MASK 0xc0000
#define  USB2O_ENDPTCTRL9_TXT_SHIFT 18
#define  USB2O_ENDPTCTRL9_TXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL9_TXT_MASK) >> USB2O_ENDPTCTRL9_TXT_SHIFT)
#define  USB2O_ENDPTCTRL9_TXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL9_TXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL9_TXT_SHIFT))

#define  USB2O_ENDPTCTRL9_TXD_MASK 0x20000
#define  USB2O_ENDPTCTRL9_TXD_SHIFT 17
#define  USB2O_ENDPTCTRL9_TXD_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL9_TXD_MASK) >> USB2O_ENDPTCTRL9_TXD_SHIFT)
#define  USB2O_ENDPTCTRL9_TXD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL9_TXD_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL9_TXD_SHIFT))

#define  USB2O_ENDPTCTRL9_TXS_MASK 0x10000
#define  USB2O_ENDPTCTRL9_TXS_SHIFT 16
#define  USB2O_ENDPTCTRL9_TXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL9_TXS_MASK) >> USB2O_ENDPTCTRL9_TXS_SHIFT)
#define  USB2O_ENDPTCTRL9_TXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL9_TXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL9_TXS_SHIFT))

#define  USB2O_ENDPTCTRL9_RESERVED3_MASK 0xff00
#define  USB2O_ENDPTCTRL9_RESERVED3_SHIFT 8
#define  USB2O_ENDPTCTRL9_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL9_RESERVED3_MASK) >> USB2O_ENDPTCTRL9_RESERVED3_SHIFT)
#define  USB2O_ENDPTCTRL9_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL9_RESERVED3_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL9_RESERVED3_SHIFT))

#define  USB2O_ENDPTCTRL9_RXE_MASK 0x80
#define  USB2O_ENDPTCTRL9_RXE_SHIFT 7
#define  USB2O_ENDPTCTRL9_RXE_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL9_RXE_MASK) >> USB2O_ENDPTCTRL9_RXE_SHIFT)
#define  USB2O_ENDPTCTRL9_RXE_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL9_RXE_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL9_RXE_SHIFT))

#define  USB2O_ENDPTCTRL9_RXR_MASK 0x40
#define  USB2O_ENDPTCTRL9_RXR_SHIFT 6
#define  USB2O_ENDPTCTRL9_RXR_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL9_RXR_MASK) >> USB2O_ENDPTCTRL9_RXR_SHIFT)
#define  USB2O_ENDPTCTRL9_RXR_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL9_RXR_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL9_RXR_SHIFT))

#define  USB2O_ENDPTCTRL9_RXI_MASK 0x20
#define  USB2O_ENDPTCTRL9_RXI_SHIFT 5
#define  USB2O_ENDPTCTRL9_RXI_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL9_RXI_MASK) >> USB2O_ENDPTCTRL9_RXI_SHIFT)
#define  USB2O_ENDPTCTRL9_RXI_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL9_RXI_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL9_RXI_SHIFT))

#define  USB2O_ENDPTCTRL9_RESERVED4_MASK 0x10
#define  USB2O_ENDPTCTRL9_RESERVED4_SHIFT 4
#define  USB2O_ENDPTCTRL9_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL9_RESERVED4_MASK) >> USB2O_ENDPTCTRL9_RESERVED4_SHIFT)
#define  USB2O_ENDPTCTRL9_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL9_RESERVED4_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL9_RESERVED4_SHIFT))

#define  USB2O_ENDPTCTRL9_RXT_MASK 0xc
#define  USB2O_ENDPTCTRL9_RXT_SHIFT 2
#define  USB2O_ENDPTCTRL9_RXT_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL9_RXT_MASK) >> USB2O_ENDPTCTRL9_RXT_SHIFT)
#define  USB2O_ENDPTCTRL9_RXT_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL9_RXT_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL9_RXT_SHIFT))

#define  USB2O_ENDPTCTRL9_RXD_MASK 0x2
#define  USB2O_ENDPTCTRL9_RXD_SHIFT 1
#define  USB2O_ENDPTCTRL9_RXD_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL9_RXD_MASK) >> USB2O_ENDPTCTRL9_RXD_SHIFT)
#define  USB2O_ENDPTCTRL9_RXD_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL9_RXD_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL9_RXD_SHIFT))

#define  USB2O_ENDPTCTRL9_RXS_MASK 0x1
#define  USB2O_ENDPTCTRL9_RXS_SHIFT 0
#define  USB2O_ENDPTCTRL9_RXS_MASK_SHIFT(reg) (((reg) & USB2O_ENDPTCTRL9_RXS_MASK) >> USB2O_ENDPTCTRL9_RXS_SHIFT)
#define  USB2O_ENDPTCTRL9_RXS_REPLACE_VAL(reg,val) (((reg) & ~USB2O_ENDPTCTRL9_RXS_MASK) | (((uint32_t)val) << USB2O_ENDPTCTRL9_RXS_SHIFT))

//====================================================================
//
//Register File: USB transceiver (USB2PHY)
//
//====================================================================

//====================================================================
//
//Register File: USB UTM PLL (USB2PHY_USB2_UTM_PLL)
//
//====================================================================

//====================================================================
//Register: PHY ID Register (PHY_ID)
//====================================================================

#define  USB2PHY_USB2_UTM_PLL_PHY_ID_PHY_ID_MASK 0xffff0000
#define  USB2PHY_USB2_UTM_PLL_PHY_ID_PHY_ID_SHIFT 16
#define  USB2PHY_USB2_UTM_PLL_PHY_ID_PHY_ID_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PHY_ID_PHY_ID_MASK) >> USB2PHY_USB2_UTM_PLL_PHY_ID_PHY_ID_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PHY_ID_PHY_ID_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PHY_ID_PHY_ID_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PHY_ID_PHY_ID_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PHY_ID_ID_IN_MASK 0xffff
#define  USB2PHY_USB2_UTM_PLL_PHY_ID_ID_IN_SHIFT 0
#define  USB2PHY_USB2_UTM_PLL_PHY_ID_ID_IN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PHY_ID_ID_IN_MASK) >> USB2PHY_USB2_UTM_PLL_PHY_ID_ID_IN_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PHY_ID_ID_IN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PHY_ID_ID_IN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PHY_ID_ID_IN_SHIFT))

//====================================================================
//Register: PLL Control Register 0 (PLL0)
//====================================================================

#define  USB2PHY_USB2_UTM_PLL_PLL0_V2I_MASK 0xe0000000
#define  USB2PHY_USB2_UTM_PLL_PLL0_V2I_SHIFT 29
#define  USB2PHY_USB2_UTM_PLL_PLL0_V2I_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL0_V2I_MASK) >> USB2PHY_USB2_UTM_PLL_PLL0_V2I_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL0_V2I_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL0_V2I_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL0_V2I_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL0_PLLVDDL_MASK 0x18000000
#define  USB2PHY_USB2_UTM_PLL_PLL0_PLLVDDL_SHIFT 27
#define  USB2PHY_USB2_UTM_PLL_PLL0_PLLVDDL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL0_PLLVDDL_MASK) >> USB2PHY_USB2_UTM_PLL_PLL0_PLLVDDL_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL0_PLLVDDL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL0_PLLVDDL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL0_PLLVDDL_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL0_PLLCAL_MASK 0x6000000
#define  USB2PHY_USB2_UTM_PLL_PLL0_PLLCAL_SHIFT 25
#define  USB2PHY_USB2_UTM_PLL_PLL0_PLLCAL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL0_PLLCAL_MASK) >> USB2PHY_USB2_UTM_PLL_PLL0_PLLCAL_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL0_PLLCAL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL0_PLLCAL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL0_PLLCAL_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL0_CLK_BLK_EN_MASK 0x1000000
#define  USB2PHY_USB2_UTM_PLL_PLL0_CLK_BLK_EN_SHIFT 24
#define  USB2PHY_USB2_UTM_PLL_PLL0_CLK_BLK_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL0_CLK_BLK_EN_MASK) >> USB2PHY_USB2_UTM_PLL_PLL0_CLK_BLK_EN_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL0_CLK_BLK_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL0_CLK_BLK_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL0_CLK_BLK_EN_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL0_PLL_READY_MASK 0x800000
#define  USB2PHY_USB2_UTM_PLL_PLL0_PLL_READY_SHIFT 23
#define  USB2PHY_USB2_UTM_PLL_PLL0_PLL_READY_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL0_PLL_READY_MASK) >> USB2PHY_USB2_UTM_PLL_PLL0_PLL_READY_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL0_PLL_READY_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL0_PLL_READY_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL0_PLL_READY_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL0_KVCO_EXT_MASK 0x400000
#define  USB2PHY_USB2_UTM_PLL_PLL0_KVCO_EXT_SHIFT 22
#define  USB2PHY_USB2_UTM_PLL_PLL0_KVCO_EXT_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL0_KVCO_EXT_MASK) >> USB2PHY_USB2_UTM_PLL_PLL0_KVCO_EXT_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL0_KVCO_EXT_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL0_KVCO_EXT_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL0_KVCO_EXT_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL0_VCOCAL_START_MASK 0x200000
#define  USB2PHY_USB2_UTM_PLL_PLL0_VCOCAL_START_SHIFT 21
#define  USB2PHY_USB2_UTM_PLL_PLL0_VCOCAL_START_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL0_VCOCAL_START_MASK) >> USB2PHY_USB2_UTM_PLL_PLL0_VCOCAL_START_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL0_VCOCAL_START_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL0_VCOCAL_START_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL0_VCOCAL_START_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL0_REG_PLL_RESET_MASK 0x100000
#define  USB2PHY_USB2_UTM_PLL_PLL0_REG_PLL_RESET_SHIFT 20
#define  USB2PHY_USB2_UTM_PLL_PLL0_REG_PLL_RESET_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL0_REG_PLL_RESET_MASK) >> USB2PHY_USB2_UTM_PLL_PLL0_REG_PLL_RESET_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL0_REG_PLL_RESET_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL0_REG_PLL_RESET_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL0_REG_PLL_RESET_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL0_RESERVED1_MASK 0x80000
#define  USB2PHY_USB2_UTM_PLL_PLL0_RESERVED1_SHIFT 19
#define  USB2PHY_USB2_UTM_PLL_PLL0_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL0_RESERVED1_MASK) >> USB2PHY_USB2_UTM_PLL_PLL0_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL0_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL0_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL0_LOCKDET_ISEL_MASK 0x40000
#define  USB2PHY_USB2_UTM_PLL_PLL0_LOCKDET_ISEL_SHIFT 18
#define  USB2PHY_USB2_UTM_PLL_PLL0_LOCKDET_ISEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL0_LOCKDET_ISEL_MASK) >> USB2PHY_USB2_UTM_PLL_PLL0_LOCKDET_ISEL_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL0_LOCKDET_ISEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL0_LOCKDET_ISEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL0_LOCKDET_ISEL_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL0_KVCO_MASK 0x38000
#define  USB2PHY_USB2_UTM_PLL_PLL0_KVCO_SHIFT 15
#define  USB2PHY_USB2_UTM_PLL_PLL0_KVCO_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL0_KVCO_MASK) >> USB2PHY_USB2_UTM_PLL_PLL0_KVCO_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL0_KVCO_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL0_KVCO_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL0_KVCO_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL0_ICP_MASK 0x7000
#define  USB2PHY_USB2_UTM_PLL_PLL0_ICP_SHIFT 12
#define  USB2PHY_USB2_UTM_PLL_PLL0_ICP_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL0_ICP_MASK) >> USB2PHY_USB2_UTM_PLL_PLL0_ICP_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL0_ICP_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL0_ICP_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL0_ICP_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL0_FBDIV_MASK 0xff0
#define  USB2PHY_USB2_UTM_PLL_PLL0_FBDIV_SHIFT 4
#define  USB2PHY_USB2_UTM_PLL_PLL0_FBDIV_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL0_FBDIV_MASK) >> USB2PHY_USB2_UTM_PLL_PLL0_FBDIV_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL0_FBDIV_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL0_FBDIV_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL0_FBDIV_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL0_REFDIV_MASK 0xf
#define  USB2PHY_USB2_UTM_PLL_PLL0_REFDIV_SHIFT 0
#define  USB2PHY_USB2_UTM_PLL_PLL0_REFDIV_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL0_REFDIV_MASK) >> USB2PHY_USB2_UTM_PLL_PLL0_REFDIV_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL0_REFDIV_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL0_REFDIV_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL0_REFDIV_SHIFT))

//====================================================================
//Register: PLL Control Register 1 (PLL1)
//====================================================================

#define  USB2PHY_USB2_UTM_PLL_PLL1_RESERVED1_MASK 0xfffff800
#define  USB2PHY_USB2_UTM_PLL_PLL1_RESERVED1_SHIFT 11
#define  USB2PHY_USB2_UTM_PLL_PLL1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL1_RESERVED1_MASK) >> USB2PHY_USB2_UTM_PLL_PLL1_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL1_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL1_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL1_PLL_SUSPEND_EN_MASK 0x400
#define  USB2PHY_USB2_UTM_PLL_PLL1_PLL_SUSPEND_EN_SHIFT 10
#define  USB2PHY_USB2_UTM_PLL_PLL1_PLL_SUSPEND_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL1_PLL_SUSPEND_EN_MASK) >> USB2PHY_USB2_UTM_PLL_PLL1_PLL_SUSPEND_EN_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL1_PLL_SUSPEND_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL1_PLL_SUSPEND_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL1_PLL_SUSPEND_EN_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL1_PU_MASK 0x200
#define  USB2PHY_USB2_UTM_PLL_PLL1_PU_SHIFT 9
#define  USB2PHY_USB2_UTM_PLL_PLL1_PU_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL1_PU_MASK) >> USB2PHY_USB2_UTM_PLL_PLL1_PU_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL1_PU_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL1_PU_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL1_PU_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL1_R_ROTATE_SEL_MASK 0x100
#define  USB2PHY_USB2_UTM_PLL_PLL1_R_ROTATE_SEL_SHIFT 8
#define  USB2PHY_USB2_UTM_PLL_PLL1_R_ROTATE_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL1_R_ROTATE_SEL_MASK) >> USB2PHY_USB2_UTM_PLL_PLL1_R_ROTATE_SEL_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL1_R_ROTATE_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL1_R_ROTATE_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL1_R_ROTATE_SEL_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL1_STRESS_TEST_MODE_MASK 0x80
#define  USB2PHY_USB2_UTM_PLL_PLL1_STRESS_TEST_MODE_SHIFT 7
#define  USB2PHY_USB2_UTM_PLL_PLL1_STRESS_TEST_MODE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL1_STRESS_TEST_MODE_MASK) >> USB2PHY_USB2_UTM_PLL_PLL1_STRESS_TEST_MODE_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL1_STRESS_TEST_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL1_STRESS_TEST_MODE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL1_STRESS_TEST_MODE_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL1_PLL_VDDM_MASK 0x60
#define  USB2PHY_USB2_UTM_PLL_PLL1_PLL_VDDM_SHIFT 5
#define  USB2PHY_USB2_UTM_PLL_PLL1_PLL_VDDM_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL1_PLL_VDDM_MASK) >> USB2PHY_USB2_UTM_PLL_PLL1_PLL_VDDM_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL1_PLL_VDDM_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL1_PLL_VDDM_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL1_PLL_VDDM_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL1_TESTMON_PLL_MASK 0x1c
#define  USB2PHY_USB2_UTM_PLL_PLL1_TESTMON_PLL_SHIFT 2
#define  USB2PHY_USB2_UTM_PLL_PLL1_TESTMON_PLL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL1_TESTMON_PLL_MASK) >> USB2PHY_USB2_UTM_PLL_PLL1_TESTMON_PLL_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL1_TESTMON_PLL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL1_TESTMON_PLL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL1_TESTMON_PLL_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL1_SEL_LPFR_MASK 0x2
#define  USB2PHY_USB2_UTM_PLL_PLL1_SEL_LPFR_SHIFT 1
#define  USB2PHY_USB2_UTM_PLL_PLL1_SEL_LPFR_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL1_SEL_LPFR_MASK) >> USB2PHY_USB2_UTM_PLL_PLL1_SEL_LPFR_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL1_SEL_LPFR_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL1_SEL_LPFR_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL1_SEL_LPFR_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_PLL1_V2I_EXT_MASK 0x1
#define  USB2PHY_USB2_UTM_PLL_PLL1_V2I_EXT_SHIFT 0
#define  USB2PHY_USB2_UTM_PLL_PLL1_V2I_EXT_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_PLL1_V2I_EXT_MASK) >> USB2PHY_USB2_UTM_PLL_PLL1_V2I_EXT_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_PLL1_V2I_EXT_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_PLL1_V2I_EXT_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_PLL1_V2I_EXT_SHIFT))

//====================================================================
//Register: Reserve Register (RESERVE)
//====================================================================

#define  USB2PHY_USB2_UTM_PLL_RESERVE_RESERVE_MASK 0xffffffff
#define  USB2PHY_USB2_UTM_PLL_RESERVE_RESERVE_SHIFT 0
#define  USB2PHY_USB2_UTM_PLL_RESERVE_RESERVE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_RESERVE_RESERVE_MASK) >> USB2PHY_USB2_UTM_PLL_RESERVE_RESERVE_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_RESERVE_RESERVE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_RESERVE_RESERVE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_RESERVE_RESERVE_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (INT_EN)
//====================================================================

#define  USB2PHY_USB2_UTM_PLL_INT_EN_LINE_INT_REG_MASK 0xfffe0000
#define  USB2PHY_USB2_UTM_PLL_INT_EN_LINE_INT_REG_SHIFT 17
#define  USB2PHY_USB2_UTM_PLL_INT_EN_LINE_INT_REG_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_INT_EN_LINE_INT_REG_MASK) >> USB2PHY_USB2_UTM_PLL_INT_EN_LINE_INT_REG_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_INT_EN_LINE_INT_REG_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_INT_EN_LINE_INT_REG_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_INT_EN_LINE_INT_REG_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_INT_EN_RESERVED1_MASK 0x10000
#define  USB2PHY_USB2_UTM_PLL_INT_EN_RESERVED1_SHIFT 16
#define  USB2PHY_USB2_UTM_PLL_INT_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_INT_EN_RESERVED1_MASK) >> USB2PHY_USB2_UTM_PLL_INT_EN_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_INT_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_INT_EN_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_INT_EN_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_INT_EN_LINE_INT_EN_MASK 0xffff
#define  USB2PHY_USB2_UTM_PLL_INT_EN_LINE_INT_EN_SHIFT 0
#define  USB2PHY_USB2_UTM_PLL_INT_EN_LINE_INT_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_INT_EN_LINE_INT_EN_MASK) >> USB2PHY_USB2_UTM_PLL_INT_EN_LINE_INT_EN_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_INT_EN_LINE_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_INT_EN_LINE_INT_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_INT_EN_LINE_INT_EN_SHIFT))

//====================================================================
//Register: Interrupt Status Register (INT_STAT)
//====================================================================

#define  USB2PHY_USB2_UTM_PLL_INT_STAT_USB_INTERRUPT_MASK 0xfffe0000
#define  USB2PHY_USB2_UTM_PLL_INT_STAT_USB_INTERRUPT_SHIFT 17
#define  USB2PHY_USB2_UTM_PLL_INT_STAT_USB_INTERRUPT_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_INT_STAT_USB_INTERRUPT_MASK) >> USB2PHY_USB2_UTM_PLL_INT_STAT_USB_INTERRUPT_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_INT_STAT_USB_INTERRUPT_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_INT_STAT_USB_INTERRUPT_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_INT_STAT_USB_INTERRUPT_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_INT_STAT_RESERVED1_MASK 0x10000
#define  USB2PHY_USB2_UTM_PLL_INT_STAT_RESERVED1_SHIFT 16
#define  USB2PHY_USB2_UTM_PLL_INT_STAT_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_INT_STAT_RESERVED1_MASK) >> USB2PHY_USB2_UTM_PLL_INT_STAT_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_INT_STAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_INT_STAT_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_INT_STAT_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_INT_STAT_USB_RESUME_MASK 0xfffe
#define  USB2PHY_USB2_UTM_PLL_INT_STAT_USB_RESUME_SHIFT 1
#define  USB2PHY_USB2_UTM_PLL_INT_STAT_USB_RESUME_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_INT_STAT_USB_RESUME_MASK) >> USB2PHY_USB2_UTM_PLL_INT_STAT_USB_RESUME_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_INT_STAT_USB_RESUME_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_INT_STAT_USB_RESUME_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_INT_STAT_USB_RESUME_SHIFT))

#define  USB2PHY_USB2_UTM_PLL_INT_STAT_USB_INT_MASK 0x1
#define  USB2PHY_USB2_UTM_PLL_INT_STAT_USB_INT_SHIFT 0
#define  USB2PHY_USB2_UTM_PLL_INT_STAT_USB_INT_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM_PLL_INT_STAT_USB_INT_MASK) >> USB2PHY_USB2_UTM_PLL_INT_STAT_USB_INT_SHIFT)
#define  USB2PHY_USB2_UTM_PLL_INT_STAT_USB_INT_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM_PLL_INT_STAT_USB_INT_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM_PLL_INT_STAT_USB_INT_SHIFT))

//====================================================================
//
//Register File: USB UTM (Instance 1 of 3) (USB2PHY_USB2_UTM1)
//
//====================================================================

//====================================================================
//Register: USB Control Register (USB_CTL)
//====================================================================

#define  USB2PHY_USB2_UTM1_USB_CTL_RESERVED1_MASK 0xffffffff
#define  USB2PHY_USB2_UTM1_USB_CTL_RESERVED1_SHIFT 0
#define  USB2PHY_USB2_UTM1_USB_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_USB_CTL_RESERVED1_MASK) >> USB2PHY_USB2_UTM1_USB_CTL_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM1_USB_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_USB_CTL_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_USB_CTL_RESERVED1_SHIFT))

//====================================================================
//Register: TX Channel Control Register (TX)
//====================================================================

#define  USB2PHY_USB2_UTM1_TX_RESERVED1_MASK 0x80000000
#define  USB2PHY_USB2_UTM1_TX_RESERVED1_SHIFT 31
#define  USB2PHY_USB2_UTM1_TX_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TX_RESERVED1_MASK) >> USB2PHY_USB2_UTM1_TX_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM1_TX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TX_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TX_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM1_TX_REG_EXT_FS_RCAL_MASK 0x78000000
#define  USB2PHY_USB2_UTM1_TX_REG_EXT_FS_RCAL_SHIFT 27
#define  USB2PHY_USB2_UTM1_TX_REG_EXT_FS_RCAL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TX_REG_EXT_FS_RCAL_MASK) >> USB2PHY_USB2_UTM1_TX_REG_EXT_FS_RCAL_SHIFT)
#define  USB2PHY_USB2_UTM1_TX_REG_EXT_FS_RCAL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TX_REG_EXT_FS_RCAL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TX_REG_EXT_FS_RCAL_SHIFT))

#define  USB2PHY_USB2_UTM1_TX_REG_EXT_FS_RCAL_EN_MASK 0x4000000
#define  USB2PHY_USB2_UTM1_TX_REG_EXT_FS_RCAL_EN_SHIFT 26
#define  USB2PHY_USB2_UTM1_TX_REG_EXT_FS_RCAL_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TX_REG_EXT_FS_RCAL_EN_MASK) >> USB2PHY_USB2_UTM1_TX_REG_EXT_FS_RCAL_EN_SHIFT)
#define  USB2PHY_USB2_UTM1_TX_REG_EXT_FS_RCAL_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TX_REG_EXT_FS_RCAL_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TX_REG_EXT_FS_RCAL_EN_SHIFT))

#define  USB2PHY_USB2_UTM1_TX_HS_SLEW_RATE_MASK 0x3000000
#define  USB2PHY_USB2_UTM1_TX_HS_SLEW_RATE_SHIFT 24
#define  USB2PHY_USB2_UTM1_TX_HS_SLEW_RATE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TX_HS_SLEW_RATE_MASK) >> USB2PHY_USB2_UTM1_TX_HS_SLEW_RATE_SHIFT)
#define  USB2PHY_USB2_UTM1_TX_HS_SLEW_RATE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TX_HS_SLEW_RATE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TX_HS_SLEW_RATE_SHIFT))

#define  USB2PHY_USB2_UTM1_TX_TXVDDL_MASK 0xc00000
#define  USB2PHY_USB2_UTM1_TX_TXVDDL_SHIFT 22
#define  USB2PHY_USB2_UTM1_TX_TXVDDL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TX_TXVDDL_MASK) >> USB2PHY_USB2_UTM1_TX_TXVDDL_SHIFT)
#define  USB2PHY_USB2_UTM1_TX_TXVDDL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TX_TXVDDL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TX_TXVDDL_SHIFT))

#define  USB2PHY_USB2_UTM1_TX_TXDATA_BLOCK_EN_MASK 0x200000
#define  USB2PHY_USB2_UTM1_TX_TXDATA_BLOCK_EN_SHIFT 21
#define  USB2PHY_USB2_UTM1_TX_TXDATA_BLOCK_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TX_TXDATA_BLOCK_EN_MASK) >> USB2PHY_USB2_UTM1_TX_TXDATA_BLOCK_EN_SHIFT)
#define  USB2PHY_USB2_UTM1_TX_TXDATA_BLOCK_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TX_TXDATA_BLOCK_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TX_TXDATA_BLOCK_EN_SHIFT))

#define  USB2PHY_USB2_UTM1_TX_FSDRV_EN_MASK 0x1e0000
#define  USB2PHY_USB2_UTM1_TX_FSDRV_EN_SHIFT 17
#define  USB2PHY_USB2_UTM1_TX_FSDRV_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TX_FSDRV_EN_MASK) >> USB2PHY_USB2_UTM1_TX_FSDRV_EN_SHIFT)
#define  USB2PHY_USB2_UTM1_TX_FSDRV_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TX_FSDRV_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TX_FSDRV_EN_SHIFT))

#define  USB2PHY_USB2_UTM1_TX_IMPCAL_VTH_MASK 0x1c000
#define  USB2PHY_USB2_UTM1_TX_IMPCAL_VTH_SHIFT 14
#define  USB2PHY_USB2_UTM1_TX_IMPCAL_VTH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TX_IMPCAL_VTH_MASK) >> USB2PHY_USB2_UTM1_TX_IMPCAL_VTH_SHIFT)
#define  USB2PHY_USB2_UTM1_TX_IMPCAL_VTH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TX_IMPCAL_VTH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TX_IMPCAL_VTH_SHIFT))

#define  USB2PHY_USB2_UTM1_TX_REG_EXT_HS_RCAL_EN_MASK 0x2000
#define  USB2PHY_USB2_UTM1_TX_REG_EXT_HS_RCAL_EN_SHIFT 13
#define  USB2PHY_USB2_UTM1_TX_REG_EXT_HS_RCAL_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TX_REG_EXT_HS_RCAL_EN_MASK) >> USB2PHY_USB2_UTM1_TX_REG_EXT_HS_RCAL_EN_SHIFT)
#define  USB2PHY_USB2_UTM1_TX_REG_EXT_HS_RCAL_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TX_REG_EXT_HS_RCAL_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TX_REG_EXT_HS_RCAL_EN_SHIFT))

#define  USB2PHY_USB2_UTM1_TX_REG_RCAL_START_MASK 0x1000
#define  USB2PHY_USB2_UTM1_TX_REG_RCAL_START_SHIFT 12
#define  USB2PHY_USB2_UTM1_TX_REG_RCAL_START_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TX_REG_RCAL_START_MASK) >> USB2PHY_USB2_UTM1_TX_REG_RCAL_START_SHIFT)
#define  USB2PHY_USB2_UTM1_TX_REG_RCAL_START_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TX_REG_RCAL_START_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TX_REG_RCAL_START_SHIFT))

#define  USB2PHY_USB2_UTM1_TX_LOWVDD_EN_MASK 0x800
#define  USB2PHY_USB2_UTM1_TX_LOWVDD_EN_SHIFT 11
#define  USB2PHY_USB2_UTM1_TX_LOWVDD_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TX_LOWVDD_EN_MASK) >> USB2PHY_USB2_UTM1_TX_LOWVDD_EN_SHIFT)
#define  USB2PHY_USB2_UTM1_TX_LOWVDD_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TX_LOWVDD_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TX_LOWVDD_EN_SHIFT))

#define  USB2PHY_USB2_UTM1_TX_HSDRV_EN_MASK 0x780
#define  USB2PHY_USB2_UTM1_TX_HSDRV_EN_SHIFT 7
#define  USB2PHY_USB2_UTM1_TX_HSDRV_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TX_HSDRV_EN_MASK) >> USB2PHY_USB2_UTM1_TX_HSDRV_EN_SHIFT)
#define  USB2PHY_USB2_UTM1_TX_HSDRV_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TX_HSDRV_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TX_HSDRV_EN_SHIFT))

#define  USB2PHY_USB2_UTM1_TX_REG_EXT_HS_RCAL_MASK 0x78
#define  USB2PHY_USB2_UTM1_TX_REG_EXT_HS_RCAL_SHIFT 3
#define  USB2PHY_USB2_UTM1_TX_REG_EXT_HS_RCAL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TX_REG_EXT_HS_RCAL_MASK) >> USB2PHY_USB2_UTM1_TX_REG_EXT_HS_RCAL_SHIFT)
#define  USB2PHY_USB2_UTM1_TX_REG_EXT_HS_RCAL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TX_REG_EXT_HS_RCAL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TX_REG_EXT_HS_RCAL_SHIFT))

#define  USB2PHY_USB2_UTM1_TX_AMP_MASK 0x7
#define  USB2PHY_USB2_UTM1_TX_AMP_SHIFT 0
#define  USB2PHY_USB2_UTM1_TX_AMP_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TX_AMP_MASK) >> USB2PHY_USB2_UTM1_TX_AMP_SHIFT)
#define  USB2PHY_USB2_UTM1_TX_AMP_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TX_AMP_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TX_AMP_SHIFT))

//====================================================================
//Register: RX Channel Control Register 0 (RX0)
//====================================================================

#define  USB2PHY_USB2_UTM1_RX0_EARLY_VOS_ON_EN_MASK 0x80000000
#define  USB2PHY_USB2_UTM1_RX0_EARLY_VOS_ON_EN_SHIFT 31
#define  USB2PHY_USB2_UTM1_RX0_EARLY_VOS_ON_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX0_EARLY_VOS_ON_EN_MASK) >> USB2PHY_USB2_UTM1_RX0_EARLY_VOS_ON_EN_SHIFT)
#define  USB2PHY_USB2_UTM1_RX0_EARLY_VOS_ON_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX0_EARLY_VOS_ON_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX0_EARLY_VOS_ON_EN_SHIFT))

#define  USB2PHY_USB2_UTM1_RX0_RXDATA_BLOCK_EN_MASK 0x40000000
#define  USB2PHY_USB2_UTM1_RX0_RXDATA_BLOCK_EN_SHIFT 30
#define  USB2PHY_USB2_UTM1_RX0_RXDATA_BLOCK_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX0_RXDATA_BLOCK_EN_MASK) >> USB2PHY_USB2_UTM1_RX0_RXDATA_BLOCK_EN_SHIFT)
#define  USB2PHY_USB2_UTM1_RX0_RXDATA_BLOCK_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX0_RXDATA_BLOCK_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX0_RXDATA_BLOCK_EN_SHIFT))

#define  USB2PHY_USB2_UTM1_RX0_RXDATA_BLOCK_LENGTH_MASK 0x30000000
#define  USB2PHY_USB2_UTM1_RX0_RXDATA_BLOCK_LENGTH_SHIFT 28
#define  USB2PHY_USB2_UTM1_RX0_RXDATA_BLOCK_LENGTH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX0_RXDATA_BLOCK_LENGTH_MASK) >> USB2PHY_USB2_UTM1_RX0_RXDATA_BLOCK_LENGTH_SHIFT)
#define  USB2PHY_USB2_UTM1_RX0_RXDATA_BLOCK_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX0_RXDATA_BLOCK_LENGTH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX0_RXDATA_BLOCK_LENGTH_SHIFT))

#define  USB2PHY_USB2_UTM1_RX0_EDGE_DET_SEL_MASK 0xc000000
#define  USB2PHY_USB2_UTM1_RX0_EDGE_DET_SEL_SHIFT 26
#define  USB2PHY_USB2_UTM1_RX0_EDGE_DET_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX0_EDGE_DET_SEL_MASK) >> USB2PHY_USB2_UTM1_RX0_EDGE_DET_SEL_SHIFT)
#define  USB2PHY_USB2_UTM1_RX0_EDGE_DET_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX0_EDGE_DET_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX0_EDGE_DET_SEL_SHIFT))

#define  USB2PHY_USB2_UTM1_RX0_EDGE_DET_EN_MASK 0x2000000
#define  USB2PHY_USB2_UTM1_RX0_EDGE_DET_EN_SHIFT 25
#define  USB2PHY_USB2_UTM1_RX0_EDGE_DET_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX0_EDGE_DET_EN_MASK) >> USB2PHY_USB2_UTM1_RX0_EDGE_DET_EN_SHIFT)
#define  USB2PHY_USB2_UTM1_RX0_EDGE_DET_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX0_EDGE_DET_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX0_EDGE_DET_EN_SHIFT))

#define  USB2PHY_USB2_UTM1_RX0_S2TO3_DLY_SEL_MASK 0x1800000
#define  USB2PHY_USB2_UTM1_RX0_S2TO3_DLY_SEL_SHIFT 23
#define  USB2PHY_USB2_UTM1_RX0_S2TO3_DLY_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX0_S2TO3_DLY_SEL_MASK) >> USB2PHY_USB2_UTM1_RX0_S2TO3_DLY_SEL_SHIFT)
#define  USB2PHY_USB2_UTM1_RX0_S2TO3_DLY_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX0_S2TO3_DLY_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX0_S2TO3_DLY_SEL_SHIFT))

#define  USB2PHY_USB2_UTM1_RX0_CDR_COEF_SEL_MASK 0x400000
#define  USB2PHY_USB2_UTM1_RX0_CDR_COEF_SEL_SHIFT 22
#define  USB2PHY_USB2_UTM1_RX0_CDR_COEF_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX0_CDR_COEF_SEL_MASK) >> USB2PHY_USB2_UTM1_RX0_CDR_COEF_SEL_SHIFT)
#define  USB2PHY_USB2_UTM1_RX0_CDR_COEF_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX0_CDR_COEF_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX0_CDR_COEF_SEL_SHIFT))

#define  USB2PHY_USB2_UTM1_RX0_CDR_FASTLOCK_EN_MASK 0x200000
#define  USB2PHY_USB2_UTM1_RX0_CDR_FASTLOCK_EN_SHIFT 21
#define  USB2PHY_USB2_UTM1_RX0_CDR_FASTLOCK_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX0_CDR_FASTLOCK_EN_MASK) >> USB2PHY_USB2_UTM1_RX0_CDR_FASTLOCK_EN_SHIFT)
#define  USB2PHY_USB2_UTM1_RX0_CDR_FASTLOCK_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX0_CDR_FASTLOCK_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX0_CDR_FASTLOCK_EN_SHIFT))

#define  USB2PHY_USB2_UTM1_RX0_PHASE_FREEZE_DLY_MASK 0x100000
#define  USB2PHY_USB2_UTM1_RX0_PHASE_FREEZE_DLY_SHIFT 20
#define  USB2PHY_USB2_UTM1_RX0_PHASE_FREEZE_DLY_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX0_PHASE_FREEZE_DLY_MASK) >> USB2PHY_USB2_UTM1_RX0_PHASE_FREEZE_DLY_SHIFT)
#define  USB2PHY_USB2_UTM1_RX0_PHASE_FREEZE_DLY_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX0_PHASE_FREEZE_DLY_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX0_PHASE_FREEZE_DLY_SHIFT))

#define  USB2PHY_USB2_UTM1_RX0_REG_USQ_LENGTH_MASK 0x80000
#define  USB2PHY_USB2_UTM1_RX0_REG_USQ_LENGTH_SHIFT 19
#define  USB2PHY_USB2_UTM1_RX0_REG_USQ_LENGTH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX0_REG_USQ_LENGTH_MASK) >> USB2PHY_USB2_UTM1_RX0_REG_USQ_LENGTH_SHIFT)
#define  USB2PHY_USB2_UTM1_RX0_REG_USQ_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX0_REG_USQ_LENGTH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX0_REG_USQ_LENGTH_SHIFT))

#define  USB2PHY_USB2_UTM1_RX0_REG_ACQ_LENGTH_MASK 0x60000
#define  USB2PHY_USB2_UTM1_RX0_REG_ACQ_LENGTH_SHIFT 17
#define  USB2PHY_USB2_UTM1_RX0_REG_ACQ_LENGTH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX0_REG_ACQ_LENGTH_MASK) >> USB2PHY_USB2_UTM1_RX0_REG_ACQ_LENGTH_SHIFT)
#define  USB2PHY_USB2_UTM1_RX0_REG_ACQ_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX0_REG_ACQ_LENGTH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX0_REG_ACQ_LENGTH_SHIFT))

#define  USB2PHY_USB2_UTM1_RX0_REG_SQ_LENGTH_MASK 0x18000
#define  USB2PHY_USB2_UTM1_RX0_REG_SQ_LENGTH_SHIFT 15
#define  USB2PHY_USB2_UTM1_RX0_REG_SQ_LENGTH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX0_REG_SQ_LENGTH_MASK) >> USB2PHY_USB2_UTM1_RX0_REG_SQ_LENGTH_SHIFT)
#define  USB2PHY_USB2_UTM1_RX0_REG_SQ_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX0_REG_SQ_LENGTH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX0_REG_SQ_LENGTH_SHIFT))

#define  USB2PHY_USB2_UTM1_RX0_RESERVED1_MASK 0x6000
#define  USB2PHY_USB2_UTM1_RX0_RESERVED1_SHIFT 13
#define  USB2PHY_USB2_UTM1_RX0_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX0_RESERVED1_MASK) >> USB2PHY_USB2_UTM1_RX0_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM1_RX0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX0_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX0_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM1_RX0_CAP_SEL_MASK 0x1c00
#define  USB2PHY_USB2_UTM1_RX0_CAP_SEL_SHIFT 10
#define  USB2PHY_USB2_UTM1_RX0_CAP_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX0_CAP_SEL_MASK) >> USB2PHY_USB2_UTM1_RX0_CAP_SEL_SHIFT)
#define  USB2PHY_USB2_UTM1_RX0_CAP_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX0_CAP_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX0_CAP_SEL_SHIFT))

#define  USB2PHY_USB2_UTM1_RX0_DISCON_THRESH_MASK 0x300
#define  USB2PHY_USB2_UTM1_RX0_DISCON_THRESH_SHIFT 8
#define  USB2PHY_USB2_UTM1_RX0_DISCON_THRESH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX0_DISCON_THRESH_MASK) >> USB2PHY_USB2_UTM1_RX0_DISCON_THRESH_SHIFT)
#define  USB2PHY_USB2_UTM1_RX0_DISCON_THRESH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX0_DISCON_THRESH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX0_DISCON_THRESH_SHIFT))

#define  USB2PHY_USB2_UTM1_RX0_SQ_THRESH_MASK 0xf0
#define  USB2PHY_USB2_UTM1_RX0_SQ_THRESH_SHIFT 4
#define  USB2PHY_USB2_UTM1_RX0_SQ_THRESH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX0_SQ_THRESH_MASK) >> USB2PHY_USB2_UTM1_RX0_SQ_THRESH_SHIFT)
#define  USB2PHY_USB2_UTM1_RX0_SQ_THRESH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX0_SQ_THRESH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX0_SQ_THRESH_SHIFT))

#define  USB2PHY_USB2_UTM1_RX0_LPF_COEF_MASK 0xc
#define  USB2PHY_USB2_UTM1_RX0_LPF_COEF_SHIFT 2
#define  USB2PHY_USB2_UTM1_RX0_LPF_COEF_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX0_LPF_COEF_MASK) >> USB2PHY_USB2_UTM1_RX0_LPF_COEF_SHIFT)
#define  USB2PHY_USB2_UTM1_RX0_LPF_COEF_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX0_LPF_COEF_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX0_LPF_COEF_SHIFT))

#define  USB2PHY_USB2_UTM1_RX0_INTPI_MASK 0x3
#define  USB2PHY_USB2_UTM1_RX0_INTPI_SHIFT 0
#define  USB2PHY_USB2_UTM1_RX0_INTPI_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX0_INTPI_MASK) >> USB2PHY_USB2_UTM1_RX0_INTPI_SHIFT)
#define  USB2PHY_USB2_UTM1_RX0_INTPI_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX0_INTPI_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX0_INTPI_SHIFT))

//====================================================================
//Register: Receive Channel Control Register 1 (RX1)
//====================================================================

#define  USB2PHY_USB2_UTM1_RX1_RESERVED1_MASK 0xffff0000
#define  USB2PHY_USB2_UTM1_RX1_RESERVED1_SHIFT 16
#define  USB2PHY_USB2_UTM1_RX1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX1_RESERVED1_MASK) >> USB2PHY_USB2_UTM1_RX1_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM1_RX1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX1_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX1_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM1_RX1_PU_PHY_MASK 0x8000
#define  USB2PHY_USB2_UTM1_RX1_PU_PHY_SHIFT 15
#define  USB2PHY_USB2_UTM1_RX1_PU_PHY_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX1_PU_PHY_MASK) >> USB2PHY_USB2_UTM1_RX1_PU_PHY_SHIFT)
#define  USB2PHY_USB2_UTM1_RX1_PU_PHY_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX1_PU_PHY_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX1_PU_PHY_SHIFT))

#define  USB2PHY_USB2_UTM1_RX1_STRESS_TEST_MODE_MASK 0x4000
#define  USB2PHY_USB2_UTM1_RX1_STRESS_TEST_MODE_SHIFT 14
#define  USB2PHY_USB2_UTM1_RX1_STRESS_TEST_MODE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX1_STRESS_TEST_MODE_MASK) >> USB2PHY_USB2_UTM1_RX1_STRESS_TEST_MODE_SHIFT)
#define  USB2PHY_USB2_UTM1_RX1_STRESS_TEST_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX1_STRESS_TEST_MODE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX1_STRESS_TEST_MODE_SHIFT))

#define  USB2PHY_USB2_UTM1_RX1_RESERVED2_MASK 0x2000
#define  USB2PHY_USB2_UTM1_RX1_RESERVED2_SHIFT 13
#define  USB2PHY_USB2_UTM1_RX1_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX1_RESERVED2_MASK) >> USB2PHY_USB2_UTM1_RX1_RESERVED2_SHIFT)
#define  USB2PHY_USB2_UTM1_RX1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX1_RESERVED2_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX1_RESERVED2_SHIFT))

#define  USB2PHY_USB2_UTM1_RX1_TESTMON_MASK 0x1e00
#define  USB2PHY_USB2_UTM1_RX1_TESTMON_SHIFT 9
#define  USB2PHY_USB2_UTM1_RX1_TESTMON_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX1_TESTMON_MASK) >> USB2PHY_USB2_UTM1_RX1_TESTMON_SHIFT)
#define  USB2PHY_USB2_UTM1_RX1_TESTMON_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX1_TESTMON_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX1_TESTMON_SHIFT))

#define  USB2PHY_USB2_UTM1_RX1_USQ_FILTER_MASK 0x100
#define  USB2PHY_USB2_UTM1_RX1_USQ_FILTER_SHIFT 8
#define  USB2PHY_USB2_UTM1_RX1_USQ_FILTER_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX1_USQ_FILTER_MASK) >> USB2PHY_USB2_UTM1_RX1_USQ_FILTER_SHIFT)
#define  USB2PHY_USB2_UTM1_RX1_USQ_FILTER_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX1_USQ_FILTER_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX1_USQ_FILTER_SHIFT))

#define  USB2PHY_USB2_UTM1_RX1_SQ_CM_SEL_MASK 0x80
#define  USB2PHY_USB2_UTM1_RX1_SQ_CM_SEL_SHIFT 7
#define  USB2PHY_USB2_UTM1_RX1_SQ_CM_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX1_SQ_CM_SEL_MASK) >> USB2PHY_USB2_UTM1_RX1_SQ_CM_SEL_SHIFT)
#define  USB2PHY_USB2_UTM1_RX1_SQ_CM_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX1_SQ_CM_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX1_SQ_CM_SEL_SHIFT))

#define  USB2PHY_USB2_UTM1_RX1_SAMPLER_CTRL_MASK 0x40
#define  USB2PHY_USB2_UTM1_RX1_SAMPLER_CTRL_SHIFT 6
#define  USB2PHY_USB2_UTM1_RX1_SAMPLER_CTRL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX1_SAMPLER_CTRL_MASK) >> USB2PHY_USB2_UTM1_RX1_SAMPLER_CTRL_SHIFT)
#define  USB2PHY_USB2_UTM1_RX1_SAMPLER_CTRL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX1_SAMPLER_CTRL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX1_SAMPLER_CTRL_SHIFT))

#define  USB2PHY_USB2_UTM1_RX1_SQ_BUFFER_EN_MASK 0x20
#define  USB2PHY_USB2_UTM1_RX1_SQ_BUFFER_EN_SHIFT 5
#define  USB2PHY_USB2_UTM1_RX1_SQ_BUFFER_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX1_SQ_BUFFER_EN_MASK) >> USB2PHY_USB2_UTM1_RX1_SQ_BUFFER_EN_SHIFT)
#define  USB2PHY_USB2_UTM1_RX1_SQ_BUFFER_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX1_SQ_BUFFER_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX1_SQ_BUFFER_EN_SHIFT))

#define  USB2PHY_USB2_UTM1_RX1_SQ_ALWAYS_ON_MASK 0x10
#define  USB2PHY_USB2_UTM1_RX1_SQ_ALWAYS_ON_SHIFT 4
#define  USB2PHY_USB2_UTM1_RX1_SQ_ALWAYS_ON_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX1_SQ_ALWAYS_ON_MASK) >> USB2PHY_USB2_UTM1_RX1_SQ_ALWAYS_ON_SHIFT)
#define  USB2PHY_USB2_UTM1_RX1_SQ_ALWAYS_ON_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX1_SQ_ALWAYS_ON_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX1_SQ_ALWAYS_ON_SHIFT))

#define  USB2PHY_USB2_UTM1_RX1_RXVDDL_MASK 0xc
#define  USB2PHY_USB2_UTM1_RX1_RXVDDL_SHIFT 2
#define  USB2PHY_USB2_UTM1_RX1_RXVDDL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX1_RXVDDL_MASK) >> USB2PHY_USB2_UTM1_RX1_RXVDDL_SHIFT)
#define  USB2PHY_USB2_UTM1_RX1_RXVDDL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX1_RXVDDL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX1_RXVDDL_SHIFT))

#define  USB2PHY_USB2_UTM1_RX1_RESERVED3_MASK 0x3
#define  USB2PHY_USB2_UTM1_RX1_RESERVED3_SHIFT 0
#define  USB2PHY_USB2_UTM1_RX1_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RX1_RESERVED3_MASK) >> USB2PHY_USB2_UTM1_RX1_RESERVED3_SHIFT)
#define  USB2PHY_USB2_UTM1_RX1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RX1_RESERVED3_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RX1_RESERVED3_SHIFT))

//====================================================================
//Register: PHY IVREF Control Register (IVREF)
//====================================================================

#define  USB2PHY_USB2_UTM1_IVREF_PHY_IVREF_CTL_MASK 0xffffffff
#define  USB2PHY_USB2_UTM1_IVREF_PHY_IVREF_CTL_SHIFT 0
#define  USB2PHY_USB2_UTM1_IVREF_PHY_IVREF_CTL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_IVREF_PHY_IVREF_CTL_MASK) >> USB2PHY_USB2_UTM1_IVREF_PHY_IVREF_CTL_SHIFT)
#define  USB2PHY_USB2_UTM1_IVREF_PHY_IVREF_CTL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_IVREF_PHY_IVREF_CTL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_IVREF_PHY_IVREF_CTL_SHIFT))

//====================================================================
//Register: Test Group0 Register (TEST0)
//====================================================================

#define  USB2PHY_USB2_UTM1_TEST0_REG_FIFO_OV_MASK 0x80000000
#define  USB2PHY_USB2_UTM1_TEST0_REG_FIFO_OV_SHIFT 31
#define  USB2PHY_USB2_UTM1_TEST0_REG_FIFO_OV_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_REG_FIFO_OV_MASK) >> USB2PHY_USB2_UTM1_TEST0_REG_FIFO_OV_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_REG_FIFO_OV_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_REG_FIFO_OV_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_REG_FIFO_OV_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_REG_FIFO_UF_MASK 0x40000000
#define  USB2PHY_USB2_UTM1_TEST0_REG_FIFO_UF_SHIFT 30
#define  USB2PHY_USB2_UTM1_TEST0_REG_FIFO_UF_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_REG_FIFO_UF_MASK) >> USB2PHY_USB2_UTM1_TEST0_REG_FIFO_UF_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_REG_FIFO_UF_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_REG_FIFO_UF_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_REG_FIFO_UF_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_RESERVED1_MASK 0x20000000
#define  USB2PHY_USB2_UTM1_TEST0_RESERVED1_SHIFT 29
#define  USB2PHY_USB2_UTM1_TEST0_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_RESERVED1_MASK) >> USB2PHY_USB2_UTM1_TEST0_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_REG_ARC_DPDM_MODE_MASK 0x10000000
#define  USB2PHY_USB2_UTM1_TEST0_REG_ARC_DPDM_MODE_SHIFT 28
#define  USB2PHY_USB2_UTM1_TEST0_REG_ARC_DPDM_MODE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_REG_ARC_DPDM_MODE_MASK) >> USB2PHY_USB2_UTM1_TEST0_REG_ARC_DPDM_MODE_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_REG_ARC_DPDM_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_REG_ARC_DPDM_MODE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_REG_ARC_DPDM_MODE_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_REG_DP_PULLDOWN_MASK 0x8000000
#define  USB2PHY_USB2_UTM1_TEST0_REG_DP_PULLDOWN_SHIFT 27
#define  USB2PHY_USB2_UTM1_TEST0_REG_DP_PULLDOWN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_REG_DP_PULLDOWN_MASK) >> USB2PHY_USB2_UTM1_TEST0_REG_DP_PULLDOWN_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_REG_DP_PULLDOWN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_REG_DP_PULLDOWN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_REG_DP_PULLDOWN_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_REG_DM_PULLDOWN_MASK 0x4000000
#define  USB2PHY_USB2_UTM1_TEST0_REG_DM_PULLDOWN_SHIFT 26
#define  USB2PHY_USB2_UTM1_TEST0_REG_DM_PULLDOWN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_REG_DM_PULLDOWN_MASK) >> USB2PHY_USB2_UTM1_TEST0_REG_DM_PULLDOWN_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_REG_DM_PULLDOWN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_REG_DM_PULLDOWN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_REG_DM_PULLDOWN_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_RESERVED2_MASK 0x2000000
#define  USB2PHY_USB2_UTM1_TEST0_RESERVED2_SHIFT 25
#define  USB2PHY_USB2_UTM1_TEST0_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_RESERVED2_MASK) >> USB2PHY_USB2_UTM1_TEST0_RESERVED2_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_RESERVED2_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_RESERVED2_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_REG_FIFO_FILL_NUM_MASK 0x1e00000
#define  USB2PHY_USB2_UTM1_TEST0_REG_FIFO_FILL_NUM_SHIFT 21
#define  USB2PHY_USB2_UTM1_TEST0_REG_FIFO_FILL_NUM_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_REG_FIFO_FILL_NUM_MASK) >> USB2PHY_USB2_UTM1_TEST0_REG_FIFO_FILL_NUM_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_REG_FIFO_FILL_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_REG_FIFO_FILL_NUM_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_REG_FIFO_FILL_NUM_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_REG_SQ_SYNC_SEL_MASK 0x100000
#define  USB2PHY_USB2_UTM1_TEST0_REG_SQ_SYNC_SEL_SHIFT 20
#define  USB2PHY_USB2_UTM1_TEST0_REG_SQ_SYNC_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_REG_SQ_SYNC_SEL_MASK) >> USB2PHY_USB2_UTM1_TEST0_REG_SQ_SYNC_SEL_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_REG_SQ_SYNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_REG_SQ_SYNC_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_REG_SQ_SYNC_SEL_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_REG_ALIGN_FS_OUTEN_MASK 0x80000
#define  USB2PHY_USB2_UTM1_TEST0_REG_ALIGN_FS_OUTEN_SHIFT 19
#define  USB2PHY_USB2_UTM1_TEST0_REG_ALIGN_FS_OUTEN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_REG_ALIGN_FS_OUTEN_MASK) >> USB2PHY_USB2_UTM1_TEST0_REG_ALIGN_FS_OUTEN_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_REG_ALIGN_FS_OUTEN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_REG_ALIGN_FS_OUTEN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_REG_ALIGN_FS_OUTEN_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_RESERVED3_MASK 0x40000
#define  USB2PHY_USB2_UTM1_TEST0_RESERVED3_SHIFT 18
#define  USB2PHY_USB2_UTM1_TEST0_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_RESERVED3_MASK) >> USB2PHY_USB2_UTM1_TEST0_RESERVED3_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_RESERVED3_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_RESERVED3_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_REG_LONG_EOP_MASK 0x20000
#define  USB2PHY_USB2_UTM1_TEST0_REG_LONG_EOP_SHIFT 17
#define  USB2PHY_USB2_UTM1_TEST0_REG_LONG_EOP_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_REG_LONG_EOP_MASK) >> USB2PHY_USB2_UTM1_TEST0_REG_LONG_EOP_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_REG_LONG_EOP_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_REG_LONG_EOP_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_REG_LONG_EOP_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_REG_PLL_LOCK_BYPASS_MASK 0x10000
#define  USB2PHY_USB2_UTM1_TEST0_REG_PLL_LOCK_BYPASS_SHIFT 16
#define  USB2PHY_USB2_UTM1_TEST0_REG_PLL_LOCK_BYPASS_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_REG_PLL_LOCK_BYPASS_MASK) >> USB2PHY_USB2_UTM1_TEST0_REG_PLL_LOCK_BYPASS_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_REG_PLL_LOCK_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_REG_PLL_LOCK_BYPASS_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_REG_PLL_LOCK_BYPASS_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_REG_FIFO_SQ_RST_MASK 0x8000
#define  USB2PHY_USB2_UTM1_TEST0_REG_FIFO_SQ_RST_SHIFT 15
#define  USB2PHY_USB2_UTM1_TEST0_REG_FIFO_SQ_RST_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_REG_FIFO_SQ_RST_MASK) >> USB2PHY_USB2_UTM1_TEST0_REG_FIFO_SQ_RST_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_REG_FIFO_SQ_RST_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_REG_FIFO_SQ_RST_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_REG_FIFO_SQ_RST_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_REG_CLK_SUSPEND_EN_MASK 0x4000
#define  USB2PHY_USB2_UTM1_TEST0_REG_CLK_SUSPEND_EN_SHIFT 14
#define  USB2PHY_USB2_UTM1_TEST0_REG_CLK_SUSPEND_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_REG_CLK_SUSPEND_EN_MASK) >> USB2PHY_USB2_UTM1_TEST0_REG_CLK_SUSPEND_EN_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_REG_CLK_SUSPEND_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_REG_CLK_SUSPEND_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_REG_CLK_SUSPEND_EN_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_REG_EARLY_TX_ENABLE_MASK 0x2000
#define  USB2PHY_USB2_UTM1_TEST0_REG_EARLY_TX_ENABLE_SHIFT 13
#define  USB2PHY_USB2_UTM1_TEST0_REG_EARLY_TX_ENABLE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_REG_EARLY_TX_ENABLE_MASK) >> USB2PHY_USB2_UTM1_TEST0_REG_EARLY_TX_ENABLE_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_REG_EARLY_TX_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_REG_EARLY_TX_ENABLE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_REG_EARLY_TX_ENABLE_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_REG_OVUF_RST_EN_MASK 0x1000
#define  USB2PHY_USB2_UTM1_TEST0_REG_OVUF_RST_EN_SHIFT 12
#define  USB2PHY_USB2_UTM1_TEST0_REG_OVUF_RST_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_REG_OVUF_RST_EN_MASK) >> USB2PHY_USB2_UTM1_TEST0_REG_OVUF_RST_EN_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_REG_OVUF_RST_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_REG_OVUF_RST_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_REG_OVUF_RST_EN_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_REG_EOP_RST_EN_MASK 0x800
#define  USB2PHY_USB2_UTM1_TEST0_REG_EOP_RST_EN_SHIFT 11
#define  USB2PHY_USB2_UTM1_TEST0_REG_EOP_RST_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_REG_EOP_RST_EN_MASK) >> USB2PHY_USB2_UTM1_TEST0_REG_EOP_RST_EN_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_REG_EOP_RST_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_REG_EOP_RST_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_REG_EOP_RST_EN_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_REG_SYNC_NUM_MASK 0x600
#define  USB2PHY_USB2_UTM1_TEST0_REG_SYNC_NUM_SHIFT 9
#define  USB2PHY_USB2_UTM1_TEST0_REG_SYNC_NUM_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_REG_SYNC_NUM_MASK) >> USB2PHY_USB2_UTM1_TEST0_REG_SYNC_NUM_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_REG_SYNC_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_REG_SYNC_NUM_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_REG_SYNC_NUM_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_REG_NOVBUS_DPDM00_MASK 0x100
#define  USB2PHY_USB2_UTM1_TEST0_REG_NOVBUS_DPDM00_SHIFT 8
#define  USB2PHY_USB2_UTM1_TEST0_REG_NOVBUS_DPDM00_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_REG_NOVBUS_DPDM00_MASK) >> USB2PHY_USB2_UTM1_TEST0_REG_NOVBUS_DPDM00_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_REG_NOVBUS_DPDM00_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_REG_NOVBUS_DPDM00_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_REG_NOVBUS_DPDM00_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST0_RESERVED4_MASK 0xff
#define  USB2PHY_USB2_UTM1_TEST0_RESERVED4_SHIFT 0
#define  USB2PHY_USB2_UTM1_TEST0_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST0_RESERVED4_MASK) >> USB2PHY_USB2_UTM1_TEST0_RESERVED4_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST0_RESERVED4_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST0_RESERVED4_SHIFT))

//====================================================================
//Register: Test Group1 Register (TEST1)
//====================================================================

#define  USB2PHY_USB2_UTM1_TEST1_REG_HS_HDL_SYNC_MASK 0x80000000
#define  USB2PHY_USB2_UTM1_TEST1_REG_HS_HDL_SYNC_SHIFT 31
#define  USB2PHY_USB2_UTM1_TEST1_REG_HS_HDL_SYNC_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST1_REG_HS_HDL_SYNC_MASK) >> USB2PHY_USB2_UTM1_TEST1_REG_HS_HDL_SYNC_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST1_REG_HS_HDL_SYNC_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST1_REG_HS_HDL_SYNC_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST1_REG_HS_HDL_SYNC_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST1_REG_FS_HDL_OPMD_MASK 0x40000000
#define  USB2PHY_USB2_UTM1_TEST1_REG_FS_HDL_OPMD_SHIFT 30
#define  USB2PHY_USB2_UTM1_TEST1_REG_FS_HDL_OPMD_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST1_REG_FS_HDL_OPMD_MASK) >> USB2PHY_USB2_UTM1_TEST1_REG_FS_HDL_OPMD_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST1_REG_FS_HDL_OPMD_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST1_REG_FS_HDL_OPMD_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST1_REG_FS_HDL_OPMD_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST1_RESERVED1_MASK 0x3fc00000
#define  USB2PHY_USB2_UTM1_TEST1_RESERVED1_SHIFT 22
#define  USB2PHY_USB2_UTM1_TEST1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST1_RESERVED1_MASK) >> USB2PHY_USB2_UTM1_TEST1_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST1_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST1_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST1_RESERVED2_MASK 0x200000
#define  USB2PHY_USB2_UTM1_TEST1_RESERVED2_SHIFT 21
#define  USB2PHY_USB2_UTM1_TEST1_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST1_RESERVED2_MASK) >> USB2PHY_USB2_UTM1_TEST1_RESERVED2_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST1_RESERVED2_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST1_RESERVED2_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_DIG_LPBK_MASK 0x100000
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_DIG_LPBK_SHIFT 20
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_DIG_LPBK_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST1_REG_TEST_DIG_LPBK_MASK) >> USB2PHY_USB2_UTM1_TEST1_REG_TEST_DIG_LPBK_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_DIG_LPBK_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST1_REG_TEST_DIG_LPBK_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST1_REG_TEST_DIG_LPBK_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_SKIP_MASK 0xe0000
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_SKIP_SHIFT 17
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_SKIP_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST1_REG_TEST_SKIP_MASK) >> USB2PHY_USB2_UTM1_TEST1_REG_TEST_SKIP_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_SKIP_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST1_REG_TEST_SKIP_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST1_REG_TEST_SKIP_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_FLAG_MASK 0x10000
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_FLAG_SHIFT 16
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_FLAG_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST1_REG_TEST_FLAG_MASK) >> USB2PHY_USB2_UTM1_TEST1_REG_TEST_FLAG_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_FLAG_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST1_REG_TEST_FLAG_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST1_REG_TEST_FLAG_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_DONE_MASK 0x8000
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_DONE_SHIFT 15
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_DONE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST1_REG_TEST_DONE_MASK) >> USB2PHY_USB2_UTM1_TEST1_REG_TEST_DONE_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_DONE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST1_REG_TEST_DONE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST1_REG_TEST_DONE_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_LENGTH_MASK 0x6000
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_LENGTH_SHIFT 13
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_LENGTH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST1_REG_TEST_LENGTH_MASK) >> USB2PHY_USB2_UTM1_TEST1_REG_TEST_LENGTH_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST1_REG_TEST_LENGTH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST1_REG_TEST_LENGTH_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_TX_PATTERN_MASK 0x1fe0
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_TX_PATTERN_SHIFT 5
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_TX_PATTERN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST1_REG_TEST_TX_PATTERN_MASK) >> USB2PHY_USB2_UTM1_TEST1_REG_TEST_TX_PATTERN_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_TX_PATTERN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST1_REG_TEST_TX_PATTERN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST1_REG_TEST_TX_PATTERN_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_MODE_MASK 0x18
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_MODE_SHIFT 3
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_MODE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST1_REG_TEST_MODE_MASK) >> USB2PHY_USB2_UTM1_TEST1_REG_TEST_MODE_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST1_REG_TEST_MODE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST1_REG_TEST_MODE_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_LPBK_EN_MASK 0x4
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_LPBK_EN_SHIFT 2
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_LPBK_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST1_REG_TEST_LPBK_EN_MASK) >> USB2PHY_USB2_UTM1_TEST1_REG_TEST_LPBK_EN_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_LPBK_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST1_REG_TEST_LPBK_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST1_REG_TEST_LPBK_EN_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_BYPASS_MASK 0x2
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_BYPASS_SHIFT 1
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_BYPASS_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST1_REG_TEST_BYPASS_MASK) >> USB2PHY_USB2_UTM1_TEST1_REG_TEST_BYPASS_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST1_REG_TEST_BYPASS_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST1_REG_TEST_BYPASS_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_EN_MASK 0x1
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_EN_SHIFT 0
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST1_REG_TEST_EN_MASK) >> USB2PHY_USB2_UTM1_TEST1_REG_TEST_EN_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST1_REG_TEST_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST1_REG_TEST_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST1_REG_TEST_EN_SHIFT))

//====================================================================
//Register: Test Group2 Register (TEST2)
//====================================================================

#define  USB2PHY_USB2_UTM1_TEST2_RESERVED1_MASK 0xffffffff
#define  USB2PHY_USB2_UTM1_TEST2_RESERVED1_SHIFT 0
#define  USB2PHY_USB2_UTM1_TEST2_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST2_RESERVED1_MASK) >> USB2PHY_USB2_UTM1_TEST2_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST2_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST2_RESERVED1_SHIFT))

//====================================================================
//Register: Test Group3 Register (TEST3)
//====================================================================

#define  USB2PHY_USB2_UTM1_TEST3_REG_FS_EOP_MODE_MASK 0x80000000
#define  USB2PHY_USB2_UTM1_TEST3_REG_FS_EOP_MODE_SHIFT 31
#define  USB2PHY_USB2_UTM1_TEST3_REG_FS_EOP_MODE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST3_REG_FS_EOP_MODE_MASK) >> USB2PHY_USB2_UTM1_TEST3_REG_FS_EOP_MODE_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST3_REG_FS_EOP_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST3_REG_FS_EOP_MODE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST3_REG_FS_EOP_MODE_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST3_REG_HOST_DISCON_SEL1_MASK 0x40000000
#define  USB2PHY_USB2_UTM1_TEST3_REG_HOST_DISCON_SEL1_SHIFT 30
#define  USB2PHY_USB2_UTM1_TEST3_REG_HOST_DISCON_SEL1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST3_REG_HOST_DISCON_SEL1_MASK) >> USB2PHY_USB2_UTM1_TEST3_REG_HOST_DISCON_SEL1_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST3_REG_HOST_DISCON_SEL1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST3_REG_HOST_DISCON_SEL1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST3_REG_HOST_DISCON_SEL1_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST3_REG_HOST_DISCON_SEL0_MASK 0x20000000
#define  USB2PHY_USB2_UTM1_TEST3_REG_HOST_DISCON_SEL0_SHIFT 29
#define  USB2PHY_USB2_UTM1_TEST3_REG_HOST_DISCON_SEL0_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST3_REG_HOST_DISCON_SEL0_MASK) >> USB2PHY_USB2_UTM1_TEST3_REG_HOST_DISCON_SEL0_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST3_REG_HOST_DISCON_SEL0_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST3_REG_HOST_DISCON_SEL0_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST3_REG_HOST_DISCON_SEL0_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_TX_BITSTUFF_EN_MASK 0x10000000
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_TX_BITSTUFF_EN_SHIFT 28
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_TX_BITSTUFF_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST3_REG_TEST_TX_BITSTUFF_EN_MASK) >> USB2PHY_USB2_UTM1_TEST3_REG_TEST_TX_BITSTUFF_EN_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_TX_BITSTUFF_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST3_REG_TEST_TX_BITSTUFF_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST3_REG_TEST_TX_BITSTUFF_EN_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_TERM_SELECT_MASK 0x8000000
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_TERM_SELECT_SHIFT 27
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_TERM_SELECT_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST3_REG_TEST_TERM_SELECT_MASK) >> USB2PHY_USB2_UTM1_TEST3_REG_TEST_TERM_SELECT_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_TERM_SELECT_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST3_REG_TEST_TERM_SELECT_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST3_REG_TEST_TERM_SELECT_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_SUSPENDM_MASK 0x4000000
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_SUSPENDM_SHIFT 26
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_SUSPENDM_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST3_REG_TEST_SUSPENDM_MASK) >> USB2PHY_USB2_UTM1_TEST3_REG_TEST_SUSPENDM_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_SUSPENDM_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST3_REG_TEST_SUSPENDM_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST3_REG_TEST_SUSPENDM_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_RESET_MASK 0x2000000
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_RESET_SHIFT 25
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_RESET_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST3_REG_TEST_RESET_MASK) >> USB2PHY_USB2_UTM1_TEST3_REG_TEST_RESET_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_RESET_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST3_REG_TEST_RESET_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST3_REG_TEST_RESET_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_XCVR_SELECT_MASK 0x1800000
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_XCVR_SELECT_SHIFT 23
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_XCVR_SELECT_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST3_REG_TEST_XCVR_SELECT_MASK) >> USB2PHY_USB2_UTM1_TEST3_REG_TEST_XCVR_SELECT_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_XCVR_SELECT_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST3_REG_TEST_XCVR_SELECT_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST3_REG_TEST_XCVR_SELECT_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_OP_MODE_MASK 0x600000
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_OP_MODE_SHIFT 21
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_OP_MODE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST3_REG_TEST_OP_MODE_MASK) >> USB2PHY_USB2_UTM1_TEST3_REG_TEST_OP_MODE_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_OP_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST3_REG_TEST_OP_MODE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST3_REG_TEST_OP_MODE_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_UTMI_SEL_MASK 0x100000
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_UTMI_SEL_SHIFT 20
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_UTMI_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST3_REG_TEST_UTMI_SEL_MASK) >> USB2PHY_USB2_UTM1_TEST3_REG_TEST_UTMI_SEL_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST3_REG_TEST_UTMI_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST3_REG_TEST_UTMI_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST3_REG_TEST_UTMI_SEL_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE2_MASK 0x80000
#define  USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE2_SHIFT 19
#define  USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE2_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE2_MASK) >> USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE2_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE2_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE2_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE2_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE1_MASK 0x40000
#define  USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE1_SHIFT 18
#define  USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE1_MASK) >> USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE1_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE1_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE_MASK 0x20000
#define  USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE_SHIFT 17
#define  USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE_MASK) >> USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST3_REG_FS_RX_ERROR_MODE_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST3_REG_FORCE_END_EN_MASK 0x10000
#define  USB2PHY_USB2_UTM1_TEST3_REG_FORCE_END_EN_SHIFT 16
#define  USB2PHY_USB2_UTM1_TEST3_REG_FORCE_END_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST3_REG_FORCE_END_EN_MASK) >> USB2PHY_USB2_UTM1_TEST3_REG_FORCE_END_EN_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST3_REG_FORCE_END_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST3_REG_FORCE_END_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST3_REG_FORCE_END_EN_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST3_RESERVED1_MASK 0xe000
#define  USB2PHY_USB2_UTM1_TEST3_RESERVED1_SHIFT 13
#define  USB2PHY_USB2_UTM1_TEST3_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST3_RESERVED1_MASK) >> USB2PHY_USB2_UTM1_TEST3_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST3_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST3_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST3_REG_MON_SEL_MASK 0x1f80
#define  USB2PHY_USB2_UTM1_TEST3_REG_MON_SEL_SHIFT 7
#define  USB2PHY_USB2_UTM1_TEST3_REG_MON_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST3_REG_MON_SEL_MASK) >> USB2PHY_USB2_UTM1_TEST3_REG_MON_SEL_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST3_REG_MON_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST3_REG_MON_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST3_REG_MON_SEL_SHIFT))

#define  USB2PHY_USB2_UTM1_TEST3_RESERVED2_MASK 0x7f
#define  USB2PHY_USB2_UTM1_TEST3_RESERVED2_SHIFT 0
#define  USB2PHY_USB2_UTM1_TEST3_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_TEST3_RESERVED2_MASK) >> USB2PHY_USB2_UTM1_TEST3_RESERVED2_SHIFT)
#define  USB2PHY_USB2_UTM1_TEST3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_TEST3_RESERVED2_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_TEST3_RESERVED2_SHIFT))

//====================================================================
//Register: Reserve Register (RESERVE)
//====================================================================

#define  USB2PHY_USB2_UTM1_RESERVE_RESERVED1_MASK 0xffffffff
#define  USB2PHY_USB2_UTM1_RESERVE_RESERVED1_SHIFT 0
#define  USB2PHY_USB2_UTM1_RESERVE_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_RESERVE_RESERVED1_MASK) >> USB2PHY_USB2_UTM1_RESERVE_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM1_RESERVE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_RESERVE_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_RESERVE_RESERVED1_SHIFT))

//====================================================================
//Register: Addon Register (ADDON)
//====================================================================

#define  USB2PHY_USB2_UTM1_ADDON_PHY_REG_ADDON_MASK 0xffffffff
#define  USB2PHY_USB2_UTM1_ADDON_PHY_REG_ADDON_SHIFT 0
#define  USB2PHY_USB2_UTM1_ADDON_PHY_REG_ADDON_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_ADDON_PHY_REG_ADDON_MASK) >> USB2PHY_USB2_UTM1_ADDON_PHY_REG_ADDON_SHIFT)
#define  USB2PHY_USB2_UTM1_ADDON_PHY_REG_ADDON_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_ADDON_PHY_REG_ADDON_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_ADDON_PHY_REG_ADDON_SHIFT))

//====================================================================
//Register: Monitor Register (MON)
//====================================================================

#define  USB2PHY_USB2_UTM1_MON_RESERVED1_MASK 0xffff0000
#define  USB2PHY_USB2_UTM1_MON_RESERVED1_SHIFT 16
#define  USB2PHY_USB2_UTM1_MON_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_MON_RESERVED1_MASK) >> USB2PHY_USB2_UTM1_MON_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM1_MON_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_MON_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_MON_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM1_MON_USB_MON_MASK 0xffff
#define  USB2PHY_USB2_UTM1_MON_USB_MON_SHIFT 0
#define  USB2PHY_USB2_UTM1_MON_USB_MON_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM1_MON_USB_MON_MASK) >> USB2PHY_USB2_UTM1_MON_USB_MON_SHIFT)
#define  USB2PHY_USB2_UTM1_MON_USB_MON_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM1_MON_USB_MON_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM1_MON_USB_MON_SHIFT))

//====================================================================
//
//Register File: USB UTM (Instance 2 of 3) (USB2PHY_USB2_UTM2)
//
//====================================================================

//====================================================================
//Register: USB Control Register (USB_CTL)
//====================================================================

#define  USB2PHY_USB2_UTM2_USB_CTL_RESERVED1_MASK 0xffffffff
#define  USB2PHY_USB2_UTM2_USB_CTL_RESERVED1_SHIFT 0
#define  USB2PHY_USB2_UTM2_USB_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_USB_CTL_RESERVED1_MASK) >> USB2PHY_USB2_UTM2_USB_CTL_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM2_USB_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_USB_CTL_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_USB_CTL_RESERVED1_SHIFT))

//====================================================================
//Register: TX Channel Control Register (TX)
//====================================================================

#define  USB2PHY_USB2_UTM2_TX_RESERVED1_MASK 0x80000000
#define  USB2PHY_USB2_UTM2_TX_RESERVED1_SHIFT 31
#define  USB2PHY_USB2_UTM2_TX_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TX_RESERVED1_MASK) >> USB2PHY_USB2_UTM2_TX_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM2_TX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TX_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TX_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM2_TX_REG_EXT_FS_RCAL_MASK 0x78000000
#define  USB2PHY_USB2_UTM2_TX_REG_EXT_FS_RCAL_SHIFT 27
#define  USB2PHY_USB2_UTM2_TX_REG_EXT_FS_RCAL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TX_REG_EXT_FS_RCAL_MASK) >> USB2PHY_USB2_UTM2_TX_REG_EXT_FS_RCAL_SHIFT)
#define  USB2PHY_USB2_UTM2_TX_REG_EXT_FS_RCAL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TX_REG_EXT_FS_RCAL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TX_REG_EXT_FS_RCAL_SHIFT))

#define  USB2PHY_USB2_UTM2_TX_REG_EXT_FS_RCAL_EN_MASK 0x4000000
#define  USB2PHY_USB2_UTM2_TX_REG_EXT_FS_RCAL_EN_SHIFT 26
#define  USB2PHY_USB2_UTM2_TX_REG_EXT_FS_RCAL_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TX_REG_EXT_FS_RCAL_EN_MASK) >> USB2PHY_USB2_UTM2_TX_REG_EXT_FS_RCAL_EN_SHIFT)
#define  USB2PHY_USB2_UTM2_TX_REG_EXT_FS_RCAL_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TX_REG_EXT_FS_RCAL_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TX_REG_EXT_FS_RCAL_EN_SHIFT))

#define  USB2PHY_USB2_UTM2_TX_HS_SLEW_RATE_MASK 0x3000000
#define  USB2PHY_USB2_UTM2_TX_HS_SLEW_RATE_SHIFT 24
#define  USB2PHY_USB2_UTM2_TX_HS_SLEW_RATE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TX_HS_SLEW_RATE_MASK) >> USB2PHY_USB2_UTM2_TX_HS_SLEW_RATE_SHIFT)
#define  USB2PHY_USB2_UTM2_TX_HS_SLEW_RATE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TX_HS_SLEW_RATE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TX_HS_SLEW_RATE_SHIFT))

#define  USB2PHY_USB2_UTM2_TX_TXVDDL_MASK 0xc00000
#define  USB2PHY_USB2_UTM2_TX_TXVDDL_SHIFT 22
#define  USB2PHY_USB2_UTM2_TX_TXVDDL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TX_TXVDDL_MASK) >> USB2PHY_USB2_UTM2_TX_TXVDDL_SHIFT)
#define  USB2PHY_USB2_UTM2_TX_TXVDDL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TX_TXVDDL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TX_TXVDDL_SHIFT))

#define  USB2PHY_USB2_UTM2_TX_TXDATA_BLOCK_EN_MASK 0x200000
#define  USB2PHY_USB2_UTM2_TX_TXDATA_BLOCK_EN_SHIFT 21
#define  USB2PHY_USB2_UTM2_TX_TXDATA_BLOCK_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TX_TXDATA_BLOCK_EN_MASK) >> USB2PHY_USB2_UTM2_TX_TXDATA_BLOCK_EN_SHIFT)
#define  USB2PHY_USB2_UTM2_TX_TXDATA_BLOCK_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TX_TXDATA_BLOCK_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TX_TXDATA_BLOCK_EN_SHIFT))

#define  USB2PHY_USB2_UTM2_TX_FSDRV_EN_MASK 0x1e0000
#define  USB2PHY_USB2_UTM2_TX_FSDRV_EN_SHIFT 17
#define  USB2PHY_USB2_UTM2_TX_FSDRV_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TX_FSDRV_EN_MASK) >> USB2PHY_USB2_UTM2_TX_FSDRV_EN_SHIFT)
#define  USB2PHY_USB2_UTM2_TX_FSDRV_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TX_FSDRV_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TX_FSDRV_EN_SHIFT))

#define  USB2PHY_USB2_UTM2_TX_IMPCAL_VTH_MASK 0x1c000
#define  USB2PHY_USB2_UTM2_TX_IMPCAL_VTH_SHIFT 14
#define  USB2PHY_USB2_UTM2_TX_IMPCAL_VTH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TX_IMPCAL_VTH_MASK) >> USB2PHY_USB2_UTM2_TX_IMPCAL_VTH_SHIFT)
#define  USB2PHY_USB2_UTM2_TX_IMPCAL_VTH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TX_IMPCAL_VTH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TX_IMPCAL_VTH_SHIFT))

#define  USB2PHY_USB2_UTM2_TX_REG_EXT_HS_RCAL_EN_MASK 0x2000
#define  USB2PHY_USB2_UTM2_TX_REG_EXT_HS_RCAL_EN_SHIFT 13
#define  USB2PHY_USB2_UTM2_TX_REG_EXT_HS_RCAL_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TX_REG_EXT_HS_RCAL_EN_MASK) >> USB2PHY_USB2_UTM2_TX_REG_EXT_HS_RCAL_EN_SHIFT)
#define  USB2PHY_USB2_UTM2_TX_REG_EXT_HS_RCAL_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TX_REG_EXT_HS_RCAL_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TX_REG_EXT_HS_RCAL_EN_SHIFT))

#define  USB2PHY_USB2_UTM2_TX_REG_RCAL_START_MASK 0x1000
#define  USB2PHY_USB2_UTM2_TX_REG_RCAL_START_SHIFT 12
#define  USB2PHY_USB2_UTM2_TX_REG_RCAL_START_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TX_REG_RCAL_START_MASK) >> USB2PHY_USB2_UTM2_TX_REG_RCAL_START_SHIFT)
#define  USB2PHY_USB2_UTM2_TX_REG_RCAL_START_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TX_REG_RCAL_START_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TX_REG_RCAL_START_SHIFT))

#define  USB2PHY_USB2_UTM2_TX_LOWVDD_EN_MASK 0x800
#define  USB2PHY_USB2_UTM2_TX_LOWVDD_EN_SHIFT 11
#define  USB2PHY_USB2_UTM2_TX_LOWVDD_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TX_LOWVDD_EN_MASK) >> USB2PHY_USB2_UTM2_TX_LOWVDD_EN_SHIFT)
#define  USB2PHY_USB2_UTM2_TX_LOWVDD_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TX_LOWVDD_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TX_LOWVDD_EN_SHIFT))

#define  USB2PHY_USB2_UTM2_TX_HSDRV_EN_MASK 0x780
#define  USB2PHY_USB2_UTM2_TX_HSDRV_EN_SHIFT 7
#define  USB2PHY_USB2_UTM2_TX_HSDRV_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TX_HSDRV_EN_MASK) >> USB2PHY_USB2_UTM2_TX_HSDRV_EN_SHIFT)
#define  USB2PHY_USB2_UTM2_TX_HSDRV_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TX_HSDRV_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TX_HSDRV_EN_SHIFT))

#define  USB2PHY_USB2_UTM2_TX_REG_EXT_HS_RCAL_MASK 0x78
#define  USB2PHY_USB2_UTM2_TX_REG_EXT_HS_RCAL_SHIFT 3
#define  USB2PHY_USB2_UTM2_TX_REG_EXT_HS_RCAL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TX_REG_EXT_HS_RCAL_MASK) >> USB2PHY_USB2_UTM2_TX_REG_EXT_HS_RCAL_SHIFT)
#define  USB2PHY_USB2_UTM2_TX_REG_EXT_HS_RCAL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TX_REG_EXT_HS_RCAL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TX_REG_EXT_HS_RCAL_SHIFT))

#define  USB2PHY_USB2_UTM2_TX_AMP_MASK 0x7
#define  USB2PHY_USB2_UTM2_TX_AMP_SHIFT 0
#define  USB2PHY_USB2_UTM2_TX_AMP_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TX_AMP_MASK) >> USB2PHY_USB2_UTM2_TX_AMP_SHIFT)
#define  USB2PHY_USB2_UTM2_TX_AMP_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TX_AMP_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TX_AMP_SHIFT))

//====================================================================
//Register: RX Channel Control Register 0 (RX0)
//====================================================================

#define  USB2PHY_USB2_UTM2_RX0_EARLY_VOS_ON_EN_MASK 0x80000000
#define  USB2PHY_USB2_UTM2_RX0_EARLY_VOS_ON_EN_SHIFT 31
#define  USB2PHY_USB2_UTM2_RX0_EARLY_VOS_ON_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX0_EARLY_VOS_ON_EN_MASK) >> USB2PHY_USB2_UTM2_RX0_EARLY_VOS_ON_EN_SHIFT)
#define  USB2PHY_USB2_UTM2_RX0_EARLY_VOS_ON_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX0_EARLY_VOS_ON_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX0_EARLY_VOS_ON_EN_SHIFT))

#define  USB2PHY_USB2_UTM2_RX0_RXDATA_BLOCK_EN_MASK 0x40000000
#define  USB2PHY_USB2_UTM2_RX0_RXDATA_BLOCK_EN_SHIFT 30
#define  USB2PHY_USB2_UTM2_RX0_RXDATA_BLOCK_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX0_RXDATA_BLOCK_EN_MASK) >> USB2PHY_USB2_UTM2_RX0_RXDATA_BLOCK_EN_SHIFT)
#define  USB2PHY_USB2_UTM2_RX0_RXDATA_BLOCK_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX0_RXDATA_BLOCK_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX0_RXDATA_BLOCK_EN_SHIFT))

#define  USB2PHY_USB2_UTM2_RX0_RXDATA_BLOCK_LENGTH_MASK 0x30000000
#define  USB2PHY_USB2_UTM2_RX0_RXDATA_BLOCK_LENGTH_SHIFT 28
#define  USB2PHY_USB2_UTM2_RX0_RXDATA_BLOCK_LENGTH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX0_RXDATA_BLOCK_LENGTH_MASK) >> USB2PHY_USB2_UTM2_RX0_RXDATA_BLOCK_LENGTH_SHIFT)
#define  USB2PHY_USB2_UTM2_RX0_RXDATA_BLOCK_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX0_RXDATA_BLOCK_LENGTH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX0_RXDATA_BLOCK_LENGTH_SHIFT))

#define  USB2PHY_USB2_UTM2_RX0_EDGE_DET_SEL_MASK 0xc000000
#define  USB2PHY_USB2_UTM2_RX0_EDGE_DET_SEL_SHIFT 26
#define  USB2PHY_USB2_UTM2_RX0_EDGE_DET_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX0_EDGE_DET_SEL_MASK) >> USB2PHY_USB2_UTM2_RX0_EDGE_DET_SEL_SHIFT)
#define  USB2PHY_USB2_UTM2_RX0_EDGE_DET_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX0_EDGE_DET_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX0_EDGE_DET_SEL_SHIFT))

#define  USB2PHY_USB2_UTM2_RX0_EDGE_DET_EN_MASK 0x2000000
#define  USB2PHY_USB2_UTM2_RX0_EDGE_DET_EN_SHIFT 25
#define  USB2PHY_USB2_UTM2_RX0_EDGE_DET_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX0_EDGE_DET_EN_MASK) >> USB2PHY_USB2_UTM2_RX0_EDGE_DET_EN_SHIFT)
#define  USB2PHY_USB2_UTM2_RX0_EDGE_DET_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX0_EDGE_DET_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX0_EDGE_DET_EN_SHIFT))

#define  USB2PHY_USB2_UTM2_RX0_S2TO3_DLY_SEL_MASK 0x1800000
#define  USB2PHY_USB2_UTM2_RX0_S2TO3_DLY_SEL_SHIFT 23
#define  USB2PHY_USB2_UTM2_RX0_S2TO3_DLY_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX0_S2TO3_DLY_SEL_MASK) >> USB2PHY_USB2_UTM2_RX0_S2TO3_DLY_SEL_SHIFT)
#define  USB2PHY_USB2_UTM2_RX0_S2TO3_DLY_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX0_S2TO3_DLY_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX0_S2TO3_DLY_SEL_SHIFT))

#define  USB2PHY_USB2_UTM2_RX0_CDR_COEF_SEL_MASK 0x400000
#define  USB2PHY_USB2_UTM2_RX0_CDR_COEF_SEL_SHIFT 22
#define  USB2PHY_USB2_UTM2_RX0_CDR_COEF_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX0_CDR_COEF_SEL_MASK) >> USB2PHY_USB2_UTM2_RX0_CDR_COEF_SEL_SHIFT)
#define  USB2PHY_USB2_UTM2_RX0_CDR_COEF_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX0_CDR_COEF_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX0_CDR_COEF_SEL_SHIFT))

#define  USB2PHY_USB2_UTM2_RX0_CDR_FASTLOCK_EN_MASK 0x200000
#define  USB2PHY_USB2_UTM2_RX0_CDR_FASTLOCK_EN_SHIFT 21
#define  USB2PHY_USB2_UTM2_RX0_CDR_FASTLOCK_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX0_CDR_FASTLOCK_EN_MASK) >> USB2PHY_USB2_UTM2_RX0_CDR_FASTLOCK_EN_SHIFT)
#define  USB2PHY_USB2_UTM2_RX0_CDR_FASTLOCK_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX0_CDR_FASTLOCK_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX0_CDR_FASTLOCK_EN_SHIFT))

#define  USB2PHY_USB2_UTM2_RX0_PHASE_FREEZE_DLY_MASK 0x100000
#define  USB2PHY_USB2_UTM2_RX0_PHASE_FREEZE_DLY_SHIFT 20
#define  USB2PHY_USB2_UTM2_RX0_PHASE_FREEZE_DLY_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX0_PHASE_FREEZE_DLY_MASK) >> USB2PHY_USB2_UTM2_RX0_PHASE_FREEZE_DLY_SHIFT)
#define  USB2PHY_USB2_UTM2_RX0_PHASE_FREEZE_DLY_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX0_PHASE_FREEZE_DLY_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX0_PHASE_FREEZE_DLY_SHIFT))

#define  USB2PHY_USB2_UTM2_RX0_REG_USQ_LENGTH_MASK 0x80000
#define  USB2PHY_USB2_UTM2_RX0_REG_USQ_LENGTH_SHIFT 19
#define  USB2PHY_USB2_UTM2_RX0_REG_USQ_LENGTH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX0_REG_USQ_LENGTH_MASK) >> USB2PHY_USB2_UTM2_RX0_REG_USQ_LENGTH_SHIFT)
#define  USB2PHY_USB2_UTM2_RX0_REG_USQ_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX0_REG_USQ_LENGTH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX0_REG_USQ_LENGTH_SHIFT))

#define  USB2PHY_USB2_UTM2_RX0_REG_ACQ_LENGTH_MASK 0x60000
#define  USB2PHY_USB2_UTM2_RX0_REG_ACQ_LENGTH_SHIFT 17
#define  USB2PHY_USB2_UTM2_RX0_REG_ACQ_LENGTH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX0_REG_ACQ_LENGTH_MASK) >> USB2PHY_USB2_UTM2_RX0_REG_ACQ_LENGTH_SHIFT)
#define  USB2PHY_USB2_UTM2_RX0_REG_ACQ_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX0_REG_ACQ_LENGTH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX0_REG_ACQ_LENGTH_SHIFT))

#define  USB2PHY_USB2_UTM2_RX0_REG_SQ_LENGTH_MASK 0x18000
#define  USB2PHY_USB2_UTM2_RX0_REG_SQ_LENGTH_SHIFT 15
#define  USB2PHY_USB2_UTM2_RX0_REG_SQ_LENGTH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX0_REG_SQ_LENGTH_MASK) >> USB2PHY_USB2_UTM2_RX0_REG_SQ_LENGTH_SHIFT)
#define  USB2PHY_USB2_UTM2_RX0_REG_SQ_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX0_REG_SQ_LENGTH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX0_REG_SQ_LENGTH_SHIFT))

#define  USB2PHY_USB2_UTM2_RX0_RESERVED1_MASK 0x6000
#define  USB2PHY_USB2_UTM2_RX0_RESERVED1_SHIFT 13
#define  USB2PHY_USB2_UTM2_RX0_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX0_RESERVED1_MASK) >> USB2PHY_USB2_UTM2_RX0_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM2_RX0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX0_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX0_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM2_RX0_CAP_SEL_MASK 0x1c00
#define  USB2PHY_USB2_UTM2_RX0_CAP_SEL_SHIFT 10
#define  USB2PHY_USB2_UTM2_RX0_CAP_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX0_CAP_SEL_MASK) >> USB2PHY_USB2_UTM2_RX0_CAP_SEL_SHIFT)
#define  USB2PHY_USB2_UTM2_RX0_CAP_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX0_CAP_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX0_CAP_SEL_SHIFT))

#define  USB2PHY_USB2_UTM2_RX0_DISCON_THRESH_MASK 0x300
#define  USB2PHY_USB2_UTM2_RX0_DISCON_THRESH_SHIFT 8
#define  USB2PHY_USB2_UTM2_RX0_DISCON_THRESH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX0_DISCON_THRESH_MASK) >> USB2PHY_USB2_UTM2_RX0_DISCON_THRESH_SHIFT)
#define  USB2PHY_USB2_UTM2_RX0_DISCON_THRESH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX0_DISCON_THRESH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX0_DISCON_THRESH_SHIFT))

#define  USB2PHY_USB2_UTM2_RX0_SQ_THRESH_MASK 0xf0
#define  USB2PHY_USB2_UTM2_RX0_SQ_THRESH_SHIFT 4
#define  USB2PHY_USB2_UTM2_RX0_SQ_THRESH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX0_SQ_THRESH_MASK) >> USB2PHY_USB2_UTM2_RX0_SQ_THRESH_SHIFT)
#define  USB2PHY_USB2_UTM2_RX0_SQ_THRESH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX0_SQ_THRESH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX0_SQ_THRESH_SHIFT))

#define  USB2PHY_USB2_UTM2_RX0_LPF_COEF_MASK 0xc
#define  USB2PHY_USB2_UTM2_RX0_LPF_COEF_SHIFT 2
#define  USB2PHY_USB2_UTM2_RX0_LPF_COEF_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX0_LPF_COEF_MASK) >> USB2PHY_USB2_UTM2_RX0_LPF_COEF_SHIFT)
#define  USB2PHY_USB2_UTM2_RX0_LPF_COEF_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX0_LPF_COEF_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX0_LPF_COEF_SHIFT))

#define  USB2PHY_USB2_UTM2_RX0_INTPI_MASK 0x3
#define  USB2PHY_USB2_UTM2_RX0_INTPI_SHIFT 0
#define  USB2PHY_USB2_UTM2_RX0_INTPI_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX0_INTPI_MASK) >> USB2PHY_USB2_UTM2_RX0_INTPI_SHIFT)
#define  USB2PHY_USB2_UTM2_RX0_INTPI_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX0_INTPI_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX0_INTPI_SHIFT))

//====================================================================
//Register: Receive Channel Control Register 1 (RX1)
//====================================================================

#define  USB2PHY_USB2_UTM2_RX1_RESERVED1_MASK 0xffff0000
#define  USB2PHY_USB2_UTM2_RX1_RESERVED1_SHIFT 16
#define  USB2PHY_USB2_UTM2_RX1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX1_RESERVED1_MASK) >> USB2PHY_USB2_UTM2_RX1_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM2_RX1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX1_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX1_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM2_RX1_PU_PHY_MASK 0x8000
#define  USB2PHY_USB2_UTM2_RX1_PU_PHY_SHIFT 15
#define  USB2PHY_USB2_UTM2_RX1_PU_PHY_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX1_PU_PHY_MASK) >> USB2PHY_USB2_UTM2_RX1_PU_PHY_SHIFT)
#define  USB2PHY_USB2_UTM2_RX1_PU_PHY_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX1_PU_PHY_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX1_PU_PHY_SHIFT))

#define  USB2PHY_USB2_UTM2_RX1_STRESS_TEST_MODE_MASK 0x4000
#define  USB2PHY_USB2_UTM2_RX1_STRESS_TEST_MODE_SHIFT 14
#define  USB2PHY_USB2_UTM2_RX1_STRESS_TEST_MODE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX1_STRESS_TEST_MODE_MASK) >> USB2PHY_USB2_UTM2_RX1_STRESS_TEST_MODE_SHIFT)
#define  USB2PHY_USB2_UTM2_RX1_STRESS_TEST_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX1_STRESS_TEST_MODE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX1_STRESS_TEST_MODE_SHIFT))

#define  USB2PHY_USB2_UTM2_RX1_RESERVED2_MASK 0x2000
#define  USB2PHY_USB2_UTM2_RX1_RESERVED2_SHIFT 13
#define  USB2PHY_USB2_UTM2_RX1_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX1_RESERVED2_MASK) >> USB2PHY_USB2_UTM2_RX1_RESERVED2_SHIFT)
#define  USB2PHY_USB2_UTM2_RX1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX1_RESERVED2_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX1_RESERVED2_SHIFT))

#define  USB2PHY_USB2_UTM2_RX1_TESTMON_MASK 0x1e00
#define  USB2PHY_USB2_UTM2_RX1_TESTMON_SHIFT 9
#define  USB2PHY_USB2_UTM2_RX1_TESTMON_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX1_TESTMON_MASK) >> USB2PHY_USB2_UTM2_RX1_TESTMON_SHIFT)
#define  USB2PHY_USB2_UTM2_RX1_TESTMON_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX1_TESTMON_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX1_TESTMON_SHIFT))

#define  USB2PHY_USB2_UTM2_RX1_USQ_FILTER_MASK 0x100
#define  USB2PHY_USB2_UTM2_RX1_USQ_FILTER_SHIFT 8
#define  USB2PHY_USB2_UTM2_RX1_USQ_FILTER_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX1_USQ_FILTER_MASK) >> USB2PHY_USB2_UTM2_RX1_USQ_FILTER_SHIFT)
#define  USB2PHY_USB2_UTM2_RX1_USQ_FILTER_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX1_USQ_FILTER_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX1_USQ_FILTER_SHIFT))

#define  USB2PHY_USB2_UTM2_RX1_SQ_CM_SEL_MASK 0x80
#define  USB2PHY_USB2_UTM2_RX1_SQ_CM_SEL_SHIFT 7
#define  USB2PHY_USB2_UTM2_RX1_SQ_CM_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX1_SQ_CM_SEL_MASK) >> USB2PHY_USB2_UTM2_RX1_SQ_CM_SEL_SHIFT)
#define  USB2PHY_USB2_UTM2_RX1_SQ_CM_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX1_SQ_CM_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX1_SQ_CM_SEL_SHIFT))

#define  USB2PHY_USB2_UTM2_RX1_SAMPLER_CTRL_MASK 0x40
#define  USB2PHY_USB2_UTM2_RX1_SAMPLER_CTRL_SHIFT 6
#define  USB2PHY_USB2_UTM2_RX1_SAMPLER_CTRL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX1_SAMPLER_CTRL_MASK) >> USB2PHY_USB2_UTM2_RX1_SAMPLER_CTRL_SHIFT)
#define  USB2PHY_USB2_UTM2_RX1_SAMPLER_CTRL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX1_SAMPLER_CTRL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX1_SAMPLER_CTRL_SHIFT))

#define  USB2PHY_USB2_UTM2_RX1_SQ_BUFFER_EN_MASK 0x20
#define  USB2PHY_USB2_UTM2_RX1_SQ_BUFFER_EN_SHIFT 5
#define  USB2PHY_USB2_UTM2_RX1_SQ_BUFFER_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX1_SQ_BUFFER_EN_MASK) >> USB2PHY_USB2_UTM2_RX1_SQ_BUFFER_EN_SHIFT)
#define  USB2PHY_USB2_UTM2_RX1_SQ_BUFFER_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX1_SQ_BUFFER_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX1_SQ_BUFFER_EN_SHIFT))

#define  USB2PHY_USB2_UTM2_RX1_SQ_ALWAYS_ON_MASK 0x10
#define  USB2PHY_USB2_UTM2_RX1_SQ_ALWAYS_ON_SHIFT 4
#define  USB2PHY_USB2_UTM2_RX1_SQ_ALWAYS_ON_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX1_SQ_ALWAYS_ON_MASK) >> USB2PHY_USB2_UTM2_RX1_SQ_ALWAYS_ON_SHIFT)
#define  USB2PHY_USB2_UTM2_RX1_SQ_ALWAYS_ON_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX1_SQ_ALWAYS_ON_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX1_SQ_ALWAYS_ON_SHIFT))

#define  USB2PHY_USB2_UTM2_RX1_RXVDDL_MASK 0xc
#define  USB2PHY_USB2_UTM2_RX1_RXVDDL_SHIFT 2
#define  USB2PHY_USB2_UTM2_RX1_RXVDDL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX1_RXVDDL_MASK) >> USB2PHY_USB2_UTM2_RX1_RXVDDL_SHIFT)
#define  USB2PHY_USB2_UTM2_RX1_RXVDDL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX1_RXVDDL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX1_RXVDDL_SHIFT))

#define  USB2PHY_USB2_UTM2_RX1_RESERVED3_MASK 0x3
#define  USB2PHY_USB2_UTM2_RX1_RESERVED3_SHIFT 0
#define  USB2PHY_USB2_UTM2_RX1_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RX1_RESERVED3_MASK) >> USB2PHY_USB2_UTM2_RX1_RESERVED3_SHIFT)
#define  USB2PHY_USB2_UTM2_RX1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RX1_RESERVED3_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RX1_RESERVED3_SHIFT))

//====================================================================
//Register: PHY IVREF Control Register (IVREF)
//====================================================================

#define  USB2PHY_USB2_UTM2_IVREF_PHY_IVREF_CTL_MASK 0xffffffff
#define  USB2PHY_USB2_UTM2_IVREF_PHY_IVREF_CTL_SHIFT 0
#define  USB2PHY_USB2_UTM2_IVREF_PHY_IVREF_CTL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_IVREF_PHY_IVREF_CTL_MASK) >> USB2PHY_USB2_UTM2_IVREF_PHY_IVREF_CTL_SHIFT)
#define  USB2PHY_USB2_UTM2_IVREF_PHY_IVREF_CTL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_IVREF_PHY_IVREF_CTL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_IVREF_PHY_IVREF_CTL_SHIFT))

//====================================================================
//Register: Test Group0 Register (TEST0)
//====================================================================

#define  USB2PHY_USB2_UTM2_TEST0_REG_FIFO_OV_MASK 0x80000000
#define  USB2PHY_USB2_UTM2_TEST0_REG_FIFO_OV_SHIFT 31
#define  USB2PHY_USB2_UTM2_TEST0_REG_FIFO_OV_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_REG_FIFO_OV_MASK) >> USB2PHY_USB2_UTM2_TEST0_REG_FIFO_OV_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_REG_FIFO_OV_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_REG_FIFO_OV_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_REG_FIFO_OV_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_REG_FIFO_UF_MASK 0x40000000
#define  USB2PHY_USB2_UTM2_TEST0_REG_FIFO_UF_SHIFT 30
#define  USB2PHY_USB2_UTM2_TEST0_REG_FIFO_UF_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_REG_FIFO_UF_MASK) >> USB2PHY_USB2_UTM2_TEST0_REG_FIFO_UF_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_REG_FIFO_UF_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_REG_FIFO_UF_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_REG_FIFO_UF_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_RESERVED1_MASK 0x20000000
#define  USB2PHY_USB2_UTM2_TEST0_RESERVED1_SHIFT 29
#define  USB2PHY_USB2_UTM2_TEST0_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_RESERVED1_MASK) >> USB2PHY_USB2_UTM2_TEST0_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_REG_ARC_DPDM_MODE_MASK 0x10000000
#define  USB2PHY_USB2_UTM2_TEST0_REG_ARC_DPDM_MODE_SHIFT 28
#define  USB2PHY_USB2_UTM2_TEST0_REG_ARC_DPDM_MODE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_REG_ARC_DPDM_MODE_MASK) >> USB2PHY_USB2_UTM2_TEST0_REG_ARC_DPDM_MODE_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_REG_ARC_DPDM_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_REG_ARC_DPDM_MODE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_REG_ARC_DPDM_MODE_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_REG_DP_PULLDOWN_MASK 0x8000000
#define  USB2PHY_USB2_UTM2_TEST0_REG_DP_PULLDOWN_SHIFT 27
#define  USB2PHY_USB2_UTM2_TEST0_REG_DP_PULLDOWN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_REG_DP_PULLDOWN_MASK) >> USB2PHY_USB2_UTM2_TEST0_REG_DP_PULLDOWN_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_REG_DP_PULLDOWN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_REG_DP_PULLDOWN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_REG_DP_PULLDOWN_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_REG_DM_PULLDOWN_MASK 0x4000000
#define  USB2PHY_USB2_UTM2_TEST0_REG_DM_PULLDOWN_SHIFT 26
#define  USB2PHY_USB2_UTM2_TEST0_REG_DM_PULLDOWN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_REG_DM_PULLDOWN_MASK) >> USB2PHY_USB2_UTM2_TEST0_REG_DM_PULLDOWN_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_REG_DM_PULLDOWN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_REG_DM_PULLDOWN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_REG_DM_PULLDOWN_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_RESERVED2_MASK 0x2000000
#define  USB2PHY_USB2_UTM2_TEST0_RESERVED2_SHIFT 25
#define  USB2PHY_USB2_UTM2_TEST0_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_RESERVED2_MASK) >> USB2PHY_USB2_UTM2_TEST0_RESERVED2_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_RESERVED2_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_RESERVED2_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_REG_FIFO_FILL_NUM_MASK 0x1e00000
#define  USB2PHY_USB2_UTM2_TEST0_REG_FIFO_FILL_NUM_SHIFT 21
#define  USB2PHY_USB2_UTM2_TEST0_REG_FIFO_FILL_NUM_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_REG_FIFO_FILL_NUM_MASK) >> USB2PHY_USB2_UTM2_TEST0_REG_FIFO_FILL_NUM_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_REG_FIFO_FILL_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_REG_FIFO_FILL_NUM_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_REG_FIFO_FILL_NUM_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_REG_SQ_SYNC_SEL_MASK 0x100000
#define  USB2PHY_USB2_UTM2_TEST0_REG_SQ_SYNC_SEL_SHIFT 20
#define  USB2PHY_USB2_UTM2_TEST0_REG_SQ_SYNC_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_REG_SQ_SYNC_SEL_MASK) >> USB2PHY_USB2_UTM2_TEST0_REG_SQ_SYNC_SEL_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_REG_SQ_SYNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_REG_SQ_SYNC_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_REG_SQ_SYNC_SEL_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_REG_ALIGN_FS_OUTEN_MASK 0x80000
#define  USB2PHY_USB2_UTM2_TEST0_REG_ALIGN_FS_OUTEN_SHIFT 19
#define  USB2PHY_USB2_UTM2_TEST0_REG_ALIGN_FS_OUTEN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_REG_ALIGN_FS_OUTEN_MASK) >> USB2PHY_USB2_UTM2_TEST0_REG_ALIGN_FS_OUTEN_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_REG_ALIGN_FS_OUTEN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_REG_ALIGN_FS_OUTEN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_REG_ALIGN_FS_OUTEN_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_RESERVED3_MASK 0x40000
#define  USB2PHY_USB2_UTM2_TEST0_RESERVED3_SHIFT 18
#define  USB2PHY_USB2_UTM2_TEST0_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_RESERVED3_MASK) >> USB2PHY_USB2_UTM2_TEST0_RESERVED3_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_RESERVED3_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_RESERVED3_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_REG_LONG_EOP_MASK 0x20000
#define  USB2PHY_USB2_UTM2_TEST0_REG_LONG_EOP_SHIFT 17
#define  USB2PHY_USB2_UTM2_TEST0_REG_LONG_EOP_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_REG_LONG_EOP_MASK) >> USB2PHY_USB2_UTM2_TEST0_REG_LONG_EOP_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_REG_LONG_EOP_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_REG_LONG_EOP_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_REG_LONG_EOP_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_REG_PLL_LOCK_BYPASS_MASK 0x10000
#define  USB2PHY_USB2_UTM2_TEST0_REG_PLL_LOCK_BYPASS_SHIFT 16
#define  USB2PHY_USB2_UTM2_TEST0_REG_PLL_LOCK_BYPASS_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_REG_PLL_LOCK_BYPASS_MASK) >> USB2PHY_USB2_UTM2_TEST0_REG_PLL_LOCK_BYPASS_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_REG_PLL_LOCK_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_REG_PLL_LOCK_BYPASS_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_REG_PLL_LOCK_BYPASS_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_REG_FIFO_SQ_RST_MASK 0x8000
#define  USB2PHY_USB2_UTM2_TEST0_REG_FIFO_SQ_RST_SHIFT 15
#define  USB2PHY_USB2_UTM2_TEST0_REG_FIFO_SQ_RST_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_REG_FIFO_SQ_RST_MASK) >> USB2PHY_USB2_UTM2_TEST0_REG_FIFO_SQ_RST_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_REG_FIFO_SQ_RST_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_REG_FIFO_SQ_RST_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_REG_FIFO_SQ_RST_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_REG_CLK_SUSPEND_EN_MASK 0x4000
#define  USB2PHY_USB2_UTM2_TEST0_REG_CLK_SUSPEND_EN_SHIFT 14
#define  USB2PHY_USB2_UTM2_TEST0_REG_CLK_SUSPEND_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_REG_CLK_SUSPEND_EN_MASK) >> USB2PHY_USB2_UTM2_TEST0_REG_CLK_SUSPEND_EN_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_REG_CLK_SUSPEND_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_REG_CLK_SUSPEND_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_REG_CLK_SUSPEND_EN_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_REG_EARLY_TX_ENABLE_MASK 0x2000
#define  USB2PHY_USB2_UTM2_TEST0_REG_EARLY_TX_ENABLE_SHIFT 13
#define  USB2PHY_USB2_UTM2_TEST0_REG_EARLY_TX_ENABLE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_REG_EARLY_TX_ENABLE_MASK) >> USB2PHY_USB2_UTM2_TEST0_REG_EARLY_TX_ENABLE_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_REG_EARLY_TX_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_REG_EARLY_TX_ENABLE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_REG_EARLY_TX_ENABLE_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_REG_OVUF_RST_EN_MASK 0x1000
#define  USB2PHY_USB2_UTM2_TEST0_REG_OVUF_RST_EN_SHIFT 12
#define  USB2PHY_USB2_UTM2_TEST0_REG_OVUF_RST_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_REG_OVUF_RST_EN_MASK) >> USB2PHY_USB2_UTM2_TEST0_REG_OVUF_RST_EN_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_REG_OVUF_RST_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_REG_OVUF_RST_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_REG_OVUF_RST_EN_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_REG_EOP_RST_EN_MASK 0x800
#define  USB2PHY_USB2_UTM2_TEST0_REG_EOP_RST_EN_SHIFT 11
#define  USB2PHY_USB2_UTM2_TEST0_REG_EOP_RST_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_REG_EOP_RST_EN_MASK) >> USB2PHY_USB2_UTM2_TEST0_REG_EOP_RST_EN_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_REG_EOP_RST_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_REG_EOP_RST_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_REG_EOP_RST_EN_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_REG_SYNC_NUM_MASK 0x600
#define  USB2PHY_USB2_UTM2_TEST0_REG_SYNC_NUM_SHIFT 9
#define  USB2PHY_USB2_UTM2_TEST0_REG_SYNC_NUM_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_REG_SYNC_NUM_MASK) >> USB2PHY_USB2_UTM2_TEST0_REG_SYNC_NUM_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_REG_SYNC_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_REG_SYNC_NUM_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_REG_SYNC_NUM_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_REG_NOVBUS_DPDM00_MASK 0x100
#define  USB2PHY_USB2_UTM2_TEST0_REG_NOVBUS_DPDM00_SHIFT 8
#define  USB2PHY_USB2_UTM2_TEST0_REG_NOVBUS_DPDM00_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_REG_NOVBUS_DPDM00_MASK) >> USB2PHY_USB2_UTM2_TEST0_REG_NOVBUS_DPDM00_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_REG_NOVBUS_DPDM00_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_REG_NOVBUS_DPDM00_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_REG_NOVBUS_DPDM00_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST0_RESERVED4_MASK 0xff
#define  USB2PHY_USB2_UTM2_TEST0_RESERVED4_SHIFT 0
#define  USB2PHY_USB2_UTM2_TEST0_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST0_RESERVED4_MASK) >> USB2PHY_USB2_UTM2_TEST0_RESERVED4_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST0_RESERVED4_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST0_RESERVED4_SHIFT))

//====================================================================
//Register: Test Group1 Register (TEST1)
//====================================================================

#define  USB2PHY_USB2_UTM2_TEST1_REG_HS_HDL_SYNC_MASK 0x80000000
#define  USB2PHY_USB2_UTM2_TEST1_REG_HS_HDL_SYNC_SHIFT 31
#define  USB2PHY_USB2_UTM2_TEST1_REG_HS_HDL_SYNC_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST1_REG_HS_HDL_SYNC_MASK) >> USB2PHY_USB2_UTM2_TEST1_REG_HS_HDL_SYNC_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST1_REG_HS_HDL_SYNC_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST1_REG_HS_HDL_SYNC_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST1_REG_HS_HDL_SYNC_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST1_REG_FS_HDL_OPMD_MASK 0x40000000
#define  USB2PHY_USB2_UTM2_TEST1_REG_FS_HDL_OPMD_SHIFT 30
#define  USB2PHY_USB2_UTM2_TEST1_REG_FS_HDL_OPMD_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST1_REG_FS_HDL_OPMD_MASK) >> USB2PHY_USB2_UTM2_TEST1_REG_FS_HDL_OPMD_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST1_REG_FS_HDL_OPMD_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST1_REG_FS_HDL_OPMD_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST1_REG_FS_HDL_OPMD_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST1_RESERVED1_MASK 0x3fc00000
#define  USB2PHY_USB2_UTM2_TEST1_RESERVED1_SHIFT 22
#define  USB2PHY_USB2_UTM2_TEST1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST1_RESERVED1_MASK) >> USB2PHY_USB2_UTM2_TEST1_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST1_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST1_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST1_RESERVED2_MASK 0x200000
#define  USB2PHY_USB2_UTM2_TEST1_RESERVED2_SHIFT 21
#define  USB2PHY_USB2_UTM2_TEST1_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST1_RESERVED2_MASK) >> USB2PHY_USB2_UTM2_TEST1_RESERVED2_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST1_RESERVED2_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST1_RESERVED2_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_DIG_LPBK_MASK 0x100000
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_DIG_LPBK_SHIFT 20
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_DIG_LPBK_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST1_REG_TEST_DIG_LPBK_MASK) >> USB2PHY_USB2_UTM2_TEST1_REG_TEST_DIG_LPBK_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_DIG_LPBK_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST1_REG_TEST_DIG_LPBK_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST1_REG_TEST_DIG_LPBK_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_SKIP_MASK 0xe0000
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_SKIP_SHIFT 17
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_SKIP_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST1_REG_TEST_SKIP_MASK) >> USB2PHY_USB2_UTM2_TEST1_REG_TEST_SKIP_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_SKIP_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST1_REG_TEST_SKIP_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST1_REG_TEST_SKIP_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_FLAG_MASK 0x10000
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_FLAG_SHIFT 16
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_FLAG_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST1_REG_TEST_FLAG_MASK) >> USB2PHY_USB2_UTM2_TEST1_REG_TEST_FLAG_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_FLAG_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST1_REG_TEST_FLAG_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST1_REG_TEST_FLAG_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_DONE_MASK 0x8000
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_DONE_SHIFT 15
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_DONE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST1_REG_TEST_DONE_MASK) >> USB2PHY_USB2_UTM2_TEST1_REG_TEST_DONE_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_DONE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST1_REG_TEST_DONE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST1_REG_TEST_DONE_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_LENGTH_MASK 0x6000
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_LENGTH_SHIFT 13
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_LENGTH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST1_REG_TEST_LENGTH_MASK) >> USB2PHY_USB2_UTM2_TEST1_REG_TEST_LENGTH_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST1_REG_TEST_LENGTH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST1_REG_TEST_LENGTH_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_TX_PATTERN_MASK 0x1fe0
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_TX_PATTERN_SHIFT 5
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_TX_PATTERN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST1_REG_TEST_TX_PATTERN_MASK) >> USB2PHY_USB2_UTM2_TEST1_REG_TEST_TX_PATTERN_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_TX_PATTERN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST1_REG_TEST_TX_PATTERN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST1_REG_TEST_TX_PATTERN_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_MODE_MASK 0x18
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_MODE_SHIFT 3
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_MODE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST1_REG_TEST_MODE_MASK) >> USB2PHY_USB2_UTM2_TEST1_REG_TEST_MODE_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST1_REG_TEST_MODE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST1_REG_TEST_MODE_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_LPBK_EN_MASK 0x4
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_LPBK_EN_SHIFT 2
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_LPBK_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST1_REG_TEST_LPBK_EN_MASK) >> USB2PHY_USB2_UTM2_TEST1_REG_TEST_LPBK_EN_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_LPBK_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST1_REG_TEST_LPBK_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST1_REG_TEST_LPBK_EN_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_BYPASS_MASK 0x2
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_BYPASS_SHIFT 1
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_BYPASS_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST1_REG_TEST_BYPASS_MASK) >> USB2PHY_USB2_UTM2_TEST1_REG_TEST_BYPASS_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST1_REG_TEST_BYPASS_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST1_REG_TEST_BYPASS_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_EN_MASK 0x1
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_EN_SHIFT 0
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST1_REG_TEST_EN_MASK) >> USB2PHY_USB2_UTM2_TEST1_REG_TEST_EN_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST1_REG_TEST_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST1_REG_TEST_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST1_REG_TEST_EN_SHIFT))

//====================================================================
//Register: Test Group2 Register (TEST2)
//====================================================================

#define  USB2PHY_USB2_UTM2_TEST2_RESERVED1_MASK 0xffffffff
#define  USB2PHY_USB2_UTM2_TEST2_RESERVED1_SHIFT 0
#define  USB2PHY_USB2_UTM2_TEST2_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST2_RESERVED1_MASK) >> USB2PHY_USB2_UTM2_TEST2_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST2_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST2_RESERVED1_SHIFT))

//====================================================================
//Register: Test Group3 Register (TEST3)
//====================================================================

#define  USB2PHY_USB2_UTM2_TEST3_REG_FS_EOP_MODE_MASK 0x80000000
#define  USB2PHY_USB2_UTM2_TEST3_REG_FS_EOP_MODE_SHIFT 31
#define  USB2PHY_USB2_UTM2_TEST3_REG_FS_EOP_MODE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST3_REG_FS_EOP_MODE_MASK) >> USB2PHY_USB2_UTM2_TEST3_REG_FS_EOP_MODE_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST3_REG_FS_EOP_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST3_REG_FS_EOP_MODE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST3_REG_FS_EOP_MODE_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST3_REG_HOST_DISCON_SEL1_MASK 0x40000000
#define  USB2PHY_USB2_UTM2_TEST3_REG_HOST_DISCON_SEL1_SHIFT 30
#define  USB2PHY_USB2_UTM2_TEST3_REG_HOST_DISCON_SEL1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST3_REG_HOST_DISCON_SEL1_MASK) >> USB2PHY_USB2_UTM2_TEST3_REG_HOST_DISCON_SEL1_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST3_REG_HOST_DISCON_SEL1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST3_REG_HOST_DISCON_SEL1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST3_REG_HOST_DISCON_SEL1_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST3_REG_HOST_DISCON_SEL0_MASK 0x20000000
#define  USB2PHY_USB2_UTM2_TEST3_REG_HOST_DISCON_SEL0_SHIFT 29
#define  USB2PHY_USB2_UTM2_TEST3_REG_HOST_DISCON_SEL0_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST3_REG_HOST_DISCON_SEL0_MASK) >> USB2PHY_USB2_UTM2_TEST3_REG_HOST_DISCON_SEL0_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST3_REG_HOST_DISCON_SEL0_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST3_REG_HOST_DISCON_SEL0_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST3_REG_HOST_DISCON_SEL0_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_TX_BITSTUFF_EN_MASK 0x10000000
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_TX_BITSTUFF_EN_SHIFT 28
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_TX_BITSTUFF_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST3_REG_TEST_TX_BITSTUFF_EN_MASK) >> USB2PHY_USB2_UTM2_TEST3_REG_TEST_TX_BITSTUFF_EN_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_TX_BITSTUFF_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST3_REG_TEST_TX_BITSTUFF_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST3_REG_TEST_TX_BITSTUFF_EN_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_TERM_SELECT_MASK 0x8000000
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_TERM_SELECT_SHIFT 27
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_TERM_SELECT_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST3_REG_TEST_TERM_SELECT_MASK) >> USB2PHY_USB2_UTM2_TEST3_REG_TEST_TERM_SELECT_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_TERM_SELECT_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST3_REG_TEST_TERM_SELECT_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST3_REG_TEST_TERM_SELECT_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_SUSPENDM_MASK 0x4000000
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_SUSPENDM_SHIFT 26
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_SUSPENDM_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST3_REG_TEST_SUSPENDM_MASK) >> USB2PHY_USB2_UTM2_TEST3_REG_TEST_SUSPENDM_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_SUSPENDM_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST3_REG_TEST_SUSPENDM_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST3_REG_TEST_SUSPENDM_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_RESET_MASK 0x2000000
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_RESET_SHIFT 25
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_RESET_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST3_REG_TEST_RESET_MASK) >> USB2PHY_USB2_UTM2_TEST3_REG_TEST_RESET_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_RESET_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST3_REG_TEST_RESET_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST3_REG_TEST_RESET_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_XCVR_SELECT_MASK 0x1800000
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_XCVR_SELECT_SHIFT 23
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_XCVR_SELECT_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST3_REG_TEST_XCVR_SELECT_MASK) >> USB2PHY_USB2_UTM2_TEST3_REG_TEST_XCVR_SELECT_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_XCVR_SELECT_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST3_REG_TEST_XCVR_SELECT_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST3_REG_TEST_XCVR_SELECT_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_OP_MODE_MASK 0x600000
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_OP_MODE_SHIFT 21
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_OP_MODE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST3_REG_TEST_OP_MODE_MASK) >> USB2PHY_USB2_UTM2_TEST3_REG_TEST_OP_MODE_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_OP_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST3_REG_TEST_OP_MODE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST3_REG_TEST_OP_MODE_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_UTMI_SEL_MASK 0x100000
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_UTMI_SEL_SHIFT 20
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_UTMI_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST3_REG_TEST_UTMI_SEL_MASK) >> USB2PHY_USB2_UTM2_TEST3_REG_TEST_UTMI_SEL_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST3_REG_TEST_UTMI_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST3_REG_TEST_UTMI_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST3_REG_TEST_UTMI_SEL_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE2_MASK 0x80000
#define  USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE2_SHIFT 19
#define  USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE2_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE2_MASK) >> USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE2_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE2_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE2_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE2_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE1_MASK 0x40000
#define  USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE1_SHIFT 18
#define  USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE1_MASK) >> USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE1_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE1_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE_MASK 0x20000
#define  USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE_SHIFT 17
#define  USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE_MASK) >> USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST3_REG_FS_RX_ERROR_MODE_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST3_REG_FORCE_END_EN_MASK 0x10000
#define  USB2PHY_USB2_UTM2_TEST3_REG_FORCE_END_EN_SHIFT 16
#define  USB2PHY_USB2_UTM2_TEST3_REG_FORCE_END_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST3_REG_FORCE_END_EN_MASK) >> USB2PHY_USB2_UTM2_TEST3_REG_FORCE_END_EN_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST3_REG_FORCE_END_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST3_REG_FORCE_END_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST3_REG_FORCE_END_EN_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST3_RESERVED1_MASK 0xe000
#define  USB2PHY_USB2_UTM2_TEST3_RESERVED1_SHIFT 13
#define  USB2PHY_USB2_UTM2_TEST3_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST3_RESERVED1_MASK) >> USB2PHY_USB2_UTM2_TEST3_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST3_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST3_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST3_REG_MON_SEL_MASK 0x1f80
#define  USB2PHY_USB2_UTM2_TEST3_REG_MON_SEL_SHIFT 7
#define  USB2PHY_USB2_UTM2_TEST3_REG_MON_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST3_REG_MON_SEL_MASK) >> USB2PHY_USB2_UTM2_TEST3_REG_MON_SEL_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST3_REG_MON_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST3_REG_MON_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST3_REG_MON_SEL_SHIFT))

#define  USB2PHY_USB2_UTM2_TEST3_RESERVED2_MASK 0x7f
#define  USB2PHY_USB2_UTM2_TEST3_RESERVED2_SHIFT 0
#define  USB2PHY_USB2_UTM2_TEST3_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_TEST3_RESERVED2_MASK) >> USB2PHY_USB2_UTM2_TEST3_RESERVED2_SHIFT)
#define  USB2PHY_USB2_UTM2_TEST3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_TEST3_RESERVED2_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_TEST3_RESERVED2_SHIFT))

//====================================================================
//Register: Reserve Register (RESERVE)
//====================================================================

#define  USB2PHY_USB2_UTM2_RESERVE_RESERVED1_MASK 0xffffffff
#define  USB2PHY_USB2_UTM2_RESERVE_RESERVED1_SHIFT 0
#define  USB2PHY_USB2_UTM2_RESERVE_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_RESERVE_RESERVED1_MASK) >> USB2PHY_USB2_UTM2_RESERVE_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM2_RESERVE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_RESERVE_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_RESERVE_RESERVED1_SHIFT))

//====================================================================
//Register: Addon Register (ADDON)
//====================================================================

#define  USB2PHY_USB2_UTM2_ADDON_PHY_REG_ADDON_MASK 0xffffffff
#define  USB2PHY_USB2_UTM2_ADDON_PHY_REG_ADDON_SHIFT 0
#define  USB2PHY_USB2_UTM2_ADDON_PHY_REG_ADDON_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_ADDON_PHY_REG_ADDON_MASK) >> USB2PHY_USB2_UTM2_ADDON_PHY_REG_ADDON_SHIFT)
#define  USB2PHY_USB2_UTM2_ADDON_PHY_REG_ADDON_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_ADDON_PHY_REG_ADDON_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_ADDON_PHY_REG_ADDON_SHIFT))

//====================================================================
//Register: Monitor Register (MON)
//====================================================================

#define  USB2PHY_USB2_UTM2_MON_RESERVED1_MASK 0xffff0000
#define  USB2PHY_USB2_UTM2_MON_RESERVED1_SHIFT 16
#define  USB2PHY_USB2_UTM2_MON_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_MON_RESERVED1_MASK) >> USB2PHY_USB2_UTM2_MON_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM2_MON_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_MON_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_MON_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM2_MON_USB_MON_MASK 0xffff
#define  USB2PHY_USB2_UTM2_MON_USB_MON_SHIFT 0
#define  USB2PHY_USB2_UTM2_MON_USB_MON_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM2_MON_USB_MON_MASK) >> USB2PHY_USB2_UTM2_MON_USB_MON_SHIFT)
#define  USB2PHY_USB2_UTM2_MON_USB_MON_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM2_MON_USB_MON_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM2_MON_USB_MON_SHIFT))

//====================================================================
//
//Register File: USB UTM (Instance 3 of 3) (USB2PHY_USB2_UTM3)
//
//====================================================================

//====================================================================
//Register: USB Control Register (USB_CTL)
//====================================================================

#define  USB2PHY_USB2_UTM3_USB_CTL_RESERVED1_MASK 0xffffffff
#define  USB2PHY_USB2_UTM3_USB_CTL_RESERVED1_SHIFT 0
#define  USB2PHY_USB2_UTM3_USB_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_USB_CTL_RESERVED1_MASK) >> USB2PHY_USB2_UTM3_USB_CTL_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM3_USB_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_USB_CTL_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_USB_CTL_RESERVED1_SHIFT))

//====================================================================
//Register: TX Channel Control Register (TX)
//====================================================================

#define  USB2PHY_USB2_UTM3_TX_RESERVED1_MASK 0x80000000
#define  USB2PHY_USB2_UTM3_TX_RESERVED1_SHIFT 31
#define  USB2PHY_USB2_UTM3_TX_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TX_RESERVED1_MASK) >> USB2PHY_USB2_UTM3_TX_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM3_TX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TX_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TX_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM3_TX_REG_EXT_FS_RCAL_MASK 0x78000000
#define  USB2PHY_USB2_UTM3_TX_REG_EXT_FS_RCAL_SHIFT 27
#define  USB2PHY_USB2_UTM3_TX_REG_EXT_FS_RCAL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TX_REG_EXT_FS_RCAL_MASK) >> USB2PHY_USB2_UTM3_TX_REG_EXT_FS_RCAL_SHIFT)
#define  USB2PHY_USB2_UTM3_TX_REG_EXT_FS_RCAL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TX_REG_EXT_FS_RCAL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TX_REG_EXT_FS_RCAL_SHIFT))

#define  USB2PHY_USB2_UTM3_TX_REG_EXT_FS_RCAL_EN_MASK 0x4000000
#define  USB2PHY_USB2_UTM3_TX_REG_EXT_FS_RCAL_EN_SHIFT 26
#define  USB2PHY_USB2_UTM3_TX_REG_EXT_FS_RCAL_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TX_REG_EXT_FS_RCAL_EN_MASK) >> USB2PHY_USB2_UTM3_TX_REG_EXT_FS_RCAL_EN_SHIFT)
#define  USB2PHY_USB2_UTM3_TX_REG_EXT_FS_RCAL_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TX_REG_EXT_FS_RCAL_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TX_REG_EXT_FS_RCAL_EN_SHIFT))

#define  USB2PHY_USB2_UTM3_TX_HS_SLEW_RATE_MASK 0x3000000
#define  USB2PHY_USB2_UTM3_TX_HS_SLEW_RATE_SHIFT 24
#define  USB2PHY_USB2_UTM3_TX_HS_SLEW_RATE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TX_HS_SLEW_RATE_MASK) >> USB2PHY_USB2_UTM3_TX_HS_SLEW_RATE_SHIFT)
#define  USB2PHY_USB2_UTM3_TX_HS_SLEW_RATE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TX_HS_SLEW_RATE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TX_HS_SLEW_RATE_SHIFT))

#define  USB2PHY_USB2_UTM3_TX_TXVDDL_MASK 0xc00000
#define  USB2PHY_USB2_UTM3_TX_TXVDDL_SHIFT 22
#define  USB2PHY_USB2_UTM3_TX_TXVDDL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TX_TXVDDL_MASK) >> USB2PHY_USB2_UTM3_TX_TXVDDL_SHIFT)
#define  USB2PHY_USB2_UTM3_TX_TXVDDL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TX_TXVDDL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TX_TXVDDL_SHIFT))

#define  USB2PHY_USB2_UTM3_TX_TXDATA_BLOCK_EN_MASK 0x200000
#define  USB2PHY_USB2_UTM3_TX_TXDATA_BLOCK_EN_SHIFT 21
#define  USB2PHY_USB2_UTM3_TX_TXDATA_BLOCK_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TX_TXDATA_BLOCK_EN_MASK) >> USB2PHY_USB2_UTM3_TX_TXDATA_BLOCK_EN_SHIFT)
#define  USB2PHY_USB2_UTM3_TX_TXDATA_BLOCK_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TX_TXDATA_BLOCK_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TX_TXDATA_BLOCK_EN_SHIFT))

#define  USB2PHY_USB2_UTM3_TX_FSDRV_EN_MASK 0x1e0000
#define  USB2PHY_USB2_UTM3_TX_FSDRV_EN_SHIFT 17
#define  USB2PHY_USB2_UTM3_TX_FSDRV_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TX_FSDRV_EN_MASK) >> USB2PHY_USB2_UTM3_TX_FSDRV_EN_SHIFT)
#define  USB2PHY_USB2_UTM3_TX_FSDRV_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TX_FSDRV_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TX_FSDRV_EN_SHIFT))

#define  USB2PHY_USB2_UTM3_TX_IMPCAL_VTH_MASK 0x1c000
#define  USB2PHY_USB2_UTM3_TX_IMPCAL_VTH_SHIFT 14
#define  USB2PHY_USB2_UTM3_TX_IMPCAL_VTH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TX_IMPCAL_VTH_MASK) >> USB2PHY_USB2_UTM3_TX_IMPCAL_VTH_SHIFT)
#define  USB2PHY_USB2_UTM3_TX_IMPCAL_VTH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TX_IMPCAL_VTH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TX_IMPCAL_VTH_SHIFT))

#define  USB2PHY_USB2_UTM3_TX_REG_EXT_HS_RCAL_EN_MASK 0x2000
#define  USB2PHY_USB2_UTM3_TX_REG_EXT_HS_RCAL_EN_SHIFT 13
#define  USB2PHY_USB2_UTM3_TX_REG_EXT_HS_RCAL_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TX_REG_EXT_HS_RCAL_EN_MASK) >> USB2PHY_USB2_UTM3_TX_REG_EXT_HS_RCAL_EN_SHIFT)
#define  USB2PHY_USB2_UTM3_TX_REG_EXT_HS_RCAL_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TX_REG_EXT_HS_RCAL_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TX_REG_EXT_HS_RCAL_EN_SHIFT))

#define  USB2PHY_USB2_UTM3_TX_REG_RCAL_START_MASK 0x1000
#define  USB2PHY_USB2_UTM3_TX_REG_RCAL_START_SHIFT 12
#define  USB2PHY_USB2_UTM3_TX_REG_RCAL_START_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TX_REG_RCAL_START_MASK) >> USB2PHY_USB2_UTM3_TX_REG_RCAL_START_SHIFT)
#define  USB2PHY_USB2_UTM3_TX_REG_RCAL_START_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TX_REG_RCAL_START_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TX_REG_RCAL_START_SHIFT))

#define  USB2PHY_USB2_UTM3_TX_LOWVDD_EN_MASK 0x800
#define  USB2PHY_USB2_UTM3_TX_LOWVDD_EN_SHIFT 11
#define  USB2PHY_USB2_UTM3_TX_LOWVDD_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TX_LOWVDD_EN_MASK) >> USB2PHY_USB2_UTM3_TX_LOWVDD_EN_SHIFT)
#define  USB2PHY_USB2_UTM3_TX_LOWVDD_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TX_LOWVDD_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TX_LOWVDD_EN_SHIFT))

#define  USB2PHY_USB2_UTM3_TX_HSDRV_EN_MASK 0x780
#define  USB2PHY_USB2_UTM3_TX_HSDRV_EN_SHIFT 7
#define  USB2PHY_USB2_UTM3_TX_HSDRV_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TX_HSDRV_EN_MASK) >> USB2PHY_USB2_UTM3_TX_HSDRV_EN_SHIFT)
#define  USB2PHY_USB2_UTM3_TX_HSDRV_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TX_HSDRV_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TX_HSDRV_EN_SHIFT))

#define  USB2PHY_USB2_UTM3_TX_REG_EXT_HS_RCAL_MASK 0x78
#define  USB2PHY_USB2_UTM3_TX_REG_EXT_HS_RCAL_SHIFT 3
#define  USB2PHY_USB2_UTM3_TX_REG_EXT_HS_RCAL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TX_REG_EXT_HS_RCAL_MASK) >> USB2PHY_USB2_UTM3_TX_REG_EXT_HS_RCAL_SHIFT)
#define  USB2PHY_USB2_UTM3_TX_REG_EXT_HS_RCAL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TX_REG_EXT_HS_RCAL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TX_REG_EXT_HS_RCAL_SHIFT))

#define  USB2PHY_USB2_UTM3_TX_AMP_MASK 0x7
#define  USB2PHY_USB2_UTM3_TX_AMP_SHIFT 0
#define  USB2PHY_USB2_UTM3_TX_AMP_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TX_AMP_MASK) >> USB2PHY_USB2_UTM3_TX_AMP_SHIFT)
#define  USB2PHY_USB2_UTM3_TX_AMP_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TX_AMP_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TX_AMP_SHIFT))

//====================================================================
//Register: RX Channel Control Register 0 (RX0)
//====================================================================

#define  USB2PHY_USB2_UTM3_RX0_EARLY_VOS_ON_EN_MASK 0x80000000
#define  USB2PHY_USB2_UTM3_RX0_EARLY_VOS_ON_EN_SHIFT 31
#define  USB2PHY_USB2_UTM3_RX0_EARLY_VOS_ON_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX0_EARLY_VOS_ON_EN_MASK) >> USB2PHY_USB2_UTM3_RX0_EARLY_VOS_ON_EN_SHIFT)
#define  USB2PHY_USB2_UTM3_RX0_EARLY_VOS_ON_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX0_EARLY_VOS_ON_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX0_EARLY_VOS_ON_EN_SHIFT))

#define  USB2PHY_USB2_UTM3_RX0_RXDATA_BLOCK_EN_MASK 0x40000000
#define  USB2PHY_USB2_UTM3_RX0_RXDATA_BLOCK_EN_SHIFT 30
#define  USB2PHY_USB2_UTM3_RX0_RXDATA_BLOCK_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX0_RXDATA_BLOCK_EN_MASK) >> USB2PHY_USB2_UTM3_RX0_RXDATA_BLOCK_EN_SHIFT)
#define  USB2PHY_USB2_UTM3_RX0_RXDATA_BLOCK_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX0_RXDATA_BLOCK_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX0_RXDATA_BLOCK_EN_SHIFT))

#define  USB2PHY_USB2_UTM3_RX0_RXDATA_BLOCK_LENGTH_MASK 0x30000000
#define  USB2PHY_USB2_UTM3_RX0_RXDATA_BLOCK_LENGTH_SHIFT 28
#define  USB2PHY_USB2_UTM3_RX0_RXDATA_BLOCK_LENGTH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX0_RXDATA_BLOCK_LENGTH_MASK) >> USB2PHY_USB2_UTM3_RX0_RXDATA_BLOCK_LENGTH_SHIFT)
#define  USB2PHY_USB2_UTM3_RX0_RXDATA_BLOCK_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX0_RXDATA_BLOCK_LENGTH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX0_RXDATA_BLOCK_LENGTH_SHIFT))

#define  USB2PHY_USB2_UTM3_RX0_EDGE_DET_SEL_MASK 0xc000000
#define  USB2PHY_USB2_UTM3_RX0_EDGE_DET_SEL_SHIFT 26
#define  USB2PHY_USB2_UTM3_RX0_EDGE_DET_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX0_EDGE_DET_SEL_MASK) >> USB2PHY_USB2_UTM3_RX0_EDGE_DET_SEL_SHIFT)
#define  USB2PHY_USB2_UTM3_RX0_EDGE_DET_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX0_EDGE_DET_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX0_EDGE_DET_SEL_SHIFT))

#define  USB2PHY_USB2_UTM3_RX0_EDGE_DET_EN_MASK 0x2000000
#define  USB2PHY_USB2_UTM3_RX0_EDGE_DET_EN_SHIFT 25
#define  USB2PHY_USB2_UTM3_RX0_EDGE_DET_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX0_EDGE_DET_EN_MASK) >> USB2PHY_USB2_UTM3_RX0_EDGE_DET_EN_SHIFT)
#define  USB2PHY_USB2_UTM3_RX0_EDGE_DET_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX0_EDGE_DET_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX0_EDGE_DET_EN_SHIFT))

#define  USB2PHY_USB2_UTM3_RX0_S2TO3_DLY_SEL_MASK 0x1800000
#define  USB2PHY_USB2_UTM3_RX0_S2TO3_DLY_SEL_SHIFT 23
#define  USB2PHY_USB2_UTM3_RX0_S2TO3_DLY_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX0_S2TO3_DLY_SEL_MASK) >> USB2PHY_USB2_UTM3_RX0_S2TO3_DLY_SEL_SHIFT)
#define  USB2PHY_USB2_UTM3_RX0_S2TO3_DLY_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX0_S2TO3_DLY_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX0_S2TO3_DLY_SEL_SHIFT))

#define  USB2PHY_USB2_UTM3_RX0_CDR_COEF_SEL_MASK 0x400000
#define  USB2PHY_USB2_UTM3_RX0_CDR_COEF_SEL_SHIFT 22
#define  USB2PHY_USB2_UTM3_RX0_CDR_COEF_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX0_CDR_COEF_SEL_MASK) >> USB2PHY_USB2_UTM3_RX0_CDR_COEF_SEL_SHIFT)
#define  USB2PHY_USB2_UTM3_RX0_CDR_COEF_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX0_CDR_COEF_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX0_CDR_COEF_SEL_SHIFT))

#define  USB2PHY_USB2_UTM3_RX0_CDR_FASTLOCK_EN_MASK 0x200000
#define  USB2PHY_USB2_UTM3_RX0_CDR_FASTLOCK_EN_SHIFT 21
#define  USB2PHY_USB2_UTM3_RX0_CDR_FASTLOCK_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX0_CDR_FASTLOCK_EN_MASK) >> USB2PHY_USB2_UTM3_RX0_CDR_FASTLOCK_EN_SHIFT)
#define  USB2PHY_USB2_UTM3_RX0_CDR_FASTLOCK_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX0_CDR_FASTLOCK_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX0_CDR_FASTLOCK_EN_SHIFT))

#define  USB2PHY_USB2_UTM3_RX0_PHASE_FREEZE_DLY_MASK 0x100000
#define  USB2PHY_USB2_UTM3_RX0_PHASE_FREEZE_DLY_SHIFT 20
#define  USB2PHY_USB2_UTM3_RX0_PHASE_FREEZE_DLY_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX0_PHASE_FREEZE_DLY_MASK) >> USB2PHY_USB2_UTM3_RX0_PHASE_FREEZE_DLY_SHIFT)
#define  USB2PHY_USB2_UTM3_RX0_PHASE_FREEZE_DLY_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX0_PHASE_FREEZE_DLY_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX0_PHASE_FREEZE_DLY_SHIFT))

#define  USB2PHY_USB2_UTM3_RX0_REG_USQ_LENGTH_MASK 0x80000
#define  USB2PHY_USB2_UTM3_RX0_REG_USQ_LENGTH_SHIFT 19
#define  USB2PHY_USB2_UTM3_RX0_REG_USQ_LENGTH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX0_REG_USQ_LENGTH_MASK) >> USB2PHY_USB2_UTM3_RX0_REG_USQ_LENGTH_SHIFT)
#define  USB2PHY_USB2_UTM3_RX0_REG_USQ_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX0_REG_USQ_LENGTH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX0_REG_USQ_LENGTH_SHIFT))

#define  USB2PHY_USB2_UTM3_RX0_REG_ACQ_LENGTH_MASK 0x60000
#define  USB2PHY_USB2_UTM3_RX0_REG_ACQ_LENGTH_SHIFT 17
#define  USB2PHY_USB2_UTM3_RX0_REG_ACQ_LENGTH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX0_REG_ACQ_LENGTH_MASK) >> USB2PHY_USB2_UTM3_RX0_REG_ACQ_LENGTH_SHIFT)
#define  USB2PHY_USB2_UTM3_RX0_REG_ACQ_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX0_REG_ACQ_LENGTH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX0_REG_ACQ_LENGTH_SHIFT))

#define  USB2PHY_USB2_UTM3_RX0_REG_SQ_LENGTH_MASK 0x18000
#define  USB2PHY_USB2_UTM3_RX0_REG_SQ_LENGTH_SHIFT 15
#define  USB2PHY_USB2_UTM3_RX0_REG_SQ_LENGTH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX0_REG_SQ_LENGTH_MASK) >> USB2PHY_USB2_UTM3_RX0_REG_SQ_LENGTH_SHIFT)
#define  USB2PHY_USB2_UTM3_RX0_REG_SQ_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX0_REG_SQ_LENGTH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX0_REG_SQ_LENGTH_SHIFT))

#define  USB2PHY_USB2_UTM3_RX0_RESERVED1_MASK 0x6000
#define  USB2PHY_USB2_UTM3_RX0_RESERVED1_SHIFT 13
#define  USB2PHY_USB2_UTM3_RX0_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX0_RESERVED1_MASK) >> USB2PHY_USB2_UTM3_RX0_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM3_RX0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX0_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX0_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM3_RX0_CAP_SEL_MASK 0x1c00
#define  USB2PHY_USB2_UTM3_RX0_CAP_SEL_SHIFT 10
#define  USB2PHY_USB2_UTM3_RX0_CAP_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX0_CAP_SEL_MASK) >> USB2PHY_USB2_UTM3_RX0_CAP_SEL_SHIFT)
#define  USB2PHY_USB2_UTM3_RX0_CAP_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX0_CAP_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX0_CAP_SEL_SHIFT))

#define  USB2PHY_USB2_UTM3_RX0_DISCON_THRESH_MASK 0x300
#define  USB2PHY_USB2_UTM3_RX0_DISCON_THRESH_SHIFT 8
#define  USB2PHY_USB2_UTM3_RX0_DISCON_THRESH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX0_DISCON_THRESH_MASK) >> USB2PHY_USB2_UTM3_RX0_DISCON_THRESH_SHIFT)
#define  USB2PHY_USB2_UTM3_RX0_DISCON_THRESH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX0_DISCON_THRESH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX0_DISCON_THRESH_SHIFT))

#define  USB2PHY_USB2_UTM3_RX0_SQ_THRESH_MASK 0xf0
#define  USB2PHY_USB2_UTM3_RX0_SQ_THRESH_SHIFT 4
#define  USB2PHY_USB2_UTM3_RX0_SQ_THRESH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX0_SQ_THRESH_MASK) >> USB2PHY_USB2_UTM3_RX0_SQ_THRESH_SHIFT)
#define  USB2PHY_USB2_UTM3_RX0_SQ_THRESH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX0_SQ_THRESH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX0_SQ_THRESH_SHIFT))

#define  USB2PHY_USB2_UTM3_RX0_LPF_COEF_MASK 0xc
#define  USB2PHY_USB2_UTM3_RX0_LPF_COEF_SHIFT 2
#define  USB2PHY_USB2_UTM3_RX0_LPF_COEF_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX0_LPF_COEF_MASK) >> USB2PHY_USB2_UTM3_RX0_LPF_COEF_SHIFT)
#define  USB2PHY_USB2_UTM3_RX0_LPF_COEF_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX0_LPF_COEF_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX0_LPF_COEF_SHIFT))

#define  USB2PHY_USB2_UTM3_RX0_INTPI_MASK 0x3
#define  USB2PHY_USB2_UTM3_RX0_INTPI_SHIFT 0
#define  USB2PHY_USB2_UTM3_RX0_INTPI_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX0_INTPI_MASK) >> USB2PHY_USB2_UTM3_RX0_INTPI_SHIFT)
#define  USB2PHY_USB2_UTM3_RX0_INTPI_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX0_INTPI_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX0_INTPI_SHIFT))

//====================================================================
//Register: Receive Channel Control Register 1 (RX1)
//====================================================================

#define  USB2PHY_USB2_UTM3_RX1_RESERVED1_MASK 0xffff0000
#define  USB2PHY_USB2_UTM3_RX1_RESERVED1_SHIFT 16
#define  USB2PHY_USB2_UTM3_RX1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX1_RESERVED1_MASK) >> USB2PHY_USB2_UTM3_RX1_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM3_RX1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX1_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX1_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM3_RX1_PU_PHY_MASK 0x8000
#define  USB2PHY_USB2_UTM3_RX1_PU_PHY_SHIFT 15
#define  USB2PHY_USB2_UTM3_RX1_PU_PHY_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX1_PU_PHY_MASK) >> USB2PHY_USB2_UTM3_RX1_PU_PHY_SHIFT)
#define  USB2PHY_USB2_UTM3_RX1_PU_PHY_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX1_PU_PHY_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX1_PU_PHY_SHIFT))

#define  USB2PHY_USB2_UTM3_RX1_STRESS_TEST_MODE_MASK 0x4000
#define  USB2PHY_USB2_UTM3_RX1_STRESS_TEST_MODE_SHIFT 14
#define  USB2PHY_USB2_UTM3_RX1_STRESS_TEST_MODE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX1_STRESS_TEST_MODE_MASK) >> USB2PHY_USB2_UTM3_RX1_STRESS_TEST_MODE_SHIFT)
#define  USB2PHY_USB2_UTM3_RX1_STRESS_TEST_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX1_STRESS_TEST_MODE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX1_STRESS_TEST_MODE_SHIFT))

#define  USB2PHY_USB2_UTM3_RX1_RESERVED2_MASK 0x2000
#define  USB2PHY_USB2_UTM3_RX1_RESERVED2_SHIFT 13
#define  USB2PHY_USB2_UTM3_RX1_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX1_RESERVED2_MASK) >> USB2PHY_USB2_UTM3_RX1_RESERVED2_SHIFT)
#define  USB2PHY_USB2_UTM3_RX1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX1_RESERVED2_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX1_RESERVED2_SHIFT))

#define  USB2PHY_USB2_UTM3_RX1_TESTMON_MASK 0x1e00
#define  USB2PHY_USB2_UTM3_RX1_TESTMON_SHIFT 9
#define  USB2PHY_USB2_UTM3_RX1_TESTMON_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX1_TESTMON_MASK) >> USB2PHY_USB2_UTM3_RX1_TESTMON_SHIFT)
#define  USB2PHY_USB2_UTM3_RX1_TESTMON_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX1_TESTMON_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX1_TESTMON_SHIFT))

#define  USB2PHY_USB2_UTM3_RX1_USQ_FILTER_MASK 0x100
#define  USB2PHY_USB2_UTM3_RX1_USQ_FILTER_SHIFT 8
#define  USB2PHY_USB2_UTM3_RX1_USQ_FILTER_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX1_USQ_FILTER_MASK) >> USB2PHY_USB2_UTM3_RX1_USQ_FILTER_SHIFT)
#define  USB2PHY_USB2_UTM3_RX1_USQ_FILTER_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX1_USQ_FILTER_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX1_USQ_FILTER_SHIFT))

#define  USB2PHY_USB2_UTM3_RX1_SQ_CM_SEL_MASK 0x80
#define  USB2PHY_USB2_UTM3_RX1_SQ_CM_SEL_SHIFT 7
#define  USB2PHY_USB2_UTM3_RX1_SQ_CM_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX1_SQ_CM_SEL_MASK) >> USB2PHY_USB2_UTM3_RX1_SQ_CM_SEL_SHIFT)
#define  USB2PHY_USB2_UTM3_RX1_SQ_CM_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX1_SQ_CM_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX1_SQ_CM_SEL_SHIFT))

#define  USB2PHY_USB2_UTM3_RX1_SAMPLER_CTRL_MASK 0x40
#define  USB2PHY_USB2_UTM3_RX1_SAMPLER_CTRL_SHIFT 6
#define  USB2PHY_USB2_UTM3_RX1_SAMPLER_CTRL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX1_SAMPLER_CTRL_MASK) >> USB2PHY_USB2_UTM3_RX1_SAMPLER_CTRL_SHIFT)
#define  USB2PHY_USB2_UTM3_RX1_SAMPLER_CTRL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX1_SAMPLER_CTRL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX1_SAMPLER_CTRL_SHIFT))

#define  USB2PHY_USB2_UTM3_RX1_SQ_BUFFER_EN_MASK 0x20
#define  USB2PHY_USB2_UTM3_RX1_SQ_BUFFER_EN_SHIFT 5
#define  USB2PHY_USB2_UTM3_RX1_SQ_BUFFER_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX1_SQ_BUFFER_EN_MASK) >> USB2PHY_USB2_UTM3_RX1_SQ_BUFFER_EN_SHIFT)
#define  USB2PHY_USB2_UTM3_RX1_SQ_BUFFER_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX1_SQ_BUFFER_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX1_SQ_BUFFER_EN_SHIFT))

#define  USB2PHY_USB2_UTM3_RX1_SQ_ALWAYS_ON_MASK 0x10
#define  USB2PHY_USB2_UTM3_RX1_SQ_ALWAYS_ON_SHIFT 4
#define  USB2PHY_USB2_UTM3_RX1_SQ_ALWAYS_ON_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX1_SQ_ALWAYS_ON_MASK) >> USB2PHY_USB2_UTM3_RX1_SQ_ALWAYS_ON_SHIFT)
#define  USB2PHY_USB2_UTM3_RX1_SQ_ALWAYS_ON_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX1_SQ_ALWAYS_ON_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX1_SQ_ALWAYS_ON_SHIFT))

#define  USB2PHY_USB2_UTM3_RX1_RXVDDL_MASK 0xc
#define  USB2PHY_USB2_UTM3_RX1_RXVDDL_SHIFT 2
#define  USB2PHY_USB2_UTM3_RX1_RXVDDL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX1_RXVDDL_MASK) >> USB2PHY_USB2_UTM3_RX1_RXVDDL_SHIFT)
#define  USB2PHY_USB2_UTM3_RX1_RXVDDL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX1_RXVDDL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX1_RXVDDL_SHIFT))

#define  USB2PHY_USB2_UTM3_RX1_RESERVED3_MASK 0x3
#define  USB2PHY_USB2_UTM3_RX1_RESERVED3_SHIFT 0
#define  USB2PHY_USB2_UTM3_RX1_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RX1_RESERVED3_MASK) >> USB2PHY_USB2_UTM3_RX1_RESERVED3_SHIFT)
#define  USB2PHY_USB2_UTM3_RX1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RX1_RESERVED3_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RX1_RESERVED3_SHIFT))

//====================================================================
//Register: PHY IVREF Control Register (IVREF)
//====================================================================

#define  USB2PHY_USB2_UTM3_IVREF_PHY_IVREF_CTL_MASK 0xffffffff
#define  USB2PHY_USB2_UTM3_IVREF_PHY_IVREF_CTL_SHIFT 0
#define  USB2PHY_USB2_UTM3_IVREF_PHY_IVREF_CTL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_IVREF_PHY_IVREF_CTL_MASK) >> USB2PHY_USB2_UTM3_IVREF_PHY_IVREF_CTL_SHIFT)
#define  USB2PHY_USB2_UTM3_IVREF_PHY_IVREF_CTL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_IVREF_PHY_IVREF_CTL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_IVREF_PHY_IVREF_CTL_SHIFT))

//====================================================================
//Register: Test Group0 Register (TEST0)
//====================================================================

#define  USB2PHY_USB2_UTM3_TEST0_REG_FIFO_OV_MASK 0x80000000
#define  USB2PHY_USB2_UTM3_TEST0_REG_FIFO_OV_SHIFT 31
#define  USB2PHY_USB2_UTM3_TEST0_REG_FIFO_OV_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_REG_FIFO_OV_MASK) >> USB2PHY_USB2_UTM3_TEST0_REG_FIFO_OV_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_REG_FIFO_OV_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_REG_FIFO_OV_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_REG_FIFO_OV_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_REG_FIFO_UF_MASK 0x40000000
#define  USB2PHY_USB2_UTM3_TEST0_REG_FIFO_UF_SHIFT 30
#define  USB2PHY_USB2_UTM3_TEST0_REG_FIFO_UF_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_REG_FIFO_UF_MASK) >> USB2PHY_USB2_UTM3_TEST0_REG_FIFO_UF_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_REG_FIFO_UF_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_REG_FIFO_UF_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_REG_FIFO_UF_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_RESERVED1_MASK 0x20000000
#define  USB2PHY_USB2_UTM3_TEST0_RESERVED1_SHIFT 29
#define  USB2PHY_USB2_UTM3_TEST0_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_RESERVED1_MASK) >> USB2PHY_USB2_UTM3_TEST0_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_REG_ARC_DPDM_MODE_MASK 0x10000000
#define  USB2PHY_USB2_UTM3_TEST0_REG_ARC_DPDM_MODE_SHIFT 28
#define  USB2PHY_USB2_UTM3_TEST0_REG_ARC_DPDM_MODE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_REG_ARC_DPDM_MODE_MASK) >> USB2PHY_USB2_UTM3_TEST0_REG_ARC_DPDM_MODE_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_REG_ARC_DPDM_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_REG_ARC_DPDM_MODE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_REG_ARC_DPDM_MODE_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_REG_DP_PULLDOWN_MASK 0x8000000
#define  USB2PHY_USB2_UTM3_TEST0_REG_DP_PULLDOWN_SHIFT 27
#define  USB2PHY_USB2_UTM3_TEST0_REG_DP_PULLDOWN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_REG_DP_PULLDOWN_MASK) >> USB2PHY_USB2_UTM3_TEST0_REG_DP_PULLDOWN_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_REG_DP_PULLDOWN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_REG_DP_PULLDOWN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_REG_DP_PULLDOWN_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_REG_DM_PULLDOWN_MASK 0x4000000
#define  USB2PHY_USB2_UTM3_TEST0_REG_DM_PULLDOWN_SHIFT 26
#define  USB2PHY_USB2_UTM3_TEST0_REG_DM_PULLDOWN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_REG_DM_PULLDOWN_MASK) >> USB2PHY_USB2_UTM3_TEST0_REG_DM_PULLDOWN_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_REG_DM_PULLDOWN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_REG_DM_PULLDOWN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_REG_DM_PULLDOWN_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_RESERVED2_MASK 0x2000000
#define  USB2PHY_USB2_UTM3_TEST0_RESERVED2_SHIFT 25
#define  USB2PHY_USB2_UTM3_TEST0_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_RESERVED2_MASK) >> USB2PHY_USB2_UTM3_TEST0_RESERVED2_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_RESERVED2_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_RESERVED2_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_REG_FIFO_FILL_NUM_MASK 0x1e00000
#define  USB2PHY_USB2_UTM3_TEST0_REG_FIFO_FILL_NUM_SHIFT 21
#define  USB2PHY_USB2_UTM3_TEST0_REG_FIFO_FILL_NUM_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_REG_FIFO_FILL_NUM_MASK) >> USB2PHY_USB2_UTM3_TEST0_REG_FIFO_FILL_NUM_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_REG_FIFO_FILL_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_REG_FIFO_FILL_NUM_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_REG_FIFO_FILL_NUM_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_REG_SQ_SYNC_SEL_MASK 0x100000
#define  USB2PHY_USB2_UTM3_TEST0_REG_SQ_SYNC_SEL_SHIFT 20
#define  USB2PHY_USB2_UTM3_TEST0_REG_SQ_SYNC_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_REG_SQ_SYNC_SEL_MASK) >> USB2PHY_USB2_UTM3_TEST0_REG_SQ_SYNC_SEL_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_REG_SQ_SYNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_REG_SQ_SYNC_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_REG_SQ_SYNC_SEL_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_REG_ALIGN_FS_OUTEN_MASK 0x80000
#define  USB2PHY_USB2_UTM3_TEST0_REG_ALIGN_FS_OUTEN_SHIFT 19
#define  USB2PHY_USB2_UTM3_TEST0_REG_ALIGN_FS_OUTEN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_REG_ALIGN_FS_OUTEN_MASK) >> USB2PHY_USB2_UTM3_TEST0_REG_ALIGN_FS_OUTEN_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_REG_ALIGN_FS_OUTEN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_REG_ALIGN_FS_OUTEN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_REG_ALIGN_FS_OUTEN_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_RESERVED3_MASK 0x40000
#define  USB2PHY_USB2_UTM3_TEST0_RESERVED3_SHIFT 18
#define  USB2PHY_USB2_UTM3_TEST0_RESERVED3_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_RESERVED3_MASK) >> USB2PHY_USB2_UTM3_TEST0_RESERVED3_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_RESERVED3_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_RESERVED3_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_REG_LONG_EOP_MASK 0x20000
#define  USB2PHY_USB2_UTM3_TEST0_REG_LONG_EOP_SHIFT 17
#define  USB2PHY_USB2_UTM3_TEST0_REG_LONG_EOP_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_REG_LONG_EOP_MASK) >> USB2PHY_USB2_UTM3_TEST0_REG_LONG_EOP_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_REG_LONG_EOP_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_REG_LONG_EOP_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_REG_LONG_EOP_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_REG_PLL_LOCK_BYPASS_MASK 0x10000
#define  USB2PHY_USB2_UTM3_TEST0_REG_PLL_LOCK_BYPASS_SHIFT 16
#define  USB2PHY_USB2_UTM3_TEST0_REG_PLL_LOCK_BYPASS_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_REG_PLL_LOCK_BYPASS_MASK) >> USB2PHY_USB2_UTM3_TEST0_REG_PLL_LOCK_BYPASS_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_REG_PLL_LOCK_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_REG_PLL_LOCK_BYPASS_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_REG_PLL_LOCK_BYPASS_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_REG_FIFO_SQ_RST_MASK 0x8000
#define  USB2PHY_USB2_UTM3_TEST0_REG_FIFO_SQ_RST_SHIFT 15
#define  USB2PHY_USB2_UTM3_TEST0_REG_FIFO_SQ_RST_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_REG_FIFO_SQ_RST_MASK) >> USB2PHY_USB2_UTM3_TEST0_REG_FIFO_SQ_RST_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_REG_FIFO_SQ_RST_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_REG_FIFO_SQ_RST_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_REG_FIFO_SQ_RST_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_REG_CLK_SUSPEND_EN_MASK 0x4000
#define  USB2PHY_USB2_UTM3_TEST0_REG_CLK_SUSPEND_EN_SHIFT 14
#define  USB2PHY_USB2_UTM3_TEST0_REG_CLK_SUSPEND_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_REG_CLK_SUSPEND_EN_MASK) >> USB2PHY_USB2_UTM3_TEST0_REG_CLK_SUSPEND_EN_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_REG_CLK_SUSPEND_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_REG_CLK_SUSPEND_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_REG_CLK_SUSPEND_EN_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_REG_EARLY_TX_ENABLE_MASK 0x2000
#define  USB2PHY_USB2_UTM3_TEST0_REG_EARLY_TX_ENABLE_SHIFT 13
#define  USB2PHY_USB2_UTM3_TEST0_REG_EARLY_TX_ENABLE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_REG_EARLY_TX_ENABLE_MASK) >> USB2PHY_USB2_UTM3_TEST0_REG_EARLY_TX_ENABLE_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_REG_EARLY_TX_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_REG_EARLY_TX_ENABLE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_REG_EARLY_TX_ENABLE_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_REG_OVUF_RST_EN_MASK 0x1000
#define  USB2PHY_USB2_UTM3_TEST0_REG_OVUF_RST_EN_SHIFT 12
#define  USB2PHY_USB2_UTM3_TEST0_REG_OVUF_RST_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_REG_OVUF_RST_EN_MASK) >> USB2PHY_USB2_UTM3_TEST0_REG_OVUF_RST_EN_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_REG_OVUF_RST_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_REG_OVUF_RST_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_REG_OVUF_RST_EN_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_REG_EOP_RST_EN_MASK 0x800
#define  USB2PHY_USB2_UTM3_TEST0_REG_EOP_RST_EN_SHIFT 11
#define  USB2PHY_USB2_UTM3_TEST0_REG_EOP_RST_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_REG_EOP_RST_EN_MASK) >> USB2PHY_USB2_UTM3_TEST0_REG_EOP_RST_EN_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_REG_EOP_RST_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_REG_EOP_RST_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_REG_EOP_RST_EN_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_REG_SYNC_NUM_MASK 0x600
#define  USB2PHY_USB2_UTM3_TEST0_REG_SYNC_NUM_SHIFT 9
#define  USB2PHY_USB2_UTM3_TEST0_REG_SYNC_NUM_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_REG_SYNC_NUM_MASK) >> USB2PHY_USB2_UTM3_TEST0_REG_SYNC_NUM_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_REG_SYNC_NUM_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_REG_SYNC_NUM_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_REG_SYNC_NUM_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_REG_NOVBUS_DPDM00_MASK 0x100
#define  USB2PHY_USB2_UTM3_TEST0_REG_NOVBUS_DPDM00_SHIFT 8
#define  USB2PHY_USB2_UTM3_TEST0_REG_NOVBUS_DPDM00_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_REG_NOVBUS_DPDM00_MASK) >> USB2PHY_USB2_UTM3_TEST0_REG_NOVBUS_DPDM00_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_REG_NOVBUS_DPDM00_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_REG_NOVBUS_DPDM00_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_REG_NOVBUS_DPDM00_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST0_RESERVED4_MASK 0xff
#define  USB2PHY_USB2_UTM3_TEST0_RESERVED4_SHIFT 0
#define  USB2PHY_USB2_UTM3_TEST0_RESERVED4_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST0_RESERVED4_MASK) >> USB2PHY_USB2_UTM3_TEST0_RESERVED4_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST0_RESERVED4_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST0_RESERVED4_SHIFT))

//====================================================================
//Register: Test Group1 Register (TEST1)
//====================================================================

#define  USB2PHY_USB2_UTM3_TEST1_REG_HS_HDL_SYNC_MASK 0x80000000
#define  USB2PHY_USB2_UTM3_TEST1_REG_HS_HDL_SYNC_SHIFT 31
#define  USB2PHY_USB2_UTM3_TEST1_REG_HS_HDL_SYNC_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST1_REG_HS_HDL_SYNC_MASK) >> USB2PHY_USB2_UTM3_TEST1_REG_HS_HDL_SYNC_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST1_REG_HS_HDL_SYNC_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST1_REG_HS_HDL_SYNC_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST1_REG_HS_HDL_SYNC_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST1_REG_FS_HDL_OPMD_MASK 0x40000000
#define  USB2PHY_USB2_UTM3_TEST1_REG_FS_HDL_OPMD_SHIFT 30
#define  USB2PHY_USB2_UTM3_TEST1_REG_FS_HDL_OPMD_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST1_REG_FS_HDL_OPMD_MASK) >> USB2PHY_USB2_UTM3_TEST1_REG_FS_HDL_OPMD_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST1_REG_FS_HDL_OPMD_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST1_REG_FS_HDL_OPMD_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST1_REG_FS_HDL_OPMD_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST1_RESERVED1_MASK 0x3fc00000
#define  USB2PHY_USB2_UTM3_TEST1_RESERVED1_SHIFT 22
#define  USB2PHY_USB2_UTM3_TEST1_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST1_RESERVED1_MASK) >> USB2PHY_USB2_UTM3_TEST1_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST1_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST1_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST1_RESERVED2_MASK 0x200000
#define  USB2PHY_USB2_UTM3_TEST1_RESERVED2_SHIFT 21
#define  USB2PHY_USB2_UTM3_TEST1_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST1_RESERVED2_MASK) >> USB2PHY_USB2_UTM3_TEST1_RESERVED2_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST1_RESERVED2_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST1_RESERVED2_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_DIG_LPBK_MASK 0x100000
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_DIG_LPBK_SHIFT 20
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_DIG_LPBK_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST1_REG_TEST_DIG_LPBK_MASK) >> USB2PHY_USB2_UTM3_TEST1_REG_TEST_DIG_LPBK_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_DIG_LPBK_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST1_REG_TEST_DIG_LPBK_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST1_REG_TEST_DIG_LPBK_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_SKIP_MASK 0xe0000
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_SKIP_SHIFT 17
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_SKIP_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST1_REG_TEST_SKIP_MASK) >> USB2PHY_USB2_UTM3_TEST1_REG_TEST_SKIP_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_SKIP_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST1_REG_TEST_SKIP_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST1_REG_TEST_SKIP_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_FLAG_MASK 0x10000
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_FLAG_SHIFT 16
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_FLAG_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST1_REG_TEST_FLAG_MASK) >> USB2PHY_USB2_UTM3_TEST1_REG_TEST_FLAG_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_FLAG_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST1_REG_TEST_FLAG_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST1_REG_TEST_FLAG_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_DONE_MASK 0x8000
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_DONE_SHIFT 15
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_DONE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST1_REG_TEST_DONE_MASK) >> USB2PHY_USB2_UTM3_TEST1_REG_TEST_DONE_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_DONE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST1_REG_TEST_DONE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST1_REG_TEST_DONE_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_LENGTH_MASK 0x6000
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_LENGTH_SHIFT 13
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_LENGTH_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST1_REG_TEST_LENGTH_MASK) >> USB2PHY_USB2_UTM3_TEST1_REG_TEST_LENGTH_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST1_REG_TEST_LENGTH_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST1_REG_TEST_LENGTH_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_TX_PATTERN_MASK 0x1fe0
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_TX_PATTERN_SHIFT 5
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_TX_PATTERN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST1_REG_TEST_TX_PATTERN_MASK) >> USB2PHY_USB2_UTM3_TEST1_REG_TEST_TX_PATTERN_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_TX_PATTERN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST1_REG_TEST_TX_PATTERN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST1_REG_TEST_TX_PATTERN_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_MODE_MASK 0x18
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_MODE_SHIFT 3
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_MODE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST1_REG_TEST_MODE_MASK) >> USB2PHY_USB2_UTM3_TEST1_REG_TEST_MODE_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST1_REG_TEST_MODE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST1_REG_TEST_MODE_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_LPBK_EN_MASK 0x4
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_LPBK_EN_SHIFT 2
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_LPBK_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST1_REG_TEST_LPBK_EN_MASK) >> USB2PHY_USB2_UTM3_TEST1_REG_TEST_LPBK_EN_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_LPBK_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST1_REG_TEST_LPBK_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST1_REG_TEST_LPBK_EN_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_BYPASS_MASK 0x2
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_BYPASS_SHIFT 1
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_BYPASS_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST1_REG_TEST_BYPASS_MASK) >> USB2PHY_USB2_UTM3_TEST1_REG_TEST_BYPASS_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST1_REG_TEST_BYPASS_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST1_REG_TEST_BYPASS_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_EN_MASK 0x1
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_EN_SHIFT 0
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST1_REG_TEST_EN_MASK) >> USB2PHY_USB2_UTM3_TEST1_REG_TEST_EN_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST1_REG_TEST_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST1_REG_TEST_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST1_REG_TEST_EN_SHIFT))

//====================================================================
//Register: Test Group2 Register (TEST2)
//====================================================================

#define  USB2PHY_USB2_UTM3_TEST2_RESERVED1_MASK 0xffffffff
#define  USB2PHY_USB2_UTM3_TEST2_RESERVED1_SHIFT 0
#define  USB2PHY_USB2_UTM3_TEST2_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST2_RESERVED1_MASK) >> USB2PHY_USB2_UTM3_TEST2_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST2_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST2_RESERVED1_SHIFT))

//====================================================================
//Register: Test Group3 Register (TEST3)
//====================================================================

#define  USB2PHY_USB2_UTM3_TEST3_REG_FS_EOP_MODE_MASK 0x80000000
#define  USB2PHY_USB2_UTM3_TEST3_REG_FS_EOP_MODE_SHIFT 31
#define  USB2PHY_USB2_UTM3_TEST3_REG_FS_EOP_MODE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST3_REG_FS_EOP_MODE_MASK) >> USB2PHY_USB2_UTM3_TEST3_REG_FS_EOP_MODE_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST3_REG_FS_EOP_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST3_REG_FS_EOP_MODE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST3_REG_FS_EOP_MODE_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST3_REG_HOST_DISCON_SEL1_MASK 0x40000000
#define  USB2PHY_USB2_UTM3_TEST3_REG_HOST_DISCON_SEL1_SHIFT 30
#define  USB2PHY_USB2_UTM3_TEST3_REG_HOST_DISCON_SEL1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST3_REG_HOST_DISCON_SEL1_MASK) >> USB2PHY_USB2_UTM3_TEST3_REG_HOST_DISCON_SEL1_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST3_REG_HOST_DISCON_SEL1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST3_REG_HOST_DISCON_SEL1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST3_REG_HOST_DISCON_SEL1_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST3_REG_HOST_DISCON_SEL0_MASK 0x20000000
#define  USB2PHY_USB2_UTM3_TEST3_REG_HOST_DISCON_SEL0_SHIFT 29
#define  USB2PHY_USB2_UTM3_TEST3_REG_HOST_DISCON_SEL0_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST3_REG_HOST_DISCON_SEL0_MASK) >> USB2PHY_USB2_UTM3_TEST3_REG_HOST_DISCON_SEL0_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST3_REG_HOST_DISCON_SEL0_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST3_REG_HOST_DISCON_SEL0_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST3_REG_HOST_DISCON_SEL0_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_TX_BITSTUFF_EN_MASK 0x10000000
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_TX_BITSTUFF_EN_SHIFT 28
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_TX_BITSTUFF_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST3_REG_TEST_TX_BITSTUFF_EN_MASK) >> USB2PHY_USB2_UTM3_TEST3_REG_TEST_TX_BITSTUFF_EN_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_TX_BITSTUFF_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST3_REG_TEST_TX_BITSTUFF_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST3_REG_TEST_TX_BITSTUFF_EN_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_TERM_SELECT_MASK 0x8000000
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_TERM_SELECT_SHIFT 27
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_TERM_SELECT_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST3_REG_TEST_TERM_SELECT_MASK) >> USB2PHY_USB2_UTM3_TEST3_REG_TEST_TERM_SELECT_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_TERM_SELECT_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST3_REG_TEST_TERM_SELECT_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST3_REG_TEST_TERM_SELECT_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_SUSPENDM_MASK 0x4000000
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_SUSPENDM_SHIFT 26
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_SUSPENDM_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST3_REG_TEST_SUSPENDM_MASK) >> USB2PHY_USB2_UTM3_TEST3_REG_TEST_SUSPENDM_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_SUSPENDM_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST3_REG_TEST_SUSPENDM_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST3_REG_TEST_SUSPENDM_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_RESET_MASK 0x2000000
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_RESET_SHIFT 25
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_RESET_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST3_REG_TEST_RESET_MASK) >> USB2PHY_USB2_UTM3_TEST3_REG_TEST_RESET_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_RESET_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST3_REG_TEST_RESET_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST3_REG_TEST_RESET_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_XCVR_SELECT_MASK 0x1800000
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_XCVR_SELECT_SHIFT 23
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_XCVR_SELECT_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST3_REG_TEST_XCVR_SELECT_MASK) >> USB2PHY_USB2_UTM3_TEST3_REG_TEST_XCVR_SELECT_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_XCVR_SELECT_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST3_REG_TEST_XCVR_SELECT_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST3_REG_TEST_XCVR_SELECT_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_OP_MODE_MASK 0x600000
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_OP_MODE_SHIFT 21
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_OP_MODE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST3_REG_TEST_OP_MODE_MASK) >> USB2PHY_USB2_UTM3_TEST3_REG_TEST_OP_MODE_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_OP_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST3_REG_TEST_OP_MODE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST3_REG_TEST_OP_MODE_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_UTMI_SEL_MASK 0x100000
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_UTMI_SEL_SHIFT 20
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_UTMI_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST3_REG_TEST_UTMI_SEL_MASK) >> USB2PHY_USB2_UTM3_TEST3_REG_TEST_UTMI_SEL_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST3_REG_TEST_UTMI_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST3_REG_TEST_UTMI_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST3_REG_TEST_UTMI_SEL_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE2_MASK 0x80000
#define  USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE2_SHIFT 19
#define  USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE2_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE2_MASK) >> USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE2_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE2_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE2_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE2_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE1_MASK 0x40000
#define  USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE1_SHIFT 18
#define  USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE1_MASK) >> USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE1_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE1_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE_MASK 0x20000
#define  USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE_SHIFT 17
#define  USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE_MASK) >> USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST3_REG_FS_RX_ERROR_MODE_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST3_REG_FORCE_END_EN_MASK 0x10000
#define  USB2PHY_USB2_UTM3_TEST3_REG_FORCE_END_EN_SHIFT 16
#define  USB2PHY_USB2_UTM3_TEST3_REG_FORCE_END_EN_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST3_REG_FORCE_END_EN_MASK) >> USB2PHY_USB2_UTM3_TEST3_REG_FORCE_END_EN_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST3_REG_FORCE_END_EN_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST3_REG_FORCE_END_EN_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST3_REG_FORCE_END_EN_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST3_RESERVED1_MASK 0xe000
#define  USB2PHY_USB2_UTM3_TEST3_RESERVED1_SHIFT 13
#define  USB2PHY_USB2_UTM3_TEST3_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST3_RESERVED1_MASK) >> USB2PHY_USB2_UTM3_TEST3_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST3_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST3_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST3_REG_MON_SEL_MASK 0x1f80
#define  USB2PHY_USB2_UTM3_TEST3_REG_MON_SEL_SHIFT 7
#define  USB2PHY_USB2_UTM3_TEST3_REG_MON_SEL_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST3_REG_MON_SEL_MASK) >> USB2PHY_USB2_UTM3_TEST3_REG_MON_SEL_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST3_REG_MON_SEL_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST3_REG_MON_SEL_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST3_REG_MON_SEL_SHIFT))

#define  USB2PHY_USB2_UTM3_TEST3_RESERVED2_MASK 0x7f
#define  USB2PHY_USB2_UTM3_TEST3_RESERVED2_SHIFT 0
#define  USB2PHY_USB2_UTM3_TEST3_RESERVED2_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_TEST3_RESERVED2_MASK) >> USB2PHY_USB2_UTM3_TEST3_RESERVED2_SHIFT)
#define  USB2PHY_USB2_UTM3_TEST3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_TEST3_RESERVED2_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_TEST3_RESERVED2_SHIFT))

//====================================================================
//Register: Reserve Register (RESERVE)
//====================================================================

#define  USB2PHY_USB2_UTM3_RESERVE_RESERVED1_MASK 0xffffffff
#define  USB2PHY_USB2_UTM3_RESERVE_RESERVED1_SHIFT 0
#define  USB2PHY_USB2_UTM3_RESERVE_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_RESERVE_RESERVED1_MASK) >> USB2PHY_USB2_UTM3_RESERVE_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM3_RESERVE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_RESERVE_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_RESERVE_RESERVED1_SHIFT))

//====================================================================
//Register: Addon Register (ADDON)
//====================================================================

#define  USB2PHY_USB2_UTM3_ADDON_PHY_REG_ADDON_MASK 0xffffffff
#define  USB2PHY_USB2_UTM3_ADDON_PHY_REG_ADDON_SHIFT 0
#define  USB2PHY_USB2_UTM3_ADDON_PHY_REG_ADDON_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_ADDON_PHY_REG_ADDON_MASK) >> USB2PHY_USB2_UTM3_ADDON_PHY_REG_ADDON_SHIFT)
#define  USB2PHY_USB2_UTM3_ADDON_PHY_REG_ADDON_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_ADDON_PHY_REG_ADDON_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_ADDON_PHY_REG_ADDON_SHIFT))

//====================================================================
//Register: Monitor Register (MON)
//====================================================================

#define  USB2PHY_USB2_UTM3_MON_RESERVED1_MASK 0xffff0000
#define  USB2PHY_USB2_UTM3_MON_RESERVED1_SHIFT 16
#define  USB2PHY_USB2_UTM3_MON_RESERVED1_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_MON_RESERVED1_MASK) >> USB2PHY_USB2_UTM3_MON_RESERVED1_SHIFT)
#define  USB2PHY_USB2_UTM3_MON_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_MON_RESERVED1_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_MON_RESERVED1_SHIFT))

#define  USB2PHY_USB2_UTM3_MON_USB_MON_MASK 0xffff
#define  USB2PHY_USB2_UTM3_MON_USB_MON_SHIFT 0
#define  USB2PHY_USB2_UTM3_MON_USB_MON_MASK_SHIFT(reg) (((reg) & USB2PHY_USB2_UTM3_MON_USB_MON_MASK) >> USB2PHY_USB2_UTM3_MON_USB_MON_SHIFT)
#define  USB2PHY_USB2_UTM3_MON_USB_MON_REPLACE_VAL(reg,val) (((reg) & ~USB2PHY_USB2_UTM3_MON_USB_MON_MASK) | (((uint32_t)val) << USB2PHY_USB2_UTM3_MON_USB_MON_SHIFT))

#endif // USB2TOP
