/*
 * (C) Copyright 2011
 * Marvell Semiconductors Ltd. <www.marvell.com>
 * Jason Chagas <jason.chagas@marvell.com>
 * Lei Wen <leiwen@marvell.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * NOTE: Stack isn't setup yet when these subroutines are called.
 * So we donot push the registers onto Stack during entry.
 */


.ltorg

.globl lowlevel_init
	.type   lowlevel_init, %function
lowlevel_init:
	@ Save link register in r3
	mov	r3, lr

	mrrc	p15, 1, r0, r1, c15	@ Read CPUECTRL register
	orr	r0, r0, #(1<<6)         @ Turn on SMP
	mcrr	p15, 1, r0, r1, c15	@ Write CPUECTRL register

	mov	pc, r3			@ return
