/***** -*- C -*- **************************************
 * $Id$
 *
 * Copyright (C) 2015 Ricoh Company, Ltd.  All Rights Reserved.
 *	 ORDER			 : 
 *	 PROGRAM NAME	 : 
 *	 FILE NAME		 : svinput.h
 *	 VERSION		 : $Revision$
 *	 DESIGNER		 : Hideaki Yamamoto
 *	 AUTHOR 		 : $Author$
 ******************************************************/
#ifndef _SVINPUT_H_
#define _SVINPUT_H_

#include <stddef.h>
#include <linux/ctype.h>
#include <linux/kernel.h>

/*----------------------------------------
 * Debug Macros
 *----------------------------------------*/
#define FORCE_DPRINTK(fmt, ...) { printk( fmt,  ##__VA_ARGS__ ); }

#define SVINPUT_DEBUG
#ifdef SVINPUT_DEBUG
	#define DPRINTK(fmt, args...) FORCE_DPRINTK("[svinput]%s: " fmt, __FUNCTION__ , ## args)
//	#define FUNC_START	  FORCE_DPRINTK("[svinput]%s start\n",__FUNCTION__)
//	#define FUNC_END	  FORCE_DPRINTK("[svinput]%s end\n",__FUNCTION__)
	#define FUNC_START				do {} while(0)
	#define FUNC_END				do {} while(0)
	#define FUNC_ERR	  FORCE_DPRINTK(KERN_ERR"%s::%d::%s err= %d \n", __FILE__, __LINE__, __FUNCTION__, err)
#else /* SVINPUT_DEBUG */
	#define DPRINTK(fmt, args...)	do {} while(0)
	#define FUNC_START				do {} while(0)
	#define FUNC_END				do {} while(0)
	#define FUNC_ERR				do {} while(0)
#endif/* SVINPUT_DEBUG */

#define VT100_PRE		"\033[38;5;"
#define VT100_ULPRE		"\033[4;38;5;"
#define VT100_POST		"m"
#define VT100_COLOR(num)	VT100_PRE #num VT100_POST
#define VT100_COLOR_UL(num)	VT100_ULPRE #num VT100_POST
#define VT100_NORM		"\033[m"        /* normal */
#define VT100_BOLD		"\033[1m"       /* bold */
#define VT100_RED		"\033[1;31m"    /* Red */
#define VT100_GREEN		"\033[1;32m"    /* Green */
#define VT100_YELLOW	"\033[1;33m"    /* Yellow */
#define VT100_BLUE		"\033[1;34m"    /* Blue */
#define VT100_PURPLE	"\033[1;35m"    /* Purple */
#define VT100_RICHBLUE		VT100_COLOR(33)
#define VT100_ULRICHBLUE	VT100_COLOR_UL(33)
#define VT100_CRIMSON		VT100_COLOR(161)
#define VT100_CHOCOLATE		VT100_COLOR(166)
#define VT100_GOLD			VT100_COLOR(178)
#define VT100_ULGOLD		VT100_COLOR_UL(178)
#define VT100_GRAY			VT100_COLOR(247)
#define VT100_ULGRAY		VT100_COLOR_UL(247)
#define VT100_ULGREEN		VT100_COLOR_UL(2)

#define SVINPUT_NAME "ricoh_mfp_input"
#define SVINPUT_DEVICE_NAME "integrated_input_dev"

#define TWSI_BASE_ADDR (0xd4011000)
#define TWSI_REMAP_SIZE (0x00000030)
#define OFFSET_TWSI_ILCR (0x00000028)
#define OFFSET_TWSI_ICR_ADDR (0x00000010)
#define OFFSET_TWSI_IWCR_ADDR (0x00000030)
#define ILCR_FLV_VAL (0x1d << 9)
#define ICR_SDA_GFE_VAL (0x1 << 30)
#define ICR_GPIO_EN_VAL (0x1 << 19)
#define ICR_MODE_VAL (0x1 << 15)
#define IWCR_COUNT_VAL (0x1a)

#define SVINPUT_I2C_CHANNEL (0)
#define SVINPUT_I2C_OPU_WR_ADDR (0x10)
#define SVINPUT_I2C_OPU_RD_ADDR (0x11)
#define SVINPUT_MAJOR_NUM (230)
#define SVINPUT_OPEREQ_GPIO_NO (151)
#define SVINPUT_OPEREQ_GPIO_NAME "SVINPUT_OPEREQ_GPIO"
#define SVINPUT_WQUEUE_NAME "SVINPUT_WQUEUE"
#define SVINPUT_MTRIG_OUT_GPIO_NO (154)
#define SVINPUT_MTRIG_IN_GPIO_NO (155)
#define SVINPUT_MTRIG_IN_GPIO_NAME "SV_MTRIG_GPIO"
#define SVINPUT_233_MAIN_GPIO_NO (156)
#define SVINPUT_233_SUB_GPIO_NO (13)
#define SVINPUT_SCR_REBOOT_GPIO_NO (18)
#define SVINPUT_SCR_REBOOT_GPIO_NAME "SVINPUT_SCR_REBOOT_GPIO"

#define SVINPUT_CNV_INIT_RETRY_MAX (50)
#define SVINPUT_CNV_INIT_MTRIG_LO_TIME (60)
#define SVINPUT_CNV_MTRIG_SUPER_WAIT_TIME (10)
#define SVINPUT_CNV_INIT_WAIT_TIME (100)
#define SVINPUT_CNV_WR_ADDR (0x16)
#define SVINPUT_CNV_RD_ADDR (0x17)
#define SVINPUT_CNV_DEVNAME "SV_CNV_DEVICE"
#define SVINPUT_CNV_DEVID_REG_ADDR (0x04)
#define SVINPUT_CNV_SCLWH_REG_ADDR (0x8c)
#define SVINPUT_CNV_SCLWL_REG_ADDR (0x8d)
#define SVINPUT_CNV_SCLWH_REG_VAL (0x0f)
#define SVINPUT_CNV_SCLWL_REG_VAL (0x0f)
#define SVINPUT_CNV_GPIO_REG_ADDR (0xc1)
#define SVINPUT_CNV_GPIO_REG_ADDR2 (0xc3)
#define SVINPUT_CNV_GPIOINT_REG_ADDR (0xc5)
#define SVINPUT_CNV_MASINT_REG_ADDR (0x03)
#define SVINPUT_CNV_SLVINT_REG_ADDR (0x83)

#define SVINPUT_CNV_GPIOINT_REG_VAL (0x04)
#define SVINPUT_CNV_MASINT_REG_VAL (0x10)
#define SVINPUT_CNV_SLVINT_REG_VAL (0x08)

#define SVINPUT_CNV_OPEREADY_WAIT_CNT (100)
#define SVINPUT_CNV_INIT_FREQSET_RETRY_WAIT_TIME (100)

#define SVINPUT_INIT_MTRIG_SUPER_LO_TIME (510)
#define SVINPUT_INIT_MTRIG_SUPER_HI_TIME (260)
#define SVINPUT_INIT_MTRIG_SUPER_LO_TIME2 (60)
#define SVINPUT_INIT_MTRIG_SUPER_HI_TIME2 (360)

#define I2C_SEND_BUF_SIZE (16)
#define I2C_RECV_BUF_SIZE (32)
#define I2C_ACK_BUF_SIZE (3)

#define ST1 (0xf0)
#define ST2 (0xf1)
#define PAK (0xf7)
#define PNK (0xf8)

#define EVT_TPANEL (0x60)
#define EVT_KEY (0x30)
#define EVT_TPANEL_CALIB_REQ (0x62)
#define EVT_TPANEL_CALIB_RET (0x64)
#define EVT_HEART_BEAT (0x90)
#define EVT_BUZ_END (0x25)

#define GPIO_REG_BASE (0xd4019000)
#define GPIO_REG_SIZE (0x00001000)
#define GPIOD_PLR_REG_OFFSET (0x00000300)
#define GPIOD_EDR_REG_OFFSET (0x00000318)
#define GPIOD_FER_REG_OFFSET (0x00000314)
#define GPIOE_EDR_REG_OFFSET (0x00000418)
#define GPIOG_EDR_REG_OFFSET (0x00000618)
#define GPIOG_FER_REG_OFFSET (0x00000614)

#define SVINPUT_234_REG_POLLING_INTERVAL (30)
#define SVINPUT_234_REG_POLLING_MAX (50)

#define SVINPUT_OPEINIT_REASON_BOOT 0x01
#define SVINPUT_OPEINIT_REASON_LWPW 0x02

#define FAKE_MTRIG 99

/* Input device driver private data */
typedef struct svinput_priv {
	struct i2c_client *opu_client;
	struct i2c_client *cnv_client;
	int opereq_irq;
	int mtrig_irq;
	int scr_reboot_irq;
	void __iomem *gpio_base;

	/* POSCH_INITの計算値を保持 */
	int xpos;				   /* x座標計算結果 */
	int ypos;				   /* y座標計算結果 */

	int svinput_major;
	struct class *svinput_class;
} svinput_priv_t;

/* Workqueue for touch panel & keyboard */
typedef struct workqueue_struct workqueue_struct_t;
typedef struct work_struct work_struct_t;
typedef struct svinput_work {
	work_struct_t svinput_work;
	svinput_priv_t *priv;
	int touch_cnt;
	int kbd_cnt;
} svinput_work_t;

/* Work for power mtrig */
typedef struct power_mtrig_work {
	work_struct_t power_mtrig_work;
} power_mtrig_work_t;

/* Work for power opereq */
typedef struct power_opereq_work {
	work_struct_t power_opereq_work;
} power_opereq_work_t;

/* Work for power scr */
typedef struct power_scr_work {
	work_struct_t power_scr_work;
} power_scr_work_t;

/* Work for power opereq polling */
typedef struct power_opereq_poll_work {
	work_struct_t power_opereq_poll_work;
} power_opereq_poll_work_t;

/* Keyboard command struct */
typedef struct svinput_slv_kbd_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	uint8_t key_buf[I2C_RECV_BUF_SIZE - 3];
} __attribute__ ((__packed__)) svinput_slv_kbd_cmd_t;

/* Touch panel command struct */
typedef struct svinput_slv_tp_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int pres:8;
	unsigned int xh:8;
	unsigned int xl:8;
	unsigned int yh:8;
	unsigned int yl:8;
	unsigned int rxh:8;
	unsigned int rxl:8;
	unsigned int ryh:8;
	unsigned int ryl:8;
	unsigned int calib:8;
	unsigned int sum:8;
	unsigned int rsv1:8;
	unsigned int rsv2:8;
	unsigned int rsv3:8;
	unsigned int rsv4:8;
	unsigned int rsv5:8;
	unsigned int rsv6:8;
	unsigned int rsv7:8;
	unsigned int rsv8:8;
	unsigned int rsv9:8;
	unsigned int rsva:8;
	unsigned int rsvb:8;
	unsigned int rsvc:8;
	unsigned int rsvd:8;
	unsigned int rsve:8;
	unsigned int rsvf:8;
	unsigned int rsvg:8;
	unsigned int rsvh:8;
	unsigned int rsvi:8;
} __attribute__ ((__packed__)) svinput_slv_tp_cmd_t;

typedef struct svinput_mas_ver_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int mjcd:8;
	unsigned int micdh:8;
	unsigned int micdl:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_mas_ver_cmd_t;

typedef struct svinput_slvl_ver_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int mjcd:8;
	unsigned int micdh:8;
	unsigned int micdl:8;
	unsigned int ver1:8;
	unsigned int ver2:8;
	unsigned int ver3:8;
	unsigned int pno1:8;
	unsigned int pno2:8;
	unsigned int pno3:8;
	unsigned int pno4:8;
	unsigned int pno5:8;
	unsigned int pno6:8;
	unsigned int pno7:8;
	unsigned int pno8:8;
	unsigned int pnosfx:8;
	unsigned int initkey:8;
	unsigned int sum:8;
	unsigned int rsv1:8;
	unsigned int rsv2:8;
	unsigned int rsv3:8;
	unsigned int rsv4:8;
	unsigned int rsv5:8;
	unsigned int rsv6:8;
	unsigned int rsv7:8;
	unsigned int rsv8:8;
	unsigned int rsv9:8;
	unsigned int rsva:8;
	unsigned int rsvb:8;
	unsigned int rsvc:8;
} __attribute__ ((__packed__)) svinput_slvl_ver_cmd_t;

typedef struct svinput_mas_boot_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int cau:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_mas_boot_cmd_t;

typedef struct svinput_slv_boot_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int cau:8;
	unsigned int sum:8;
	unsigned int rsv1:8;
	unsigned int rsv2:8;
	unsigned int rsv3:8;
	unsigned int rsv4:8;
	unsigned int rsv5:8;
	unsigned int rsv6:8;
	unsigned int rsv7:8;
	unsigned int rsv8:8;
	unsigned int rsv9:8;
	unsigned int rsva:8;
	unsigned int rsvb:8;
	unsigned int rsvc:8;
	unsigned int rsvd:8;
	unsigned int rsve:8;
	unsigned int rsvf:8;
	unsigned int rsvg:8;
	unsigned int rsvh:8;
	unsigned int rsvi:8;
	unsigned int rsvj:8;
	unsigned int rsvk:8;
	unsigned int rsvl:8;
	unsigned int rsvm:8;
	unsigned int rsvn:8;
	unsigned int rsvo:8;
	unsigned int rsvp:8;
	unsigned int rsvq:8;
	unsigned int rsvr:8;
} __attribute__ ((__packed__)) svinput_slv_boot_cmd_t;

typedef struct svinput_mas_lp_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int sst:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_mas_lp_cmd_t;

/* For touch panel axis notification to user space(using read system call) */
typedef struct sv_tpanel_info {
	unsigned short pos_x;
	unsigned short pos_y;
	unsigned short press;
	unsigned short info;
} sv_tpanel_info_t;

typedef struct svinput_hb_recv_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int sum:8;
} svinput_hb_recv_cmd_t;

typedef struct svinput_hb_reply_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int sum:8;
} svinput_hb_reply_cmd_t;

/* 補正値の読み出し通知 */
typedef struct svinput_calib_read_request_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_calib_read_request_cmd_t;

/* Touch panel command struct */
typedef struct svinput_calib_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int ad1xh:8;
	unsigned int ad1xl:8;
	unsigned int ad1yh:8;
	unsigned int ad1yl:8;
	unsigned int ad2xh:8;
	unsigned int ad2xl:8;
	unsigned int ad2yh:8;
	unsigned int ad2yl:8;
	unsigned int ad3xh:8;
	unsigned int ad3xl:8;
	unsigned int ad3yh:8;
	unsigned int ad3yl:8;
	unsigned int ad4xh:8;
	unsigned int ad4xl:8;
	unsigned int ad4yh:8;
	unsigned int ad4yl:8;
	unsigned int ad5xh:8;
	unsigned int ad5xl:8;
	unsigned int ad5yh:8;
	unsigned int ad5yl:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_calib_cmd_t;

/* 補正値の書込み応答*/
typedef struct svinput_calib_write_response_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int ret:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_calib_write_response_cmd_t;

/* 補正要求 */
typedef struct svinput_calib_request_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int calib:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_calib_request_cmd_t;

/* define MINOR number */
typedef enum {
	SVINPUT_TOUCHPANEL_MINOR = 0,
	SVINPUT_KEYBORD_MINOR = 1,
	SVINPUT_LED_MINOR = 2,
	SVINPUT_BACKLIGHT_MINOR = 3,
	SVINPUT_POWMNG_MINOR = 4,
	SVINPUT_BUZZER_MINOR = 5,
	SVINPUT_FWUP_MINOR = 9,
} SVINPUT_MINOR_NO;

typedef enum {
	SVINPUT_FALSE = 0,
	SVINPUT_TRUE = 1,
} SVINPUT_BOOLEAN;

typedef enum {
	JACKAL = 0,
	CHEETAH = 1,
} DEVICE_NAME;

typedef void (*input_evt_hock_func_t)(void);

extern void __iomem *clk_stretch;

extern int __svinput_wait_event_interruptible_timeout(wait_queue_head_t *argp_wait_queue, int *argp_cond, long timeout);
extern void __svinput_wake_up_interruptible(wait_queue_head_t *argp_wait_queue, int *argp_cond);

#define svinput_wait_event_interruptible_timeout(argp_wait_queue, argp_cond, timeout) \
({ \
	int __ret; \
	DPRINTK("%s L:%d event wait start: jiffies:%08lx timeout:%lx\n", __FUNCTION__, __LINE__, jiffies, timeout); \
	__ret = __svinput_wait_event_interruptible_timeout(argp_wait_queue, argp_cond, timeout); \
	DPRINTK("%s L:%d event wait end: jiffies:%08lx __ret:%x\n", __FUNCTION__, __LINE__, jiffies, __ret); \
	__ret; \
})

#define svinput_wake_up_interruptible(argp_wait_queue, argp_cond) \
do{ \
	DPRINTK("%s L:%d wake_up start: cond:%08lx\n", __FUNCTION__, __LINE__, *argp_cond); \
	__svinput_wake_up_interruptible(argp_wait_queue, argp_cond); \
	DPRINTK("%s L:%d wake_up end: cond:%d\n", __FUNCTION__, __LINE__, *argp_cond); \
}while(0)

int exchange_version(svinput_priv_t *priv, int directtion, int do_mtrig);
int signal_status_notify(svinput_priv_t *priv, int sst, int ver_exch);
int wait_opepanel_disconnect(void);

#endif /* _SVINPUT_H_ */
