#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <string.h>
#include <errno.h>  

typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned int uint32_t;

/* ␳f[^ */
typedef struct tpanel_calib_data {
	uint8_t calib;   /* ␳v 1:␳Of[^v, 0:␳f[^v. ݎ RETl */
	uint16_t ad_data[10];
	/* [0]: AD1 xW */
	/* [1]: AD1 yW */
	/* [2]: AD2 xW */
	/* [3]: AD2 yW */
	/* [4]: AD3 xW */
	/* [5]: AD3 yW */
	/* [6]: AD4 xW */
	/* [7]: AD4 yW */
	/* [8]: AD5 xW */
	/* [9]: AD5 yW */
} tpanel_calib_data_t;

#define CTLOPE_CALIB_READ		_IOR('I', 0x02, struct tpanel_calib_data)
#define CTLOPE_CALIB_WRITE		_IOWR('I', 0x03, struct tpanel_calib_data)
#define CTLOPE_CALIB_REQUEST	_IOW('I', 0x04, struct tpanel_calib_data)

typedef struct sv_tpanel_info {
	unsigned short pos_x;
	unsigned short pos_y;
	unsigned short press;
	unsigned short info;
} sv_tpanel_info_t;

typedef struct sv_ts_mas_ver_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int mjcd:8;
	unsigned int micdh:8;
	unsigned int micdl:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) sv_ts_mas_ver_cmd_t;


static int menue()
{
	int	menue = 0;

	printf("*** ToutchPanel Driver Test ***\n");
	
	printf(" 0. Ever Loop  \n");
	printf(" 1. Calibration Data Read  \n");
	printf(" 2. Calibration Data Write \n");
	printf(" 3. Calibration Data Set   \n");
	printf("\n");
	printf("Input test number->");
	printf("\n");
	
	scanf("%d", &menue);
	rewind(stdin);
	return(menue);
	
}

int main(int argc, char** argv)
{
	while (1)
	{
		switch (menue())
		{
		case 0:
			menue_0();
			break;
		case 1:
			menue_1();
			break;
		case 2:
			break;
		case 3:
			break;
		}
	}
	return 0;
}



int menue_0(void)
{
	int rc = 0;
	int fd = 0;
	int cnt = 0;
	sv_ts_mas_ver_cmd_t ver_cmd;
	sv_tpanel_info_t info;

	printf("  menue_0  \n");

	fd = open("/dev/svtouch", O_RDWR);
	if (fd < 0) {
		rc = fd;
		goto EXIT_FUNC;
	}

	/*for (cnt = 0; cnt < 100; cnt++) {*/
	for ( ; ; ) {
		rc = read(fd, &info, sizeof(info));
		if (rc == sizeof(sv_tpanel_info_t)) {
			printf("succeed to read axys!\n");
			printf("  pos_x = %u\n", info.pos_x);
			printf("  pos_y = %u\n", info.pos_y);
			printf("  press = %u\n", info.press);
			printf("  info  = %u\n", info.info);
		} else {
			printf("failed to read axis with rc = %d\n", rc);
		}
	}

	close(fd);

 EXIT_FUNC:
	return rc;
}



int menue_1(void)
{
	
	int rc = 0;
	int fd = 0;
	int cnt = 0;
	tpanel_calib_data_t calib_cmd;

	printf("  menue_1  \n");

	fd = open("/dev/svtouch", O_RDWR);
	if (fd < 0) {
		rc = fd;
		goto EXIT_FUNC;
	}
	
	rc = ioctl(fd, CTLOPE_CALIB_READ, &calib_cmd);
	if (0 == rc) {
		printf("calib_cmd.calib      = %d \n", calib_cmd.calib);
		printf("calib_cmd.ad_data[0] = %d \n", calib_cmd.ad_data[0]);
		printf("calib_cmd.ad_data[1] = %d \n", calib_cmd.ad_data[1]);
		printf("calib_cmd.ad_data[2] = %d \n", calib_cmd.ad_data[2]);
		printf("calib_cmd.ad_data[3] = %d \n", calib_cmd.ad_data[3]);
		printf("calib_cmd.ad_data[4] = %d \n", calib_cmd.ad_data[4]);
		printf("calib_cmd.ad_data[5] = %d \n", calib_cmd.ad_data[5]);
		printf("calib_cmd.ad_data[6] = %d \n", calib_cmd.ad_data[6]);
		printf("calib_cmd.ad_data[7] = %d \n", calib_cmd.ad_data[7]);
		printf("calib_cmd.ad_data[8] = %d \n", calib_cmd.ad_data[8]);
		printf("calib_cmd.ad_data[9] = %d \n", calib_cmd.ad_data[9]);
	} else {
		printf("failed to ioctl CTLOPE_CALIB_READ = %d\n", rc);
	}
	close(fd);

 EXIT_FUNC:
	return rc;
}

