/***** -*- C -*- **************************************
 * $Id$
 *
 * Copyright (C) 2015 Ricoh Company, Ltd.  All Rights Reserved.
 *	 ORDER			 : RICOH input device driver
 *	 PROGRAM NAME	 : svinput.ko
 *	 FILE NAME		 : sv_touchpanel.h
 *	 VERSION		 : $Revision$
 *	 DESIGNER		 : Hideaki Yamamoto
 *	 AUTHOR 		 : $Author$
 *-----------------------------------------------------
 *		 HISTORY
 *	 Hideaki Yamamoto - 20 Nov 2015: Created.
 *	 $Log$
 ******************************************************/
#ifndef _SV_TOUCHPANEL_H_
#define _SV_TOUCHPANEL_H_

/* ␳f[^ */
typedef struct tpanel_calib_data {
	uint8_t calib;   /* ␳v 1:␳Of[^v, 0:␳f[^v. ݎ RETl */
	uint16_t ad_data[10];
	/* [0]: AD1 xW */
	/* [1]: AD1 yW */
	/* [2]: AD2 xW */
	/* [3]: AD2 yW */
	/* [4]: AD3 xW */
	/* [5]: AD3 yW */
	/* [6]: AD4 xW */
	/* [7]: AD4 yW */
	/* [8]: AD5 xW */
	/* [9]: AD5 yW */
} tpanel_calib_data_t;

#define CTLOPE_CALIB_READ		_IOR('I', 0x02, struct tpanel_calib_data)
#define CTLOPE_CALIB_WRITE		_IOWR('I', 0x03, struct tpanel_calib_data)
#define CTLOPE_CALIB_REQUEST	_IOW('I', 0x04, struct tpanel_calib_data)

void touchpanel_wqueue_handler(work_struct_t *work, svinput_slv_tp_cmd_t *slv_tp_cmd);
void touchpanel_wqueue_calib_handler(work_struct_t *work, uint8_t *_recv_packet);

int touchpanel_open(struct inode *inode, struct file *file);
int touchpanel_release(struct inode *inode, struct file *file);
ssize_t touchpanel_read(struct file *file, char *buffer, size_t count, loff_t *ppos);
unsigned int touchpanel_poll(struct file *file, poll_table * wait);
void touchpanel_probe(struct i2c_client *client, const struct i2c_device_id *idp);
long touchpanel_ioctl(struct file *file, unsigned int cmd, unsigned long arg);

#endif /* _SVTOUCHPANEL_H_ */
