#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/input.h>
#include <linux/i2c.h>
#include <linux/gpio.h>
#include <linux/errno.h>
#include <linux/delay.h>
#include <linux/interrupt.h>
#include <linux/module.h>
#include <linux/device.h>
#include <linux/cdev.h>
#include <linux/fs.h>
#include <linux/poll.h>
#include <linux/timer.h>
#include <linux/platform_device.h>
#include <linux/syscalls.h>
#include <linux/clk.h>
#include <linux/slab.h>
#include <linux/workqueue.h>
#include <linux/kthread.h>
#include <asm/gpio.h>

#include "svinput.h"

/* Firmupdate command struct */
typedef struct svinput_mas_fwup_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_mas_fwup_cmd_t;

extern int i2c_master_sendrecv(const struct i2c_client *client, const char *sndbuf, int sndcount, char *rcvbuf, int rcvcount);
extern int i2c_master_recvsend(const struct i2c_client *client, char *rcvbuf, int rcvcount, const char *sndbuf, int sndcount);
extern unsigned char calc_sum(unsigned char *buf, int sum_pos);

static int s_fwup_is_opened = 0;
static struct i2c_client *s_client = NULL;
static ssize_t fw_offset = 0;

int fwup_open(struct inode *inode, struct file *filep)
{
	int rc = 0;
	char recv_buf[I2C_RECV_BUF_SIZE] = {0};
	s_fwup_is_opened = SVINPUT_FALSE;

	FUNC_START;
	
	if (!s_client) {
		rc = -1;
		goto EXIT_FUNC;
	}
	
	fw_offset = 0;
	
	svinput_mas_fwup_cmd_t fwup_cmd = {
		.hdr = ST1,
		.cmd = 0x0E,
		.len = 0,
		.sum = 0x0E,
	};
	
	rc = i2c_master_sendrecv(s_client, (char*)(&fwup_cmd), sizeof(fwup_cmd), recv_buf, sizeof(recv_buf));
	if (rc == -1) {
		FORCE_DPRINTK(KERN_NOTICE "[svinput]Can't send firmupdate command (-_-;\n");
	}
	if (recv_buf[0] != PAK) {
		FORCE_DPRINTK(KERN_NOTICE "[svinput]Can't recv slave ack(-_-;\n");
	} else {
		s_fwup_is_opened = SVINPUT_TRUE;
		rc = 0;
	}
	
 EXIT_FUNC:
	FUNC_END;
	return rc;
}

int fwup_release(struct inode *inode, struct file *file)
{
	int rc = 0;
	FUNC_START;
	s_fwup_is_opened = SVINPUT_TRUE;
	FUNC_END;
	return rc;
}

void fwup_probe(struct i2c_client *client, const struct i2c_device_id *idp)
{
	FUNC_START;
	s_client = client;
	FUNC_END;
	return;
}

ssize_t fwup_write(struct file *filep, const char __user * buf, size_t len, loff_t * ptr)
{
	
	int data_len, error = 0, i, msg_len, unit;
	unsigned char send_buff[32], sum;
	char recv_buf[I2C_RECV_BUF_SIZE] = {0};
	int rc, result;

//	FUNC_START;
	
	if (len < 0 || 16 < len) {
		return -EMSGSIZE; /* サイズエラー */
	}
	
	/* 6 bytes for ST1, 0x0E, LEN, SUM and addr */
	data_len = min(sizeof(send_buff) - 6, len);
	msg_len = data_len + 6;
	
	send_buff[0] = ST1;
	send_buff[1] = 0x0E;
	send_buff[2] = data_len + 2;
	send_buff[3] = (fw_offset >> 8) & 0xFF;
	send_buff[4] = (fw_offset >> 0) & 0xFF;
	
	result = copy_from_user(&send_buff[5], (void __user *)buf, len);
	if (0 != result) {
		
	}
	
	sum = calc_sum((char*)(&send_buff[0]), msg_len - 1);
	
	send_buff[msg_len - 1] = sum;
	
	rc = i2c_master_sendrecv(s_client, (char*)(&send_buff[0]), msg_len, recv_buf, sizeof(recv_buf));
	if (rc == -1) {
		FORCE_DPRINTK(KERN_NOTICE "[svinput]Can't send firmupdate command (-_-;\n");
	}
	if (recv_buf[0] != PAK) {
		FORCE_DPRINTK(KERN_NOTICE "[svinput]Can't recv slave ack(-_-;\n");
	} else {
		fw_offset += data_len;
		result = data_len;
		printk("[svinput]%s L%d: CTL->Jackal Writting...[%d: Total %d] \n", __FUNCTION__, __LINE__, data_len, fw_offset);
	}
	
//	FUNC_END;
	
	return result;
}