/***** -*- C -*- **************************************
 * $Id$
 *
 * Copyright (C) 2015 Ricoh Company, Ltd.  All Rights Reserved.
 *	 ORDER			 : RICOH input device driver
 *	 PROGRAM NAME	 : svinput.ko
 *	 FILE NAME		 : sv_buzzer.h
 *	 VERSION		 : $Revision$
 *	 DESIGNER		 : Takahiro Ishida
 *	 AUTHOR 		 : $Author$
 *-----------------------------------------------------
 *		 HISTORY
 *	 Takahiro Ishida - 16 Mar 2017: Created.
 *	 $Log$
 ******************************************************/
#ifndef _SV_BUZZER_H_
#define _SV_BUZZER_H_

#include "ctlope_buzzer.h"

#define BUZZER_OFF		0
#define BUZZER_ON		1
#define BUZZER_LEVEL_MAX 3
#define BUZZER_ID_MAX 13

/* ブザーOFF */
typedef struct svinput_mas_buz_off_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_mas_buz_off_cmd_t;

/* ブザーON */
typedef struct svinput_mas_buz_on_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_mas_buz_on_cmd_t;

/* ブザー停止通知 */
typedef struct svinput_slv_buz_end_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int id:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_slv_buz_end_cmd_t;

/* ブザー・レベル制御 */
typedef struct svinput_mas_buz_level_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int level:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_mas_buz_level_cmd_t;

/* 指定ブザーパターンでON */
typedef struct svinput_mas_buz_id_on_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int id:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_mas_buz_id_on_cmd_t;

/* オリジナル・ブザー・パターン */
typedef struct svinput_mas_buz_org_ptn_cmd {
	unsigned int hdr:8;
	unsigned int cmd:8;
	unsigned int len:8;
	unsigned int id:8;
	unsigned int m:8;
	unsigned int level:8;
	unsigned int bptn0:8;
	unsigned int bptn1:8;
	unsigned int bptn2:8;
	unsigned int bptn3:8;
	unsigned int bptn4:8;
	unsigned int bptn5:8;
	unsigned int bptn6:8;
	unsigned int bptn7:8;
	unsigned int sum:8;
} __attribute__ ((__packed__)) svinput_mas_buz_org_ptn_cmd_t;

typedef struct buz_args {
	unsigned int id;
	unsigned int m;
	unsigned int level;
	unsigned int bptn0;
	unsigned int bptn1;
	unsigned int bptn2;
	unsigned int bptn3;
	unsigned int bptn4;
	unsigned int bptn5;
	unsigned int bptn6;
	unsigned int bptn7;
} buz_args_t;

typedef enum {
	BUZZER_LEVEL0 = 0,		/* 音量：特小 */
	BUZZER_LEVEL1 = 1,			/* 音量：小 */
	BUZZER_LEVEL2 = 2,			/* 音量：中(標準)(デフォルト) */
	BUZZER_LEVEL3 = 3,			/* 音量：大 */
} BUZZER_LEVEL;

#define BZ_IOC_SET_VOLUME _IOW(0xe6, 0x1e, buzzer_info_t)
#define BZ_IOC_BUZ_ID_ON _IOW(0xe6, 0x1f, buzzer_info_t)
#define BZ_IOC_BUZZER_ON _IO(0xe6, 0x20)
#define BZ_IOC_BUZZER_OFF _IO(0xe6, 0x21)
#define BZ_IOC_GET_BUZZER_INFO _IOR(0xe6, 0x22, buzzer_info_t)
#define BZ_IOC_BUZ_ORG_PTN _IOW(0xe6, 0x23, buz_args_t)

int buzzer_open(struct inode *inode, struct file *file);
int buzzer_release(struct inode *inode, struct file *file);
void buzzer_probe(struct i2c_client *client, const struct i2c_device_id *idp);
long buzzer_ioctl(struct file *file, unsigned int cmd, unsigned long arg);
void buzzer_wqueue_handler(svinput_slv_buz_end_cmd_t *slv_buz_end_cmd);
#endif /* _SV_BUZZER_H_ */
