#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/input.h>
#include <linux/i2c.h>
#include <linux/gpio.h>
#include <linux/errno.h>
#include <linux/delay.h>
#include <linux/interrupt.h>
#include <linux/module.h>
#include <linux/device.h>
#include <linux/cdev.h>
#include <linux/fs.h>
#include <linux/poll.h>
#include <linux/timer.h>
#include <linux/platform_device.h>
#include <linux/syscalls.h>
#include <linux/clk.h>
#include <linux/slab.h>
#include <linux/workqueue.h>
#include <linux/kthread.h>
#include <asm/gpio.h>

#include "svinput.h"
#include "sv_backlight.h"

extern int i2c_master_sendrecv(const struct i2c_client *client, const char *sndbuf, int sndcount, char *rcvbuf, int rcvcount);
extern int i2c_master_recvsend(const struct i2c_client *client, char *rcvbuf, int rcvcount, const char *sndbuf, int sndcount);

static int s_backlight_is_opened = 0;
static struct i2c_client *s_client = NULL;

static struct timeval tv = {
	.tv_sec = 0,
	.tv_usec = 0,
};

int backlight_open(struct inode *inode, struct file *file)
{
	int rc = 0;
	FUNC_START;
	s_backlight_is_opened = SVINPUT_FALSE;
	FUNC_END;
	return rc;
}

int backlight_release(struct inode *inode, struct file *file)
{
	int rc = 0;
	FUNC_START;
	s_backlight_is_opened = SVINPUT_TRUE;
	FUNC_END;
	return rc;
}

void backlight_probe(struct i2c_client *client, const struct i2c_device_id *idp)
{
	s_client = client;
	return;
}

long backlight_ioctl(struct file *file, unsigned int cmd, unsigned long arg)
{
	long rc = 0xffffffff;
	static int level = DUTY_LEVEL_10;
	char recv_buf[I2C_RECV_BUF_SIZE] = {0};
	svinput_mas_bl_cmd_t bl_cmd = {
		.hdr = ST1,
		.cmd = 0x70,
		.len = 1,
	};

	FUNC_START;
	if (!s_client) {
		goto EXIT_FUNC;
	}

	switch (cmd) {
	/* 輝度調整値の設定 */
	case BL_IOC_SET_LEVEL:
		DPRINTK("*** Not support \"BL_IOC_SET_LEVEL\" ***\n");
		rc = copy_from_user(&level, (void __user *)arg, sizeof(int));
		break;
	/* 輝度調整値の設定 */
	case BL_IOC_GET_LEVEL:
		DPRINTK("*** Not support \"BL_IOC_GET_LEVEL\" ***\n");
		rc = copy_to_user((void __user *)arg, &level, sizeof(int));
		break;
	/* バックライトON */
	case BL_IOC_ON:
		DPRINTK("(%ld.%06ld)BL_IOC_ON\n", tv.tv_sec, tv.tv_usec);
		bl_cmd.onoff = 1;
		bl_cmd.sum = ((bl_cmd.cmd + bl_cmd.onoff + bl_cmd.len) & 0x00ff);
		rc = i2c_master_sendrecv(s_client, (char*)(&bl_cmd), sizeof(bl_cmd), recv_buf, sizeof(recv_buf));
		if (rc == -1) {
			FORCE_DPRINTK(KERN_NOTICE "Can't send backlight command (-_-;\n");
		}
		if (recv_buf[0] != PAK) {
			FORCE_DPRINTK(KERN_NOTICE "Can't recv slave ack(-_-;\n");
		}
		break;
	/* バックライトOFF */
	case BL_IOC_OFF:
		DPRINTK("(%ld.%06ld)BL_IOC_OFF\n", tv.tv_sec, tv.tv_usec);
		bl_cmd.onoff = 0;
		bl_cmd.sum = ((bl_cmd.cmd + bl_cmd.onoff + bl_cmd.len) & 0x00ff);
		rc = i2c_master_sendrecv(s_client, (char*)(&bl_cmd), sizeof(bl_cmd), recv_buf, sizeof(recv_buf));
		if (rc == -1) {
			FORCE_DPRINTK(KERN_NOTICE "Can't send backlight command (-_-;\n");
		}
		if (recv_buf[0] != PAK) {
			FORCE_DPRINTK(KERN_NOTICE "Can't recv slave ack(-_-;\n");
		}
		break;
	default:
		DPRINTK("(%ld.%06ld)Unknown command => 0x%02x\n", tv.tv_sec, tv.tv_usec, cmd);
		break;
	}

 EXIT_FUNC:
	FUNC_END;
	return rc;
}
