#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <string.h>
#include <errno.h>  

#include "ctlope_power.h"

/**
   #define PW_IOC_OPEPANEL_OFF _IO(0xe6, 0x12)
   #define PW_IOC_MC_VERSIONS _IOR(0xe6, 0x17, char[MFPOPE_SIZE_SVERDAT])
*/

int main(int argc, char **argv)
{
	int cmd = 0;
	int rc = 0;
	int fd = 0;
	int errnum = 0;
	char ver_str[MFPOPE_SIZE_SVERDAT] = {0};

	if (argc == 2) {
		cmd = strtol(argv[1], NULL, 10);
	} else {
		printf("Invalid argument...\n");
		rc = -1;
		goto EXIT_FUNC;
	}

	fd = open("/dev/opepower", O_RDWR);
	if (fd < 0) {
		rc = -2;
		printf("Can't open device special...\n");
		goto EXIT_FUNC;
	}

	switch (cmd) {
	case 18:/* 0x12 */
		if (argc == 2) {
			rc = ioctl(fd, PW_IOC_OPEPANEL_OFF);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 23:/* 0x17 */
		if (argc == 2) {
			rc = ioctl(fd, PW_IOC_MC_VERSIONS, ver_str);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			} else {
				printf("0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x\n", ver_str[0], ver_str[1], ver_str[2], ver_str[3], ver_str[4], ver_str[5], ver_str[6], ver_str[7], ver_str[8], ver_str[9], ver_str[10], ver_str[11], ver_str[12], ver_str[13], ver_str[14]);
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 25:/* 0x19 */
		if (argc == 2) {
			rc = ioctl(fd, PW_IOC_OPEPANEL_ENERGYSAVE);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 26:/* 0x1a */
		if (argc == 2) {
			rc = ioctl(fd, PW_IOC_OPEPANEL_ON);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 48:
		if (argc == 2) {
			rc = ioctl(fd, PW_IOC_SCAN_ENGON);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 49:
		if (argc == 2) {
			rc = ioctl(fd, PW_IOC_SCAN_ENGOFF);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	case 99:
		if (argc == 2) {
			rc = ioctl(fd, PW_IOC_OPEPANEL_FORCE_OFF);
			if (rc != 0) {
				errnum = errno;
				printf("errno=%d(%s)\n", errnum, strerror(errnum));
			}
		} else {
			printf("Invalid argument...\n");
			rc = -3;
		}
		break;
	default:
		printf("Invalid command %d\n", cmd);
		rc = -1;
		break;
	}

	close(fd);

 EXIT_FUNC:
	return rc;
}
