#include <stdio.h>
#include <fcntl.h>
#include <sys/errno.h>
#include <stdlib.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/stat.h>


#define	OPEFWU_DEVICE0		"/dev/opefwup"

#define	BINFILE_1			"/media/mmcblk1p1/Jackal_Rom.bin"	/* b */

#define	READSIZE			16

/*************************************************************************
*                                                                        *
*   File name : jackal_update.c                                          *
*                                                                        *
*   Device    : RL78/G13                                                 *
*                                                                        *
*   Abstract  : L[}CR̃Abvf[gs                         *
*                                                                        *
*************************************************************************/
int main(int argc, char *argv[])
{
	int dev_fd;
	int file_fd;
	unsigned int error;

	FILE	*fp;
	size_t	try_size = 0;
	size_t	fix_size = 0;
	char 	buf[READSIZE+1];
	long	cnt = 0;
	long	offset = 0;
	
	struct stat	stat_data;
	off_t	file_size;

	memset(&buf[0], 0, READSIZE+1);

	printf("\n\n");
	printf("///////////////////////////////////////\n");
	printf("///                                 ///\n");
	printf("/// Jackal Micon ROM UPDATE TOOL    ///\n");
	printf("///                                 ///\n");
	printf("///                     2017-10-10  ///\n");
	printf("///////////////////////////////////////\n");

	/*
	 * L[}CRވׂ̃foCXI[v
	 * I[v_ŁAL[}CRROMXV[hɓ
	 */
	if ((dev_fd = open(OPEFWU_DEVICE0, O_WRONLY)) == -1) {
		printf("Device OPEN (%s) [NG] (errno:%d) \n", OPEFWU_DEVICE0, errno);
		close(dev_fd);
		exit(1);
	}

	/* L[}CRROMXV[hɓ܂ŏ݂sȂlɔÔߑ҂Ԃ݂ */
	sleep(1);

	/* JackalpL[}CRoCit@C̃I[v */
	if ((file_fd = open(BINFILE_1, O_RDONLY)) == NULL) {
		printf("%s none Binary file \n", BINFILE_1);
		goto prog_end;
	}

	/* ݏJn */
	printf("\n JACKAL MAICON UPDATE START Please Wait ...\n\n");

	if (0 != fstat(file_fd, &stat_data)) {
		printf("\n fstat error errno(%d):%s \n", errno, strerror(errno));
	} else {
		file_size = stat_data.st_size;
		printf("\n [%s]\n", BINFILE_1);
		printf(" -> Total Size %d[byte] \n\n", file_size);
		printf("\n");
	}
	
	offset = 0;
	
	while(1)
	{
		try_size = pread(file_fd, &buf[0], READSIZE, offset);
		if (!try_size)
		{
			printf("ROM Writing (Send %d, Total %d/%d)\n", fix_size, offset, file_size);
			printf("\n\n JACKAL MAICON UPDATE END Success \n\n");
			break;
		}

		/* foCX̏ */
		fix_size = write(dev_fd, &buf[0], try_size);
		if (fix_size == -1) {
			/* ݂s!! ňAXVp̖ŃL[}CRޕKv */
			printf("\n\n WRITE NG ..... !!\n\n");
			break;
		} else {
			offset += fix_size;
		}

		cnt += fix_size;
		if (cnt > 0x1000)
		{
			printf("ROM Writing (Send %d, Total %d/%d)\n", fix_size, offset, file_size);
			cnt = 0;
		}

		if (fix_size < READSIZE)
		{
			printf("\n\n JACKAL MAICON UPDATE END Success \n\n");
			break;
		}
	}

prog_end:
	close(file_fd);
	close(dev_fd);

}

