/*****************************************************************************
 Copyright(c) 2010 DTS INSIGHT CORPORATION
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.

 Note:

 Modification history
 +-------------- Historical number (000 to 999)
 |    +--------- Modified System Version
 |    |     +--- Classification of New, Modify, Append, Delete
 v    v     v
 No  Ver  Class Date                Description
 ---+-----+----+------------+--------------------------------------------------
 000 01.00 New  2012/10/01      New
 001 01.10 Mod  2013/01/28      Fixed #13113
 002 02.12 MOD  2014/12/12      Fixed #13672
 003 02.13 MOD  2015/03/12      Fixed SMTNEW-113
                                Supported #13749
 004 03.10 Mod  2016/05/20      SMTNEW-288

*****************************************************************************/

/* Include specification ****************************************************/
#include <linux/module.h>
#include <smt/SMTAPI.h>
#include <smt/SMTAPI_CP.h>

#define SET_FUNCPOINTER(api)		_SMT_##api = (func ? func : _SMT_##api##_nop)

/* Function prototypes ******************************************************/
void smt_set_PortOut( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER addr,_SMT_UNSIGNED_32BIT_INTEGER data,_SMT_PSZ size,_SMT_PRW rw ) );
void smt_set_Printf( int (*func)(int level,const char *format , ...) );
void smt_set_Puts( int (*func)(int level,const char *s) );
void smt_set_UsrMsgTag0( int (*func)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum ) );
void smt_set_UsrMsgTag1( int (*func)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1 ) );
void smt_set_UsrMsgTag2( int (*func)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2 ) );
void smt_set_UsrMsgTag3( int (*func)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3 ) );
void smt_set_UsrMsgTag4( int (*func)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4 ) );

void smt_set_OsSwitch_Process( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER processid) );
void smt_set_OsSwitch_ThreadProcess( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid) );
void smt_set_OsSwitch_Process_Name( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER processid,const char *str) );
void smt_set_OsSwitch_ThreadProcess_Name( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid,const char *tname,const char *pname) );
void smt_set_OsSwitch_Irq_in( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER irqid) );
void smt_set_OsSwitch_Irq_out( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER irqid) );
void smt_set_OsSwitch_Idle( int (*func)( void ) );
void smt_set_OsCall0( int (*func)(int osc,_SMT_OS_CALL attr) );
void smt_set_OsCall1( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1) );
void smt_set_OsCall2( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2) );
void smt_set_OsCall3( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3) );
void smt_set_OsCall4( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4) );
void smt_set_OsCall5( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5) );
void smt_set_OsCall6( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6) );
void smt_set_OsCall7( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7) );
void smt_set_OsCall8( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8) );
void smt_set_OsCall9( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9) );
void smt_set_OsCall10( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10) );
void smt_set_OsCall11( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11) );
void smt_set_OsCall12( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12) );
void smt_set_OsCall13( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13) );
void smt_set_OsCall14( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14) );
void smt_set_OsCall15( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15) );
void smt_set_OsCall16( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16) );

void smt_set_Hook0( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum) );
void smt_set_Hook1( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1) );
void smt_set_Hook2( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2) );
void smt_set_Hook3( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3) );
void smt_set_Hook4( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4) );
void smt_set_Hook5( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5) );
void smt_set_Hook6( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6) );
void smt_set_Hook7( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7) );
void smt_set_Hook8( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8) );
void smt_set_Hook9( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9) );
void smt_set_Hook10( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10) );
void smt_set_Hook11( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11) );
void smt_set_Hook12( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12) );
void smt_set_Hook13( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13) );
void smt_set_Hook14( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14) );
void smt_set_Hook15( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15) );
void smt_set_Hook16( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16) );

void smt_set_Hook0_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum) );
void smt_set_Hook1_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1) );
void smt_set_Hook2_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2) );
void smt_set_Hook3_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3) );
void smt_set_Hook4_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4) );
void smt_set_Hook5_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5) );
void smt_set_Hook6_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6) );
void smt_set_Hook7_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7) );
void smt_set_Hook8_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8) );
void smt_set_Hook9_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9) );
void smt_set_Hook10_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10) );
void smt_set_Hook11_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11) );
void smt_set_Hook12_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12) );
void smt_set_Hook13_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13) );
void smt_set_Hook14_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14) );
void smt_set_Hook15_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15) );
void smt_set_Hook16_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16) );

/* Static Function prototypes ***********************************************/
static int _SMT_PortOut_nop(_SMT_UNSIGNED_32BIT_INTEGER addr,_SMT_UNSIGNED_32BIT_INTEGER data,_SMT_PSZ size,_SMT_PRW rw);
static int _SMT_Printf_nop(int level,const char *format , ...);
static int _SMT_Puts_nop(int level,const char *s);
static int _SMT_UsrMsgTag0_nop(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum);
static int _SMT_UsrMsgTag1_nop(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1);
static int _SMT_UsrMsgTag2_nop(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2);
static int _SMT_UsrMsgTag3_nop(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3);
static int _SMT_UsrMsgTag4_nop(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4);
static int _SMT_OsSwitch_Process_nop(_SMT_UNSIGNED_32BIT_INTEGER processid);
static int _SMT_OsSwitch_ThreadProcess_nop(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid);
static int _SMT_OsSwitch_Process_Name_nop(_SMT_UNSIGNED_32BIT_INTEGER processid,const char *str);
static int _SMT_OsSwitch_ThreadProcess_Name_nop(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid,const char *tname,const char *pname);
static int _SMT_OsSwitch_Irq_in_nop(_SMT_UNSIGNED_32BIT_INTEGER irqid);
static int _SMT_OsSwitch_Irq_out_nop(_SMT_UNSIGNED_32BIT_INTEGER irqid);
static int _SMT_OsSwitch_Idle_nop( void );

static int _SMT_OsCall0_nop(int osc,_SMT_OS_CALL attr);
static int _SMT_OsCall1_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1);
static int _SMT_OsCall2_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2);
static int _SMT_OsCall3_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3);
static int _SMT_OsCall4_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4);
static int _SMT_OsCall5_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5);
static int _SMT_OsCall6_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6);
static int _SMT_OsCall7_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7);
static int _SMT_OsCall8_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8);
static int _SMT_OsCall9_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9);
static int _SMT_OsCall10_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10);
static int _SMT_OsCall11_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11);
static int _SMT_OsCall12_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12);
static int _SMT_OsCall13_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13);
static int _SMT_OsCall14_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14);
static int _SMT_OsCall15_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15);
static int _SMT_OsCall16_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16);

static void _TRQ_Hook0_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum);
static void _TRQ_Hook1_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1);
static void _TRQ_Hook2_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2);
static void _TRQ_Hook3_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3);
static void _TRQ_Hook4_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4);
static void _TRQ_Hook5_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5);
static void _TRQ_Hook6_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6);
static void _TRQ_Hook7_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7);
static void _TRQ_Hook8_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8);
static void _TRQ_Hook9_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9);
static void _TRQ_Hook10_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10);
static void _TRQ_Hook11_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11);
static void _TRQ_Hook12_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12);
static void _TRQ_Hook13_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13);
static void _TRQ_Hook14_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14);
static void _TRQ_Hook15_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15);
static void _TRQ_Hook16_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16);

/* Internal variables *******************************************************/
static int SMTDebugLevel 		  = SMT_LV_MSK;

int (*_SMT_PortOut)(_SMT_UNSIGNED_32BIT_INTEGER addr ,_SMT_UNSIGNED_32BIT_INTEGER data,_SMT_PSZ size,_SMT_PRW rw)												= _SMT_PortOut_nop;
int (*_SMT_Printf)(int level,const char *format , ...)																				= _SMT_Printf_nop;
int (*_SMT_Puts)(int level,const char *s)																							= _SMT_Puts_nop;
int (*_SMT_UsrMsgTag0)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum)																				= _SMT_UsrMsgTag0_nop;
int (*_SMT_UsrMsgTag1)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1)															= _SMT_UsrMsgTag1_nop;
int (*_SMT_UsrMsgTag2)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2)										= _SMT_UsrMsgTag2_nop;
int (*_SMT_UsrMsgTag3)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3)						= _SMT_UsrMsgTag3_nop;
int (*_SMT_UsrMsgTag4)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4)	= _SMT_UsrMsgTag4_nop;
int (*_SMT_OsSwitch_Process)(_SMT_UNSIGNED_32BIT_INTEGER processid) 																				= _SMT_OsSwitch_Process_nop;
int (*_SMT_OsSwitch_ThreadProcess)(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid) 													= _SMT_OsSwitch_ThreadProcess_nop;
int (*_SMT_OsSwitch_Process_Name)(_SMT_UNSIGNED_32BIT_INTEGER processid,const char *str) 															= _SMT_OsSwitch_Process_Name_nop;
int (*_SMT_OsSwitch_ThreadProcess_Name)(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid,const char *tname,const char *pname) 		= _SMT_OsSwitch_ThreadProcess_Name_nop;
int (*_SMT_OsSwitch_Irq_in)(_SMT_UNSIGNED_32BIT_INTEGER irqid) 																					= _SMT_OsSwitch_Irq_in_nop;
int (*_SMT_OsSwitch_Irq_out)(_SMT_UNSIGNED_32BIT_INTEGER irqid) 																					= _SMT_OsSwitch_Irq_out_nop;
int (*_SMT_OsSwitch_Idle)( void ) 																									= _SMT_OsSwitch_Idle_nop;

int (*_SMT_OsCall0)(int osc,_SMT_OS_CALL attr) 																						= _SMT_OsCall0_nop;
int (*_SMT_OsCall1)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1) 																	= _SMT_OsCall1_nop;
int (*_SMT_OsCall2)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2) 												= _SMT_OsCall2_nop;
int (*_SMT_OsCall3)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3) 							= _SMT_OsCall3_nop;
int (*_SMT_OsCall4)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4) 			= _SMT_OsCall4_nop;
int (*_SMT_OsCall5)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5) 																																																							= _SMT_OsCall5_nop;
int (*_SMT_OsCall6)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6) 																																																		= _SMT_OsCall6_nop;
int (*_SMT_OsCall7)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7) 																																													= _SMT_OsCall7_nop;
int (*_SMT_OsCall8)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8) 																																								= _SMT_OsCall8_nop;
int (*_SMT_OsCall9)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9)																																				= _SMT_OsCall9_nop;
int (*_SMT_OsCall10)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10) 																														= _SMT_OsCall10_nop;
int (*_SMT_OsCall11)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11) 																									= _SMT_OsCall11_nop;
int (*_SMT_OsCall12)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12) 																				= _SMT_OsCall12_nop;
int (*_SMT_OsCall13)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13) 															= _SMT_OsCall13_nop;
int (*_SMT_OsCall14)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14) 										= _SMT_OsCall14_nop;
int (*_SMT_OsCall15)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15) 					= _SMT_OsCall15_nop;
int (*_SMT_OsCall16)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16) = _SMT_OsCall16_nop;

void (*_TRQ_Hook0)(_SMT_UNSIGNED_32BIT_INTEGER TagNum)																							= _TRQ_Hook0_nop;
void (*_TRQ_Hook1)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1)																			= _TRQ_Hook1_nop;
void (*_TRQ_Hook2)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2)														= _TRQ_Hook2_nop;
void (*_TRQ_Hook3)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3)									= _TRQ_Hook3_nop;
void (*_TRQ_Hook4)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4)				= _TRQ_Hook4_nop;
void (*_TRQ_Hook5)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5)																																																								= _TRQ_Hook5_nop;
void (*_TRQ_Hook6)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6) 																																																			= _TRQ_Hook6_nop;
void (*_TRQ_Hook7)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7)																																														= _TRQ_Hook7_nop;
void (*_TRQ_Hook8)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8) 																																									= _TRQ_Hook8_nop;
void (*_TRQ_Hook9)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9)																																					= _TRQ_Hook9_nop;
void (*_TRQ_Hook10)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10)																															= _TRQ_Hook10_nop;
void (*_TRQ_Hook11)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11)																										= _TRQ_Hook11_nop;
void (*_TRQ_Hook12)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12)																					= _TRQ_Hook12_nop;
void (*_TRQ_Hook13)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13)																= _TRQ_Hook13_nop;
void (*_TRQ_Hook14)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14)											= _TRQ_Hook14_nop;
void (*_TRQ_Hook15)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15)						= _TRQ_Hook15_nop;
void (*_TRQ_Hook16)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16)	= _TRQ_Hook16_nop;

void (*_TRQ_Hook0_userland)(_SMT_UNSIGNED_32BIT_INTEGER TagNum)																							= _TRQ_Hook0_nop;
void (*_TRQ_Hook1_userland)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1)																			= _TRQ_Hook1_nop;
void (*_TRQ_Hook2_userland)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2)														= _TRQ_Hook2_nop;
void (*_TRQ_Hook3_userland)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3)									= _TRQ_Hook3_nop;
void (*_TRQ_Hook4_userland)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4)				= _TRQ_Hook4_nop;
void (*_TRQ_Hook5_userland)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5)																																																								= _TRQ_Hook5_nop;
void (*_TRQ_Hook6_userland)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6) 																																																			= _TRQ_Hook6_nop;
void (*_TRQ_Hook7_userland)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7)																																														= _TRQ_Hook7_nop;
void (*_TRQ_Hook8_userland)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8) 																																									= _TRQ_Hook8_nop;
void (*_TRQ_Hook9_userland)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9)																																					= _TRQ_Hook9_nop;
void (*_TRQ_Hook10_userland)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10)																															= _TRQ_Hook10_nop;
void (*_TRQ_Hook11_userland)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11)																										= _TRQ_Hook11_nop;
void (*_TRQ_Hook12_userland)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12)																					= _TRQ_Hook12_nop;
void (*_TRQ_Hook13_userland)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13)																= _TRQ_Hook13_nop;
void (*_TRQ_Hook14_userland)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14)											= _TRQ_Hook14_nop;
void (*_TRQ_Hook15_userland)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15)						= _TRQ_Hook15_nop;
void (*_TRQ_Hook16_userland)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16)	= _TRQ_Hook16_nop;

EXPORT_SYMBOL(_SMT_PortOut);
EXPORT_SYMBOL(_SMT_Printf);
EXPORT_SYMBOL(_SMT_Puts);
EXPORT_SYMBOL(_SMT_UsrMsgTag0);
EXPORT_SYMBOL(_SMT_UsrMsgTag1);
EXPORT_SYMBOL(_SMT_UsrMsgTag2);
EXPORT_SYMBOL(_SMT_UsrMsgTag3);
EXPORT_SYMBOL(_SMT_UsrMsgTag4);
EXPORT_SYMBOL(_SMT_OsSwitch_Process);
EXPORT_SYMBOL(_SMT_OsSwitch_ThreadProcess);
EXPORT_SYMBOL(_SMT_OsSwitch_Process_Name);
EXPORT_SYMBOL(_SMT_OsSwitch_ThreadProcess_Name);
EXPORT_SYMBOL(_SMT_OsSwitch_Irq_in);
EXPORT_SYMBOL(_SMT_OsSwitch_Irq_out);
EXPORT_SYMBOL(_SMT_OsSwitch_Idle);
EXPORT_SYMBOL(_SMT_OsCall0);
EXPORT_SYMBOL(_SMT_OsCall1);
EXPORT_SYMBOL(_SMT_OsCall2);
EXPORT_SYMBOL(_SMT_OsCall3);
EXPORT_SYMBOL(_SMT_OsCall4);
EXPORT_SYMBOL(_SMT_OsCall5);
EXPORT_SYMBOL(_SMT_OsCall6);
EXPORT_SYMBOL(_SMT_OsCall7);
EXPORT_SYMBOL(_SMT_OsCall8);
EXPORT_SYMBOL(_SMT_OsCall9);
EXPORT_SYMBOL(_SMT_OsCall10);
EXPORT_SYMBOL(_SMT_OsCall11);
EXPORT_SYMBOL(_SMT_OsCall12);
EXPORT_SYMBOL(_SMT_OsCall13);
EXPORT_SYMBOL(_SMT_OsCall14);
EXPORT_SYMBOL(_SMT_OsCall15);
EXPORT_SYMBOL(_SMT_OsCall16);
EXPORT_SYMBOL(_TRQ_Hook0);
EXPORT_SYMBOL(_TRQ_Hook1);
EXPORT_SYMBOL(_TRQ_Hook2);
EXPORT_SYMBOL(_TRQ_Hook3);
EXPORT_SYMBOL(_TRQ_Hook4);
EXPORT_SYMBOL(_TRQ_Hook5);
EXPORT_SYMBOL(_TRQ_Hook6);
EXPORT_SYMBOL(_TRQ_Hook7);
EXPORT_SYMBOL(_TRQ_Hook8);
EXPORT_SYMBOL(_TRQ_Hook9);
EXPORT_SYMBOL(_TRQ_Hook10);
EXPORT_SYMBOL(_TRQ_Hook11);
EXPORT_SYMBOL(_TRQ_Hook12);
EXPORT_SYMBOL(_TRQ_Hook13);
EXPORT_SYMBOL(_TRQ_Hook14);
EXPORT_SYMBOL(_TRQ_Hook15);
EXPORT_SYMBOL(_TRQ_Hook16);
EXPORT_SYMBOL(_TRQ_Hook0_userland);
EXPORT_SYMBOL(_TRQ_Hook1_userland);
EXPORT_SYMBOL(_TRQ_Hook2_userland);
EXPORT_SYMBOL(_TRQ_Hook3_userland);
EXPORT_SYMBOL(_TRQ_Hook4_userland);
EXPORT_SYMBOL(_TRQ_Hook5_userland);
EXPORT_SYMBOL(_TRQ_Hook6_userland);
EXPORT_SYMBOL(_TRQ_Hook7_userland);
EXPORT_SYMBOL(_TRQ_Hook8_userland);
EXPORT_SYMBOL(_TRQ_Hook9_userland);
EXPORT_SYMBOL(_TRQ_Hook10_userland);
EXPORT_SYMBOL(_TRQ_Hook11_userland);
EXPORT_SYMBOL(_TRQ_Hook12_userland);
EXPORT_SYMBOL(_TRQ_Hook13_userland);
EXPORT_SYMBOL(_TRQ_Hook14_userland);
EXPORT_SYMBOL(_TRQ_Hook15_userland);
EXPORT_SYMBOL(_TRQ_Hook16_userland);
/*****************************************************************************
1.Function: get debug print output level

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------

4.Return Value:
								SMTDebugLevel: debug print output level

*****************************************************************************/
int	_SMT_GetDebugLevel( void )
{
	return SMTDebugLevel;
}
EXPORT_SYMBOL(_SMT_GetDebugLevel);

/*****************************************************************************
1.Function: set debug print output level

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	level						Setting value of debug print output level mask

4.Return Value:
								SMTDebugLevel: debug print output level

*****************************************************************************/
void _SMT_SetDebugLevel( int level )
{
	SMTDebugLevel = level;
}
EXPORT_SYMBOL(_SMT_SetDebugLevel);

/*****************************************************************************
1.Function: set _SMT_PortOut() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_PortOut( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER addr ,_SMT_UNSIGNED_32BIT_INTEGER data ,_SMT_PSZ size ,_SMT_PRW rw ) )
{
	if( func ){
		_SMT_PortOut = func;
	}
	else{
		_SMT_PortOut = _SMT_PortOut_nop;
	}
}
EXPORT_SYMBOL(smt_set_PortOut);

/*****************************************************************************
1.Function: set _SMT_Printf() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Printf( int (*func)(int level,const char *format , ...) )
{
	if( func ){
		_SMT_Printf = func;
	}
	else{
		_SMT_Printf = _SMT_Printf_nop;
	}
}
EXPORT_SYMBOL(smt_set_Printf);

/*****************************************************************************
1.Function: set _SMT_Puts() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Puts( int (*func)(int level,const char *s) )
{
	if( func ){
		_SMT_Puts = func;
	}
	else{
		_SMT_Puts = _SMT_Puts_nop;
	}
}
EXPORT_SYMBOL(smt_set_Puts);

/*****************************************************************************
1.Function: set _SMT_UsrMsgTag0() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_UsrMsgTag0( int(*func)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum ) )
{
	if( func ){
		_SMT_UsrMsgTag0 = func;
	}
	else{
		_SMT_UsrMsgTag0 = _SMT_UsrMsgTag0_nop;
	}
}
EXPORT_SYMBOL(smt_set_UsrMsgTag0);

/*****************************************************************************
1.Function: set _SMT_UsrMsgTag1() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_UsrMsgTag1( int (*func)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1 ) )
{
	if( func ){
		_SMT_UsrMsgTag1 = func;
	}
	else{
		_SMT_UsrMsgTag1 = _SMT_UsrMsgTag1_nop;
	}
}
EXPORT_SYMBOL(smt_set_UsrMsgTag1);

/*****************************************************************************
1.Function: set _SMT_UsrMsgTag2() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_UsrMsgTag2( int (*func)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2 ) )
{
	if( func ){
		_SMT_UsrMsgTag2 = func;
	}
	else{
		_SMT_UsrMsgTag2 = _SMT_UsrMsgTag2_nop;
	}
}
EXPORT_SYMBOL(smt_set_UsrMsgTag2);

/*****************************************************************************
1.Function: set _SMT_UsrMsgTag3() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_UsrMsgTag3( int (*func)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3 ) )
{
	if( func ){
		_SMT_UsrMsgTag3 = func;
	}
	else{
		_SMT_UsrMsgTag3 = _SMT_UsrMsgTag3_nop;
	}
}
EXPORT_SYMBOL(smt_set_UsrMsgTag3);

/*****************************************************************************
1.Function: set _SMT_UsrMsgTag4() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_UsrMsgTag4( int (*func)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4 ) )
{
	if( func ){
		_SMT_UsrMsgTag4 = func;
	}
	else{
		_SMT_UsrMsgTag4 = _SMT_UsrMsgTag4_nop;
	}
}
EXPORT_SYMBOL(smt_set_UsrMsgTag4);

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_PortOut() function

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/	addr						Address value
I/	data						Data value
I/	size						Port size 1:8bit 2:16bit 3:32bit
I/	rw							Access type 0:Write 1:Read

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_PortOut_nop(_SMT_UNSIGNED_32BIT_INTEGER addr ,_SMT_UNSIGNED_32BIT_INTEGER data ,_SMT_PSZ size ,_SMT_PRW rw )
{
	return( _SMT_OK );
}

/****************************************************************************
1.Function: Library uninitialized when for _SMTPrintf() 

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/	level						Level of debug print output
I/	*format						Pointer for character string to specify the syntax
I/	arg							Output data in accordance with the syntax


4.Return Value:
	_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_Printf_nop(int level,const char *format , ...)
{
	return( _SMT_OK );
}

/****************************************************************************
1.Function: Library uninitialized when for _SMTPuts() 

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/	level						Level of debug print output
I/	*s							Pointer for character string to output

4.Return Value:
	_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_Puts_nop(int level,const char *s)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_UsrMsgTag0() 
information.

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	level						Level of debug statement output
I/	TagNum						Message tag number 0 to 1023

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_UsrMsgTag0_nop(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_UsrMsgTag1() 
information.

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	level						Level of debug statement output
I/	TagNum						Message tag number 0 to 1023
I/	arg1						Output data in accordance with the syntax

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_UsrMsgTag1_nop(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_UsrMsgTag2() 
information.

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	level						Level of debug statement output
I/	TagNum						Message tag number 0 to 1023
I/	arg1						Output data in accordance with the syntax
I/	arg2						Output data in accordance with the syntax

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_UsrMsgTag2_nop(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_UsrMsgTag3() 
information.

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	level						Level of debug statement output
I/	TagNum						Message tag number 0 to 1023
I/	arg1						Output data in accordance with the syntax
I/	arg2						Output data in accordance with the syntax
I/	arg3						Output data in accordance with the syntax

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_UsrMsgTag3_nop(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_UsrMsgTag4() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	level						Level of debug statement output
I/	TagNum						Message tag number 0 to 1023
I/	arg1						Output data in accordance with the syntax
I/	arg2						Output data in accordance with the syntax
I/	arg3						Output data in accordance with the syntax
I/	arg4						Output data in accordance with the syntax

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_UsrMsgTag4_nop(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: set _SMT_OsSwitch_Process() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsSwitch_Process( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER processid) )
{
	SET_FUNCPOINTER(OsSwitch_Process);
}
EXPORT_SYMBOL(smt_set_OsSwitch_Process);

/*****************************************************************************
1.Function: set _SMT_OsSwitch_ThreadProcess() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsSwitch_ThreadProcess( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid) )
{
	SET_FUNCPOINTER(OsSwitch_ThreadProcess);
}
EXPORT_SYMBOL(smt_set_OsSwitch_ThreadProcess);

/*****************************************************************************
1.Function: set _SMT_OsSwitch_Process_Name() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsSwitch_Process_Name( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER processid,const char *str) )
{
	SET_FUNCPOINTER(OsSwitch_Process_Name);
}
EXPORT_SYMBOL(smt_set_OsSwitch_Process_Name);

/*****************************************************************************
1.Function: set _SMT_OsSwitch_ThreadProcess_Name() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsSwitch_ThreadProcess_Name( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid,const char *tname,const char *pname) )
{
	SET_FUNCPOINTER(OsSwitch_ThreadProcess_Name);
}
EXPORT_SYMBOL(smt_set_OsSwitch_ThreadProcess_Name);

/*****************************************************************************
1.Function: set _SMT_OsSwitch_Irq_in() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsSwitch_Irq_in( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER irqid) )
{
	SET_FUNCPOINTER(OsSwitch_Irq_in);
}
EXPORT_SYMBOL(smt_set_OsSwitch_Irq_in);

/*****************************************************************************
1.Function: set _SMT_OsSwitch_Irq_out() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsSwitch_Irq_out( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER irqid) )
{
	SET_FUNCPOINTER(OsSwitch_Irq_out);
}
EXPORT_SYMBOL(smt_set_OsSwitch_Irq_out);

/*****************************************************************************
1.Function: set _SMT_OsSwitch_Idle() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsSwitch_Idle( int (*func)( void ) )
{
	SET_FUNCPOINTER(OsSwitch_Idle);
}
EXPORT_SYMBOL(smt_set_OsSwitch_Idle);

/*****************************************************************************
1.Function: set _SMT_OsCall0() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsCall0( int (*func)(int osc,_SMT_OS_CALL attr) )
{
	SET_FUNCPOINTER(OsCall0);
}
EXPORT_SYMBOL(smt_set_OsCall0);

/*****************************************************************************
1.Function: set _SMT_OsCall1() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsCall1( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1) )
{
	SET_FUNCPOINTER(OsCall1);
}
EXPORT_SYMBOL(smt_set_OsCall1);

/*****************************************************************************
1.Function: set _SMT_OsCall2() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsCall2( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2) )
{
	SET_FUNCPOINTER(OsCall2);
}
EXPORT_SYMBOL(smt_set_OsCall2);

/*****************************************************************************
1.Function: set _SMT_OsCall3() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsCall3( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3) )
{
	SET_FUNCPOINTER(OsCall3);
}
EXPORT_SYMBOL(smt_set_OsCall3);

/*****************************************************************************
1.Function: set _SMT_OsCall4() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsCall4( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4) )
{
	SET_FUNCPOINTER(OsCall4);
}
EXPORT_SYMBOL(smt_set_OsCall4);

/*****************************************************************************
1.Function: set _SMT_OsCall5() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsCall5( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5) )
{
	SET_FUNCPOINTER(OsCall5);
}
EXPORT_SYMBOL(smt_set_OsCall5);

/*****************************************************************************
1.Function: set _SMT_OsCall6() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsCall6( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6) )
{
	SET_FUNCPOINTER(OsCall6);
}
EXPORT_SYMBOL(smt_set_OsCall6);

/*****************************************************************************
1.Function: set _SMT_OsCall7() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsCall7( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7) )
{
	SET_FUNCPOINTER(OsCall7);
}
EXPORT_SYMBOL(smt_set_OsCall7);

/*****************************************************************************
1.Function: set _SMT_OsCall8() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsCall8( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8) )
{
	SET_FUNCPOINTER(OsCall8);
}
EXPORT_SYMBOL(smt_set_OsCall8);

/*****************************************************************************
1.Function: set _SMT_OsCall9() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsCall9( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9) )
{
	SET_FUNCPOINTER(OsCall9);
}
EXPORT_SYMBOL(smt_set_OsCall9);

/*****************************************************************************
1.Function: set _SMT_OsCall10() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsCall10( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10) )
{
	SET_FUNCPOINTER(OsCall10);
}
EXPORT_SYMBOL(smt_set_OsCall10);

/*****************************************************************************
1.Function: set _SMT_OsCall11() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsCall11( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11) )
{
	SET_FUNCPOINTER(OsCall11);
}
EXPORT_SYMBOL(smt_set_OsCall11);

/*****************************************************************************
1.Function: set _SMT_OsCall12() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsCall12( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12) )
{
	SET_FUNCPOINTER(OsCall12);
}
EXPORT_SYMBOL(smt_set_OsCall12);

/*****************************************************************************
1.Function: set _SMT_OsCall13() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsCall13( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13) )
{
	SET_FUNCPOINTER(OsCall13);
}
EXPORT_SYMBOL(smt_set_OsCall13);

/*****************************************************************************
1.Function: set _SMT_OsCall14() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsCall14( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14) )
{
	SET_FUNCPOINTER(OsCall14);
}
EXPORT_SYMBOL(smt_set_OsCall14);

/*****************************************************************************
1.Function: set _SMT_OsCall15() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsCall15( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15) )
{
	SET_FUNCPOINTER(OsCall15);
}
EXPORT_SYMBOL(smt_set_OsCall15);

/*****************************************************************************
1.Function: set _SMT_OsCall16() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_OsCall16( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16) )
{
	SET_FUNCPOINTER(OsCall16);
}
EXPORT_SYMBOL(smt_set_OsCall16);

/*****************************************************************************
1.Function: set _TRQ_Hook0() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook0( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum) )
{
	if( func ){
		_TRQ_Hook0 = func;
	}
	else{
		_TRQ_Hook0 = _TRQ_Hook0_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook0);

/*****************************************************************************
1.Function: set _TRQ_Hook1() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook1( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1) )
{
	if( func ){
		_TRQ_Hook1 = func;
	}
	else{
		_TRQ_Hook1 = _TRQ_Hook1_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook1);

/*****************************************************************************
1.Function: set _TRQ_Hook2() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook2( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2) )
{
	if( func ){
		_TRQ_Hook2 = func;
	}
	else{
		_TRQ_Hook2 = _TRQ_Hook2_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook2);

/*****************************************************************************
1.Function: set _TRQ_Hook3() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook3( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3) )
{
	if( func ){
		_TRQ_Hook3 = func;
	}
	else{
		_TRQ_Hook3 = _TRQ_Hook3_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook3);

/*****************************************************************************
1.Function: set _TRQ_Hook4() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook4( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4) )
{
	if( func ){
		_TRQ_Hook4 = func;
	}
	else{
		_TRQ_Hook4 = _TRQ_Hook4_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook4);

/*****************************************************************************
1.Function: set _TRQ_Hook5() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook5( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5) )
{
	if( func ){
		_TRQ_Hook5 = func;
	}
	else{
		_TRQ_Hook5 = _TRQ_Hook5_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook5);

/*****************************************************************************
1.Function: set _TRQ_Hook6() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook6( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6) )
{
	if( func ){
		_TRQ_Hook6 = func;
	}
	else{
		_TRQ_Hook6 = _TRQ_Hook6_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook6);

/*****************************************************************************
1.Function: set _TRQ_Hook7() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook7( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7) )
{
	if( func ){
		_TRQ_Hook7 = func;
	}
	else{
		_TRQ_Hook7 = _TRQ_Hook7_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook7);

/*****************************************************************************
1.Function: set _TRQ_Hook8() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook8( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8) )
{
	if( func ){
		_TRQ_Hook8 = func;
	}
	else{
		_TRQ_Hook8 = _TRQ_Hook8_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook8);

/*****************************************************************************
1.Function: set _TRQ_Hook9() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook9( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9) )
{
	if( func ){
		_TRQ_Hook9 = func;
	}
	else{
		_TRQ_Hook9 = _TRQ_Hook9_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook9);

/*****************************************************************************
1.Function: set _TRQ_Hook10() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook10( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10) )
{
	if( func ){
		_TRQ_Hook10 = func;
	}
	else{
		_TRQ_Hook10 = _TRQ_Hook10_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook10);

/*****************************************************************************
1.Function: set _TRQ_Hook11() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook11( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11) )
{
	if( func ){
		_TRQ_Hook11 = func;
	}
	else{
		_TRQ_Hook11 = _TRQ_Hook11_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook11);

/*****************************************************************************
1.Function: set _TRQ_Hook12() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook12( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12) )
{
	if( func ){
		_TRQ_Hook12 = func;
	}
	else{
		_TRQ_Hook12 = _TRQ_Hook12_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook12);

/*****************************************************************************
1.Function: set _TRQ_Hook13() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook13( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13) )
{
	if( func ){
		_TRQ_Hook13 = func;
	}
	else{
		_TRQ_Hook13 = _TRQ_Hook13_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook13);

/*****************************************************************************
1.Function: set _TRQ_Hook14() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook14( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14) )
{
	if( func ){
		_TRQ_Hook14 = func;
	}
	else{
		_TRQ_Hook14 = _TRQ_Hook14_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook14);

/*****************************************************************************
1.Function: set _TRQ_Hook15() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook15( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15) )
{
	if( func ){
		_TRQ_Hook15 = func;
	}
	else{
		_TRQ_Hook15 = _TRQ_Hook15_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook15);

/*****************************************************************************
1.Function: set _TRQ_Hook16() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook16( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16) )
{
	if( func ){
		_TRQ_Hook16 = func;
	}
	else{
		_TRQ_Hook16 = _TRQ_Hook16_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook16);

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsSwitch_Process() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	processid					Process ID

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:abnormal end
*****************************************************************************/
static int _SMT_OsSwitch_Process_nop(_SMT_UNSIGNED_32BIT_INTEGER processid)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsSwitch_ThreadProcess() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	threadid					Thread ID
I/	processid					Process ID

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:abnormal end
*****************************************************************************/
static int _SMT_OsSwitch_ThreadProcess_nop(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsSwitch_Process_Name() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	processid					Process ID
I/	str							Character string of process name (up to 56 characters including termination character)

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:abnormal end
*****************************************************************************/
static int _SMT_OsSwitch_Process_Name_nop(_SMT_UNSIGNED_32BIT_INTEGER processid,const char *str)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsSwitch_ThreadProcess_Name() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	threadid					Thread ID
I/	processid					Process ID
I/	tname						Character string of thread name (up to 56 characters including termination character)
I/	pname						Character string of process name (up to 56 characters including termination character)


4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:abnormal end
*****************************************************************************/
static int _SMT_OsSwitch_ThreadProcess_Name_nop(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid,const char *tname,const char *pname)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsSwitch_Irq_in() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	irqid						Interruption number

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:abnormal end
*****************************************************************************/
static int _SMT_OsSwitch_Irq_in_nop(_SMT_UNSIGNED_32BIT_INTEGER irqid)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsSwitch_Irq_out() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	irqid						Interruption number

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:abnormal end
*****************************************************************************/
static int _SMT_OsSwitch_Irq_out_nop(_SMT_UNSIGNED_32BIT_INTEGER irqid)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsSwitch_Idle() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------


4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:abnormal end
*****************************************************************************/
static int _SMT_OsSwitch_Idle_nop( void )
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsCall0() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_OsCall0_nop(int osc,_SMT_OS_CALL attr)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsCall1() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
									
I/	arg1						Argument 1

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_OsCall1_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsCall2() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
									
I/	arg1						Argument 1
I/	arg2						Argument 2

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_OsCall2_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsCall3() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
									
I/	argN(1-3)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_OsCall3_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsCall4() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
									
I/	argN(1-4)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_OsCall4_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsCall5() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
									
I/	argN(1-5)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_OsCall5_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsCall6() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
									
I/	argN(1-6)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_OsCall6_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsCall7() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
									
I/	argN(1-7)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_OsCall7_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsCall8() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
									
I/	argN(1-8)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_OsCall8_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsCall9() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
									
I/	argN(1-9)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_OsCall9_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsCall10() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
									
I/	argN(1-10)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_OsCall10_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsCall11() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
									
I/	argN(1-11)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_OsCall11_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsCall12() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
									
I/	argN(1-12)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_OsCall12_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsCall13() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
									
I/	argN(1-13)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_OsCall13_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsCall14() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
									
I/	argN(1-14)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_OsCall14_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsCall15() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
									
I/	argN(1-15)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_OsCall15_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_OsCall16() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
									
I/	argN(1-16)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int _SMT_OsCall16_nop(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16)
{
	return( _SMT_OK );
}

/*****************************************************************************
1.Function: Library uninitialized when for _TRQ_Hook0() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static void _TRQ_Hook0_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum)
{
}

/*****************************************************************************
1.Function: Library uninitialized when for _TRQ_Hook1() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	arg1						argument value/return value

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static void _TRQ_Hook1_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1 )
{
}

/*****************************************************************************
1.Function: Library uninitialized when for _TRQ_Hook2() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-2)					argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static void _TRQ_Hook2_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum ,_SMT_UNSIGNED_32BIT_INTEGER arg1 ,_SMT_UNSIGNED_32BIT_INTEGER arg2 )
{
}

/*****************************************************************************
1.Function: Library uninitialized when for _TRQ_Hook3() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-3)					argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static void _TRQ_Hook3_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum ,_SMT_UNSIGNED_32BIT_INTEGER arg1 ,_SMT_UNSIGNED_32BIT_INTEGER arg2 ,_SMT_UNSIGNED_32BIT_INTEGER arg3 )
{
}

/*****************************************************************************
1.Function: Library uninitialized when for _TRQ_Hook4() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-4)					argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static void _TRQ_Hook4_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum ,_SMT_UNSIGNED_32BIT_INTEGER arg1 ,_SMT_UNSIGNED_32BIT_INTEGER arg2 ,_SMT_UNSIGNED_32BIT_INTEGER arg3 ,_SMT_UNSIGNED_32BIT_INTEGER arg4 )
{
}

/*****************************************************************************
1.Function: Library uninitialized when for _TRQ_Hook5() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-5)					argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static void _TRQ_Hook5_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum ,_SMT_UNSIGNED_32BIT_INTEGER arg1 ,_SMT_UNSIGNED_32BIT_INTEGER arg2 ,_SMT_UNSIGNED_32BIT_INTEGER arg3 ,_SMT_UNSIGNED_32BIT_INTEGER arg4 ,_SMT_UNSIGNED_32BIT_INTEGER arg5 )
{
}

/*****************************************************************************
1.Function: Library uninitialized when for _TRQ_Hook6() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-6)					argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static void _TRQ_Hook6_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum ,_SMT_UNSIGNED_32BIT_INTEGER arg1 ,_SMT_UNSIGNED_32BIT_INTEGER arg2 ,_SMT_UNSIGNED_32BIT_INTEGER arg3 ,_SMT_UNSIGNED_32BIT_INTEGER arg4 ,_SMT_UNSIGNED_32BIT_INTEGER arg5 ,_SMT_UNSIGNED_32BIT_INTEGER arg6 )
{
}

/*****************************************************************************
1.Function: Library uninitialized when for _TRQ_Hook7() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-7)					argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static void _TRQ_Hook7_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum ,_SMT_UNSIGNED_32BIT_INTEGER arg1 ,_SMT_UNSIGNED_32BIT_INTEGER arg2 ,_SMT_UNSIGNED_32BIT_INTEGER arg3 ,_SMT_UNSIGNED_32BIT_INTEGER arg4 ,_SMT_UNSIGNED_32BIT_INTEGER arg5 ,_SMT_UNSIGNED_32BIT_INTEGER arg6 ,_SMT_UNSIGNED_32BIT_INTEGER arg7 )
{
}

/*****************************************************************************
1.Function: Library uninitialized when for _TRQ_Hook8() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-8)					argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static void _TRQ_Hook8_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum ,_SMT_UNSIGNED_32BIT_INTEGER arg1 ,_SMT_UNSIGNED_32BIT_INTEGER arg2 ,_SMT_UNSIGNED_32BIT_INTEGER arg3 ,_SMT_UNSIGNED_32BIT_INTEGER arg4 ,_SMT_UNSIGNED_32BIT_INTEGER arg5 ,_SMT_UNSIGNED_32BIT_INTEGER arg6 ,_SMT_UNSIGNED_32BIT_INTEGER arg7 ,_SMT_UNSIGNED_32BIT_INTEGER arg8 )
{
}

/*****************************************************************************
1.Function: Library uninitialized when for _TRQ_Hook9() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-9)					argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static void _TRQ_Hook9_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum ,_SMT_UNSIGNED_32BIT_INTEGER arg1 ,_SMT_UNSIGNED_32BIT_INTEGER arg2 ,_SMT_UNSIGNED_32BIT_INTEGER arg3 ,_SMT_UNSIGNED_32BIT_INTEGER arg4 ,_SMT_UNSIGNED_32BIT_INTEGER arg5 ,_SMT_UNSIGNED_32BIT_INTEGER arg6 ,_SMT_UNSIGNED_32BIT_INTEGER arg7 ,_SMT_UNSIGNED_32BIT_INTEGER arg8 ,_SMT_UNSIGNED_32BIT_INTEGER arg9 )
{
}

/*****************************************************************************
1.Function: Library uninitialized when for _TRQ_Hook10() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-10)					argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static void _TRQ_Hook10_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum ,_SMT_UNSIGNED_32BIT_INTEGER arg1 ,_SMT_UNSIGNED_32BIT_INTEGER arg2 ,_SMT_UNSIGNED_32BIT_INTEGER arg3 ,_SMT_UNSIGNED_32BIT_INTEGER arg4 ,_SMT_UNSIGNED_32BIT_INTEGER arg5 ,_SMT_UNSIGNED_32BIT_INTEGER arg6 ,_SMT_UNSIGNED_32BIT_INTEGER arg7 ,_SMT_UNSIGNED_32BIT_INTEGER arg8 ,_SMT_UNSIGNED_32BIT_INTEGER arg9 ,_SMT_UNSIGNED_32BIT_INTEGER arg10 )
{
}

/*****************************************************************************
1.Function: Library uninitialized when for _TRQ_Hook11() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-11)					argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static void _TRQ_Hook11_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum ,_SMT_UNSIGNED_32BIT_INTEGER arg1 ,_SMT_UNSIGNED_32BIT_INTEGER arg2 ,_SMT_UNSIGNED_32BIT_INTEGER arg3 ,_SMT_UNSIGNED_32BIT_INTEGER arg4 ,_SMT_UNSIGNED_32BIT_INTEGER arg5 ,_SMT_UNSIGNED_32BIT_INTEGER arg6 ,_SMT_UNSIGNED_32BIT_INTEGER arg7 ,_SMT_UNSIGNED_32BIT_INTEGER arg8 ,_SMT_UNSIGNED_32BIT_INTEGER arg9 ,_SMT_UNSIGNED_32BIT_INTEGER arg10 ,_SMT_UNSIGNED_32BIT_INTEGER arg11 )
{
}

/*****************************************************************************
1.Function: Library uninitialized when for _TRQ_Hook12() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-12)					argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static void _TRQ_Hook12_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum ,_SMT_UNSIGNED_32BIT_INTEGER arg1 ,_SMT_UNSIGNED_32BIT_INTEGER arg2 ,_SMT_UNSIGNED_32BIT_INTEGER arg3 ,_SMT_UNSIGNED_32BIT_INTEGER arg4 ,_SMT_UNSIGNED_32BIT_INTEGER arg5 ,_SMT_UNSIGNED_32BIT_INTEGER arg6 ,_SMT_UNSIGNED_32BIT_INTEGER arg7 ,_SMT_UNSIGNED_32BIT_INTEGER arg8 ,_SMT_UNSIGNED_32BIT_INTEGER arg9 ,_SMT_UNSIGNED_32BIT_INTEGER arg10 ,_SMT_UNSIGNED_32BIT_INTEGER arg11 ,_SMT_UNSIGNED_32BIT_INTEGER arg12 )
{
}

/*****************************************************************************
1.Function: Library uninitialized when for _TRQ_Hook13() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-13)					argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static void _TRQ_Hook13_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum ,_SMT_UNSIGNED_32BIT_INTEGER arg1 ,_SMT_UNSIGNED_32BIT_INTEGER arg2 ,_SMT_UNSIGNED_32BIT_INTEGER arg3 ,_SMT_UNSIGNED_32BIT_INTEGER arg4 ,_SMT_UNSIGNED_32BIT_INTEGER arg5 ,_SMT_UNSIGNED_32BIT_INTEGER arg6 ,_SMT_UNSIGNED_32BIT_INTEGER arg7 ,_SMT_UNSIGNED_32BIT_INTEGER arg8 ,_SMT_UNSIGNED_32BIT_INTEGER arg9 ,_SMT_UNSIGNED_32BIT_INTEGER arg10 ,_SMT_UNSIGNED_32BIT_INTEGER arg11 ,_SMT_UNSIGNED_32BIT_INTEGER arg12 ,_SMT_UNSIGNED_32BIT_INTEGER arg13 )
{
}

/*****************************************************************************
1.Function: Library uninitialized when for _TRQ_Hook14() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-14)					argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static void _TRQ_Hook14_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum ,_SMT_UNSIGNED_32BIT_INTEGER arg1 ,_SMT_UNSIGNED_32BIT_INTEGER arg2 ,_SMT_UNSIGNED_32BIT_INTEGER arg3 ,_SMT_UNSIGNED_32BIT_INTEGER arg4 ,_SMT_UNSIGNED_32BIT_INTEGER arg5 ,_SMT_UNSIGNED_32BIT_INTEGER arg6 ,_SMT_UNSIGNED_32BIT_INTEGER arg7 ,_SMT_UNSIGNED_32BIT_INTEGER arg8 ,_SMT_UNSIGNED_32BIT_INTEGER arg9 ,_SMT_UNSIGNED_32BIT_INTEGER arg10 ,_SMT_UNSIGNED_32BIT_INTEGER arg11 ,_SMT_UNSIGNED_32BIT_INTEGER arg12 ,_SMT_UNSIGNED_32BIT_INTEGER arg13 ,_SMT_UNSIGNED_32BIT_INTEGER arg14 )
{
}

/*****************************************************************************
1.Function: Library uninitialized when for _TRQ_Hook15() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-15)					argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static void _TRQ_Hook15_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum ,_SMT_UNSIGNED_32BIT_INTEGER arg1 ,_SMT_UNSIGNED_32BIT_INTEGER arg2 ,_SMT_UNSIGNED_32BIT_INTEGER arg3 ,_SMT_UNSIGNED_32BIT_INTEGER arg4 ,_SMT_UNSIGNED_32BIT_INTEGER arg5 ,_SMT_UNSIGNED_32BIT_INTEGER arg6 ,_SMT_UNSIGNED_32BIT_INTEGER arg7 ,_SMT_UNSIGNED_32BIT_INTEGER arg8 ,_SMT_UNSIGNED_32BIT_INTEGER arg9 ,_SMT_UNSIGNED_32BIT_INTEGER arg10 ,_SMT_UNSIGNED_32BIT_INTEGER arg11 ,_SMT_UNSIGNED_32BIT_INTEGER arg12 ,_SMT_UNSIGNED_32BIT_INTEGER arg13 ,_SMT_UNSIGNED_32BIT_INTEGER arg14 ,_SMT_UNSIGNED_32BIT_INTEGER arg15 )
{
}

/*****************************************************************************
1.Function: Library uninitialized when for _TRQ_Hook16() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-16)					argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static void _TRQ_Hook16_nop(_SMT_UNSIGNED_32BIT_INTEGER TagNum ,_SMT_UNSIGNED_32BIT_INTEGER arg1 ,_SMT_UNSIGNED_32BIT_INTEGER arg2 ,_SMT_UNSIGNED_32BIT_INTEGER arg3 ,_SMT_UNSIGNED_32BIT_INTEGER arg4 ,_SMT_UNSIGNED_32BIT_INTEGER arg5 ,_SMT_UNSIGNED_32BIT_INTEGER arg6 ,_SMT_UNSIGNED_32BIT_INTEGER arg7 ,_SMT_UNSIGNED_32BIT_INTEGER arg8 ,_SMT_UNSIGNED_32BIT_INTEGER arg9 ,_SMT_UNSIGNED_32BIT_INTEGER arg10 ,_SMT_UNSIGNED_32BIT_INTEGER arg11 ,_SMT_UNSIGNED_32BIT_INTEGER arg12 ,_SMT_UNSIGNED_32BIT_INTEGER arg13 ,_SMT_UNSIGNED_32BIT_INTEGER arg14 ,_SMT_UNSIGNED_32BIT_INTEGER arg15 ,_SMT_UNSIGNED_32BIT_INTEGER arg16 )
{
}

/*****************************************************************************
1.Function: Library uninitialized when for _SMT_CP_Printf() 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I 	TagNum						Tag number
I	argN(1-16)					argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int  _SMT_CP_Printf(int level, const char *format , ...){

	va_list	ap;
	char s[_SMT_CP_PUTW_BUF_SIZE_B] __attribute__ ((aligned (4)));
	va_start(ap,format);
	vsnprintf(s,_SMT_CP_PUTW_BUF_SIZE_B,format,ap);
	va_end(ap);
	return( _SMT_Puts(level,s) );
}
EXPORT_SYMBOL(_SMT_CP_Printf);

/*****************************************************************************
1.Function: set _TRQ_Hook0_userland() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook0_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum) )
{
	if( func ){
		_TRQ_Hook0_userland = func;
	}
	else{
		_TRQ_Hook0_userland = _TRQ_Hook0_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook0_userland);

/*****************************************************************************
1.Function: set _TRQ_Hook1_userland() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook1_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1) )
{
	if( func ){
		_TRQ_Hook1_userland = func;
	}
	else{
		_TRQ_Hook1_userland = _TRQ_Hook1_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook1_userland);

/*****************************************************************************
1.Function: set _TRQ_Hook2_userland() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook2_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2) )
{
	if( func ){
		_TRQ_Hook2_userland = func;
	}
	else{
		_TRQ_Hook2_userland = _TRQ_Hook2_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook2_userland);

/*****************************************************************************
1.Function: set _TRQ_Hook3_userland() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook3_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3) )
{
	if( func ){
		_TRQ_Hook3_userland = func;
	}
	else{
		_TRQ_Hook3_userland = _TRQ_Hook3_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook3_userland);

/*****************************************************************************
1.Function: set _TRQ_Hook4_userland() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook4_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4) )
{
	if( func ){
		_TRQ_Hook4_userland = func;
	}
	else{
		_TRQ_Hook4_userland = _TRQ_Hook4_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook4_userland);

/*****************************************************************************
1.Function: set _TRQ_Hook5_userland() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook5_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5) )
{
	if( func ){
		_TRQ_Hook5_userland = func;
	}
	else{
		_TRQ_Hook5_userland = _TRQ_Hook5_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook5_userland);

/*****************************************************************************
1.Function: set _TRQ_Hook6_userland() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook6_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6) )
{
	if( func ){
		_TRQ_Hook6_userland = func;
	}
	else{
		_TRQ_Hook6_userland = _TRQ_Hook6_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook6_userland);

/*****************************************************************************
1.Function: set _TRQ_Hook7_userland() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook7_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7) )
{
	if( func ){
		_TRQ_Hook7_userland = func;
	}
	else{
		_TRQ_Hook7_userland = _TRQ_Hook7_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook7_userland);

/*****************************************************************************
1.Function: set _TRQ_Hook8_userland() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook8_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8) )
{
	if( func ){
		_TRQ_Hook8_userland = func;
	}
	else{
		_TRQ_Hook8_userland = _TRQ_Hook8_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook8_userland);

/*****************************************************************************
1.Function: set _TRQ_Hook9_userland() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook9_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9) )
{
	if( func ){
		_TRQ_Hook9_userland = func;
	}
	else{
		_TRQ_Hook9_userland = _TRQ_Hook9_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook9_userland);

/*****************************************************************************
1.Function: set _TRQ_Hook10_userland() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook10_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10) )
{
	if( func ){
		_TRQ_Hook10_userland = func;
	}
	else{
		_TRQ_Hook10_userland = _TRQ_Hook10_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook10_userland);

/*****************************************************************************
1.Function: set _TRQ_Hook11_userland() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook11_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11) )
{
	if( func ){
		_TRQ_Hook11_userland = func;
	}
	else{
		_TRQ_Hook11_userland = _TRQ_Hook11_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook11_userland);

/*****************************************************************************
1.Function: set _TRQ_Hook12() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook12_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12) )
{
	if( func ){
		_TRQ_Hook12_userland = func;
	}
	else{
		_TRQ_Hook12_userland = _TRQ_Hook12_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook12_userland);

/*****************************************************************************
1.Function: set _TRQ_Hook13_userland() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook13_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13) )
{
	if( func ){
		_TRQ_Hook13_userland = func;
	}
	else{
		_TRQ_Hook13_userland = _TRQ_Hook13_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook13_userland);

/*****************************************************************************
1.Function: set _TRQ_Hook14() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook14_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14) )
{
	if( func ){
		_TRQ_Hook14_userland = func;
	}
	else{
		_TRQ_Hook14_userland = _TRQ_Hook14_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook14_userland);

/*****************************************************************************
1.Function: set _TRQ_Hook15_userland() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook15_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15) )
{
	if( func ){
		_TRQ_Hook15_userland = func;
	}
	else{
		_TRQ_Hook15_userland = _TRQ_Hook15_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook15_userland);

/*****************************************************************************
1.Function: set _TRQ_Hook16_userland() address 

2.Restriction, Cautions: 

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I	func						function pointer

4.Return Value:

*****************************************************************************/
void smt_set_Hook16_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16) )
{
	if( func ){
		_TRQ_Hook16_userland = func;
	}
	else{
		_TRQ_Hook16_userland = _TRQ_Hook16_nop;
	}
}
EXPORT_SYMBOL(smt_set_Hook16_userland);