/*****************************************************************************
 Copyright(c) 2010 DTS INSIGHT CORPORATION
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.

 Note:

 Modification history
 +-------------- Historical number (000 to 999)
 |    +--------- Modified System Version
 |    |     +--- Classification of New, Modify, Append, Delete
 v    v     v
 No  Ver  Class Date                Description
 ---+-----+----+------------+--------------------------------------------------
 000 01.00 New  2012/10/01      New
 001 01.10 Mod  2013/01/28      Fixed #13113 
 002 02.12 MOD  2014/12/12      Fixed #13672
 003 02.13 MOD  2015/03/12      Fixed SMTNEW-113
*****************************************************************************/
#ifndef __SMTAPI_H__
#define __SMTAPI_H__

typedef unsigned long _SMT_UNSIGNED_32BIT_INTEGER;

#define	_SMT_OK			0			// normal end
#define	_SMT_NG			-1			// abnoarmal end
                                    
/****** debug  print output level config ******/
/* SMT_LV_MSK

    bit
     1 1 1 1 1 1
     5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
    +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
    |L|L|L|L|L|L|L|L|L|L|L|L|L|L|L|L|
    |V|V|V|V|V|V|V|V|V|V|V|V|V|V|V|V|
    |1|1|1|1|1|1| | | | | | | | | | |
    |5|4|3|2|1|0|9|8|7|6|5|4|3|2|1|0|
    +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
    LV0-15= Level
    
    NOTE: Each bit masks the corresponding level of SMT debug statement level.
     1: mask   0: output

    Example 1: Output all debug statement levels
    #define SMT_LV_MSK  0x0000

    Example 2: Output debug statements whose level is 4 or above. 
    #define SMT_LV_MSK  0x000F

    Example 3: Output the debug statements whose level is 2 or 8.
    #define SMT_LV_MSK  0xFEFB


 */

#define	SMT_LV_MSK	0x0000

/****** Invalidate the debug function config ******/
/* 
    Invalidate the all debug output
    #define _SMT_ALL_DIS
    Invalidate the port output function
    #define _SMT_PORT_DIS
    Invalidate the print-related functions
    #define _SMT_PRINT_DIS
*/

#if !defined(_SMT_PORT_DIS) && !defined(_SMT_ALL_DIS)
	#define	_SMT_PORTOUT		_SMT_PortOut
#else	// _SMT_PORT_DIS
	#define	_SMT_PORTOUT		1 ? (void)0 : _SMT_PortOut
#endif	// _SMT_PORT_DIS

#if !defined(_SMT_PRINT_DIS) && !defined(_SMT_ALL_DIS)
	#define	_SMT_PRINTF			_SMT_Printf
	#define	_SMT_PUTS			_SMT_Puts
	#define	_SMT_USRMSGTAG0		_SMT_UsrMsgTag0
	#define	_SMT_USRMSGTAG1		_SMT_UsrMsgTag1
	#define	_SMT_USRMSGTAG2		_SMT_UsrMsgTag2
	#define	_SMT_USRMSGTAG3		_SMT_UsrMsgTag3
	#define	_SMT_USRMSGTAG4		_SMT_UsrMsgTag4
#else	// _SMT_PRINT_DIS
	#define	_SMT_PRINTF			1 ? (void)0 : _SMT_Printf
	#define	_SMT_PUTS			1 ? (void)0 : _SMT_Puts
	#define	_SMT_USRMSGTAG0		1 ? (void)0 : _SMT_UsrMsgTag0
	#define	_SMT_USRMSGTAG1		1 ? (void)0 : _SMT_UsrMsgTag1
	#define	_SMT_USRMSGTAG2		1 ? (void)0 : _SMT_UsrMsgTag2
	#define	_SMT_USRMSGTAG3		1 ? (void)0 : _SMT_UsrMsgTag3
	#define	_SMT_USRMSGTAG4		1 ? (void)0 : _SMT_UsrMsgTag4
#endif	// _SMT_PRINT_DIS

#if !defined(_SMT_OS_DIS) && !defined(_SMT_ALL_DIS)
	#define _SMT_OSSWITCH_PROCESS				_SMT_OsSwitch_Process
	#define _SMT_OSSWITCH_THREADPROCESS			_SMT_OsSwitch_ThreadProcess
	#define _SMT_OSSWITCH_PROCESS_NAME			_SMT_OsSwitch_Process_Name
	#define _SMT_OSSWITCH_THREADPROCESS_NAME	_SMT_OsSwitch_ThreadProcess_Name
	#define _SMT_OSSWITCH_IRQ_IN				_SMT_OsSwitch_Irq_in
	#define _SMT_OSSWITCH_IRQ_OUT				_SMT_OsSwitch_Irq_out
	#define _SMT_OSSWITCH_IDLE					_SMT_OsSwitch_Idle
	#define _SMT_OSCALL0						_SMT_OsCall0
	#define _SMT_OSCALL1						_SMT_OsCall1
	#define _SMT_OSCALL2						_SMT_OsCall2
	#define _SMT_OSCALL3						_SMT_OsCall3
	#define _SMT_OSCALL4						_SMT_OsCall4
	#define _SMT_OSCALL5						_SMT_OsCall5
	#define _SMT_OSCALL6						_SMT_OsCall6
	#define _SMT_OSCALL7						_SMT_OsCall7
	#define _SMT_OSCALL8						_SMT_OsCall8
	#define _SMT_OSCALL9						_SMT_OsCall9
	#define _SMT_OSCALL10						_SMT_OsCall10
	#define _SMT_OSCALL11						_SMT_OsCall11
	#define _SMT_OSCALL12						_SMT_OsCall12
	#define _SMT_OSCALL13						_SMT_OsCall13
	#define _SMT_OSCALL14						_SMT_OsCall14
	#define _SMT_OSCALL15						_SMT_OsCall15
	#define _SMT_OSCALL16						_SMT_OsCall16
#else
	#define _SMT_OSSWITCH_PROCESS				1 ? (void)0 : _SMT_OsSwitch_Process
	#define _SMT_OSSWITCH_THREADPROCESS			1 ? (void)0 : _SMT_OsSwitch_ThreadProcess
	#define _SMT_OSSWITCH_PROCESS_NAME			1 ? (void)0 : _SMT_OsSwitch_Process_Name
	#define _SMT_OSSWITCH_THREADPROCESS_NAME	1 ? (void)0 : _SMT_OsSwitch_ThreadProcess_Name
	#define _SMT_OSSWITCH_IRQ_IN				1 ? (void)0 : _SMT_OsSwitch_Irq_in
	#define _SMT_OSSWITCH_IRQ_OUT				1 ? (void)0 : _SMT_OsSwitch_Irq_out
	#define _SMT_OSSWITCH_IDLE					1 ? (void)0 : _SMT_OsSwitch_Idle
	#define _SMT_OSCALL0						1 ? (void)0 : _SMT_OsCall0
	#define _SMT_OSCALL1						1 ? (void)0 : _SMT_OsCall1
	#define _SMT_OSCALL2						1 ? (void)0 : _SMT_OsCall2
	#define _SMT_OSCALL3						1 ? (void)0 : _SMT_OsCall3
	#define _SMT_OSCALL4						1 ? (void)0 : _SMT_OsCall4
	#define _SMT_OSCALL5						1 ? (void)0 : _SMT_OsCall5
	#define _SMT_OSCALL6						1 ? (void)0 : _SMT_OsCall6
	#define _SMT_OSCALL7						1 ? (void)0 : _SMT_OsCall7
	#define _SMT_OSCALL8						1 ? (void)0 : _SMT_OsCall8
	#define _SMT_OSCALL9						1 ? (void)0 : _SMT_OsCall9
	#define _SMT_OSCALL10						1 ? (void)0 : _SMT_OsCall10
	#define _SMT_OSCALL11						1 ? (void)0 : _SMT_OsCall11
	#define _SMT_OSCALL12						1 ? (void)0 : _SMT_OsCall12
	#define _SMT_OSCALL13						1 ? (void)0 : _SMT_OsCall13
	#define _SMT_OSCALL14						1 ? (void)0 : _SMT_OsCall14
	#define _SMT_OSCALL15						1 ? (void)0 : _SMT_OsCall15
	#define _SMT_OSCALL16						1 ? (void)0 : _SMT_OsCall16
#endif


// port size value
typedef enum {
	_SMT_PSZ64 = 0,				// 64Bit width(unused)
	_SMT_PSZ8,					//  8Bit width
	_SMT_PSZ16,					// 16Bit width
	_SMT_PSZ32					// 32Bit width
} _SMT_PSZ ;

// data access
typedef enum{
	_SMT_PW = 0,				// Write access
	_SMT_PR						// Read access
} _SMT_PRW;


typedef enum {
	_SMT_OS_ATTR_CALL = 0,
	_SMT_OS_ATTR_RET
} _SMT_OS_CALL ;

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
	int	 _SMT_GetDebugLevel( void );
	void _SMT_SetDebugLevel( int level );
	void _SMT_IntrruptInit(void);
	void _SMT_IntrruptEnable(void);
	void _SMT_IntrruptDisable(void);
#ifdef __cplusplus
}
#endif // __cplusplus

/* Function prototypes ******************************************************/
extern int (*_SMT_PortOut)(_SMT_UNSIGNED_32BIT_INTEGER addr,_SMT_UNSIGNED_32BIT_INTEGER data,_SMT_PSZ size,_SMT_PRW rw);
extern int (*_SMT_Printf)(int level,const char *format , ...);
extern int	(*_SMT_Puts)(int level,const char *s);
extern int	(*_SMT_UsrMsgTag0)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum);
extern int	(*_SMT_UsrMsgTag1)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1);
extern int	(*_SMT_UsrMsgTag2)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2);
extern int	(*_SMT_UsrMsgTag3)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3);
extern int	(*_SMT_UsrMsgTag4)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4);
extern int (*_SMT_OsSwitch_Process)(_SMT_UNSIGNED_32BIT_INTEGER processid);
extern int (*_SMT_OsSwitch_ThreadProcess)(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid);
extern int (*_SMT_OsSwitch_Process_Name)(_SMT_UNSIGNED_32BIT_INTEGER processid,const char *str);
extern int (*_SMT_OsSwitch_ThreadProcess_Name)(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid,const char *tname,const char *pname);
extern int (*_SMT_OsSwitch_Irq_in)(_SMT_UNSIGNED_32BIT_INTEGER irqid);
extern int (*_SMT_OsSwitch_Irq_out)(_SMT_UNSIGNED_32BIT_INTEGER irqid);
extern int (*_SMT_OsSwitch_Idle)( void );
extern int (*_SMT_OsCall0)(int osc,_SMT_OS_CALL attr);
extern int (*_SMT_OsCall1)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1);
extern int (*_SMT_OsCall2)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2);
extern int (*_SMT_OsCall3)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3);
extern int (*_SMT_OsCall4)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4);
extern int (*_SMT_OsCall5)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5);
extern int (*_SMT_OsCall6)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6);
extern int (*_SMT_OsCall7)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7);
extern int (*_SMT_OsCall8)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8);
extern int (*_SMT_OsCall9)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9);
extern int (*_SMT_OsCall10)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10);
extern int (*_SMT_OsCall11)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11);
extern int (*_SMT_OsCall12)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12);
extern int (*_SMT_OsCall13)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13);
extern int (*_SMT_OsCall14)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14);
extern int (*_SMT_OsCall15)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15);
extern int (*_SMT_OsCall16)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16);


#endif /* __SMTAPI_H__ */
