/****************************************************************************
 Copyright(c) 2010 DTS INSIGHT CORPORATION
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.

 Note:

 Modification history
 +-------------- Historical number (000 to 999)
 |	  +--------- Modified System Version
 |	  | 	+--- Classification of New, Modify, Append, Delete
 v	  v 	v
 No  Ver  Class Date				Description
 ---+-----+----+------------+--------------------------------------------------
 000 01.00 New 2012/10/01		New
 001 01.10 Mod 2013/01/28		Fixed #13113 
 002 02.13 MOD 2015/03/12       Fixed SMTNEW-113
 003 03.10 Mod 2016/05/20      SMTNEW-288
*****************************************************************************/

/* Include specification ****************************************************/
#include <linux/version.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/init.h>
#include <linux/fs.h>
#include <linux/string.h>
#include <linux/sched.h>
#include <linux/slab.h>

#include <smt/SMTAPI.h>
#include "smtoutput.h"
/* Constant definition ******************************************************/

/* FROM driver/mmc/host/sdhci.h */
#include <linux/io.h>
#define SDHCI_MAKE_CMD(c, f)	(((c & 0xff) << 8) | (f & 0xff))

#define SDHCI_ARGUMENT		0x08
#define SDHCI_TRANSFER_MODE	0x0C
#define SDHCI_COMMAND		0x0E
#define SDHCI_PRESENT_STATE	0x24
  /* in SDHCI_PRESENT_STATE */
  #define SDHCI_CMD_INHIBIT	0x00000001
#define SDHCI_POWER_CONTROL	0x29
  /* in SDHCI_POWER_CONTROL */
  #define SDHCI_POWER_ON	0x01
  #define SDHCI_POWER_330	0x0E
#define SDHCI_CLOCK_CONTROL	0x2C
  /* in SDHCI_CLOCK_CONTROL */
  #define SDHCI_CLOCK_INT_EN	0x0001
  #define SDHCI_CLOCK_CARD_EN	0x0004
#define SDHCI_INT_STATUS	0x30
  /* in SDHCI_INT_STATUS */
  #define SDHCI_INT_RESPONSE	0x00000001
  #define SDHCI_INT_TIMEOUT	0x00010000

/* FROM driver/mmc/host/sdhci-pxav3.c */
#define SD_CE_ATA_2		0x10E
#define SDCE_MISC_INT_EN	(1 << 1)

/* Original definitions. */
#define SDMMC3REG_BASE		0xD4281000
#define SDMMC3REG_SIZE		0x200

static void *sdmmc3_ioaddr;
#define IO_ADDR(_offset)	(void *)(sdmmc3_ioaddr + _offset)

#define SMT_CLOCK_48MHZ		(2 << 8)

/* Externel refarence function prototyps ************************************/
extern unsigned long smt_disable_int(void);
extern void smt_enable_int(unsigned long flag);

/* Function prototypes ******************************************************/


/* Internal function prototypes *********************************************/
static int SDIO_output(_SMT_UNSIGNED_32BIT_INTEGER data,const unsigned long attr);

/* Internal variables *******************************************************/
/*
 * SMT SD Comand table 
 */
#define		SD_SMT_CMD_HEAD			1
#define		SD_SMT_CMD_DATA			0

static unsigned long sd_smt_cmd[4][2] = {
	{ 0x0000003E, 0x0000003F},
	{ 0x0000002C, 0x0000002D},
	{ 0x0000002E, 0x0000002F},
	{ 0x00000030, 0x00000031}
};

#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
/*****************************************************************************
1.Function: output Stack pointer address

2.Restriction, Cautions:
	not support 64bit address

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------

4.Return Value:

*****************************************************************************/
_SMT_UNSIGNED_32BIT_INTEGER _SMT_get_SP_address(void){
	_SMT_UNSIGNED_32BIT_INTEGER sp_addr = 0 ;

	<<< Caution >>> Please delete this line, and code the program.
//	#ifdef __GNUC__
//  sp_addr = __builtin_frame_address(0);
//	#endif

	return sp_addr;
}

#endif

/****************************************************************************
1.Function: SMT driver Initialization

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_Init(void)
{
	u8	val_power;
	u16	val_clock;
	u16	val_interrupt;

	sdmmc3_ioaddr = ioremap_nocache(SDMMC3REG_BASE, SDMMC3REG_SIZE);
	if (!sdmmc3_ioaddr) {
		pr_err("smtModule: Initialization failed.\n");
		return( _SMT_NG );
	}

	/* set Power. (3.30V) */
	val_power = SDHCI_POWER_ON | SDHCI_POWER_330;
	iowrite8(val_power, IO_ADDR(SDHCI_POWER_CONTROL));

	/* set Clock. (48MHz) */
	val_clock = SDHCI_CLOCK_CARD_EN | SDHCI_CLOCK_INT_EN | SMT_CLOCK_48MHZ;
	iowrite16(val_clock, IO_ADDR(SDHCI_CLOCK_CONTROL));

	/* set Interruption. */
	val_interrupt = ioread16(IO_ADDR(SD_CE_ATA_2)) | SDCE_MISC_INT_EN;
	iowrite16(val_interrupt, IO_ADDR(SD_CE_ATA_2));

	pr_info("smtModule: Initialization succeeded.\n");
	return( _SMT_OK );
}

/****************************************************************************
1.Function: SMT driver Output tranzaction

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_Output(_SMT_UNSIGNED_32BIT_INTEGER length,_SMT_UNSIGNED_32BIT_INTEGER *data)
{
	unsigned long i,flag;

	if( length==0 ){
		return( _SMT_OK );
	}
	flag = smt_disable_int();
	if( SDIO_output( *data, SD_SMT_CMD_HEAD )!=_SMT_OK ){
		smt_enable_int(flag);
		return( _SMT_NG );
	}
	data++;
	length--;
	for(i=0;i<length;i++){
		if( SDIO_output( *data, SD_SMT_CMD_DATA )!=_SMT_OK ){
			smt_enable_int(flag);
			return( _SMT_NG );
		}
		data++;
	}
	smt_enable_int(flag);
	return( _SMT_OK );
}

/****************************************************************************
1.Function: SMT driver End processing

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_Close(void)
{
	return( _SMT_OK );
}

/****************************************************************************
1.Function: Output SD CMD

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
static int SDIO_output(_SMT_UNSIGNED_32BIT_INTEGER data,const unsigned long attr)
{
	unsigned long	timeout;
	u32	cmd = 0;
	int	core_id = 0;
#ifdef CONFIG_SMP
	core_id = raw_smp_processor_id();
#endif
	cmd = sd_smt_cmd[core_id][attr];

	/* FROM sdhci_send_command() @ driver/mmc/host/sdhci.c */
	timeout = 10;
	while (ioread32(IO_ADDR(SDHCI_PRESENT_STATE)) & SDHCI_CMD_INHIBIT) {
		if (timeout == 0) {
			pr_err("smtModule: Controller never released inhibit bit.\n");
			return( _SMT_NG );
		}
		timeout--;
		mdelay(1);
	}

	/* set ARGUMENT register */
	iowrite32(data, IO_ADDR(SDHCI_ARGUMENT));

	/* set TRANSFER MODE register */
	iowrite16(0, IO_ADDR(SDHCI_TRANSFER_MODE));

	/* set COMMAND register */
	iowrite16(SDHCI_MAKE_CMD(cmd, 0), IO_ADDR(SDHCI_COMMAND));

	timeout = 10;
	while (1) {
		u32 status = ioread32(IO_ADDR(SDHCI_INT_STATUS));
		if (status & SDHCI_INT_RESPONSE) {
			/* Clear interrupt bits. (write to clear) */
			iowrite32(status, IO_ADDR(SDHCI_INT_STATUS));
			break;
		}
		if ((timeout == 0) || (status & SDHCI_INT_TIMEOUT)) {
			pr_err("smtModule: Command response timeout.\n");
			return( _SMT_NG );
		}
		timeout--;
	}

	return( _SMT_OK );
}


/****************************************************************************
1.Function: SMT driver Output tranzaction

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_Set(_SMT_UNSIGNED_32BIT_INTEGER length,_SMT_UNSIGNED_32BIT_INTEGER *data)
{
	unsigned long i;

	if( length==0 ){
		return( _SMT_OK );
	}
	if( SDIO_output( *data, SD_SMT_CMD_HEAD )!=_SMT_OK ){

		return( _SMT_NG );
	}
	data++;
	length--;
	for(i=0;i<length;i++){
		if( SDIO_output( *data, SD_SMT_CMD_DATA )!=_SMT_OK ){

			return( _SMT_NG );
		}
		data++;
	}
	return( _SMT_OK );
}
