/*****************************************************************************
 Copyright(c) 2010 DTS INSIGHT CORPORATION
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.

 Note:

 Modification history
 +-------------- Historical number (000 to 999)
 |    +--------- Modified System Version
 |    |     +--- Classification of New, Modify, Append, Delete
 v    v     v
 No  Ver  Class Date                Description
 ---+-----+----+------------+--------------------------------------------------
 000 01.00 New  2012/10/01      New
 001 01.10 Mod  2013/01/28      Fixed #13066 #13113 
 002 02.12 MOD  2014/12/12      Fixed #13672
 003 02.13 MOD  2015/03/12      Fixed SMTNEW-113
 004 03.10 Mod  2016/05/20      SMTNEW-288
*****************************************************************************/

/* Include specification ****************************************************/
#include <linux/module.h>
#include <linux/spinlock.h>
#include <linux/fs.h>
#include <linux/string.h>
#include <asm/io.h>

#include <smt/SMTAPI.h>
#include "SMTDef.h"
#include "smt.h"
#include "smtoutput.h"

#define REGISTER_API(api)		smt_set_##api(_SMT_##api##_core)
#define UNREGISTER_API(api)		smt_set_##api(NULL)

extern struct smt_device* smt_device;

/* Extern Function prototypes ******************************************************/
extern void smt_set_PortOut( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER addr,_SMT_UNSIGNED_32BIT_INTEGER data,_SMT_PSZ size,_SMT_PRW rw) );
extern void smt_set_Printf( int (*func)(int level,const char *format , ...) );
extern void smt_set_Puts( int (*func)(int level,const char *s) );
extern void smt_set_UsrMsgTag0( int (*func)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum ) );
extern void smt_set_UsrMsgTag1( int (*func)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1 ) );
extern void smt_set_UsrMsgTag2( int (*func)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2 ) );
extern void smt_set_UsrMsgTag3( int (*func)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3 ) );
extern void smt_set_UsrMsgTag4( int (*func)(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4 ) );
extern void smt_set_OsSwitch_Process( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER processid) );
extern void smt_set_OsSwitch_ThreadProcess( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid) );
extern void smt_set_OsSwitch_Process_Name( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER processid,const char *str) );
extern void smt_set_OsSwitch_ThreadProcess_Name( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid,const char *tname,const char *pname) );
extern void smt_set_OsSwitch_Irq_in( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER irqid) );
extern void smt_set_OsSwitch_Irq_out( int (*func)(_SMT_UNSIGNED_32BIT_INTEGER irqid) );
extern void smt_set_OsSwitch_Idle( int (*func)( void ) );

extern void smt_set_OsCall0( int (*func)(int osc,_SMT_OS_CALL attr) );
extern void smt_set_OsCall1( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1) );
extern void smt_set_OsCall2( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2) );
extern void smt_set_OsCall3( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3) );
extern void smt_set_OsCall4( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4) );
extern void smt_set_OsCall5( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5) );
extern void smt_set_OsCall6( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6) );
extern void smt_set_OsCall7( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7) );
extern void smt_set_OsCall8( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8) );
extern void smt_set_OsCall9( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9) );
extern void smt_set_OsCall10( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10) );
extern void smt_set_OsCall11( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11) );
extern void smt_set_OsCall12( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12) );
extern void smt_set_OsCall13( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13) );
extern void smt_set_OsCall14( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14) );
extern void smt_set_OsCall15( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15) );
extern void smt_set_OsCall16( int (*func)(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16) );
extern void smt_set_Hook0( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum) );
extern void smt_set_Hook1( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1) );
extern void smt_set_Hook2( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2) );
extern void smt_set_Hook3( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3) );
extern void smt_set_Hook4( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4) );
extern void smt_set_Hook5( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5) );
extern void smt_set_Hook6( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6) );
extern void smt_set_Hook7( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7) );
extern void smt_set_Hook8( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8) );
extern void smt_set_Hook9( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9) );
extern void smt_set_Hook10( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10) );
extern void smt_set_Hook11( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11) );
extern void smt_set_Hook12( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12) );
extern void smt_set_Hook13( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13) );
extern void smt_set_Hook14( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14) );
extern void smt_set_Hook15( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15) );
extern void smt_set_Hook16( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16) );

extern void smt_set_Hook0_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr) );
extern void smt_set_Hook1_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr) );
extern void smt_set_Hook2_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr2) );
extern void smt_set_Hook3_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr) );
extern void smt_set_Hook4_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr) );
extern void smt_set_Hook5_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr) );
extern void smt_set_Hook6_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr) );
extern void smt_set_Hook7_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr) );
extern void smt_set_Hook8_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr) );
extern void smt_set_Hook9_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr) );
extern void smt_set_Hook10_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr) );
extern void smt_set_Hook11_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr) );
extern void smt_set_Hook12_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr) );
extern void smt_set_Hook13_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr) );
extern void smt_set_Hook14_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr) );
extern void smt_set_Hook15_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr) );
extern void smt_set_Hook16_userland( void (*func)(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr) );

extern unsigned long smt_disable_int(void);
extern void smt_enable_int(unsigned long flag);
/* External variables *******************************************************/
extern bool osproc;
extern bool osirq;
extern bool oscall;


/* Function prototypes ******************************************************/
void smt_register_api(void);
void smt_unregister_api(void);
int  SMT_Putw(int level,const char *s);

/* Static Function prototypes ***********************************************/
static _SMT_UNSIGNED_32BIT_INTEGER smt_strlen(const char *s);
static void os_putw(const char *str,_SMT_UNSIGNED_32BIT_INTEGER len,_SMT_UNSIGNED_32BIT_INTEGER *out);
static void os_len_putw(const char *name,_SMT_UNSIGNED_32BIT_INTEGER len,_SMT_UNSIGNED_32BIT_INTEGER olen,_SMT_UNSIGNED_32BIT_INTEGER *out);
static _SMT_UNSIGNED_32BIT_INTEGER os_strlen(const char *s);


#define	_SMT_PORTOUT_DATA_SIZE				3				// PortOut output data size (_SMT_UNSIGNED_32BIT_INTEGER)
                                                            
#define	_SMT_USRMSGTAG_DATA_SIZE_0			1				// UsrMsgTag0 output data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_USRMSGTAG_DATA_SIZE_1			2				// UsrMsgTag1 output data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_USRMSGTAG_DATA_SIZE_2			3				// UsrMsgTag2 output data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_USRMSGTAG_DATA_SIZE_3			4				// UsrMsgTag3 output data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_USRMSGTAG_DATA_SIZE_4			5				// UsrMsgTag4 output data size(_SMT_UNSIGNED_32BIT_INTEGER)
                                                            
#define	_SMT_OS_SWITCH_DATA_SIZE_PROCESS	2				// Process data size(_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_SWITCH_DATA_SIZE_THREAD		3				// Thread data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_SWITCH_DATA_SIZE_IRQ_IN		2				// IRQ_IN data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_SWITCH_DATA_SIZE_IRQ_OUT	2				// IRQ_OUT datasize (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_SWITCH_DATA_SIZE_IDLE		1				// IDLE data size(_SMT_UNSIGNED_32BIT_INTEGER)
                                                            
#define	_SMT_OS_CALL_DATA_SIZE_0			1				// systemcall argument 0  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_CALL_DATA_SIZE_1			2				// systemcall argument 1  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_CALL_DATA_SIZE_2			3				// systemcall argument 2  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_CALL_DATA_SIZE_3			4				// systemcall argument 3  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_CALL_DATA_SIZE_4			5				// systemcall argument 4  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_CALL_DATA_SIZE_5			6				// systemcall argument 5  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_CALL_DATA_SIZE_6			7				// systemcall argument 6  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_CALL_DATA_SIZE_7			8				// systemcall argument 7  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_CALL_DATA_SIZE_8			9				// systemcall argument 8  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_CALL_DATA_SIZE_9			10				// systemcall argument 9  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_CALL_DATA_SIZE_10			11				// systemcall argument 10 data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_CALL_DATA_SIZE_11			12				// systemcall argument 11 data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_CALL_DATA_SIZE_12			13				// systemcall argument 12 data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_CALL_DATA_SIZE_13			14				// systemcall argument 13 data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_CALL_DATA_SIZE_14			15				// systemcall argument 14 data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_CALL_DATA_SIZE_15			16				// systemcall argument 15 data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_OS_CALL_DATA_SIZE_16			17				// systemcall argument 16 data size (_SMT_UNSIGNED_32BIT_INTEGER)
                                                            
#define	_SMT_HOOK_DATA_SIZE_0				1				// Hook0  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_1				2				// Hook1  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_2				4				// Hook2  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_3				5				// Hook3  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_4				6				// Hook4  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_5				7				// Hook5  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_6				8				// Hook6  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_7				9				// Hook7  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_8				10				// Hook8  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_9				11				// Hook9  data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_10				12				// Hook10 data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_11				13				// Hook11 data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_12				14				// Hook12 data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_13				15				// Hook13 data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_14				16				// Hook14 data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_15				17				// Hook15 data size (_SMT_UNSIGNED_32BIT_INTEGER)
#define	_SMT_HOOK_DATA_SIZE_16				18				// Hook16 data size (_SMT_UNSIGNED_32BIT_INTEGER)

/*****************************************************************************
1.Function: Output Address,Data,Size,Read/Write info

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/	addr						Address value
I/	data						Data value
I/	size						Port size 1:8bit 2:16bit 3:32bit
I/	rw							Access type 0:Write 1:Read

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_PortOut_core(_SMT_UNSIGNED_32BIT_INTEGER addr,_SMT_UNSIGNED_32BIT_INTEGER data,_SMT_PSZ size,_SMT_PRW rw)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_PORTOUT_DATA_SIZE] __attribute__ ((aligned(4)));

	out[0] = _SMT_ATR_PORTOUT | _SMT_OUT_SIZE_PORTOUT | ((rw & _SMT_MASK_PORTOUT_RW) << _SMT_PORTOUT_RW_POS) | (size & _SMT_MASK_PORTOUT_SIZE);
	out[1] = addr;
	out[2] = data;
	return( _SMT_Output(_SMT_PORTOUT_DATA_SIZE,out) );
}

/****************************************************************************
1.Function: equivalent to printf function

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/	level						Level of debug print output
I/	*format						Pointer for character string to specify the syntax
I/	arg							Output data in accordance with the syntax

4.Return Value:
	_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_Printf_core(int level,const char *format , ...)
{
	va_list	ap;
	char s[_SMT_STR_MAX_SIZE_B] __attribute__ ((aligned (4)));

	if ( _SMT_GetDebugLevel() & (1 <<level) ){
		return( _SMT_OK );
	}
	va_start(ap,format);
	vsnprintf(s,_SMT_STR_MAX_SIZE_B,format,ap);
	va_end(ap);
	return( SMT_Putw(level,s) );
}

/****************************************************************************
1.Function: Output String

2.Restriction, Cautions:

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/	level						Level of debug print output
I/	*s							Pointer for character string to output

4.Return Value:
	_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_Puts_core(int level,const char *s)
{
	if ( _SMT_GetDebugLevel() & (1 <<level) ){
		return( _SMT_OK );
	}
	return( SMT_Putw(level,s) );
}

/*****************************************************************************
1.Function:This function outputs the user defined message tag number 

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	level						Level of debug statement output
I/	TagNum						Message tag number 0 to 1023

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_UsrMsgTag0_core( int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum )
{
	_SMT_UNSIGNED_32BIT_INTEGER out;

	if ( _SMT_GetDebugLevel() & (1 <<level) ){
		return( _SMT_OK );
	}
	out = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_0 | _SMT_MSG_TAG_ON | ((level & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (TagNum & _SMT_MASK_MSGNO);
	return( _SMT_Output(_SMT_USRMSGTAG_DATA_SIZE_0,&out) );
}

/*****************************************************************************
1.Function:This function outputs the user defined message tag number

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	level						Level of debug statement output
I/	TagNum						Message tag number 0 to 1023
I/	arg1						Output data in accordance with the syntax

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_UsrMsgTag1_core(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1 )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));

	if ( _SMT_GetDebugLevel() & (1 <<level) ){
		return( _SMT_OK );
	}
	out[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | ((level & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (TagNum & _SMT_MASK_MSGNO);
	out[1] = arg1;
	return( _SMT_Output(_SMT_USRMSGTAG_DATA_SIZE_1,out) );
}

/*****************************************************************************
1.Function:This function outputs the user defined message tag number

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	level						Level of debug statement output
I/	TagNum						Message tag number 0 to 1023
I/	arg1						Output data in accordance with the syntax
I/	arg2						Output data in accordance with the syntax

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_UsrMsgTag2_core(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_USRMSGTAG_DATA_SIZE_2] __attribute__ ((aligned (4)));

	if ( _SMT_GetDebugLevel() & (1 <<level) ){
		return( _SMT_OK );
	}
	out[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_2 | _SMT_MSG_TAG_ON | ((level & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (TagNum & _SMT_MASK_MSGNO);
	out[1] = arg1;
	out[2] = arg2;
	return( _SMT_Output(_SMT_USRMSGTAG_DATA_SIZE_2,out) );
}

/*****************************************************************************
1.Function:This function outputs the user defined message tag number

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	level						Level of debug statement output
I/	TagNum						Message tag number 0 to 1023
I/	arg1						Output data in accordance with the syntax
I/	arg2						Output data in accordance with the syntax
I/	arg3						Output data in accordance with the syntax

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_UsrMsgTag3_core(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_USRMSGTAG_DATA_SIZE_3] __attribute__ ((aligned (4)));

	if ( _SMT_GetDebugLevel() & (1 <<level) ){
		return( _SMT_OK );
	}
	out[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_3 | _SMT_MSG_TAG_ON | ((level & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (TagNum & _SMT_MASK_MSGNO);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	return( _SMT_Output(_SMT_USRMSGTAG_DATA_SIZE_3,out) );
}

/*****************************************************************************
1.Function:This function outputs the user defined message tag number

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	level						Level of debug statement output
I/	TagNum						Message tag number 0 to 1023
I/	arg1						Output data in accordance with the syntax
I/	arg2						Output data in accordance with the syntax
I/	arg3						Output data in accordance with the syntax
I/	arg4						Output data in accordance with the syntax

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_UsrMsgTag4_core(int level,_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_USRMSGTAG_DATA_SIZE_4] __attribute__ ((aligned (4)));

	if ( _SMT_GetDebugLevel() & (1 <<level) ){
		return( _SMT_OK );
	}
	out[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_4 | _SMT_MSG_TAG_ON | ((level & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (TagNum & _SMT_MASK_MSGNO);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	return( _SMT_Output(_SMT_USRMSGTAG_DATA_SIZE_4,out) );
}

/*****************************************************************************
1.Function: Output one word to SMT_port

2.Restriction, Cautions:string length is 1WORD(4BYTE)

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/	level						Level of debug print output
I/	*s							Pointer for character string to output

4.Return Value:
	_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int SMT_Putw(int level,const char *s)
{
	union	U_DT {
		char	c[4];
		long	l;
	} dt;
	_SMT_UNSIGNED_32BIT_INTEGER len;
	_SMT_UNSIGNED_32BIT_INTEGER size_word = 0;
	_SMT_UNSIGNED_32BIT_INTEGER pos;
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_PUTW_BUF_SIZE_B/sizeof(_SMT_UNSIGNED_32BIT_INTEGER)] __attribute__ ((aligned (4)));


	len = smt_strlen(s);
	pos = 0;
	size_word = (len + ((sizeof(_SMT_UNSIGNED_32BIT_INTEGER)) - 1)) / (sizeof(_SMT_UNSIGNED_32BIT_INTEGER));
	out[pos]   = _SMT_ATR_PRINT | ((size_word) << _SMT_OUT_SIZE_POS) | ((level & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS);
	pos++;
	while(size_word-- > 1) {
		dt.c[0] = *s++;
		dt.c[1] = *s++;
		dt.c[2] = *s++;
		dt.c[3] = *s++;
		out[pos]= dt.l;
		pos++;
	}
	dt.c[0] = *s++;
	dt.c[1] = *s++;
	dt.c[2] = *s++;
	dt.c[3] = *s++;
	switch((len-1)%4) {
		case 0:
			((char*)&dt.c)[0] = '\0';
			((char*)&dt.c)[1] = '\0';
			((char*)&dt.c)[2] = '\0';
			((char*)&dt.c)[3] = '\0';
			break;
		case 1:
			((char*)&dt.c)[1] = '\0';
			((char*)&dt.c)[2] = '\0';
			((char*)&dt.c)[3] = '\0';
			break;
		case 2:
			((char*)&dt.c)[2] = '\0';
			((char*)&dt.c)[3] = '\0';
		    break;
		case 3:
		    ((char*)&dt.c)[3] = '\0';
		    break;
	}
	out[pos]= dt.l;
	pos++;
	return( _SMT_Output(pos,out) );
}

/*****************************************************************************
1.Function: Count number of characters

2.Restriction, Cautions: max string length is 124

3.Argument
I/O|Variable Name			   |Explanation
---+---------------------------+---------------------------------------------
I/	*s							Pointer for character string to output

4.Return Value:
	string length

*****************************************************************************/
static _SMT_UNSIGNED_32BIT_INTEGER smt_strlen(const char *s)
{
	_SMT_UNSIGNED_32BIT_INTEGER i=0;

	while (s[i] != '\0') {
		i++;
		if( i >= _SMT_STR_MAX_SIZE_B ){
			break;
		}
	}
	i++;
	if( i>_SMT_STR_MAX_SIZE_B ){
		i = _SMT_STR_MAX_SIZE_B;
	}
	return(i);
}

/*****************************************************************************
1.Function: OS switching (Process ID)

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	processid

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsSwitch_Process_core(_SMT_UNSIGNED_32BIT_INTEGER processid)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_SWITCH_DATA_SIZE_PROCESS] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_SWITCH | _SMT_OS_SWITCH_SIZE_PROCESS | _SMT_OS_SWITCH_PROCESS;
	out[1] = processid;
	return( _SMT_Output(_SMT_OS_SWITCH_DATA_SIZE_PROCESS,out) );
}

/*****************************************************************************
1.Function: OS switching (Thread ID & Process ID)

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	threadid					Thread ID
I/	processid					Process ID

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsSwitch_ThreadProcess_core(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_SWITCH_DATA_SIZE_THREAD] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_SWITCH | _SMT_OS_SWITCH_SIZE_THREAD | _SMT_OS_SWITCH_THREAD;
	out[1] = threadid;
	out[2] = processid;
	return( _SMT_Output(_SMT_OS_SWITCH_DATA_SIZE_THREAD,out) );
}

/*****************************************************************************
1.Function: OS switching (Prosess ID & Prosess Name)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	processid					Process ID
I/	str							Character string of process name (up to 56 characters including termination character)

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsSwitch_Process_Name_core(_SMT_UNSIGNED_32BIT_INTEGER processid,const char *str)
{
	_SMT_UNSIGNED_32BIT_INTEGER len,full;
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_SWITCH_DATA_SIZE_PROCESS + (_SMT_OS_SWITCH_NAME_MAX/sizeof(_SMT_UNSIGNED_32BIT_INTEGER))]  __attribute__ ((aligned (4)));

	len  = os_strlen( str );
	full = _SMT_OS_SWITCH_DATA_SIZE_PROCESS + ((len + sizeof(_SMT_UNSIGNED_32BIT_INTEGER)) / sizeof(_SMT_UNSIGNED_32BIT_INTEGER));
	out[0] = _SMT_ATR_OS_SWITCH | ((full-1) << _SMT_OUT_SIZE_POS) | _SMT_OS_SWITCH_PROCESS_NAME;
	out[1] = processid;
	os_putw((const char*)str,len,&out[2]);
	return( _SMT_Output(full,out) );
}

/*****************************************************************************
1.Function: OS switching  (Thread/Prosess ID & Thread/Prosess Name)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	threadid					Thread ID
I/	processid					Process ID
I/	tname						Character string of thread name (up to 56 characters including termination character)
I/	pname						Character string of process name (up to 56 characters including termination character)

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsSwitch_ThreadProcess_Name_core(_SMT_UNSIGNED_32BIT_INTEGER threadid,_SMT_UNSIGNED_32BIT_INTEGER processid,const char *tname,const char *pname)
{
	_SMT_UNSIGNED_32BIT_INTEGER tlen,plen,olen,full;
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_SWITCH_DATA_SIZE_THREAD + ((_SMT_OS_SWITCH_NAME_MAX/sizeof(_SMT_UNSIGNED_32BIT_INTEGER))*2)] __attribute__ ((aligned (4)));

	tlen  = os_strlen( tname );
	plen  = os_strlen( pname );
	if( tlen<plen ){
		olen = plen;
	}
	else{
		olen = tlen;
	}
	full = _SMT_OS_SWITCH_DATA_SIZE_THREAD + (((olen + sizeof(_SMT_UNSIGNED_32BIT_INTEGER)) / sizeof(_SMT_UNSIGNED_32BIT_INTEGER))*2);
	out[0] = _SMT_ATR_OS_SWITCH | ((full-1) << _SMT_OUT_SIZE_POS) | _SMT_OS_SWITCH_THREAD_NAME;
	out[1] = threadid;
	out[2] = processid;
	os_len_putw(tname,tlen,olen,&out[3]);
	os_len_putw(pname,plen,olen,&out[3+((olen+sizeof(_SMT_UNSIGNED_32BIT_INTEGER))/sizeof(_SMT_UNSIGNED_32BIT_INTEGER))]);
	return( _SMT_Output(full,out) );
}

/*****************************************************************************
1.Function: outputs the starting of interruption and interruption number


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	irqid						Interruption number

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsSwitch_Irq_in_core(_SMT_UNSIGNED_32BIT_INTEGER irqid)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_SWITCH_DATA_SIZE_IRQ_IN] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_SWITCH | _SMT_OS_SWITCH_SIZE_IRQ_IN | _SMT_OS_SWITCH_IRQ_IN;
	out[1] = irqid;
	return( _SMT_Output(_SMT_OS_SWITCH_DATA_SIZE_IRQ_IN,out) );
}

/*****************************************************************************
1.Function:  outputs the ending of interruption and interruption number.


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	irqid						Interruption number

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsSwitch_Irq_out_core(_SMT_UNSIGNED_32BIT_INTEGER irqid)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_SWITCH_DATA_SIZE_IRQ_OUT] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_SWITCH | _SMT_OS_SWITCH_SIZE_IRQ_IN | _SMT_OS_SWITCH_IRQ_OUT;
	out[1] = irqid;
	return( _SMT_Output(_SMT_OS_SWITCH_DATA_SIZE_IRQ_OUT,out) );
}

/*****************************************************************************
1.Function:  outputs a switch for idle process.

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------


4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsSwitch_Idle_core( void )
{
	_SMT_UNSIGNED_32BIT_INTEGER out;

	out = _SMT_ATR_OS_SWITCH |  _SMT_OS_SWITCH_IDLE;
	return( _SMT_Output(_SMT_OS_SWITCH_DATA_SIZE_IDLE,&out) );
}

/*****************************************************************************
1.Function:  outputs character


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	str							output character
I/	len							Number of character
I/	offset						SMT Port offset


4.Return Value:
*****************************************************************************/
static void os_putw(const char *str,_SMT_UNSIGNED_32BIT_INTEGER len,_SMT_UNSIGNED_32BIT_INTEGER *out)
{
	_SMT_UNSIGNED_32BIT_INTEGER i,acc;
	union	U_DT {
		unsigned  char	c[4];
		_SMT_UNSIGNED_32BIT_INTEGER	l;
	} dt;

	acc  = len / sizeof(_SMT_UNSIGNED_32BIT_INTEGER);
	for(i=0;i<acc;i++){
		dt.c[0]      	= *str++;
		dt.c[1]      	= *str++;
		dt.c[2]      	= *str++;
		dt.c[3]       	= *str++;
		*(out)			= dt.l;
		out++;
	}
	switch( len-acc*sizeof(_SMT_UNSIGNED_32BIT_INTEGER) ){
	case 0:
		*(out)			= 0x00000000UL;
		break;
	case 1:
		dt.l         	= 0x00000000UL;
		dt.c[0]      	= (*str);
		*(out)			= dt.l;
		break;
	case 2:
		dt.l         	= 0x00000000UL;
		dt.c[0]      	= *str++;
		dt.c[1]      	= *str++;
		*(out)			= dt.l;
		break;
	case 3:
		dt.l         	= 0x00000000UL;
		dt.c[0]     	= *str++;
		dt.c[1]     	= *str++;
		dt.c[2]     	= *str++;
		*(out)			= dt.l;
		break;
	}
}

/*****************************************************************************
1.Function:  outputs character  (null padding)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	str							output character
I/	len							Number of character
I/	olen						output length
I/	offset						SMT Port offset


4.Return Value:
*****************************************************************************/
static void os_len_putw(const char *str,_SMT_UNSIGNED_32BIT_INTEGER len,_SMT_UNSIGNED_32BIT_INTEGER olen,_SMT_UNSIGNED_32BIT_INTEGER *out)
{
	_SMT_UNSIGNED_32BIT_INTEGER i,less,next;

	os_putw(str,len,out);

	less = ((olen+sizeof(_SMT_UNSIGNED_32BIT_INTEGER))/sizeof(_SMT_UNSIGNED_32BIT_INTEGER))-((len+sizeof(_SMT_UNSIGNED_32BIT_INTEGER))/sizeof(_SMT_UNSIGNED_32BIT_INTEGER));
	next = (len+sizeof(_SMT_UNSIGNED_32BIT_INTEGER))/sizeof(_SMT_UNSIGNED_32BIT_INTEGER);
	for(i=0;i<less;i++){
		out[next] = 0x0UL;
	}
}

/*****************************************************************************
1.Function:  calculate character length 


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	str							output character

4.Return Value:
*****************************************************************************/
static _SMT_UNSIGNED_32BIT_INTEGER os_strlen(const char *s)
{
	_SMT_UNSIGNED_32BIT_INTEGER i;

	i=0;
	while( s[i]!='\0' ){
		i++;
		if( _SMT_OS_SWITCH_NAME_MAX<=i ){
			break;
		}
	}
	return( i );
}

/*****************************************************************************
1.Function:  outputs the system call number and calling attributes.

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsCall0_core(int osc,_SMT_OS_CALL attr)
{
	_SMT_UNSIGNED_32BIT_INTEGER out;

	out = _SMT_ATR_OS_CALL | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_0,&out) );
}

/*****************************************************************************
1.Function:  outputs the system call number and calling attributes,and 1 argument

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
I/	arg1						Argument 1
4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsCall1_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_1] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_1 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_1,out) );
}

/*****************************************************************************
1.Function:  outputs the system call number and calling attributes,and 2 argument

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
I/	arg1						Argument 1
I/	arg2						Argument 2

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsCall2_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_2] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_2 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_2,out) );
}

/*****************************************************************************
1.Function:  outputs the system call number and calling attributes,and 3 argument

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
I/	argN(1-3)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsCall3_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_3] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_3 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_3,out) );
}

/*****************************************************************************
1.Function:  outputs the system call number and calling attributes,and 4 argument

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
I/	argN(1-4)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsCall4_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_4] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_4 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_4,out) );
}

/*****************************************************************************
1.Function:  outputs the system call number and calling attributes,and 5 argument

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
I/	argN(1-5)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsCall5_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_5] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_5 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_5,out) );
}

/*****************************************************************************
1.Function:  outputs the system call number and calling attributes,and 6 argument

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
I/	argN(1-6)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsCall6_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_6] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_6 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_6,out) );
}

/*****************************************************************************
1.Function:  outputs the system call number and calling attributes,and 7 argument

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
I/	argN(1-7)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsCall7_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_7] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_7 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_7,out) );
}

/*****************************************************************************
1.Function:  outputs the system call number and calling attributes,and 8 argument

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
I/	argN(1-8)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsCall8_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_8] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_8 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	out[8] = arg8;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_8,out) );
}

/*****************************************************************************
1.Function:  outputs the system call number and calling attributes,and 9 argument

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
I/	argN(1-9)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsCall9_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_9] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_9 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	out[8] = arg8;
	out[9] = arg9;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_9,out) );
}

/*****************************************************************************
1.Function:  outputs the system call number and calling attributes,and 10 argument

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
I/	argN(1-10)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsCall10_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_10] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_10 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	out[8] = arg8;
	out[9] = arg9;
	out[10]= arg10;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_10,out) );
}

/*****************************************************************************
1.Function:  outputs the system call number and calling attributes,and 11 argument

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
I/	argN(1-11)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsCall11_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_11] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_11 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	out[8] = arg8;
	out[9] = arg9;
	out[10]= arg10;
	out[11]= arg11;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_11,out) );
}

/*****************************************************************************
1.Function:  outputs the system call number and calling attributes,and 12 argument

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
I/	argN(1-12)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsCall12_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_12] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_12 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	out[8] = arg8;
	out[9] = arg9;
	out[10]= arg10;
	out[11]= arg11;
	out[12]= arg12;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_12,out) );
}

/*****************************************************************************
1.Function:  outputs the system call number and calling attributes,and 13 argument

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
I/	argN(1-13)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsCall13_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_13] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_13 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	out[8] = arg8;
	out[9] = arg9;
	out[10]= arg10;
	out[11]= arg11;
	out[12]= arg12;
	out[13]= arg13;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_13,out) );
}

/*****************************************************************************
1.Function:  outputs the system call number and calling attributes,and 14 argument

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
I/	argN(1-14)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsCall14_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_14] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_14 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	out[8] = arg8;
	out[9] = arg9;
	out[10]= arg10;
	out[11]= arg11;
	out[12]= arg12;
	out[13]= arg13;
	out[14]= arg14;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_14,out) );
}

/*****************************************************************************
1.Function:  outputs the system call number and calling attributes,and 15 argument

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
I/	argN(1-15)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsCall15_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_15] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_15 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	out[8] = arg8;
	out[9] = arg9;
	out[10]= arg10;
	out[11]= arg11;
	out[12]= arg12;
	out[13]= arg13;
	out[14]= arg14;
	out[15]= arg15;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_15,out) );
}

/*****************************************************************************
1.Function:  outputs the system call number and calling attributes,and 16 argument

2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	osc							System Call number
I/	_SMT_OS_CALL				Attribute
									_SMT_OS_ATTR_CALL: Beginning of system call
									_SMT_OS_ATTR_RET: Ending of system call
I/	argN(1-16)						Argument N

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
int _SMT_OsCall16_core(int osc,_SMT_OS_CALL attr,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_OS_CALL_DATA_SIZE_16] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_OS_CALL | _SMT_OS_CALL_SIZE_16 | (osc & _SMT_OS_CALL_MASK_OSC) | ((attr & _SMT_OS_CALL_MASK_ATTR) << _SMT_OS_CALL_ATTR_POS);
	out[1] = arg1;
	out[2] = arg2;
	out[3] = arg3;
	out[4] = arg4;
	out[5] = arg5;
	out[6] = arg6;
	out[7] = arg7;
	out[8] = arg8;
	out[9] = arg9;
	out[10]= arg10;
	out[11]= arg11;
	out[12]= arg12;
	out[13]= arg13;
	out[14]= arg14;
	out[15]= arg15;
	out[16]= arg16;
	return( _SMT_Output(_SMT_OS_CALL_DATA_SIZE_16,out) );
}

/*****************************************************************************
1.Function:  Function in/out (no argument, no return value)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number

4.Return Value:
*****************************************************************************/
void _SMT_Hook0_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum)
{
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER out;
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;
	
	out = TagNum;

	sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
	sp_data[1] = _SMT_get_SP_address();
	saved = smt_disable_int();
	_SMT_Set(_SMT_HOOK_DATA_SIZE_0,&out);
	_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
	smt_enable_int(saved);

#else
	_SMT_UNSIGNED_32BIT_INTEGER out;
	out = TagNum;
	_SMT_Output(_SMT_HOOK_DATA_SIZE_0,&out);
#endif
}

/*****************************************************************************
1.Function:  Function in/out (one argument , return value)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	arg1						argument1, return value

4.Return Value:
*****************************************************************************/
void _SMT_Hook1_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1)
{
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_1] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;
	
	out[0] = TagNum;
	out[1] = arg1;

	sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
	sp_data[1] = _SMT_get_SP_address();
	saved = smt_disable_int();
	_SMT_Set(_SMT_HOOK_DATA_SIZE_1,out);
	_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
	smt_enable_int(saved);

#else
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_1] __attribute__ ((aligned (4)));

	out[0] = TagNum;
	out[1] = arg1;
	_SMT_Output(_SMT_HOOK_DATA_SIZE_1,out);

#endif
}

/*****************************************************************************
1.Function:  Function in  (2 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	arg1						argument1
I/	arg2						argument2

4.Return Value:
*****************************************************************************/
void _SMT_Hook2_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum ,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2 )
{
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_2] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;
	
	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_2;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;


	sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
	sp_data[1] = _SMT_get_SP_address();
	saved = smt_disable_int();
	_SMT_Set(_SMT_HOOK_DATA_SIZE_2,out);
	_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
	smt_enable_int(saved);

#else
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_2] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_2;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	_SMT_Output(_SMT_HOOK_DATA_SIZE_2,out);

#endif
}

/*****************************************************************************
1.Function:  Function in  (3 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-3)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook3_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3 )
{
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_3] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;
	
	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_3;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;

	sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
	sp_data[1] = _SMT_get_SP_address();
	saved = smt_disable_int();
	_SMT_Set(_SMT_HOOK_DATA_SIZE_3,out);
	_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
	smt_enable_int(saved);

#else
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_3] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_3;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	_SMT_Output(_SMT_HOOK_DATA_SIZE_3,out);

#endif
}

/*****************************************************************************
1.Function:  Function in  (4 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-4)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook4_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4 )
{
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_4] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;
	
	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_4;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;

	sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
	sp_data[1] = _SMT_get_SP_address();
	saved = smt_disable_int();
	_SMT_Set(_SMT_HOOK_DATA_SIZE_4,out);
	_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
	smt_enable_int(saved);

#else
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_4] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_4;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	_SMT_Output(_SMT_HOOK_DATA_SIZE_4,out);

#endif
}

/*****************************************************************************
1.Function:  Function in  (5 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-5)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook5_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5 )
{
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	unsigned long saved;
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_5] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	
	
	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_5;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;

	sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
	sp_data[1] = _SMT_get_SP_address();
	saved = smt_disable_int();
	_SMT_Set(_SMT_HOOK_DATA_SIZE_5,out);
	_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
	smt_enable_int(saved);

#else
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_5] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_5;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	_SMT_Output(_SMT_HOOK_DATA_SIZE_5,out);

#endif
}

/*****************************************************************************
1.Function:  Function in  (6 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-6)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook6_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6 )
{
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	unsigned long saved;
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_6] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	
	
	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_6;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;

	sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
	sp_data[1] = _SMT_get_SP_address();
	saved = smt_disable_int();
	_SMT_Set(_SMT_HOOK_DATA_SIZE_6,out);
	_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
	smt_enable_int(saved);

#else
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_6] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_6;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	_SMT_Output(_SMT_HOOK_DATA_SIZE_6,out);

#endif
}

/*****************************************************************************
1.Function:  Function in  (7 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-7)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook7_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7 )
{
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	unsigned long saved;
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_7] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));


	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_7;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;

	sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
	sp_data[1] = _SMT_get_SP_address();
	saved = smt_disable_int();
	_SMT_Set(_SMT_HOOK_DATA_SIZE_7,out);
	_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
	smt_enable_int(saved);

#else
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_7] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_7;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	_SMT_Output(_SMT_HOOK_DATA_SIZE_7,out);

#endif
}

/*****************************************************************************
1.Function:  Function in  (8 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-8)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook8_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8 )
{
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_8] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;
	
	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_8;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;

	sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
	sp_data[1] = _SMT_get_SP_address();
	saved = smt_disable_int();
	_SMT_Set(_SMT_HOOK_DATA_SIZE_8,out);
	_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
	smt_enable_int(saved);

#else
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_8] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_8;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	_SMT_Output(_SMT_HOOK_DATA_SIZE_8,out);

#endif
}

/*****************************************************************************
1.Function:  Function in  (9 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-9)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook9_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9 )
{
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_9] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;
	
	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_9;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;

	sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
	sp_data[1] = _SMT_get_SP_address();
	saved = smt_disable_int();
	_SMT_Set(_SMT_HOOK_DATA_SIZE_9,out);
	_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
	smt_enable_int(saved);

#else
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_9] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_9;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	_SMT_Output(_SMT_HOOK_DATA_SIZE_9,out);

#endif
}

/*****************************************************************************
1.Function:  Function in  (10 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-10)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook10_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10 )
{
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_10] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;
	
	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_10;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;

	sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
	sp_data[1] = _SMT_get_SP_address();
	saved = smt_disable_int();
	_SMT_Set(_SMT_HOOK_DATA_SIZE_10,out);
	_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
	smt_enable_int(saved);

#else
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_10] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_10;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	_SMT_Output(_SMT_HOOK_DATA_SIZE_10,out);

#endif
}

/*****************************************************************************
1.Function:  Function in  (11 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-11)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook11_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11 )
{
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_11] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;
	
	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_11;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;

	sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
	sp_data[1] = _SMT_get_SP_address();
	saved = smt_disable_int();
	_SMT_Set(_SMT_HOOK_DATA_SIZE_11,out);
	_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
	smt_enable_int(saved);

#else
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_11] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_11;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	_SMT_Output(_SMT_HOOK_DATA_SIZE_11,out);

#endif
}

/*****************************************************************************
1.Function:  Function in  (12 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-12)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook12_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12 )
{
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_12] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;
	
	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_12;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;

	sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
	sp_data[1] = _SMT_get_SP_address();
	saved = smt_disable_int();
	_SMT_Set(_SMT_HOOK_DATA_SIZE_12,out);
	_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
	smt_enable_int(saved);

#else
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_12] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_12;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	_SMT_Output(_SMT_HOOK_DATA_SIZE_12,out);

#endif
}

/*****************************************************************************
1.Function:  Function in  (13 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-13)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook13_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13 )
{
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_13] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;
	
	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_13;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;

	sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
	sp_data[1] = _SMT_get_SP_address();
	saved = smt_disable_int();
	_SMT_Set(_SMT_HOOK_DATA_SIZE_13,out);
	_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
	smt_enable_int(saved);

#else
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_13] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_13;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;
	_SMT_Output(_SMT_HOOK_DATA_SIZE_13,out);

#endif
}

/*****************************************************************************
1.Function:  Function in  (14 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-14)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook14_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14 )
{
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_14] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;
	
	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_14;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;
	out[15] = arg14;

	sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
	sp_data[1] = _SMT_get_SP_address();
	saved = smt_disable_int();
	_SMT_Set(_SMT_HOOK_DATA_SIZE_14,out);
	_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
	smt_enable_int(saved);

#else
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_14] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_14;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;
	out[15] = arg14;
	_SMT_Output(_SMT_HOOK_DATA_SIZE_14,out);

#endif
}

/*****************************************************************************
1.Function:  Function in  (15 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-15)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook15_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15 )
{
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_15] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;
	
	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_15;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;
	out[15] = arg14;
	out[16] = arg15;

	sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
	sp_data[1] = _SMT_get_SP_address();
	saved = smt_disable_int();
	_SMT_Set(_SMT_HOOK_DATA_SIZE_15,out);
	_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
	smt_enable_int(saved);

#else
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_15] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_15;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;
	out[15] = arg14;
	out[16] = arg15;
	_SMT_Output(_SMT_HOOK_DATA_SIZE_15,out);

#endif
}

/*****************************************************************************
1.Function:  Function in  (16 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-16)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook16_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16 )
{
#if _SMT_OUTPUT_SP_ADDR == _SMT_ON
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_16] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;
	
	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_16;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;
	out[15] = arg14;
	out[16] = arg15;
	out[17] = arg16;

	sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
	sp_data[1] = _SMT_get_SP_address();
	saved = smt_disable_int();
	_SMT_Set(_SMT_HOOK_DATA_SIZE_16,out);
	_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
	smt_enable_int(saved);

#else
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_16] __attribute__ ((aligned (4)));

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_16;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;
	out[15] = arg14;
	out[16] = arg15;
	out[17] = arg16;
	_SMT_Output(_SMT_HOOK_DATA_SIZE_16,out);

#endif
}

/*****************************************************************************
1.Function:  Function in/out (no argument, no return value)


	2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number

4.Return Value:
*****************************************************************************/
void _SMT_Hook0_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr)
{
	_SMT_UNSIGNED_32BIT_INTEGER out;
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] = {0};
	unsigned long saved;

	out = TagNum;

	if(output_sp_flg == _SMT_SP_OUTPUT_ENABLE){	
		sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
		sp_data[1] = sp_addr;
		saved = smt_disable_int();
		_SMT_Set(_SMT_HOOK_DATA_SIZE_0,&out);
		_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
		smt_enable_int(saved);
	} else {
		_SMT_Output(_SMT_HOOK_DATA_SIZE_0,&out);
	}

}


/*****************************************************************************
1.Function:  Function in/out (one argument , return value)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	arg1						argument1, return value

4.Return Value:
*****************************************************************************/
void _SMT_Hook1_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_1] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1];
	unsigned long saved;


	out[0] = TagNum;
	out[1] = arg1;

	if(output_sp_flg == _SMT_SP_OUTPUT_ENABLE){	
		sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
		sp_data[1] = sp_addr;
		saved = smt_disable_int();
		_SMT_Set(_SMT_HOOK_DATA_SIZE_1,out);
		_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
		smt_enable_int(saved);
	} else {
		_SMT_Output(_SMT_HOOK_DATA_SIZE_1,out);
	}
}

/*****************************************************************************
1.Function:  Function in  (2 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	arg1						argument1
I/	arg2						argument2

4.Return Value:
*****************************************************************************/
void _SMT_Hook2_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum ,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_2] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_2;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	
	if(output_sp_flg == _SMT_SP_OUTPUT_ENABLE){	
		sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
		sp_data[1] = sp_addr;
		saved = smt_disable_int();
		_SMT_Set(_SMT_HOOK_DATA_SIZE_2,out);
		_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
		smt_enable_int(saved);
	} else {
		_SMT_Output(_SMT_HOOK_DATA_SIZE_2,out);
	}
}

/*****************************************************************************
1.Function:  Function in  (3 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-3)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook3_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3 ,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_3] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_3;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;

	if(output_sp_flg == _SMT_SP_OUTPUT_ENABLE){	
		sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
		sp_data[1] = sp_addr;
		saved = smt_disable_int();
		_SMT_Set(_SMT_HOOK_DATA_SIZE_3,out);
		_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
		smt_enable_int(saved);
	} else {
		_SMT_Output(_SMT_HOOK_DATA_SIZE_3,out);
	}
}

/*****************************************************************************
1.Function:  Function in  (4 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-4)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook4_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_4] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_4;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;

	if(output_sp_flg == _SMT_SP_OUTPUT_ENABLE){	
		sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
		sp_data[1] = sp_addr;
		saved = smt_disable_int();
		_SMT_Set(_SMT_HOOK_DATA_SIZE_4,out);
		_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
		smt_enable_int(saved);
	} else {
		_SMT_Output(_SMT_HOOK_DATA_SIZE_4,out);
	}
}

/*****************************************************************************
1.Function:  Function in  (5 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-5)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook5_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_5] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_5;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;

	if(output_sp_flg == _SMT_SP_OUTPUT_ENABLE){	
		sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
		sp_data[1] = sp_addr;
		saved = smt_disable_int();
		_SMT_Set(_SMT_HOOK_DATA_SIZE_5,out);
		_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
		smt_enable_int(saved);
	} else {
		_SMT_Output(_SMT_HOOK_DATA_SIZE_5,out);
	}
}

/*****************************************************************************
1.Function:  Function in  (6 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-6)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook6_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_6] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_6;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;

	if(output_sp_flg == _SMT_SP_OUTPUT_ENABLE){	
		sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
		sp_data[1] = sp_addr;
		saved = smt_disable_int();
		_SMT_Set(_SMT_HOOK_DATA_SIZE_6,out);
		_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
		smt_enable_int(saved);
	} else {
		_SMT_Output(_SMT_HOOK_DATA_SIZE_6,out);
	}
}

/*****************************************************************************
1.Function:  Function in  (7 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-7)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook7_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_7] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_7;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;

	if(output_sp_flg == _SMT_SP_OUTPUT_ENABLE){	
		sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
		sp_data[1] = sp_addr;
		saved = smt_disable_int();
		_SMT_Set(_SMT_HOOK_DATA_SIZE_7,out);
		_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
		smt_enable_int(saved);
	} else {
		_SMT_Output(_SMT_HOOK_DATA_SIZE_7,out);
	}
}

/*****************************************************************************
1.Function:  Function in  (8 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-8)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook8_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8 ,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_8] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_8;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;

	if(output_sp_flg == _SMT_SP_OUTPUT_ENABLE){	
		sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
		sp_data[1] = sp_addr;
		saved = smt_disable_int();
		_SMT_Set(_SMT_HOOK_DATA_SIZE_8,out);
		_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
		smt_enable_int(saved);
	} else {
		_SMT_Output(_SMT_HOOK_DATA_SIZE_8,out);
	}
}

/*****************************************************************************
1.Function:  Function in  (9 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-9)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook9_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9 ,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_9] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_9;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;

	if(output_sp_flg == _SMT_SP_OUTPUT_ENABLE){	
		sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
		sp_data[1] = sp_addr;
		saved = smt_disable_int();
		_SMT_Set(_SMT_HOOK_DATA_SIZE_9,out);
		_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
		smt_enable_int(saved);
	} else {
		_SMT_Output(_SMT_HOOK_DATA_SIZE_9,out);
	}
}

/*****************************************************************************
1.Function:  Function in  (10 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-10)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook10_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10 ,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_10] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_10;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	if(output_sp_flg == _SMT_SP_OUTPUT_ENABLE){	
		sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
		sp_data[1] = sp_addr;
		saved = smt_disable_int();
		_SMT_Set(_SMT_HOOK_DATA_SIZE_10,out);
		_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
		smt_enable_int(saved);
	} else {
		_SMT_Output(_SMT_HOOK_DATA_SIZE_10,out);
	}
}

/*****************************************************************************
1.Function:  Function in  (11 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-11)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook11_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11 ,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_11] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_11;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;

	if(output_sp_flg == _SMT_SP_OUTPUT_ENABLE){	
		sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
		sp_data[1] = sp_addr;
		saved = smt_disable_int();
		_SMT_Set(_SMT_HOOK_DATA_SIZE_11,out);
		_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
		smt_enable_int(saved);
	} else {
		_SMT_Output(_SMT_HOOK_DATA_SIZE_11,out);
	}
}

/*****************************************************************************
1.Function:  Function in  (12 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-12)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook12_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_12] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_12;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	if(output_sp_flg == _SMT_SP_OUTPUT_ENABLE){	
		sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
		sp_data[1] = sp_addr;
		saved = smt_disable_int();
		_SMT_Set(_SMT_HOOK_DATA_SIZE_12,out);
		_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
		smt_enable_int(saved);
	} else {
		_SMT_Output(_SMT_HOOK_DATA_SIZE_12,out);
	}
}

/*****************************************************************************
1.Function:  Function in  (13 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-13)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook13_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_13] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_13;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;

	if(output_sp_flg == _SMT_SP_OUTPUT_ENABLE){	
		sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
		sp_data[1] = sp_addr;
		saved = smt_disable_int();
		_SMT_Set(_SMT_HOOK_DATA_SIZE_13,out);
		_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
		smt_enable_int(saved);
	} else {
		_SMT_Output(_SMT_HOOK_DATA_SIZE_13,out);
	}
}

/*****************************************************************************
1.Function:  Function in  (14 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-14)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook14_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_14] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_14;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;
	out[15] = arg14;

	if(output_sp_flg == _SMT_SP_OUTPUT_ENABLE){	
		sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
		sp_data[1] = sp_addr;
		saved = smt_disable_int();
		_SMT_Set(_SMT_HOOK_DATA_SIZE_14,out);
		_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
		smt_enable_int(saved);
	} else {
		_SMT_Output(_SMT_HOOK_DATA_SIZE_14,out);
	}

}

/*****************************************************************************
1.Function:  Function in  (15 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-15)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook15_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15 ,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr)
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_15] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_15;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;
	out[15] = arg14;
	out[16] = arg15;

	if(output_sp_flg == _SMT_SP_OUTPUT_ENABLE){	
		sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
		sp_data[1] = sp_addr;
		saved = smt_disable_int();
		_SMT_Set(_SMT_HOOK_DATA_SIZE_15,out);
		_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
		smt_enable_int(saved);
	} else {
		_SMT_Output(_SMT_HOOK_DATA_SIZE_15,out);
	}
}

/*****************************************************************************
1.Function:  Function in  (16 arguments)


2.Restriction, Cautions:

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------
I/	TagNum						function tag number
I/	argN(1-16)					argument N

4.Return Value:
*****************************************************************************/
void _SMT_Hook16_userland_core(_SMT_UNSIGNED_32BIT_INTEGER TagNum,_SMT_UNSIGNED_32BIT_INTEGER arg1,_SMT_UNSIGNED_32BIT_INTEGER arg2,_SMT_UNSIGNED_32BIT_INTEGER arg3,_SMT_UNSIGNED_32BIT_INTEGER arg4,_SMT_UNSIGNED_32BIT_INTEGER arg5,_SMT_UNSIGNED_32BIT_INTEGER arg6,_SMT_UNSIGNED_32BIT_INTEGER arg7,_SMT_UNSIGNED_32BIT_INTEGER arg8,_SMT_UNSIGNED_32BIT_INTEGER arg9,_SMT_UNSIGNED_32BIT_INTEGER arg10,_SMT_UNSIGNED_32BIT_INTEGER arg11,_SMT_UNSIGNED_32BIT_INTEGER arg12,_SMT_UNSIGNED_32BIT_INTEGER arg13,_SMT_UNSIGNED_32BIT_INTEGER arg14,_SMT_UNSIGNED_32BIT_INTEGER arg15,_SMT_UNSIGNED_32BIT_INTEGER arg16,int output_sp_flg,_SMT_UNSIGNED_32BIT_INTEGER sp_addr )
{
	_SMT_UNSIGNED_32BIT_INTEGER out[_SMT_HOOK_DATA_SIZE_16] __attribute__ ((aligned (4)));
	_SMT_UNSIGNED_32BIT_INTEGER sp_data[_SMT_USRMSGTAG_DATA_SIZE_1] __attribute__ ((aligned (4)));
	unsigned long saved;

	out[0] = _SMT_ATR_FUNC | _SMT_OUT_SIZE_HOOK_16;
	out[1] = TagNum;
	out[2] = arg1;
	out[3] = arg2;
	out[4] = arg3;
	out[5] = arg4;
	out[6] = arg5;
	out[7] = arg6;
	out[8] = arg7;
	out[9] = arg8;
	out[10] = arg9;
	out[11] = arg10;
	out[12] = arg11;
	out[13] = arg12;
	out[14] = arg13;
	out[15] = arg14;
	out[16] = arg15;
	out[17] = arg16;

	if(output_sp_flg == _SMT_SP_OUTPUT_ENABLE){	
		sp_data[0] = _SMT_ATR_PRINT | _SMT_OUT_SIZE_USRMSGTAG_1 | _SMT_MSG_TAG_ON | (((_SMT_UNSIGNED_32BIT_INTEGER)0 & _SMT_DBG_LV_MSK) << _SMT_DBG_LV_POS) | (0xFFFC & _SMT_MASK_MSGNO);
		sp_data[1] = sp_addr;
		saved = smt_disable_int();
		_SMT_Set(_SMT_HOOK_DATA_SIZE_16,out);
		_SMT_Set(_SMT_USRMSGTAG_DATA_SIZE_1,sp_data);
		smt_enable_int(saved);
	} else {
		_SMT_Output(_SMT_HOOK_DATA_SIZE_16,out);
	}
}


/*****************************************************************************
1.Function: SMT Kernel land API library registry

2.Restriction, Cautions: enable SMT port access
                         During this function processing  is Preemption and Interrupt dsable
                         

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
void smt_register_api(void)
{
	REGISTER_API(Puts);
	REGISTER_API(Printf);
	REGISTER_API(UsrMsgTag0);
	REGISTER_API(UsrMsgTag1);
	REGISTER_API(UsrMsgTag2);
	REGISTER_API(UsrMsgTag3);
	REGISTER_API(UsrMsgTag4);
	REGISTER_API(PortOut);
	REGISTER_API(Hook0);
	REGISTER_API(Hook1);
	REGISTER_API(Hook2);
	REGISTER_API(Hook3);
	REGISTER_API(Hook4);
	REGISTER_API(Hook5);
	REGISTER_API(Hook6);
	REGISTER_API(Hook7);
	REGISTER_API(Hook8);
	REGISTER_API(Hook9);
	REGISTER_API(Hook10);
	REGISTER_API(Hook11);
	REGISTER_API(Hook12);
	REGISTER_API(Hook13);
	REGISTER_API(Hook14);
	REGISTER_API(Hook15);
	REGISTER_API(Hook16);
	REGISTER_API(Hook0_userland);
	REGISTER_API(Hook1_userland);
	REGISTER_API(Hook2_userland);
	REGISTER_API(Hook3_userland);
	REGISTER_API(Hook4_userland);
	REGISTER_API(Hook5_userland);
	REGISTER_API(Hook6_userland);
	REGISTER_API(Hook7_userland);
	REGISTER_API(Hook8_userland);
	REGISTER_API(Hook9_userland);
	REGISTER_API(Hook10_userland);
	REGISTER_API(Hook11_userland);
	REGISTER_API(Hook12_userland);
	REGISTER_API(Hook13_userland);
	REGISTER_API(Hook14_userland);
	REGISTER_API(Hook15_userland);
	REGISTER_API(Hook16_userland);
	if( osproc ){
		REGISTER_API(OsSwitch_Process);
		REGISTER_API(OsSwitch_ThreadProcess);
		REGISTER_API(OsSwitch_Process_Name);
		REGISTER_API(OsSwitch_ThreadProcess_Name);
		REGISTER_API(OsSwitch_Idle);
	}
	if( osirq ){
		REGISTER_API(OsSwitch_Irq_in);
		REGISTER_API(OsSwitch_Irq_out);
	}
	if( oscall ){
		REGISTER_API(OsCall0);
		REGISTER_API(OsCall1);
		REGISTER_API(OsCall2);
		REGISTER_API(OsCall3);
		REGISTER_API(OsCall4);
		REGISTER_API(OsCall5);
		REGISTER_API(OsCall6);
		REGISTER_API(OsCall7);
		REGISTER_API(OsCall8);
		REGISTER_API(OsCall9);
		REGISTER_API(OsCall10);
		REGISTER_API(OsCall11);
		REGISTER_API(OsCall12);
		REGISTER_API(OsCall13);
		REGISTER_API(OsCall14);
		REGISTER_API(OsCall15);
		REGISTER_API(OsCall16);
	}
}

/*****************************************************************************
1.Function: SMT Kernel land API library unregistry

2.Restriction, Cautions: disable SMT port access

3.Argument:
I/O|Variable Name			   |Explanation
---+---------------------------+----------------------------------------------

4.Return Value:
			_SMT_OK:Normal end / _SMT_NG:Unuseal end
*****************************************************************************/
void smt_unregister_api(void)
{
	UNREGISTER_API(Puts);
	UNREGISTER_API(Printf);
	UNREGISTER_API(UsrMsgTag0);
	UNREGISTER_API(UsrMsgTag1);
	UNREGISTER_API(UsrMsgTag2);
	UNREGISTER_API(UsrMsgTag3);
	UNREGISTER_API(UsrMsgTag4);
	UNREGISTER_API(PortOut);
	UNREGISTER_API(Hook0);
	UNREGISTER_API(Hook1);
	UNREGISTER_API(Hook2);
	UNREGISTER_API(Hook3);
	UNREGISTER_API(Hook4);
	UNREGISTER_API(Hook5);
	UNREGISTER_API(Hook6);
	UNREGISTER_API(Hook7);
	UNREGISTER_API(Hook8);
	UNREGISTER_API(Hook9);
	UNREGISTER_API(Hook10);
	UNREGISTER_API(Hook11);
	UNREGISTER_API(Hook12);
	UNREGISTER_API(Hook13);
	UNREGISTER_API(Hook14);
	UNREGISTER_API(Hook15);
	UNREGISTER_API(Hook16);

	UNREGISTER_API(Hook0_userland);
	UNREGISTER_API(Hook1_userland);
	UNREGISTER_API(Hook2_userland);
	UNREGISTER_API(Hook3_userland);
	UNREGISTER_API(Hook4_userland);
	UNREGISTER_API(Hook5_userland);
	UNREGISTER_API(Hook6_userland);
	UNREGISTER_API(Hook7_userland);
	UNREGISTER_API(Hook8_userland);
	UNREGISTER_API(Hook9_userland);
	UNREGISTER_API(Hook10_userland);
	UNREGISTER_API(Hook11_userland);
	UNREGISTER_API(Hook12_userland);
	UNREGISTER_API(Hook13_userland);
	UNREGISTER_API(Hook14_userland);
	UNREGISTER_API(Hook15_userland);
	UNREGISTER_API(Hook16_userland);

	UNREGISTER_API(OsSwitch_Process);
	UNREGISTER_API(OsSwitch_ThreadProcess);
	UNREGISTER_API(OsSwitch_Process_Name);
	UNREGISTER_API(OsSwitch_ThreadProcess_Name);
	UNREGISTER_API(OsSwitch_Idle);
	UNREGISTER_API(OsSwitch_Irq_in);
	UNREGISTER_API(OsSwitch_Irq_out);
	UNREGISTER_API(OsCall0);
	UNREGISTER_API(OsCall1);
	UNREGISTER_API(OsCall2);
	UNREGISTER_API(OsCall3);
	UNREGISTER_API(OsCall4);
	UNREGISTER_API(OsCall5);
	UNREGISTER_API(OsCall6);
	UNREGISTER_API(OsCall7);
	UNREGISTER_API(OsCall8);
	UNREGISTER_API(OsCall9);
	UNREGISTER_API(OsCall10);
	UNREGISTER_API(OsCall11);
	UNREGISTER_API(OsCall12);
	UNREGISTER_API(OsCall13);
	UNREGISTER_API(OsCall14);
	UNREGISTER_API(OsCall15);
	UNREGISTER_API(OsCall16);
}
